/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.ResultReceiver;
import android.text.BoringLayout;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.Selection;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.TextView;
import com.android.internal.widget.EditableInputConnection;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebTextView
extends AutoCompleteTextView
implements AdapterView.OnItemClickListener {
    public static final String LOGTAG = "webtextview";
    public WebView mWebView;
    public boolean mSingle;
    public int mWidthSpec;
    public int mHeightSpec;
    public int mNodePointer;
    public boolean mGotEnterDown;
    public int mMaxLength;
    public String mPreChange;
    public Drawable mBackground;
    public float mDragStartX;
    public float mDragStartY;
    public long mDragStartTime;
    public boolean mDragSent;
    public boolean mScrolled;
    public boolean mFromWebKit;
    public boolean mFromFocusChange;
    public boolean mFromSetInputType;
    public boolean mGotTouchDown;
    public boolean mHasPerformedLongClick;
    public boolean mInSetTextAndKeepSelection;
    public char[] mCharacter = new char[1];
    public static final InputFilter[] NO_FILTERS = new InputFilter[0];
    public boolean mGotDelete;
    public int mDelSelStart;
    public int mDelSelEnd;
    public static final int FORM_NOT_AUTOFILLABLE = -1;
    public boolean mAutoFillable;
    public int mQueryId;
    public boolean mAutoFillProfileIsSet;
    public boolean mInsideRemove;
    public MyResultReceiver mReceiver;
    public static final int NORMAL_TEXT_FIELD = 0;
    public static final int TEXT_AREA = 1;
    public static final int PASSWORD = 2;
    public static final int SEARCH = 3;
    public static final int EMAIL = 4;
    public static final int NUMBER = 5;
    public static final int TELEPHONE = 6;
    public static final int URL = 7;
    public static final int AUTOFILL_FORM = 100;
    public Handler mHandler;

    public WebTextView(Context context, WebView webView, int autoFillQueryId) {
        super(context, null, 16843449);
        this.mWebView = webView;
        this.mMaxLength = -1;
        this.setAutoFillable(autoFillQueryId);
        TextPaint paint = this.getPaint();
        int flags = paint.getFlags() & 0xFFFFFEFF | 0x80 | 4;
        paint.setFlags(flags);
        this.setTextColor(-16777216);
        this.setIncludeFontPadding(false);
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 100: {
                        WebTextView.this.mWebView.autoFillForm(WebTextView.this.mQueryId);
                    }
                }
            }
        };
        this.mReceiver = new MyResultReceiver(this.mHandler);
    }

    public void setAutoFillable(int queryId) {
        this.mAutoFillable = this.mWebView.getSettings().getAutoFillEnabled() && queryId != -1;
        this.mQueryId = queryId;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.isSystem()) {
            return super.dispatchKeyEvent(event);
        }
        boolean down = event.getAction() != 1;
        int keyCode = event.getKeyCode();
        boolean isArrowKey = false;
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                isArrowKey = true;
            }
        }
        if (61 == keyCode) {
            if (down) {
                this.onEditorAction(5);
            }
            return true;
        }
        Editable text = this.getText();
        int oldStart = Selection.getSelectionStart(text);
        int oldEnd = Selection.getSelectionEnd(text);
        if (67 == keyCode) {
            if (oldStart == 0 && oldEnd == 0) {
                this.sendDomEvent(event);
                return true;
            }
            if (down) {
                this.mGotDelete = true;
                this.mDelSelStart = oldStart;
                this.mDelSelEnd = oldEnd;
            }
        }
        if (this.mSingle && (66 == keyCode || 160 == keyCode)) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(event);
            }
            if (!down) {
                InputMethodManager.getInstance(this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
                this.sendDomEvent(new KeyEvent(0, keyCode));
                this.sendDomEvent(event);
            }
            return super.dispatchKeyEvent(event);
        }
        if (23 == keyCode) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(event);
            }
            if (!down) {
                this.mWebView.centerKeyPressOnTextField();
            }
            return super.dispatchKeyEvent(event);
        }
        if (this.getLayout() == null) {
            this.measure(this.mWidthSpec, this.mHeightSpec);
        }
        int oldLength = text.length();
        boolean maxedOut = this.mMaxLength != -1 && oldLength == this.mMaxLength;
        String oldText = maxedOut && oldEnd != oldStart ? text.toString() : "";
        if (super.dispatchKeyEvent(event)) {
            if (66 == keyCode || 160 == keyCode) {
                this.mGotEnterDown = true;
            }
            if (maxedOut && !isArrowKey && keyCode != 67) {
                if (oldEnd == oldStart) {
                    return true;
                }
                if (!oldText.equals(this.getText().toString())) {
                    Editable span = this.getText();
                    int newStart = Selection.getSelectionStart(span);
                    int newEnd = Selection.getSelectionEnd(span);
                    this.mWebView.replaceTextfieldText(0, oldLength, span.toString(), newStart, newEnd);
                    return true;
                }
            }
            return true;
        }
        if (this.mGotEnterDown && !down) {
            return true;
        }
        if (isArrowKey) {
            this.mWebView.resetTrackballTime();
            return down ? this.mWebView.onKeyDown(keyCode, event) : this.mWebView.onKeyUp(keyCode, event);
        }
        return false;
    }

    public void ensureLayout() {
        if (this.getLayout() == null) {
            this.measure(this.mWidthSpec, this.mHeightSpec);
            AbsoluteLayout.LayoutParams params = (AbsoluteLayout.LayoutParams)this.getLayoutParams();
            if (params != null) {
                this.layout(params.x, params.y, params.x + params.width, params.y + params.height);
            }
        }
    }

    public ResultReceiver getResultReceiver() {
        return this.mReceiver;
    }

    public boolean isSameTextField(int ptr) {
        return ptr == this.mNodePointer;
    }

    public void lineUpScroll() {
        Layout layout2 = this.getLayout();
        if (this.mWebView != null && layout2 != null) {
            if (this.mSingle) {
                float maxScrollX = layout2.getLineRight(0) - (float)this.getWidth();
                this.mWebView.scrollFocusedTextInputX(maxScrollX > 0.0f ? (float)this.mScrollX / maxScrollX : 0.0f);
            } else {
                this.mWebView.scrollFocusedTextInputY(this.mScrollY);
            }
        }
    }

    @Override
    public void makeNewLayout(int w, int hintWidth, BoringLayout.Metrics boring, BoringLayout.Metrics hintBoring, int ellipsisWidth, boolean bringIntoView) {
        super.makeNewLayout(w, hintWidth, boring, hintBoring, ellipsisWidth, bringIntoView);
        if (this.willNotDraw()) {
            float height;
            float lineHeight = -1.0f;
            if (this.mWebView != null && (height = (float)this.mWebView.nativeFocusCandidateLineHeight()) != -1.0f) {
                lineHeight = height * this.mWebView.getScale();
            }
            Editable text = this.getText();
            this.mLayout = new WebTextViewLayout(text, text, this.getPaint(), this.mLayout.getWidth(), this.mLayout.getAlignment(), this.mLayout.getSpacingMultiplier(), this.mLayout.getSpacingAdd(), false, null, ellipsisWidth, lineHeight);
        }
        this.lineUpScroll();
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        InputConnection connection = super.onCreateInputConnection(outAttrs);
        if (this.mWebView != null) {
            outAttrs.fieldName = this.mWebView.nativeFocusCandidateName() + "\\" + this.mWebView.getUrl();
        }
        return connection;
    }

    public void onDrawSubstitute() {
        if (!this.willNotDraw()) {
            return;
        }
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (imm != null && imm.isActive(this)) {
            Editable sp = this.getText();
            int selStart = Selection.getSelectionStart(sp);
            int selEnd = Selection.getSelectionEnd(sp);
            int candStart = EditableInputConnection.getComposingSpanStart(sp);
            int candEnd = EditableInputConnection.getComposingSpanEnd(sp);
            imm.updateSelection(this, selStart, selEnd, candStart, candEnd);
        }
        this.updateCursorControllerPositions();
    }

    @Override
    public void onDraw(Canvas canvas) {
        if (this.mWebView == null || !this.mWebView.nativeFocusCandidateIsPassword() || !this.isSameTextField(this.mWebView.nativeFocusCandidatePointer())) {
            this.setInPassword(false);
        } else {
            super.onDraw(canvas);
        }
    }

    @Override
    public void onEditorAction(int actionCode) {
        switch (actionCode) {
            case 5: {
                if (!this.mWebView.nativeMoveCursorToNextTextInput()) break;
                this.mWebView.rebuildWebTextView();
                this.setDefaultSelection();
                this.mWebView.invalidate();
                break;
            }
            case 6: {
                super.onEditorAction(actionCode);
                break;
            }
            case 2: 
            case 3: {
                InputMethodManager.getInstance(this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
                this.sendDomEvent(new KeyEvent(0, 66));
                this.sendDomEvent(new KeyEvent(1, 66));
            }
        }
    }

    @Override
    public void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        this.mFromFocusChange = true;
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.mWebView.setActive(true);
        } else if (!this.mInsideRemove) {
            this.mWebView.setActive(false);
        }
        this.mFromFocusChange = false;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (id2 == 0L && position == 0) {
            this.replaceText("");
            WebSettings settings = this.mWebView.getSettings();
            if (this.mAutoFillProfileIsSet) {
                this.mWebView.autoFillForm(this.mQueryId);
            } else {
                this.mWebView.getWebChromeClient().setupAutoFill(this.mHandler.obtainMessage(100));
            }
        }
    }

    @Override
    public void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.lineUpScroll();
    }

    @Override
    public void onSelectionChanged(int selStart, int selEnd) {
        if (!(this.mFromWebKit || this.mFromFocusChange || this.mFromSetInputType || this.mWebView == null || this.mInSetTextAndKeepSelection)) {
            this.mWebView.setSelection(selStart, selEnd);
            this.lineUpScroll();
        }
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        int charactersFromKeyEvents;
        super.onTextChanged(s, start, before, count);
        String postChange = ((Object)s).toString();
        if (this.mPreChange == null || this.mPreChange.equals(postChange) || this.mMaxLength > -1 && this.mPreChange.length() > this.mMaxLength && this.mPreChange.substring(0, this.mMaxLength).equals(postChange)) {
            return;
        }
        this.mPreChange = postChange;
        if (0 == count) {
            if (before > 0) {
                this.updateCachedTextfield();
                if (this.mGotDelete) {
                    this.mGotDelete = false;
                    int oldEnd = start + before;
                    if (this.mDelSelEnd == oldEnd && (this.mDelSelStart == start || this.mDelSelStart == oldEnd && before == 1)) {
                        this.sendDomEvent(new KeyEvent(0, 67));
                        this.sendDomEvent(new KeyEvent(1, 67));
                        return;
                    }
                }
                this.mWebView.deleteSelection(start, start + before);
            }
            this.mGotDelete = false;
            return;
        }
        this.mGotDelete = false;
        TextUtils.getChars(s, start + count - 1, start + count, this.mCharacter, 0);
        KeyCharacterMap kmap = KeyCharacterMap.load(-1);
        KeyEvent[] events = kmap.getEvents(this.mCharacter);
        boolean cannotUseKeyEvents = null == events;
        int n = charactersFromKeyEvents = cannotUseKeyEvents ? 0 : 1;
        if (count > 1 || cannotUseKeyEvents) {
            String replace = ((Object)s.subSequence(start, start + count - charactersFromKeyEvents)).toString();
            this.mWebView.replaceTextfieldText(start, start + before, replace, start + count - charactersFromKeyEvents, start + count - charactersFromKeyEvents);
        } else if (!this.mInSetTextAndKeepSelection) {
            this.mWebView.setSelection(start, start + before);
        }
        if (!cannotUseKeyEvents) {
            int length = events.length;
            for (int i = 0; i < length; ++i) {
                if (KeyEvent.isModifierKey(events[i].getKeyCode())) continue;
                this.sendDomEvent(events[i]);
            }
        }
        this.updateCachedTextfield();
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                super.onTouchEvent(event);
                this.mDragStartX = event.getX();
                this.mDragStartY = event.getY();
                this.mDragStartTime = event.getEventTime();
                this.mDragSent = false;
                this.mScrolled = false;
                this.mGotTouchDown = true;
                this.mHasPerformedLongClick = false;
                break;
            }
            case 2: {
                if (this.mHasPerformedLongClick) {
                    this.mGotTouchDown = false;
                    return false;
                }
                int slop = ViewConfiguration.get(this.mContext).getScaledTouchSlop();
                Editable buffer = this.getText();
                int initialScrollX = Touch.getInitialScrollX(this, buffer);
                int initialScrollY = Touch.getInitialScrollY(this, buffer);
                super.onTouchEvent(event);
                int dx = Math.abs(this.mScrollX - initialScrollX);
                int dy = Math.abs(this.mScrollY - initialScrollY);
                int smallerSlop = slop / 2;
                if (dx > smallerSlop || dy > smallerSlop) {
                    this.mScrolled = true;
                    this.cancelLongPress();
                    return true;
                }
                if (Math.abs((float)((int)event.getX()) - this.mDragStartX) < (float)slop && Math.abs((float)((int)event.getY()) - this.mDragStartY) < (float)slop) {
                    return true;
                }
                if (this.mWebView != null) {
                    boolean scrolled;
                    if (!this.mDragSent) {
                        this.mWebView.initiateTextFieldDrag(this.mDragStartX, this.mDragStartY, this.mDragStartTime);
                        this.mDragSent = true;
                    }
                    if (scrolled = this.mWebView.textFieldDrag(event)) {
                        this.mScrolled = true;
                        this.cancelLongPress();
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 3: {
                super.onTouchEvent(event);
                if (this.mHasPerformedLongClick) {
                    this.mGotTouchDown = false;
                    return false;
                }
                if (!this.mScrolled) {
                    this.cancelLongPress();
                    if (this.mGotTouchDown && this.mWebView != null) {
                        this.mWebView.touchUpOnTextField(event);
                    }
                }
                if (this.mWebView != null && this.mDragSent) {
                    this.mWebView.onTouchEvent(event);
                }
                this.mGotTouchDown = false;
                break;
            }
        }
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event) {
        if (this.isPopupShowing()) {
            return super.onTrackballEvent(event);
        }
        if (event.getAction() != 2) {
            return false;
        }
        Editable text = this.getText();
        MovementMethod move = this.getMovementMethod();
        return move != null && this.getLayout() != null && move.onTrackballEvent(this, text, event);
    }

    @Override
    public boolean performLongClick() {
        this.mHasPerformedLongClick = true;
        return super.performLongClick();
    }

    public void remove() {
        InputMethodManager imm = InputMethodManager.getInstance(this.mContext);
        if (imm.isActive(this)) {
            imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
        this.mInsideRemove = true;
        this.mWebView.removeView(this);
        this.mWebView.requestFocus();
        this.mInsideRemove = false;
    }

    @Override
    public boolean requestRectangleOnScreen(Rect rectangle, boolean immediate) {
        return true;
    }

    public void sendDomEvent(KeyEvent event) {
        this.mWebView.passToJavaScript(this.getText().toString(), event);
    }

    public void setAdapterCustom(AutoCompleteAdapter adapter) {
        if (adapter != null) {
            this.setInputType(this.getInputType() | 0x10000);
            adapter.setTextView(this);
            if (this.mAutoFillable) {
                this.setOnItemClickListener(this);
            } else {
                this.setOnItemClickListener(null);
            }
            this.showDropDown();
        } else {
            this.dismissDropDown();
        }
        super.setAdapter(adapter);
    }

    public void setDefaultSelection() {
        int selection;
        Editable text = this.getText();
        int n = selection = this.mSingle ? text.length() : 0;
        if (Selection.getSelectionStart(text) == selection && Selection.getSelectionEnd(text) == selection) {
            if (this.mWebView != null) {
                this.mWebView.setSelection(selection, selection);
            }
        } else {
            Selection.setSelection(text, selection, selection);
        }
        if (this.mWebView != null) {
            this.mWebView.incrementTextGeneration();
        }
    }

    public void setInPassword(boolean inPassword) {
        if (inPassword) {
            this.setInputType(225);
            this.createBackground();
        }
        this.setWillNotDraw(!inPassword);
        this.setBackgroundDrawable(inPassword ? this.mBackground : null);
    }

    public void createBackground() {
        if (this.mBackground != null) {
            return;
        }
        this.mBackground = new OutlineDrawable();
        this.setGravity(16);
    }

    @Override
    public void setInputType(int type) {
        this.mFromSetInputType = true;
        super.setInputType(type);
        this.mFromSetInputType = false;
    }

    public void setMaxLength(int maxLength) {
        this.mMaxLength = maxLength;
        if (-1 == maxLength) {
            this.setFilters(NO_FILTERS);
        } else {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        }
    }

    public void setNodePointer(int ptr) {
        this.mNodePointer = ptr;
    }

    public void setRect(int x, int y, int width, int height) {
        AbsoluteLayout.LayoutParams lp = (AbsoluteLayout.LayoutParams)this.getLayoutParams();
        if (null == lp) {
            lp = new AbsoluteLayout.LayoutParams(width, height, x, y);
        } else {
            lp.x = x;
            lp.y = y;
            lp.width = width;
            lp.height = height;
        }
        if (this.getParent() == null) {
            this.mWebView.addView(this, lp);
        } else {
            this.setLayoutParams(lp);
        }
        this.mWidthSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        this.mHeightSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
    }

    public void setSelectionFromWebKit(int start, int end) {
        if (start < 0 || end < 0) {
            return;
        }
        Editable text = this.getText();
        int length = text.length();
        if (start > length || end > length) {
            return;
        }
        this.mFromWebKit = true;
        Selection.setSelection(text, start, end);
        this.mFromWebKit = false;
    }

    public void updateTextSize() {
        Assert.assertNotNull((String)"updateTextSize should only be called from mWebView, so mWebView should never be null!", (Object)this.mWebView);
        float size = this.mWebView.nativeFocusCandidateTextSize() * this.mWebView.getScale();
        this.setTextSize(0, size);
    }

    public void setTextAndKeepSelection(String text) {
        this.mPreChange = text.toString();
        Editable edit = this.getText();
        int selStart = Selection.getSelectionStart(edit);
        int selEnd = Selection.getSelectionEnd(edit);
        this.mInSetTextAndKeepSelection = true;
        edit.replace(0, edit.length(), text);
        int newLength = edit.length();
        if (selStart > newLength) {
            selStart = newLength;
        }
        if (selEnd > newLength) {
            selEnd = newLength;
        }
        Selection.setSelection(edit, selStart, selEnd);
        this.mInSetTextAndKeepSelection = false;
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (imm != null && imm.isActive(this)) {
            imm.restartInput(this);
        }
        this.updateCachedTextfield();
    }

    public void setType(int type) {
        if (this.mWebView == null) {
            return;
        }
        boolean single = true;
        boolean inPassword = false;
        int maxLength = -1;
        int inputType = 161;
        int imeOptions = 0x12000000;
        if (1 != type && this.mWebView.nativeFocusCandidateHasNextTextfield()) {
            imeOptions |= 0x8000000;
        }
        switch (type) {
            case 0: {
                imeOptions |= 2;
                break;
            }
            case 1: {
                single = false;
                inputType |= 0x2C000;
                imeOptions |= 1;
                break;
            }
            case 2: {
                inPassword = true;
                imeOptions |= 2;
                break;
            }
            case 3: {
                imeOptions |= 3;
                break;
            }
            case 4: {
                inputType = 209;
                imeOptions |= 2;
                break;
            }
            case 5: {
                inputType = 2;
                imeOptions |= 5;
                break;
            }
            case 6: {
                inputType = 3;
                imeOptions |= 5;
                break;
            }
            case 7: {
                imeOptions |= 2;
                break;
            }
            default: {
                imeOptions |= 2;
            }
        }
        this.setHint(null);
        if (single) {
            String name;
            this.mWebView.requestLabel(this.mWebView.nativeFocusCandidateFramePointer(), this.mNodePointer);
            maxLength = this.mWebView.nativeFocusCandidateMaxLength();
            boolean autoComplete = this.mWebView.nativeFocusCandidateIsAutoComplete();
            if (type != 2 && (this.mAutoFillable || autoComplete) && (name = this.mWebView.nativeFocusCandidateName()) != null && name.length() > 0) {
                this.mWebView.requestFormData(name, this.mNodePointer, this.mAutoFillable, autoComplete);
            }
        }
        this.mSingle = single;
        this.setMaxLength(maxLength);
        this.setHorizontallyScrolling(single);
        this.setInputType(inputType);
        this.setImeOptions(imeOptions);
        this.setInPassword(inPassword);
        AutoCompleteAdapter adapter = null;
        this.setAdapterCustom(adapter);
    }

    public void updateCachedTextfield() {
        this.mWebView.updateCachedTextfield(this.getText().toString());
    }

    public void setAutoFillProfileIsSet(boolean autoFillProfileIsSet) {
        this.mAutoFillProfileIsSet = autoFillProfileIsSet;
    }

    public static class OutlineDrawable
    extends Drawable {
        public Paint mBackgroundPaint = new Paint(1);
        public Paint mOutlinePaint;
        public float[] mLines;

        public OutlineDrawable() {
            this.mBackgroundPaint.setColor(-1);
            this.mOutlinePaint = new Paint(1);
            this.mOutlinePaint.setColor(-16777216);
            this.mOutlinePaint.setStyle(Paint.Style.STROKE);
            this.mLines = new float[16];
        }

        public void setBounds(int left, int top, int right, int bottom) {
            super.setBounds(left, top, right, bottom);
            --bottom;
            this.mLines[0] = left;
            this.mLines[1] = top + 1;
            this.mLines[2] = right -= 2;
            this.mLines[3] = top + 1;
            this.mLines[4] = right;
            this.mLines[5] = top;
            this.mLines[6] = right;
            this.mLines[7] = bottom;
            this.mLines[8] = left;
            this.mLines[9] = bottom;
            this.mLines[10] = right;
            this.mLines[11] = bottom;
            this.mLines[12] = left + 1;
            this.mLines[13] = top;
            this.mLines[14] = left + 1;
            this.mLines[15] = bottom;
        }

        public void draw(Canvas canvas) {
            canvas.drawRect(this.getBounds(), this.mBackgroundPaint);
            canvas.drawLines(this.mLines, this.mOutlinePaint);
        }

        public int getOpacity() {
            return -1;
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AutoCompleteAdapter
    extends ArrayAdapter<String> {
        public TextView mTextView;

        public AutoCompleteAdapter(Context context, ArrayList<String> entries) {
            super(context, 17367199, entries);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            TextView tv = (TextView)super.getView(position, convertView, parent);
            if (tv != null && this.mTextView != null) {
                tv.setTextSize(this.mTextView.getTextSize());
            }
            return tv;
        }

        public void setTextView(TextView tv) {
            this.mTextView = tv;
        }
    }

    public static class WebTextViewLayout
    extends DynamicLayout {
        public float mLineHeight;
        public float mDifference;

        public WebTextViewLayout(CharSequence base, CharSequence display, TextPaint paint, int width, Layout.Alignment align, float spacingMult, float spacingAdd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth, float lineHeight) {
            super(base, display, paint, width, align, spacingMult, spacingAdd, includepad, ellipsize, ellipsizedWidth);
            float paintLineHeight = paint.descent() - paint.ascent();
            if (lineHeight == -1.0f) {
                this.mLineHeight = paintLineHeight;
                this.mDifference = 0.0f;
            } else {
                this.mLineHeight = lineHeight;
                this.mDifference = (lineHeight - paintLineHeight) / 2.0f;
            }
        }

        public int getLineTop(int line) {
            return Math.round(this.mLineHeight * (float)line - this.mDifference);
        }
    }

    public class MyResultReceiver
    extends ResultReceiver {
        public void onReceiveResult(int resultCode, Bundle resultData) {
            if (resultCode == 2 && WebTextView.this.mWebView != null) {
                WebTextView.this.mWebView.revealSelection();
            }
        }

        public MyResultReceiver(Handler handler) {
            super(handler);
        }
    }
}

