/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.android.internal.policy.PolicyManager;
import java.util.Formatter;
import java.util.Locale;

public class MediaController
extends FrameLayout {
    public MediaPlayerControl mPlayer;
    public Context mContext;
    public View mAnchor;
    public View mRoot;
    public WindowManager mWindowManager;
    public Window mWindow;
    public View mDecor;
    public ProgressBar mProgress;
    public TextView mEndTime;
    public TextView mCurrentTime;
    public boolean mShowing;
    public boolean mDragging;
    public static final int sDefaultTimeout = 3000;
    public static final int FADE_OUT = 1;
    public static final int SHOW_PROGRESS = 2;
    public boolean mUseFastForward;
    public boolean mFromXml;
    public boolean mListenersSet;
    public View.OnClickListener mNextListener;
    public View.OnClickListener mPrevListener;
    public StringBuilder mFormatBuilder;
    public Formatter mFormatter;
    public ImageButton mPauseButton;
    public ImageButton mFfwdButton;
    public ImageButton mRewButton;
    public ImageButton mNextButton;
    public ImageButton mPrevButton;
    public View.OnTouchListener mTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0 && MediaController.this.mShowing) {
                MediaController.this.hide();
            }
            return false;
        }
    };
    public Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MediaController.this.hide();
                    break;
                }
                case 2: {
                    int pos = MediaController.this.setProgress();
                    if (MediaController.this.mDragging || !MediaController.this.mShowing || !MediaController.this.mPlayer.isPlaying()) break;
                    msg = this.obtainMessage(2);
                    this.sendMessageDelayed(msg, 1000 - pos % 1000);
                }
            }
        }
    };
    public View.OnClickListener mPauseListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaController.this.doPauseResume();
            MediaController.this.show(3000);
        }
    };
    public SeekBar.OnSeekBarChangeListener mSeekListener = new SeekBar.OnSeekBarChangeListener(){

        public void onStartTrackingTouch(SeekBar bar) {
            MediaController.this.show(3600000);
            MediaController.this.mDragging = true;
            MediaController.this.mHandler.removeMessages(2);
        }

        public void onProgressChanged(SeekBar bar, int progress, boolean fromuser) {
            if (!fromuser) {
                return;
            }
            long duration = MediaController.this.mPlayer.getDuration();
            long newposition = duration * (long)progress / 1000L;
            MediaController.this.mPlayer.seekTo((int)newposition);
            if (MediaController.this.mCurrentTime != null) {
                MediaController.this.mCurrentTime.setText(MediaController.this.stringForTime((int)newposition));
            }
        }

        public void onStopTrackingTouch(SeekBar bar) {
            MediaController.this.mDragging = false;
            MediaController.this.setProgress();
            MediaController.this.updatePausePlay();
            MediaController.this.show(3000);
            MediaController.this.mHandler.sendEmptyMessage(2);
        }
    };
    public View.OnClickListener mRewListener = new View.OnClickListener(){

        public void onClick(View v) {
            int pos = MediaController.this.mPlayer.getCurrentPosition();
            MediaController.this.mPlayer.seekTo(pos -= 5000);
            MediaController.this.setProgress();
            MediaController.this.show(3000);
        }
    };
    public View.OnClickListener mFfwdListener = new View.OnClickListener(){

        public void onClick(View v) {
            int pos = MediaController.this.mPlayer.getCurrentPosition();
            MediaController.this.mPlayer.seekTo(pos += 15000);
            MediaController.this.setProgress();
            MediaController.this.show(3000);
        }
    };

    public MediaController(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mRoot = this;
        this.mContext = context;
        this.mUseFastForward = true;
        this.mFromXml = true;
    }

    public void onFinishInflate() {
        if (this.mRoot != null) {
            this.initControllerView(this.mRoot);
        }
    }

    public MediaController(Context context, boolean useFastForward) {
        super(context);
        this.mContext = context;
        this.mUseFastForward = useFastForward;
        this.initFloatingWindow();
    }

    public MediaController(Context context) {
        super(context);
        this.mContext = context;
        this.mUseFastForward = true;
        this.initFloatingWindow();
    }

    public void initFloatingWindow() {
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        this.mWindow = PolicyManager.makeNewWindow(this.mContext);
        this.mWindow.setWindowManager(this.mWindowManager, null, null);
        this.mWindow.requestFeature(1);
        this.mDecor = this.mWindow.getDecorView();
        this.mDecor.setOnTouchListener(this.mTouchListener);
        this.mWindow.setContentView(this);
        this.mWindow.setBackgroundDrawableResource(17170445);
        this.mWindow.setVolumeControlStream(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
        this.requestFocus();
    }

    public void setMediaPlayer(MediaPlayerControl player) {
        this.mPlayer = player;
        this.updatePausePlay();
    }

    public void setAnchorView(View view) {
        this.mAnchor = view;
        FrameLayout.LayoutParams frameParams = new FrameLayout.LayoutParams(-1, -1);
        this.removeAllViews();
        View v = this.makeControllerView();
        this.addView(v, frameParams);
    }

    public View makeControllerView() {
        LayoutInflater inflate = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mRoot = inflate.inflate(17367129, null);
        this.initControllerView(this.mRoot);
        return this.mRoot;
    }

    public void initControllerView(View v) {
        this.mPauseButton = (ImageButton)v.findViewById(16908934);
        if (this.mPauseButton != null) {
            this.mPauseButton.requestFocus();
            this.mPauseButton.setOnClickListener(this.mPauseListener);
        }
        this.mFfwdButton = (ImageButton)v.findViewById(16908935);
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setOnClickListener(this.mFfwdListener);
            if (!this.mFromXml) {
                this.mFfwdButton.setVisibility(this.mUseFastForward ? 0 : 8);
            }
        }
        this.mRewButton = (ImageButton)v.findViewById(16908933);
        if (this.mRewButton != null) {
            this.mRewButton.setOnClickListener(this.mRewListener);
            if (!this.mFromXml) {
                this.mRewButton.setVisibility(this.mUseFastForward ? 0 : 8);
            }
        }
        this.mNextButton = (ImageButton)v.findViewById(16908936);
        if (this.mNextButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mNextButton.setVisibility(8);
        }
        this.mPrevButton = (ImageButton)v.findViewById(16908932);
        if (this.mPrevButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mPrevButton.setVisibility(8);
        }
        this.mProgress = (ProgressBar)v.findViewById(16908938);
        if (this.mProgress != null) {
            if (this.mProgress instanceof SeekBar) {
                SeekBar seeker = (SeekBar)this.mProgress;
                seeker.setOnSeekBarChangeListener(this.mSeekListener);
            }
            this.mProgress.setMax(1000);
        }
        this.mEndTime = (TextView)v.findViewById(16908388);
        this.mCurrentTime = (TextView)v.findViewById(16908937);
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.installPrevNextListeners();
    }

    public void show() {
        this.show(3000);
    }

    public void disableUnsupportedButtons() {
        try {
            if (this.mPauseButton != null && !this.mPlayer.canPause()) {
                this.mPauseButton.setEnabled(false);
            }
            if (this.mRewButton != null && !this.mPlayer.canSeekBackward()) {
                this.mRewButton.setEnabled(false);
            }
            if (this.mFfwdButton != null && !this.mPlayer.canSeekForward()) {
                this.mFfwdButton.setEnabled(false);
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    public void show(int timeout) {
        if (!this.mShowing && this.mAnchor != null) {
            this.setProgress();
            if (this.mPauseButton != null) {
                this.mPauseButton.requestFocus();
            }
            this.disableUnsupportedButtons();
            int[] anchorpos = new int[2];
            this.mAnchor.getLocationOnScreen(anchorpos);
            WindowManager.LayoutParams p = new WindowManager.LayoutParams();
            p.gravity = 48;
            p.width = this.mAnchor.getWidth();
            p.height = -2;
            p.x = 0;
            p.y = anchorpos[1] + this.mAnchor.getHeight() - p.height;
            p.format = -3;
            p.type = 1000;
            p.flags |= 0x820000;
            p.token = null;
            p.windowAnimations = 0;
            this.mWindowManager.addView(this.mDecor, p);
            this.mShowing = true;
        }
        this.updatePausePlay();
        this.mHandler.sendEmptyMessage(2);
        Message msg = this.mHandler.obtainMessage(1);
        if (timeout != 0) {
            this.mHandler.removeMessages(1);
            this.mHandler.sendMessageDelayed(msg, timeout);
        }
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public void hide() {
        if (this.mAnchor == null) {
            return;
        }
        if (this.mShowing) {
            try {
                this.mHandler.removeMessages(2);
                this.mWindowManager.removeView(this.mDecor);
            }
            catch (IllegalArgumentException ex) {
                Log.w("MediaController", "already removed");
            }
            this.mShowing = false;
        }
    }

    public String stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        this.mFormatBuilder.setLength(0);
        if (hours > 0) {
            return this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    public int setProgress() {
        if (this.mPlayer == null || this.mDragging) {
            return 0;
        }
        int position = this.mPlayer.getCurrentPosition();
        int duration = this.mPlayer.getDuration();
        if (this.mProgress != null) {
            if (duration > 0) {
                long pos = 1000L * (long)position / (long)duration;
                this.mProgress.setProgress((int)pos);
            }
            int percent = this.mPlayer.getBufferPercentage();
            this.mProgress.setSecondaryProgress(percent * 10);
        }
        if (this.mEndTime != null) {
            this.mEndTime.setText(this.stringForTime(duration));
        }
        if (this.mCurrentTime != null) {
            this.mCurrentTime.setText(this.stringForTime(position));
        }
        return position;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.show(3000);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        this.show(3000);
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean uniqueDown;
        int keyCode = event.getKeyCode();
        boolean bl = uniqueDown = event.getRepeatCount() == 0 && event.getAction() == 0;
        if (keyCode == 79 || keyCode == 85 || keyCode == 62) {
            if (uniqueDown) {
                this.doPauseResume();
                this.show(3000);
                if (this.mPauseButton != null) {
                    this.mPauseButton.requestFocus();
                }
            }
            return true;
        }
        if (keyCode == 126) {
            if (uniqueDown && !this.mPlayer.isPlaying()) {
                this.mPlayer.start();
                this.updatePausePlay();
                this.show(3000);
            }
            return true;
        }
        if (keyCode == 86 || keyCode == 127) {
            if (uniqueDown && this.mPlayer.isPlaying()) {
                this.mPlayer.pause();
                this.updatePausePlay();
                this.show(3000);
            }
            return true;
        }
        if (keyCode == 25 || keyCode == 24 || keyCode == 164) {
            return super.dispatchKeyEvent(event);
        }
        if (keyCode == 4 || keyCode == 82) {
            if (uniqueDown) {
                this.hide();
            }
            return true;
        }
        this.show(3000);
        return super.dispatchKeyEvent(event);
    }

    public void updatePausePlay() {
        if (this.mRoot == null || this.mPauseButton == null) {
            return;
        }
        if (this.mPlayer.isPlaying()) {
            this.mPauseButton.setImageResource(17301539);
        } else {
            this.mPauseButton.setImageResource(17301540);
        }
    }

    public void doPauseResume() {
        if (this.mPlayer.isPlaying()) {
            this.mPlayer.pause();
        } else {
            this.mPlayer.start();
        }
        this.updatePausePlay();
    }

    public void setEnabled(boolean enabled) {
        if (this.mPauseButton != null) {
            this.mPauseButton.setEnabled(enabled);
        }
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setEnabled(enabled);
        }
        if (this.mRewButton != null) {
            this.mRewButton.setEnabled(enabled);
        }
        if (this.mNextButton != null) {
            this.mNextButton.setEnabled(enabled && this.mNextListener != null);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setEnabled(enabled && this.mPrevListener != null);
        }
        if (this.mProgress != null) {
            this.mProgress.setEnabled(enabled);
        }
        this.disableUnsupportedButtons();
        super.setEnabled(enabled);
    }

    public void installPrevNextListeners() {
        if (this.mNextButton != null) {
            this.mNextButton.setOnClickListener(this.mNextListener);
            this.mNextButton.setEnabled(this.mNextListener != null);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setOnClickListener(this.mPrevListener);
            this.mPrevButton.setEnabled(this.mPrevListener != null);
        }
    }

    public void setPrevNextListeners(View.OnClickListener next, View.OnClickListener prev) {
        this.mNextListener = next;
        this.mPrevListener = prev;
        this.mListenersSet = true;
        if (this.mRoot != null) {
            this.installPrevNextListeners();
            if (this.mNextButton != null && !this.mFromXml) {
                this.mNextButton.setVisibility(0);
            }
            if (this.mPrevButton != null && !this.mFromXml) {
                this.mPrevButton.setVisibility(0);
            }
        }
    }

    public static interface MediaPlayerControl {
        public void start();

        public void pause();

        public int getDuration();

        public int getCurrentPosition();

        public void seekTo(int var1);

        public boolean isPlaying();

        public int getBufferPercentage();

        public boolean canPause();

        public boolean canSeekBackward();

        public boolean canSeekForward();
    }
}

