/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.PendingIntent;
import android.app.SearchableInfo;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.CursorAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SuggestionsAdapter;
import android.widget.TextView;
import com.android.internal.R;
import java.util.WeakHashMap;

public class SearchView
extends LinearLayout {
    public static final boolean DBG = false;
    public static final String LOG_TAG = "SearchView";
    public OnQueryTextListener mOnQueryChangeListener;
    public OnCloseListener mOnCloseListener;
    public View.OnFocusChangeListener mOnQueryTextFocusChangeListener;
    public OnSuggestionListener mOnSuggestionListener;
    public View.OnClickListener mOnSearchClickListener;
    public boolean mIconifiedByDefault;
    public boolean mIconified;
    public CursorAdapter mSuggestionsAdapter;
    public View mSearchButton;
    public View mSubmitButton;
    public View mSearchPlate;
    public View mSubmitArea;
    public ImageView mCloseButton;
    public View mSearchEditFrame;
    public View mVoiceButton;
    public SearchAutoComplete mQueryTextView;
    public boolean mSubmitButtonEnabled;
    public CharSequence mQueryHint;
    public boolean mQueryRefinement;
    public boolean mClearingFocus;
    public int mMaxWidth;
    public boolean mVoiceButtonEnabled;
    public SearchableInfo mSearchable;
    public Bundle mAppSearchData;
    public final Intent mVoiceWebSearchIntent;
    public final Intent mVoiceAppSearchIntent;
    public final WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache = new WeakHashMap();
    public final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v == SearchView.this.mSearchButton) {
                SearchView.this.onSearchClicked();
            } else if (v == SearchView.this.mCloseButton) {
                SearchView.this.onCloseClicked();
            } else if (v == SearchView.this.mSubmitButton) {
                SearchView.this.onSubmitQuery();
            } else if (v == SearchView.this.mVoiceButton) {
                SearchView.this.onVoiceClicked();
            }
        }
    };
    public View.OnKeyListener mTextKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (SearchView.this.mSearchable == null) {
                return false;
            }
            if (SearchView.this.mQueryTextView.isPopupShowing() && SearchView.this.mQueryTextView.getListSelection() != -1) {
                return SearchView.this.onSuggestionsKey(v, keyCode, event);
            }
            if (!SearchView.this.mQueryTextView.isEmpty() && event.hasNoModifiers()) {
                SearchableInfo.ActionKeyInfo actionKey;
                if (event.getAction() == 1 && keyCode == 66) {
                    v.cancelLongPress();
                    SearchView.this.launchQuerySearch(0, null, SearchView.this.mQueryTextView.getText().toString());
                    return true;
                }
                if (event.getAction() == 0 && (actionKey = SearchView.this.mSearchable.findActionKey(keyCode)) != null && actionKey.getQueryActionMsg() != null) {
                    SearchView.this.launchQuerySearch(keyCode, actionKey.getQueryActionMsg(), SearchView.this.mQueryTextView.getText().toString());
                    return true;
                }
            }
            return false;
        }
    };
    public final TextView.OnEditorActionListener mOnEditorActionListener = new TextView.OnEditorActionListener(){

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            SearchView.this.onSubmitQuery();
            return true;
        }
    };
    public final AdapterView.OnItemClickListener mOnItemClickListener = new AdapterView.OnItemClickListener(){

        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            SearchView.this.onItemClicked(position, 0, null);
        }
    };
    public final AdapterView.OnItemSelectedListener mOnItemSelectedListener = new AdapterView.OnItemSelectedListener(){

        @Override
        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
            SearchView.this.onItemSelected(position);
        }

        @Override
        public void onNothingSelected(AdapterView<?> parent) {
        }
    };
    public TextWatcher mTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int before, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int after) {
            SearchView.this.onTextChanged(s);
        }

        public void afterTextChanged(Editable s) {
        }
    };

    public SearchView(Context context) {
        this(context, null);
    }

    public SearchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        CharSequence queryHint;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(17367167, (ViewGroup)this, true);
        this.mSearchButton = this.findViewById(16908980);
        this.mQueryTextView = (SearchAutoComplete)this.findViewById(16908983);
        this.mQueryTextView.setSearchView(this);
        this.mSearchEditFrame = this.findViewById(16908981);
        this.mSearchPlate = this.findViewById(16908982);
        this.mSubmitArea = this.findViewById(16908985);
        this.mSubmitButton = this.findViewById(16908986);
        this.mCloseButton = (ImageView)this.findViewById(16908984);
        this.mVoiceButton = this.findViewById(16908987);
        this.mSearchButton.setOnClickListener(this.mOnClickListener);
        this.mCloseButton.setOnClickListener(this.mOnClickListener);
        this.mSubmitButton.setOnClickListener(this.mOnClickListener);
        this.mVoiceButton.setOnClickListener(this.mOnClickListener);
        this.mQueryTextView.addTextChangedListener(this.mTextWatcher);
        this.mQueryTextView.setOnEditorActionListener(this.mOnEditorActionListener);
        this.mQueryTextView.setOnItemClickListener(this.mOnItemClickListener);
        this.mQueryTextView.setOnItemSelectedListener(this.mOnItemSelectedListener);
        this.mQueryTextView.setOnKeyListener(this.mTextKeyListener);
        this.mQueryTextView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (SearchView.this.mOnQueryTextFocusChangeListener != null) {
                    SearchView.this.mOnQueryTextFocusChangeListener.onFocusChange(SearchView.this, hasFocus);
                }
            }
        });
        boolean focusable = true;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SearchView, 0, 0);
        this.setIconifiedByDefault(a.getBoolean(1, true));
        int maxWidth = a.getDimensionPixelSize(0, -1);
        if (maxWidth != -1) {
            this.setMaxWidth(maxWidth);
        }
        if (!TextUtils.isEmpty(queryHint = a.getText(2))) {
            this.setQueryHint(queryHint);
        }
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.View, 0, 0);
        focusable = a.getBoolean(18, focusable);
        a.recycle();
        this.setFocusable(focusable);
        this.mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceWebSearchIntent.addFlags(0x10000000);
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mVoiceAppSearchIntent.addFlags(0x10000000);
        this.updateViewsVisibility(this.mIconifiedByDefault);
    }

    public void setSearchableInfo(SearchableInfo searchable) {
        this.mSearchable = searchable;
        if (this.mSearchable != null) {
            this.updateSearchAutoComplete();
            this.updateQueryHint();
        }
        this.mVoiceButtonEnabled = this.hasVoiceSearch();
        this.updateViewsVisibility(this.mIconifiedByDefault);
    }

    public void setAppSearchData(Bundle appSearchData) {
        this.mAppSearchData = appSearchData;
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if (this.mClearingFocus) {
            return false;
        }
        if (!this.isFocusable()) {
            return false;
        }
        if (!this.isIconified()) {
            boolean result = this.mQueryTextView.requestFocus(direction, previouslyFocusedRect);
            if (result) {
                this.updateViewsVisibility(false);
            }
            return result;
        }
        return super.requestFocus(direction, previouslyFocusedRect);
    }

    public void clearFocus() {
        this.mClearingFocus = true;
        super.clearFocus();
        this.mQueryTextView.clearFocus();
        this.setImeVisibility(false);
        this.mClearingFocus = false;
        this.updateViewsVisibility(this.mIconifiedByDefault);
    }

    public void setOnQueryTextListener(OnQueryTextListener listener) {
        this.mOnQueryChangeListener = listener;
    }

    public void setOnCloseListener(OnCloseListener listener) {
        this.mOnCloseListener = listener;
    }

    public void setOnQueryTextFocusChangeListener(View.OnFocusChangeListener listener) {
        this.mOnQueryTextFocusChangeListener = listener;
    }

    public void setOnSuggestionListener(OnSuggestionListener listener) {
        this.mOnSuggestionListener = listener;
    }

    public void setOnSearchClickListener(View.OnClickListener listener) {
        this.mOnSearchClickListener = listener;
    }

    public CharSequence getQuery() {
        return this.mQueryTextView.getText();
    }

    public void setQuery(CharSequence query, boolean submit) {
        this.mQueryTextView.setText(query);
        if (query != null) {
            this.mQueryTextView.setSelection(query.length());
        }
        if (submit && !TextUtils.isEmpty(query)) {
            this.onSubmitQuery();
        }
    }

    public void setQueryHint(CharSequence hint) {
        this.mQueryHint = hint;
        this.updateQueryHint();
    }

    public void setIconifiedByDefault(boolean iconified) {
        if (this.mIconifiedByDefault == iconified) {
            return;
        }
        this.mIconifiedByDefault = iconified;
        this.updateViewsVisibility(iconified);
    }

    public boolean isIconfiedByDefault() {
        return this.mIconifiedByDefault;
    }

    public void setIconified(boolean iconify) {
        if (iconify) {
            this.onCloseClicked();
        } else {
            this.onSearchClicked();
        }
    }

    public boolean isIconified() {
        return this.mIconified;
    }

    public void setSubmitButtonEnabled(boolean enabled) {
        this.mSubmitButtonEnabled = enabled;
        this.updateViewsVisibility(this.isIconified());
    }

    public boolean isSubmitButtonEnabled() {
        return this.mSubmitButtonEnabled;
    }

    public void setQueryRefinementEnabled(boolean enable) {
        this.mQueryRefinement = enable;
        if (this.mSuggestionsAdapter instanceof SuggestionsAdapter) {
            ((SuggestionsAdapter)this.mSuggestionsAdapter).setQueryRefinement(enable ? 2 : 1);
        }
    }

    public boolean isQueryRefinementEnabled() {
        return this.mQueryRefinement;
    }

    public void setSuggestionsAdapter(CursorAdapter adapter) {
        this.mSuggestionsAdapter = adapter;
        this.mQueryTextView.setAdapter(this.mSuggestionsAdapter);
    }

    public CursorAdapter getSuggestionsAdapter() {
        return this.mSuggestionsAdapter;
    }

    public void setMaxWidth(int maxpixels) {
        this.mMaxWidth = maxpixels;
        this.requestLayout();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int width = View.MeasureSpec.getSize(widthMeasureSpec);
        if ((widthMode == Integer.MIN_VALUE || widthMode == 0x40000000) && this.mMaxWidth > 0 && width > this.mMaxWidth) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec(this.mMaxWidth, widthMode), heightMeasureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void updateViewsVisibility(boolean collapsed) {
        this.mIconified = collapsed;
        int visCollapsed = collapsed ? 0 : 8;
        boolean hasText = !TextUtils.isEmpty(this.mQueryTextView.getText());
        this.mSearchButton.setVisibility(visCollapsed);
        this.updateSubmitButton(hasText);
        this.mSearchEditFrame.setVisibility(collapsed ? 8 : 0);
        this.updateCloseButton();
        this.updateVoiceButton(!hasText);
        this.updateSubmitArea();
    }

    public boolean hasVoiceSearch() {
        if (this.mSearchable != null && this.mSearchable.getVoiceSearchEnabled()) {
            Intent testIntent = null;
            if (this.mSearchable.getVoiceSearchLaunchWebSearch()) {
                testIntent = this.mVoiceWebSearchIntent;
            } else if (this.mSearchable.getVoiceSearchLaunchRecognizer()) {
                testIntent = this.mVoiceAppSearchIntent;
            }
            if (testIntent != null) {
                ResolveInfo ri = this.getContext().getPackageManager().resolveActivity(testIntent, 65536);
                return ri != null;
            }
        }
        return false;
    }

    public boolean isSubmitAreaEnabled() {
        return (this.mSubmitButtonEnabled || this.mVoiceButtonEnabled) && !this.isIconified();
    }

    public void updateSubmitButton(boolean hasText) {
        int visibility = 8;
        if (this.isSubmitAreaEnabled() && this.hasFocus() && (hasText || !this.mVoiceButtonEnabled)) {
            visibility = 0;
        }
        this.mSubmitButton.setVisibility(visibility);
    }

    public void updateSubmitArea() {
        int visibility = 8;
        if (this.isSubmitAreaEnabled() && (this.mSubmitButton.getVisibility() == 0 || this.mVoiceButton.getVisibility() == 0)) {
            visibility = 0;
        }
        this.mSubmitArea.setVisibility(visibility);
    }

    public void updateCloseButton() {
        boolean hasText = !TextUtils.isEmpty(this.mQueryTextView.getText());
        boolean showClose = hasText || this.mIconifiedByDefault || this.mQueryTextView.hasFocus();
        this.mCloseButton.setVisibility(showClose ? 0 : 4);
        this.mCloseButton.getDrawable().setState(hasText ? ENABLED_STATE_SET : EMPTY_STATE_SET);
    }

    public void updateFocusedState(boolean focused) {
        this.mSearchPlate.getBackground().setState(focused ? FOCUSED_STATE_SET : EMPTY_STATE_SET);
        this.mSubmitArea.getBackground().setState(focused ? FOCUSED_STATE_SET : EMPTY_STATE_SET);
    }

    public void setImeVisibility(boolean visible) {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (imm != null) {
            if (visible) {
                imm.showSoftInputUnchecked(0, null);
            } else {
                imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
            }
        }
    }

    public void onQueryRefine(CharSequence queryText) {
        this.setQuery(queryText);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mSearchable == null) {
            return false;
        }
        SearchableInfo.ActionKeyInfo actionKey = this.mSearchable.findActionKey(keyCode);
        if (actionKey != null && actionKey.getQueryActionMsg() != null) {
            this.launchQuerySearch(keyCode, actionKey.getQueryActionMsg(), this.mQueryTextView.getText().toString());
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onSuggestionsKey(View v, int keyCode, KeyEvent event) {
        if (this.mSearchable == null) {
            return false;
        }
        if (this.mSuggestionsAdapter == null) {
            return false;
        }
        if (event.getAction() == 0 && event.hasNoModifiers()) {
            String actionMsg;
            Cursor c;
            int position;
            if (keyCode == 66 || keyCode == 84 || keyCode == 61) {
                int position2 = this.mQueryTextView.getListSelection();
                return this.onItemClicked(position2, 0, null);
            }
            if (keyCode == 21 || keyCode == 22) {
                int selPoint = keyCode == 21 ? 0 : this.mQueryTextView.length();
                this.mQueryTextView.setSelection(selPoint);
                this.mQueryTextView.setListSelection(0);
                this.mQueryTextView.clearListSelection();
                this.mQueryTextView.ensureImeVisible(true);
                return true;
            }
            if (keyCode == 19 && 0 == this.mQueryTextView.getListSelection()) {
                return false;
            }
            SearchableInfo.ActionKeyInfo actionKey = this.mSearchable.findActionKey(keyCode);
            if (actionKey != null && (actionKey.getSuggestActionMsg() != null || actionKey.getSuggestActionMsgColumn() != null) && (position = this.mQueryTextView.getListSelection()) != -1 && (c = this.mSuggestionsAdapter.getCursor()).moveToPosition(position) && (actionMsg = SearchView.getActionKeyMessage(c, actionKey)) != null && actionMsg.length() > 0) {
                return this.onItemClicked(position, keyCode, actionMsg);
            }
        }
        return false;
    }

    public static String getActionKeyMessage(Cursor c, SearchableInfo.ActionKeyInfo actionKey) {
        String result = null;
        String column = actionKey.getSuggestActionMsgColumn();
        if (column != null) {
            result = SuggestionsAdapter.getColumnString(c, column);
        }
        if (result == null) {
            result = actionKey.getSuggestActionMsg();
        }
        return result;
    }

    public void updateQueryHint() {
        if (this.mQueryHint != null) {
            this.mQueryTextView.setHint(this.mQueryHint);
        } else if (this.mSearchable != null) {
            String hint = null;
            int hintId = this.mSearchable.getHintId();
            if (hintId != 0) {
                hint = this.getContext().getString(hintId);
            }
            if (hint != null) {
                this.mQueryTextView.setHint(hint);
            }
        }
    }

    public void updateSearchAutoComplete() {
        this.mQueryTextView.setDropDownAnimationStyle(0);
        this.mQueryTextView.setThreshold(this.mSearchable.getSuggestThreshold());
        if (this.mSearchable.getSuggestAuthority() != null) {
            this.mSuggestionsAdapter = new SuggestionsAdapter(this.getContext(), this, this.mSearchable, this.mOutsideDrawablesCache);
            this.mQueryTextView.setAdapter(this.mSuggestionsAdapter);
            ((SuggestionsAdapter)this.mSuggestionsAdapter).setQueryRefinement(this.mQueryRefinement ? 2 : 1);
        }
    }

    public void updateVoiceButton(boolean empty) {
        int visibility = 8;
        if (this.mVoiceButtonEnabled && !this.isIconified() && (empty || !this.mSubmitButtonEnabled)) {
            visibility = 0;
            this.mSubmitButton.setVisibility(8);
        }
        this.mVoiceButton.setVisibility(visibility);
    }

    public void onTextChanged(CharSequence newText) {
        boolean hasText;
        Editable text = this.mQueryTextView.getText();
        boolean bl = hasText = !TextUtils.isEmpty(text);
        if (this.isSubmitButtonEnabled()) {
            this.updateSubmitButton(hasText);
        }
        this.updateVoiceButton(!hasText);
        this.updateCloseButton();
        this.updateSubmitArea();
        if (this.mOnQueryChangeListener != null) {
            this.mOnQueryChangeListener.onQueryTextChange(((Object)newText).toString());
        }
    }

    public void onSubmitQuery() {
        Editable query = this.mQueryTextView.getText();
        if (!(TextUtils.isEmpty(query) || this.mOnQueryChangeListener != null && this.mOnQueryChangeListener.onQueryTextSubmit(query.toString()))) {
            if (this.mSearchable != null) {
                this.launchQuerySearch(0, null, query.toString());
                this.setImeVisibility(false);
            }
            this.dismissSuggestions();
        }
    }

    public void dismissSuggestions() {
        this.mQueryTextView.dismissDropDown();
    }

    public void onCloseClicked() {
        if (this.mOnCloseListener == null || !this.mOnCloseListener.onClose()) {
            Editable text = this.mQueryTextView.getText();
            if (TextUtils.isEmpty(text)) {
                this.clearFocus();
                this.setImeVisibility(false);
            } else {
                this.mQueryTextView.setText("");
            }
            this.updateViewsVisibility(this.mIconifiedByDefault);
            if (this.mIconifiedByDefault) {
                this.setImeVisibility(false);
            }
        }
    }

    public void onSearchClicked() {
        this.updateViewsVisibility(false);
        this.mQueryTextView.requestFocus();
        this.setImeVisibility(true);
        if (this.mOnSearchClickListener != null) {
            this.mOnSearchClickListener.onClick(this);
        }
    }

    public void onVoiceClicked() {
        if (this.mSearchable == null) {
            return;
        }
        SearchableInfo searchable = this.mSearchable;
        try {
            if (searchable.getVoiceSearchLaunchWebSearch()) {
                Intent webSearchIntent = this.createVoiceWebSearchIntent(this.mVoiceWebSearchIntent, searchable);
                this.getContext().startActivity(webSearchIntent);
            } else if (searchable.getVoiceSearchLaunchRecognizer()) {
                Intent appSearchIntent = this.createVoiceAppSearchIntent(this.mVoiceAppSearchIntent, searchable);
                this.getContext().startActivity(appSearchIntent);
            }
        }
        catch (ActivityNotFoundException e) {
            Log.w(LOG_TAG, "Could not find voice search activity");
        }
    }

    public void onTextFocusChanged() {
        this.updateViewsVisibility(this.isIconified());
        this.updateFocusedState(this.mQueryTextView.hasFocus());
    }

    public boolean onItemClicked(int position, int actionKey, String actionMsg) {
        if (this.mOnSuggestionListener == null || !this.mOnSuggestionListener.onSuggestionClick(position)) {
            this.launchSuggestion(position, 0, null);
            this.setImeVisibility(false);
            this.dismissSuggestions();
            return true;
        }
        return false;
    }

    public boolean onItemSelected(int position) {
        if (this.mOnSuggestionListener == null || !this.mOnSuggestionListener.onSuggestionSelect(position)) {
            this.rewriteQueryFromSuggestion(position);
            return true;
        }
        return false;
    }

    public void rewriteQueryFromSuggestion(int position) {
        Editable oldQuery = this.mQueryTextView.getText();
        Cursor c = this.mSuggestionsAdapter.getCursor();
        if (c == null) {
            return;
        }
        if (c.moveToPosition(position)) {
            CharSequence newQuery = this.mSuggestionsAdapter.convertToString(c);
            if (newQuery != null) {
                this.setQuery(newQuery);
            } else {
                this.setQuery(oldQuery);
            }
        } else {
            this.setQuery(oldQuery);
        }
    }

    public boolean launchSuggestion(int position, int actionKey, String actionMsg) {
        Cursor c = this.mSuggestionsAdapter.getCursor();
        if (c != null && c.moveToPosition(position)) {
            Intent intent = this.createIntentFromSuggestion(c, actionKey, actionMsg);
            this.launchIntent(intent);
            return true;
        }
        return false;
    }

    public void launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        try {
            this.getContext().startActivity(intent);
        }
        catch (RuntimeException ex) {
            Log.e(LOG_TAG, "Failed launch activity: " + intent, ex);
        }
    }

    public void setQuery(CharSequence query) {
        this.mQueryTextView.setText(query, true);
        this.mQueryTextView.setSelection(TextUtils.isEmpty(query) ? 0 : query.length());
    }

    public void launchQuerySearch(int actionKey, String actionMsg, String query) {
        String action = "android.intent.action.SEARCH";
        Intent intent = this.createIntent(action, null, null, query, actionKey, actionMsg);
        this.getContext().startActivity(intent);
    }

    public Intent createIntent(String action, Uri data, String extraData, String query, int actionKey, String actionMsg) {
        Intent intent = new Intent(action);
        intent.addFlags(0x10000000);
        if (data != null) {
            intent.setData(data);
        }
        intent.putExtra("user_query", query);
        if (query != null) {
            intent.putExtra("query", query);
        }
        if (extraData != null) {
            intent.putExtra("intent_extra_data_key", extraData);
        }
        if (this.mAppSearchData != null) {
            intent.putExtra("app_data", this.mAppSearchData);
        }
        if (actionKey != 0) {
            intent.putExtra("action_key", actionKey);
            intent.putExtra("action_msg", actionMsg);
        }
        intent.setComponent(this.mSearchable.getSearchActivity());
        return intent;
    }

    public Intent createVoiceWebSearchIntent(Intent baseIntent, SearchableInfo searchable) {
        Intent voiceIntent = new Intent(baseIntent);
        ComponentName searchActivity = searchable.getSearchActivity();
        voiceIntent.putExtra("calling_package", searchActivity == null ? null : searchActivity.flattenToShortString());
        return voiceIntent;
    }

    public Intent createVoiceAppSearchIntent(Intent baseIntent, SearchableInfo searchable) {
        ComponentName searchActivity = searchable.getSearchActivity();
        Intent queryIntent = new Intent("android.intent.action.SEARCH");
        queryIntent.setComponent(searchActivity);
        PendingIntent pending = PendingIntent.getActivity(this.getContext(), 0, queryIntent, 0x40000000);
        Bundle queryExtras = new Bundle();
        Intent voiceIntent = new Intent(baseIntent);
        String languageModel = "free_form";
        String prompt = null;
        String language = null;
        int maxResults = 1;
        Resources resources = this.getResources();
        if (searchable.getVoiceLanguageModeId() != 0) {
            languageModel = resources.getString(searchable.getVoiceLanguageModeId());
        }
        if (searchable.getVoicePromptTextId() != 0) {
            prompt = resources.getString(searchable.getVoicePromptTextId());
        }
        if (searchable.getVoiceLanguageId() != 0) {
            language = resources.getString(searchable.getVoiceLanguageId());
        }
        if (searchable.getVoiceMaxResults() != 0) {
            maxResults = searchable.getVoiceMaxResults();
        }
        voiceIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", languageModel);
        voiceIntent.putExtra("android.speech.extra.PROMPT", prompt);
        voiceIntent.putExtra("android.speech.extra.LANGUAGE", language);
        voiceIntent.putExtra("android.speech.extra.MAX_RESULTS", maxResults);
        voiceIntent.putExtra("calling_package", searchActivity == null ? null : searchActivity.flattenToShortString());
        voiceIntent.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", pending);
        voiceIntent.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", queryExtras);
        return voiceIntent;
    }

    public Intent createIntentFromSuggestion(Cursor c, int actionKey, String actionMsg) {
        try {
            String id2;
            String data;
            String action = SuggestionsAdapter.getColumnString(c, "suggest_intent_action");
            if (action == null) {
                action = this.mSearchable.getSuggestIntentAction();
            }
            if (action == null) {
                action = "android.intent.action.SEARCH";
            }
            if ((data = SuggestionsAdapter.getColumnString(c, "suggest_intent_data")) == null) {
                data = this.mSearchable.getSuggestIntentData();
            }
            if (data != null && (id2 = SuggestionsAdapter.getColumnString(c, "suggest_intent_data_id")) != null) {
                data = data + "/" + Uri.encode(id2);
            }
            Uri dataUri = data == null ? null : Uri.parse(data);
            String query = SuggestionsAdapter.getColumnString(c, "suggest_intent_query");
            String extraData = SuggestionsAdapter.getColumnString(c, "suggest_intent_extra_data");
            return this.createIntent(action, dataUri, extraData, query, actionKey, actionMsg);
        }
        catch (RuntimeException e) {
            int rowNum;
            try {
                rowNum = c.getPosition();
            }
            catch (RuntimeException e2) {
                rowNum = -1;
            }
            Log.w(LOG_TAG, "Search Suggestions cursor at row " + rowNum + " returned exception" + e.toString());
            return null;
        }
    }

    public static boolean isLandscapeMode(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    public static class SearchAutoComplete
    extends AutoCompleteTextView {
        public int mThreshold = this.getThreshold();
        public SearchView mSearchView;

        public SearchAutoComplete(Context context) {
            super(context);
        }

        public SearchAutoComplete(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public SearchAutoComplete(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
        }

        public void setSearchView(SearchView searchView) {
            this.mSearchView = searchView;
        }

        public void setThreshold(int threshold) {
            super.setThreshold(threshold);
            this.mThreshold = threshold;
        }

        public boolean isEmpty() {
            return TextUtils.getTrimmedLength(this.getText()) == 0;
        }

        public void replaceText(CharSequence text) {
        }

        public void performCompletion() {
        }

        public void onWindowFocusChanged(boolean hasWindowFocus) {
            super.onWindowFocusChanged(hasWindowFocus);
            if (hasWindowFocus && this.mSearchView.hasFocus() && this.getVisibility() == 0) {
                InputMethodManager inputManager = (InputMethodManager)this.getContext().getSystemService("input_method");
                inputManager.showSoftInput(this, 0);
                if (SearchView.isLandscapeMode(this.getContext())) {
                    this.ensureImeVisible(true);
                }
            }
        }

        public void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
            super.onFocusChanged(focused, direction, previouslyFocusedRect);
            this.mSearchView.onTextFocusChanged();
        }

        public boolean enoughToFilter() {
            return this.mThreshold <= 0 || super.enoughToFilter();
        }
    }

    public static interface OnSuggestionListener {
        public boolean onSuggestionSelect(int var1);

        public boolean onSuggestionClick(int var1);
    }

    public static interface OnCloseListener {
        public boolean onClose();
    }

    public static interface OnQueryTextListener {
        public boolean onQueryTextSubmit(String var1);

        public boolean onQueryTextChange(String var1);
    }
}

