/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.LocalActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TabWidget;
import android.widget.TextView;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.List;

public class TabHost
extends FrameLayout
implements ViewTreeObserver.OnTouchModeChangeListener {
    public TabWidget mTabWidget;
    public FrameLayout mTabContent;
    public List<TabSpec> mTabSpecs = new ArrayList<TabSpec>(2);
    public int mCurrentTab = -1;
    public View mCurrentView = null;
    public LocalActivityManager mLocalActivityManager = null;
    public OnTabChangeListener mOnTabChangeListener;
    public View.OnKeyListener mTabKeyListener;
    public int mTabLayoutId;

    public TabHost(Context context) {
        super(context);
        this.initTabHost();
    }

    public TabHost(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabWidget, 16842883, 0);
        this.mTabLayoutId = a.getResourceId(4, 0);
        a.recycle();
        if (this.mTabLayoutId == 0) {
            this.mTabLayoutId = 17367182;
        }
        this.initTabHost();
    }

    public void initTabHost() {
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
        this.mCurrentTab = -1;
        this.mCurrentView = null;
    }

    public TabSpec newTabSpec(String tag) {
        return new TabSpec(tag, null);
    }

    public void setup() {
        this.mTabWidget = (TabWidget)this.findViewById(16908307);
        if (this.mTabWidget == null) {
            throw new RuntimeException("Your TabHost must have a TabWidget whose id attribute is 'android.R.id.tabs'");
        }
        this.mTabKeyListener = new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                switch (keyCode) {
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 66: {
                        return false;
                    }
                }
                TabHost.this.mTabContent.requestFocus(2);
                return TabHost.this.mTabContent.dispatchKeyEvent(event);
            }
        };
        this.mTabWidget.setTabSelectionListener(new TabWidget.OnTabSelectionChanged(){

            public void onTabSelectionChanged(int tabIndex, boolean clicked) {
                TabHost.this.setCurrentTab(tabIndex);
                if (clicked) {
                    TabHost.this.mTabContent.requestFocus(2);
                }
            }
        });
        this.mTabContent = (FrameLayout)this.findViewById(0x1020011);
        if (this.mTabContent == null) {
            throw new RuntimeException("Your TabHost must have a FrameLayout whose id attribute is 'android.R.id.tabcontent'");
        }
    }

    public void sendAccessibilityEvent(int eventType) {
    }

    public void setup(LocalActivityManager activityGroup) {
        this.setup();
        this.mLocalActivityManager = activityGroup;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        treeObserver.addOnTouchModeChangeListener(this);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        treeObserver.removeOnTouchModeChangeListener(this);
    }

    public void onTouchModeChanged(boolean isInTouchMode) {
        if (!(isInTouchMode || this.mCurrentView == null || this.mCurrentView.hasFocus() && !this.mCurrentView.isFocused())) {
            this.mTabWidget.getChildTabViewAt(this.mCurrentTab).requestFocus();
        }
    }

    public void addTab(TabSpec tabSpec) {
        if (tabSpec.mIndicatorStrategy == null) {
            throw new IllegalArgumentException("you must specify a way to create the tab indicator.");
        }
        if (tabSpec.mContentStrategy == null) {
            throw new IllegalArgumentException("you must specify a way to create the tab content");
        }
        View tabIndicator = tabSpec.mIndicatorStrategy.createIndicatorView();
        tabIndicator.setOnKeyListener(this.mTabKeyListener);
        if (tabSpec.mIndicatorStrategy instanceof ViewIndicatorStrategy) {
            this.mTabWidget.setStripEnabled(false);
        }
        this.mTabWidget.addView(tabIndicator);
        this.mTabSpecs.add(tabSpec);
        if (this.mCurrentTab == -1) {
            this.setCurrentTab(0);
        }
    }

    public void clearAllTabs() {
        this.mTabWidget.removeAllViews();
        this.initTabHost();
        this.mTabContent.removeAllViews();
        this.mTabSpecs.clear();
        this.requestLayout();
        this.invalidate();
    }

    public TabWidget getTabWidget() {
        return this.mTabWidget;
    }

    public int getCurrentTab() {
        return this.mCurrentTab;
    }

    public String getCurrentTabTag() {
        if (this.mCurrentTab >= 0 && this.mCurrentTab < this.mTabSpecs.size()) {
            return this.mTabSpecs.get(this.mCurrentTab).getTag();
        }
        return null;
    }

    public View getCurrentTabView() {
        if (this.mCurrentTab >= 0 && this.mCurrentTab < this.mTabSpecs.size()) {
            return this.mTabWidget.getChildTabViewAt(this.mCurrentTab);
        }
        return null;
    }

    public View getCurrentView() {
        return this.mCurrentView;
    }

    public void setCurrentTabByTag(String tag) {
        for (int i = 0; i < this.mTabSpecs.size(); ++i) {
            if (!this.mTabSpecs.get(i).getTag().equals(tag)) continue;
            this.setCurrentTab(i);
            break;
        }
    }

    public FrameLayout getTabContentView() {
        return this.mTabContent;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean handled = super.dispatchKeyEvent(event);
        if (!handled && event.getAction() == 0 && event.getKeyCode() == 19 && this.mCurrentView != null && this.mCurrentView.isRootNamespace() && this.mCurrentView.hasFocus() && this.mCurrentView.findFocus().focusSearch(33) == null) {
            this.mTabWidget.getChildTabViewAt(this.mCurrentTab).requestFocus();
            this.playSoundEffect(2);
            return true;
        }
        return handled;
    }

    public void dispatchWindowFocusChanged(boolean hasFocus) {
        if (this.mCurrentView != null) {
            this.mCurrentView.dispatchWindowFocusChanged(hasFocus);
        }
    }

    public void setCurrentTab(int index) {
        if (index < 0 || index >= this.mTabSpecs.size()) {
            return;
        }
        if (index == this.mCurrentTab) {
            return;
        }
        if (this.mCurrentTab != -1) {
            this.mTabSpecs.get(this.mCurrentTab).mContentStrategy.tabClosed();
        }
        this.mCurrentTab = index;
        TabSpec spec = this.mTabSpecs.get(index);
        this.mTabWidget.focusCurrentTab(this.mCurrentTab);
        this.mCurrentView = spec.mContentStrategy.getContentView();
        if (this.mCurrentView.getParent() == null) {
            this.mTabContent.addView(this.mCurrentView, new ViewGroup.LayoutParams(-1, -1));
        }
        if (!this.mTabWidget.hasFocus()) {
            this.mCurrentView.requestFocus();
        }
        this.invokeOnTabChangeListener();
    }

    public void setOnTabChangedListener(OnTabChangeListener l) {
        this.mOnTabChangeListener = l;
    }

    public void invokeOnTabChangeListener() {
        if (this.mOnTabChangeListener != null) {
            this.mOnTabChangeListener.onTabChanged(this.getCurrentTabTag());
        }
    }

    public class IntentContentStrategy
    implements ContentStrategy {
        public final String mTag;
        public final Intent mIntent;
        public View mLaunchedView;

        public IntentContentStrategy(String tag, Intent intent) {
            this.mTag = tag;
            this.mIntent = intent;
        }

        public View getContentView() {
            View wd;
            if (TabHost.this.mLocalActivityManager == null) {
                throw new IllegalStateException("Did you forget to call 'public void setup(LocalActivityManager activityGroup)'?");
            }
            Window w = TabHost.this.mLocalActivityManager.startActivity(this.mTag, this.mIntent);
            View view = wd = w != null ? w.getDecorView() : null;
            if (this.mLaunchedView != wd && this.mLaunchedView != null && this.mLaunchedView.getParent() != null) {
                TabHost.this.mTabContent.removeView(this.mLaunchedView);
            }
            this.mLaunchedView = wd;
            if (this.mLaunchedView != null) {
                this.mLaunchedView.setVisibility(0);
                this.mLaunchedView.setFocusableInTouchMode(true);
                ((ViewGroup)this.mLaunchedView).setDescendantFocusability(262144);
            }
            return this.mLaunchedView;
        }

        public void tabClosed() {
            if (this.mLaunchedView != null) {
                this.mLaunchedView.setVisibility(8);
            }
        }

        public /* synthetic */ IntentContentStrategy(String x1, Intent x2, 1 x3) {
            this(x1, x2);
        }
    }

    public class FactoryContentStrategy
    implements ContentStrategy {
        public View mTabContent;
        public final CharSequence mTag;
        public TabContentFactory mFactory;

        public FactoryContentStrategy(CharSequence tag, TabContentFactory factory) {
            this.mTag = tag;
            this.mFactory = factory;
        }

        public View getContentView() {
            if (this.mTabContent == null) {
                this.mTabContent = this.mFactory.createTabContent(((Object)this.mTag).toString());
            }
            this.mTabContent.setVisibility(0);
            return this.mTabContent;
        }

        public void tabClosed() {
            this.mTabContent.setVisibility(8);
        }
    }

    public class ViewIdContentStrategy
    implements ContentStrategy {
        public final View mView;

        public ViewIdContentStrategy(int viewId) {
            this.mView = TabHost.this.mTabContent.findViewById(viewId);
            if (this.mView == null) {
                throw new RuntimeException("Could not create tab content because could not find view with id " + viewId);
            }
            this.mView.setVisibility(8);
        }

        public View getContentView() {
            this.mView.setVisibility(0);
            return this.mView;
        }

        public void tabClosed() {
            this.mView.setVisibility(8);
        }

        public /* synthetic */ ViewIdContentStrategy(int x1, 1 x2) {
            this(x1);
        }
    }

    public class ViewIndicatorStrategy
    implements IndicatorStrategy {
        public final View mView;

        public ViewIndicatorStrategy(View view) {
            this.mView = view;
        }

        public View createIndicatorView() {
            return this.mView;
        }

        public /* synthetic */ ViewIndicatorStrategy(View x1, 1 x2) {
            this(x1);
        }
    }

    public class LabelAndIconIndicatorStrategy
    implements IndicatorStrategy {
        public final CharSequence mLabel;
        public final Drawable mIcon;

        public LabelAndIconIndicatorStrategy(CharSequence label, Drawable icon) {
            this.mLabel = label;
            this.mIcon = icon;
        }

        public View createIndicatorView() {
            Context context = TabHost.this.getContext();
            LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
            View tabIndicator = inflater.inflate(TabHost.this.mTabLayoutId, (ViewGroup)TabHost.this.mTabWidget, false);
            TextView tv = (TextView)tabIndicator.findViewById(16908310);
            tv.setText(this.mLabel);
            ImageView iconView = (ImageView)tabIndicator.findViewById(16908294);
            if (this.mIcon != null) {
                iconView.setImageDrawable(this.mIcon);
                iconView.setVisibility(0);
            }
            if (context.getApplicationInfo().targetSdkVersion <= 4) {
                tabIndicator.setBackgroundResource(17302839);
                tv.setTextColor(context.getResources().getColorStateList(17170538));
            }
            return tabIndicator;
        }

        public /* synthetic */ LabelAndIconIndicatorStrategy(CharSequence x1, Drawable x2, 1 x3) {
            this(x1, x2);
        }
    }

    public class LabelIndicatorStrategy
    implements IndicatorStrategy {
        public final CharSequence mLabel;

        public LabelIndicatorStrategy(CharSequence label) {
            this.mLabel = label;
        }

        public View createIndicatorView() {
            Context context = TabHost.this.getContext();
            LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
            View tabIndicator = inflater.inflate(TabHost.this.mTabLayoutId, (ViewGroup)TabHost.this.mTabWidget, false);
            TextView tv = (TextView)tabIndicator.findViewById(16908310);
            tv.setText(this.mLabel);
            if (context.getApplicationInfo().targetSdkVersion <= 4) {
                tabIndicator.setBackgroundResource(17302839);
                tv.setTextColor(context.getResources().getColorStateList(17170538));
            }
            return tabIndicator;
        }

        public /* synthetic */ LabelIndicatorStrategy(CharSequence x1, 1 x2) {
            this(x1);
        }
    }

    public static interface ContentStrategy {
        public View getContentView();

        public void tabClosed();
    }

    public static interface IndicatorStrategy {
        public View createIndicatorView();
    }

    public class TabSpec {
        public String mTag;
        public IndicatorStrategy mIndicatorStrategy;
        public ContentStrategy mContentStrategy;

        public TabSpec(String tag) {
            this.mTag = tag;
        }

        public TabSpec setIndicator(CharSequence label) {
            this.mIndicatorStrategy = new LabelIndicatorStrategy(label, null);
            return this;
        }

        public TabSpec setIndicator(CharSequence label, Drawable icon) {
            this.mIndicatorStrategy = new LabelAndIconIndicatorStrategy(label, icon, null);
            return this;
        }

        public TabSpec setIndicator(View view) {
            this.mIndicatorStrategy = new ViewIndicatorStrategy(view, null);
            return this;
        }

        public TabSpec setContent(int viewId) {
            this.mContentStrategy = new ViewIdContentStrategy(viewId, null);
            return this;
        }

        public TabSpec setContent(TabContentFactory contentFactory) {
            this.mContentStrategy = new FactoryContentStrategy(this.mTag, contentFactory);
            return this;
        }

        public TabSpec setContent(Intent intent) {
            this.mContentStrategy = new IntentContentStrategy(this.mTag, intent, null);
            return this;
        }

        public String getTag() {
            return this.mTag;
        }

        public /* synthetic */ TabSpec(String x1, 1 x2) {
            this(x1);
        }
    }

    public static interface TabContentFactory {
        public View createTabContent(String var1);
    }

    public static interface OnTabChangeListener {
        public void onTabChanged(String var1);
    }
}

