/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.ActionBar;
import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.ActionMode;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.DecelerateInterpolator;
import android.widget.LinearLayout;
import android.widget.SpinnerAdapter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuPopupHelper;
import com.android.internal.view.menu.SubMenuBuilder;
import com.android.internal.widget.ActionBarContainer;
import com.android.internal.widget.ActionBarContextView;
import com.android.internal.widget.ActionBarView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class ActionBarImpl
extends ActionBar {
    public static final int NORMAL_VIEW = 0;
    public static final int CONTEXT_VIEW = 1;
    public Context mContext;
    public Activity mActivity;
    public Dialog mDialog;
    public ActionBarContainer mContainerView;
    public ActionBarView mActionView;
    public ActionBarContextView mUpperContextView;
    public LinearLayout mLowerContextView;
    public View mContentView;
    public ArrayList<TabImpl> mTabs = new ArrayList();
    public TabImpl mSelectedTab;
    public int mSavedTabPosition = -1;
    public ActionMode mActionMode;
    public boolean mLastMenuVisibility;
    public ArrayList<ActionBar.OnMenuVisibilityListener> mMenuVisibilityListeners = new ArrayList();
    public static final int CONTEXT_DISPLAY_NORMAL = 0;
    public static final int CONTEXT_DISPLAY_SPLIT = 1;
    public static final int INVALID_POSITION = -1;
    public int mContextDisplayMode;
    public final Handler mHandler = new Handler();
    public Animator mCurrentAnim;
    public boolean mShowHideAnimationEnabled;
    public static final TimeInterpolator sFadeOutInterpolator = new DecelerateInterpolator();
    public final Animator.AnimatorListener[] mAfterAnimation = new Animator.AnimatorListener[]{new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            if (ActionBarImpl.this.mLowerContextView != null) {
                ActionBarImpl.this.mLowerContextView.removeAllViews();
            }
            ActionBarImpl.this.mCurrentAnim = null;
            ActionBarImpl.this.hideAllExcept(0);
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }, new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            ActionBarImpl.this.mCurrentAnim = null;
            ActionBarImpl.this.hideAllExcept(1);
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }};
    public final Animator.AnimatorListener mHideListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            if (ActionBarImpl.this.mContentView != null) {
                ActionBarImpl.this.mContentView.setTranslationY(0.0f);
            }
            ActionBarImpl.this.mContainerView.setVisibility(8);
            ActionBarImpl.this.mContainerView.setTransitioning(false);
            ActionBarImpl.this.mCurrentAnim = null;
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };
    public final Animator.AnimatorListener mShowListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            ActionBarImpl.this.mCurrentAnim = null;
            ActionBarImpl.this.mContainerView.requestLayout();
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };

    public ActionBarImpl(Activity activity) {
        this.mActivity = activity;
        Window window = activity.getWindow();
        View decor = window.getDecorView();
        this.init(decor);
        if (!this.mActivity.getWindow().hasFeature(9)) {
            this.mContentView = decor.findViewById(0x1020002);
        }
    }

    public ActionBarImpl(Dialog dialog) {
        this.mDialog = dialog;
        this.init(dialog.getWindow().getDecorView());
    }

    public void init(View decor) {
        this.mContext = decor.getContext();
        this.mActionView = (ActionBarView)decor.findViewById(16908973);
        this.mUpperContextView = (ActionBarContextView)decor.findViewById(16908974);
        this.mLowerContextView = (LinearLayout)decor.findViewById(0x1020200);
        this.mContainerView = (ActionBarContainer)decor.findViewById(16908972);
        if (this.mActionView == null || this.mUpperContextView == null || this.mContainerView == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with a compatible window decor layout");
        }
        this.mActionView.setContextView(this.mUpperContextView);
        this.mContextDisplayMode = this.mLowerContextView == null ? 0 : 1;
    }

    public void setShowHideAnimationEnabled(boolean enabled) {
        this.mShowHideAnimationEnabled = enabled;
        if (!enabled && this.mCurrentAnim != null) {
            this.mCurrentAnim.end();
        }
    }

    public void addOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener listener) {
        this.mMenuVisibilityListeners.add(listener);
    }

    public void removeOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener listener) {
        this.mMenuVisibilityListeners.remove(listener);
    }

    public void dispatchMenuVisibilityChanged(boolean isVisible) {
        if (isVisible == this.mLastMenuVisibility) {
            return;
        }
        this.mLastMenuVisibility = isVisible;
        int count = this.mMenuVisibilityListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mMenuVisibilityListeners.get(i).onMenuVisibilityChanged(isVisible);
        }
    }

    public void setCustomView(int resId) {
        this.setCustomView(LayoutInflater.from(this.mContext).inflate(resId, (ViewGroup)this.mActionView, false));
    }

    public void setDisplayUseLogoEnabled(boolean useLogo) {
        this.setDisplayOptions(useLogo ? 1 : 0, 1);
    }

    public void setDisplayShowHomeEnabled(boolean showHome) {
        this.setDisplayOptions(showHome ? 2 : 0, 2);
    }

    public void setDisplayHomeAsUpEnabled(boolean showHomeAsUp) {
        this.setDisplayOptions(showHomeAsUp ? 4 : 0, 4);
    }

    public void setDisplayShowTitleEnabled(boolean showTitle) {
        this.setDisplayOptions(showTitle ? 8 : 0, 8);
    }

    public void setDisplayShowCustomEnabled(boolean showCustom) {
        this.setDisplayOptions(showCustom ? 16 : 0, 16);
    }

    public void setTitle(int resId) {
        this.setTitle(this.mContext.getString(resId));
    }

    public void setSubtitle(int resId) {
        this.setSubtitle(this.mContext.getString(resId));
    }

    public void setSelectedNavigationItem(int position) {
        switch (this.mActionView.getNavigationMode()) {
            case 2: {
                this.selectTab(this.mTabs.get(position));
                break;
            }
            case 1: {
                this.mActionView.setDropdownSelectedPosition(position);
                break;
            }
            default: {
                throw new IllegalStateException("setSelectedNavigationIndex not valid for current navigation mode");
            }
        }
    }

    public void removeAllTabs() {
        this.cleanupTabs();
    }

    public void cleanupTabs() {
        if (this.mSelectedTab != null) {
            this.selectTab(null);
        }
        this.mTabs.clear();
        this.mActionView.removeAllTabs();
        this.mSavedTabPosition = -1;
    }

    public void setTitle(CharSequence title) {
        this.mActionView.setTitle(title);
    }

    public void setSubtitle(CharSequence subtitle) {
        this.mActionView.setSubtitle(subtitle);
    }

    public void setDisplayOptions(int options) {
        this.mActionView.setDisplayOptions(options);
    }

    public void setDisplayOptions(int options, int mask) {
        int current = this.mActionView.getDisplayOptions();
        this.mActionView.setDisplayOptions(options & mask | current & ~mask);
    }

    public void setBackgroundDrawable(Drawable d) {
        this.mContainerView.setBackgroundDrawable(d);
    }

    public View getCustomView() {
        return this.mActionView.getCustomNavigationView();
    }

    public CharSequence getTitle() {
        return this.mActionView.getTitle();
    }

    public CharSequence getSubtitle() {
        return this.mActionView.getSubtitle();
    }

    public int getNavigationMode() {
        return this.mActionView.getNavigationMode();
    }

    public int getDisplayOptions() {
        return this.mActionView.getDisplayOptions();
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
        }
        this.mUpperContextView.killMode();
        ActionModeImpl mode = new ActionModeImpl(callback);
        if (callback.onCreateActionMode(mode, ((ActionMode)mode).getMenu())) {
            ((ActionMode)mode).invalidate();
            this.mUpperContextView.initForMode(mode);
            this.animateTo(1);
            if (this.mLowerContextView != null) {
                this.mLowerContextView.setVisibility(0);
            }
            this.mActionMode = mode;
            this.show();
            return mode;
        }
        return null;
    }

    public void configureTab(ActionBar.Tab tab, int position) {
        TabImpl tabi = (TabImpl)tab;
        ActionBar.TabListener callback = tabi.getCallback();
        if (callback == null) {
            throw new IllegalStateException("Action Bar Tab must have a Callback");
        }
        tabi.setPosition(position);
        this.mTabs.add(position, tabi);
        int count = this.mTabs.size();
        for (int i = position + 1; i < count; ++i) {
            this.mTabs.get(i).setPosition(i);
        }
    }

    public void addTab(ActionBar.Tab tab) {
        this.addTab(tab, this.mTabs.isEmpty());
    }

    public void addTab(ActionBar.Tab tab, int position) {
        this.addTab(tab, position, this.mTabs.isEmpty());
    }

    public void addTab(ActionBar.Tab tab, boolean setSelected) {
        this.mActionView.addTab(tab, setSelected);
        this.configureTab(tab, this.mTabs.size());
        if (setSelected) {
            this.selectTab(tab);
        }
    }

    public void addTab(ActionBar.Tab tab, int position, boolean setSelected) {
        this.mActionView.addTab(tab, position, setSelected);
        this.configureTab(tab, position);
        if (setSelected) {
            this.selectTab(tab);
        }
    }

    public ActionBar.Tab newTab() {
        return new TabImpl();
    }

    public void removeTab(ActionBar.Tab tab) {
        this.removeTabAt(tab.getPosition());
    }

    public void removeTabAt(int position) {
        int selectedTabPosition = this.mSelectedTab != null ? this.mSelectedTab.getPosition() : this.mSavedTabPosition;
        this.mActionView.removeTabAt(position);
        this.mTabs.remove(position);
        int newTabCount = this.mTabs.size();
        for (int i = position; i < newTabCount; ++i) {
            this.mTabs.get(i).setPosition(i);
        }
        if (selectedTabPosition == position) {
            this.selectTab(this.mTabs.isEmpty() ? null : this.mTabs.get(Math.max(0, position - 1)));
        }
    }

    public void selectTab(ActionBar.Tab tab) {
        if (this.getNavigationMode() != 2) {
            this.mSavedTabPosition = tab != null ? tab.getPosition() : -1;
            return;
        }
        FragmentTransaction trans = this.mActivity.getFragmentManager().beginTransaction().disallowAddToBackStack();
        if (this.mSelectedTab == tab) {
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabReselected(this.mSelectedTab, trans);
            }
        } else {
            this.mActionView.setTabSelected(tab != null ? tab.getPosition() : -1);
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabUnselected(this.mSelectedTab, trans);
            }
            this.mSelectedTab = (TabImpl)tab;
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabSelected(this.mSelectedTab, trans);
            }
        }
        if (!trans.isEmpty()) {
            trans.commit();
        }
    }

    public ActionBar.Tab getSelectedTab() {
        return this.mSelectedTab;
    }

    public int getHeight() {
        return this.mActionView.getHeight();
    }

    public void show() {
        if (this.mCurrentAnim != null) {
            this.mCurrentAnim.end();
        }
        if (this.mContainerView.getVisibility() == 0) {
            return;
        }
        this.mContainerView.setVisibility(0);
        if (this.mShowHideAnimationEnabled) {
            this.mContainerView.setAlpha(0.0f);
            AnimatorSet anim2 = new AnimatorSet();
            AnimatorSet.Builder b = anim2.play(ObjectAnimator.ofFloat(this.mContainerView, "alpha", 1.0f));
            if (this.mContentView != null) {
                b.with(ObjectAnimator.ofFloat(this.mContentView, "translationY", -this.mContainerView.getHeight(), 0.0f));
                this.mContainerView.setTranslationY(-this.mContainerView.getHeight());
                b.with(ObjectAnimator.ofFloat(this.mContainerView, "translationY", 0.0f));
            }
            anim2.addListener(this.mShowListener);
            this.mCurrentAnim = anim2;
            anim2.start();
        } else {
            this.mShowListener.onAnimationEnd(null);
        }
    }

    public void hide() {
        if (this.mCurrentAnim != null) {
            this.mCurrentAnim.end();
        }
        if (this.mContainerView.getVisibility() == 8) {
            return;
        }
        if (this.mShowHideAnimationEnabled) {
            this.mContainerView.setAlpha(1.0f);
            this.mContainerView.setTransitioning(true);
            AnimatorSet anim2 = new AnimatorSet();
            AnimatorSet.Builder b = anim2.play(ObjectAnimator.ofFloat(this.mContainerView, "alpha", 0.0f));
            if (this.mContentView != null) {
                b.with(ObjectAnimator.ofFloat(this.mContentView, "translationY", 0.0f, -this.mContainerView.getHeight()));
                b.with(ObjectAnimator.ofFloat(this.mContainerView, "translationY", -this.mContainerView.getHeight()));
            }
            anim2.addListener(this.mHideListener);
            this.mCurrentAnim = anim2;
            anim2.start();
        } else {
            this.mHideListener.onAnimationEnd(null);
        }
    }

    public boolean isShowing() {
        return this.mContainerView.getVisibility() == 0;
    }

    public long animateTo(int viewIndex) {
        this.show();
        AnimatorSet set = new AnimatorSet();
        View targetChild = this.mContainerView.getChildAt(viewIndex);
        targetChild.setVisibility(0);
        AnimatorSet.Builder b = set.play(ObjectAnimator.ofFloat(targetChild, "alpha", 1.0f));
        int count = this.mContainerView.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.mContainerView.getChildAt(i);
            if (i == viewIndex || child.getVisibility() == 8) continue;
            ObjectAnimator a = ObjectAnimator.ofFloat(child, "alpha", 0.0f);
            ((Animator)a).setInterpolator(sFadeOutInterpolator);
            b.with(a);
        }
        set.addListener(this.mAfterAnimation[viewIndex]);
        this.mCurrentAnim = set;
        set.start();
        return set.getDuration();
    }

    public void hideAllExcept(int viewIndex) {
        int count = this.mContainerView.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.mContainerView.getChildAt(i).setVisibility(i == viewIndex ? 0 : 8);
        }
    }

    public void setCustomView(View view) {
        this.mActionView.setCustomNavigationView(view);
    }

    public void setCustomView(View view, ActionBar.LayoutParams layoutParams) {
        view.setLayoutParams(layoutParams);
        this.mActionView.setCustomNavigationView(view);
    }

    public void setListNavigationCallbacks(SpinnerAdapter adapter, ActionBar.OnNavigationListener callback) {
        this.mActionView.setDropdownAdapter(adapter);
        this.mActionView.setCallback(callback);
    }

    public int getSelectedNavigationIndex() {
        switch (this.mActionView.getNavigationMode()) {
            case 2: {
                return this.mSelectedTab != null ? this.mSelectedTab.getPosition() : -1;
            }
            case 1: {
                return this.mActionView.getDropdownSelectedPosition();
            }
        }
        return -1;
    }

    public int getNavigationItemCount() {
        switch (this.mActionView.getNavigationMode()) {
            case 2: {
                return this.mTabs.size();
            }
            case 1: {
                SpinnerAdapter adapter = this.mActionView.getDropdownAdapter();
                return adapter != null ? adapter.getCount() : 0;
            }
        }
        return 0;
    }

    public int getTabCount() {
        return this.mTabs.size();
    }

    public void setNavigationMode(int mode) {
        int oldMode = this.mActionView.getNavigationMode();
        switch (oldMode) {
            case 2: {
                this.mSavedTabPosition = this.getSelectedNavigationIndex();
                this.selectTab(null);
            }
        }
        this.mActionView.setNavigationMode(mode);
        switch (mode) {
            case 2: {
                if (this.mSavedTabPosition == -1) break;
                this.setSelectedNavigationItem(this.mSavedTabPosition);
                this.mSavedTabPosition = -1;
            }
        }
    }

    public ActionBar.Tab getTabAt(int index) {
        return this.mTabs.get(index);
    }

    public class SwitchSelectedTabViewFragment
    extends Fragment {
        public int mSelectedTabIndex;

        public SwitchSelectedTabViewFragment(int oldSelectedTab) {
            this.mSelectedTabIndex = oldSelectedTab;
        }

        public void onDetach() {
            if (this.mSelectedTabIndex >= 0 && this.mSelectedTabIndex < ActionBarImpl.this.getTabCount()) {
                ActionBarImpl.this.mActionView.setTabSelected(this.mSelectedTabIndex);
            }
        }
    }

    public class TabImpl
    extends ActionBar.Tab {
        public ActionBar.TabListener mCallback;
        public Object mTag;
        public Drawable mIcon;
        public CharSequence mText;
        public int mPosition;
        public View mCustomView;

        public Object getTag() {
            return this.mTag;
        }

        public ActionBar.Tab setTag(Object tag) {
            this.mTag = tag;
            return this;
        }

        public ActionBar.TabListener getCallback() {
            return this.mCallback;
        }

        public ActionBar.Tab setTabListener(ActionBar.TabListener callback) {
            this.mCallback = callback;
            return this;
        }

        public View getCustomView() {
            return this.mCustomView;
        }

        public ActionBar.Tab setCustomView(View view) {
            this.mCustomView = view;
            return this;
        }

        public ActionBar.Tab setCustomView(int layoutResId) {
            return this.setCustomView(LayoutInflater.from(ActionBarImpl.this.mContext).inflate(layoutResId, null));
        }

        public Drawable getIcon() {
            return this.mIcon;
        }

        public int getPosition() {
            return this.mPosition;
        }

        public void setPosition(int position) {
            this.mPosition = position;
        }

        public CharSequence getText() {
            return this.mText;
        }

        public ActionBar.Tab setIcon(Drawable icon) {
            this.mIcon = icon;
            return this;
        }

        public ActionBar.Tab setIcon(int resId) {
            return this.setIcon(ActionBarImpl.this.mContext.getResources().getDrawable(resId));
        }

        public ActionBar.Tab setText(CharSequence text) {
            this.mText = text;
            return this;
        }

        public ActionBar.Tab setText(int resId) {
            return this.setText(ActionBarImpl.this.mContext.getResources().getText(resId));
        }

        public void select() {
            ActionBarImpl.this.selectTab(this);
        }
    }

    public class ActionModeImpl
    extends ActionMode
    implements MenuBuilder.Callback {
        public ActionMode.Callback mCallback;
        public MenuBuilder mMenu;
        public WeakReference<View> mCustomView;

        public ActionModeImpl(ActionMode.Callback callback) {
            this.mCallback = callback;
            this.mMenu = new MenuBuilder(ActionBarImpl.this.mActionView.getContext()).setDefaultShowAsAction(1);
            this.mMenu.setCallback(this);
        }

        public MenuInflater getMenuInflater() {
            return new MenuInflater(ActionBarImpl.this.mContext);
        }

        public Menu getMenu() {
            return this.mMenu;
        }

        public void finish() {
            if (ActionBarImpl.this.mActionMode != this) {
                return;
            }
            this.mCallback.onDestroyActionMode(this);
            this.mCallback = null;
            ActionBarImpl.this.animateTo(0);
            ActionBarImpl.this.mUpperContextView.closeMode();
            if (ActionBarImpl.this.mLowerContextView != null && ActionBarImpl.this.mLowerContextView.getVisibility() != 8) {
                ActionBarImpl.this.mLowerContextView.setVisibility(8);
            }
            ActionBarImpl.this.mActionMode = null;
        }

        public void invalidate() {
            if (this.mCallback.onPrepareActionMode(this, this.mMenu)) {
                // empty if block
            }
        }

        public void setCustomView(View view) {
            ActionBarImpl.this.mUpperContextView.setCustomView(view);
            this.mCustomView = new WeakReference<View>(view);
        }

        public void setSubtitle(CharSequence subtitle) {
            ActionBarImpl.this.mUpperContextView.setSubtitle(subtitle);
        }

        public void setTitle(CharSequence title) {
            ActionBarImpl.this.mUpperContextView.setTitle(title);
        }

        public void setTitle(int resId) {
            this.setTitle(ActionBarImpl.this.mContext.getResources().getString(resId));
        }

        public void setSubtitle(int resId) {
            this.setSubtitle(ActionBarImpl.this.mContext.getResources().getString(resId));
        }

        public CharSequence getTitle() {
            return ActionBarImpl.this.mUpperContextView.getTitle();
        }

        public CharSequence getSubtitle() {
            return ActionBarImpl.this.mUpperContextView.getSubtitle();
        }

        public View getCustomView() {
            return this.mCustomView != null ? (View)this.mCustomView.get() : null;
        }

        public boolean onMenuItemSelected(MenuBuilder menu2, MenuItem item) {
            if (this.mCallback != null) {
                return this.mCallback.onActionItemClicked(this, item);
            }
            return false;
        }

        public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        }

        public boolean onSubMenuSelected(SubMenuBuilder subMenu) {
            if (this.mCallback == null) {
                return false;
            }
            if (!subMenu.hasVisibleItems()) {
                return true;
            }
            new MenuPopupHelper(ActionBarImpl.this.mContext, subMenu).show();
            return true;
        }

        public void onCloseSubMenu(SubMenuBuilder menu2) {
        }

        public void onMenuModeChange(MenuBuilder menu2) {
            if (this.mCallback == null) {
                return;
            }
            this.invalidate();
            ActionBarImpl.this.mUpperContextView.openOverflowMenu();
        }
    }
}

