/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;

public class HandlerCaller {
    public static final String TAG = "HandlerCaller";
    public static final boolean DEBUG = false;
    public final Context mContext;
    public final Looper mMainLooper;
    public final Handler mH;
    public final Callback mCallback;
    public static final int ARGS_POOL_MAX_SIZE = 10;
    public int mArgsPoolSize;
    public SomeArgs mArgsPool;

    public HandlerCaller(Context context, Callback callback) {
        this.mContext = context;
        this.mMainLooper = context.getMainLooper();
        this.mH = new MyHandler(this.mMainLooper);
        this.mCallback = callback;
    }

    public HandlerCaller(Context context, Looper looper, Callback callback) {
        this.mContext = context;
        this.mMainLooper = looper;
        this.mH = new MyHandler(this.mMainLooper);
        this.mCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SomeArgs obtainArgs() {
        Handler handler = this.mH;
        synchronized (handler) {
            SomeArgs args = this.mArgsPool;
            if (args != null) {
                this.mArgsPool = args.next;
                args.next = null;
                --this.mArgsPoolSize;
                return args;
            }
        }
        return new SomeArgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycleArgs(SomeArgs args) {
        Handler handler = this.mH;
        synchronized (handler) {
            if (this.mArgsPoolSize < 10) {
                args.next = this.mArgsPool;
                this.mArgsPool = args;
                ++this.mArgsPoolSize;
            }
        }
    }

    public void executeOrSendMessage(Message msg) {
        if (Looper.myLooper() == this.mMainLooper) {
            this.mCallback.executeMessage(msg);
            msg.recycle();
            return;
        }
        this.mH.sendMessage(msg);
    }

    public boolean hasMessages(int what) {
        return this.mH.hasMessages(what);
    }

    public void removeMessages(int what) {
        this.mH.removeMessages(what);
    }

    public void removeMessages(int what, Object obj) {
        this.mH.removeMessages(what, obj);
    }

    public void sendMessage(Message msg) {
        this.mH.sendMessage(msg);
    }

    public Message obtainMessage(int what) {
        return this.mH.obtainMessage(what);
    }

    public Message obtainMessageBO(int what, boolean arg1, Object arg2) {
        return this.mH.obtainMessage(what, arg1 ? 1 : 0, 0, arg2);
    }

    public Message obtainMessageBOO(int what, boolean arg1, Object arg2, Object arg3) {
        SomeArgs args = this.obtainArgs();
        args.arg1 = arg2;
        args.arg2 = arg3;
        return this.mH.obtainMessage(what, arg1 ? 1 : 0, 0, args);
    }

    public Message obtainMessageO(int what, Object arg1) {
        return this.mH.obtainMessage(what, 0, 0, arg1);
    }

    public Message obtainMessageI(int what, int arg1) {
        return this.mH.obtainMessage(what, arg1, 0);
    }

    public Message obtainMessageII(int what, int arg1, int arg2) {
        return this.mH.obtainMessage(what, arg1, arg2);
    }

    public Message obtainMessageIO(int what, int arg1, Object arg2) {
        return this.mH.obtainMessage(what, arg1, 0, arg2);
    }

    public Message obtainMessageIIO(int what, int arg1, int arg2, Object arg3) {
        return this.mH.obtainMessage(what, arg1, arg2, arg3);
    }

    public Message obtainMessageIIOO(int what, int arg1, int arg2, Object arg3, Object arg4) {
        SomeArgs args = this.obtainArgs();
        args.arg1 = arg3;
        args.arg2 = arg4;
        return this.mH.obtainMessage(what, arg1, arg2, args);
    }

    public Message obtainMessageIOO(int what, int arg1, Object arg2, Object arg3) {
        SomeArgs args = this.obtainArgs();
        args.arg1 = arg2;
        args.arg2 = arg3;
        return this.mH.obtainMessage(what, arg1, 0, args);
    }

    public Message obtainMessageOO(int what, Object arg1, Object arg2) {
        SomeArgs args = this.obtainArgs();
        args.arg1 = arg1;
        args.arg2 = arg2;
        return this.mH.obtainMessage(what, 0, 0, args);
    }

    public Message obtainMessageOOO(int what, Object arg1, Object arg2, Object arg3) {
        SomeArgs args = this.obtainArgs();
        args.arg1 = arg1;
        args.arg2 = arg2;
        args.arg3 = arg3;
        return this.mH.obtainMessage(what, 0, 0, args);
    }

    public Message obtainMessageOOOO(int what, Object arg1, Object arg2, Object arg3, Object arg4) {
        SomeArgs args = this.obtainArgs();
        args.arg1 = arg1;
        args.arg2 = arg2;
        args.arg3 = arg3;
        args.arg4 = arg4;
        return this.mH.obtainMessage(what, 0, 0, args);
    }

    public Message obtainMessageIIII(int what, int arg1, int arg2, int arg3, int arg4) {
        SomeArgs args = this.obtainArgs();
        args.argi1 = arg1;
        args.argi2 = arg2;
        args.argi3 = arg3;
        args.argi4 = arg4;
        return this.mH.obtainMessage(what, 0, 0, args);
    }

    public Message obtainMessageIIIIII(int what, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {
        SomeArgs args = this.obtainArgs();
        args.argi1 = arg1;
        args.argi2 = arg2;
        args.argi3 = arg3;
        args.argi4 = arg4;
        args.argi5 = arg5;
        args.argi6 = arg6;
        return this.mH.obtainMessage(what, 0, 0, args);
    }

    public Message obtainMessageIIIIO(int what, int arg1, int arg2, int arg3, int arg4, Object arg5) {
        SomeArgs args = this.obtainArgs();
        args.arg1 = arg5;
        args.argi1 = arg1;
        args.argi2 = arg2;
        args.argi3 = arg3;
        args.argi4 = arg4;
        return this.mH.obtainMessage(what, 0, 0, args);
    }

    public static interface Callback {
        public void executeMessage(Message var1);
    }

    public class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            HandlerCaller.this.mCallback.executeMessage(msg);
        }
    }

    public static class SomeArgs {
        public SomeArgs next;
        public Object arg1;
        public Object arg2;
        public Object arg3;
        public Object arg4;
        public int argi1;
        public int argi2;
        public int argi3;
        public int argi4;
        public int argi5;
        public int argi6;
    }
}

