/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.net.LinkAddress;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.text.TextUtils;
import com.android.internal.telephony.ApnSetting;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.EventLogTags;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.RetryManager;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;

public abstract class DataConnection
extends HierarchicalStateMachine {
    public static final boolean DBG = true;
    public static Object mCountLock = new Object();
    public static int mCount;
    public static final int EVENT_RESET = 1;
    public static final int EVENT_CONNECT = 2;
    public static final int EVENT_SETUP_DATA_CONNECTION_DONE = 3;
    public static final int EVENT_GET_LAST_FAIL_DONE = 4;
    public static final int EVENT_DEACTIVATE_DONE = 5;
    public static final int EVENT_DISCONNECT = 6;
    public static final int EVENT_LOG_BAD_DNS_ADDRESS = 50100;
    public int mId;
    public int mTag;
    public PhoneBase phone;
    public RetryManager mRetryMgr;
    public int cid;
    public LinkProperties mLinkProperties = new LinkProperties();
    public LinkCapabilities mCapabilities = new LinkCapabilities();
    public long createTime;
    public long lastFailTime;
    public FailCause lastFailCause;
    public static final String NULL_IP = "0.0.0.0";
    public Object userData;
    public DcDefaultState mDefaultState = new DcDefaultState(null);
    public DcInactiveState mInactiveState = new DcInactiveState(null);
    public DcActivatingState mActivatingState = new DcActivatingState(null);
    public DcActiveState mActiveState = new DcActiveState(null);
    public DcDisconnectingState mDisconnectingState = new DcDisconnectingState(null);
    public DcDisconnectionErrorCreatingConnection mDisconnectingErrorCreatingConnection = new DcDisconnectionErrorCreatingConnection(null);

    public abstract String toString();

    public abstract void onConnect(ConnectionParams var1);

    public abstract boolean isDnsOk(String[] var1);

    public abstract void log(String var1);

    public DataConnection(PhoneBase phone, String name, RetryManager rm) {
        super(name);
        this.log("DataConnection constructor E");
        this.phone = phone;
        this.mRetryMgr = rm;
        this.cid = -1;
        this.clearSettings();
        this.setDbg(false);
        this.addState(this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mActivatingState, this.mDefaultState);
        this.addState(this.mActiveState, this.mDefaultState);
        this.addState(this.mDisconnectingState, this.mDefaultState);
        this.addState(this.mDisconnectingErrorCreatingConnection, this.mDefaultState);
        this.setInitialState(this.mInactiveState);
        this.log("DataConnection constructor X");
    }

    public void tearDownData(Object o) {
        int discReason = 0;
        if (o != null && o instanceof DisconnectParams) {
            String reason;
            DisconnectParams dp = (DisconnectParams)o;
            Message m = dp.onCompletedMsg;
            if (m != null && m.obj != null && m.obj instanceof String && TextUtils.equals(reason = (String)m.obj, "radioTurnedOff")) {
                discReason = 1;
            }
        }
        if (this.phone.mCM.getRadioState().isOn()) {
            this.log("tearDownData radio is on, call deactivateDataCall");
            this.phone.mCM.deactivateDataCall(this.cid, discReason, this.obtainMessage(5, o));
        } else {
            this.log("tearDownData radio is off sendMessage EVENT_DEACTIVATE_DONE immediately");
            AsyncResult ar = new AsyncResult(o, null, null);
            this.sendMessage(this.obtainMessage(5, ar));
        }
    }

    public void notifyConnectCompleted(ConnectionParams cp, FailCause cause) {
        Message connectionCompletedMsg = cp.onCompletedMsg;
        if (connectionCompletedMsg == null) {
            return;
        }
        long timeStamp = System.currentTimeMillis();
        connectionCompletedMsg.arg1 = this.cid;
        if (cause == FailCause.NONE) {
            this.createTime = timeStamp;
            AsyncResult.forMessage(connectionCompletedMsg);
        } else {
            this.lastFailCause = cause;
            this.lastFailTime = timeStamp;
            AsyncResult.forMessage(connectionCompletedMsg, (Object)cause, new Exception());
        }
        this.log("notifyConnection at " + timeStamp + " cause=" + (Object)((Object)cause));
        connectionCompletedMsg.sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDisconnectCompleted(DisconnectParams dp) {
        this.log("NotifyDisconnectCompleted");
        if (dp.onCompletedMsg != null) {
            Message msg = dp.onCompletedMsg;
            this.log(String.format("msg=%s msg.obj=%s", msg.toString(), msg.obj instanceof String ? (String)msg.obj : "<no-reason>"));
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
        if (dp.lockObj != null) {
            ResetSynchronouslyLock resetSynchronouslyLock = dp.lockObj;
            synchronized (resetSynchronouslyLock) {
                dp.lockObj.notify();
            }
        }
        this.clearSettings();
    }

    public RetryManager getRetryMgr() {
        return this.mRetryMgr;
    }

    public void clearSettings() {
        this.log("clearSettings");
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = FailCause.NONE;
        this.mLinkProperties = new LinkProperties();
    }

    public SetupResult onSetupConnectionCompleted(AsyncResult ar) {
        SetupResult result;
        DataCallState response = (DataCallState)ar.result;
        ConnectionParams cp = (ConnectionParams)ar.userObj;
        if (ar.exception != null) {
            this.log("onSetupConnectionCompleted failed, ar.exception=" + ar.exception + " response=" + response);
            if (ar.exception instanceof CommandException && ((CommandException)ar.exception).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE) {
                result = SetupResult.ERR_BadCommand;
                result.mFailCause = FailCause.RADIO_NOT_AVAILABLE;
            } else if (response == null || response.version < 4) {
                result = SetupResult.ERR_GetLastErrorFromRil;
            } else {
                result = SetupResult.ERR_RilError;
                result.mFailCause = FailCause.fromInt(response.status);
            }
        } else if (cp.tag != this.mTag) {
            this.log("BUG: onSetupConnectionCompleted is stale cp.tag=" + cp.tag + ", mtag=" + this.mTag);
            result = SetupResult.ERR_Stale;
        } else {
            this.log("onSetupConnectionCompleted received DataCallState: " + response);
            LinkProperties linkProperties = new LinkProperties();
            if (response.status == FailCause.NONE.getErrorCode()) {
                String propertyPrefix = "net." + response.ifname + ".";
                try {
                    InetAddress ia;
                    this.cid = response.cid;
                    linkProperties.setInterfaceName(response.ifname);
                    if (response.addresses != null && response.addresses.length > 0) {
                        for (String addr : response.addresses) {
                            InetAddress ia2;
                            int addrPrefixLen;
                            String[] ap = addr.split("/");
                            if (ap.length == 2) {
                                addr = ap[0];
                                addrPrefixLen = Integer.parseInt(ap[1]);
                            } else {
                                addrPrefixLen = 0;
                            }
                            try {
                                ia2 = NetworkUtils.numericToInetAddress(addr);
                            }
                            catch (IllegalArgumentException e) {
                                EventLogTags.writeBadIpAddress(addr);
                                throw new UnknownHostException("Non-numeric ip addr=" + addr);
                            }
                            if (addrPrefixLen == 0) {
                                addrPrefixLen = ia2 instanceof Inet4Address ? 32 : 128;
                            }
                            this.log("addr/pl=" + addr + "/" + addrPrefixLen);
                            LinkAddress la = new LinkAddress(ia2, addrPrefixLen);
                            linkProperties.addLinkAddress(la);
                        }
                    } else {
                        EventLogTags.writeBadIpAddress("no address for ifname=" + response.ifname);
                        throw new UnknownHostException("no address for ifname=" + response.ifname);
                    }
                    if (response.dnses != null && response.dnses.length > 0) {
                        for (String addr : response.dnses) {
                            try {
                                ia = NetworkUtils.numericToInetAddress(addr);
                            }
                            catch (IllegalArgumentException e) {
                                EventLogTags.writePdpBadDnsAddress("dns=" + addr);
                                throw new UnknownHostException("Non-numeric dns addr=" + addr);
                            }
                            linkProperties.addDns(ia);
                        }
                        result = SetupResult.SUCCESS;
                    } else {
                        String[] dnsServers = new String[]{SystemProperties.get(propertyPrefix + "dns1"), SystemProperties.get(propertyPrefix + "dns2")};
                        if (this.isDnsOk(dnsServers)) {
                            for (String dnsAddr : dnsServers) {
                                InetAddress ia3;
                                try {
                                    ia3 = NetworkUtils.numericToInetAddress(dnsAddr);
                                }
                                catch (IllegalArgumentException e) {
                                    EventLogTags.writePdpBadDnsAddress("dnsAddr=" + dnsAddr);
                                    throw new UnknownHostException("Non-numeric dns addr=" + dnsAddr);
                                }
                                linkProperties.addDns(ia3);
                            }
                            result = SetupResult.SUCCESS;
                        } else {
                            StringBuilder sb = new StringBuilder();
                            for (String dnsAddr : dnsServers) {
                                sb.append(dnsAddr);
                                sb.append(" ");
                            }
                            EventLogTags.writePdpBadDnsAddress("Unacceptable dns addresses=" + sb);
                            throw new UnknownHostException("Unacceptable dns addresses=" + sb);
                        }
                    }
                    if (response.gateways == null || response.gateways.length == 0) {
                        String gateways = SystemProperties.get(propertyPrefix + "gw");
                        response.gateways = gateways != null ? gateways.split(" ") : new String[0];
                    }
                    for (String addr : response.gateways) {
                        try {
                            ia = NetworkUtils.numericToInetAddress(addr);
                        }
                        catch (IllegalArgumentException e) {
                            EventLogTags.writePdpBadDnsAddress("gateway=" + addr);
                            throw new UnknownHostException("Non-numeric gateway addr=" + addr);
                        }
                        linkProperties.addGateway(ia);
                    }
                    result = SetupResult.SUCCESS;
                }
                catch (UnknownHostException e) {
                    this.log("onSetupCompleted: UnknownHostException " + e);
                    e.printStackTrace();
                    result = SetupResult.ERR_UnacceptableParameter;
                }
            } else {
                result = response.version < 4 ? SetupResult.ERR_GetLastErrorFromRil : SetupResult.ERR_RilError;
            }
            if (result != SetupResult.SUCCESS) {
                this.log("onSetupConnectionCompleted with an error, clearing LinkProperties");
                linkProperties.clear();
            }
            this.mLinkProperties = linkProperties;
        }
        this.log("onSetupConnectionCompleted: DataConnection setup result='" + (Object)((Object)result) + "' on cid=" + this.cid);
        if (result == SetupResult.SUCCESS) {
            this.log("onSetupConnectionCompleted: LinkProperties: " + this.mLinkProperties.toString());
        }
        return result;
    }

    public void reset(Message onCompletedMsg) {
        this.sendMessage(this.obtainMessage(1, new DisconnectParams(onCompletedMsg)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSynchronously() {
        ResetSynchronouslyLock lockObj;
        ResetSynchronouslyLock resetSynchronouslyLock = lockObj = new ResetSynchronouslyLock();
        synchronized (resetSynchronouslyLock) {
            this.sendMessage(this.obtainMessage(1, new DisconnectParams(lockObj)));
            try {
                lockObj.wait();
            }
            catch (InterruptedException e) {
                this.log("blockingReset: unexpected interrupted of wait()");
            }
        }
    }

    public void connect(Message onCompletedMsg, ApnSetting apn) {
        this.sendMessage(this.obtainMessage(2, new ConnectionParams(apn, onCompletedMsg)));
    }

    public void connect(Message onCompletedMsg) {
        this.sendMessage(this.obtainMessage(2, new ConnectionParams(null, onCompletedMsg)));
    }

    public void disconnect(Message onCompletedMsg) {
        this.sendMessage(this.obtainMessage(6, new DisconnectParams(onCompletedMsg)));
    }

    public boolean isInactive() {
        boolean retVal = this.getCurrentState() == this.mInactiveState;
        return retVal;
    }

    public boolean isActive() {
        boolean retVal = this.getCurrentState() == this.mActiveState;
        return retVal;
    }

    public int getDataConnectionId() {
        return this.mId;
    }

    public LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public LinkCapabilities getLinkCapabilities() {
        return new LinkCapabilities(this.mCapabilities);
    }

    public String getStateAsString() {
        String retVal = this.getCurrentState().getName();
        return retVal;
    }

    public long getConnectionTime() {
        return this.createTime;
    }

    public long getLastFailTime() {
        return this.lastFailTime;
    }

    public FailCause getLastFailCause() {
        return this.lastFailCause;
    }

    public class DcDisconnectionErrorCreatingConnection
    extends HierarchicalState {
        public DcDisconnectionErrorCreatingConnection() {
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 5: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    if (cp.tag == DataConnection.this.mTag) {
                        DataConnection.this.log("DcDisconnectionErrorCreatingConnection msg.what=EVENT_DEACTIVATE_DONE");
                        DataConnection.this.mInactiveState.setEnterNotificationParams(cp, FailCause.UNACCEPTABLE_NETWORK_PARAMETER);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcDisconnectionErrorCreatingConnection EVENT_DEACTIVATE_DONE stale dp.tag=" + cp.tag + ", mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcDisconnectionErrorCreatingConnection not handled msg.what=" + msg.what);
                    retVal = false;
                }
            }
            return retVal;
        }

        public /* synthetic */ DcDisconnectionErrorCreatingConnection(1 x1) {
            this();
        }
    }

    public class DcDisconnectingState
    extends HierarchicalState {
        public DcDisconnectingState() {
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 5: {
                    DataConnection.this.log("DcDisconnectingState msg.what=EVENT_DEACTIVATE_DONE");
                    AsyncResult ar = (AsyncResult)msg.obj;
                    DisconnectParams dp = (DisconnectParams)ar.userObj;
                    if (dp.tag == DataConnection.this.mTag) {
                        DataConnection.this.mInactiveState.setEnterNotificationParams((DisconnectParams)ar.userObj);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcDisconnectState EVENT_DEACTIVATE_DONE stale dp.tag=" + dp.tag + " mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcDisconnectingState not handled msg.what=" + msg.what);
                    retVal = false;
                }
            }
            return retVal;
        }

        public /* synthetic */ DcDisconnectingState(1 x1) {
            this();
        }
    }

    public class DcActiveState
    extends HierarchicalState {
        public ConnectionParams mConnectionParams = null;
        public FailCause mFailCause = null;

        public DcActiveState() {
        }

        public void setEnterNotificationParams(ConnectionParams cp, FailCause cause) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams cp,cause");
            this.mConnectionParams = cp;
            this.mFailCause = cause;
        }

        public void enter() {
            if (this.mConnectionParams != null && this.mFailCause != null) {
                DataConnection.this.log("DcActiveState: enter notifyConnectCompleted");
                DataConnection.this.notifyConnectCompleted(this.mConnectionParams, this.mFailCause);
            }
        }

        public void exit() {
            this.mConnectionParams = null;
            this.mFailCause = null;
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 6: {
                    DataConnection.this.log("DcActiveState msg.what=EVENT_DISCONNECT");
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    dp.tag = DataConnection.this.mTag;
                    DataConnection.this.tearDownData(dp);
                    DataConnection.this.transitionTo(DataConnection.this.mDisconnectingState);
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcActiveState nothandled msg.what=" + msg.what);
                    retVal = false;
                }
            }
            return retVal;
        }

        public /* synthetic */ DcActiveState(1 x1) {
            this();
        }
    }

    public class DcActivatingState
    extends HierarchicalState {
        public DcActivatingState() {
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 6: {
                    DataConnection.this.log("DcActivatingState deferring msg.what=EVENT_DISCONNECT");
                    DataConnection.this.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 3: {
                    DataConnection.this.log("DcActivatingState msg.what=EVENT_SETUP_DATA_CONNECTION_DONE");
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    SetupResult result = DataConnection.this.onSetupConnectionCompleted(ar);
                    DataConnection.this.log("DcActivatingState onSetupConnectionCompleted result=" + (Object)((Object)result));
                    switch (result) {
                        case SUCCESS: {
                            DataConnection.this.mActiveState.setEnterNotificationParams(cp, FailCause.NONE);
                            DataConnection.this.transitionTo(DataConnection.this.mActiveState);
                            break;
                        }
                        case ERR_BadCommand: {
                            DataConnection.this.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                            DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                            break;
                        }
                        case ERR_UnacceptableParameter: {
                            DataConnection.this.tearDownData(cp);
                            DataConnection.this.transitionTo(DataConnection.this.mDisconnectingErrorCreatingConnection);
                            break;
                        }
                        case ERR_GetLastErrorFromRil: {
                            DataConnection.this.phone.mCM.getLastDataCallFailCause(DataConnection.this.obtainMessage(4, cp));
                            break;
                        }
                        case ERR_RilError: {
                            DataConnection.this.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                            DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                            break;
                        }
                        case ERR_Stale: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unkown SetupResult, should not happen");
                        }
                    }
                    retVal = true;
                    break;
                }
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    FailCause cause = FailCause.UNKNOWN;
                    if (cp.tag == DataConnection.this.mTag) {
                        DataConnection.this.log("DcActivatingState msg.what=EVENT_GET_LAST_FAIL_DONE");
                        if (ar.exception == null) {
                            int rilFailCause = ((int[])ar.result)[0];
                            cause = FailCause.fromInt(rilFailCause);
                        }
                        DataConnection.this.mInactiveState.setEnterNotificationParams(cp, cause);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcActivatingState EVENT_GET_LAST_FAIL_DONE is stale cp.tag=" + cp.tag + ", mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcActivatingState not handled msg.what=" + msg.what);
                    retVal = false;
                }
            }
            return retVal;
        }

        public /* synthetic */ DcActivatingState(1 x1) {
            this();
        }
    }

    public class DcInactiveState
    extends HierarchicalState {
        public ConnectionParams mConnectionParams = null;
        public FailCause mFailCause = null;
        public DisconnectParams mDisconnectParams = null;

        public DcInactiveState() {
        }

        public void setEnterNotificationParams(ConnectionParams cp, FailCause cause) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams cp,cause");
            this.mConnectionParams = cp;
            this.mFailCause = cause;
        }

        public void setEnterNotificationParams(DisconnectParams dp) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams dp");
            this.mDisconnectParams = dp;
        }

        public void enter() {
            ++DataConnection.this.mTag;
            if (this.mConnectionParams != null && this.mFailCause != null) {
                DataConnection.this.log("DcInactiveState: enter notifyConnectCompleted");
                DataConnection.this.notifyConnectCompleted(this.mConnectionParams, this.mFailCause);
            }
            if (this.mDisconnectParams != null) {
                DataConnection.this.log("DcInactiveState: enter notifyDisconnectCompleted");
                DataConnection.this.notifyDisconnectCompleted(this.mDisconnectParams);
            }
        }

        public void exit() {
            this.mConnectionParams = null;
            this.mFailCause = null;
            this.mDisconnectParams = null;
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 1: {
                    DataConnection.this.log("DcInactiveState: msg.what=EVENT_RESET, ignore we're already reset");
                    if (msg.obj != null) {
                        DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj);
                    }
                    retVal = true;
                    break;
                }
                case 2: {
                    DataConnection.this.log("DcInactiveState msg.what=EVENT_CONNECT");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    cp.tag = DataConnection.this.mTag;
                    DataConnection.this.onConnect(cp);
                    DataConnection.this.transitionTo(DataConnection.this.mActivatingState);
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcInactiveState nothandled msg.what=" + msg.what);
                    retVal = false;
                }
            }
            return retVal;
        }

        public /* synthetic */ DcInactiveState(1 x1) {
            this();
        }
    }

    public class DcDefaultState
    extends HierarchicalState {
        public DcDefaultState() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_RESET");
                    DataConnection.this.clearSettings();
                    if (msg.obj != null) {
                        DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj);
                    }
                    DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    break;
                }
                case 2: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_CONNECT, fail not expected");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    DataConnection.this.notifyConnectCompleted(cp, FailCause.UNKNOWN);
                    break;
                }
                case 6: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_DISCONNECT");
                    DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj);
                    break;
                }
                default: {
                    DataConnection.this.log("DcDefaultState: shouldn't happen but ignore msg.what=" + msg.what);
                }
            }
            return true;
        }

        public /* synthetic */ DcDefaultState(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailCause {
        NONE(0),
        OPERATOR_BARRED(8),
        INSUFFICIENT_RESOURCES(26),
        MISSING_UNKNOWN_APN(27),
        UNKNOWN_PDP_ADDRESS_TYPE(28),
        USER_AUTHENTICATION(29),
        ACTIVATION_REJECT_GGSN(30),
        ACTIVATION_REJECT_UNSPECIFIED(31),
        SERVICE_OPTION_NOT_SUPPORTED(32),
        SERVICE_OPTION_NOT_SUBSCRIBED(33),
        SERVICE_OPTION_OUT_OF_ORDER(34),
        NSAPI_IN_USE(35),
        ONLY_IPV4_ALLOWED(50),
        ONLY_IPV6_ALLOWED(51),
        ONLY_SINGLE_BEARER_ALLOWED(52),
        PROTOCOL_ERRORS(111),
        REGISTRATION_FAIL(-1),
        GPRS_REGISTRATION_FAIL(-2),
        SIGNAL_LOST(-3),
        PREF_RADIO_TECH_CHANGED(-4),
        RADIO_POWER_OFF(-5),
        TETHERED_CALL_ACTIVE(-6),
        ERROR_UNSPECIFIED(65535),
        UNKNOWN(65536),
        RADIO_NOT_AVAILABLE(65537),
        UNACCEPTABLE_NETWORK_PARAMETER(65538);

        public final int mErrorCode;
        public static final HashMap<Integer, FailCause> sErrorCodeToFailCauseMap;

        public FailCause(int errorCode) {
            this.mErrorCode = errorCode;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        public boolean isPermanentFail() {
            return this == OPERATOR_BARRED || this == MISSING_UNKNOWN_APN || this == UNKNOWN_PDP_ADDRESS_TYPE || this == USER_AUTHENTICATION || this == SERVICE_OPTION_NOT_SUPPORTED || this == SERVICE_OPTION_NOT_SUBSCRIBED || this == NSAPI_IN_USE || this == PROTOCOL_ERRORS;
        }

        public boolean isEventLoggable() {
            return this == OPERATOR_BARRED || this == INSUFFICIENT_RESOURCES || this == UNKNOWN_PDP_ADDRESS_TYPE || this == USER_AUTHENTICATION || this == ACTIVATION_REJECT_GGSN || this == ACTIVATION_REJECT_UNSPECIFIED || this == SERVICE_OPTION_NOT_SUBSCRIBED || this == SERVICE_OPTION_NOT_SUPPORTED || this == SERVICE_OPTION_OUT_OF_ORDER || this == NSAPI_IN_USE || this == PROTOCOL_ERRORS || this == UNACCEPTABLE_NETWORK_PARAMETER;
        }

        public static FailCause fromInt(int errorCode) {
            FailCause fc = sErrorCodeToFailCauseMap.get(errorCode);
            if (fc == null) {
                fc = UNKNOWN;
            }
            return fc;
        }

        static {
            sErrorCodeToFailCauseMap = new HashMap();
            for (FailCause fc : FailCause.values()) {
                sErrorCodeToFailCauseMap.put(fc.ordinal(), fc);
            }
        }
    }

    public static class DisconnectParams {
        public int tag;
        public Message onCompletedMsg;
        public ResetSynchronouslyLock lockObj;

        public DisconnectParams(Message onCompletedMsg) {
            this.onCompletedMsg = onCompletedMsg;
        }

        public DisconnectParams(ResetSynchronouslyLock lockObj) {
            this.lockObj = lockObj;
        }
    }

    public class ResetSynchronouslyLock {
    }

    public static class ConnectionParams {
        public int tag;
        public ApnSetting apn;
        public Message onCompletedMsg;

        public ConnectionParams(ApnSetting apn, Message onCompletedMsg) {
            this.apn = apn;
            this.onCompletedMsg = onCompletedMsg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SetupResult {
        SUCCESS,
        ERR_BadCommand,
        ERR_UnacceptableParameter,
        ERR_GetLastErrorFromRil,
        ERR_Stale,
        ERR_RilError;

        public FailCause mFailCause = FailCause.fromInt(0);

        public String toString() {
            return this.name() + "  SetupResult.mFailCause=" + (Object)((Object)this.mFailCause);
        }
    }
}

