/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.ApnSetting;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.RetryManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataConnectionTracker
extends Handler {
    public static final boolean DBG = true;
    public static String ACTION_DATA_CONNECTION_TRACKER_MESSENGER = "com.android.internal.telephony";
    public static String EXTRA_MESSENGER = "EXTRA_MESSENGER";
    public static final int EVENT_DATA_SETUP_COMPLETE = 1;
    public static final int EVENT_RADIO_AVAILABLE = 3;
    public static final int EVENT_RECORDS_LOADED = 4;
    public static final int EVENT_TRY_SETUP_DATA = 5;
    public static final int EVENT_DATA_STATE_CHANGED = 6;
    public static final int EVENT_POLL_PDP = 7;
    public static final int EVENT_GET_PDP_LIST_COMPLETE = 11;
    public static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 12;
    public static final int EVENT_VOICE_CALL_STARTED = 14;
    public static final int EVENT_VOICE_CALL_ENDED = 15;
    public static final int EVENT_GPRS_DETACHED = 19;
    public static final int EVENT_LINK_STATE_CHANGED = 20;
    public static final int EVENT_ROAMING_ON = 21;
    public static final int EVENT_ROAMING_OFF = 22;
    public static final int EVENT_ENABLE_NEW_APN = 23;
    public static final int EVENT_RESTORE_DEFAULT_APN = 24;
    public static final int EVENT_DISCONNECT_DONE = 25;
    public static final int EVENT_GPRS_ATTACHED = 26;
    public static final int EVENT_START_NETSTAT_POLL = 27;
    public static final int EVENT_START_RECOVERY = 28;
    public static final int EVENT_APN_CHANGED = 29;
    public static final int EVENT_CDMA_DATA_DETACHED = 30;
    public static final int EVENT_NV_READY = 31;
    public static final int EVENT_PS_RESTRICT_ENABLED = 32;
    public static final int EVENT_PS_RESTRICT_DISABLED = 33;
    public static final int EVENT_CLEAN_UP_CONNECTION = 34;
    public static final int EVENT_CDMA_OTA_PROVISION = 35;
    public static final int EVENT_RESTART_RADIO = 36;
    public static final int EVENT_SET_INTERNAL_DATA_ENABLE = 37;
    public static final int EVENT_RESET_DONE = 38;
    public static final int CMD_SET_DATA_ENABLE = 39;
    public static final int APN_INVALID_ID = -1;
    public static final int APN_DEFAULT_ID = 0;
    public static final int APN_MMS_ID = 1;
    public static final int APN_SUPL_ID = 2;
    public static final int APN_DUN_ID = 3;
    public static final int APN_HIPRI_ID = 4;
    public static final int APN_NUM_TYPES = 5;
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    public boolean mInternalDataEnabled = true;
    public boolean mDataEnabled = true;
    public boolean[] dataEnabled = new boolean[5];
    public int enabledCount = 0;
    public String mRequestedApnType = "default";
    public static final String DEFAULT_DATA_RETRY_CONFIG = "default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000";
    public static final String SECONDARY_DATA_RETRY_CONFIG = "max_retries=3, 5000, 5000, 5000";
    public static final int POLL_NETSTAT_SLOW_MILLIS = 5000;
    public static final int DEFAULT_MAX_PDP_RESET_FAIL = 3;
    public static final int NO_RECV_POLL_LIMIT = 24;
    public static final int POLL_NETSTAT_MILLIS = 1000;
    public static final int POLL_NETSTAT_SCREEN_OFF_MILLIS = 600000;
    public static final int POLL_LONGEST_RTT = 120000;
    public static final int NUMBER_SENT_PACKETS_OF_HANG = 10;
    public static final int RESTORE_DEFAULT_APN_DELAY = 60000;
    public static final String APN_RESTORE_DELAY_PROP_NAME = "android.telephony.apn-restore";
    public static final String NULL_IP = "0.0.0.0";
    public static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reason";
    public PhoneBase mPhone;
    public Activity mActivity = Activity.NONE;
    public State mState = State.IDLE;
    public Handler mDataConnectionTracker = null;
    public long mTxPkts;
    public long mRxPkts;
    public long mSentSinceLastRecv;
    public int mNetStatPollPeriod;
    public int mNoRecvPollCount = 0;
    public boolean mNetStatPollEnabled = false;
    public RetryManager mRetryMgr = new RetryManager();
    public boolean mIsWifiConnected = false;
    public PendingIntent mReconnectIntent = null;
    public int mCidActive;
    public boolean mAvailability = false;
    public boolean mAutoAttachOnCreation = false;
    public boolean mIsScreenOn = true;
    public LinkProperties mLinkProperties = new LinkProperties();
    public LinkCapabilities mLinkCapabilities = new LinkCapabilities();
    public AtomicInteger mUniqueIdGenerator = new AtomicInteger(0);
    public HashMap<Integer, DataConnection> mDataConnections = new HashMap();
    public ApnSetting mActiveApn;
    public BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                DataConnectionTracker.this.mIsScreenOn = true;
                DataConnectionTracker.this.stopNetStatPoll();
                DataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                DataConnectionTracker.this.mIsScreenOn = false;
                DataConnectionTracker.this.stopNetStatPoll();
                DataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals(DataConnectionTracker.this.getActionIntentReconnectAlarm())) {
                DataConnectionTracker.this.log("Reconnect alarm. Previous state was " + (Object)((Object)DataConnectionTracker.this.mState));
                String reason = intent.getStringExtra(DataConnectionTracker.INTENT_RECONNECT_ALARM_EXTRA_REASON);
                if (DataConnectionTracker.this.mState == State.FAILED) {
                    Message msg = DataConnectionTracker.this.obtainMessage(34);
                    msg.arg1 = 0;
                    msg.obj = reason;
                    DataConnectionTracker.this.sendMessage(msg);
                }
                DataConnectionTracker.this.sendMessage(DataConnectionTracker.this.obtainMessage(5));
            } else if (action.equals("android.net.wifi.STATE_CHANGE")) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                DataConnectionTracker.this.mIsWifiConnected = networkInfo != null && networkInfo.isConnected();
            } else if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                boolean enabled;
                boolean bl = enabled = intent.getIntExtra("wifi_state", 4) == 3;
                if (!enabled) {
                    DataConnectionTracker.this.mIsWifiConnected = false;
                }
            }
        }
    };

    public DataConnectionTracker(PhoneBase phone) {
        this.mPhone = phone;
        IntentFilter filter = new IntentFilter();
        filter.addAction(this.getActionIntentReconnectAlarm());
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        this.mDataEnabled = Settings.Secure.getInt(this.mPhone.getContext().getContentResolver(), "mobile_data", 1) == 1;
        this.mPhone.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mPhone);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
        boolean bl = this.dataEnabled[0] = !sp.getBoolean("disabled_on_boot_key", false);
        if (this.dataEnabled[0]) {
            ++this.enabledCount;
        }
        this.mAutoAttachOnCreation = this.dataEnabled[0];
    }

    public void dispose() {
        this.mPhone.getContext().unregisterReceiver(this.mIntentReceiver);
    }

    public void broadcastMessenger() {
        Intent intent = new Intent(ACTION_DATA_CONNECTION_TRACKER_MESSENGER);
        intent.putExtra(EXTRA_MESSENGER, new Messenger(this));
        this.mPhone.getContext().sendBroadcast(intent);
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public State getState() {
        return this.mState;
    }

    public String getStateInString() {
        switch (this.mState) {
            case IDLE: {
                return "IDLE";
            }
            case INITING: {
                return "INIT";
            }
            case CONNECTING: {
                return "CING";
            }
            case SCANNING: {
                return "SCAN";
            }
            case CONNECTED: {
                return "CNTD";
            }
            case DISCONNECTING: {
                return "DING";
            }
            case FAILED: {
                return "FAIL";
            }
        }
        return "ERRO";
    }

    public ArrayList<DataConnection> getAllDataConnections() {
        return new ArrayList<DataConnection>(this.mDataConnections.values());
    }

    public boolean isApnTypeActive(String type) {
        return this.mActiveApn != null && this.mActiveApn.canHandleType(type);
    }

    public String[] getActiveApnTypes() {
        String[] result = this.mActiveApn != null ? this.mActiveApn.types : new String[]{"default"};
        return result;
    }

    public String getActiveApnType() {
        String result = this.mActiveApn != null ? this.apnIdToType(this.mActiveApn.id) : null;
        return result;
    }

    public String getActiveApnString() {
        String result = null;
        if (this.mActiveApn != null) {
            result = this.mActiveApn.apn;
        }
        return result;
    }

    public abstract boolean isDataConnectionAsDesired();

    public void setDataOnRoamingEnabled(boolean enabled) {
        if (this.getDataOnRoamingEnabled() != enabled) {
            Settings.Secure.putInt(this.mPhone.getContext().getContentResolver(), "data_roaming", enabled ? 1 : 0);
            if (this.mPhone.getServiceState().getRoaming()) {
                if (enabled) {
                    this.mRetryMgr.resetRetryCount();
                }
                this.sendMessage(this.obtainMessage(21));
            }
        }
    }

    public boolean getDataOnRoamingEnabled() {
        try {
            return Settings.Secure.getInt(this.mPhone.getContext().getContentResolver(), "data_roaming") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return false;
        }
    }

    public abstract String getActionIntentReconnectAlarm();

    public abstract boolean onTrySetupData(String var1);

    public abstract void onRoamingOff();

    public abstract void onRoamingOn();

    public abstract void onRadioAvailable();

    public abstract void onRadioOffOrNotAvailable();

    public abstract void onDataSetupComplete(AsyncResult var1);

    public abstract void onDisconnectDone(int var1, AsyncResult var2);

    public abstract void onResetDone(AsyncResult var1);

    public abstract void onVoiceCallStarted();

    public abstract void onVoiceCallEnded();

    public abstract void onCleanUpConnection(boolean var1, String var2);

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 23: {
                this.onEnableApn(msg.arg1, msg.arg2);
                break;
            }
            case 5: {
                String reason = null;
                if (msg.obj instanceof String) {
                    reason = (String)msg.obj;
                }
                this.onTrySetupData(reason);
                break;
            }
            case 22: {
                if (!this.getDataOnRoamingEnabled()) {
                    this.mRetryMgr.resetRetryCount();
                }
                this.onRoamingOff();
                break;
            }
            case 21: {
                this.onRoamingOn();
                break;
            }
            case 3: {
                this.onRadioAvailable();
                break;
            }
            case 12: {
                this.onRadioOffOrNotAvailable();
                break;
            }
            case 1: {
                this.mCidActive = msg.arg1;
                this.onDataSetupComplete((AsyncResult)msg.obj);
                break;
            }
            case 25: {
                this.log("DataConnectoinTracker.handleMessage: EVENT_DISCONNECT_DONE msg=" + msg);
                this.onDisconnectDone(msg.arg1, (AsyncResult)msg.obj);
                break;
            }
            case 14: {
                this.onVoiceCallStarted();
                break;
            }
            case 15: {
                this.onVoiceCallEnded();
                break;
            }
            case 34: {
                boolean tearDown = msg.arg1 != 0;
                this.onCleanUpConnection(tearDown, (String)msg.obj);
                break;
            }
            case 37: {
                boolean enabled = msg.arg1 == 1;
                this.onSetInternalDataEnabled(enabled);
                break;
            }
            case 38: {
                this.onResetDone((AsyncResult)msg.obj);
                break;
            }
            case 39: {
                this.log("CMD_SET_DATA_ENABLE msg=" + msg);
                boolean enabled = msg.arg1 == 1;
                this.onSetDataEnabled(enabled);
                break;
            }
            default: {
                Log.e("DATA", "Unidentified event = " + msg.what);
            }
        }
    }

    public synchronized boolean getAnyDataEnabled() {
        boolean result;
        boolean bl = result = this.mInternalDataEnabled && this.mDataEnabled && this.enabledCount != 0;
        if (!result) {
            this.log("getAnyDataEnabled " + result);
        }
        return result;
    }

    public abstract void startNetStatPoll();

    public abstract void stopNetStatPoll();

    public abstract void restartRadio();

    public abstract void log(String var1);

    public abstract void loge(String var1);

    public int apnTypeToId(String type) {
        if (TextUtils.equals(type, "default")) {
            return 0;
        }
        if (TextUtils.equals(type, "mms")) {
            return 1;
        }
        if (TextUtils.equals(type, "supl")) {
            return 2;
        }
        if (TextUtils.equals(type, "dun")) {
            return 3;
        }
        if (TextUtils.equals(type, "hipri")) {
            return 4;
        }
        return -1;
    }

    public String apnIdToType(int id2) {
        switch (id2) {
            case 0: {
                return "default";
            }
            case 1: {
                return "mms";
            }
            case 2: {
                return "supl";
            }
            case 3: {
                return "dun";
            }
            case 4: {
                return "hipri";
            }
        }
        this.log("Unknown id (" + id2 + ") in apnIdToType");
        return "default";
    }

    public abstract boolean isApnTypeAvailable(String var1);

    public abstract void setState(State var1);

    public LinkProperties getLinkProperties(String apnType) {
        int id2 = this.apnTypeToId(apnType);
        if (this.isApnIdEnabled(id2)) {
            return new LinkProperties(this.mLinkProperties);
        }
        return new LinkProperties();
    }

    public LinkCapabilities getLinkCapabilities(String apnType) {
        int id2 = this.apnTypeToId(apnType);
        if (this.isApnIdEnabled(id2)) {
            return new LinkCapabilities(this.mLinkCapabilities);
        }
        return new LinkCapabilities();
    }

    public LinkProperties getLinkProperties(DataConnection connection) {
        return connection.getLinkProperties();
    }

    public LinkCapabilities getLinkCapabilities(DataConnection connection) {
        return connection.getLinkCapabilities();
    }

    public void notifyDataConnection(String reason) {
        for (int id2 = 0; id2 < 5; ++id2) {
            if (!this.dataEnabled[id2]) continue;
            this.mPhone.notifyDataConnection(reason, this.apnIdToType(id2));
        }
        this.notifyDataAvailability(reason);
    }

    public void notifyApnIdUpToCurrent(String reason, int apnId) {
        switch (this.mState) {
            case IDLE: 
            case INITING: {
                break;
            }
            case CONNECTING: 
            case SCANNING: {
                this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), Phone.DataState.CONNECTING);
                break;
            }
            case CONNECTED: 
            case DISCONNECTING: {
                this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), Phone.DataState.CONNECTING);
                this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), Phone.DataState.CONNECTED);
            }
        }
    }

    public void notifyApnIdDisconnected(String reason, int apnId) {
        this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), Phone.DataState.DISCONNECTED);
    }

    public void notifyOffApnsOfAvailability(String reason, boolean availability) {
        if (this.mAvailability == availability) {
            this.log("notifyOffApnsOfAvailability: no change in availability, not nofitying about reason='" + reason + "' availability=" + availability);
            return;
        }
        this.mAvailability = availability;
        for (int id2 = 0; id2 < 5; ++id2) {
            if (this.isApnIdEnabled(id2)) continue;
            this.notifyApnIdDisconnected(reason, id2);
        }
    }

    public void notifyDataAvailability(String reason) {
        this.notifyOffApnsOfAvailability(reason, this.isDataPossible());
    }

    public boolean isDataPossible() {
        boolean possible;
        boolean dataAllowed = this.isDataAllowed();
        boolean anyDataEnabled = this.getAnyDataEnabled();
        boolean bl = possible = dataAllowed && (!anyDataEnabled || this.mState != State.FAILED && this.mState != State.IDLE);
        if (!possible) {
            this.log("isDataPossible() " + possible + ", dataAllowed=" + dataAllowed + " anyDataEnabled=" + anyDataEnabled + " dataState=" + (Object)((Object)this.mState));
        }
        return possible;
    }

    public abstract boolean isDataAllowed();

    public boolean isApnTypeEnabled(String apnType) {
        if (apnType == null) {
            apnType = this.getActiveApnType();
        }
        return this.isApnIdEnabled(this.apnTypeToId(apnType));
    }

    public synchronized boolean isApnIdEnabled(int id2) {
        if (id2 != -1) {
            return this.dataEnabled[id2];
        }
        return false;
    }

    public synchronized int enableApnType(String type) {
        int id2 = this.apnTypeToId(type);
        if (id2 == -1) {
            return 3;
        }
        this.log("enableApnType(" + type + "), isApnTypeActive = " + this.isApnTypeActive(type) + ", isApnIdEnabled =" + this.isApnIdEnabled(id2) + " and state = " + (Object)((Object)this.mState));
        if (!this.isApnTypeAvailable(type)) {
            this.log("type not available");
            return 2;
        }
        if (this.isApnIdEnabled(id2)) {
            return 0;
        }
        this.setEnabled(id2, true);
        return 1;
    }

    public synchronized int disableApnType(String type) {
        this.log("disableApnType(" + type + ")");
        int id2 = this.apnTypeToId(type);
        if (id2 == -1) {
            return 3;
        }
        if (this.isApnIdEnabled(id2)) {
            this.setEnabled(id2, false);
            if (this.isApnTypeActive("default")) {
                if (this.dataEnabled[0]) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
        return 3;
    }

    public void setEnabled(int id2, boolean enable) {
        this.log("setEnabled(" + id2 + ", " + enable + ") with old state = " + this.dataEnabled[id2] + " and enabledCount = " + this.enabledCount);
        Message msg = this.obtainMessage(23);
        msg.arg1 = id2;
        msg.arg2 = enable ? 1 : 0;
        this.sendMessage(msg);
    }

    public synchronized void onEnableApn(int apnId, int enabled) {
        this.log("EVENT_APN_ENABLE_REQUEST apnId=" + apnId + ", apnType=" + this.apnIdToType(apnId) + ", enabled=" + enabled + ", dataEnabled = " + this.dataEnabled[apnId] + ", enabledCount = " + this.enabledCount + ", isApnTypeActive = " + this.isApnTypeActive(this.apnIdToType(apnId)));
        if (enabled == 1) {
            String type;
            if (!this.dataEnabled[apnId]) {
                this.dataEnabled[apnId] = true;
                ++this.enabledCount;
            }
            if (!this.isApnTypeActive(type = this.apnIdToType(apnId))) {
                this.mRequestedApnType = type;
                this.onEnableNewApn();
            } else {
                this.notifyApnIdUpToCurrent("apnSwitched", apnId);
            }
        } else if (this.dataEnabled[apnId]) {
            this.dataEnabled[apnId] = false;
            --this.enabledCount;
            if (this.enabledCount == 0) {
                this.onCleanUpConnection(true, "dataDisabled");
            }
            this.notifyApnIdDisconnected("dataDisabled", apnId);
            if (this.dataEnabled[0] && !this.isApnTypeActive("default")) {
                this.mRequestedApnType = "default";
                this.onEnableNewApn();
            }
        }
    }

    public void onEnableNewApn() {
    }

    public boolean setInternalDataEnabled(boolean enable) {
        this.log("setInternalDataEnabled(" + enable + ")");
        Message msg = this.obtainMessage(37);
        msg.arg1 = enable ? 1 : 0;
        this.sendMessage(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSetInternalDataEnabled(boolean enable) {
        boolean prevEnabled = this.getAnyDataEnabled();
        if (this.mInternalDataEnabled != enable) {
            DataConnectionTracker dataConnectionTracker = this;
            synchronized (dataConnectionTracker) {
                this.mInternalDataEnabled = enable;
            }
            if (prevEnabled != this.getAnyDataEnabled()) {
                if (!prevEnabled) {
                    this.mRetryMgr.resetRetryCount();
                    this.onTrySetupData("dataEnabled");
                } else {
                    this.onCleanUpConnection(true, "dataDisabled");
                }
            }
        }
    }

    public synchronized boolean getDataEnabled() {
        return this.mDataEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSetDataEnabled(boolean enable) {
        boolean prevEnabled = this.getAnyDataEnabled();
        if (this.mDataEnabled != enable) {
            DataConnectionTracker dataConnectionTracker = this;
            synchronized (dataConnectionTracker) {
                this.mDataEnabled = enable;
            }
            Settings.Secure.putInt(this.mPhone.getContext().getContentResolver(), "mobile_data", enable ? 1 : 0);
            if (prevEnabled != this.getAnyDataEnabled()) {
                if (!prevEnabled) {
                    this.mRetryMgr.resetRetryCount();
                    this.onTrySetupData("dataEnabled");
                } else {
                    this.onCleanUpConnection(true, "dataDisabled");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Activity {
        NONE,
        DATAIN,
        DATAOUT,
        DATAINANDOUT,
        DORMANT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IDLE,
        INITING,
        CONNECTING,
        SCANNING,
        CONNECTED,
        DISCONNECTING,
        FAILED;

    }
}

