/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Message;
import android.os.Parcel;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.RIL;

public class RILRequest {
    public static final String LOG_TAG = "RILJ";
    public static int sNextSerial = 0;
    public static Object sSerialMonitor = new Object();
    public static Object sPoolSync = new Object();
    public static RILRequest sPool = null;
    public static int sPoolSize = 0;
    public static final int MAX_POOL_SIZE = 4;
    public int mSerial;
    public int mRequest;
    public Message mResult;
    public Parcel mp;
    public RILRequest mNext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RILRequest obtain(int request, Message result) {
        RILRequest rr = null;
        Object object = sPoolSync;
        synchronized (object) {
            if (sPool != null) {
                rr = sPool;
                sPool = rr.mNext;
                rr.mNext = null;
                --sPoolSize;
            }
        }
        if (rr == null) {
            rr = new RILRequest();
        }
        object = sSerialMonitor;
        synchronized (object) {
            rr.mSerial = sNextSerial++;
        }
        rr.mRequest = request;
        rr.mResult = result;
        rr.mp = Parcel.obtain();
        if (result != null && result.getTarget() == null) {
            throw new NullPointerException("Message target must not be null");
        }
        rr.mp.writeInt(request);
        rr.mp.writeInt(rr.mSerial);
        return rr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 4) {
                this.mNext = sPool;
                sPool = this;
                ++sPoolSize;
                this.mResult = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetSerial() {
        Object object = sSerialMonitor;
        synchronized (object) {
            sNextSerial = 0;
        }
    }

    public String serialString() {
        StringBuilder sb = new StringBuilder(8);
        String sn = Integer.toString(this.mSerial);
        sb.append('[');
        int s = sn.length();
        for (int i = 0; i < 4 - s; ++i) {
            sb.append('0');
        }
        sb.append(sn);
        sb.append(']');
        return sb.toString();
    }

    public void onError(int error, Object ret) {
        CommandException ex = CommandException.fromRilErrno(error);
        Log.d(LOG_TAG, this.serialString() + "< " + RIL.requestToString(this.mRequest) + " error: " + ex);
        if (this.mResult != null) {
            AsyncResult.forMessage(this.mResult, ret, ex);
            this.mResult.sendToTarget();
        }
        if (this.mp != null) {
            this.mp.recycle();
            this.mp = null;
        }
    }
}

