/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.android.internal.telephony.IWapPushManager;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.WspTypeDecoder;

public class WapPushOverSms {
    public static final String LOG_TAG = "WAP PUSH";
    public final Context mContext;
    public WspTypeDecoder pduDecoder;
    public SMSDispatcher mSmsDispatcher;
    public final int WAKE_LOCK_TIMEOUT = 5000;
    public final int BIND_RETRY_INTERVAL = 1000;
    public WapPushConnection mWapConn = null;

    public WapPushOverSms(Phone phone, SMSDispatcher smsDispatcher) {
        this.mSmsDispatcher = smsDispatcher;
        this.mContext = phone.getContext();
        this.mWapConn = new WapPushConnection(this.mContext);
        this.mWapConn.bindWapPushManager();
    }

    public int dispatchWapPdu(byte[] pdu) {
        byte[] intentData;
        int index = 0;
        int transactionId = pdu[index++] & 0xFF;
        int pduType = pdu[index++] & 0xFF;
        int headerLength = 0;
        if (pduType != 6 && pduType != 7) {
            return 1;
        }
        this.pduDecoder = new WspTypeDecoder(pdu);
        if (!this.pduDecoder.decodeUintvarInteger(index)) {
            return 2;
        }
        headerLength = (int)this.pduDecoder.getValue32();
        int headerStartIndex = index += this.pduDecoder.getDecodedDataLength();
        if (!this.pduDecoder.decodeContentType(index)) {
            return 2;
        }
        String mimeType = this.pduDecoder.getValueString();
        long binaryContentType = this.pduDecoder.getValue32();
        index += this.pduDecoder.getDecodedDataLength();
        byte[] header = new byte[headerLength];
        System.arraycopy(pdu, headerStartIndex, header, 0, header.length);
        if (mimeType != null && mimeType.equals("application/vnd.wap.coc")) {
            intentData = pdu;
        } else {
            int dataIndex = headerStartIndex + headerLength;
            intentData = new byte[pdu.length - dataIndex];
            System.arraycopy(pdu, dataIndex, intentData, 0, intentData.length);
        }
        if (this.pduDecoder.seekXWapApplicationId(index, index + headerLength - 1)) {
            index = (int)this.pduDecoder.getValue32();
            this.pduDecoder.decodeXWapApplicationId(index);
            String wapAppId = this.pduDecoder.getValueString();
            if (wapAppId == null) {
                wapAppId = Integer.toString((int)this.pduDecoder.getValue32());
            }
            String contentType = mimeType == null ? Long.toString(binaryContentType) : mimeType;
            try {
                boolean processFurther = true;
                IWapPushManager wapPushMan = this.mWapConn.getWapPushManager();
                if (wapPushMan != null) {
                    Intent intent = new Intent();
                    intent.putExtra("transactionId", transactionId);
                    intent.putExtra("pduType", pduType);
                    intent.putExtra("header", header);
                    intent.putExtra("data", intentData);
                    intent.putExtra("contentTypeParameters", this.pduDecoder.getContentParameters());
                    int procRet = wapPushMan.processMessage(wapAppId, contentType, intent);
                    if ((procRet & 1) > 0 && (procRet & 0x8000) == 0) {
                        processFurther = false;
                    }
                }
                if (!processFurther) {
                    return 1;
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (mimeType == null) {
            return 2;
        }
        String permission2 = mimeType.equals("application/vnd.wap.mms-message") ? "android.permission.RECEIVE_MMS" : "android.permission.RECEIVE_WAP_PUSH";
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_RECEIVED");
        intent.setType(mimeType);
        intent.putExtra("transactionId", transactionId);
        intent.putExtra("pduType", pduType);
        intent.putExtra("header", header);
        intent.putExtra("data", intentData);
        intent.putExtra("contentTypeParameters", this.pduDecoder.getContentParameters());
        this.mSmsDispatcher.dispatch(intent, permission2);
        return -1;
    }

    public class WapPushConnection
    implements ServiceConnection {
        public IWapPushManager mWapPushMan;
        public Context mOwner;

        public WapPushConnection(Context ownerContext) {
            this.mOwner = ownerContext;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            this.mWapPushMan = IWapPushManager.Stub.asInterface(service);
        }

        public void onServiceDisconnected(ComponentName name) {
            this.mWapPushMan = null;
            this.rebindWapPushManager();
        }

        public void bindWapPushManager() {
            if (this.mWapPushMan != null) {
                return;
            }
            WapPushConnection wapPushConnection = this;
            this.mOwner.bindService(new Intent(IWapPushManager.class.getName()), wapPushConnection, 1);
        }

        public void rebindWapPushManager() {
            if (this.mWapPushMan != null) {
                return;
            }
            final WapPushConnection wapPushConnection = this;
            new Thread(){

                public void run() {
                    while (WapPushConnection.this.mWapPushMan == null) {
                        WapPushConnection.this.mOwner.bindService(new Intent(IWapPushManager.class.getName()), wapPushConnection, 1);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }.start();
        }

        public IWapPushManager getWapPushManager() {
            return this.mWapPushMan;
        }
    }
}

