/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.ProxyProperties;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.ApnSetting;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmDataConnection;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsmDataConnectionTracker
extends DataConnectionTracker {
    public final String LOG_TAG = "GSM";
    public GSMPhone mGsmPhone;
    public boolean mReregisterOnReconnectFailure = false;
    public ContentResolver mResolver;
    public int mPdpResetCount = 0;
    public static final int APN_DELAY_MILLIS = 5000;
    public boolean mFailNextConnect = false;
    public ArrayList<ApnSetting> mAllApns = null;
    public ArrayList<ApnSetting> mWaitingApns = null;
    public int mWaitingApnsPermanentFailureCountDown = 0;
    public ApnSetting mPreferredApn = null;
    public GsmDataConnection mPendingDataConnection;
    public HashMap<String, Integer> mApnToDataConnectionId = new HashMap();
    public boolean mIsPsRestricted = false;
    public static final int POLL_PDP_MILLIS = 5000;
    public static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.gprs-reconnect";
    public static final Uri PREFERAPN_URI = Uri.parse("content://telephony/carriers/preferapn");
    public static final String APN_ID = "apn_id";
    public boolean canSetPreferApn = false;
    public ApnChangeObserver mApnObserver;
    public Runnable mPollNetStat = new Runnable(){

        public void run() {
            long preTxPkts = -1L;
            long preRxPkts = -1L;
            preTxPkts = GsmDataConnectionTracker.this.mTxPkts;
            preRxPkts = GsmDataConnectionTracker.this.mRxPkts;
            GsmDataConnectionTracker.this.mTxPkts = TrafficStats.getMobileTxPackets();
            GsmDataConnectionTracker.this.mRxPkts = TrafficStats.getMobileRxPackets();
            if (GsmDataConnectionTracker.this.mNetStatPollEnabled && (preTxPkts > 0L || preRxPkts > 0L)) {
                DataConnectionTracker.Activity newActivity;
                long sent = GsmDataConnectionTracker.this.mTxPkts - preTxPkts;
                long received = GsmDataConnectionTracker.this.mRxPkts - preRxPkts;
                if (sent > 0L && received > 0L) {
                    GsmDataConnectionTracker.this.mSentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.DATAINANDOUT;
                    GsmDataConnectionTracker.this.mPdpResetCount = 0;
                } else if (sent > 0L && received == 0L) {
                    if (GsmDataConnectionTracker.this.mPhone.getState() == Phone.State.IDLE) {
                        GsmDataConnectionTracker.this.mSentSinceLastRecv += sent;
                    } else {
                        GsmDataConnectionTracker.this.mSentSinceLastRecv = 0L;
                    }
                    newActivity = DataConnectionTracker.Activity.DATAOUT;
                } else if (sent == 0L && received > 0L) {
                    GsmDataConnectionTracker.this.mSentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.DATAIN;
                    GsmDataConnectionTracker.this.mPdpResetCount = 0;
                } else if (sent == 0L && received == 0L) {
                    newActivity = DataConnectionTracker.Activity.NONE;
                } else {
                    GsmDataConnectionTracker.this.mSentSinceLastRecv = 0L;
                    newActivity = DataConnectionTracker.Activity.NONE;
                }
                if (GsmDataConnectionTracker.this.mActivity != newActivity && GsmDataConnectionTracker.this.mIsScreenOn) {
                    GsmDataConnectionTracker.this.mActivity = newActivity;
                    GsmDataConnectionTracker.this.mPhone.notifyDataActivity();
                }
            }
            int watchdogTrigger = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_trigger_packet_count", 10);
            if (GsmDataConnectionTracker.this.mSentSinceLastRecv >= (long)watchdogTrigger) {
                if (GsmDataConnectionTracker.this.mNoRecvPollCount == 0) {
                    EventLog.writeEvent(50101, GsmDataConnectionTracker.this.mSentSinceLastRecv);
                }
                int noRecvPollLimit = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_count", 24);
                if (GsmDataConnectionTracker.this.mNoRecvPollCount < noRecvPollLimit) {
                    GsmDataConnectionTracker.this.log("no DATAIN in a while; polling PDP");
                    ((GsmDataConnectionTracker)GsmDataConnectionTracker.this).mPhone.mCM.getDataCallList(GsmDataConnectionTracker.this.obtainMessage(11));
                    GsmDataConnectionTracker.this.mNoRecvPollCount++;
                    GsmDataConnectionTracker.this.mNetStatPollPeriod = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_error_poll_interval_ms", 5000);
                } else {
                    GsmDataConnectionTracker.this.log("Sent " + String.valueOf(GsmDataConnectionTracker.this.mSentSinceLastRecv) + " pkts since last received start recovery process");
                    GsmDataConnectionTracker.this.stopNetStatPoll();
                    GsmDataConnectionTracker.this.sendMessage(GsmDataConnectionTracker.this.obtainMessage(28));
                }
            } else {
                GsmDataConnectionTracker.this.mNoRecvPollCount = 0;
                if (GsmDataConnectionTracker.this.mIsScreenOn) {
                    GsmDataConnectionTracker.this.mNetStatPollPeriod = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_poll_interval_ms", 1000);
                } else {
                    GsmDataConnectionTracker.this.mNetStatPollPeriod = Settings.Secure.getInt(GsmDataConnectionTracker.this.mResolver, "pdp_watchdog_long_poll_interval_ms", 600000);
                }
            }
            if (GsmDataConnectionTracker.this.mNetStatPollEnabled) {
                GsmDataConnectionTracker.this.mDataConnectionTracker.postDelayed(this, GsmDataConnectionTracker.this.mNetStatPollPeriod);
            }
        }
    };

    public GsmDataConnectionTracker(GSMPhone p) {
        super(p);
        this.mGsmPhone = p;
        p.mCM.registerForAvailable(this, 3, null);
        p.mCM.registerForOffOrNotAvailable(this, 12, null);
        p.mSIMRecords.registerForRecordsLoaded(this, 4, null);
        p.mCM.registerForDataNetworkStateChanged(this, 6, null);
        p.mCT.registerForVoiceCallEnded(this, 15, null);
        p.mCT.registerForVoiceCallStarted(this, 14, null);
        p.mSST.registerForGprsAttached(this, 26, null);
        p.mSST.registerForGprsDetached(this, 19, null);
        p.mSST.registerForRoamingOn(this, 21, null);
        p.mSST.registerForRoamingOff(this, 22, null);
        p.mSST.registerForPsRestrictedEnabled(this, 32, null);
        p.mSST.registerForPsRestrictedDisabled(this, 33, null);
        this.mDataConnectionTracker = this;
        this.mResolver = this.mPhone.getContext().getContentResolver();
        this.mApnObserver = new ApnChangeObserver();
        p.getContext().getContentResolver().registerContentObserver(Telephony.Carriers.CONTENT_URI, true, this.mApnObserver);
        this.createDataConnection("default");
        this.broadcastMessenger();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mPhone.mCM.unregisterForAvailable(this);
        this.mPhone.mCM.unregisterForOffOrNotAvailable(this);
        this.mGsmPhone.mSIMRecords.unregisterForRecordsLoaded(this);
        this.mPhone.mCM.unregisterForDataNetworkStateChanged(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallEnded(this);
        this.mGsmPhone.mCT.unregisterForVoiceCallStarted(this);
        this.mGsmPhone.mSST.unregisterForGprsAttached(this);
        this.mGsmPhone.mSST.unregisterForGprsDetached(this);
        this.mGsmPhone.mSST.unregisterForRoamingOn(this);
        this.mGsmPhone.mSST.unregisterForRoamingOff(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedEnabled(this);
        this.mGsmPhone.mSST.unregisterForPsRestrictedDisabled(this);
        this.mPhone.getContext().getContentResolver().unregisterContentObserver(this.mApnObserver);
        this.destroyDataConnections();
    }

    public void finalize() {
        this.log("finalize");
    }

    @Override
    public String getActionIntentReconnectAlarm() {
        return INTENT_RECONNECT_ALARM;
    }

    @Override
    public void setState(DataConnectionTracker.State s) {
        this.log("setState: " + (Object)((Object)s));
        if (this.mState != s) {
            EventLog.writeEvent(50113, this.mState.toString(), s.toString());
            this.mState = s;
        }
        if (this.mState == DataConnectionTracker.State.FAILED && this.mWaitingApns != null) {
            this.mWaitingApns.clear();
        }
    }

    @Override
    public boolean isDataConnectionAsDesired() {
        boolean roaming = this.mPhone.getServiceState().getRoaming();
        if (!(!this.mGsmPhone.mSIMRecords.getRecordsLoaded() || this.mGsmPhone.mSST.getCurrentGprsState() != 0 || roaming && !this.getDataOnRoamingEnabled() || this.mIsWifiConnected || this.mIsPsRestricted)) {
            return this.mState == DataConnectionTracker.State.CONNECTED;
        }
        return true;
    }

    @Override
    public boolean isApnTypeAvailable(String type) {
        if (type.equals("dun")) {
            return this.fetchDunApn() != null;
        }
        if (this.mAllApns != null) {
            for (ApnSetting apn : this.mAllApns) {
                if (!apn.canHandleType(type)) continue;
                return true;
            }
        }
        return false;
    }

    public void onGprsDetached() {
        this.stopNetStatPoll();
        this.notifyDataConnection("gprsDetached");
    }

    public void onGprsAttached() {
        if (this.mState == DataConnectionTracker.State.CONNECTED) {
            this.startNetStatPoll();
            this.notifyDataConnection("gprsAttached");
        } else {
            if (this.mState == DataConnectionTracker.State.FAILED) {
                this.cleanUpConnection(false, "gprsAttached");
                this.mRetryMgr.resetRetryCount();
            }
            this.trySetupData("gprsAttached");
        }
    }

    @Override
    public boolean isDataAllowed() {
        boolean allowed;
        int gprsState = this.mGsmPhone.mSST.getCurrentGprsState();
        boolean desiredPowerState = this.mGsmPhone.mSST.getDesiredPowerState();
        boolean bl = allowed = !(gprsState != 0 && !this.mAutoAttachOnCreation || !this.mGsmPhone.mSIMRecords.getRecordsLoaded() || this.mPhone.getState() != Phone.State.IDLE || !this.mInternalDataEnabled || this.mPhone.getServiceState().getRoaming() && !this.getDataOnRoamingEnabled() || this.mIsPsRestricted || !desiredPowerState);
        if (!allowed) {
            String reason = "";
            if (gprsState != 0 && !this.mAutoAttachOnCreation) {
                reason = reason + " - gprs= " + gprsState;
            }
            if (!this.mGsmPhone.mSIMRecords.getRecordsLoaded()) {
                reason = reason + " - SIM not loaded";
            }
            if (this.mPhone.getState() != Phone.State.IDLE) {
                reason = reason + " - PhoneState= " + (Object)((Object)this.mPhone.getState());
            }
            if (!this.mInternalDataEnabled) {
                reason = reason + " - mInternalDataEnabled= false";
            }
            if (this.mPhone.getServiceState().getRoaming() && !this.getDataOnRoamingEnabled()) {
                reason = reason + " - Roaming and data roaming not enabled";
            }
            if (this.mIsPsRestricted) {
                reason = reason + " - mIsPsRestricted= true";
            }
            if (!desiredPowerState) {
                reason = reason + " - desiredPowerState= false";
            }
            this.log("Data not allowed due to" + reason);
        }
        return allowed;
    }

    public boolean trySetupData(String reason) {
        this.log("***trySetupData due to " + (reason == null ? "(unspecified)" : reason));
        this.log("[DSAC DEB] trySetupData with mIsPsRestricted=" + this.mIsPsRestricted);
        if (this.mPhone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.notifyDataConnection(reason);
            this.log("(fix?) We're on the simulator; assuming data is connected");
            return true;
        }
        int gprsState = this.mGsmPhone.mSST.getCurrentGprsState();
        boolean desiredPowerState = this.mGsmPhone.mSST.getDesiredPowerState();
        if ((this.mState == DataConnectionTracker.State.IDLE || this.mState == DataConnectionTracker.State.SCANNING) && this.isDataAllowed() && this.getAnyDataEnabled()) {
            if (this.mState == DataConnectionTracker.State.IDLE) {
                this.mWaitingApns = this.buildWaitingApns(this.mRequestedApnType);
                this.mWaitingApnsPermanentFailureCountDown = this.mWaitingApns.size();
                if (this.mWaitingApns.isEmpty()) {
                    this.log("No APN found");
                    this.notifyNoData(DataConnection.FailCause.MISSING_UNKNOWN_APN);
                    this.notifyOffApnsOfAvailability(reason, false);
                    return false;
                }
                this.log("Create from allApns : " + this.apnListToString(this.mAllApns));
            }
            this.log("Setup waitngApns : " + this.apnListToString(this.mWaitingApns));
            boolean retValue = this.setupData(reason);
            this.notifyOffApnsOfAvailability(reason, retValue);
            return retValue;
        }
        this.notifyOffApnsOfAvailability(reason, false);
        return false;
    }

    public void cleanUpConnection(boolean tearDown, String reason) {
        this.log("Clean up connection due to " + reason);
        if (this.mReconnectIntent != null) {
            AlarmManager am = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
            am.cancel(this.mReconnectIntent);
            this.mReconnectIntent = null;
        }
        this.setState(DataConnectionTracker.State.DISCONNECTING);
        boolean notificationDeferred = false;
        for (DataConnection conn : this.mDataConnections.values()) {
            if (tearDown) {
                this.log("cleanUpConnection: teardown, call conn.disconnect");
                conn.disconnect(this.obtainMessage(25, conn.getDataConnectionId(), 0, reason));
                notificationDeferred = true;
                continue;
            }
            this.log("cleanUpConnection: !tearDown, call conn.resetSynchronously");
            conn.resetSynchronously();
            notificationDeferred = false;
        }
        this.stopNetStatPoll();
        if (!notificationDeferred) {
            this.log("cleanupConnection: !notificationDeferred");
            this.gotoIdleAndNotifyDataConnection(reason);
        }
    }

    public String[] parseTypes(String types) {
        String[] result = types == null || types.equals("") ? new String[]{"*"} : types.split(",");
        return result;
    }

    public ArrayList<ApnSetting> createApnList(Cursor cursor) {
        ArrayList<ApnSetting> result = new ArrayList<ApnSetting>();
        if (cursor.moveToFirst()) {
            do {
                String[] types = this.parseTypes(cursor.getString(cursor.getColumnIndexOrThrow("type")));
                ApnSetting apn = new ApnSetting(cursor.getInt(cursor.getColumnIndexOrThrow("_id")), cursor.getString(cursor.getColumnIndexOrThrow("numeric")), cursor.getString(cursor.getColumnIndexOrThrow("name")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), cursor.getString(cursor.getColumnIndexOrThrow("proxy")), cursor.getString(cursor.getColumnIndexOrThrow("port")), cursor.getString(cursor.getColumnIndexOrThrow("mmsc")), cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy")), cursor.getString(cursor.getColumnIndexOrThrow("mmsport")), cursor.getString(cursor.getColumnIndexOrThrow("user")), cursor.getString(cursor.getColumnIndexOrThrow("password")), cursor.getInt(cursor.getColumnIndexOrThrow("authtype")), types, cursor.getString(cursor.getColumnIndexOrThrow("protocol")), cursor.getString(cursor.getColumnIndexOrThrow("roaming_protocol")));
                result.add(apn);
            } while (cursor.moveToNext());
        }
        return result;
    }

    public GsmDataConnection findFreeDataConnection() {
        for (DataConnection dc : this.mDataConnections.values()) {
            if (!dc.isInactive()) continue;
            this.log("found free GsmDataConnection");
            return (GsmDataConnection)dc;
        }
        this.log("NO free GsmDataConnection");
        return null;
    }

    public boolean setupData(String reason) {
        ApnSetting apn = this.getNextApn();
        if (apn == null) {
            return false;
        }
        GsmDataConnection gdc = this.findFreeDataConnection();
        if (gdc == null) {
            this.log("setupData: No free GsmDataConnection found!");
            return false;
        }
        this.mActiveApn = apn;
        this.mPendingDataConnection = gdc;
        Message msg = this.obtainMessage();
        msg.what = 1;
        msg.obj = reason;
        gdc.connect(msg, apn);
        this.setState(DataConnectionTracker.State.INITING);
        this.notifyDataConnection(reason);
        return true;
    }

    public boolean dataCallStatesHasCID(ArrayList<DataCallState> states, int cid) {
        int s = states.size();
        for (int i = 0; i < s; ++i) {
            if (states.get((int)i).cid != cid) continue;
            return true;
        }
        return false;
    }

    public boolean dataCallStatesHasActiveCID(ArrayList<DataCallState> states, int cid) {
        int s = states.size();
        for (int i = 0; i < s; ++i) {
            if (states.get((int)i).cid != cid || states.get((int)i).active == 0) continue;
            return true;
        }
        return false;
    }

    public void onApnChanged() {
        boolean isConnected = this.mState != DataConnectionTracker.State.IDLE && this.mState != DataConnectionTracker.State.FAILED;
        this.mGsmPhone.updateCurrentCarrierInProvider();
        this.createAllApnList();
        if (this.mState != DataConnectionTracker.State.DISCONNECTING) {
            this.cleanUpConnection(isConnected, "apnChanged");
            if (!isConnected) {
                this.mRetryMgr.resetRetryCount();
                this.mReregisterOnReconnectFailure = false;
                this.trySetupData("apnChanged");
            }
        }
    }

    public void onDataStateChanged(AsyncResult ar, boolean explicitPoll) {
        ArrayList dataCallStates = (ArrayList)ar.result;
        if (ar.exception != null) {
            return;
        }
        if (this.mState == DataConnectionTracker.State.CONNECTED) {
            if (!this.dataCallStatesHasCID(dataCallStates, this.mCidActive)) {
                this.log("PDP connection has dropped. Reconnecting");
                GsmCellLocation loc = (GsmCellLocation)this.mPhone.getCellLocation();
                EventLog.writeEvent(50109, loc != null ? loc.getCid() : -1, TelephonyManager.getDefault().getNetworkType());
                this.cleanUpConnection(true, null);
                return;
            }
            if (!this.dataCallStatesHasActiveCID(dataCallStates, this.mCidActive)) {
                if (!explicitPoll) {
                    this.mPhone.mCM.getPDPContextList(this.obtainMessage(11));
                } else {
                    this.log("PDP connection has dropped (active=false case).  Reconnecting");
                    GsmCellLocation loc = (GsmCellLocation)this.mPhone.getCellLocation();
                    EventLog.writeEvent(50109, loc != null ? loc.getCid() : -1, TelephonyManager.getDefault().getNetworkType());
                    this.cleanUpConnection(true, null);
                }
            }
        }
    }

    public void notifyDefaultData(String reason) {
        this.setState(DataConnectionTracker.State.CONNECTED);
        this.notifyDataConnection(reason);
        this.startNetStatPoll();
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
    }

    public void gotoIdleAndNotifyDataConnection(String reason) {
        this.log("gotoIdleAndNotifyDataConnection: reason=" + reason);
        this.setState(DataConnectionTracker.State.IDLE);
        this.notifyDataConnection(reason);
        this.mActiveApn = null;
    }

    public void resetPollStats() {
        this.mTxPkts = -1L;
        this.mRxPkts = -1L;
        this.mSentSinceLastRecv = 0L;
        this.mNetStatPollPeriod = 1000;
        this.mNoRecvPollCount = 0;
    }

    public void doRecovery() {
        if (this.mState == DataConnectionTracker.State.CONNECTED) {
            int maxPdpReset = Settings.Secure.getInt(this.mResolver, "pdp_watchdog_max_pdp_reset_fail_count", 3);
            if (this.mPdpResetCount < maxPdpReset) {
                ++this.mPdpResetCount;
                EventLog.writeEvent(50102, this.mSentSinceLastRecv);
                this.cleanUpConnection(true, "pdpReset");
            } else {
                this.mPdpResetCount = 0;
                EventLog.writeEvent(50104, this.mSentSinceLastRecv);
                this.mGsmPhone.mSST.reRegisterNetwork(null);
            }
        }
    }

    @Override
    public void startNetStatPoll() {
        if (this.mState == DataConnectionTracker.State.CONNECTED && !this.mNetStatPollEnabled) {
            this.log("[DataConnection] Start poll NetStat");
            this.resetPollStats();
            this.mNetStatPollEnabled = true;
            this.mPollNetStat.run();
        }
    }

    @Override
    public void stopNetStatPoll() {
        this.mNetStatPollEnabled = false;
        this.removeCallbacks(this.mPollNetStat);
        this.log("[DataConnection] Stop poll NetStat");
    }

    @Override
    public void restartRadio() {
        this.log("************TURN OFF RADIO**************");
        this.cleanUpConnection(true, "radioTurnedOff");
        this.mGsmPhone.mSST.powerOffRadioSafely();
        int reset = Integer.parseInt(SystemProperties.get("net.ppp.reset-by-timeout", "0"));
        SystemProperties.set("net.ppp.reset-by-timeout", String.valueOf(reset + 1));
    }

    public boolean shouldPostNotification(DataConnection.FailCause cause) {
        return cause != DataConnection.FailCause.UNKNOWN;
    }

    public boolean retryAfterDisconnected(String reason) {
        boolean retry = true;
        if ("radioTurnedOff".equals(reason)) {
            retry = false;
        }
        return retry;
    }

    public void reconnectAfterFail(DataConnection.FailCause lastFailCauseCode, String reason) {
        if (this.mState == DataConnectionTracker.State.FAILED) {
            if (!this.mRetryMgr.isRetryNeeded()) {
                if (!this.mRequestedApnType.equals("default")) {
                    this.notifyDataConnection("apnFailed");
                    this.onEnableApn(this.apnTypeToId(this.mRequestedApnType), 0);
                    return;
                }
                if (this.mReregisterOnReconnectFailure) {
                    this.mRetryMgr.retryForeverUsingLastTimeout();
                } else {
                    this.log("PDP activate failed, Reregistering to the network");
                    this.mReregisterOnReconnectFailure = true;
                    this.mGsmPhone.mSST.reRegisterNetwork(null);
                    this.mRetryMgr.resetRetryCount();
                    return;
                }
            }
            int nextReconnectDelay = this.mRetryMgr.getRetryTimer();
            this.log("PDP activate failed. Scheduling next attempt for " + nextReconnectDelay / 1000 + "s");
            AlarmManager am = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
            Intent intent = new Intent(INTENT_RECONNECT_ALARM);
            intent.putExtra("reason", reason);
            this.mReconnectIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0);
            am.set(2, SystemClock.elapsedRealtime() + (long)nextReconnectDelay, this.mReconnectIntent);
            this.mRetryMgr.increaseRetryCount();
            if (!this.shouldPostNotification(lastFailCauseCode)) {
                this.log("NOT Posting GPRS Unavailable notification -- likely transient error");
            } else {
                this.notifyNoData(lastFailCauseCode);
            }
        }
    }

    public void notifyNoData(DataConnection.FailCause lastFailCauseCode) {
        this.setState(DataConnectionTracker.State.FAILED);
    }

    public void onRecordsLoaded() {
        this.createAllApnList();
        if (this.mState == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, null);
        }
        this.sendMessage(this.obtainMessage(5, "simLoaded"));
    }

    @Override
    public void onEnableNewApn() {
        this.log("onEnableNewApn E");
        if (this.mRequestedApnType.equals("default")) {
            this.log("onEnableNewApn default type");
            this.mRetryMgr = this.mPendingDataConnection.getRetryMgr();
            this.mRetryMgr.resetRetryCount();
        } else if (this.mApnToDataConnectionId.get(this.mRequestedApnType) == null) {
            this.log("onEnableNewApn mRequestedApnType=" + this.mRequestedApnType + " missing, make a new connection");
            int id2 = this.createDataConnection(this.mRequestedApnType);
            this.mRetryMgr = ((DataConnection)this.mDataConnections.get(id2)).getRetryMgr();
            this.mRetryMgr.resetRetryCount();
        } else {
            this.log("oneEnableNewApn connection already exists, nothing to setup");
        }
        this.cleanUpConnection(true, "apnSwitched");
        this.log("onEnableNewApn X");
    }

    @Override
    public boolean onTrySetupData(String reason) {
        return this.trySetupData(reason);
    }

    @Override
    public void onRoamingOff() {
        this.trySetupData("roamingOff");
    }

    @Override
    public void onRoamingOn() {
        if (this.getDataOnRoamingEnabled()) {
            this.trySetupData("roamingOn");
        } else {
            this.log("Tear down data connection on roaming.");
            this.cleanUpConnection(true, "roamingOn");
        }
    }

    @Override
    public void onRadioAvailable() {
        if (this.mPhone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.notifyDataConnection(null);
            this.log("We're on the simulator; assuming data is connected");
        }
        if (this.mState != DataConnectionTracker.State.IDLE) {
            this.cleanUpConnection(true, null);
        }
    }

    @Override
    public void onRadioOffOrNotAvailable() {
        this.mRetryMgr.resetRetryCount();
        this.mReregisterOnReconnectFailure = false;
        if (this.mPhone.getSimulatedRadioControl() != null) {
            this.log("We're on the simulator; assuming radio off is meaningless");
        } else {
            this.log("Radio is off and clean up all connection");
            this.cleanUpConnection(false, "radioTurnedOff");
        }
    }

    @Override
    public void onDataSetupComplete(AsyncResult ar) {
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        if (ar.exception == null) {
            this.log(String.format("onDataSetupComplete: success apn=%s", this.mWaitingApns.get((int)0).apn));
            this.mLinkProperties = this.getLinkProperties(this.mPendingDataConnection);
            this.mLinkCapabilities = this.getLinkCapabilities(this.mPendingDataConnection);
            ApnSetting apn = this.mPendingDataConnection.getApn();
            if (apn.proxy != null && apn.proxy.length() != 0) {
                try {
                    ProxyProperties proxy = new ProxyProperties(apn.proxy, Integer.parseInt(apn.port), null);
                    this.mLinkProperties.setHttpProxy(proxy);
                }
                catch (NumberFormatException e) {
                    this.loge("NumberFormatException making ProxyProperties (" + apn.port + "): " + e);
                }
            }
            if (this.isApnTypeActive("default")) {
                SystemProperties.set("gsm.defaultpdpcontext.active", "true");
                if (this.canSetPreferApn && this.mPreferredApn == null) {
                    this.log("PREFERRED APN is null");
                    this.mPreferredApn = this.mActiveApn;
                    this.setPreferredApn(this.mPreferredApn.id);
                }
            } else {
                SystemProperties.set("gsm.defaultpdpcontext.active", "false");
            }
            this.notifyDefaultData(reason);
        } else {
            String apnString;
            DataConnection.FailCause cause = (DataConnection.FailCause)((Object)ar.result);
            try {
                apnString = this.mWaitingApns.get((int)0).apn;
            }
            catch (Exception e) {
                apnString = "<unknown>";
            }
            this.log(String.format("onDataSetupComplete: error apn=%s cause=%s", new Object[]{apnString, cause}));
            if (cause.isEventLoggable()) {
                GsmCellLocation loc = (GsmCellLocation)this.mPhone.getCellLocation();
                EventLog.writeEvent(50105, cause.ordinal(), loc != null ? loc.getCid() : -1, TelephonyManager.getDefault().getNetworkType());
            }
            this.mWaitingApnsPermanentFailureCountDown -= cause.isPermanentFail() ? 1 : 0;
            this.mWaitingApns.remove(0);
            this.log(String.format("onDataSetupComplete: mWaitingApns.size=%d mWaitingApnsPermanenatFailureCountDown=%d", this.mWaitingApns.size(), this.mWaitingApnsPermanentFailureCountDown));
            if (this.mWaitingApns.isEmpty()) {
                if (this.mWaitingApnsPermanentFailureCountDown == 0) {
                    this.log("onDataSetupComplete: Permanent failures stop retrying");
                    this.notifyNoData(cause);
                    this.notifyDataConnection("apnFailed");
                } else {
                    this.log("onDataSetupComplete: Not all permanent failures, retry");
                    this.startDelayedRetry(cause, reason);
                }
            } else {
                this.log("onDataSetupComplete: Try next APN");
                this.setState(DataConnectionTracker.State.SCANNING);
                this.sendMessageDelayed(this.obtainMessage(5, reason), 5000L);
            }
        }
    }

    @Override
    public void onDisconnectDone(int connId, AsyncResult ar) {
        this.log("EVENT_DISCONNECT_DONE connId=" + connId);
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.setState(DataConnectionTracker.State.IDLE);
        this.notifyDataConnection(reason);
        this.mActiveApn = null;
        if (this.retryAfterDisconnected(reason)) {
            this.trySetupData(reason);
        }
    }

    @Override
    public void onResetDone(AsyncResult ar) {
        this.log("EVENT_RESET_DONE");
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.gotoIdleAndNotifyDataConnection(reason);
    }

    public void onPollPdp() {
        if (this.mState == DataConnectionTracker.State.CONNECTED) {
            this.mPhone.mCM.getPDPContextList(this.obtainMessage(11));
            this.sendMessageDelayed(this.obtainMessage(7), 5000L);
        }
    }

    @Override
    public void onVoiceCallStarted() {
        if (this.mState == DataConnectionTracker.State.CONNECTED && !this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
            this.stopNetStatPoll();
            this.notifyDataConnection("2GVoiceCallStarted");
        }
    }

    @Override
    public void onVoiceCallEnded() {
        if (this.mState == DataConnectionTracker.State.CONNECTED) {
            if (!this.mGsmPhone.mSST.isConcurrentVoiceAndData()) {
                this.startNetStatPoll();
                this.notifyDataConnection("2GVoiceCallEnded");
            } else {
                this.resetPollStats();
            }
        } else {
            this.mRetryMgr.resetRetryCount();
            this.mReregisterOnReconnectFailure = false;
            this.trySetupData("2GVoiceCallEnded");
        }
    }

    @Override
    public void onCleanUpConnection(boolean tearDown, String reason) {
        this.cleanUpConnection(tearDown, reason);
    }

    public void createAllApnList() {
        this.mAllApns = new ArrayList();
        String operator = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
        if (operator != null) {
            String selection = "numeric = '" + operator + "'";
            Cursor cursor = this.mPhone.getContext().getContentResolver().query(Telephony.Carriers.CONTENT_URI, null, selection, null, null);
            if (cursor != null) {
                if (cursor.getCount() > 0) {
                    this.mAllApns = this.createApnList(cursor);
                }
                cursor.close();
            }
        }
        if (this.mAllApns.isEmpty()) {
            this.log("No APN found for carrier: " + operator);
            this.mPreferredApn = null;
            this.notifyNoData(DataConnection.FailCause.MISSING_UNKNOWN_APN);
        } else {
            this.mPreferredApn = this.getPreferredApn();
            this.log("Get PreferredAPN");
            if (this.mPreferredApn != null && !this.mPreferredApn.numeric.equals(operator)) {
                this.mPreferredApn = null;
                this.setPreferredApn(-1);
            }
        }
    }

    public int createDataConnection(String apnType) {
        this.log("createDataConnection(" + apnType + ") E");
        RetryManager rm = new RetryManager();
        if (apnType.equals("default")) {
            if (!rm.configure(SystemProperties.get("ro.gsm.data_retry_config")) && !rm.configure("default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000")) {
                this.log("Could not configure using DEFAULT_DATA_RETRY_CONFIG=default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000");
                rm.configure(20, 2000, 1000);
            }
        } else if (!rm.configure(SystemProperties.get("ro.gsm.2nd_data_retry_config")) && !rm.configure("max_retries=3, 5000, 5000, 5000")) {
            this.log("Could note configure using SECONDARY_DATA_RETRY_CONFIG=max_retries=3, 5000, 5000, 5000");
            rm.configure("max_retries=3, 333, 333, 333");
        }
        int id2 = this.mUniqueIdGenerator.getAndIncrement();
        GsmDataConnection conn = GsmDataConnection.makeDataConnection(this.mGsmPhone, id2, rm);
        this.mDataConnections.put(id2, conn);
        this.mApnToDataConnectionId.put(apnType, id2);
        this.log("createDataConnection(" + apnType + ") X id=" + id2);
        return id2;
    }

    public void destroyDataConnections() {
        if (this.mDataConnections != null) {
            this.log("destroyDataConnectionList clear mDataConnectionList");
            this.mDataConnections.clear();
        } else {
            this.log("destroyDataConnectionList mDataConnecitonList is empty, ignore");
        }
    }

    public ApnSetting fetchDunApn() {
        Context c = this.mPhone.getContext();
        String apnData = Settings.Secure.getString(c.getContentResolver(), "tether_dun_apn");
        ApnSetting dunSetting = ApnSetting.fromString(apnData);
        if (dunSetting != null) {
            return dunSetting;
        }
        apnData = c.getResources().getString(17039383);
        return ApnSetting.fromString(apnData);
    }

    public ArrayList<ApnSetting> buildWaitingApns(String requestedApnType) {
        ArrayList<ApnSetting> apnList = new ArrayList<ApnSetting>();
        if (requestedApnType.equals("dun")) {
            ApnSetting dun = this.fetchDunApn();
            if (dun != null) {
                apnList.add(dun);
            }
            return apnList;
        }
        String operator = this.mGsmPhone.mSIMRecords.getSIMOperatorNumeric();
        if (requestedApnType.equals("default") && this.canSetPreferApn && this.mPreferredApn != null) {
            this.log("Preferred APN:" + operator + ":" + this.mPreferredApn.numeric + ":" + this.mPreferredApn);
            if (this.mPreferredApn.numeric.equals(operator)) {
                this.log("Waiting APN set to preferred APN");
                apnList.add(this.mPreferredApn);
                return apnList;
            }
            this.setPreferredApn(-1);
            this.mPreferredApn = null;
        }
        if (this.mAllApns != null) {
            for (ApnSetting apn : this.mAllApns) {
                if (!apn.canHandleType(requestedApnType)) continue;
                apnList.add(apn);
            }
        }
        return apnList;
    }

    public ApnSetting getNextApn() {
        ArrayList<ApnSetting> list = this.mWaitingApns;
        ApnSetting apn = null;
        if (list != null && !list.isEmpty()) {
            apn = list.get(0);
        }
        return apn;
    }

    public String apnListToString(ArrayList<ApnSetting> apns) {
        StringBuilder result = new StringBuilder();
        int size = apns.size();
        for (int i = 0; i < size; ++i) {
            result.append('[').append(apns.get(i).toString()).append(']');
        }
        return result.toString();
    }

    public void startDelayedRetry(DataConnection.FailCause cause, String reason) {
        this.notifyNoData(cause);
        this.reconnectAfterFail(cause, reason);
    }

    public void setPreferredApn(int pos) {
        if (!this.canSetPreferApn) {
            return;
        }
        ContentResolver resolver = this.mPhone.getContext().getContentResolver();
        resolver.delete(PREFERAPN_URI, null, null);
        if (pos >= 0) {
            ContentValues values = new ContentValues();
            values.put(APN_ID, pos);
            resolver.insert(PREFERAPN_URI, values);
        }
    }

    public ApnSetting getPreferredApn() {
        if (this.mAllApns.isEmpty()) {
            return null;
        }
        Cursor cursor = this.mPhone.getContext().getContentResolver().query(PREFERAPN_URI, new String[]{"_id", "name", "apn"}, null, null, "name ASC");
        this.canSetPreferApn = cursor != null;
        if (this.canSetPreferApn && cursor.getCount() > 0) {
            cursor.moveToFirst();
            int pos = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            for (ApnSetting p : this.mAllApns) {
                if (p.id != pos || !p.canHandleType(this.mRequestedApnType)) continue;
                cursor.close();
                return p;
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        return null;
    }

    @Override
    public void handleMessage(Message msg) {
        this.log("GSMDataConnTrack handleMessage " + msg);
        if (!this.mGsmPhone.mIsTheCurrentActivePhone) {
            this.log("Ignore GSM msgs since GSM phone is inactive");
            return;
        }
        switch (msg.what) {
            case 4: {
                this.onRecordsLoaded();
                break;
            }
            case 19: {
                this.onGprsDetached();
                break;
            }
            case 26: {
                this.onGprsAttached();
                break;
            }
            case 6: {
                this.onDataStateChanged((AsyncResult)msg.obj, false);
                break;
            }
            case 11: {
                this.onDataStateChanged((AsyncResult)msg.obj, true);
                break;
            }
            case 7: {
                this.onPollPdp();
                break;
            }
            case 27: {
                this.startNetStatPoll();
                break;
            }
            case 28: {
                this.doRecovery();
                break;
            }
            case 29: {
                this.onApnChanged();
                break;
            }
            case 32: {
                this.log("[DSAC DEB] EVENT_PS_RESTRICT_ENABLED " + this.mIsPsRestricted);
                this.stopNetStatPoll();
                this.mIsPsRestricted = true;
                break;
            }
            case 33: {
                this.log("[DSAC DEB] EVENT_PS_RESTRICT_DISABLED " + this.mIsPsRestricted);
                this.mIsPsRestricted = false;
                if (this.mState == DataConnectionTracker.State.CONNECTED) {
                    this.startNetStatPoll();
                    break;
                }
                if (this.mState == DataConnectionTracker.State.FAILED) {
                    this.cleanUpConnection(false, "psRestrictEnabled");
                    this.mRetryMgr.resetRetryCount();
                    this.mReregisterOnReconnectFailure = false;
                }
                this.trySetupData("psRestrictEnabled");
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    @Override
    public void log(String s) {
        Log.d("GSM", "[GsmDataConnectionTracker] " + s);
    }

    @Override
    public void loge(String s) {
        Log.e("GSM", "[GsmDataConnectionTracker] " + s);
    }

    public class ApnChangeObserver
    extends ContentObserver {
        public ApnChangeObserver() {
            super(GsmDataConnectionTracker.this.mDataConnectionTracker);
        }

        public void onChange(boolean selfChange) {
            GsmDataConnectionTracker.this.sendMessage(GsmDataConnectionTracker.this.obtainMessage(29));
        }
    }
}

