/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

public class SmsCbHeader {
    public static final int PDU_HEADER_LENGTH = 6;
    public final int geographicalScope;
    public final int messageCode;
    public final int updateNumber;
    public final int messageIdentifier;
    public final int dataCodingScheme;
    public final int pageIndex;
    public final int nrOfPages;

    public SmsCbHeader(byte[] pdu) throws IllegalArgumentException {
        if (pdu == null || pdu.length < 6) {
            throw new IllegalArgumentException("Illegal PDU");
        }
        this.geographicalScope = (pdu[0] & 0xC0) >> 6;
        this.messageCode = (pdu[0] & 0x3F) << 4 | (pdu[1] & 0xF0) >> 4;
        this.updateNumber = pdu[1] & 0xF;
        this.messageIdentifier = pdu[2] << 8 | pdu[3];
        this.dataCodingScheme = pdu[4];
        int pageIndex = (pdu[5] & 0xF0) >> 4;
        int nrOfPages = pdu[5] & 0xF;
        if (pageIndex == 0 || nrOfPages == 0 || pageIndex > nrOfPages) {
            pageIndex = 1;
            nrOfPages = 1;
        }
        this.pageIndex = pageIndex;
        this.nrOfPages = nrOfPages;
    }
}

