/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.content.Context;
import android.media.AudioManager;
import android.net.rtp.AudioGroup;
import android.net.sip.SipAudioCall;
import android.net.sip.SipErrorCode;
import android.net.sip.SipException;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.sip.SipCallBase;
import com.android.internal.telephony.sip.SipConnectionBase;
import com.android.internal.telephony.sip.SipPhoneBase;
import java.text.ParseException;
import java.util.List;

public class SipPhone
extends SipPhoneBase {
    public static final String LOG_TAG = "SipPhone";
    public static final boolean DEBUG = true;
    public static final int TIMEOUT_MAKE_CALL = 15;
    public static final int TIMEOUT_ANSWER_CALL = 8;
    public static final int TIMEOUT_HOLD_CALL = 15;
    public SipCall ringingCall = new SipCall(null);
    public SipCall foregroundCall = new SipCall(null);
    public SipCall backgroundCall = new SipCall(null);
    public SipManager mSipManager;
    public SipProfile mProfile;

    public SipPhone(Context context, PhoneNotifier notifier, SipProfile profile) {
        super(context, notifier);
        Log.d(LOG_TAG, "new SipPhone: " + profile.getUriString());
        this.ringingCall = new SipCall(null);
        this.foregroundCall = new SipCall(null);
        this.backgroundCall = new SipCall(null);
        this.mProfile = profile;
        this.mSipManager = SipManager.newInstance(context);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SipPhone)) {
            return false;
        }
        SipPhone that = (SipPhone)o;
        return this.mProfile.getUriString().equals(that.mProfile.getUriString());
    }

    public String getPhoneName() {
        return "SIP:" + this.getUriString(this.mProfile);
    }

    public String getSipUri() {
        return this.mProfile.getUriString();
    }

    public boolean equals(SipPhone phone) {
        return this.getSipUri().equals(phone.getSipUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canTake(Object incomingCall) {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (!(incomingCall instanceof SipAudioCall)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            if (this.ringingCall.getState().isAlive()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            if (this.foregroundCall.getState().isAlive() && this.backgroundCall.getState().isAlive()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            try {
                SipAudioCall sipAudioCall = (SipAudioCall)incomingCall;
                Log.d(LOG_TAG, "+++ taking call from: " + sipAudioCall.getPeerProfile().getUriString());
                String localUri = sipAudioCall.getLocalProfile().getUriString();
                if (localUri.equals(this.mProfile.getUriString())) {
                    boolean makeCallWait = this.foregroundCall.getState().isAlive();
                    this.ringingCall.initIncomingCall(sipAudioCall, makeCallWait);
                    if (sipAudioCall.getState() != 3) {
                        Log.d(LOG_TAG, "    call cancelled !!");
                        this.ringingCall.reset();
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
            }
            catch (Exception e) {
                this.ringingCall.reset();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptCall() throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (this.ringingCall.getState() != Call.State.INCOMING && this.ringingCall.getState() != Call.State.WAITING) {
                throw new CallStateException("phone not ringing");
            }
            Log.d(LOG_TAG, "acceptCall");
            this.ringingCall.setMute(false);
            this.ringingCall.acceptCall();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectCall() throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (!this.ringingCall.getState().isRinging()) {
                throw new CallStateException("phone not ringing");
            }
            Log.d(LOG_TAG, "rejectCall");
            this.ringingCall.rejectCall();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection dial(String dialString) throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.dialInternal(dialString);
        }
    }

    public Connection dialInternal(String dialString) throws CallStateException {
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        if (this.foregroundCall.getState() == Call.State.ACTIVE) {
            this.switchHoldingAndActive();
        }
        if (this.foregroundCall.getState() != Call.State.IDLE) {
            throw new CallStateException("cannot dial in current state");
        }
        this.foregroundCall.setMute(false);
        try {
            Connection c = this.foregroundCall.dial(dialString);
            return c;
        }
        catch (SipException e) {
            Log.e(LOG_TAG, "dial()", e);
            throw new CallStateException("dial error: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchHoldingAndActive() throws CallStateException {
        Log.d(LOG_TAG, " ~~~~~~  switch fg and bg");
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.foregroundCall.switchWith(this.backgroundCall);
            if (this.backgroundCall.getState().isAlive()) {
                this.backgroundCall.hold();
            }
            if (this.foregroundCall.getState().isAlive()) {
                this.foregroundCall.unhold();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean canConference() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conference() throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (this.foregroundCall.getState() != Call.State.ACTIVE || this.foregroundCall.getState() != Call.State.ACTIVE) {
                throw new CallStateException("wrong state to merge calls: fg=" + (Object)((Object)this.foregroundCall.getState()) + ", bg=" + (Object)((Object)this.backgroundCall.getState()));
            }
            this.foregroundCall.merge(this.backgroundCall);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conference(Call that) throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (!(that instanceof SipCall)) {
                throw new CallStateException("expect " + SipCall.class + ", cannot merge with " + that.getClass());
            }
            this.foregroundCall.merge((SipCall)that);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean canTransfer() {
        return false;
    }

    public void explicitCallTransfer() throws CallStateException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDisconnected() {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.ringingCall.clearDisconnected();
            this.foregroundCall.clearDisconnected();
            this.backgroundCall.clearDisconnected();
            this.updatePhoneState();
            this.notifyPreciseCallStateChanged();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Log.e(LOG_TAG, "sendDtmf called with invalid character '" + c + "'");
            return;
        }
        if (!this.foregroundCall.getState().isAlive()) return;
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.foregroundCall.sendDtmf(c);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Log.e(LOG_TAG, "startDtmf called with invalid character '" + c + "'");
        } else {
            this.sendDtmf(c);
        }
    }

    public void stopDtmf() {
    }

    public void sendBurstDtmf(String dtmfString) {
        Log.e(LOG_TAG, "[SipPhone] sendBurstDtmf() is a CDMA method");
    }

    public void getOutgoingCallerIdDisplay(Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    public void setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    public void getCallWaiting(Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    public void setCallWaiting(boolean enable, Message onComplete) {
        Log.e(LOG_TAG, "call waiting not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEchoSuppressionEnabled(boolean enabled) {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.foregroundCall.setAudioGroupMode();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMute(boolean muted) {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.foregroundCall.setMute(muted);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean getMute() {
        return this.foregroundCall.getState().isAlive() ? this.foregroundCall.getMute() : this.backgroundCall.getMute();
    }

    public Call getForegroundCall() {
        return this.foregroundCall;
    }

    public Call getBackgroundCall() {
        return this.backgroundCall;
    }

    public Call getRingingCall() {
        return this.ringingCall;
    }

    public ServiceState getServiceState() {
        return super.getServiceState();
    }

    public String getUriString(SipProfile p) {
        return p.getUserName() + "@" + this.getSipDomain(p);
    }

    public String getSipDomain(SipProfile p) {
        String domain = p.getSipDomain();
        if (domain.endsWith(":5060")) {
            return domain.substring(0, domain.length() - 5);
        }
        return domain;
    }

    public static Call.State getCallStateFrom(SipAudioCall sipAudioCall) {
        if (sipAudioCall.isOnHold()) {
            return Call.State.HOLDING;
        }
        int sessionState = sipAudioCall.getState();
        switch (sessionState) {
            case 0: {
                return Call.State.IDLE;
            }
            case 3: 
            case 4: {
                return Call.State.INCOMING;
            }
            case 5: {
                return Call.State.DIALING;
            }
            case 6: {
                return Call.State.ALERTING;
            }
            case 7: {
                return Call.State.DISCONNECTING;
            }
            case 8: {
                return Call.State.ACTIVE;
            }
        }
        Log.w(LOG_TAG, "illegal connection state: " + sessionState);
        return Call.State.DISCONNECTED;
    }

    public static class 1 {
    }

    public abstract class SipAudioCallAdapter
    extends SipAudioCall.Listener {
        public SipAudioCallAdapter() {
        }

        public abstract void onCallEnded(Connection.DisconnectCause var1);

        public abstract void onError(Connection.DisconnectCause var1);

        public void onCallEnded(SipAudioCall call) {
            this.onCallEnded(call.isInCall() ? Connection.DisconnectCause.NORMAL : Connection.DisconnectCause.INCOMING_MISSED);
        }

        public void onCallBusy(SipAudioCall call) {
            this.onCallEnded(Connection.DisconnectCause.BUSY);
        }

        public void onError(SipAudioCall call, int errorCode, String errorMessage) {
            switch (errorCode) {
                case -12: {
                    this.onError(Connection.DisconnectCause.SERVER_UNREACHABLE);
                    break;
                }
                case -7: {
                    this.onError(Connection.DisconnectCause.NUMBER_UNREACHABLE);
                    break;
                }
                case -6: {
                    this.onError(Connection.DisconnectCause.INVALID_NUMBER);
                    break;
                }
                case -5: 
                case -3: {
                    this.onError(Connection.DisconnectCause.TIMED_OUT);
                    break;
                }
                case -10: {
                    this.onError(Connection.DisconnectCause.LOST_SIGNAL);
                    break;
                }
                case -8: {
                    this.onError(Connection.DisconnectCause.INVALID_CREDENTIALS);
                    break;
                }
                case -11: {
                    this.onError(Connection.DisconnectCause.OUT_OF_NETWORK);
                    break;
                }
                case -2: {
                    this.onError(Connection.DisconnectCause.SERVER_ERROR);
                    break;
                }
                default: {
                    Log.w(SipPhone.LOG_TAG, "error: " + SipErrorCode.toString(errorCode) + ": " + errorMessage);
                    this.onError(Connection.DisconnectCause.ERROR_UNSPECIFIED);
                }
            }
        }

        public /* synthetic */ SipAudioCallAdapter(1 x1) {
            this();
        }
    }

    public class SipConnection
    extends SipConnectionBase {
        public SipCall mOwner;
        public SipAudioCall mSipAudioCall;
        public Call.State mState;
        public SipProfile mPeer;
        public String mOriginalNumber;
        public boolean mIncoming;
        public SipAudioCallAdapter mAdapter;

        public SipConnection(SipCall owner, SipProfile callee, String originalNumber) {
            super(originalNumber);
            this.mState = Call.State.IDLE;
            this.mIncoming = false;
            this.mAdapter = new SipAudioCallAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onCallEnded(Connection.DisconnectCause cause) {
                    if (SipConnection.this.getDisconnectCause() != Connection.DisconnectCause.LOCAL) {
                        SipConnection.this.setDisconnectCause(cause);
                    }
                    Class<SipPhone> clazz = SipPhone.class;
                    synchronized (SipPhone.class) {
                        SipConnection.this.setState(Call.State.DISCONNECTED);
                        SipAudioCall sipAudioCall = SipConnection.this.mSipAudioCall;
                        SipConnection.this.mSipAudioCall = null;
                        String sessionState = sipAudioCall == null ? "" : sipAudioCall.getState() + ", ";
                        Log.d(SipPhone.LOG_TAG, "--- connection ended: " + SipConnection.this.mPeer.getUriString() + ": " + sessionState + "cause: " + (Object)((Object)SipConnection.this.getDisconnectCause()) + ", on phone " + SipConnection.this.getPhone());
                        if (sipAudioCall != null) {
                            sipAudioCall.setListener(null);
                            sipAudioCall.close();
                        }
                        SipConnection.this.mOwner.onConnectionEnded(SipConnection.this);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                public void onCallEstablished(SipAudioCall call) {
                    this.onChanged(call);
                    if (SipConnection.this.mState == Call.State.ACTIVE) {
                        call.startAudio();
                    }
                }

                public void onCallHeld(SipAudioCall call) {
                    this.onChanged(call);
                    if (SipConnection.this.mState == Call.State.HOLDING) {
                        call.startAudio();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onChanged(SipAudioCall call) {
                    Class<SipPhone> clazz = SipPhone.class;
                    synchronized (SipPhone.class) {
                        Call.State newState = SipPhone.getCallStateFrom(call);
                        if (SipConnection.this.mState == newState) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                        if (newState == Call.State.INCOMING) {
                            SipConnection.this.setState(SipConnection.this.mOwner.getState());
                        } else {
                            if (SipConnection.this.mOwner == SipPhone.this.ringingCall) {
                                if (SipPhone.this.ringingCall.getState() == Call.State.WAITING) {
                                    try {
                                        SipPhone.this.switchHoldingAndActive();
                                    }
                                    catch (CallStateException e) {
                                        this.onCallEnded(Connection.DisconnectCause.LOCAL);
                                        // ** MonitorExit[var2_2] (shouldn't be in output)
                                        return;
                                    }
                                }
                                SipPhone.this.foregroundCall.switchWith(SipPhone.this.ringingCall);
                            }
                            SipConnection.this.setState(newState);
                        }
                        SipConnection.this.mOwner.onConnectionStateChanged(SipConnection.this);
                        Log.v(SipPhone.LOG_TAG, "+***+ connection state changed: " + SipConnection.this.mPeer.getUriString() + ": " + (Object)((Object)SipConnection.this.mState) + " on phone " + SipConnection.this.getPhone());
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                public void onError(Connection.DisconnectCause cause) {
                    Log.d(SipPhone.LOG_TAG, "SIP error: " + (Object)((Object)cause));
                    this.onCallEnded(cause);
                }
            };
            this.mOwner = owner;
            this.mPeer = callee;
            this.mOriginalNumber = originalNumber;
        }

        public SipConnection(SipCall owner, SipProfile callee) {
            this(owner, callee, sipPhone.getUriString(callee));
        }

        public String getCnapName() {
            String displayName = this.mPeer.getDisplayName();
            return TextUtils.isEmpty(displayName) ? null : displayName;
        }

        public int getNumberPresentation() {
            return Connection.PRESENTATION_ALLOWED;
        }

        public void initIncomingCall(SipAudioCall sipAudioCall, Call.State newState) {
            this.setState(newState);
            this.mSipAudioCall = sipAudioCall;
            sipAudioCall.setListener(this.mAdapter);
            this.mIncoming = true;
        }

        public void acceptCall() throws CallStateException {
            try {
                this.mSipAudioCall.answerCall(8);
            }
            catch (SipException e) {
                throw new CallStateException("acceptCall(): " + e);
            }
        }

        public void changeOwner(SipCall owner) {
            this.mOwner = owner;
        }

        public AudioGroup getAudioGroup() {
            if (this.mSipAudioCall == null) {
                return null;
            }
            return this.mSipAudioCall.getAudioGroup();
        }

        public void dial() throws SipException {
            this.setState(Call.State.DIALING);
            this.mSipAudioCall = SipPhone.this.mSipManager.makeAudioCall(SipPhone.this.mProfile, this.mPeer, null, 15);
            this.mSipAudioCall.setListener(this.mAdapter);
        }

        public void hold() throws CallStateException {
            this.setState(Call.State.HOLDING);
            try {
                this.mSipAudioCall.holdCall(15);
            }
            catch (SipException e) {
                throw new CallStateException("hold(): " + e);
            }
        }

        public void unhold(AudioGroup audioGroup) throws CallStateException {
            this.mSipAudioCall.setAudioGroup(audioGroup);
            this.setState(Call.State.ACTIVE);
            try {
                this.mSipAudioCall.continueCall(15);
            }
            catch (SipException e) {
                throw new CallStateException("unhold(): " + e);
            }
        }

        public void setMute(boolean muted) {
            if (this.mSipAudioCall != null && muted != this.mSipAudioCall.isMuted()) {
                this.mSipAudioCall.toggleMute();
            }
        }

        public boolean getMute() {
            return this.mSipAudioCall == null ? false : this.mSipAudioCall.isMuted();
        }

        public void setState(Call.State state) {
            if (state == this.mState) {
                return;
            }
            super.setState(state);
            this.mState = state;
        }

        public Call.State getState() {
            return this.mState;
        }

        public boolean isIncoming() {
            return this.mIncoming;
        }

        public String getAddress() {
            return this.mOriginalNumber;
        }

        public SipCall getCall() {
            return this.mOwner;
        }

        public Phone getPhone() {
            return this.mOwner.getPhone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hangup() throws CallStateException {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                Log.d(SipPhone.LOG_TAG, "hangup conn: " + this.mPeer.getUriString() + ": " + (Object)((Object)this.mState) + ": on phone " + this.getPhone().getPhoneName());
                if (!this.mState.isAlive()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                try {
                    block8: {
                        try {
                            SipAudioCall sipAudioCall = this.mSipAudioCall;
                            if (sipAudioCall == null) break block8;
                            sipAudioCall.setListener(null);
                            sipAudioCall.endCall();
                        }
                        catch (SipException e) {
                            throw new CallStateException("hangup(): " + e);
                        }
                    }
                    Object var4_4 = null;
                    this.mAdapter.onCallEnded(this.mState == Call.State.INCOMING || this.mState == Call.State.WAITING ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.LOCAL);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.mAdapter.onCallEnded(this.mState == Call.State.INCOMING || this.mState == Call.State.WAITING ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.LOCAL);
                    throw throwable;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void separate() throws CallStateException {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                SipCall call;
                SipCall sipCall = call = this.getPhone() == SipPhone.this ? (SipCall)SipPhone.this.getBackgroundCall() : (SipCall)SipPhone.this.getForegroundCall();
                if (call.getState() != Call.State.IDLE) {
                    throw new CallStateException("cannot put conn back to a call in non-idle state: " + (Object)((Object)call.getState()));
                }
                Log.d(SipPhone.LOG_TAG, "separate conn: " + this.mPeer.getUriString() + " from " + this.mOwner + " back to " + call);
                Phone originalPhone = this.getPhone();
                AudioGroup audioGroup = call.getAudioGroup();
                call.add(this);
                this.mSipAudioCall.setAudioGroup(audioGroup);
                originalPhone.switchHoldingAndActive();
                call = (SipCall)SipPhone.this.getForegroundCall();
                this.mSipAudioCall.startAudio();
                call.onConnectionStateChanged(this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SipCall
    extends SipCallBase {
        public SipCall() {
        }

        public void reset() {
            this.connections.clear();
            this.setState(Call.State.IDLE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void switchWith(SipCall that) {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                SipCall tmp = new SipCall();
                tmp.takeOver(this);
                this.takeOver(that);
                that.takeOver(tmp);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void takeOver(SipCall that) {
            this.connections = that.connections;
            this.state = that.state;
            for (Connection c : this.connections) {
                ((SipConnection)c).changeOwner(this);
            }
        }

        @Override
        public Phone getPhone() {
            return SipPhone.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Connection> getConnections() {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.connections;
            }
        }

        public Connection dial(String originalNumber) throws SipException {
            String calleeSipUri = originalNumber;
            if (!calleeSipUri.contains("@")) {
                calleeSipUri = SipPhone.this.mProfile.getUriString().replaceFirst(SipPhone.this.mProfile.getUserName() + "@", calleeSipUri + "@");
            }
            try {
                SipProfile callee = new SipProfile.Builder(calleeSipUri).build();
                SipConnection c = new SipConnection(this, callee, originalNumber);
                c.dial();
                this.connections.add(c);
                this.setState(Call.State.DIALING);
                return c;
            }
            catch (ParseException e) {
                throw new SipException("dial", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hangup() throws CallStateException {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                if (this.state.isAlive()) {
                    Log.d("Call", "hang up call: " + (Object)((Object)this.getState()) + ": " + this + " on phone " + this.getPhone());
                    this.setState(Call.State.DISCONNECTING);
                    CallStateException excp = null;
                    for (Connection c : this.connections) {
                        try {
                            c.hangup();
                        }
                        catch (CallStateException e) {
                            excp = e;
                        }
                    }
                    if (excp != null) {
                        throw excp;
                    }
                } else {
                    Log.d("Call", "hang up dead call: " + (Object)((Object)this.getState()) + ": " + this + " on phone " + this.getPhone());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public void initIncomingCall(SipAudioCall sipAudioCall, boolean makeCallWait) {
            SipProfile callee = sipAudioCall.getPeerProfile();
            SipConnection c = new SipConnection(this, callee);
            this.connections.add(c);
            Call.State newState = makeCallWait ? Call.State.WAITING : Call.State.INCOMING;
            c.initIncomingCall(sipAudioCall, newState);
            this.setState(newState);
            SipPhone.this.notifyNewRingingConnectionP(c);
        }

        public void rejectCall() throws CallStateException {
            this.hangup();
        }

        public void acceptCall() throws CallStateException {
            if (this != SipPhone.this.ringingCall) {
                throw new CallStateException("acceptCall() in a non-ringing call");
            }
            if (this.connections.size() != 1) {
                throw new CallStateException("acceptCall() in a conf call");
            }
            ((SipConnection)this.connections.get(0)).acceptCall();
        }

        public boolean isSpeakerOn() {
            return ((AudioManager)SipPhone.this.mContext.getSystemService("audio")).isSpeakerphoneOn();
        }

        public void setAudioGroupMode() {
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup == null) {
                return;
            }
            int mode = audioGroup.getMode();
            if (this.state == Call.State.HOLDING) {
                audioGroup.setMode(0);
            } else if (this.getMute()) {
                audioGroup.setMode(1);
            } else if (this.isSpeakerOn()) {
                audioGroup.setMode(3);
            } else {
                audioGroup.setMode(2);
            }
            Log.d("Call", String.format("audioGroup mode change: %d --> %d", mode, audioGroup.getMode()));
        }

        public void hold() throws CallStateException {
            this.setState(Call.State.HOLDING);
            for (Connection c : this.connections) {
                ((SipConnection)c).hold();
            }
            this.setAudioGroupMode();
        }

        public void unhold() throws CallStateException {
            this.setState(Call.State.ACTIVE);
            AudioGroup audioGroup = new AudioGroup();
            for (Connection c : this.connections) {
                ((SipConnection)c).unhold(audioGroup);
            }
            this.setAudioGroupMode();
        }

        public void setMute(boolean muted) {
            for (Connection c : this.connections) {
                ((SipConnection)c).setMute(muted);
            }
        }

        public boolean getMute() {
            return this.connections.isEmpty() ? false : ((SipConnection)this.connections.get(0)).getMute();
        }

        public void merge(SipCall that) throws CallStateException {
            Connection[] cc;
            AudioGroup audioGroup = this.getAudioGroup();
            for (Connection c : cc = that.connections.toArray(new Connection[that.connections.size()])) {
                SipConnection conn = (SipConnection)c;
                this.add(conn);
                if (conn.getState() != Call.State.HOLDING) continue;
                conn.unhold(audioGroup);
            }
            that.setState(Call.State.IDLE);
        }

        public void add(SipConnection conn) {
            SipCall call = conn.getCall();
            if (call == this) {
                return;
            }
            if (call != null) {
                call.connections.remove(conn);
            }
            this.connections.add(conn);
            conn.changeOwner(this);
        }

        public void sendDtmf(char c) {
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup == null) {
                return;
            }
            audioGroup.sendDtmf(this.convertDtmf(c));
        }

        public int convertDtmf(char c) {
            int code = c - 48;
            if (code < 0 || code > 9) {
                switch (c) {
                    case '*': {
                        return 10;
                    }
                    case '#': {
                        return 11;
                    }
                    case 'A': {
                        return 12;
                    }
                    case 'B': {
                        return 13;
                    }
                    case 'C': {
                        return 14;
                    }
                    case 'D': {
                        return 15;
                    }
                }
                throw new IllegalArgumentException("invalid DTMF char: " + c);
            }
            return code;
        }

        @Override
        public void setState(Call.State newState) {
            if (this.state != newState) {
                Log.v("Call", "+***+ call state changed: " + (Object)((Object)this.state) + " --> " + (Object)((Object)newState) + ": " + this + ": on phone " + this.getPhone() + " " + this.connections.size());
                if (newState == Call.State.ALERTING) {
                    this.state = newState;
                    SipPhone.this.startRingbackTone();
                } else if (this.state == Call.State.ALERTING) {
                    SipPhone.this.stopRingbackTone();
                }
                this.state = newState;
                SipPhone.this.updatePhoneState();
                SipPhone.this.notifyPreciseCallStateChanged();
            }
        }

        public void onConnectionStateChanged(SipConnection conn) {
            if (this.state != Call.State.ACTIVE) {
                this.setState(conn.getState());
            }
        }

        public void onConnectionEnded(SipConnection conn) {
            if (this.state != Call.State.DISCONNECTED) {
                boolean allConnectionsDisconnected = true;
                Log.d("Call", "---check connections: " + this.connections.size());
                for (Connection c : this.connections) {
                    Log.d("Call", "   state=" + (Object)((Object)c.getState()) + ": " + c);
                    if (c.getState() == Call.State.DISCONNECTED) continue;
                    allConnectionsDisconnected = false;
                    break;
                }
                if (allConnectionsDisconnected) {
                    this.setState(Call.State.DISCONNECTED);
                }
            }
            SipPhone.this.notifyDisconnectP(conn);
        }

        public AudioGroup getAudioGroup() {
            if (this.connections.isEmpty()) {
                return null;
            }
            return ((SipConnection)this.connections.get(0)).getAudioGroup();
        }

        public /* synthetic */ SipCall(1 x1) {
            this();
        }
    }
}

