/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;

public class ActionMenuItem
implements MenuItem {
    public final int mId;
    public final int mGroup;
    public final int mCategoryOrder;
    public final int mOrdering;
    public CharSequence mTitle;
    public CharSequence mTitleCondensed;
    public Intent mIntent;
    public char mShortcutNumericChar;
    public char mShortcutAlphabeticChar;
    public Drawable mIconDrawable;
    public int mIconResId = 0;
    public Context mContext;
    public MenuItem.OnMenuItemClickListener mClickListener;
    public static final int NO_ICON = 0;
    public int mFlags = 16;
    public static final int CHECKABLE = 1;
    public static final int CHECKED = 2;
    public static final int EXCLUSIVE = 4;
    public static final int HIDDEN = 8;
    public static final int ENABLED = 16;

    public ActionMenuItem(Context context, int group, int id2, int categoryOrder, int ordering, CharSequence title) {
        this.mContext = context;
        this.mId = id2;
        this.mGroup = group;
        this.mCategoryOrder = categoryOrder;
        this.mOrdering = ordering;
        this.mTitle = title;
    }

    public char getAlphabeticShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    public int getGroupId() {
        return this.mGroup;
    }

    public Drawable getIcon() {
        return this.mIconDrawable;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public int getItemId() {
        return this.mId;
    }

    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return null;
    }

    public char getNumericShortcut() {
        return this.mShortcutNumericChar;
    }

    public int getOrder() {
        return this.mOrdering;
    }

    public SubMenu getSubMenu() {
        return null;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getTitleCondensed() {
        return this.mTitleCondensed;
    }

    public boolean hasSubMenu() {
        return false;
    }

    public boolean isCheckable() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isChecked() {
        return (this.mFlags & 2) != 0;
    }

    public boolean isEnabled() {
        return (this.mFlags & 0x10) != 0;
    }

    public boolean isVisible() {
        return (this.mFlags & 8) == 0;
    }

    public MenuItem setAlphabeticShortcut(char alphaChar) {
        this.mShortcutAlphabeticChar = alphaChar;
        return this;
    }

    public MenuItem setCheckable(boolean checkable) {
        this.mFlags = this.mFlags & 0xFFFFFFFE | (checkable ? 1 : 0);
        return this;
    }

    public ActionMenuItem setExclusiveCheckable(boolean exclusive) {
        this.mFlags = this.mFlags & 0xFFFFFFFB | (exclusive ? 4 : 0);
        return this;
    }

    public MenuItem setChecked(boolean checked) {
        this.mFlags = this.mFlags & 0xFFFFFFFD | (checked ? 2 : 0);
        return this;
    }

    public MenuItem setEnabled(boolean enabled) {
        this.mFlags = this.mFlags & 0xFFFFFFEF | (enabled ? 16 : 0);
        return this;
    }

    public MenuItem setIcon(Drawable icon) {
        this.mIconDrawable = icon;
        this.mIconResId = 0;
        return this;
    }

    public MenuItem setIcon(int iconRes) {
        this.mIconResId = iconRes;
        this.mIconDrawable = this.mContext.getResources().getDrawable(iconRes);
        return this;
    }

    public MenuItem setIntent(Intent intent) {
        this.mIntent = intent;
        return this;
    }

    public MenuItem setNumericShortcut(char numericChar) {
        this.mShortcutNumericChar = numericChar;
        return this;
    }

    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener menuItemClickListener) {
        this.mClickListener = menuItemClickListener;
        return this;
    }

    public MenuItem setShortcut(char numericChar, char alphaChar) {
        this.mShortcutNumericChar = numericChar;
        this.mShortcutAlphabeticChar = alphaChar;
        return this;
    }

    public MenuItem setTitle(CharSequence title) {
        this.mTitle = title;
        return this;
    }

    public MenuItem setTitle(int title) {
        this.mTitle = this.mContext.getResources().getString(title);
        return this;
    }

    public MenuItem setTitleCondensed(CharSequence title) {
        this.mTitleCondensed = title;
        return this;
    }

    public MenuItem setVisible(boolean visible) {
        this.mFlags = this.mFlags & 8 | (visible ? 0 : 8);
        return this;
    }

    public boolean invoke() {
        if (this.mClickListener != null && this.mClickListener.onMenuItemClick(this)) {
            return true;
        }
        if (this.mIntent != null) {
            this.mContext.startActivity(this.mIntent);
            return true;
        }
        return false;
    }

    public void setShowAsAction(int show) {
    }

    public MenuItem setActionView(View actionView) {
        throw new UnsupportedOperationException();
    }

    public View getActionView() {
        return null;
    }

    public MenuItem setActionView(int resId) {
        throw new UnsupportedOperationException();
    }
}

