/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public class ExpandedMenuView
extends ListView
implements MenuBuilder.ItemInvoker,
MenuView,
AdapterView.OnItemClickListener {
    public MenuBuilder mMenu;
    public int mAnimations;

    public ExpandedMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MenuView, 0, 0);
        this.mAnimations = a.getResourceId(0, 0);
        a.recycle();
        this.setOnItemClickListener(this);
    }

    public void initialize(MenuBuilder menu2, int menuType) {
        this.mMenu = menu2;
        MenuBuilder menuBuilder = menu2;
        menuBuilder.getClass();
        this.setAdapter(new MenuBuilder.MenuAdapter(menuBuilder, menuType));
    }

    public void updateChildren(boolean cleared) {
        ListAdapter adapter = this.getAdapter();
        if (adapter != null) {
            if (cleared) {
                ((BaseAdapter)adapter).notifyDataSetInvalidated();
            } else {
                ((BaseAdapter)adapter).notifyDataSetChanged();
            }
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setChildrenDrawingCacheEnabled(false);
    }

    public boolean recycleOnMeasure() {
        return false;
    }

    public boolean invokeItem(MenuItemImpl item) {
        return this.mMenu.performItemAction(item, 0);
    }

    public void onItemClick(AdapterView parent, View v, int position, long id2) {
        this.invokeItem((MenuItemImpl)this.getAdapter().getItem(position));
    }

    public int getWindowAnimations() {
        return this.mAnimations;
    }
}

