/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.SubMenuBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuPopupHelper
implements AdapterView.OnItemClickListener,
View.OnKeyListener,
ViewTreeObserver.OnGlobalLayoutListener,
PopupWindow.OnDismissListener,
View.OnAttachStateChangeListener {
    public static final String TAG = "MenuPopupHelper";
    public Context mContext;
    public ListPopupWindow mPopup;
    public MenuBuilder mMenu;
    public int mPopupMaxWidth;
    public View mAnchorView;
    public boolean mOverflowOnly;
    public ViewTreeObserver mTreeObserver;
    public final Handler mHandler = new Handler();

    public MenuPopupHelper(Context context, MenuBuilder menu2) {
        this(context, menu2, null, false);
    }

    public MenuPopupHelper(Context context, MenuBuilder menu2, View anchorView) {
        this(context, menu2, anchorView, false);
    }

    public MenuPopupHelper(Context context, MenuBuilder menu2, View anchorView, boolean overflowOnly) {
        this.mContext = context;
        this.mMenu = menu2;
        this.mOverflowOnly = overflowOnly;
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        this.mPopupMaxWidth = metrics.widthPixels / 2;
        this.mAnchorView = anchorView;
    }

    public void setAnchorView(View anchor) {
        this.mAnchorView = anchor;
    }

    public void show() {
        if (!this.tryShow()) {
            throw new IllegalStateException("MenuPopupHelper cannot be used without an anchor");
        }
    }

    public boolean tryShow() {
        this.mPopup = new ListPopupWindow(this.mContext, null, 0x1010300);
        this.mPopup.setOnItemClickListener(this);
        this.mPopup.setOnDismissListener(this);
        MenuBuilder.MenuAdapter adapter = this.mOverflowOnly ? this.mMenu.getOverflowMenuAdapter(4) : this.mMenu.getMenuAdapter(4);
        this.mPopup.setAdapter(adapter);
        this.mPopup.setModal(true);
        View anchor = this.mAnchorView;
        if (anchor == null && this.mMenu instanceof SubMenuBuilder) {
            SubMenuBuilder subMenu = (SubMenuBuilder)this.mMenu;
            MenuItemImpl itemImpl = (MenuItemImpl)subMenu.getItem();
            this.mAnchorView = anchor = itemImpl.getItemView(3, null);
        }
        if (anchor != null) {
            boolean addGlobalListener = this.mTreeObserver == null;
            this.mTreeObserver = anchor.getViewTreeObserver();
            if (addGlobalListener) {
                this.mTreeObserver.addOnGlobalLayoutListener(this);
            }
        } else {
            return false;
        }
        anchor.addOnAttachStateChangeListener(this);
        this.mPopup.setAnchorView(anchor);
        this.mPopup.setContentWidth(Math.min(this.measureContentWidth(adapter), this.mPopupMaxWidth));
        this.mPopup.setInputMethodMode(2);
        this.mPopup.show();
        this.mPopup.getListView().setOnKeyListener(this);
        return true;
    }

    public void dismiss() {
        if (this.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    @Override
    public void onDismiss() {
        this.mPopup = null;
        if (this.mTreeObserver != null) {
            if (!this.mTreeObserver.isAlive()) {
                this.mTreeObserver = this.mAnchorView.getViewTreeObserver();
            }
            this.mTreeObserver.removeGlobalOnLayoutListener(this);
            this.mTreeObserver = null;
        }
        this.mAnchorView.removeOnAttachStateChangeListener(this);
    }

    public boolean isShowing() {
        return this.mPopup != null && this.mPopup.isShowing();
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (!this.isShowing()) {
            return;
        }
        MenuItem item = null;
        item = this.mOverflowOnly ? this.mMenu.getOverflowItem(position) : (MenuItem)this.mMenu.getVisibleItems().get(position);
        this.dismiss();
        final MenuItem performItem = item;
        this.mHandler.post(new Runnable(){

            public void run() {
                MenuPopupHelper.this.mMenu.performItemAction(performItem, 0);
            }
        });
    }

    @Override
    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (event.getAction() == 1 && keyCode == 82) {
            this.dismiss();
            return true;
        }
        return false;
    }

    public int measureContentWidth(MenuBuilder.MenuAdapter adapter) {
        int width = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            itemView = adapter.getView(i, itemView, null);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            width = Math.max(width, itemView.getMeasuredWidth());
        }
        return width;
    }

    @Override
    public void onGlobalLayout() {
        if (this.isShowing()) {
            View anchor = this.mAnchorView;
            if (anchor == null || !anchor.isShown()) {
                this.dismiss();
            } else if (this.isShowing()) {
                this.mPopup.show();
            }
        }
    }

    @Override
    public void onViewAttachedToWindow(View v) {
    }

    @Override
    public void onViewDetachedFromWindow(View v) {
        if (this.mTreeObserver != null) {
            if (!this.mTreeObserver.isAlive()) {
                this.mTreeObserver = v.getViewTreeObserver();
            }
            this.mTreeObserver.removeGlobalOnLayoutListener(this);
        }
        v.removeOnAttachStateChangeListener(this);
    }
}

