/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.graphics.Bitmap_Delegate;
import android.graphics.Paint_Delegate;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Region_Delegate;
import android.graphics.Shader_Delegate;
import android.graphics.Xfermode_Delegate;
import com.android.layoutlib.bridge.Bridge;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class GcSnapshot {
    private final GcSnapshot mPrevious;
    private final int mFlags;
    private final ArrayList<Layer> mLayers = new ArrayList();
    private AffineTransform mTransform = null;
    private Area mClip = null;
    private final Layer mLocalLayer;
    private final Paint_Delegate mLocalLayerPaint;
    private final Rect mLayerBounds;

    public static GcSnapshot createDefaultSnapshot(Bitmap_Delegate bitmap_Delegate) {
        GcSnapshot gcSnapshot = new GcSnapshot();
        if (bitmap_Delegate != null) {
            gcSnapshot.setBitmap(bitmap_Delegate);
        }
        return gcSnapshot;
    }

    public GcSnapshot save(int n) {
        return new GcSnapshot(this, null, null, n);
    }

    public GcSnapshot saveLayer(RectF rectF, Paint_Delegate paint_Delegate, int n) {
        return new GcSnapshot(this, rectF, paint_Delegate, n);
    }

    private GcSnapshot() {
        this.mPrevious = null;
        this.mFlags = 0;
        this.mLocalLayer = null;
        this.mLocalLayerPaint = null;
        this.mLayerBounds = null;
    }

    private GcSnapshot(GcSnapshot gcSnapshot, RectF rectF, Paint_Delegate paint_Delegate, int n) {
        assert (gcSnapshot != null);
        this.mPrevious = gcSnapshot;
        this.mFlags = n;
        for (Layer object : this.mPrevious.mLayers) {
            this.mLayers.add(object.makeCopy());
        }
        if (rectF != null) {
            AffineTransform affineTransform = this.mLayers.get(0).getGraphics().getTransform();
            RectF rectF2 = new RectF();
            this.mapRect(affineTransform, rectF2, rectF);
            this.mLayerBounds = new Rect();
            rectF2.round(this.mLayerBounds);
            Layer layer = this.mLayers.get(0);
            BufferedImage bufferedImage = new BufferedImage(layer.getImage().getWidth(), layer.getImage().getHeight(), (this.mFlags & 4) != 0 ? 2 : 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            AffineTransform affineTransform2 = layer.getGraphics().getTransform();
            graphics2D.setTransform(affineTransform2);
            this.mLocalLayer = new Layer(graphics2D, bufferedImage, n);
            this.mLayers.add(this.mLocalLayer);
            Shape shape = layer.getGraphics().getClip();
            this.mLocalLayer.setClip(shape);
            if ((this.mFlags & 0x10) == 0) {
                int n2 = this.mLayerBounds.width();
                int n3 = this.mLayerBounds.height();
                for (int i = 0; i < this.mLayers.size() - 1; ++i) {
                    Layer layer2 = this.mLayers.get(i);
                    BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 2);
                    Graphics2D graphics2D2 = bufferedImage2.createGraphics();
                    graphics2D2.drawImage(layer2.getImage(), 0, 0, n2, n3, this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, null);
                    graphics2D2.dispose();
                    layer2.setOriginalCopy(bufferedImage2);
                }
            }
        } else {
            this.mLocalLayer = null;
            this.mLayerBounds = null;
        }
        this.mLocalLayerPaint = paint_Delegate;
    }

    public void dispose() {
        for (Layer layer : this.mLayers) {
            layer.getGraphics().dispose();
        }
        if (this.mPrevious != null) {
            this.mPrevious.dispose();
        }
    }

    public GcSnapshot restore() {
        return this.doRestore();
    }

    public GcSnapshot restoreTo(int n) {
        return this.doRestoreTo(this.size(), n);
    }

    public int size() {
        if (this.mPrevious != null) {
            return this.mPrevious.size() + 1;
        }
        return 1;
    }

    public void setBitmap(Bitmap_Delegate bitmap_Delegate) {
        Graphics2D graphics2D = bitmap_Delegate.getImage().createGraphics();
        Layer layer = new Layer(graphics2D, bitmap_Delegate);
        graphics2D.setTransform(this.getTransform());
        this.mTransform = null;
        layer.setClip(this.getClip());
        this.mClip = null;
        this.mLayers.clear();
        this.mLayers.add(layer);
    }

    public void translate(float f, float f2) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().translate(f, f2);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.translate(f, f2);
        }
    }

    public void rotate(double d) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().rotate(d);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.rotate(d);
        }
    }

    public void scale(float f, float f2) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().scale(f, f2);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.scale(f, f2);
        }
    }

    public AffineTransform getTransform() {
        if (this.mLayers.size() > 0) {
            return this.mLayers.get(0).getGraphics().getTransform();
        }
        if (this.mTransform == null) {
            this.mTransform = new AffineTransform();
        }
        return this.mTransform;
    }

    public void setTransform(AffineTransform affineTransform) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().setTransform(affineTransform);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.setTransform(affineTransform);
        }
    }

    public boolean clip(Shape shape, int n) {
        if (n == Region.Op.INTERSECT.nativeInt && this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.clip(shape);
            }
            Shape shape2 = this.getClip();
            return shape2 != null && !shape2.getBounds().isEmpty();
        }
        Area area = null;
        area = n == Region.Op.REPLACE.nativeInt ? new Area(shape) : Region_Delegate.combineShapes(this.getClip(), shape, n);
        assert (area != null);
        if (this.mLayers.size() > 0) {
            Object object;
            if (area != null) {
                object = this.mLayers.iterator();
                while (object.hasNext()) {
                    Layer layer = (Layer)object.next();
                    layer.setClip(area);
                }
            }
            return (object = this.getClip()) != null && !object.getBounds().isEmpty();
        }
        this.mClip = area != null ? area : new Area();
        return !this.mClip.getBounds().isEmpty();
    }

    public boolean clipRect(float f, float f2, float f3, float f4, int n) {
        return this.clip(new Rectangle2D.Float(f, f2, f3 - f, f4 - f2), n);
    }

    public Shape getClip() {
        if (this.mLayers.size() > 0) {
            return this.mLayers.get(0).getGraphics().getClip();
        }
        return this.mClip;
    }

    private GcSnapshot doRestoreTo(int n, int n2) {
        if (n <= n2) {
            return this;
        }
        GcSnapshot gcSnapshot = this.doRestore();
        if (n == n2 + 1) {
            return gcSnapshot;
        }
        return gcSnapshot.doRestoreTo(n - 1, n2);
    }

    public void draw(Drawable drawable2) {
        this.draw(drawable2, null, false, false);
    }

    public void draw(Drawable drawable2, Paint_Delegate paint_Delegate, boolean bl, boolean bl2) {
        if (this.mLayers.size() == 1) {
            this.drawInLayer(this.mLayers.get(0), drawable2, paint_Delegate, bl, bl2);
        } else {
            int n;
            int n2 = this.mLayers.size() - 1;
            do {
                Layer layer = this.mLayers.get(n2);
                this.drawInLayer(layer, drawable2, paint_Delegate, bl, bl2);
                n = layer.getFlags();
            } while (--n2 >= 0 && (n & 0x10) == 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawInLayer(Layer layer, Drawable drawable2, Paint_Delegate paint_Delegate, boolean bl, boolean bl2) {
        Graphics2D graphics2D;
        Graphics2D graphics2D2 = layer.getGraphics();
        Graphics2D graphics2D3 = graphics2D = paint_Delegate != null ? this.createCustomGraphics(graphics2D2, paint_Delegate, bl, bl2) : (Graphics2D)graphics2D2.create();
        if (graphics2D != null) {
            try {
                drawable2.draw(graphics2D, paint_Delegate);
                layer.change();
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    private GcSnapshot doRestore() {
        if (this.mPrevious != null) {
            if (this.mLocalLayer != null) {
                int n;
                int n2 = this.mLayers.size() - 1;
                do {
                    Layer layer = this.mLayers.get(n2 - 1);
                    this.restoreLayer(layer);
                    n = layer.getFlags();
                } while (--n2 > 0 && (n & 0x10) == 0);
            }
            if ((this.mFlags & 1) == 0) {
                AffineTransform affineTransform = this.getTransform();
                for (Layer layer : this.mPrevious.mLayers) {
                    layer.getGraphics().setTransform(affineTransform);
                }
            }
            if ((this.mFlags & 2) == 0) {
                Shape shape = this.getClip();
                for (Layer layer : this.mPrevious.mLayers) {
                    layer.setClip(shape);
                }
            }
        }
        for (Layer layer : this.mLayers) {
            layer.getGraphics().dispose();
        }
        return this.mPrevious;
    }

    private void restoreLayer(Layer layer) {
        Graphics2D graphics2D;
        Graphics2D graphics2D2 = layer.getImage().createGraphics();
        BufferedImage bufferedImage = layer.getOriginalCopy();
        if (bufferedImage != null) {
            graphics2D = (Graphics2D)graphics2D2.create();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage(bufferedImage, this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, 0, 0, this.mLayerBounds.width(), this.mLayerBounds.height(), null);
            graphics2D.dispose();
        }
        if ((graphics2D = this.createCustomGraphics(graphics2D2, this.mLocalLayerPaint, true, false)) != null) {
            graphics2D.drawImage(this.mLocalLayer.getImage(), this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, null);
            graphics2D.dispose();
        }
        graphics2D2.dispose();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Graphics2D createCustomGraphics(Graphics2D graphics2D, Paint_Delegate paint_Delegate, boolean bl, boolean bl2) {
        int n;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        if (paint_Delegate.isAntiAliased()) {
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        boolean bl3 = false;
        if (!bl) {
            Shader_Delegate shader_Delegate = paint_Delegate.getShader();
            if (shader_Delegate != null) {
                if (shader_Delegate.isSupported()) {
                    if (!shader_Delegate.isValid()) {
                        graphics2D2.dispose();
                        return null;
                    }
                    Paint paint = shader_Delegate.getJavaPaint();
                    assert (paint != null);
                    if (paint != null) {
                        graphics2D2.setPaint(paint);
                        bl3 = true;
                    }
                } else {
                    Bridge.getLog().fidelityWarning("shader", shader_Delegate.getSupportMessage(), null, null);
                }
            }
            if (!bl3) {
                graphics2D2.setColor(new Color(paint_Delegate.getColor(), true));
            }
            graphics2D2.setStroke(paint_Delegate.getJavaStroke());
        }
        int n2 = n = bl || bl3 ? paint_Delegate.getAlpha() : 255;
        if (bl2) {
            graphics2D2.setComposite(AlphaComposite.getInstance(2, (float)n / 255.0f));
            return graphics2D2;
        }
        boolean bl4 = false;
        Xfermode_Delegate xfermode_Delegate = paint_Delegate.getXfermode();
        if (xfermode_Delegate != null) {
            if (xfermode_Delegate.isSupported()) {
                Composite composite = xfermode_Delegate.getComposite(n);
                assert (composite != null);
                if (composite != null) {
                    graphics2D2.setComposite(composite);
                    bl4 = true;
                }
            } else {
                Bridge.getLog().fidelityWarning("xfermode", xfermode_Delegate.getSupportMessage(), null, null);
            }
        }
        if (bl4) return graphics2D2;
        if (n == 255) return graphics2D2;
        graphics2D2.setComposite(AlphaComposite.getInstance(3, (float)n / 255.0f));
        return graphics2D2;
    }

    private void mapRect(AffineTransform affineTransform, RectF rectF, RectF rectF2) {
        float[] fArray = new float[]{rectF2.left, rectF2.top, rectF2.right, rectF2.top, rectF2.right, rectF2.bottom, rectF2.left, rectF2.bottom};
        affineTransform.transform(fArray, 0, fArray, 0, 4);
        rectF.left = Math.min(Math.min(fArray[0], fArray[2]), Math.min(fArray[4], fArray[6]));
        rectF.right = Math.max(Math.max(fArray[0], fArray[2]), Math.max(fArray[4], fArray[6]));
        rectF.top = Math.min(Math.min(fArray[1], fArray[3]), Math.min(fArray[5], fArray[7]));
        rectF.bottom = Math.max(Math.max(fArray[1], fArray[3]), Math.max(fArray[5], fArray[7]));
    }

    private static class Layer {
        private final Graphics2D mGraphics;
        private final Bitmap_Delegate mBitmap;
        private final BufferedImage mImage;
        private final int mFlags;
        private BufferedImage mOriginalCopy;

        Layer(Graphics2D graphics2D, Bitmap_Delegate bitmap_Delegate) {
            this.mGraphics = graphics2D;
            this.mBitmap = bitmap_Delegate;
            this.mImage = this.mBitmap.getImage();
            this.mFlags = 0;
        }

        Layer(Graphics2D graphics2D, BufferedImage bufferedImage, int n) {
            this.mGraphics = graphics2D;
            this.mBitmap = null;
            this.mImage = bufferedImage;
            this.mFlags = n;
        }

        Graphics2D getGraphics() {
            return this.mGraphics;
        }

        BufferedImage getImage() {
            return this.mImage;
        }

        int getFlags() {
            return this.mFlags;
        }

        Layer makeCopy() {
            if (this.mBitmap != null) {
                return new Layer((Graphics2D)this.mGraphics.create(), this.mBitmap);
            }
            return new Layer((Graphics2D)this.mGraphics.create(), this.mImage, this.mFlags);
        }

        void setOriginalCopy(BufferedImage bufferedImage) {
            this.mOriginalCopy = bufferedImage;
        }

        BufferedImage getOriginalCopy() {
            return this.mOriginalCopy;
        }

        void change() {
            if (this.mBitmap != null) {
                this.mBitmap.change();
            }
        }

        void setClip(Shape shape) {
            this.mGraphics.setClip(null);
            this.mGraphics.clip(shape);
        }

        public void clip(Shape shape) {
            this.mGraphics.clip(shape);
        }
    }

    public static interface Drawable {
        public void draw(Graphics2D var1, Paint_Delegate var2);
    }
}

