/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.os.HandlerThread_Delegate;
import android.util.DisplayMetrics;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderParams;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.Result;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.resources.ResourceType;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenderAction<T extends RenderParams>
extends RenderResources.FrameworkResourceIdProvider {
    private static BridgeContext sCurrentContext = null;
    private final T mParams;
    private BridgeContext mContext;

    protected RenderAction(T t) {
        this.mParams = t;
    }

    public Result init(long l) {
        Result result = this.acquireLock(l);
        if (result != null) {
            return result;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        displayMetrics.densityDpi = this.mParams.getDensity().getDpiValue();
        displayMetrics.scaledDensity = displayMetrics.density = (float)displayMetrics.densityDpi / 160.0f;
        displayMetrics.widthPixels = this.mParams.getScreenWidth();
        displayMetrics.heightPixels = this.mParams.getScreenHeight();
        displayMetrics.xdpi = this.mParams.getXdpi();
        displayMetrics.ydpi = this.mParams.getYdpi();
        RenderResources renderResources = this.mParams.getResources();
        this.mContext = new BridgeContext(this.mParams.getProjectKey(), displayMetrics, renderResources, this.mParams.getProjectCallback(), this.mParams.getTargetSdkVersion());
        this.setUp();
        return Result.Status.SUCCESS.createResult();
    }

    public Result acquire(long l) {
        if (this.mContext == null) {
            throw new IllegalStateException("After scene creation, #init() must be called");
        }
        Result result = this.acquireLock(l);
        if (result != null) {
            return result;
        }
        this.setUp();
        return Result.Status.SUCCESS.createResult();
    }

    private Result acquireLock(long l) {
        block5: {
            ReentrantLock reentrantLock = Bridge.getLock();
            if (!reentrantLock.isHeldByCurrentThread()) {
                try {
                    boolean bl = reentrantLock.tryLock(l, TimeUnit.MILLISECONDS);
                    if (!bl) {
                        return Result.Status.ERROR_TIMEOUT.createResult();
                    }
                    break block5;
                }
                catch (InterruptedException interruptedException) {
                    return Result.Status.ERROR_LOCK_INTERRUPTED.createResult();
                }
            }
            if (this.mContext != sCurrentContext) {
                throw new IllegalStateException("Acquiring different scenes from same thread without releases");
            }
            return Result.Status.SUCCESS.createResult();
        }
        return null;
    }

    public void release() {
        ReentrantLock reentrantLock = Bridge.getLock();
        if (reentrantLock.isHeldByCurrentThread()) {
            this.tearDown();
            reentrantLock.unlock();
        }
    }

    private void setUp() {
        this.mContext.initResources();
        sCurrentContext = this.mContext;
        LayoutLog layoutLog = this.mParams.getLog();
        Bridge.setLog(layoutLog);
        this.mContext.getRenderResources().setFrameworkResourceIdProvider((RenderResources.FrameworkResourceIdProvider)this);
        this.mContext.getRenderResources().setLogger(layoutLog);
    }

    private void tearDown() {
        this.mContext.disposeResources();
        HandlerThread_Delegate.cleanUp(sCurrentContext);
        sCurrentContext = null;
        Bridge.setLog(null);
        this.mContext.getRenderResources().setFrameworkResourceIdProvider(null);
        this.mContext.getRenderResources().setLogger(null);
    }

    public static BridgeContext getCurrentContext() {
        return sCurrentContext;
    }

    protected T getParams() {
        return this.mParams;
    }

    protected BridgeContext getContext() {
        return this.mContext;
    }

    public LayoutLog getLog() {
        if (this.mParams != null) {
            return this.mParams.getLog();
        }
        return null;
    }

    protected void checkLock() {
        ReentrantLock reentrantLock = Bridge.getLock();
        if (!reentrantLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("scene must be acquired first. see #acquire(long)");
        }
        if (sCurrentContext != this.mContext) {
            throw new IllegalStateException("Thread acquired a scene but is rendering a different one");
        }
    }

    public Integer getId(ResourceType resourceType, String string2) {
        return Bridge.getResourceId(resourceType, string2);
    }
}

