/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.View;
import android.widget.FrameLayout;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeWindow;
import com.android.layoutlib.bridge.android.BridgeWindowSession;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderDrawable
extends RenderAction<DrawableParams> {
    public RenderDrawable(DrawableParams drawableParams) {
        super(new DrawableParams(drawableParams));
    }

    public Result render() {
        this.checkLock();
        try {
            DrawableParams drawableParams = (DrawableParams)this.getParams();
            ResourceValue resourceValue = drawableParams.getDrawable();
            BridgeContext bridgeContext = this.getContext();
            resourceValue = bridgeContext.getRenderResources().resolveResValue(resourceValue);
            if (resourceValue == null || resourceValue.getResourceType() != ResourceType.DRAWABLE) {
                return Result.Status.ERROR_NOT_A_DRAWABLE.createResult();
            }
            FrameLayout frameLayout = new FrameLayout(bridgeContext);
            Drawable drawable2 = ResourceHelper.getDrawable(resourceValue, bridgeContext);
            frameLayout.setBackgroundDrawable(drawable2);
            View.AttachInfo attachInfo = new View.AttachInfo(new BridgeWindowSession(), new BridgeWindow(), new Handler(), null);
            attachInfo.mHasWindowFocus = true;
            attachInfo.mWindowVisibility = 0;
            attachInfo.mInTouchMode = false;
            attachInfo.mHardwareAccelerated = false;
            frameLayout.dispatchAttachedToWindow(attachInfo, 0);
            int n = drawableParams.getScreenWidth();
            int n2 = drawableParams.getScreenHeight();
            int n3 = View.MeasureSpec.makeMeasureSpec(n, 0x40000000);
            int n4 = View.MeasureSpec.makeMeasureSpec(n2, 0x40000000);
            frameLayout.measure(n3, n4);
            frameLayout.layout(0, 0, n, n2);
            frameLayout.mAttachInfo.mTreeObserver.dispatchOnPreDraw();
            BufferedImage bufferedImage = this.getImage(n, n2);
            Bitmap bitmap = Bitmap_Delegate.createBitmap(bufferedImage, true, drawableParams.getDensity());
            Canvas canvas = new Canvas(bitmap);
            canvas.setDensity(drawableParams.getDensity().getDpiValue());
            frameLayout.draw(canvas);
            return Result.Status.SUCCESS.createResult((Object)bufferedImage);
        }
        catch (IOException iOException) {
            return Result.Status.ERROR_UNKNOWN.createResult(iOException.getMessage(), (Throwable)iOException);
        }
    }

    protected BufferedImage getImage(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setColor(new Color(0, true));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }
}

