/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.LayoutTransition;
import android.app.Fragment_Delegate;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.ExpandableListView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.QuickContactBadge;
import android.widget.TabHost;
import android.widget.TabWidget;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.IAnimationListener;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeInflater;
import com.android.layoutlib.bridge.android.BridgeLayoutParamsMapAttributes;
import com.android.layoutlib.bridge.android.BridgeWindow;
import com.android.layoutlib.bridge.android.BridgeWindowSession;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.bars.CustomBar;
import com.android.layoutlib.bridge.bars.FakeActionBar;
import com.android.layoutlib.bridge.bars.PhoneSystemBar;
import com.android.layoutlib.bridge.bars.TabletSystemBar;
import com.android.layoutlib.bridge.bars.TitleBar;
import com.android.layoutlib.bridge.impl.AnimationThread;
import com.android.layoutlib.bridge.impl.PlayAnimationThread;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.layoutlib.bridge.impl.binding.FakeAdapter;
import com.android.layoutlib.bridge.impl.binding.FakeExpandableAdapter;
import com.android.resources.ResourceType;
import com.android.resources.ScreenSize;
import com.android.util.Pair;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderSessionImpl
extends RenderAction<SessionParams> {
    private static final int DEFAULT_TITLE_BAR_HEIGHT = 25;
    private static final int DEFAULT_STATUS_BAR_HEIGHT = 25;
    private RenderSession mScene;
    private BridgeXmlBlockParser mBlockParser;
    private BridgeInflater mInflater;
    private ResourceValue mWindowBackground;
    private ViewGroup mViewRoot;
    private FrameLayout mContentRoot;
    private Canvas mCanvas;
    private int mMeasuredScreenWidth = -1;
    private int mMeasuredScreenHeight = -1;
    private boolean mIsAlphaChannelImage;
    private boolean mWindowIsFloating;
    private int mStatusBarSize;
    private int mSystemBarSize;
    private int mTitleBarSize;
    private int mActionBarSize;
    private BufferedImage mImage;
    private List<ViewInfo> mViewInfoList;

    public RenderSessionImpl(SessionParams sessionParams) {
        super(new SessionParams(sessionParams));
    }

    @Override
    public Result init(long l) {
        Result result = super.init(l);
        if (!result.isSuccess()) {
            return result;
        }
        SessionParams sessionParams = (SessionParams)this.getParams();
        BridgeContext bridgeContext = this.getContext();
        RenderResources renderResources = ((SessionParams)this.getParams()).getResources();
        DisplayMetrics displayMetrics = this.getContext().getMetrics();
        this.mIsAlphaChannelImage = this.getBooleanThemeValue(renderResources, "windowIsFloating", true);
        this.mWindowIsFloating = this.getBooleanThemeValue(renderResources, "windowIsFloating", true);
        this.findBackground(renderResources);
        this.findStatusBar(renderResources, displayMetrics);
        this.findActionBar(renderResources, displayMetrics);
        this.findSystemBar(renderResources, displayMetrics);
        this.mInflater = new BridgeInflater(bridgeContext, sessionParams.getProjectCallback());
        bridgeContext.setBridgeInflater(this.mInflater);
        this.mInflater.setFactory2(bridgeContext);
        this.mBlockParser = new BridgeXmlBlockParser((XmlPullParser)sessionParams.getLayoutDescription(), bridgeContext, false);
        return Result.Status.SUCCESS.createResult();
    }

    public Result inflate() {
        this.checkLock();
        try {
            Object object;
            Object object2;
            View view;
            SessionParams sessionParams = (SessionParams)this.getParams();
            BridgeContext bridgeContext = this.getContext();
            ViewGroup viewGroup = null;
            if (this.mWindowIsFloating || sessionParams.isForceNoDecor()) {
                this.mContentRoot = new FrameLayout(bridgeContext);
                this.mViewRoot = this.mContentRoot;
                viewGroup = this.mContentRoot;
            } else {
                CustomBar customBar;
                view = new LinearLayout(bridgeContext);
                this.mViewRoot = view;
                ((LinearLayout)view).setOrientation(1);
                if (this.mStatusBarSize > 0) {
                    try {
                        object2 = new PhoneSystemBar((Context)bridgeContext, sessionParams.getDensity());
                        ((View)object2).setLayoutParams(new LinearLayout.LayoutParams(-1, this.mStatusBarSize));
                        ((ViewGroup)view).addView((View)object2);
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        // empty catch block
                    }
                }
                object2 = new LinearLayout(bridgeContext);
                viewGroup = object2;
                ((LinearLayout)object2).setOrientation(1);
                object = new LinearLayout.LayoutParams(-1, -2);
                ((LinearLayout.LayoutParams)object).weight = 1.0f;
                ((View)object2).setLayoutParams((ViewGroup.LayoutParams)object);
                ((ViewGroup)view).addView((View)object2);
                if (this.mActionBarSize > 0) {
                    try {
                        customBar = new FakeActionBar(bridgeContext, sessionParams.getDensity(), sessionParams.getAppLabel(), sessionParams.getAppIcon());
                        customBar.setLayoutParams(new LinearLayout.LayoutParams(-1, this.mActionBarSize));
                        ((ViewGroup)object2).addView(customBar);
                    }
                    catch (XmlPullParserException xmlPullParserException) {}
                } else if (this.mTitleBarSize > 0) {
                    try {
                        customBar = new TitleBar((Context)bridgeContext, sessionParams.getDensity(), sessionParams.getAppLabel());
                        customBar.setLayoutParams(new LinearLayout.LayoutParams(-1, this.mTitleBarSize));
                        ((ViewGroup)object2).addView(customBar);
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        // empty catch block
                    }
                }
                this.mContentRoot = new FrameLayout(bridgeContext);
                object = new LinearLayout.LayoutParams(-1, -2);
                ((LinearLayout.LayoutParams)object).weight = 1.0f;
                this.mContentRoot.setLayoutParams((ViewGroup.LayoutParams)object);
                ((ViewGroup)object2).addView(this.mContentRoot);
                if (this.mSystemBarSize > 0) {
                    try {
                        customBar = new TabletSystemBar((Context)bridgeContext, sessionParams.getDensity());
                        customBar.setLayoutParams(new LinearLayout.LayoutParams(-1, this.mSystemBarSize));
                        ((ViewGroup)view).addView(customBar);
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        // empty catch block
                    }
                }
            }
            Fragment_Delegate.setProjectCallback(sessionParams.getProjectCallback());
            view = this.mInflater.inflate(this.mBlockParser, (ViewGroup)this.mContentRoot);
            bridgeContext.popParser();
            Fragment_Delegate.setProjectCallback(null);
            object2 = new View.AttachInfo(new BridgeWindowSession(), new BridgeWindow(), new Handler(), null);
            ((View.AttachInfo)object2).mHasWindowFocus = true;
            ((View.AttachInfo)object2).mWindowVisibility = 0;
            ((View.AttachInfo)object2).mInTouchMode = false;
            ((View.AttachInfo)object2).mHardwareAccelerated = false;
            this.mViewRoot.dispatchAttachedToWindow((View.AttachInfo)object2, 0);
            this.postInflateProcess(view, sessionParams.getProjectCallback());
            if (this.mWindowBackground != null && viewGroup != null) {
                object = ResourceHelper.getDrawable(this.mWindowBackground, bridgeContext);
                viewGroup.setBackgroundDrawable((Drawable)object);
            }
            return Result.Status.SUCCESS.createResult();
        }
        catch (PostInflateException postInflateException) {
            return Result.Status.ERROR_INFLATION.createResult(postInflateException.getMessage(), (Throwable)postInflateException);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            while (throwable2.getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            return Result.Status.ERROR_INFLATION.createResult(throwable2.getMessage(), throwable2);
        }
    }

    public Result render(boolean bl) {
        this.checkLock();
        SessionParams sessionParams = (SessionParams)this.getParams();
        try {
            int n;
            if (this.mViewRoot == null) {
                return Result.Status.ERROR_NOT_INFLATED.createResult();
            }
            SessionParams.RenderingMode renderingMode = sessionParams.getRenderingMode();
            boolean bl2 = false;
            if (this.mMeasuredScreenWidth == -1) {
                bl2 = true;
                this.mMeasuredScreenWidth = sessionParams.getScreenWidth();
                this.mMeasuredScreenHeight = sessionParams.getScreenHeight();
                if (renderingMode != SessionParams.RenderingMode.NORMAL) {
                    int n2;
                    int n3;
                    n = renderingMode.isHorizExpand() ? 0 : 0x40000000;
                    int n4 = renderingMode.isVertExpand() ? 0 : 0x40000000;
                    Pair<Integer, Integer> pair = this.measureView(this.mViewRoot, this.mContentRoot.getChildAt(0), this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
                    Pair<Integer, Integer> pair2 = this.measureView(this.mContentRoot, this.mContentRoot.getChildAt(0), this.mMeasuredScreenWidth, n, this.mMeasuredScreenHeight, n4);
                    if (renderingMode.isHorizExpand()) {
                        n3 = (Integer)pair.getFirst();
                        n2 = (Integer)pair2.getFirst();
                        if (n2 > n3) {
                            this.mMeasuredScreenWidth += n2 - n3;
                        }
                    }
                    if (renderingMode.isVertExpand()) {
                        n3 = (Integer)pair.getSecond();
                        n2 = (Integer)pair2.getSecond();
                        if (n2 > n3) {
                            this.mMeasuredScreenHeight += n2 - n3;
                        }
                    }
                }
            }
            this.measureView(this.mViewRoot, null, this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
            this.mViewRoot.layout(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
            if (sessionParams.isLayoutOnly()) {
                this.mImage = null;
                this.mCanvas = null;
            } else {
                this.mViewRoot.mAttachInfo.mTreeObserver.dispatchOnPreDraw();
                n = 0;
                if (bl2 || this.mCanvas == null) {
                    if (sessionParams.getImageFactory() != null) {
                        this.mImage = sessionParams.getImageFactory().getImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                    } else {
                        this.mImage = new BufferedImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight, 2);
                        n = 1;
                    }
                    if (sessionParams.isBgColorOverridden()) {
                        n = 1;
                        Graphics2D graphics2D = this.mImage.createGraphics();
                        graphics2D.setColor(new Color(sessionParams.getOverrideBgColor(), true));
                        graphics2D.setComposite(AlphaComposite.Src);
                        graphics2D.fillRect(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                        graphics2D.dispose();
                    }
                    Bitmap bitmap = Bitmap_Delegate.createBitmap(this.mImage, true, sessionParams.getDensity());
                    this.mCanvas = new Canvas(bitmap);
                    this.mCanvas.setDensity(sessionParams.getDensity().getDpiValue());
                }
                if (bl && n == 0) {
                    Graphics2D graphics2D = this.mImage.createGraphics();
                    graphics2D.setComposite(AlphaComposite.Src);
                    graphics2D.setColor(new Color(0, true));
                    graphics2D.fillRect(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                    graphics2D.dispose();
                }
                this.mViewRoot.draw(this.mCanvas);
            }
            this.mViewInfoList = this.startVisitingViews(this.mViewRoot, 0, sessionParams.getExtendedViewInfoMode());
            return Result.Status.SUCCESS.createResult();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            while (throwable2.getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            return Result.Status.ERROR_UNKNOWN.createResult(throwable2.getMessage(), throwable2);
        }
    }

    private Pair<Integer, Integer> measureView(ViewGroup viewGroup, View view, int n, int n2, int n3, int n4) {
        int n5 = View.MeasureSpec.makeMeasureSpec(n, n2);
        int n6 = View.MeasureSpec.makeMeasureSpec(n3, n4);
        viewGroup.measure(n5, n6);
        if (view != null) {
            return Pair.of((Object)view.getMeasuredWidth(), (Object)view.getMeasuredHeight());
        }
        return null;
    }

    public Result animate(Object object, String string2, boolean bl, IAnimationListener iAnimationListener) {
        this.checkLock();
        BridgeContext bridgeContext = this.getContext();
        ResourceValue resourceValue = null;
        int n = 0;
        if (bl) {
            resourceValue = bridgeContext.getRenderResources().getFrameworkResource(ResourceType.ANIMATOR, string2);
            if (resourceValue != null) {
                n = Bridge.getResourceId(ResourceType.ANIMATOR, string2);
            }
        } else {
            resourceValue = bridgeContext.getRenderResources().getProjectResource(ResourceType.ANIMATOR, string2);
            if (resourceValue != null) {
                n = bridgeContext.getProjectCallback().getResourceId(ResourceType.ANIMATOR, string2);
            }
        }
        if (resourceValue != null) {
            try {
                Animator animator2 = AnimatorInflater.loadAnimator(bridgeContext, n);
                if (animator2 != null) {
                    animator2.setTarget(object);
                    new PlayAnimationThread(animator2, this, string2, iAnimationListener).start();
                    return Result.Status.SUCCESS.createResult();
                }
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                while (throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                return Result.Status.ERROR_UNKNOWN.createResult(throwable.getMessage(), throwable);
            }
        }
        return Result.Status.ERROR_ANIM_NOT_FOUND.createResult();
    }

    public Result insertChild(final ViewGroup viewGroup, ILayoutPullParser iLayoutPullParser, final int n, IAnimationListener iAnimationListener) {
        this.checkLock();
        BridgeContext bridgeContext = this.getContext();
        BridgeXmlBlockParser bridgeXmlBlockParser = new BridgeXmlBlockParser((XmlPullParser)iLayoutPullParser, bridgeContext, false);
        final View view = this.mInflater.inflate(bridgeXmlBlockParser, viewGroup, false);
        bridgeXmlBlockParser.ensurePopped();
        this.invalidateRenderingSize();
        if (iAnimationListener != null) {
            new AnimationThread(this, "insertChild", iAnimationListener){

                public Result preAnimation() {
                    viewGroup.setLayoutTransition(new LayoutTransition());
                    return RenderSessionImpl.this.addView(viewGroup, view, n);
                }

                public void postAnimation() {
                    viewGroup.setLayoutTransition(null);
                }
            }.start();
            return Result.Status.SUCCESS.createResult((Object)view);
        }
        Result result = this.addView(viewGroup, view, n);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.render(false);
        if (result.isSuccess()) {
            result = result.getCopyWithData((Object)view);
        }
        return result;
    }

    private Result addView(ViewGroup viewGroup, View view, int n) {
        try {
            viewGroup.addView(view, n);
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    public Result moveChild(final ViewGroup viewGroup, final View view, final int n, Map<String, String> map, final IAnimationListener iAnimationListener) {
        this.checkLock();
        this.invalidateRenderingSize();
        ViewGroup.LayoutParams layoutParams = null;
        if (map != null) {
            layoutParams = viewGroup.generateLayoutParams(new BridgeLayoutParamsMapAttributes(map));
        }
        final ViewGroup viewGroup2 = (ViewGroup)view.getParent();
        if (iAnimationListener != null) {
            final ViewGroup.LayoutParams layoutParams2 = layoutParams;
            if (viewGroup2 != viewGroup) {
                new Thread("not animated moveChild"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Result result = RenderSessionImpl.this.moveView(viewGroup2, viewGroup, view, n, layoutParams2);
                        if (!result.isSuccess()) {
                            iAnimationListener.done(result);
                        }
                        if (!(result = RenderSessionImpl.this.acquire(250L)).isSuccess()) {
                            iAnimationListener.done(result);
                            return;
                        }
                        try {
                            result = RenderSessionImpl.this.render(false);
                            if (result.isSuccess()) {
                                iAnimationListener.onNewFrame(RenderSessionImpl.this.getSession());
                            }
                        }
                        finally {
                            RenderSessionImpl.this.release();
                        }
                        iAnimationListener.done(result);
                    }
                }.start();
            } else {
                new AnimationThread(this, "moveChild", iAnimationListener){

                    public Result preAnimation() {
                        LayoutTransition layoutTransition = new LayoutTransition();
                        viewGroup2.setLayoutTransition(layoutTransition);
                        layoutTransition.setDuration(3, 100L);
                        layoutTransition.setStartDelay(1, 100L);
                        layoutTransition.setDuration(1, 100L);
                        layoutTransition.setDuration(0, 100L);
                        layoutTransition.setStartDelay(2, 100L);
                        layoutTransition.setDuration(2, 100L);
                        return RenderSessionImpl.this.moveView(viewGroup2, viewGroup, view, n, layoutParams2);
                    }

                    public void postAnimation() {
                        viewGroup2.setLayoutTransition(null);
                        viewGroup.setLayoutTransition(null);
                    }
                }.start();
            }
            return Result.Status.SUCCESS.createResult((Object)layoutParams);
        }
        Result result = this.moveView(viewGroup2, viewGroup, view, n, layoutParams);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.render(false);
        if (layoutParams != null && result.isSuccess()) {
            result = result.getCopyWithData((Object)layoutParams);
        }
        return result;
    }

    private Result moveView(ViewGroup viewGroup, final ViewGroup viewGroup2, final View view, final int n, final ViewGroup.LayoutParams layoutParams) {
        try {
            LayoutTransition layoutTransition = viewGroup.getLayoutTransition();
            if (layoutTransition != null) {
                layoutTransition.addTransitionListener(new LayoutTransition.TransitionListener(){
                    private int mChangeDisappearingCount = 0;

                    public void startTransition(LayoutTransition layoutTransition, ViewGroup viewGroup, View view2, int n2) {
                        if (n2 == 1) {
                            ++this.mChangeDisappearingCount;
                        }
                    }

                    public void endTransition(LayoutTransition layoutTransition, ViewGroup viewGroup, View view2, int n2) {
                        if (n2 == 1) {
                            --this.mChangeDisappearingCount;
                        }
                        if (n2 == 1 && this.mChangeDisappearingCount == 0) {
                            if (layoutParams != null) {
                                viewGroup2.addView(view, n, layoutParams);
                            } else {
                                viewGroup2.addView(view, n);
                            }
                        }
                    }
                });
                viewGroup.removeView(view);
                return Result.Status.SUCCESS.createResult();
            }
            viewGroup.removeView(view);
            if (layoutParams != null) {
                viewGroup2.addView(view, n, layoutParams);
            } else {
                viewGroup2.addView(view, n);
            }
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    public Result removeChild(final View view, IAnimationListener iAnimationListener) {
        this.checkLock();
        this.invalidateRenderingSize();
        final ViewGroup viewGroup = (ViewGroup)view.getParent();
        if (iAnimationListener != null) {
            new AnimationThread(this, "moveChild", iAnimationListener){

                public Result preAnimation() {
                    viewGroup.setLayoutTransition(new LayoutTransition());
                    return RenderSessionImpl.this.removeView(viewGroup, view);
                }

                public void postAnimation() {
                    viewGroup.setLayoutTransition(null);
                }
            }.start();
            return Result.Status.SUCCESS.createResult();
        }
        Result result = this.removeView(viewGroup, view);
        if (!result.isSuccess()) {
            return result;
        }
        return this.render(false);
    }

    private Result removeView(ViewGroup viewGroup, View view) {
        try {
            viewGroup.removeView(view);
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    private void findBackground(RenderResources renderResources) {
        if (!((SessionParams)this.getParams()).isBgColorOverridden()) {
            this.mWindowBackground = renderResources.findItemInTheme("windowBackground");
            if (this.mWindowBackground != null) {
                this.mWindowBackground = renderResources.resolveResValue(this.mWindowBackground);
            }
        }
    }

    private boolean isTabletUi() {
        return ((SessionParams)this.getParams()).getConfigScreenSize() == ScreenSize.XLARGE;
    }

    private void findStatusBar(RenderResources renderResources, DisplayMetrics displayMetrics) {
        boolean bl;
        if (!(this.isTabletUi() || (bl = this.getBooleanThemeValue(renderResources, "windowFullscreen", false)) || this.mWindowIsFloating)) {
            TypedValue typedValue;
            this.mStatusBarSize = 25;
            ResourceValue resourceValue = renderResources.getFrameworkResource(ResourceType.DIMEN, "status_bar_height");
            if (resourceValue != null && (typedValue = ResourceHelper.getValue("status_bar_height", resourceValue.getValue(), true)) != null) {
                this.mStatusBarSize = (int)typedValue.getDimension(displayMetrics);
            }
        }
    }

    private void findActionBar(RenderResources renderResources, DisplayMetrics displayMetrics) {
        if (this.mWindowIsFloating) {
            return;
        }
        boolean bl = this.getBooleanThemeValue(renderResources, "windowActionBar", true);
        if (bl) {
            TypedValue typedValue;
            this.mActionBarSize = 25;
            ResourceValue resourceValue = renderResources.findItemInTheme("actionBarSize");
            if ((resourceValue = renderResources.resolveResValue(resourceValue)) != null && (typedValue = ResourceHelper.getValue("actionBarSize", resourceValue.getValue(), true)) != null) {
                this.mActionBarSize = (int)typedValue.getDimension(displayMetrics);
            }
        } else {
            boolean bl2 = this.getBooleanThemeValue(renderResources, "windowNoTitle", false);
            if (!bl2) {
                TypedValue typedValue;
                this.mTitleBarSize = 25;
                ResourceValue resourceValue = renderResources.findItemInTheme("windowTitleSize");
                if ((resourceValue = renderResources.resolveResValue(resourceValue)) != null && (typedValue = ResourceHelper.getValue("windowTitleSize", resourceValue.getValue(), true)) != null) {
                    this.mTitleBarSize = (int)typedValue.getDimension(displayMetrics);
                }
            }
        }
    }

    private void findSystemBar(RenderResources renderResources, DisplayMetrics displayMetrics) {
        if (this.isTabletUi() && !this.mWindowIsFloating) {
            TypedValue typedValue;
            this.mSystemBarSize = 48;
            ResourceValue resourceValue = renderResources.getFrameworkResource(ResourceType.DIMEN, "status_bar_height");
            if (resourceValue != null && (typedValue = ResourceHelper.getValue("status_bar_height", resourceValue.getValue(), true)) != null) {
                this.mSystemBarSize = (int)typedValue.getDimension(displayMetrics);
            }
        }
    }

    private boolean getBooleanThemeValue(RenderResources renderResources, String string2, boolean bl) {
        ResourceValue resourceValue = renderResources.findItemInTheme(string2);
        if ((resourceValue = renderResources.resolveResValue(resourceValue)) == null || resourceValue.getValue() == null) {
            return bl;
        }
        return XmlUtils.convertValueToBoolean(resourceValue.getValue(), bl);
    }

    private void postInflateProcess(View view, IProjectCallback iProjectCallback) throws PostInflateException {
        block11: {
            block13: {
                AdapterBinding adapterBinding;
                SessionParams sessionParams;
                ResourceReference resourceReference;
                block14: {
                    block12: {
                        block10: {
                            if (!(view instanceof TabHost)) break block10;
                            this.setupTabHost((TabHost)view, iProjectCallback);
                            break block11;
                        }
                        if (!(view instanceof QuickContactBadge)) break block12;
                        QuickContactBadge quickContactBadge = (QuickContactBadge)view;
                        quickContactBadge.setImageToDefault();
                        break block11;
                    }
                    if (!(view instanceof AdapterView)) break block13;
                    int n = view.getId();
                    BridgeContext bridgeContext = this.getContext();
                    resourceReference = bridgeContext.resolveId(n);
                    if (resourceReference == null) break block11;
                    sessionParams = (SessionParams)this.getParams();
                    adapterBinding = (AdapterBinding)sessionParams.getAdapterBindings().get(resourceReference);
                    if (adapterBinding == null) {
                        adapterBinding = sessionParams.getProjectCallback().getAdapterBinding(resourceReference, bridgeContext.getViewKey(view), (Object)view);
                    }
                    if (adapterBinding == null) break block11;
                    if (!(view instanceof AbsListView)) break block14;
                    if ((adapterBinding.getFooterCount() > 0 || adapterBinding.getHeaderCount() > 0) && view instanceof ListView) {
                        Pair<View, Boolean> pair;
                        int n2;
                        ListView listView = (ListView)view;
                        boolean bl = false;
                        int n3 = adapterBinding.getHeaderCount();
                        for (n2 = 0; n2 < n3; ++n2) {
                            pair = bridgeContext.inflateView(adapterBinding.getHeaderAt(n2), listView, false, bl);
                            if (pair.getFirst() != null) {
                                listView.addHeaderView((View)pair.getFirst());
                            }
                            bl |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                        n3 = adapterBinding.getFooterCount();
                        for (n2 = 0; n2 < n3; ++n2) {
                            pair = bridgeContext.inflateView(adapterBinding.getFooterAt(n2), listView, false, bl);
                            if (pair.getFirst() != null) {
                                listView.addFooterView((View)pair.getFirst());
                            }
                            bl |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                    }
                    if (view instanceof ExpandableListView) {
                        ((ExpandableListView)view).setAdapter(new FakeExpandableAdapter(resourceReference, adapterBinding, sessionParams.getProjectCallback()));
                    } else {
                        ((AbsListView)view).setAdapter(new FakeAdapter(resourceReference, adapterBinding, sessionParams.getProjectCallback()));
                    }
                    break block11;
                }
                if (!(view instanceof AbsSpinner)) break block11;
                ((AbsSpinner)view).setAdapter(new FakeAdapter(resourceReference, adapterBinding, sessionParams.getProjectCallback()));
                break block11;
            }
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                int n = viewGroup.getChildCount();
                for (int i = 0; i < n; ++i) {
                    View view2 = viewGroup.getChildAt(i);
                    this.postInflateProcess(view2, iProjectCallback);
                }
            }
        }
    }

    private void setupTabHost(TabHost tabHost, IProjectCallback iProjectCallback) throws PostInflateException {
        View view = tabHost.findViewById(16908307);
        if (view == null) {
            throw new PostInflateException("TabHost requires a TabWidget with id \"android:id/tabs\".\n");
        }
        if (!(view instanceof TabWidget)) {
            throw new PostInflateException(String.format("TabHost requires a TabWidget with id \"android:id/tabs\".\nView found with id 'tabs' is '%s'", view.getClass().getCanonicalName()));
        }
        view = tabHost.findViewById(0x1020011);
        if (view == null) {
            throw new PostInflateException("TabHost requires a FrameLayout with id \"android:id/tabcontent\".");
        }
        if (!(view instanceof FrameLayout)) {
            throw new PostInflateException(String.format("TabHost requires a FrameLayout with id \"android:id/tabcontent\".\nView found with id 'tabcontent' is '%s'", view.getClass().getCanonicalName()));
        }
        FrameLayout frameLayout = (FrameLayout)view;
        int n = frameLayout.getChildCount();
        tabHost.setup();
        if (n == 0) {
            TabHost.TabSpec tabSpec = tabHost.newTabSpec("tag").setIndicator("Tab Label", tabHost.getResources().getDrawable(17301569)).setContent(new TabHost.TabContentFactory(){

                public View createTabContent(String string2) {
                    return new LinearLayout(RenderSessionImpl.this.getContext());
                }
            });
            tabHost.addTab(tabSpec);
            return;
        }
        for (int i = 0; i < n; ++i) {
            View view2 = frameLayout.getChildAt(i);
            String string2 = String.format("tab_spec%d", i + 1);
            int n2 = view2.getId();
            Pair pair = iProjectCallback.resolveResourceId(n2);
            String string3 = pair != null ? (String)pair.getSecond() : String.format("Tab %d", i + 1);
            tabHost.addTab(tabHost.newTabSpec(string2).setIndicator(string3).setContent(n2));
        }
    }

    private List<ViewInfo> startVisitingViews(View view, int n, boolean bl) {
        if (view == null) {
            return null;
        }
        n += view.getTop();
        if (view == this.mContentRoot) {
            return this.visitAllChildren(this.mContentRoot, n, bl);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                List<ViewInfo> list = this.startVisitingViews(viewGroup.getChildAt(i), n, bl);
                if (list == null) continue;
                return list;
            }
        }
        return null;
    }

    private ViewInfo visit(View view, int n, boolean bl) {
        Object object;
        if (view == null) {
            return null;
        }
        ViewInfo viewInfo = new ViewInfo(view.getClass().getName(), this.getContext().getViewKey(view), view.getLeft(), view.getTop() + n, view.getRight(), view.getBottom() + n, (Object)view, (Object)view.getLayoutParams());
        if (bl) {
            object = null;
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                object = (ViewGroup.MarginLayoutParams)layoutParams;
            }
            viewInfo.setExtendedInfo(view.getBaseline(), object != null ? ((ViewGroup.MarginLayoutParams)object).leftMargin : 0, object != null ? ((ViewGroup.MarginLayoutParams)object).topMargin : 0, object != null ? ((ViewGroup.MarginLayoutParams)object).rightMargin : 0, object != null ? ((ViewGroup.MarginLayoutParams)object).bottomMargin : 0);
        }
        if (view instanceof ViewGroup) {
            object = (ViewGroup)view;
            viewInfo.setChildren(this.visitAllChildren((ViewGroup)object, 0, bl));
        }
        return viewInfo;
    }

    private List<ViewInfo> visitAllChildren(ViewGroup viewGroup, int n, boolean bl) {
        if (viewGroup == null) {
            return null;
        }
        ArrayList<ViewInfo> arrayList = new ArrayList<ViewInfo>();
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            arrayList.add(this.visit(viewGroup.getChildAt(i), n, bl));
        }
        return arrayList;
    }

    private void invalidateRenderingSize() {
        this.mMeasuredScreenHeight = -1;
        this.mMeasuredScreenWidth = -1;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public boolean isAlphaChannelImage() {
        return this.mIsAlphaChannelImage;
    }

    public List<ViewInfo> getViewInfos() {
        return this.mViewInfoList;
    }

    public Map<String, String> getDefaultProperties(Object object) {
        return this.getContext().getDefaultPropMap(object);
    }

    public void setScene(RenderSession renderSession) {
        this.mScene = renderSession;
    }

    public RenderSession getSession() {
        return this.mScene;
    }

    private static final class PostInflateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PostInflateException(String string2) {
            super(string2);
        }
    }
}

