/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gles_jni;

import android.app.AppGlobals;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL10Ext;
import javax.microedition.khronos.opengles.GL11;
import javax.microedition.khronos.opengles.GL11Ext;
import javax.microedition.khronos.opengles.GL11ExtensionPack;

public class GLImpl
implements GL10,
GL10Ext,
GL11,
GL11Ext,
GL11ExtensionPack {
    public Buffer _colorPointer = null;
    public Buffer _normalPointer = null;
    public Buffer _texCoordPointer = null;
    public Buffer _vertexPointer = null;
    public Buffer _pointSizePointerOES = null;
    public Buffer _matrixIndexPointerOES = null;
    public Buffer _weightPointerOES = null;
    public boolean haveCheckedExtensions;
    public boolean have_OES_blend_equation_separate;
    public boolean have_OES_blend_subtract;
    public boolean have_OES_framebuffer_object;
    public boolean have_OES_texture_cube_map;

    public static void _nativeClassInit() {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#_nativeClassInit()V", true, null);
    }

    public void glGetPointerv(int pname, Buffer[] params) {
        throw new UnsupportedOperationException("glGetPointerv");
    }

    public static boolean allowIndirectBuffers(String appName) {
        boolean result = false;
        int version = 0;
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            ApplicationInfo applicationInfo = pm.getApplicationInfo(appName, 0);
            if (applicationInfo != null) {
                version = applicationInfo.targetSdkVersion;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        Log.e("OpenGLES", String.format("Application %s (SDK target %d) called a GL11 Pointer method with an indirect Buffer.", appName, version));
        if (version <= 3) {
            result = true;
        }
        return result;
    }

    public void glActiveTexture(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glActiveTexture(I)V", true, this);
    }

    public void glAlphaFunc(int n, float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glAlphaFunc(IF)V", true, this);
    }

    public void glAlphaFuncx(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glAlphaFuncx(II)V", true, this);
    }

    public void glBindTexture(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glBindTexture(II)V", true, this);
    }

    public void glBlendFunc(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glBlendFunc(II)V", true, this);
    }

    public void glClear(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glClear(I)V", true, this);
    }

    public void glClearColor(float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glClearColor(FFFF)V", true, this);
    }

    public void glClearColorx(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glClearColorx(IIII)V", true, this);
    }

    public void glClearDepthf(float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glClearDepthf(F)V", true, this);
    }

    public void glClearDepthx(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glClearDepthx(I)V", true, this);
    }

    public void glClearStencil(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glClearStencil(I)V", true, this);
    }

    public void glClientActiveTexture(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glClientActiveTexture(I)V", true, this);
    }

    public void glColor4f(float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glColor4f(FFFF)V", true, this);
    }

    public void glColor4x(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glColor4x(IIII)V", true, this);
    }

    public void glColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glColorMask(ZZZZ)V", true, this);
    }

    public void glColorPointerBounds(int n, int n2, int n3, Buffer buffer, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glColorPointerBounds(IIILjava/nio/Buffer;I)V", true, this);
    }

    public void glColorPointer(int size, int type, int stride, Buffer pointer) {
        this.glColorPointerBounds(size, type, stride, pointer, pointer.remaining());
        if (size == 4 && (type == 5126 || type == 5121 || type == 5132) && stride >= 0) {
            this._colorPointer = pointer;
        }
    }

    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glCompressedTexImage2D(IIIIIIILjava/nio/Buffer;)V", true, this);
    }

    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glCompressedTexSubImage2D(IIIIIIIILjava/nio/Buffer;)V", true, this);
    }

    public void glCopyTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glCopyTexImage2D(IIIIIIII)V", true, this);
    }

    public void glCopyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glCopyTexSubImage2D(IIIIIIII)V", true, this);
    }

    public void glCullFace(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glCullFace(I)V", true, this);
    }

    public void glDeleteTextures(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDeleteTextures(I[II)V", true, this);
    }

    public void glDeleteTextures(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDeleteTextures(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glDepthFunc(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDepthFunc(I)V", true, this);
    }

    public void glDepthMask(boolean bl) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDepthMask(Z)V", true, this);
    }

    public void glDepthRangef(float f, float f2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDepthRangef(FF)V", true, this);
    }

    public void glDepthRangex(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDepthRangex(II)V", true, this);
    }

    public void glDisable(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDisable(I)V", true, this);
    }

    public void glDisableClientState(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDisableClientState(I)V", true, this);
    }

    public void glDrawArrays(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawArrays(III)V", true, this);
    }

    public void glDrawElements(int n, int n2, int n3, Buffer buffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawElements(IIILjava/nio/Buffer;)V", true, this);
    }

    public void glEnable(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glEnable(I)V", true, this);
    }

    public void glEnableClientState(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glEnableClientState(I)V", true, this);
    }

    public void glFinish() {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFinish()V", true, this);
    }

    public void glFlush() {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFlush()V", true, this);
    }

    public void glFogf(int n, float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFogf(IF)V", true, this);
    }

    public void glFogfv(int n, float[] fArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFogfv(I[FI)V", true, this);
    }

    public void glFogfv(int n, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFogfv(ILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glFogx(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFogx(II)V", true, this);
    }

    public void glFogxv(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFogxv(I[II)V", true, this);
    }

    public void glFogxv(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFogxv(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glFrontFace(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFrontFace(I)V", true, this);
    }

    public void glFrustumf(float f, float f2, float f3, float f4, float f5, float f6) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFrustumf(FFFFFF)V", true, this);
    }

    public void glFrustumx(int n, int n2, int n3, int n4, int n5, int n6) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFrustumx(IIIIII)V", true, this);
    }

    public void glGenTextures(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGenTextures(I[II)V", true, this);
    }

    public void glGenTextures(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGenTextures(ILjava/nio/IntBuffer;)V", true, this);
    }

    public int glGetError() {
        return OverrideMethod.invokeI("com.google.android.gles_jni.GLImpl#glGetError()I", true, this);
    }

    public void glGetIntegerv(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetIntegerv(I[II)V", true, this);
    }

    public void glGetIntegerv(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetIntegerv(ILjava/nio/IntBuffer;)V", true, this);
    }

    public String _glGetString(int n) {
        return (String)OverrideMethod.invokeA("com.google.android.gles_jni.GLImpl#_glGetString(I)Ljava/lang/String;", true, this);
    }

    public String glGetString(int name) {
        String returnValue = this._glGetString(name);
        return returnValue;
    }

    public void glHint(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glHint(II)V", true, this);
    }

    public void glLightModelf(int n, float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightModelf(IF)V", true, this);
    }

    public void glLightModelfv(int n, float[] fArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightModelfv(I[FI)V", true, this);
    }

    public void glLightModelfv(int n, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightModelfv(ILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glLightModelx(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightModelx(II)V", true, this);
    }

    public void glLightModelxv(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightModelxv(I[II)V", true, this);
    }

    public void glLightModelxv(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightModelxv(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glLightf(int n, int n2, float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightf(IIF)V", true, this);
    }

    public void glLightfv(int n, int n2, float[] fArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightfv(II[FI)V", true, this);
    }

    public void glLightfv(int n, int n2, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightfv(IILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glLightx(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightx(III)V", true, this);
    }

    public void glLightxv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightxv(II[II)V", true, this);
    }

    public void glLightxv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLightxv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glLineWidth(float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLineWidth(F)V", true, this);
    }

    public void glLineWidthx(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLineWidthx(I)V", true, this);
    }

    public void glLoadIdentity() {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLoadIdentity()V", true, this);
    }

    public void glLoadMatrixf(float[] fArray, int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLoadMatrixf([FI)V", true, this);
    }

    public void glLoadMatrixf(FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLoadMatrixf(Ljava/nio/FloatBuffer;)V", true, this);
    }

    public void glLoadMatrixx(int[] nArray, int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLoadMatrixx([II)V", true, this);
    }

    public void glLoadMatrixx(IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLoadMatrixx(Ljava/nio/IntBuffer;)V", true, this);
    }

    public void glLogicOp(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLogicOp(I)V", true, this);
    }

    public void glMaterialf(int n, int n2, float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMaterialf(IIF)V", true, this);
    }

    public void glMaterialfv(int n, int n2, float[] fArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMaterialfv(II[FI)V", true, this);
    }

    public void glMaterialfv(int n, int n2, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMaterialfv(IILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glMaterialx(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMaterialx(III)V", true, this);
    }

    public void glMaterialxv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMaterialxv(II[II)V", true, this);
    }

    public void glMaterialxv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMaterialxv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glMatrixMode(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMatrixMode(I)V", true, this);
    }

    public void glMultMatrixf(float[] fArray, int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMultMatrixf([FI)V", true, this);
    }

    public void glMultMatrixf(FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMultMatrixf(Ljava/nio/FloatBuffer;)V", true, this);
    }

    public void glMultMatrixx(int[] nArray, int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMultMatrixx([II)V", true, this);
    }

    public void glMultMatrixx(IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMultMatrixx(Ljava/nio/IntBuffer;)V", true, this);
    }

    public void glMultiTexCoord4f(int n, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMultiTexCoord4f(IFFFF)V", true, this);
    }

    public void glMultiTexCoord4x(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMultiTexCoord4x(IIIII)V", true, this);
    }

    public void glNormal3f(float f, float f2, float f3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glNormal3f(FFF)V", true, this);
    }

    public void glNormal3x(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glNormal3x(III)V", true, this);
    }

    public void glNormalPointerBounds(int n, int n2, Buffer buffer, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glNormalPointerBounds(IILjava/nio/Buffer;I)V", true, this);
    }

    public void glNormalPointer(int type, int stride, Buffer pointer) {
        this.glNormalPointerBounds(type, stride, pointer, pointer.remaining());
        if ((type == 5126 || type == 5120 || type == 5122 || type == 5132) && stride >= 0) {
            this._normalPointer = pointer;
        }
    }

    public void glOrthof(float f, float f2, float f3, float f4, float f5, float f6) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glOrthof(FFFFFF)V", true, this);
    }

    public void glOrthox(int n, int n2, int n3, int n4, int n5, int n6) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glOrthox(IIIIII)V", true, this);
    }

    public void glPixelStorei(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPixelStorei(II)V", true, this);
    }

    public void glPointSize(float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPointSize(F)V", true, this);
    }

    public void glPointSizex(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPointSizex(I)V", true, this);
    }

    public void glPolygonOffset(float f, float f2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPolygonOffset(FF)V", true, this);
    }

    public void glPolygonOffsetx(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPolygonOffsetx(II)V", true, this);
    }

    public void glPopMatrix() {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPopMatrix()V", true, this);
    }

    public void glPushMatrix() {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPushMatrix()V", true, this);
    }

    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glReadPixels(IIIIIILjava/nio/Buffer;)V", true, this);
    }

    public void glRotatef(float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glRotatef(FFFF)V", true, this);
    }

    public void glRotatex(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glRotatex(IIII)V", true, this);
    }

    public void glSampleCoverage(float f, boolean bl) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glSampleCoverage(FZ)V", true, this);
    }

    public void glSampleCoveragex(int n, boolean bl) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glSampleCoveragex(IZ)V", true, this);
    }

    public void glScalef(float f, float f2, float f3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glScalef(FFF)V", true, this);
    }

    public void glScalex(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glScalex(III)V", true, this);
    }

    public void glScissor(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glScissor(IIII)V", true, this);
    }

    public void glShadeModel(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glShadeModel(I)V", true, this);
    }

    public void glStencilFunc(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glStencilFunc(III)V", true, this);
    }

    public void glStencilMask(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glStencilMask(I)V", true, this);
    }

    public void glStencilOp(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glStencilOp(III)V", true, this);
    }

    public void glTexCoordPointerBounds(int n, int n2, int n3, Buffer buffer, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexCoordPointerBounds(IIILjava/nio/Buffer;I)V", true, this);
    }

    public void glTexCoordPointer(int size, int type, int stride, Buffer pointer) {
        this.glTexCoordPointerBounds(size, type, stride, pointer, pointer.remaining());
        if (!(size != 2 && size != 3 && size != 4 || type != 5126 && type != 5120 && type != 5122 && type != 5132 || stride < 0)) {
            this._texCoordPointer = pointer;
        }
    }

    public void glTexEnvf(int n, int n2, float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexEnvf(IIF)V", true, this);
    }

    public void glTexEnvfv(int n, int n2, float[] fArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexEnvfv(II[FI)V", true, this);
    }

    public void glTexEnvfv(int n, int n2, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexEnvfv(IILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glTexEnvx(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexEnvx(III)V", true, this);
    }

    public void glTexEnvxv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexEnvxv(II[II)V", true, this);
    }

    public void glTexEnvxv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexEnvxv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexImage2D(IIIIIIIILjava/nio/Buffer;)V", true, this);
    }

    public void glTexParameterf(int n, int n2, float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexParameterf(IIF)V", true, this);
    }

    public void glTexParameterx(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexParameterx(III)V", true, this);
    }

    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexSubImage2D(IIIIIIIILjava/nio/Buffer;)V", true, this);
    }

    public void glTranslatef(float f, float f2, float f3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTranslatef(FFF)V", true, this);
    }

    public void glTranslatex(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTranslatex(III)V", true, this);
    }

    public void glVertexPointerBounds(int n, int n2, int n3, Buffer buffer, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glVertexPointerBounds(IIILjava/nio/Buffer;I)V", true, this);
    }

    public void glVertexPointer(int size, int type, int stride, Buffer pointer) {
        this.glVertexPointerBounds(size, type, stride, pointer, pointer.remaining());
        if (!(size != 2 && size != 3 && size != 4 || type != 5126 && type != 5120 && type != 5122 && type != 5132 || stride < 0)) {
            this._vertexPointer = pointer;
        }
    }

    public void glViewport(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glViewport(IIII)V", true, this);
    }

    public int glQueryMatrixxOES(int[] nArray, int n, int[] nArray2, int n2) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.GLImpl#glQueryMatrixxOES([II[II)I", true, this);
    }

    public int glQueryMatrixxOES(IntBuffer intBuffer, IntBuffer intBuffer2) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.GLImpl#glQueryMatrixxOES(Ljava/nio/IntBuffer;Ljava/nio/IntBuffer;)I", true, this);
    }

    public void glBindBuffer(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glBindBuffer(II)V", true, this);
    }

    public void glBufferData(int n, int n2, Buffer buffer, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glBufferData(IILjava/nio/Buffer;I)V", true, this);
    }

    public void glBufferSubData(int n, int n2, int n3, Buffer buffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glBufferSubData(IIILjava/nio/Buffer;)V", true, this);
    }

    public void glClipPlanef(int n, float[] fArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glClipPlanef(I[FI)V", true, this);
    }

    public void glClipPlanef(int n, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glClipPlanef(ILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glClipPlanex(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glClipPlanex(I[II)V", true, this);
    }

    public void glClipPlanex(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glClipPlanex(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glColor4ub(byte by, byte by2, byte by3, byte by4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glColor4ub(BBBB)V", true, this);
    }

    public void glColorPointer(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glColorPointer(IIII)V", true, this);
    }

    public void glDeleteBuffers(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDeleteBuffers(I[II)V", true, this);
    }

    public void glDeleteBuffers(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDeleteBuffers(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glDrawElements(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawElements(IIII)V", true, this);
    }

    public void glGenBuffers(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGenBuffers(I[II)V", true, this);
    }

    public void glGenBuffers(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGenBuffers(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetBooleanv(int n, boolean[] blArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetBooleanv(I[ZI)V", true, this);
    }

    public void glGetBooleanv(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetBooleanv(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetBufferParameteriv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetBufferParameteriv(II[II)V", true, this);
    }

    public void glGetBufferParameteriv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetBufferParameteriv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetClipPlanef(int n, float[] fArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetClipPlanef(I[FI)V", true, this);
    }

    public void glGetClipPlanef(int n, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetClipPlanef(ILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glGetClipPlanex(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetClipPlanex(I[II)V", true, this);
    }

    public void glGetClipPlanex(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetClipPlanex(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetFixedv(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetFixedv(I[II)V", true, this);
    }

    public void glGetFixedv(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetFixedv(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetFloatv(int n, float[] fArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetFloatv(I[FI)V", true, this);
    }

    public void glGetFloatv(int n, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetFloatv(ILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glGetLightfv(int n, int n2, float[] fArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetLightfv(II[FI)V", true, this);
    }

    public void glGetLightfv(int n, int n2, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetLightfv(IILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glGetLightxv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetLightxv(II[II)V", true, this);
    }

    public void glGetLightxv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetLightxv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetMaterialfv(int n, int n2, float[] fArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetMaterialfv(II[FI)V", true, this);
    }

    public void glGetMaterialfv(int n, int n2, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetMaterialfv(IILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glGetMaterialxv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetMaterialxv(II[II)V", true, this);
    }

    public void glGetMaterialxv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetMaterialxv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetTexEnviv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexEnviv(II[II)V", true, this);
    }

    public void glGetTexEnviv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexEnviv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetTexEnvxv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexEnvxv(II[II)V", true, this);
    }

    public void glGetTexEnvxv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexEnvxv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetTexParameterfv(int n, int n2, float[] fArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexParameterfv(II[FI)V", true, this);
    }

    public void glGetTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexParameterfv(IILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glGetTexParameteriv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexParameteriv(II[II)V", true, this);
    }

    public void glGetTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexParameteriv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetTexParameterxv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexParameterxv(II[II)V", true, this);
    }

    public void glGetTexParameterxv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexParameterxv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public boolean glIsBuffer(int n) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.GLImpl#glIsBuffer(I)Z", true, this) != 0;
    }

    public boolean glIsEnabled(int n) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.GLImpl#glIsEnabled(I)Z", true, this) != 0;
    }

    public boolean glIsTexture(int n) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.GLImpl#glIsTexture(I)Z", true, this) != 0;
    }

    public void glNormalPointer(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glNormalPointer(III)V", true, this);
    }

    public void glPointParameterf(int n, float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPointParameterf(IF)V", true, this);
    }

    public void glPointParameterfv(int n, float[] fArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPointParameterfv(I[FI)V", true, this);
    }

    public void glPointParameterfv(int n, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPointParameterfv(ILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glPointParameterx(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPointParameterx(II)V", true, this);
    }

    public void glPointParameterxv(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPointParameterxv(I[II)V", true, this);
    }

    public void glPointParameterxv(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPointParameterxv(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glPointSizePointerOESBounds(int n, int n2, Buffer buffer, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glPointSizePointerOESBounds(IILjava/nio/Buffer;I)V", true, this);
    }

    public void glPointSizePointerOES(int type, int stride, Buffer pointer) {
        this.glPointSizePointerOESBounds(type, stride, pointer, pointer.remaining());
        if ((type == 5126 || type == 5132) && stride >= 0) {
            this._pointSizePointerOES = pointer;
        }
    }

    public void glTexCoordPointer(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexCoordPointer(IIII)V", true, this);
    }

    public void glTexEnvi(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexEnvi(III)V", true, this);
    }

    public void glTexEnviv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexEnviv(II[II)V", true, this);
    }

    public void glTexEnviv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexEnviv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glTexParameterfv(int n, int n2, float[] fArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexParameterfv(II[FI)V", true, this);
    }

    public void glTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexParameterfv(IILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glTexParameteri(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexParameteri(III)V", true, this);
    }

    public void glTexParameteriv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexParameteriv(II[II)V", true, this);
    }

    public void glTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexParameteriv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glTexParameterxv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexParameterxv(II[II)V", true, this);
    }

    public void glTexParameterxv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexParameterxv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glVertexPointer(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glVertexPointer(IIII)V", true, this);
    }

    public void glCurrentPaletteMatrixOES(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glCurrentPaletteMatrixOES(I)V", true, this);
    }

    public void glDrawTexfOES(float f, float f2, float f3, float f4, float f5) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexfOES(FFFFF)V", true, this);
    }

    public void glDrawTexfvOES(float[] fArray, int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexfvOES([FI)V", true, this);
    }

    public void glDrawTexfvOES(FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexfvOES(Ljava/nio/FloatBuffer;)V", true, this);
    }

    public void glDrawTexiOES(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexiOES(IIIII)V", true, this);
    }

    public void glDrawTexivOES(int[] nArray, int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexivOES([II)V", true, this);
    }

    public void glDrawTexivOES(IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexivOES(Ljava/nio/IntBuffer;)V", true, this);
    }

    public void glDrawTexsOES(short s, short s2, short s3, short s4, short s5) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexsOES(SSSSS)V", true, this);
    }

    public void glDrawTexsvOES(short[] sArray, int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexsvOES([SI)V", true, this);
    }

    public void glDrawTexsvOES(ShortBuffer shortBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexsvOES(Ljava/nio/ShortBuffer;)V", true, this);
    }

    public void glDrawTexxOES(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexxOES(IIIII)V", true, this);
    }

    public void glDrawTexxvOES(int[] nArray, int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexxvOES([II)V", true, this);
    }

    public void glDrawTexxvOES(IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDrawTexxvOES(Ljava/nio/IntBuffer;)V", true, this);
    }

    public void glLoadPaletteFromModelViewMatrixOES() {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glLoadPaletteFromModelViewMatrixOES()V", true, this);
    }

    public void glMatrixIndexPointerOESBounds(int n, int n2, int n3, Buffer buffer, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMatrixIndexPointerOESBounds(IIILjava/nio/Buffer;I)V", true, this);
    }

    public void glMatrixIndexPointerOES(int size, int type, int stride, Buffer pointer) {
        this.glMatrixIndexPointerOESBounds(size, type, stride, pointer, pointer.remaining());
        if (!(size != 2 && size != 3 && size != 4 || type != 5126 && type != 5120 && type != 5122 && type != 5132 || stride < 0)) {
            this._matrixIndexPointerOES = pointer;
        }
    }

    public void glMatrixIndexPointerOES(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glMatrixIndexPointerOES(IIII)V", true, this);
    }

    public void glWeightPointerOESBounds(int n, int n2, int n3, Buffer buffer, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glWeightPointerOESBounds(IIILjava/nio/Buffer;I)V", true, this);
    }

    public void glWeightPointerOES(int size, int type, int stride, Buffer pointer) {
        this.glWeightPointerOESBounds(size, type, stride, pointer, pointer.remaining());
    }

    public void glWeightPointerOES(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glWeightPointerOES(IIII)V", true, this);
    }

    public void glBindFramebufferOES(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glBindFramebufferOES(II)V", true, this);
    }

    public void glBindRenderbufferOES(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glBindRenderbufferOES(II)V", true, this);
    }

    public void glBlendEquation(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glBlendEquation(I)V", true, this);
    }

    public void glBlendEquationSeparate(int n, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glBlendEquationSeparate(II)V", true, this);
    }

    public void glBlendFuncSeparate(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glBlendFuncSeparate(IIII)V", true, this);
    }

    public int glCheckFramebufferStatusOES(int n) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.GLImpl#glCheckFramebufferStatusOES(I)I", true, this);
    }

    public void glDeleteFramebuffersOES(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDeleteFramebuffersOES(I[II)V", true, this);
    }

    public void glDeleteFramebuffersOES(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDeleteFramebuffersOES(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glDeleteRenderbuffersOES(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDeleteRenderbuffersOES(I[II)V", true, this);
    }

    public void glDeleteRenderbuffersOES(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glDeleteRenderbuffersOES(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glFramebufferRenderbufferOES(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFramebufferRenderbufferOES(IIII)V", true, this);
    }

    public void glFramebufferTexture2DOES(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glFramebufferTexture2DOES(IIIII)V", true, this);
    }

    public void glGenerateMipmapOES(int n) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGenerateMipmapOES(I)V", true, this);
    }

    public void glGenFramebuffersOES(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGenFramebuffersOES(I[II)V", true, this);
    }

    public void glGenFramebuffersOES(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGenFramebuffersOES(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGenRenderbuffersOES(int n, int[] nArray, int n2) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGenRenderbuffersOES(I[II)V", true, this);
    }

    public void glGenRenderbuffersOES(int n, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGenRenderbuffersOES(ILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetFramebufferAttachmentParameterivOES(int n, int n2, int n3, int[] nArray, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetFramebufferAttachmentParameterivOES(III[II)V", true, this);
    }

    public void glGetFramebufferAttachmentParameterivOES(int n, int n2, int n3, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetFramebufferAttachmentParameterivOES(IIILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetRenderbufferParameterivOES(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetRenderbufferParameterivOES(II[II)V", true, this);
    }

    public void glGetRenderbufferParameterivOES(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetRenderbufferParameterivOES(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetTexGenfv(int n, int n2, float[] fArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexGenfv(II[FI)V", true, this);
    }

    public void glGetTexGenfv(int n, int n2, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexGenfv(IILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glGetTexGeniv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexGeniv(II[II)V", true, this);
    }

    public void glGetTexGeniv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexGeniv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glGetTexGenxv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexGenxv(II[II)V", true, this);
    }

    public void glGetTexGenxv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glGetTexGenxv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public boolean glIsFramebufferOES(int n) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.GLImpl#glIsFramebufferOES(I)Z", true, this) != 0;
    }

    public boolean glIsRenderbufferOES(int n) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.GLImpl#glIsRenderbufferOES(I)Z", true, this) != 0;
    }

    public void glRenderbufferStorageOES(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glRenderbufferStorageOES(IIII)V", true, this);
    }

    public void glTexGenf(int n, int n2, float f) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexGenf(IIF)V", true, this);
    }

    public void glTexGenfv(int n, int n2, float[] fArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexGenfv(II[FI)V", true, this);
    }

    public void glTexGenfv(int n, int n2, FloatBuffer floatBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexGenfv(IILjava/nio/FloatBuffer;)V", true, this);
    }

    public void glTexGeni(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexGeni(III)V", true, this);
    }

    public void glTexGeniv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexGeniv(II[II)V", true, this);
    }

    public void glTexGeniv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexGeniv(IILjava/nio/IntBuffer;)V", true, this);
    }

    public void glTexGenx(int n, int n2, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexGenx(III)V", true, this);
    }

    public void glTexGenxv(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexGenxv(II[II)V", true, this);
    }

    public void glTexGenxv(int n, int n2, IntBuffer intBuffer) {
        OverrideMethod.invokeV("com.google.android.gles_jni.GLImpl#glTexGenxv(IILjava/nio/IntBuffer;)V", true, this);
    }

    static {
        GLImpl._nativeClassInit();
    }
}

