/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import org.apache.harmony.luni.platform.IFileSystem;
import org.apache.harmony.luni.platform.INetworkSystem;

public class BlockGuard {
    public static final int DISALLOW_DISK_WRITE = 1;
    public static final int DISALLOW_DISK_READ = 2;
    public static final int DISALLOW_NETWORK = 4;
    public static final int PASS_RESTRICTIONS_VIA_RPC = 8;
    public static final int PENALTY_LOG = 16;
    public static final int PENALTY_DIALOG = 32;
    public static final int PENALTY_DEATH = 64;
    public static Policy LAX_POLICY = new Policy(){

        public void onWriteToDisk() {
        }

        public void onReadFromDisk() {
        }

        public void onNetwork() {
        }

        public int getPolicyMask() {
            return 0;
        }
    };
    public static ThreadLocal<Policy> threadPolicy = new ThreadLocal<Policy>(){

        @Override
        public Policy initialValue() {
            return LAX_POLICY;
        }
    };

    public static Policy getThreadPolicy() {
        return threadPolicy.get();
    }

    public static void setThreadPolicy(Policy policy) {
        if (policy == null) {
            throw new NullPointerException("policy == null");
        }
        threadPolicy.set(policy);
    }

    public static class WrappedNetworkSystem
    implements INetworkSystem {
        public final INetworkSystem mNetwork;

        public WrappedNetworkSystem(INetworkSystem network) {
            this.mNetwork = network;
        }

        public void accept(FileDescriptor serverFd, SocketImpl newSocket, FileDescriptor clientFd) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            this.mNetwork.accept(serverFd, newSocket, clientFd);
        }

        public void bind(FileDescriptor aFD, InetAddress inetAddress, int port) throws SocketException {
            this.mNetwork.bind(aFD, inetAddress, port);
        }

        public int read(FileDescriptor aFD, byte[] data, int offset, int count) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            return this.mNetwork.read(aFD, data, offset, count);
        }

        public int readDirect(FileDescriptor aFD, int address, int count) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            return this.mNetwork.readDirect(aFD, address, count);
        }

        public int write(FileDescriptor fd, byte[] data, int offset, int count) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            return this.mNetwork.write(fd, data, offset, count);
        }

        public int writeDirect(FileDescriptor fd, int address, int offset, int count) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            return this.mNetwork.writeDirect(fd, address, offset, count);
        }

        public boolean connectNonBlocking(FileDescriptor fd, InetAddress inetAddress, int port) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            return this.mNetwork.connectNonBlocking(fd, inetAddress, port);
        }

        public boolean isConnected(FileDescriptor fd, int timeout) throws IOException {
            if (timeout != 0) {
                BlockGuard.getThreadPolicy().onNetwork();
            }
            return this.mNetwork.isConnected(fd, timeout);
        }

        public int send(FileDescriptor fd, byte[] data, int offset, int length, int port, InetAddress inetAddress) throws IOException {
            return this.mNetwork.send(fd, data, offset, length, port, inetAddress);
        }

        public int sendDirect(FileDescriptor fd, int address, int offset, int length, int port, InetAddress inetAddress) throws IOException {
            return this.mNetwork.sendDirect(fd, address, offset, length, port, inetAddress);
        }

        public int recv(FileDescriptor fd, DatagramPacket packet, byte[] data, int offset, int length, boolean peek, boolean connected) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            return this.mNetwork.recv(fd, packet, data, offset, length, peek, connected);
        }

        public int recvDirect(FileDescriptor fd, DatagramPacket packet, int address, int offset, int length, boolean peek, boolean connected) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            return this.mNetwork.recvDirect(fd, packet, address, offset, length, peek, connected);
        }

        public void disconnectDatagram(FileDescriptor aFD) throws SocketException {
            this.mNetwork.disconnectDatagram(aFD);
        }

        public void socket(FileDescriptor aFD, boolean stream) throws SocketException {
            this.mNetwork.socket(aFD, stream);
        }

        public void shutdownInput(FileDescriptor descriptor) throws IOException {
            this.mNetwork.shutdownInput(descriptor);
        }

        public void shutdownOutput(FileDescriptor descriptor) throws IOException {
            this.mNetwork.shutdownOutput(descriptor);
        }

        public void sendUrgentData(FileDescriptor fd, byte value) {
            this.mNetwork.sendUrgentData(fd, value);
        }

        public void listen(FileDescriptor aFD, int backlog) throws SocketException {
            this.mNetwork.listen(aFD, backlog);
        }

        public void connect(FileDescriptor aFD, InetAddress inetAddress, int port, int timeout) throws SocketException {
            BlockGuard.getThreadPolicy().onNetwork();
            this.mNetwork.connect(aFD, inetAddress, port, timeout);
        }

        public InetAddress getSocketLocalAddress(FileDescriptor aFD) {
            return this.mNetwork.getSocketLocalAddress(aFD);
        }

        public boolean select(FileDescriptor[] readFDs, FileDescriptor[] writeFDs, int numReadable, int numWritable, long timeout, int[] flags) throws SocketException {
            BlockGuard.getThreadPolicy().onNetwork();
            return this.mNetwork.select(readFDs, writeFDs, numReadable, numWritable, timeout, flags);
        }

        public int getSocketLocalPort(FileDescriptor aFD) {
            return this.mNetwork.getSocketLocalPort(aFD);
        }

        public Object getSocketOption(FileDescriptor aFD, int opt) throws SocketException {
            return this.mNetwork.getSocketOption(aFD, opt);
        }

        public void setSocketOption(FileDescriptor aFD, int opt, Object optVal) throws SocketException {
            this.mNetwork.setSocketOption(aFD, opt, optVal);
        }

        public void close(FileDescriptor aFD) throws IOException {
            if (this.isLingerSocket(aFD)) {
                BlockGuard.getThreadPolicy().onNetwork();
            }
            this.mNetwork.close(aFD);
        }

        public void setInetAddress(InetAddress sender, byte[] address) {
            this.mNetwork.setInetAddress(sender, address);
        }

        public boolean isLingerSocket(FileDescriptor fd) throws SocketException {
            try {
                Object lingerValue = this.mNetwork.getSocketOption(fd, 128);
                if (lingerValue instanceof Boolean) {
                    return (Boolean)lingerValue;
                }
                if (lingerValue instanceof Integer) {
                    return (Integer)lingerValue != 0;
                }
                throw new AssertionError((Object)lingerValue.getClass().getName());
            }
            catch (Exception ignored) {
                return false;
            }
        }
    }

    public static class WrappedFileSystem
    implements IFileSystem {
        public final IFileSystem mFileSystem;

        public WrappedFileSystem(IFileSystem fileSystem) {
            this.mFileSystem = fileSystem;
        }

        public long read(int fileDescriptor, byte[] bytes, int offset, int length) throws IOException {
            BlockGuard.getThreadPolicy().onReadFromDisk();
            return this.mFileSystem.read(fileDescriptor, bytes, offset, length);
        }

        public long write(int fileDescriptor, byte[] bytes, int offset, int length) throws IOException {
            BlockGuard.getThreadPolicy().onWriteToDisk();
            return this.mFileSystem.write(fileDescriptor, bytes, offset, length);
        }

        public long readv(int fileDescriptor, int[] addresses, int[] offsets, int[] lengths, int size) throws IOException {
            BlockGuard.getThreadPolicy().onReadFromDisk();
            return this.mFileSystem.readv(fileDescriptor, addresses, offsets, lengths, size);
        }

        public long writev(int fileDescriptor, int[] addresses, int[] offsets, int[] lengths, int size) throws IOException {
            BlockGuard.getThreadPolicy().onWriteToDisk();
            return this.mFileSystem.writev(fileDescriptor, addresses, offsets, lengths, size);
        }

        public long readDirect(int fileDescriptor, int address, int offset, int length) throws IOException {
            BlockGuard.getThreadPolicy().onReadFromDisk();
            return this.mFileSystem.readDirect(fileDescriptor, address, offset, length);
        }

        public long writeDirect(int fileDescriptor, int address, int offset, int length) throws IOException {
            BlockGuard.getThreadPolicy().onWriteToDisk();
            return this.mFileSystem.writeDirect(fileDescriptor, address, offset, length);
        }

        public boolean lock(int fileDescriptor, long start, long length, int type, boolean waitFlag) throws IOException {
            return this.mFileSystem.lock(fileDescriptor, start, length, type, waitFlag);
        }

        public void unlock(int fileDescriptor, long start, long length) throws IOException {
            this.mFileSystem.unlock(fileDescriptor, start, length);
        }

        public long seek(int fileDescriptor, long offset, int whence) throws IOException {
            return this.mFileSystem.seek(fileDescriptor, offset, whence);
        }

        public void fsync(int fileDescriptor, boolean metadata) throws IOException {
            BlockGuard.getThreadPolicy().onWriteToDisk();
            this.mFileSystem.fsync(fileDescriptor, metadata);
        }

        public void truncate(int fileDescriptor, long size) throws IOException {
            BlockGuard.getThreadPolicy().onWriteToDisk();
            this.mFileSystem.truncate(fileDescriptor, size);
        }

        public int getAllocGranularity() {
            return this.mFileSystem.getAllocGranularity();
        }

        public int open(String path, int mode) throws FileNotFoundException {
            BlockGuard.getThreadPolicy().onReadFromDisk();
            if (mode != 0) {
                BlockGuard.getThreadPolicy().onWriteToDisk();
            }
            return this.mFileSystem.open(path, mode);
        }

        public long transfer(int fileHandler, FileDescriptor socketDescriptor, long offset, long count) throws IOException {
            return this.mFileSystem.transfer(fileHandler, socketDescriptor, offset, count);
        }

        public int ioctlAvailable(FileDescriptor fileDescriptor) throws IOException {
            return this.mFileSystem.ioctlAvailable(fileDescriptor);
        }

        public long length(int fd) {
            return this.mFileSystem.length(fd);
        }
    }

    public static class BlockGuardPolicyException
    extends RuntimeException {
        public final int mPolicyState;
        public final int mPolicyViolated;
        public final String mMessage;

        public BlockGuardPolicyException(int policyState, int policyViolated) {
            this(policyState, policyViolated, null);
        }

        public BlockGuardPolicyException(int policyState, int policyViolated, String message) {
            this.mPolicyState = policyState;
            this.mPolicyViolated = policyViolated;
            this.mMessage = message;
            this.fillInStackTrace();
        }

        public int getPolicy() {
            return this.mPolicyState;
        }

        public int getPolicyViolation() {
            return this.mPolicyViolated;
        }

        public String getMessage() {
            return "policy=" + this.mPolicyState + " violation=" + this.mPolicyViolated + (this.mMessage == null ? "" : " msg=" + this.mMessage);
        }
    }

    public static interface Policy {
        public void onWriteToDisk();

        public void onReadFromDisk();

        public void onNetwork();

        public int getPolicyMask();
    }
}

