/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import libcore.io.IoUtils;
import libcore.util.Objects;

public class SamplingProfiler {
    public final Map<HprofData.StackTrace, int[]> stackTraces = new HashMap<HprofData.StackTrace, int[]>();
    public final HprofData hprofData = new HprofData(this.stackTraces);
    public final Timer timer = new Timer("SamplingProfiler", true);
    public TimerTask sampler;
    public final int depth;
    public final ThreadSet threadSet;
    public int nextThreadId = 200001;
    public int nextStackTraceId = 300001;
    public int nextObjectId = 1;
    public Thread[] currentThreads = new Thread[0];
    public final Map<Thread, Integer> threadIds = new HashMap<Thread, Integer>();
    public final HprofData.StackTrace mutableStackTrace = new HprofData.StackTrace(null);

    public SamplingProfiler(int depth, ThreadSet threadSet) {
        this.depth = depth;
        this.threadSet = threadSet;
        this.hprofData.setFlags(BinaryHprof.ControlSettings.CPU_SAMPLING.bitmask);
        this.hprofData.setDepth(depth);
    }

    public static ThreadSet newArrayThreadSet(Thread ... threads) {
        return new ArrayThreadSet(threads);
    }

    public static ThreadSet newThreadGroupTheadSet(ThreadGroup threadGroup) {
        return new ThreadGroupThreadSet(threadGroup);
    }

    public void start(int interval) {
        if (interval < 1) {
            throw new IllegalArgumentException("interval < 1");
        }
        if (this.sampler != null) {
            throw new IllegalStateException("profiling already started");
        }
        this.sampler = new Sampler(null);
        this.hprofData.setStartMillis(System.currentTimeMillis());
        this.timer.scheduleAtFixedRate(this.sampler, 0L, (long)interval);
    }

    public void stop() {
        if (this.sampler == null) {
            return;
        }
        this.sampler.cancel();
        this.sampler = null;
    }

    public void shutdown() {
        this.stop();
        this.timer.cancel();
    }

    public HprofData getHprofData() {
        if (this.sampler != null) {
            throw new IllegalStateException("cannot access hprof data while sampling");
        }
        return this.hprofData;
    }

    public static /* synthetic */ Thread[] access$702(SamplingProfiler x0, Thread[] x1) {
        x0.currentThreads = x1;
        return x1;
    }

    public class Sampler
    extends TimerTask {
        public Thread timerThread;

        public Sampler() {
        }

        public void run() {
            if (this.timerThread == null) {
                this.timerThread = Thread.currentThread();
            }
            Object[] newThreads = SamplingProfiler.this.threadSet.threads();
            if (!Arrays.equals(SamplingProfiler.this.currentThreads, newThreads)) {
                this.updateThreadHistory(SamplingProfiler.this.currentThreads, (Thread[])newThreads);
                SamplingProfiler.access$702(SamplingProfiler.this, (Thread[])newThreads.clone());
            }
            for (Thread thread : SamplingProfiler.this.currentThreads) {
                StackTraceElement[] stackFrames;
                if (thread == null) break;
                if (thread == this.timerThread || (stackFrames = thread.getStackTrace()).length == 0) continue;
                if (stackFrames.length > SamplingProfiler.this.depth) {
                    stackFrames = Arrays.copyOfRange(stackFrames, 0, SamplingProfiler.this.depth);
                }
                this.recordStackTrace(thread, stackFrames);
            }
        }

        public void recordStackTrace(Thread thread, StackTraceElement[] stackFrames) {
            Integer threadId = (Integer)SamplingProfiler.this.threadIds.get(thread);
            if (threadId == null) {
                throw new IllegalArgumentException("Unknown thread " + thread);
            }
            SamplingProfiler.this.mutableStackTrace.threadId = threadId;
            HprofData.StackTrace.access$202(SamplingProfiler.this.mutableStackTrace, stackFrames);
            int[] countCell = (int[])SamplingProfiler.this.stackTraces.get(SamplingProfiler.this.mutableStackTrace);
            if (countCell == null) {
                countCell = new int[1];
                HprofData.StackTrace stackTrace = new HprofData.StackTrace(SamplingProfiler.this.nextStackTraceId++, threadId, stackFrames);
                SamplingProfiler.this.hprofData.addStackTrace(stackTrace, countCell);
            }
            countCell[0] = countCell[0] + 1;
        }

        public void updateThreadHistory(Thread[] oldThreads, Thread[] newThreads) {
            HashSet<Thread> n = new HashSet<Thread>(Arrays.asList(newThreads));
            HashSet<Thread> o = new HashSet<Thread>(Arrays.asList(oldThreads));
            HashSet<Thread> added = new HashSet<Thread>(n);
            added.removeAll(o);
            HashSet<Thread> removed = new HashSet<Thread>(o);
            removed.removeAll(n);
            for (Thread thread : added) {
                if (thread == null || thread == this.timerThread) continue;
                this.addStartThread(thread);
            }
            for (Thread thread : removed) {
                if (thread == null || thread == this.timerThread) continue;
                this.addEndThread(thread);
            }
        }

        public void addStartThread(Thread thread) {
            if (thread == null) {
                throw new NullPointerException("thread == null");
            }
            int threadId = SamplingProfiler.this.nextThreadId++;
            Integer old = SamplingProfiler.this.threadIds.put(thread, threadId);
            if (old != null) {
                throw new IllegalArgumentException("Thread already registered as " + old);
            }
            String threadName = thread.getName();
            ThreadGroup group = thread.getThreadGroup();
            String groupName = group == null ? null : group.getName();
            ThreadGroup parentGroup = group == null ? null : group.getParent();
            String parentGroupName = parentGroup == null ? null : parentGroup.getName();
            HprofData.ThreadEvent event = HprofData.ThreadEvent.start(SamplingProfiler.this.nextObjectId++, threadId, threadName, groupName, parentGroupName);
            SamplingProfiler.this.hprofData.addThreadEvent(event);
        }

        public void addEndThread(Thread thread) {
            if (thread == null) {
                throw new NullPointerException("thread == null");
            }
            Integer threadId = (Integer)SamplingProfiler.this.threadIds.remove(thread);
            if (threadId == null) {
                throw new IllegalArgumentException("Unknown thread " + thread);
            }
            HprofData.ThreadEvent event = HprofData.ThreadEvent.end(threadId);
            SamplingProfiler.this.hprofData.addThreadEvent(event);
        }

        public /* synthetic */ Sampler(1 x1) {
            this();
        }
    }

    public static class ThreadGroupThreadSet
    implements ThreadSet {
        public final ThreadGroup threadGroup;
        public Thread[] threads;
        public int lastThread;

        public ThreadGroupThreadSet(ThreadGroup threadGroup) {
            if (threadGroup == null) {
                throw new NullPointerException("threadGroup == null");
            }
            this.threadGroup = threadGroup;
            this.resize();
        }

        public void resize() {
            int count = this.threadGroup.activeCount();
            this.threads = new Thread[count * 2];
            this.lastThread = 0;
        }

        public Thread[] threads() {
            int threadCount;
            while ((threadCount = this.threadGroup.enumerate(this.threads)) == this.threads.length) {
                this.resize();
            }
            if (threadCount < this.lastThread) {
                Arrays.fill(this.threads, threadCount, this.lastThread, null);
            }
            this.lastThread = threadCount;
            return this.threads;
        }
    }

    public static class ArrayThreadSet
    implements ThreadSet {
        public final Thread[] threads;

        public ArrayThreadSet(Thread ... threads) {
            if (threads == null) {
                throw new NullPointerException("threads == null");
            }
            this.threads = threads;
        }

        public Thread[] threads() {
            return this.threads;
        }
    }

    public static interface ThreadSet {
        public Thread[] threads();
    }

    public static class HprofBinaryToAscii {
        public static void main(String[] args) {
            System.exit(HprofBinaryToAscii.convert(args) ? 0 : 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean convert(String[] args) {
            HprofData hprofData;
            if (args.length != 1) {
                HprofBinaryToAscii.usage("binary hprof file argument expected");
                return false;
            }
            File file = new File(args[0]);
            if (!file.exists()) {
                HprofBinaryToAscii.usage("file " + file + " does not exist");
                return false;
            }
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                BinaryHprofReader reader = new BinaryHprofReader(inputStream);
                reader.setStrict(false);
                reader.read();
                hprofData = reader.getHprofData();
            }
            catch (IOException e) {
                boolean bl;
                try {
                    System.out.println("Problem reading binary hprof data from " + file + ": " + e.getMessage());
                    bl = false;
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IoUtils.closeQuietly(inputStream);
                return bl;
            }
            IoUtils.closeQuietly(inputStream);
            try {
                AsciiHprofWriter writer = new AsciiHprofWriter(hprofData, System.out);
                writer.write();
            }
            catch (IOException e) {
                System.out.println("Problem writing ASCII hprof data: " + e.getMessage());
                return false;
            }
            return true;
        }

        public static void usage(String error) {
            System.out.print("ERROR: ");
            System.out.println(error);
            System.out.println();
            System.out.println("usage: HprofBinaryToAscii <binary-hprof-file>");
            System.out.println();
            System.out.println("Reads a binary hprof file and print it in ASCII format");
        }
    }

    public static class MalformedHprofException
    extends IOException {
        public MalformedHprofException(String message) {
            super(message);
        }

        public MalformedHprofException(String message, Throwable cause) {
            super(message, cause);
        }

        public MalformedHprofException(Throwable cause) {
            super(cause);
        }

        public /* synthetic */ MalformedHprofException(String x0, 1 x1) {
            this(x0);
        }
    }

    public static class BinaryHprofReader {
        public static final boolean TRACE = false;
        public final DataInputStream in;
        public boolean strict = true;
        public String version;
        public final Map<HprofData.StackTrace, int[]> stackTraces = new HashMap<HprofData.StackTrace, int[]>();
        public final HprofData hprofData = new HprofData(this.stackTraces);
        public final Map<Integer, String> idToString = new HashMap<Integer, String>();
        public final Map<Integer, String> idToClassName = new HashMap<Integer, String>();
        public final Map<Integer, StackTraceElement> idToStackFrame = new HashMap<Integer, StackTraceElement>();
        public final Map<Integer, HprofData.StackTrace> idToStackTrace = new HashMap<Integer, HprofData.StackTrace>();

        public BinaryHprofReader(InputStream inputStream) throws IOException {
            this.in = new DataInputStream(inputStream);
        }

        public boolean getStrict() {
            return this.strict;
        }

        public void setStrict(boolean strict) {
            if (this.version != null) {
                throw new IllegalStateException("cannot set strict after read()");
            }
            this.strict = strict;
        }

        public void checkRead() {
            if (this.version == null) {
                throw new IllegalStateException("data access before read()");
            }
        }

        public String getVersion() {
            this.checkRead();
            return this.version;
        }

        public HprofData getHprofData() {
            this.checkRead();
            return this.hprofData;
        }

        public void read() throws IOException {
            this.parseHeader();
            this.parseRecords();
        }

        public void parseHeader() throws IOException {
            this.parseVersion();
            this.parseIdSize();
            this.parseTime();
        }

        public void parseVersion() throws IOException {
            byte[] bytes = new byte[512];
            for (int i = 0; i < bytes.length; ++i) {
                byte b = this.in.readByte();
                if (b == 0) {
                    String version = new String(bytes, 0, i, "UTF-8");
                    if (!version.startsWith("JAVA PROFILE ")) {
                        throw new MalformedHprofException("Unexpected version: " + version, null);
                    }
                    this.version = version;
                    return;
                }
                bytes[i] = b;
            }
            throw new MalformedHprofException("Could not find HPROF version", null);
        }

        public void parseIdSize() throws IOException {
            int idSize = this.in.readInt();
            if (idSize != 4) {
                throw new MalformedHprofException("Unsupported identifier size: " + idSize, null);
            }
        }

        public void parseTime() throws IOException {
            long time = this.in.readLong();
            this.hprofData.setStartMillis(time);
        }

        public void parseRecords() throws IOException {
            while (this.parseRecord()) {
            }
        }

        public boolean parseRecord() throws IOException {
            int tagOrEOF = this.in.read();
            if (tagOrEOF == -1) {
                return false;
            }
            byte tag = (byte)tagOrEOF;
            int timeDeltaInMicroseconds = this.in.readInt();
            int recordLength = this.in.readInt();
            BinaryHprof.Tag hprofTag = BinaryHprof.Tag.get(tag);
            if (hprofTag == null) {
                this.skipRecord(hprofTag, recordLength);
                return true;
            }
            String error = hprofTag.checkSize(recordLength);
            if (error != null) {
                throw new MalformedHprofException(error, null);
            }
            switch (hprofTag) {
                case CONTROL_SETTINGS: {
                    this.parseControlSettings();
                    return true;
                }
                case STRING_IN_UTF8: {
                    this.parseStringInUtf8(recordLength);
                    return true;
                }
                case START_THREAD: {
                    this.parseStartThread();
                    return true;
                }
                case END_THREAD: {
                    this.parseEndThread();
                    return true;
                }
                case LOAD_CLASS: {
                    this.parseLoadClass();
                    return true;
                }
                case STACK_FRAME: {
                    this.parseStackFrame();
                    return true;
                }
                case STACK_TRACE: {
                    this.parseStackTrace(recordLength);
                    return true;
                }
                case CPU_SAMPLES: {
                    this.parseCpuSamples(recordLength);
                    return true;
                }
            }
            this.skipRecord(hprofTag, recordLength);
            return true;
        }

        public void skipRecord(BinaryHprof.Tag hprofTag, long recordLength) throws IOException {
            long skipped = this.in.skip(recordLength);
            if (skipped != recordLength) {
                throw new EOFException("Expected to skip " + recordLength + " bytes but only skipped " + skipped + " bytes");
            }
        }

        public void parseControlSettings() throws IOException {
            int flags = this.in.readInt();
            short depth = this.in.readShort();
            this.hprofData.setFlags(flags);
            this.hprofData.setDepth(depth);
        }

        public void parseStringInUtf8(int recordLength) throws IOException {
            int stringId = this.in.readInt();
            byte[] bytes = new byte[recordLength - 4];
            this.in.read(bytes);
            String string2 = new String(bytes, "UTF-8");
            String old = this.idToString.put(stringId, string2);
            if (old != null) {
                throw new MalformedHprofException("Duplicate string id: " + stringId, null);
            }
        }

        public void parseLoadClass() throws IOException {
            int classId = this.in.readInt();
            int classObjectId = this.readId();
            int stackTraceSerialNumber = this.in.readInt();
            String className = this.readString();
            String old = this.idToClassName.put(classId, className);
            if (old != null) {
                throw new MalformedHprofException("Duplicate class id: " + classId, null);
            }
        }

        public int readId() throws IOException {
            return this.in.readInt();
        }

        public String readString() throws IOException {
            int id2 = this.readId();
            if (id2 == 0) {
                return null;
            }
            String string2 = this.idToString.get(id2);
            if (string2 == null) {
                throw new MalformedHprofException("Unknown string id " + id2, null);
            }
            return string2;
        }

        public String readClass() throws IOException {
            int id2 = this.readId();
            String string2 = this.idToClassName.get(id2);
            if (string2 == null) {
                throw new MalformedHprofException("Unknown class id " + id2, null);
            }
            return string2;
        }

        public void parseStartThread() throws IOException {
            int threadId = this.in.readInt();
            int objectId = this.readId();
            int stackTraceSerialNumber = this.in.readInt();
            String threadName = this.readString();
            String groupName = this.readString();
            String parentGroupName = this.readString();
            HprofData.ThreadEvent event = HprofData.ThreadEvent.start(objectId, threadId, threadName, groupName, parentGroupName);
            this.hprofData.addThreadEvent(event);
        }

        public void parseEndThread() throws IOException {
            int threadId = this.in.readInt();
            HprofData.ThreadEvent event = HprofData.ThreadEvent.end(threadId);
            this.hprofData.addThreadEvent(event);
        }

        public void parseStackFrame() throws IOException {
            int stackFrameId = this.readId();
            String methodName = this.readString();
            String methodSignature = this.readString();
            String file = this.readString();
            String className = this.readClass();
            int line = this.in.readInt();
            StackTraceElement stackFrame = new StackTraceElement(className, methodName, file, line);
            StackTraceElement old = this.idToStackFrame.put(stackFrameId, stackFrame);
            if (old != null) {
                throw new MalformedHprofException("Duplicate stack frame id: " + stackFrameId, null);
            }
        }

        public void parseStackTrace(int recordLength) throws IOException {
            int stackTraceId = this.in.readInt();
            int threadId = this.in.readInt();
            int frames = this.in.readInt();
            int expectedLength = 12 + frames * 4;
            if (recordLength != expectedLength) {
                throw new MalformedHprofException("Expected stack trace record of size " + expectedLength + " based on number of frames but header " + "specified a length of  " + recordLength, null);
            }
            StackTraceElement[] stackFrames = new StackTraceElement[frames];
            for (int i = 0; i < frames; ++i) {
                int stackFrameId = this.readId();
                StackTraceElement stackFrame = this.idToStackFrame.get(stackFrameId);
                if (stackFrame == null) {
                    throw new MalformedHprofException("Unknown stack frame id " + stackFrameId, null);
                }
                stackFrames[i] = stackFrame;
            }
            HprofData.StackTrace stackTrace = new HprofData.StackTrace(stackTraceId, threadId, stackFrames);
            if (this.strict) {
                this.hprofData.addStackTrace(stackTrace, new int[1]);
            } else {
                int[] countCell = this.stackTraces.get(stackTrace);
                if (countCell == null) {
                    this.hprofData.addStackTrace(stackTrace, new int[1]);
                }
            }
            HprofData.StackTrace old = this.idToStackTrace.put(stackTraceId, stackTrace);
            if (old != null) {
                throw new MalformedHprofException("Duplicate stack trace id: " + stackTraceId, null);
            }
        }

        public void parseCpuSamples(int recordLength) throws IOException {
            int totalSamples = this.in.readInt();
            int samplesCount = this.in.readInt();
            int expectedLength = 8 + samplesCount * 8;
            if (recordLength != expectedLength) {
                throw new MalformedHprofException("Expected CPU samples record of size " + expectedLength + " based on number of samples but header " + "specified a length of  " + recordLength, null);
            }
            int total = 0;
            for (int i = 0; i < samplesCount; ++i) {
                int count = this.in.readInt();
                int stackTraceId = this.in.readInt();
                HprofData.StackTrace stackTrace = this.idToStackTrace.get(stackTraceId);
                if (stackTrace == null) {
                    throw new MalformedHprofException("Unknown stack trace id " + stackTraceId, null);
                }
                if (count == 0) {
                    throw new MalformedHprofException("Zero sample count for stack trace " + stackTrace, null);
                }
                int[] countCell = this.stackTraces.get(stackTrace);
                if (this.strict) {
                    if (countCell[0] != 0) {
                        throw new MalformedHprofException("Setting sample count of stack trace " + stackTrace + " to " + count + " found it was already initialized to " + countCell[0], null);
                    }
                } else {
                    count += countCell[0];
                }
                countCell[0] = count;
                total += count;
            }
            if (this.strict && totalSamples != total) {
                throw new MalformedHprofException("Expected a total of " + totalSamples + " samples but saw " + total, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BinaryHprofWriter
    implements HprofWriter {
        public int nextStringId = 1;
        public int nextClassId = 1;
        public int nextStackFrameId = 1;
        public final Map<String, Integer> stringToId = new HashMap<String, Integer>();
        public final Map<String, Integer> classNameToId = new HashMap<String, Integer>();
        public final Map<StackTraceElement, Integer> stackFrameToId = new HashMap<StackTraceElement, Integer>();
        public final HprofData data;
        public final DataOutputStream out;

        public BinaryHprofWriter(HprofData data, OutputStream outputStream) {
            this.data = data;
            this.out = new DataOutputStream(outputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write() throws IOException {
            try {
                this.writeHeader(this.data.getStartMillis());
                this.writeControlSettings(this.data.getFlags(), this.data.getDepth());
                for (HprofData.ThreadEvent event : this.data.getThreadHistory()) {
                    this.writeThreadEvent(event);
                }
                Set<HprofData.Sample> samples = this.data.getSamples();
                int total = 0;
                for (HprofData.Sample sample : samples) {
                    total += sample.count;
                    this.writeStackTrace(sample.stackTrace);
                }
                this.writeCpuSamples(total, samples);
            }
            finally {
                this.out.flush();
            }
        }

        public void writeHeader(long dumpTimeInMilliseconds) throws IOException {
            this.out.writeBytes("JAVA PROFILE 1.0.2");
            this.out.writeByte(0);
            this.out.writeInt(4);
            this.out.writeLong(dumpTimeInMilliseconds);
        }

        public void writeControlSettings(int flags, int depth) throws IOException {
            if (depth > Short.MAX_VALUE) {
                throw new IllegalArgumentException("depth too large for binary hprof: " + depth + " > " + Short.MAX_VALUE);
            }
            this.writeRecordHeader(BinaryHprof.Tag.CONTROL_SETTINGS, 0, BinaryHprof.Tag.CONTROL_SETTINGS.maximumSize);
            this.out.writeInt(flags);
            this.out.writeShort((short)depth);
        }

        public void writeThreadEvent(HprofData.ThreadEvent e) throws IOException {
            switch (e.type) {
                case START: {
                    this.writeStartThread(e);
                    return;
                }
                case END: {
                    this.writeStopThread(e);
                    return;
                }
            }
            throw new IllegalStateException(e.type.toString());
        }

        public void writeStartThread(HprofData.ThreadEvent e) throws IOException {
            int threadNameId = this.writeString(e.threadName);
            int groupNameId = this.writeString(e.groupName);
            int parentGroupNameId = this.writeString(e.parentGroupName);
            this.writeRecordHeader(BinaryHprof.Tag.START_THREAD, 0, BinaryHprof.Tag.START_THREAD.maximumSize);
            this.out.writeInt(e.threadId);
            this.writeId(e.objectId);
            this.out.writeInt(0);
            this.writeId(threadNameId);
            this.writeId(groupNameId);
            this.writeId(parentGroupNameId);
        }

        public void writeStopThread(HprofData.ThreadEvent e) throws IOException {
            this.writeRecordHeader(BinaryHprof.Tag.END_THREAD, 0, BinaryHprof.Tag.END_THREAD.maximumSize);
            this.out.writeInt(e.threadId);
        }

        public void writeRecordHeader(BinaryHprof.Tag hprofTag, int timeDeltaInMicroseconds, int recordLength) throws IOException {
            String error = hprofTag.checkSize(recordLength);
            if (error != null) {
                throw new AssertionError((Object)error);
            }
            this.out.writeByte(hprofTag.tag);
            this.out.writeInt(timeDeltaInMicroseconds);
            this.out.writeInt(recordLength);
        }

        public void writeId(int id2) throws IOException {
            this.out.writeInt(id2);
        }

        public int writeString(String string2) throws IOException {
            if (string2 == null) {
                return 0;
            }
            Integer identifier = this.stringToId.get(string2);
            if (identifier != null) {
                return identifier;
            }
            int id2 = this.nextStringId++;
            this.stringToId.put(string2, id2);
            byte[] bytes = string2.getBytes("UTF-8");
            this.writeRecordHeader(BinaryHprof.Tag.STRING_IN_UTF8, 0, 4 + bytes.length);
            this.out.writeInt(id2);
            this.out.write(bytes, 0, bytes.length);
            return id2;
        }

        public void writeCpuSamples(int totalSamples, Set<HprofData.Sample> samples) throws IOException {
            int samplesCount = samples.size();
            if (samplesCount == 0) {
                return;
            }
            this.writeRecordHeader(BinaryHprof.Tag.CPU_SAMPLES, 0, 8 + samplesCount * 8);
            this.out.writeInt(totalSamples);
            this.out.writeInt(samplesCount);
            for (HprofData.Sample sample : samples) {
                this.out.writeInt(sample.count);
                this.out.writeInt(sample.stackTrace.stackTraceId);
            }
        }

        public void writeStackTrace(HprofData.StackTrace stackTrace) throws IOException {
            int frames = stackTrace.stackFrames.length;
            int[] stackFrameIds = new int[frames];
            for (int i = 0; i < frames; ++i) {
                stackFrameIds[i] = this.writeStackFrame(stackTrace.stackFrames[i]);
            }
            this.writeRecordHeader(BinaryHprof.Tag.STACK_TRACE, 0, 12 + frames * 4);
            this.out.writeInt(stackTrace.stackTraceId);
            this.out.writeInt(stackTrace.threadId);
            this.out.writeInt(frames);
            for (int stackFrameId : stackFrameIds) {
                this.writeId(stackFrameId);
            }
        }

        public int writeLoadClass(String className) throws IOException {
            Integer identifier = this.classNameToId.get(className);
            if (identifier != null) {
                return identifier;
            }
            int id2 = this.nextClassId++;
            this.classNameToId.put(className, id2);
            int classNameId = this.writeString(className);
            this.writeRecordHeader(BinaryHprof.Tag.LOAD_CLASS, 0, BinaryHprof.Tag.LOAD_CLASS.maximumSize);
            this.out.writeInt(id2);
            this.writeId(0);
            this.out.writeInt(0);
            this.writeId(classNameId);
            return id2;
        }

        public int writeStackFrame(StackTraceElement stackFrame) throws IOException {
            Integer identifier = this.stackFrameToId.get(stackFrame);
            if (identifier != null) {
                return identifier;
            }
            int id2 = this.nextStackFrameId++;
            this.stackFrameToId.put(stackFrame, id2);
            int classId = this.writeLoadClass(stackFrame.getClassName());
            int methodNameId = this.writeString(stackFrame.getMethodName());
            int sourceId = this.writeString(stackFrame.getFileName());
            this.writeRecordHeader(BinaryHprof.Tag.STACK_FRAME, 0, BinaryHprof.Tag.STACK_FRAME.maximumSize);
            this.writeId(id2);
            this.writeId(methodNameId);
            this.writeId(0);
            this.writeId(sourceId);
            this.out.writeInt(classId);
            this.out.writeInt(stackFrame.getLineNumber());
            return id2;
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    public static class BinaryHprof {
        public static final int ID_SIZE = 4;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ControlSettings {
            ALLOC_TRACES(1),
            CPU_SAMPLING(2);

            public final int bitmask;

            public ControlSettings(int bitmask) {
                this.bitmask = bitmask;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Tag {
            STRING_IN_UTF8(1, -4),
            LOAD_CLASS(2, 16),
            UNLOAD_CLASS(3, 4),
            STACK_FRAME(4, 24),
            STACK_TRACE(5, -12),
            ALLOC_SITES(6, -34),
            HEAP_SUMMARY(7, 24),
            START_THREAD(10, 24),
            END_THREAD(11, 4),
            HEAP_DUMP(12, 0),
            HEAP_DUMP_SEGMENT(28, 0),
            HEAP_DUMP_END(44, 0),
            CPU_SAMPLES(13, -8),
            CONTROL_SETTINGS(14, 6);

            public final byte tag;
            public final int minimumSize;
            public final int maximumSize;
            public static final Map<Byte, Tag> BYTE_TO_TAG;

            public Tag(int tag, int size) {
                this.tag = (byte)tag;
                if (size > 0) {
                    this.minimumSize = size;
                    this.maximumSize = size;
                } else {
                    this.minimumSize = -size;
                    this.maximumSize = 0;
                }
            }

            public static Tag get(byte tag) {
                return BYTE_TO_TAG.get(tag);
            }

            public String checkSize(int actual) {
                if (actual < this.minimumSize) {
                    return "expected a minimial record size of " + this.minimumSize + " for " + (Object)((Object)this) + " but received " + actual;
                }
                if (this.maximumSize == 0) {
                    return null;
                }
                if (actual > this.maximumSize) {
                    return "expected a maximum record size of " + this.maximumSize + " for " + (Object)((Object)this) + " but received " + actual;
                }
                return null;
            }

            static {
                BYTE_TO_TAG = new HashMap<Byte, Tag>();
                for (Tag v : Tag.values()) {
                    BYTE_TO_TAG.put(v.tag, v);
                }
            }
        }
    }

    public static class AsciiHprofWriter
    implements HprofWriter {
        public final HprofData data;
        public final PrintWriter out;
        public static final Comparator<HprofData.Sample> SAMPLE_COMPARATOR = new Comparator<HprofData.Sample>(){

            @Override
            public int compare(HprofData.Sample s1, HprofData.Sample s2) {
                return s2.count - s1.count;
            }
        };

        public AsciiHprofWriter(HprofData data, OutputStream outputStream) {
            this.data = data;
            this.out = new PrintWriter(outputStream);
        }

        public void write() throws IOException {
            for (HprofData.ThreadEvent e : this.data.getThreadHistory()) {
                this.out.println(e);
            }
            ArrayList<HprofData.Sample> samples = new ArrayList<HprofData.Sample>(this.data.getSamples());
            Collections.sort(samples, SAMPLE_COMPARATOR);
            int total = 0;
            for (HprofData.Sample sample : samples) {
                HprofData.StackTrace stackTrace = sample.stackTrace;
                int count = sample.count;
                total += count;
                this.out.printf("TRACE %d: (thread=%d)\n", stackTrace.stackTraceId, stackTrace.threadId);
                for (StackTraceElement e : stackTrace.stackFrames) {
                    this.out.printf("\t%s\n", e);
                }
            }
            Date now = new Date(this.data.getStartMillis());
            this.out.printf("CPU SAMPLES BEGIN (total = %d) %ta %tb %td %tT %tY\n", total, now, now, now, now, now);
            this.out.printf("rank   self  accum   count trace method\n", new Object[0]);
            int rank = 0;
            double accum = 0.0;
            for (HprofData.Sample sample : samples) {
                HprofData.StackTrace stackTrace = sample.stackTrace;
                int count = sample.count;
                double self = (double)count / (double)total;
                this.out.printf("% 4d% 6.2f%%% 6.2f%% % 7d % 5d %s.%s\n", ++rank, self * 100.0, (accum += self) * 100.0, count, stackTrace.stackTraceId, stackTrace.stackFrames[0].getClassName(), stackTrace.stackFrames[0].getMethodName());
            }
            this.out.printf("CPU SAMPLES END\n", new Object[0]);
            this.out.flush();
        }
    }

    public static interface HprofWriter {
        public void write() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HprofData {
        public long startMillis;
        public int flags;
        public int depth;
        public final List<ThreadEvent> threadHistory = new ArrayList<ThreadEvent>();
        public final Map<Integer, ThreadEvent> threadIdToThreadEvent = new HashMap<Integer, ThreadEvent>();
        public final Map<StackTrace, int[]> stackTraces;

        public HprofData(Map<StackTrace, int[]> stackTraces) {
            if (stackTraces == null) {
                throw new NullPointerException("stackTraces == null");
            }
            this.stackTraces = stackTraces;
        }

        public long getStartMillis() {
            return this.startMillis;
        }

        public void setStartMillis(long startMillis) {
            this.startMillis = startMillis;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public List<ThreadEvent> getThreadHistory() {
            return Collections.unmodifiableList(this.threadHistory);
        }

        public Set<Sample> getSamples() {
            HashSet<Sample> samples = new HashSet<Sample>(this.stackTraces.size());
            for (Map.Entry<StackTrace, int[]> e : this.stackTraces.entrySet()) {
                StackTrace stackTrace = e.getKey();
                int[] countCell = e.getValue();
                int count = countCell[0];
                Sample sample = new Sample(stackTrace, count, null);
                samples.add(sample);
            }
            return samples;
        }

        public void addThreadEvent(ThreadEvent event) {
            if (event == null) {
                throw new NullPointerException("event == null");
            }
            ThreadEvent old = this.threadIdToThreadEvent.put(event.threadId, event);
            switch (event.type) {
                case START: {
                    if (old == null) break;
                    throw new IllegalArgumentException("ThreadEvent already registered for id " + event.threadId);
                }
                case END: {
                    if (old == null || old.type != ThreadEventType.END) break;
                    throw new IllegalArgumentException("Duplicate ThreadEvent.end for id " + event.threadId);
                }
            }
            this.threadHistory.add(event);
        }

        public void addStackTrace(StackTrace stackTrace, int[] countCell) {
            if (!this.threadIdToThreadEvent.containsKey(stackTrace.threadId)) {
                throw new IllegalArgumentException("Unknown thread id " + stackTrace.threadId);
            }
            int[] old = this.stackTraces.put(stackTrace, countCell);
            if (old != null) {
                throw new IllegalArgumentException("StackTrace already registered for id " + stackTrace.stackTraceId + ":\n" + stackTrace);
            }
        }

        public static class Sample {
            public final StackTrace stackTrace;
            public final int count;

            public Sample(StackTrace stackTrace, int count) {
                if (stackTrace == null) {
                    throw new NullPointerException("stackTrace == null");
                }
                if (count < 0) {
                    throw new IllegalArgumentException("count < 0:" + count);
                }
                this.stackTrace = stackTrace;
                this.count = count;
            }

            public int hashCode() {
                int result = 17;
                result = 31 * result + this.stackTrace.hashCode();
                result = 31 * result + this.count;
                return result;
            }

            public boolean equals(Object o) {
                Sample s = (Sample)o;
                return this.stackTrace.equals(s.stackTrace) && this.count == s.count;
            }

            public String toString() {
                return "Sample[count=" + this.count + " " + this.stackTrace + "]";
            }

            public /* synthetic */ Sample(StackTrace x0, int x1, 1 x2) {
                this(x0, x1);
            }
        }

        public static class StackTrace {
            public final int stackTraceId;
            public int threadId;
            public StackTraceElement[] stackFrames;

            public StackTrace() {
                this.stackTraceId = -1;
            }

            public StackTrace(int stackTraceId, int threadId, StackTraceElement[] stackFrames) {
                if (stackFrames == null) {
                    throw new NullPointerException("stackFrames == null");
                }
                this.stackTraceId = stackTraceId;
                this.threadId = threadId;
                this.stackFrames = stackFrames;
            }

            public int getThreadId() {
                return this.threadId;
            }

            public StackTraceElement[] getStackFrames() {
                return this.stackFrames;
            }

            public int hashCode() {
                int result = 17;
                result = 31 * result + this.threadId;
                result = 31 * result + Arrays.hashCode(this.stackFrames);
                return result;
            }

            public boolean equals(Object o) {
                if (!(o instanceof StackTrace)) {
                    return false;
                }
                StackTrace s = (StackTrace)o;
                return this.threadId == s.threadId && Arrays.equals(this.stackFrames, s.stackFrames);
            }

            public String toString() {
                StringBuilder frames = new StringBuilder();
                if (this.stackFrames.length > 0) {
                    frames.append('\n');
                    for (StackTraceElement stackFrame : this.stackFrames) {
                        frames.append("\t at ");
                        frames.append(stackFrame);
                        frames.append('\n');
                    }
                } else {
                    frames.append("<empty>");
                }
                return "StackTrace[stackTraceId=" + this.stackTraceId + ", threadId=" + this.threadId + ", frames=" + frames + "]";
            }

            public /* synthetic */ StackTrace(1 x0) {
                this();
            }

            public static /* synthetic */ StackTraceElement[] access$202(StackTrace x0, StackTraceElement[] x1) {
                x0.stackFrames = x1;
                return x1;
            }
        }

        public static class ThreadEvent {
            public final ThreadEventType type;
            public final int objectId;
            public final int threadId;
            public final String threadName;
            public final String groupName;
            public final String parentGroupName;

            public static ThreadEvent start(int objectId, int threadId, String threadName, String groupName, String parentGroupName) {
                return new ThreadEvent(ThreadEventType.START, objectId, threadId, threadName, groupName, parentGroupName);
            }

            public static ThreadEvent end(int threadId) {
                return new ThreadEvent(ThreadEventType.END, threadId);
            }

            public ThreadEvent(ThreadEventType type, int objectId, int threadId, String threadName, String groupName, String parentGroupName) {
                if (threadName == null) {
                    throw new NullPointerException("threadName == null");
                }
                this.type = ThreadEventType.START;
                this.objectId = objectId;
                this.threadId = threadId;
                this.threadName = threadName;
                this.groupName = groupName;
                this.parentGroupName = parentGroupName;
            }

            public ThreadEvent(ThreadEventType type, int threadId) {
                this.type = ThreadEventType.END;
                this.objectId = -1;
                this.threadId = threadId;
                this.threadName = null;
                this.groupName = null;
                this.parentGroupName = null;
            }

            public int hashCode() {
                int result = 17;
                result = 31 * result + this.objectId;
                result = 31 * result + this.threadId;
                result = 31 * result + Objects.hashCode(this.threadName);
                result = 31 * result + Objects.hashCode(this.groupName);
                result = 31 * result + Objects.hashCode(this.parentGroupName);
                return result;
            }

            public boolean equals(Object o) {
                if (!(o instanceof ThreadEvent)) {
                    return false;
                }
                ThreadEvent event = (ThreadEvent)o;
                return this.type == event.type && this.objectId == event.objectId && this.threadId == event.threadId && Objects.equal(this.threadName, event.threadName) && Objects.equal(this.groupName, event.groupName) && Objects.equal(this.parentGroupName, event.parentGroupName);
            }

            public String toString() {
                switch (this.type) {
                    case START: {
                        return String.format("THREAD START (obj=%d, id = %d, name=\"%s\", group=\"%s\")", this.objectId, this.threadId, this.threadName, this.groupName);
                    }
                    case END: {
                        return String.format("THREAD END (id = %d)", this.threadId);
                    }
                }
                throw new IllegalStateException(this.type.toString());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ThreadEventType {
            START,
            END;

        }
    }
}

