/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.MappedByteBufferAdapter;
import java.nio.MemoryBlock;
import java.nio.NioUtils;
import java.nio.ReadOnlyFileChannel;
import java.nio.SocketChannelImpl;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.harmony.luni.platform.Platform;

public abstract class FileChannelImpl
extends FileChannel {
    public static final int ALLOC_GRANULARITY = Platform.FILE_SYSTEM.getAllocGranularity();
    public static final Comparator<FileLock> LOCK_COMPARATOR = new Comparator<FileLock>(){

        @Override
        public int compare(FileLock lock1, FileLock lock2) {
            long position2;
            long position1 = lock1.position();
            return position1 > (position2 = lock2.position()) ? 1 : (position1 < position2 ? -1 : 0);
        }
    };
    public final int handle;
    public final SortedSet<FileLock> locks = new TreeSet<FileLock>(LOCK_COMPARATOR);
    public final Object repositioningLock = new Object();
    public final Object stream;

    public FileChannelImpl(Object stream, int handle) {
        this.handle = handle;
        this.stream = stream;
    }

    public void openCheck() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    public void implCloseChannel() throws IOException {
        if (this.stream instanceof Closeable) {
            ((Closeable)this.stream).close();
        }
    }

    public FileLock basicLock(long position, long size, boolean shared, boolean wait) throws IOException {
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException("Lock position and size must be non-negative");
        }
        int lockType = shared ? 1 : 2;
        FileLockImpl pendingLock = new FileLockImpl(this, position, size, shared);
        this.addLock(pendingLock);
        if (Platform.FILE_SYSTEM.lock(this.handle, position, size, lockType, wait)) {
            return pendingLock;
        }
        this.removeLock(pendingLock);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        this.openCheck();
        FileLock resultLock = null;
        boolean completed = false;
        try {
            this.begin();
            resultLock = this.basicLock(position, size, shared, true);
            completed = true;
        }
        finally {
            this.end(completed);
        }
        return resultLock;
    }

    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        this.openCheck();
        return this.basicLock(position, size, shared, false);
    }

    public void release(FileLock lock) throws IOException {
        this.openCheck();
        Platform.FILE_SYSTEM.unlock(this.handle, lock.position(), lock.size());
        this.removeLock(lock);
    }

    public void force(boolean metadata) throws IOException {
        this.openCheck();
        Platform.FILE_SYSTEM.fsync(this.handle, metadata);
    }

    public abstract MappedByteBuffer map(FileChannel.MapMode var1, long var2, long var4) throws IOException;

    public MappedByteBuffer mapImpl(FileChannel.MapMode mapMode, long position, long size) throws IOException {
        if (position + size > this.size()) {
            Platform.FILE_SYSTEM.truncate(this.handle, position + size);
        }
        long alignment = position - position % (long)ALLOC_GRANULARITY;
        int offset = (int)(position - alignment);
        MemoryBlock block = MemoryBlock.mmap(this.handle, alignment, size + (long)offset, mapMode);
        return new MappedByteBufferAdapter(block, (int)size, offset, mapMode);
    }

    public long position() throws IOException {
        this.openCheck();
        return Platform.FILE_SYSTEM.seek(this.handle, 0L, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel position(long newPosition) throws IOException {
        this.openCheck();
        if (newPosition < 0L) {
            throw new IllegalArgumentException("New position must be non-negative");
        }
        Object object = this.repositioningLock;
        synchronized (object) {
            Platform.FILE_SYSTEM.seek(this.handle, newPosition, 1);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buffer, long position) throws IOException {
        FileChannelImpl.checkWritable(buffer);
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        this.openCheck();
        if (!buffer.hasRemaining()) {
            return 0;
        }
        Object object = this.repositioningLock;
        synchronized (object) {
            int bytesRead = 0;
            long preReadPosition = this.position();
            this.position(position);
            try {
                bytesRead = this.read(buffer);
            }
            finally {
                this.position(preReadPosition);
            }
            return bytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buffer) throws IOException {
        FileChannelImpl.checkWritable(buffer);
        this.openCheck();
        if (!buffer.hasRemaining()) {
            return 0;
        }
        boolean completed = false;
        int bytesRead = 0;
        Object object = this.repositioningLock;
        synchronized (object) {
            block10: {
                block9: {
                    if (!buffer.isDirect()) break block9;
                    try {
                        this.begin();
                        int address = NioUtils.getDirectBufferAddress(buffer);
                        bytesRead = (int)Platform.FILE_SYSTEM.readDirect(this.handle, address, buffer.position(), buffer.remaining());
                        completed = true;
                        this.end(completed && bytesRead >= 0);
                    }
                    catch (Throwable throwable) {
                        this.end(completed && bytesRead >= 0);
                        throw throwable;
                    }
                    break block10;
                }
                try {
                    this.begin();
                    bytesRead = (int)Platform.FILE_SYSTEM.read(this.handle, buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                    completed = true;
                    this.end(completed && bytesRead >= 0);
                }
                catch (Throwable throwable) {
                    this.end(completed && bytesRead >= 0);
                    throw throwable;
                }
            }
            if (bytesRead > 0) {
                buffer.position(buffer.position() + bytesRead);
            }
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBuffer[] buffers, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount((int)buffers.length, (int)offset, (int)length);
        this.openCheck();
        int count = FileChannelImpl.calculateTotalRemaining(buffers, offset, length, true);
        if (count == 0) {
            return 0L;
        }
        ByteBuffer[] directBuffers = new ByteBuffer[length];
        int[] handles = new int[length];
        int[] offsets = new int[length];
        int[] lengths = new int[length];
        for (int i = 0; i < length; ++i) {
            ByteBuffer buffer = buffers[i + offset];
            if (!buffer.isDirect()) {
                directBuffers[i] = buffer = ByteBuffer.allocateDirect(buffer.remaining());
                offsets[i] = 0;
            } else {
                offsets[i] = buffer.position();
            }
            handles[i] = NioUtils.getDirectBufferAddress(buffer);
            lengths[i] = buffer.remaining();
        }
        long bytesRead = 0L;
        boolean completed = false;
        try {
            this.begin();
            Object object = this.repositioningLock;
            synchronized (object) {
                bytesRead = Platform.FILE_SYSTEM.readv(this.handle, handles, offsets, lengths, length);
            }
            completed = true;
        }
        finally {
            this.end(completed);
        }
        int end = offset + length;
        long bytesRemaining = bytesRead;
        for (int i = offset; i < end && bytesRemaining > 0L; ++i) {
            if (buffers[i].isDirect()) {
                int pos;
                if ((long)lengths[i] < bytesRemaining) {
                    pos = buffers[i].limit();
                    buffers[i].position(pos);
                    bytesRemaining -= (long)lengths[i];
                    continue;
                }
                pos = (int)bytesRemaining;
                buffers[i].position(pos);
                break;
            }
            ByteBuffer buf = directBuffers[i - offset];
            if (bytesRemaining < (long)buf.remaining()) {
                int pos = buf.position();
                buffers[i].put(buf);
                buffers[i].position(pos + (int)bytesRemaining);
                bytesRemaining = 0L;
                continue;
            }
            bytesRemaining -= (long)buf.remaining();
            buffers[i].put(buf);
        }
        return bytesRead;
    }

    public long size() throws IOException {
        this.openCheck();
        return Platform.FILE_SYSTEM.length(this.handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        long l;
        this.openCheck();
        if (!src.isOpen()) {
            throw new ClosedChannelException();
        }
        if (position < 0L || count < 0L || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (position > this.size()) {
            return 0L;
        }
        ByteBuffer buffer = null;
        try {
            if (src instanceof FileChannel) {
                FileChannel fileSrc = (FileChannel)src;
                long size = fileSrc.size();
                long filePosition = fileSrc.position();
                count = Math.min(count, size - filePosition);
                buffer = fileSrc.map(FileChannel.MapMode.READ_ONLY, filePosition, count);
                fileSrc.position(filePosition + count);
            } else {
                buffer = ByteBuffer.allocateDirect((int)count);
                src.read(buffer);
                buffer.flip();
            }
            l = this.write(buffer, position);
        }
        catch (Throwable throwable) {
            NioUtils.freeDirectBuffer(buffer);
            throw throwable;
        }
        NioUtils.freeDirectBuffer(buffer);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        long l;
        this.openCheck();
        if (!target.isOpen()) {
            throw new ClosedChannelException();
        }
        if (target instanceof ReadOnlyFileChannel) {
            throw new NonWritableChannelException();
        }
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException();
        }
        if (count == 0L || position >= this.size()) {
            return 0L;
        }
        MappedByteBuffer buffer = null;
        count = Math.min(count, this.size() - position);
        if (target instanceof SocketChannelImpl) {
            return this.kernelTransfer(this.handle, ((SocketChannelImpl)target).getFD(), position, count);
        }
        try {
            buffer = this.map(FileChannel.MapMode.READ_ONLY, position, count);
            l = target.write(buffer);
        }
        catch (Throwable throwable) {
            NioUtils.freeDirectBuffer(buffer);
            throw throwable;
        }
        NioUtils.freeDirectBuffer(buffer);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long kernelTransfer(int l, FileDescriptor fd, long position, long count) throws IOException {
        boolean completed = false;
        try {
            this.begin();
            long ret = Platform.FILE_SYSTEM.transfer(l, fd, position, count);
            completed = true;
            long l2 = ret;
            return l2;
        }
        finally {
            this.end(completed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel truncate(long size) throws IOException {
        this.openCheck();
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        if (size < this.size()) {
            Object object = this.repositioningLock;
            synchronized (object) {
                long position = this.position();
                Platform.FILE_SYSTEM.truncate(this.handle, size);
                this.position(position > size ? size : position);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer buffer, long position) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        this.openCheck();
        if (!buffer.hasRemaining()) {
            return 0;
        }
        int bytesWritten = 0;
        Object object = this.repositioningLock;
        synchronized (object) {
            long preWritePosition = this.position();
            this.position(position);
            try {
                bytesWritten = this.writeImpl(buffer);
            }
            finally {
                this.position(preWritePosition);
            }
        }
        return bytesWritten;
    }

    public int write(ByteBuffer buffer) throws IOException {
        this.openCheck();
        return this.writeImpl(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeImpl(ByteBuffer buffer) throws IOException {
        int bytesWritten;
        boolean completed = false;
        Object object = this.repositioningLock;
        synchronized (object) {
            if (buffer.isDirect()) {
                try {
                    this.begin();
                    int address = NioUtils.getDirectBufferAddress(buffer);
                    bytesWritten = (int)Platform.FILE_SYSTEM.writeDirect(this.handle, address, buffer.position(), buffer.remaining());
                    completed = true;
                }
                finally {
                    this.end(completed);
                }
            }
            try {
                this.begin();
                bytesWritten = (int)Platform.FILE_SYSTEM.write(this.handle, buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                completed = true;
            }
            finally {
                this.end(completed);
            }
            if (bytesWritten > 0) {
                buffer.position(buffer.position() + bytesWritten);
            }
        }
        return bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] buffers, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount((int)buffers.length, (int)offset, (int)length);
        this.openCheck();
        int count = FileChannelImpl.calculateTotalRemaining(buffers, offset, length, false);
        if (count == 0) {
            return 0L;
        }
        int[] handles = new int[length];
        int[] offsets = new int[length];
        int[] lengths = new int[length];
        ByteBuffer[] allocatedBufs = new ByteBuffer[length];
        for (int i = 0; i < length; ++i) {
            ByteBuffer buffer = buffers[i + offset];
            if (!buffer.isDirect()) {
                ByteBuffer directBuffer = ByteBuffer.allocateDirect(buffer.remaining());
                directBuffer.put(buffer);
                directBuffer.flip();
                buffer = directBuffer;
                allocatedBufs[i] = directBuffer;
                offsets[i] = 0;
            } else {
                offsets[i] = buffer.position();
                allocatedBufs[i] = null;
            }
            handles[i] = NioUtils.getDirectBufferAddress(buffer);
            lengths[i] = buffer.remaining();
        }
        long bytesWritten = 0L;
        boolean completed = false;
        Object object = this.repositioningLock;
        synchronized (object) {
            try {
                this.begin();
                bytesWritten = Platform.FILE_SYSTEM.writev(this.handle, handles, offsets, lengths, length);
                completed = true;
            }
            finally {
                this.end(completed);
                for (ByteBuffer buffer : allocatedBufs) {
                    NioUtils.freeDirectBuffer(buffer);
                }
            }
        }
        long bytesRemaining = bytesWritten;
        for (int i = offset; i < length + offset; ++i) {
            int pos;
            if (bytesRemaining > (long)buffers[i].remaining()) {
                pos = buffers[i].limit();
                buffers[i].position(pos);
                bytesRemaining -= (long)buffers[i].remaining();
                continue;
            }
            pos = buffers[i].position() + (int)bytesRemaining;
            buffers[i].position(pos);
            break;
        }
        return bytesWritten;
    }

    public static void checkWritable(ByteBuffer buffer) {
        if (buffer.isReadOnly()) {
            throw new IllegalArgumentException("read-only buffer");
        }
    }

    public static int calculateTotalRemaining(ByteBuffer[] buffers, int offset, int length, boolean copyingIn) {
        int count = 0;
        for (int i = offset; i < offset + length; ++i) {
            count += buffers[i].remaining();
            if (!copyingIn) continue;
            FileChannelImpl.checkWritable(buffers[i]);
        }
        return count;
    }

    public int getHandle() {
        return this.handle;
    }

    public synchronized void addLock(FileLock lock) throws OverlappingFileLockException {
        FileLock existingLock;
        long lockEnd = lock.position() + lock.size();
        Iterator i$ = this.locks.iterator();
        while (i$.hasNext() && (existingLock = (FileLock)i$.next()).position() <= lockEnd) {
            if (!existingLock.overlaps(lock.position(), lock.size())) continue;
            throw new OverlappingFileLockException();
        }
        this.locks.add(lock);
    }

    public synchronized void removeLock(FileLock lock) {
        this.locks.remove(lock);
    }

    public static class FileLockImpl
    extends FileLock {
        public boolean isReleased = false;

        public FileLockImpl(FileChannel channel, long position, long size, boolean shared) {
            super(channel, position, size, shared);
        }

        public boolean isValid() {
            return !this.isReleased && this.channel().isOpen();
        }

        public void release() throws IOException {
            if (!this.channel().isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isReleased) {
                ((FileChannelImpl)this.channel()).release(this);
                this.isReleased = true;
            }
        }
    }
}

