/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.MemoryBlock;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;

public class MappedByteBufferAdapter
extends MappedByteBuffer {
    public MappedByteBufferAdapter(ByteBuffer buffer) {
        super(buffer);
        this.effectiveDirectAddress = this.wrapped.effectiveDirectAddress;
    }

    public MappedByteBufferAdapter(MemoryBlock block, int capacity, int offset, FileChannel.MapMode mode) {
        super(block, capacity, offset, mode);
        this.effectiveDirectAddress = this.wrapped.effectiveDirectAddress;
    }

    public void limitImpl(int newLimit) {
        super.limitImpl(newLimit);
        this.wrapped.limit(newLimit);
    }

    public void positionImpl(int newPosition) {
        super.positionImpl(newPosition);
        this.wrapped.position(newPosition);
    }

    public CharBuffer asCharBuffer() {
        return this.wrapped.asCharBuffer();
    }

    public DoubleBuffer asDoubleBuffer() {
        return this.wrapped.asDoubleBuffer();
    }

    public FloatBuffer asFloatBuffer() {
        return this.wrapped.asFloatBuffer();
    }

    public IntBuffer asIntBuffer() {
        return this.wrapped.asIntBuffer();
    }

    public LongBuffer asLongBuffer() {
        return this.wrapped.asLongBuffer();
    }

    public ByteBuffer asReadOnlyBuffer() {
        MappedByteBufferAdapter result = new MappedByteBufferAdapter(this.wrapped.asReadOnlyBuffer());
        result.limit(this.limit);
        result.position(this.position);
        result.mark = this.mark;
        return result;
    }

    public ShortBuffer asShortBuffer() {
        return this.wrapped.asShortBuffer();
    }

    public ByteBuffer compact() {
        if (this.wrapped.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.wrapped.compact();
        this.limit(this.capacity);
        this.position(this.wrapped.position());
        this.mark = -1;
        return this;
    }

    public ByteBuffer duplicate() {
        MappedByteBufferAdapter result = new MappedByteBufferAdapter(this.wrapped.duplicate());
        result.limit(this.limit);
        result.position(this.position);
        result.mark = this.mark;
        return result;
    }

    public byte get() {
        this.wrapped.position(this.position);
        byte result = this.wrapped.get();
        ++this.position;
        return result;
    }

    public byte get(int index) {
        return this.wrapped.get(index);
    }

    public ByteBuffer get(byte[] dst, int dstOffset, int byteCount) {
        ByteBuffer result = this.wrapped.get(dst, dstOffset, byteCount);
        this.position += byteCount;
        return result;
    }

    public char getChar() {
        this.wrapped.position(this.position);
        char result = this.wrapped.getChar();
        this.position += 2;
        return result;
    }

    public char getChar(int index) {
        return this.wrapped.getChar(index);
    }

    public double getDouble() {
        this.wrapped.position(this.position);
        double result = this.wrapped.getDouble();
        this.position += 8;
        return result;
    }

    public double getDouble(int index) {
        return this.wrapped.getDouble(index);
    }

    public float getFloat() {
        this.wrapped.position(this.position);
        float result = this.wrapped.getFloat();
        this.position += 4;
        return result;
    }

    public float getFloat(int index) {
        return this.wrapped.getFloat(index);
    }

    public int getInt() {
        this.wrapped.position(this.position);
        int result = this.wrapped.getInt();
        this.position += 4;
        return result;
    }

    public int getInt(int index) {
        return this.wrapped.getInt(index);
    }

    public long getLong() {
        this.wrapped.position(this.position);
        long result = this.wrapped.getLong();
        this.position += 8;
        return result;
    }

    public long getLong(int index) {
        return this.wrapped.getLong(index);
    }

    public short getShort() {
        this.wrapped.position(this.position);
        short result = this.wrapped.getShort();
        this.position += 2;
        return result;
    }

    public short getShort(int index) {
        return this.wrapped.getShort(index);
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return this.wrapped.isReadOnly();
    }

    public void orderImpl(ByteOrder byteOrder) {
        super.orderImpl(byteOrder);
        this.wrapped.order(byteOrder);
    }

    public ByteBuffer put(byte b) {
        this.wrapped.position(this.position);
        this.wrapped.put(b);
        ++this.position;
        return this;
    }

    public ByteBuffer put(byte[] src, int srcOffset, int byteCount) {
        this.wrapped.position(this.position);
        this.wrapped.put(src, srcOffset, byteCount);
        this.position += byteCount;
        return this;
    }

    public ByteBuffer put(int index, byte b) {
        this.wrapped.position(this.position);
        this.wrapped.put(index, b);
        return this;
    }

    public ByteBuffer putChar(char value) {
        this.wrapped.position(this.position);
        this.wrapped.putChar(value);
        this.position += 2;
        return this;
    }

    public ByteBuffer putChar(int index, char value) {
        this.wrapped.position(this.position);
        this.wrapped.putChar(index, value);
        return this;
    }

    public ByteBuffer putDouble(double value) {
        this.wrapped.position(this.position);
        this.wrapped.putDouble(value);
        this.position += 8;
        return this;
    }

    public ByteBuffer putDouble(int index, double value) {
        this.wrapped.position(this.position);
        this.wrapped.putDouble(index, value);
        return this;
    }

    public ByteBuffer putFloat(float value) {
        this.wrapped.position(this.position);
        this.wrapped.putFloat(value);
        this.position += 4;
        return this;
    }

    public ByteBuffer putFloat(int index, float value) {
        this.wrapped.position(this.position);
        this.wrapped.putFloat(index, value);
        return this;
    }

    public ByteBuffer putInt(int index, int value) {
        this.wrapped.position(this.position);
        this.wrapped.putInt(index, value);
        return this;
    }

    public ByteBuffer putInt(int value) {
        this.wrapped.position(this.position);
        this.wrapped.putInt(value);
        this.position += 4;
        return this;
    }

    public ByteBuffer putLong(int index, long value) {
        this.wrapped.position(this.position);
        this.wrapped.putLong(index, value);
        return this;
    }

    public ByteBuffer putLong(long value) {
        this.wrapped.position(this.position);
        this.wrapped.putLong(value);
        this.position += 8;
        return this;
    }

    public ByteBuffer putShort(int index, short value) {
        this.wrapped.position(this.position);
        this.wrapped.putShort(index, value);
        return this;
    }

    public ByteBuffer putShort(short value) {
        this.wrapped.position(this.position);
        this.wrapped.putShort(value);
        this.position += 2;
        return this;
    }

    public ByteBuffer slice() {
        this.wrapped.position(this.position);
        MappedByteBufferAdapter result = new MappedByteBufferAdapter(this.wrapped.slice());
        this.wrapped.clear();
        return result;
    }

    public byte[] protectedArray() {
        return this.wrapped.protectedArray();
    }

    public int protectedArrayOffset() {
        return this.wrapped.protectedArrayOffset();
    }

    public boolean protectedHasArray() {
        return this.wrapped.protectedHasArray();
    }

    public void free() {
        this.wrapped.free();
    }
}

