/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import dalvik.system.VMRuntime;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.apache.harmony.luni.platform.OSMemory;

public class MemoryBlock {
    public int address;
    public final long size;

    public static MemoryBlock mmap(int fd, long start, long size, FileChannel.MapMode mode) throws IOException {
        if (size == 0L) {
            return new MemoryBlock(0, 0L);
        }
        int address = OSMemory.mmap(fd, start, size, mode);
        return new MemoryMappedBlock(address, size, null);
    }

    public static MemoryBlock allocate(int byteCount) {
        VMRuntime runtime = VMRuntime.getRuntime();
        byte[] array2 = (byte[])runtime.newNonMovableArray(Byte.TYPE, byteCount);
        int address = (int)runtime.addressOf(array2);
        return new NonMovableHeapBlock(array2, address, byteCount, null);
    }

    public static MemoryBlock wrapFromJni(int address, long byteCount) {
        return new UnmanagedBlock(address, byteCount, null);
    }

    public MemoryBlock(int address, long size) {
        this.address = address;
        this.size = size;
    }

    public void free() {
    }

    public void pokeByte(int offset, byte value) {
        OSMemory.pokeByte(this.address + offset, value);
    }

    public void pokeByteArray(int offset, byte[] src, int srcOffset, int byteCount) {
        OSMemory.pokeByteArray(this.address + offset, src, srcOffset, byteCount);
    }

    public void pokeCharArray(int offset, char[] src, int srcOffset, int charCount, boolean swap) {
        OSMemory.pokeCharArray(this.address + offset, src, srcOffset, charCount, swap);
    }

    public void pokeDoubleArray(int offset, double[] src, int srcOffset, int doubleCount, boolean swap) {
        OSMemory.pokeDoubleArray(this.address + offset, src, srcOffset, doubleCount, swap);
    }

    public void pokeFloatArray(int offset, float[] src, int srcOffset, int floatCount, boolean swap) {
        OSMemory.pokeFloatArray(this.address + offset, src, srcOffset, floatCount, swap);
    }

    public void pokeIntArray(int offset, int[] src, int srcOffset, int intCount, boolean swap) {
        OSMemory.pokeIntArray(this.address + offset, src, srcOffset, intCount, swap);
    }

    public void pokeLongArray(int offset, long[] src, int srcOffset, int longCount, boolean swap) {
        OSMemory.pokeLongArray(this.address + offset, src, srcOffset, longCount, swap);
    }

    public void pokeShortArray(int offset, short[] src, int srcOffset, int shortCount, boolean swap) {
        OSMemory.pokeShortArray(this.address + offset, src, srcOffset, shortCount, swap);
    }

    public byte peekByte(int offset) {
        return OSMemory.peekByte(this.address + offset);
    }

    public void peekByteArray(int offset, byte[] dst, int dstOffset, int byteCount) {
        OSMemory.peekByteArray(this.address + offset, dst, dstOffset, byteCount);
    }

    public void peekCharArray(int offset, char[] dst, int dstOffset, int charCount, boolean swap) {
        OSMemory.peekCharArray(this.address + offset, dst, dstOffset, charCount, swap);
    }

    public void peekDoubleArray(int offset, double[] dst, int dstOffset, int doubleCount, boolean swap) {
        OSMemory.peekDoubleArray(this.address + offset, dst, dstOffset, doubleCount, swap);
    }

    public void peekFloatArray(int offset, float[] dst, int dstOffset, int floatCount, boolean swap) {
        OSMemory.peekFloatArray(this.address + offset, dst, dstOffset, floatCount, swap);
    }

    public void peekIntArray(int offset, int[] dst, int dstOffset, int intCount, boolean swap) {
        OSMemory.peekIntArray(this.address + offset, dst, dstOffset, intCount, swap);
    }

    public void peekLongArray(int offset, long[] dst, int dstOffset, int longCount, boolean swap) {
        OSMemory.peekLongArray(this.address + offset, dst, dstOffset, longCount, swap);
    }

    public void peekShortArray(int offset, short[] dst, int dstOffset, int shortCount, boolean swap) {
        OSMemory.peekShortArray(this.address + offset, dst, dstOffset, shortCount, swap);
    }

    public void pokeShort(int offset, short value, ByteOrder order) {
        OSMemory.pokeShort(this.address + offset, value, order.needsSwap);
    }

    public short peekShort(int offset, ByteOrder order) {
        return OSMemory.peekShort(this.address + offset, order.needsSwap);
    }

    public void pokeInt(int offset, int value, ByteOrder order) {
        OSMemory.pokeInt(this.address + offset, value, order.needsSwap);
    }

    public int peekInt(int offset, ByteOrder order) {
        return OSMemory.peekInt(this.address + offset, order.needsSwap);
    }

    public void pokeLong(int offset, long value, ByteOrder order) {
        OSMemory.pokeLong(this.address + offset, value, order.needsSwap);
    }

    public long peekLong(int offset, ByteOrder order) {
        return OSMemory.peekLong(this.address + offset, order.needsSwap);
    }

    public int toInt() {
        return this.address;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.address + "]";
    }

    public long getSize() {
        return this.size;
    }

    public /* synthetic */ MemoryBlock(int x0, long x1, 1 x2) {
        this(x0, x1);
    }

    public static class 1 {
    }

    public static class UnmanagedBlock
    extends MemoryBlock {
        public UnmanagedBlock(int address, long byteCount) {
            super(address, byteCount, null);
        }

        public /* synthetic */ UnmanagedBlock(int x0, long x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static class NonMovableHeapBlock
    extends MemoryBlock {
        public byte[] array;

        public NonMovableHeapBlock(byte[] array2, int address, long byteCount) {
            super(address, byteCount, null);
            this.array = array2;
        }

        public void free() {
            this.array = null;
            this.address = 0;
        }

        public /* synthetic */ NonMovableHeapBlock(byte[] x0, int x1, long x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class MemoryMappedBlock
    extends MemoryBlock {
        public MemoryMappedBlock(int address, long byteCount) {
            super(address, byteCount, null);
        }

        public void free() {
            if (this.address != 0) {
                OSMemory.munmap(this.address, this.size);
                this.address = 0;
            }
        }

        public void finalize() throws Throwable {
            this.free();
        }

        public /* synthetic */ MemoryMappedBlock(int x0, long x1, 1 x2) {
            this(x0, x1);
        }
    }
}

