/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketUtils;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.FileChannelImpl;
import java.nio.NioUtils;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Arrays;
import libcore.io.IoUtils;
import org.apache.harmony.luni.net.PlainSocketImpl;
import org.apache.harmony.luni.platform.FileDescriptorHandler;
import org.apache.harmony.luni.platform.Platform;

public class SocketChannelImpl
extends SocketChannel
implements FileDescriptorHandler {
    public static final int EOF = -1;
    public static final int SOCKET_STATUS_UNINIT = -1;
    public static final int SOCKET_STATUS_UNCONNECTED = 0;
    public static final int SOCKET_STATUS_PENDING = 1;
    public static final int SOCKET_STATUS_CONNECTED = 2;
    public static final int SOCKET_STATUS_CLOSED = 3;
    public final FileDescriptor fd;
    public SocketAdapter socket = null;
    public InetSocketAddress connectAddress = null;
    public InetAddress localAddress = null;
    public int localPort;
    public int status = 0;
    public volatile boolean isBound = false;
    public final Object readLock = new Object();
    public final Object writeLock = new Object();

    public SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        this(selectorProvider, true);
    }

    public SocketChannelImpl(SelectorProvider selectorProvider, boolean connect) throws IOException {
        super(selectorProvider);
        this.fd = new FileDescriptor();
        if (connect) {
            Platform.NETWORK.socket(this.fd, true);
        }
    }

    public synchronized Socket socket() {
        if (this.socket == null) {
            try {
                InetAddress addr = null;
                int port = 0;
                if (this.connectAddress != null) {
                    addr = this.connectAddress.getAddress();
                    port = this.connectAddress.getPort();
                }
                this.socket = new SocketAdapter(new PlainSocketImpl(this.fd, this.localPort, addr, port), this);
            }
            catch (SocketException e) {
                return null;
            }
        }
        return this.socket;
    }

    public synchronized boolean isConnected() {
        return this.status == 2;
    }

    public synchronized void setConnected() {
        this.status = 2;
    }

    public void setBound(boolean flag) {
        this.isBound = flag;
    }

    public synchronized boolean isConnectionPending() {
        return this.status == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(SocketAddress socketAddress) throws IOException {
        boolean finished;
        InetSocketAddress inetSocketAddress;
        block17: {
            this.checkUnconnected();
            inetSocketAddress = SocketChannelImpl.validateAddress(socketAddress);
            InetAddress normalAddr = inetSocketAddress.getAddress();
            if (normalAddr.isAnyLocalAddress()) {
                normalAddr = InetAddress.getLocalHost();
            }
            int port = inetSocketAddress.getPort();
            String hostName = normalAddr.getHostName();
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkConnect(hostName, port);
            }
            int result = -1;
            finished = false;
            try {
                if (this.isBlocking()) {
                    this.begin();
                    Platform.NETWORK.connect(this.fd, normalAddr, port, 0);
                    finished = true;
                } else {
                    finished = Platform.NETWORK.connectNonBlocking(this.fd, normalAddr, port);
                    if (!this.isBlocking()) {
                        IoUtils.setBlocking(this.fd, false);
                    }
                }
                this.isBound = finished;
            }
            catch (IOException e) {
                if (e instanceof ConnectException && !this.isBlocking()) {
                    this.status = 1;
                    break block17;
                }
                if (this.isOpen()) {
                    this.close();
                    finished = true;
                }
                throw e;
            }
            finally {
                if (this.isBlocking()) {
                    this.end(finished);
                }
            }
        }
        this.initLocalAddressAndPort();
        this.connectAddress = inetSocketAddress;
        if (this.socket != null) {
            this.socket.socketImpl().initRemoteAddressAndPort(this.connectAddress.getAddress(), this.connectAddress.getPort());
        }
        SocketChannelImpl socketChannelImpl = this;
        synchronized (socketChannelImpl) {
            this.status = this.isBlocking() ? (finished ? 2 : 0) : 1;
        }
        return finished;
    }

    public void initLocalAddressAndPort() {
        this.localAddress = Platform.NETWORK.getSocketLocalAddress(this.fd);
        this.localPort = Platform.NETWORK.getSocketLocalPort(this.fd);
        if (this.socket != null) {
            this.socket.socketImpl().initLocalPort(this.localPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishConnect() throws IOException {
        SocketChannelImpl socketChannelImpl = this;
        synchronized (socketChannelImpl) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.status == 2) {
                return true;
            }
            if (this.status != 1) {
                throw new NoConnectionPendingException();
            }
        }
        boolean finished = false;
        try {
            this.begin();
            int WAIT_FOREVER = -1;
            boolean POLL = false;
            this.isBound = finished = Platform.NETWORK.isConnected(this.fd, this.isBlocking() ? -1 : 0);
            this.initLocalAddressAndPort();
        }
        catch (ConnectException e) {
            if (this.isOpen()) {
                this.close();
                finished = true;
            }
            throw e;
        }
        finally {
            this.end(finished);
        }
        SocketChannelImpl socketChannelImpl2 = this;
        synchronized (socketChannelImpl2) {
            this.status = finished ? 2 : this.status;
            this.isBound = finished;
            if (!this.isBlocking()) {
                this.implConfigureBlocking(false);
            }
        }
        return finished;
    }

    public void finishAccept() {
        this.initLocalAddressAndPort();
    }

    public int read(ByteBuffer target) throws IOException {
        int readCount;
        FileChannelImpl.checkWritable(target);
        this.checkOpenConnected();
        if (!target.hasRemaining()) {
            return 0;
        }
        if (target.isDirect() || target.hasArray()) {
            readCount = this.readImpl(target);
            if (readCount > 0) {
                target.position(target.position() + readCount);
            }
        } else {
            ByteBuffer readBuffer = null;
            byte[] readArray = null;
            readArray = new byte[target.remaining()];
            readBuffer = ByteBuffer.wrap(readArray);
            readCount = this.readImpl(readBuffer);
            if (readCount > 0) {
                target.put(readArray, 0, readCount);
            }
        }
        return readCount;
    }

    public long read(ByteBuffer[] targets, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount((int)targets.length, (int)offset, (int)length);
        this.checkOpenConnected();
        int totalCount = FileChannelImpl.calculateTotalRemaining(targets, offset, length, true);
        if (totalCount == 0) {
            return 0L;
        }
        byte[] readArray = new byte[totalCount];
        ByteBuffer readBuffer = ByteBuffer.wrap(readArray);
        int readCount = this.readImpl(readBuffer);
        if (readCount > 0) {
            int putLength;
            int index = offset;
            for (int left = readCount; left > 0; left -= putLength) {
                putLength = Math.min(targets[index].remaining(), left);
                targets[index].put(readArray, readCount - left, putLength);
                ++index;
            }
        }
        return readCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readImpl(ByteBuffer target) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            int n;
            int readCount = 0;
            try {
                if (this.isBlocking()) {
                    this.begin();
                }
                int offset = target.position();
                int length = target.remaining();
                if (target.isDirect()) {
                    int address = NioUtils.getDirectBufferAddress(target);
                    readCount = Platform.NETWORK.readDirect(this.fd, address + offset, length);
                } else {
                    byte[] array2 = target.array();
                    readCount = Platform.NETWORK.read(this.fd, array2, offset += target.arrayOffset(), length);
                }
                n = readCount;
            }
            catch (Throwable throwable) {
                if (this.isBlocking()) {
                    this.end(readCount > 0);
                }
                throw throwable;
            }
            if (this.isBlocking()) {
                this.end(readCount > 0);
            }
            return n;
        }
    }

    public int write(ByteBuffer source) throws IOException {
        if (source == null) {
            throw new NullPointerException();
        }
        this.checkOpenConnected();
        if (!source.hasRemaining()) {
            return 0;
        }
        return this.writeImpl(source);
    }

    public long write(ByteBuffer[] sources, int offset, int length) throws IOException {
        int gap;
        int result;
        Arrays.checkOffsetAndCount((int)sources.length, (int)offset, (int)length);
        this.checkOpenConnected();
        int count = FileChannelImpl.calculateTotalRemaining(sources, offset, length, false);
        if (count == 0) {
            return 0L;
        }
        ByteBuffer writeBuf = ByteBuffer.allocate(count);
        for (int val = offset; val < length + offset; ++val) {
            ByteBuffer source = sources[val];
            int oldPosition = source.position();
            writeBuf.put(source);
            source.position(oldPosition);
        }
        writeBuf.flip();
        int val = offset;
        int written = result;
        for (result = this.writeImpl(writeBuf); result > 0; result -= gap) {
            ByteBuffer source = sources[val];
            gap = Math.min(result, source.remaining());
            source.position(source.position() + gap);
            ++val;
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeImpl(ByteBuffer source) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (!source.hasRemaining()) {
                return 0;
            }
            int writeCount = 0;
            try {
                int pos = source.position();
                int length = source.remaining();
                if (this.isBlocking()) {
                    this.begin();
                }
                if (source.isDirect()) {
                    int address = NioUtils.getDirectBufferAddress(source);
                    writeCount = Platform.NETWORK.writeDirect(this.fd, address, pos, length);
                } else if (source.hasArray()) {
                    writeCount = Platform.NETWORK.write(this.fd, source.array(), pos += source.arrayOffset(), length);
                } else {
                    byte[] array2 = new byte[length];
                    source.get(array2);
                    writeCount = Platform.NETWORK.write(this.fd, array2, 0, length);
                }
                source.position(pos + writeCount);
            }
            catch (Throwable throwable) {
                if (this.isBlocking()) {
                    this.end(writeCount >= 0);
                }
                throw throwable;
            }
            if (this.isBlocking()) {
                this.end(writeCount >= 0);
            }
            return writeCount;
        }
    }

    public synchronized void checkOpenConnected() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
    }

    public synchronized void checkUnconnected() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.status == 2) {
            throw new AlreadyConnectedException();
        }
        if (this.status == 1) {
            throw new ConnectionPendingException();
        }
    }

    public static InetSocketAddress validateAddress(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new IllegalArgumentException();
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        return inetSocketAddress;
    }

    public InetAddress getLocalAddress() throws UnknownHostException {
        if (!this.isBound) {
            byte[] any_bytes = new byte[]{0, 0, 0, 0};
            return InetAddress.getByAddress(any_bytes);
        }
        return this.localAddress;
    }

    public synchronized void implCloseSelectableChannel() throws IOException {
        if (this.status != 3) {
            this.status = 3;
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            } else {
                Platform.NETWORK.close(this.fd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void implConfigureBlocking(boolean blockMode) throws IOException {
        Object object = this.blockingLock();
        synchronized (object) {
            IoUtils.setBlocking(this.fd, blockMode);
        }
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public static class SocketChannelInputStream
    extends InputStream {
        public final SocketChannel channel;

        public SocketChannelInputStream(SocketChannel channel) {
            this.channel = channel;
        }

        public void close() throws IOException {
            this.channel.close();
        }

        public int read() throws IOException {
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            ByteBuffer buf = ByteBuffer.allocate(1);
            int result = this.channel.read(buf);
            return -1 == result ? result : buf.get(0) & 0xFF;
        }

        public int read(byte[] buffer, int offset, int byteCount) throws IOException {
            Arrays.checkOffsetAndCount((int)buffer.length, (int)offset, (int)byteCount);
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            ByteBuffer buf = ByteBuffer.wrap(buffer, offset, byteCount);
            return this.channel.read(buf);
        }
    }

    public static class SocketChannelOutputStream
    extends OutputStream {
        public final SocketChannel channel;

        public SocketChannelOutputStream(SocketChannel channel) {
            this.channel = channel;
        }

        public void close() throws IOException {
            this.channel.close();
        }

        public void write(byte[] buffer, int offset, int byteCount) throws IOException {
            Arrays.checkOffsetAndCount((int)buffer.length, (int)offset, (int)byteCount);
            ByteBuffer buf = ByteBuffer.wrap(buffer, offset, byteCount);
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            this.channel.write(buf);
        }

        public void write(int oneByte) throws IOException {
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put(0, (byte)(oneByte & 0xFF));
            this.channel.write(buffer);
        }
    }

    public static class SocketAdapter
    extends Socket {
        public final SocketChannelImpl channel;
        public final PlainSocketImpl socketImpl;

        public SocketAdapter(PlainSocketImpl socketImpl, SocketChannelImpl channel) throws SocketException {
            super(socketImpl);
            this.socketImpl = socketImpl;
            this.channel = channel;
            SocketUtils.setCreated(this);
        }

        public PlainSocketImpl socketImpl() {
            return this.socketImpl;
        }

        public SocketChannel getChannel() {
            return this.channel;
        }

        public boolean isBound() {
            return this.channel.isBound;
        }

        public boolean isConnected() {
            return this.channel.isConnected();
        }

        public InetAddress getLocalAddress() {
            try {
                return this.channel.getLocalAddress();
            }
            catch (UnknownHostException e) {
                return null;
            }
        }

        public void connect(SocketAddress remoteAddr, int timeout) throws IOException {
            if (!this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            if (this.isConnected()) {
                throw new AlreadyConnectedException();
            }
            super.connect(remoteAddr, timeout);
            this.channel.initLocalAddressAndPort();
            if (super.isConnected()) {
                this.channel.setConnected();
                this.channel.isBound = super.isBound();
            }
        }

        public void bind(SocketAddress localAddr) throws IOException {
            if (this.channel.isConnected()) {
                throw new AlreadyConnectedException();
            }
            if (1 == this.channel.status) {
                throw new ConnectionPendingException();
            }
            super.bind(localAddr);
            this.channel.isBound = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            SocketChannelImpl socketChannelImpl = this.channel;
            synchronized (socketChannelImpl) {
                if (this.channel.isOpen()) {
                    this.channel.close();
                } else {
                    super.close();
                }
                this.channel.status = 3;
            }
        }

        public OutputStream getOutputStream() throws IOException {
            this.checkOpenAndConnected();
            if (this.isOutputShutdown()) {
                throw new SocketException("Socket output is shutdown");
            }
            return new SocketChannelOutputStream(this.channel);
        }

        public InputStream getInputStream() throws IOException {
            this.checkOpenAndConnected();
            if (this.isInputShutdown()) {
                throw new SocketException("Socket input is shutdown");
            }
            return new SocketChannelInputStream(this.channel);
        }

        public void checkOpenAndConnected() throws SocketException {
            if (!this.channel.isOpen()) {
                throw new SocketException("Socket is closed");
            }
            if (!this.channel.isConnected()) {
                throw new SocketException("Socket is not connected");
            }
        }
    }
}

