/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FileChannelImpl;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;

public class WriteOnlyFileChannel
extends FileChannelImpl {
    public boolean append = false;

    public WriteOnlyFileChannel(Object stream, int handle) {
        super(stream, handle);
    }

    public WriteOnlyFileChannel(Object stream, int handle, boolean isAppend) {
        super(stream, handle);
        this.append = isAppend;
    }

    public long position() throws IOException {
        return this.append ? this.size() : super.position();
    }

    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        this.openCheck();
        if (!target.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new NonReadableChannelException();
    }

    public long read(ByteBuffer[] buffers, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount((int)buffers.length, (int)offset, (int)length);
        this.openCheck();
        throw new NonReadableChannelException();
    }

    public int read(ByteBuffer buffer) throws IOException {
        this.openCheck();
        throw new NonReadableChannelException();
    }

    public int read(ByteBuffer buffer, long position) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        throw new NonReadableChannelException();
    }

    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        this.openCheck();
        if (mode == null) {
            throw new NullPointerException();
        }
        if (position < 0L || size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        throw new NonReadableChannelException();
    }

    public int write(ByteBuffer buffer) throws IOException {
        if (this.append) {
            this.position(this.size());
        }
        return super.write(buffer);
    }

    public FileLock basicLock(long position, long size, boolean shared, boolean wait) throws IOException {
        if (shared) {
            throw new NonReadableChannelException();
        }
        return super.basicLock(position, size, shared, wait);
    }
}

