/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;

public class TimeZones {
    public static final String[] availableTimeZones = TimeZone.getAvailableIDs();

    public static String getDisplayName(String id2, boolean daylight, int style2, Locale locale) {
        String result;
        if (CachedTimeZones.locale.equals(locale) && (result = TimeZones.lookupDisplayName(CachedTimeZones.names, id2, daylight, style2)) != null) {
            return result;
        }
        return TimeZones.getDisplayNameImpl(id2, daylight, style2, locale.toString());
    }

    public static String lookupDisplayName(String[][] zoneStrings, String id2, boolean daylight, int style2) {
        for (String[] row : zoneStrings) {
            if (!row[0].equals(id2)) continue;
            if (daylight) {
                return style2 == 1 ? row[3] : row[4];
            }
            return style2 == 1 ? row[1] : row[2];
        }
        return null;
    }

    public static String[][] createZoneStringsFor(Locale locale) {
        long start = System.currentTimeMillis();
        String[][] arrayToFill = new String[][]{(String[])availableTimeZones.clone(), new String[availableTimeZones.length], new String[availableTimeZones.length], new String[availableTimeZones.length], new String[availableTimeZones.length]};
        TimeZones.getZoneStringsImpl(arrayToFill, locale.toString());
        HashMap<String, String> internTable = new HashMap<String, String>();
        String[][] result = new String[availableTimeZones.length][5];
        for (int i = 0; i < availableTimeZones.length; ++i) {
            result[i][0] = arrayToFill[0][i];
            for (int j = 1; j <= 4; ++j) {
                String original = arrayToFill[j][i];
                String nonDuplicate = (String)internTable.get(original);
                if (nonDuplicate == null) {
                    internTable.put(original, original);
                    nonDuplicate = original;
                }
                result[i][j] = nonDuplicate;
            }
        }
        long duration = System.currentTimeMillis() - start;
        Logger.global.info("Loaded time zone names for " + locale + " in " + duration + "ms.");
        return result;
    }

    public static String[][] getZoneStrings(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (CachedTimeZones.locale.equals(locale)) {
            return TimeZones.clone2dStringArray(CachedTimeZones.names);
        }
        return TimeZones.createZoneStringsFor(locale);
    }

    public static String[][] clone2dStringArray(String[][] array2) {
        String[][] result = new String[array2.length][];
        for (int i = 0; i < array2.length; ++i) {
            result[i] = (String[])array2[i].clone();
        }
        return result;
    }

    public static String[] forLocale(Locale locale) {
        return TimeZones.forCountryCode(locale.getCountry());
    }

    public static String[] forCountryCode(String string2) {
        return (String[])OverrideMethod.invokeA("libcore.icu.TimeZones#forCountryCode(Ljava/lang/String;)[Ljava/lang/String;", true, null);
    }

    public static void getZoneStringsImpl(String[][] stringArray, String string2) {
        OverrideMethod.invokeV("libcore.icu.TimeZones#getZoneStringsImpl([[Ljava/lang/String;Ljava/lang/String;)V", true, null);
    }

    public static String getDisplayNameImpl(String string2, boolean bl, int n, String string3) {
        return (String)OverrideMethod.invokeA("libcore.icu.TimeZones#getDisplayNameImpl(Ljava/lang/String;ZILjava/lang/String;)Ljava/lang/String;", true, null);
    }

    public static /* synthetic */ String[][] access$200(Locale x0) {
        return TimeZones.createZoneStringsFor(x0);
    }

    public static class CachedTimeZones {
        public static final Locale locale = Locale.getDefault();
        public static final String[][] names = TimeZones.access$200(locale);
    }
}

