/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.internal.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.charset.Charsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TimeZone;
import libcore.io.BufferIterator;
import libcore.io.IoUtils;
import libcore.io.MemoryMappedFile;
import org.apache.harmony.luni.internal.util.TimezoneGetter;
import org.apache.harmony.luni.internal.util.ZoneInfo;

public class ZoneInfoDB {
    public static final String ZONE_DIRECTORY_NAME = System.getenv("ANDROID_ROOT") + "/usr/share/zoneinfo/";
    public static final String ZONE_FILE_NAME = ZONE_DIRECTORY_NAME + "zoneinfo.dat";
    public static final String INDEX_FILE_NAME = ZONE_DIRECTORY_NAME + "zoneinfo.idx";
    public static final Object LOCK = new Object();
    public static final String VERSION = ZoneInfoDB.readVersion();
    public static String[] ids;
    public static int[] byteOffsets;
    public static int[] rawUtcOffsets;
    public static final MemoryMappedFile allZoneData;

    public static String readVersion() {
        try {
            byte[] bytes = IoUtils.readFileAsByteArray(ZONE_DIRECTORY_NAME + "zoneinfo.version");
            return new String(bytes, 0, bytes.length, Charsets.ISO_8859_1).trim();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void readIndex() {
        RandomAccessFile file = null;
        MemoryMappedFile mappedFile = null;
        try {
            file = new RandomAccessFile(INDEX_FILE_NAME, "r");
            mappedFile = MemoryMappedFile.mmap(file.getFD(), FileChannel.MapMode.READ_ONLY, 0L, file.length());
            ZoneInfoDB.readIndex(mappedFile);
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(mappedFile);
                IoUtils.closeQuietly(file);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(mappedFile);
        IoUtils.closeQuietly(file);
    }

    public static void readIndex(MemoryMappedFile mappedFile) throws IOException {
        BufferIterator it = mappedFile.bigEndianIterator();
        int SIZEOF_TZNAME = 40;
        int SIZEOF_TZINT = 4;
        byte[] idBytes = new byte[40];
        int numEntries = mappedFile.size() / 52;
        char[] idChars = new char[numEntries * 40];
        int[] idEnd = new int[numEntries];
        int idOffset = 0;
        byteOffsets = new int[numEntries];
        rawUtcOffsets = new int[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            it.readByteArray(idBytes, 0, idBytes.length);
            ZoneInfoDB.byteOffsets[i] = it.readInt();
            int length = it.readInt();
            if (length < 44) {
                throw new AssertionError((Object)"length in index file < sizeof(tzhead)");
            }
            ZoneInfoDB.rawUtcOffsets[i] = it.readInt();
            int len = idBytes.length;
            for (int j = 0; j < len && idBytes[j] != 0; ++j) {
                idChars[idOffset++] = (char)(idBytes[j] & 0xFF);
            }
            idEnd[i] = idOffset;
        }
        String allIds = new String(idChars, 0, idOffset);
        ids = new String[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            ZoneInfoDB.ids[i] = allIds.substring(i == 0 ? 0 : idEnd[i - 1], idEnd[i]);
        }
    }

    public static MemoryMappedFile mapData() {
        MemoryMappedFile memoryMappedFile;
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(ZONE_FILE_NAME, "r");
            memoryMappedFile = MemoryMappedFile.mmap(file.getFD(), FileChannel.MapMode.READ_ONLY, 0L, file.length());
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(file);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(file);
        return memoryMappedFile;
    }

    public static TimeZone makeTimeZone(String id2) throws IOException {
        int index = Arrays.binarySearch(ids, id2);
        if (index < 0) {
            return null;
        }
        BufferIterator data = allZoneData.bigEndianIterator();
        data.skip(byteOffsets[index]);
        if (data.readInt() != 1415211366) {
            return null;
        }
        data.skip(28);
        int tzh_timecnt = data.readInt();
        int tzh_typecnt = data.readInt();
        data.skip(4);
        int[] transitions = new int[tzh_timecnt];
        data.readIntArray(transitions, 0, transitions.length);
        byte[] type = new byte[tzh_timecnt];
        data.readByteArray(type, 0, type.length);
        int[] gmtOffsets = new int[tzh_typecnt];
        byte[] isDsts = new byte[tzh_typecnt];
        for (int i = 0; i < tzh_typecnt; ++i) {
            gmtOffsets[i] = data.readInt();
            isDsts[i] = data.readByte();
            data.skip(1);
        }
        return new ZoneInfo(id2, transitions, type, gmtOffsets, isDsts);
    }

    public static String[] getAvailableIDs() {
        return (String[])ids.clone();
    }

    public static String[] getAvailableIDs(int rawOffset) {
        ArrayList<String> matches = new ArrayList<String>();
        int end = rawUtcOffsets.length;
        for (int i = 0; i < end; ++i) {
            if (rawUtcOffsets[i] != rawOffset) continue;
            matches.add(ids[i]);
        }
        return matches.toArray(new String[matches.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeZone getSystemDefault() {
        Object object = LOCK;
        synchronized (object) {
            String zoneName;
            TimezoneGetter tzGetter = TimezoneGetter.getInstance();
            String string2 = zoneName = tzGetter != null ? tzGetter.getId() : null;
            if (zoneName != null) {
                zoneName = zoneName.trim();
            }
            if (zoneName == null || zoneName.isEmpty()) {
                zoneName = "localtime";
            }
            return TimeZone.getTimeZone(zoneName);
        }
    }

    public static TimeZone getTimeZone(String id2) {
        if (id2 == null) {
            return null;
        }
        try {
            return ZoneInfoDB.makeTimeZone(id2);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    static {
        ZoneInfoDB.readIndex();
        allZoneData = ZoneInfoDB.mapData();
    }
}

