/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.harmony.xml.ExpatParser;
import org.apache.harmony.xml.ExpatReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ExpatPullParser
implements XmlPullParser {
    public static final String FEATURE_RELAXED = "http://xmlpull.org/v1/doc/features.html#relaxed";
    public static final int BUFFER_SIZE = 8096;
    public static final String NOT_A_START_TAG = "This is not a start tag.";
    public Document document;
    public boolean processNamespaces = false;
    public boolean relaxed = false;

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        if (name == null) {
            throw new IllegalArgumentException("Null feature name");
        }
        if (name.equals("http://xmlpull.org/v1/doc/features.html#process-namespaces")) {
            this.processNamespaces = state;
            return;
        }
        if (name.equals(FEATURE_RELAXED)) {
            this.relaxed = true;
            return;
        }
        if (!state && (name.equals("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes") || name.equals("http://xmlpull.org/v1/doc/features.html#process-docdecl") || name.equals("http://xmlpull.org/v1/doc/features.html#validation"))) {
            return;
        }
        throw new XmlPullParserException("Unsupported feature: " + name);
    }

    public boolean getFeature(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null feature name");
        }
        return name.equals("http://xmlpull.org/v1/doc/features.html#process-namespaces") && this.processNamespaces;
    }

    public boolean isNamespaceProcessingEnabled() {
        return this.processNamespaces;
    }

    public void setNamespaceProcessingEnabled(boolean processNamespaces) {
        this.processNamespaces = processNamespaces;
    }

    public void setProperty(String name, Object value) throws XmlPullParserException {
        if (name == null) {
            throw new IllegalArgumentException("Null feature name");
        }
        throw new XmlPullParserException("Properties aren't supported.");
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setInput(Reader in) throws XmlPullParserException {
        this.document = new CharDocument(in, this.processNamespaces);
    }

    public void setInput(InputStream in, String encodingName) throws XmlPullParserException {
        this.document = new ByteDocument(in, encodingName, this.processNamespaces);
    }

    public String getInputEncoding() {
        return this.document.getEncoding();
    }

    public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public int getNamespaceCount(int depth) throws XmlPullParserException {
        return this.document.currentEvent.namespaceStack.countAt(depth);
    }

    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        String prefix = this.document.currentEvent.namespaceStack.prefixAt(pos);
        boolean hasPrefix = prefix != "";
        return hasPrefix ? prefix : null;
    }

    public String getNamespaceUri(int pos) throws XmlPullParserException {
        return this.document.currentEvent.namespaceStack.uriAt(pos);
    }

    public String getNamespace(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return this.document.currentEvent.namespaceStack.uriFor(prefix);
    }

    public int getDepth() {
        return this.document.getDepth();
    }

    public String getPositionDescription() {
        return "line " + this.getLineNumber() + ", column " + this.getColumnNumber();
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this.getEventType() != 4) {
            throw new XmlPullParserException("Not on text.");
        }
        String text = this.getText();
        if (text.length() == 0) {
            return true;
        }
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String getText() {
        StringBuilder builder = this.document.currentEvent.getText();
        return builder == null ? null : builder.toString();
    }

    public char[] getTextCharacters(int[] holderForStartAndLength) {
        StringBuilder builder = this.document.currentEvent.getText();
        int length = builder.length();
        char[] characters = new char[length];
        builder.getChars(0, length, characters, 0);
        holderForStartAndLength[0] = 0;
        holderForStartAndLength[1] = length;
        return characters;
    }

    public String getNamespace() {
        return this.document.currentEvent.getNamespace();
    }

    public String getName() {
        return this.document.currentEvent.getName();
    }

    public String getPrefix() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        return this.document.isCurrentElementEmpty();
    }

    public int getAttributeCount() {
        return this.document.currentEvent.getAttributeCount();
    }

    public String getAttributeNamespace(int index) {
        return this.document.currentEvent.getAttributeNamespace(index);
    }

    public String getAttributeName(int index) {
        return this.document.currentEvent.getAttributeName(index);
    }

    public String getAttributePrefix(int index) {
        throw new UnsupportedOperationException();
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        return false;
    }

    public String getAttributeValue(int index) {
        return this.document.currentEvent.getAttributeValue(index);
    }

    public String getAttributeValue(String namespace, String name) {
        return this.document.currentEvent.getAttributeValue(namespace, name);
    }

    public int getEventType() throws XmlPullParserException {
        return this.document.currentEvent.getType();
    }

    public int next() throws XmlPullParserException, IOException {
        return this.document.dequeue();
    }

    public int nextToken() throws XmlPullParserException, IOException {
        throw new UnsupportedOperationException();
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new XmlPullParserException("expected " + TYPES[type] + this.getPositionDescription());
        }
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.document.currentEvent.getType() != 2) {
            throw new XmlPullParserException("Not on start tag.");
        }
        int next = this.document.dequeue();
        switch (next) {
            case 4: {
                return this.getText();
            }
            case 3: {
                return "";
            }
        }
        throw new XmlPullParserException("Unexpected event type: " + TYPES[next]);
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int eventType = this.next();
        if (eventType == 4 && this.isWhitespace()) {
            eventType = this.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("Expected start or end tag", this, null);
        }
        return eventType;
    }

    public static class 1 {
    }

    public class ByteDocument
    extends Document {
        public final byte[] buffer;
        public final InputStream in;

        public ByteDocument(InputStream in, String encoding, boolean processNamespaces) {
            super(encoding, processNamespaces);
            this.buffer = new byte[8096];
            this.in = in;
        }

        public int buffer() throws IOException {
            return this.in.read(this.buffer);
        }

        public void flush(ExpatParser parser, int length) throws XmlPullParserException {
            try {
                parser.append(this.buffer, 0, length);
            }
            catch (SAXException e) {
                throw new XmlPullParserException("Error parsing document.", ExpatPullParser.this, e);
            }
        }
    }

    public class CharDocument
    extends Document {
        public final char[] buffer;
        public final Reader in;

        public CharDocument(Reader in, boolean processNamespaces) {
            super("UTF-16", processNamespaces);
            this.buffer = new char[4048];
            this.in = in;
        }

        public int buffer() throws IOException {
            return this.in.read(this.buffer);
        }

        public void flush(ExpatParser parser, int length) throws XmlPullParserException {
            try {
                parser.append(this.buffer, 0, length);
            }
            catch (SAXException e) {
                throw new XmlPullParserException("Error parsing document.", ExpatPullParser.this, e);
            }
        }
    }

    public abstract class Document {
        public final String encoding;
        public final ExpatParser parser;
        public final boolean processNamespaces;
        public TextEvent textEvent = null;
        public boolean finished = false;
        public NamespaceStack.Builder namespaceStackBuilder = new NamespaceStack.Builder();
        public Event currentEvent;
        public Event last = this.currentEvent = new StartDocumentEvent();

        public Document(String encoding, boolean processNamespaces) {
            this.encoding = encoding;
            this.processNamespaces = processNamespaces;
            ExpatReader xmlReader = new ExpatReader();
            xmlReader.setContentHandler(new SaxHandler(null));
            this.parser = new ExpatParser(encoding, xmlReader, processNamespaces, null, null);
        }

        public void pump() throws IOException, XmlPullParserException {
            if (this.finished) {
                return;
            }
            int length = this.buffer();
            if (length == -1) {
                this.finished = true;
                if (!ExpatPullParser.this.relaxed) {
                    try {
                        this.parser.finish();
                    }
                    catch (SAXException e) {
                        throw new XmlPullParserException("Premature end of document.", ExpatPullParser.this, e);
                    }
                }
                this.add(new EndDocumentEvent());
                return;
            }
            if (length == 0) {
                return;
            }
            this.flush(this.parser, length);
        }

        public abstract int buffer() throws IOException;

        public abstract void flush(ExpatParser var1, int var2) throws XmlPullParserException;

        public void add(Event event) {
            if (this.textEvent != null) {
                this.last.setNext(this.textEvent);
                this.last = this.textEvent;
                this.textEvent = null;
            }
            this.last.setNext(event);
            this.last = event;
        }

        public int dequeue() throws XmlPullParserException, IOException {
            Event next;
            while ((next = this.currentEvent.getNext()) == null) {
                this.pump();
            }
            this.currentEvent.next = null;
            this.currentEvent = next;
            return this.currentEvent.getType();
        }

        public String getEncoding() {
            return this.encoding;
        }

        public int getDepth() {
            return this.currentEvent.getDepth();
        }

        public boolean isCurrentElementEmpty() throws XmlPullParserException {
            Event next;
            if (this.currentEvent.getType() != 2) {
                throw new XmlPullParserException(ExpatPullParser.NOT_A_START_TAG);
            }
            try {
                while ((next = this.currentEvent.getNext()) == null) {
                    this.pump();
                }
            }
            catch (IOException ex) {
                throw new XmlPullParserException(ex.toString());
            }
            return next.getType() == 3;
        }

        public class SaxHandler
        implements ContentHandler {
            public int depth = 0;

            public SaxHandler() {
            }

            public void startPrefixMapping(String prefix, String uri) throws SAXException {
                Document.this.namespaceStackBuilder.push(prefix, uri, this.depth + 1);
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                String name = Document.this.processNamespaces ? localName : qName;
                Document.this.add(new StartTagEvent(uri, name, Document.this.parser, ++this.depth, Document.this.namespaceStackBuilder.build(), Document.this.processNamespaces));
            }

            public void endElement(String uri, String localName, String qName) {
                String name = Document.this.processNamespaces ? localName : qName;
                int depth = this.depth--;
                Document.this.add(new EndTagEvent(uri, name, depth, Document.this.namespaceStackBuilder.build()));
                Document.this.namespaceStackBuilder.pop(depth);
            }

            public void characters(char[] ch, int start, int length) {
                if (length == 0) {
                    return;
                }
                if (Document.this.textEvent == null) {
                    Document.this.textEvent = new TextEvent(length, this.depth, Document.this.namespaceStackBuilder.build());
                }
                Document.this.textEvent.append(ch, start, length);
            }

            public void setDocumentLocator(Locator locator) {
            }

            public void startDocument() throws SAXException {
            }

            public void endDocument() throws SAXException {
            }

            public void endPrefixMapping(String prefix) throws SAXException {
            }

            public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            }

            public void processingInstruction(String target, String data) throws SAXException {
            }

            public void skippedEntity(String name) throws SAXException {
            }

            public /* synthetic */ SaxHandler(1 x1) {
                this();
            }
        }
    }

    public static class EndDocumentEvent
    extends Event {
        public EndDocumentEvent() {
            super(0, NamespaceStack.EMPTY);
        }

        public Event getNext() {
            throw new IllegalStateException("End of document.");
        }

        public void setNext(Event next) {
            throw new IllegalStateException("End of document.");
        }

        public int getType() {
            return 1;
        }
    }

    public static class TextEvent
    extends Event {
        public final StringBuilder builder;

        public TextEvent(int initialCapacity, int depth, NamespaceStack namespaceStack) {
            super(depth, namespaceStack);
            this.builder = new StringBuilder(initialCapacity);
        }

        public int getType() {
            return 4;
        }

        public StringBuilder getText() {
            return this.builder;
        }

        public void append(char[] text, int start, int length) {
            this.builder.append(text, start, length);
        }
    }

    public static class EndTagEvent
    extends Event {
        public final String namespace;
        public final String localName;

        public EndTagEvent(String namespace, String localName, int depth, NamespaceStack namespaceStack) {
            super(depth, namespaceStack);
            this.namespace = namespace;
            this.localName = localName;
        }

        public String getName() {
            return this.localName;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public int getType() {
            return 3;
        }
    }

    public static class StartTagEvent
    extends Event {
        public final String name;
        public final String namespace;
        public final Attributes attributes;
        public final boolean processNamespaces;

        public StartTagEvent(String namespace, String name, ExpatParser expatParser, int depth, NamespaceStack namespaceStack, boolean processNamespaces) {
            super(depth, namespaceStack);
            this.namespace = namespace;
            this.name = name;
            this.attributes = expatParser.cloneAttributes();
            this.processNamespaces = processNamespaces;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public int getAttributeCount() {
            return this.attributes.getLength();
        }

        public String getAttributeNamespace(int index) {
            return this.attributes.getURI(index);
        }

        public String getAttributeName(int index) {
            return this.processNamespaces ? this.attributes.getLocalName(index) : this.attributes.getQName(index);
        }

        public String getAttributeValue(int index) {
            return this.attributes.getValue(index);
        }

        public String getAttributeValue(String namespace, String name) {
            if (namespace == null) {
                namespace = "";
            }
            return this.attributes.getValue(namespace, name);
        }

        public int getType() {
            return 2;
        }
    }

    public static class StartDocumentEvent
    extends Event {
        public StartDocumentEvent() {
            super(0, NamespaceStack.EMPTY);
        }

        public int getType() {
            return 0;
        }
    }

    public static abstract class Event {
        public final int depth;
        public final NamespaceStack namespaceStack;
        public Event next = null;

        public Event(int depth, NamespaceStack namespaceStack) {
            this.depth = depth;
            this.namespaceStack = namespaceStack;
        }

        public void setNext(Event next) {
            this.next = next;
        }

        public Event getNext() {
            return this.next;
        }

        public StringBuilder getText() {
            return null;
        }

        public String getNamespace() {
            return null;
        }

        public String getName() {
            return null;
        }

        public int getAttributeCount() {
            return -1;
        }

        public String getAttributeNamespace(int index) {
            throw new IndexOutOfBoundsException(ExpatPullParser.NOT_A_START_TAG);
        }

        public String getAttributeName(int index) {
            throw new IndexOutOfBoundsException(ExpatPullParser.NOT_A_START_TAG);
        }

        public String getAttributeValue(int index) {
            throw new IndexOutOfBoundsException(ExpatPullParser.NOT_A_START_TAG);
        }

        public abstract int getType();

        public String getAttributeValue(String namespace, String name) {
            throw new IndexOutOfBoundsException(ExpatPullParser.NOT_A_START_TAG);
        }

        public int getDepth() {
            return this.depth;
        }
    }

    public static class NamespaceStack {
        public static final NamespaceStack EMPTY = new NamespaceStack();
        public final NamespaceStack parent;
        public final String prefix;
        public final String uri;
        public final int index;
        public final int depth;

        public NamespaceStack(NamespaceStack parent, String prefix, String uri, int depth) {
            this.parent = parent;
            this.prefix = prefix;
            this.uri = uri;
            this.index = parent.index + 1;
            this.depth = depth;
        }

        public NamespaceStack() {
            this.parent = null;
            this.prefix = null;
            this.uri = null;
            this.index = -1;
            this.depth = 0;
        }

        public String uriFor(String prefix) {
            NamespaceStack node = this;
            while (node.index >= 0) {
                if (node.prefix.equals(prefix)) {
                    return node.uri;
                }
                node = node.parent;
            }
            return null;
        }

        public String prefixAt(int index) {
            return this.nodeAt((int)index).prefix;
        }

        public String uriAt(int index) {
            return this.nodeAt((int)index).uri;
        }

        public NamespaceStack nodeAt(int index) {
            if (index > this.index) {
                throw new IndexOutOfBoundsException("Index > size.");
            }
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index < 0.");
            }
            NamespaceStack node = this;
            while (index != node.index) {
                node = node.parent;
            }
            return node;
        }

        public int countAt(int depth) {
            if (depth > this.depth) {
                throw new IndexOutOfBoundsException("Depth > maximum.");
            }
            if (depth < 0) {
                throw new IndexOutOfBoundsException("Depth < 0.");
            }
            NamespaceStack node = this;
            while (depth < node.depth) {
                node = node.parent;
            }
            return node.index + 1;
        }

        public /* synthetic */ NamespaceStack(NamespaceStack x0, String x1, String x2, int x3, 1 x4) {
            this(x0, x1, x2, x3);
        }

        public static class Builder {
            public NamespaceStack top = EMPTY;

            public void push(String prefix, String uri, int depth) {
                this.top = new NamespaceStack(this.top, prefix, uri, depth, null);
            }

            public void pop(int depth) {
                while (this.top != null && this.top.depth == depth) {
                    this.top = this.top.parent;
                }
            }

            public NamespaceStack build() {
                return this.top;
            }
        }
    }
}

