/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.harmony.xnet.provider.jsse.CipherSuite;
import org.apache.harmony.xnet.provider.jsse.ClientSessionContext;
import org.apache.harmony.xnet.provider.jsse.ProtocolVersion;
import org.apache.harmony.xnet.provider.jsse.ServerSessionContext;

public class SSLParametersImpl
implements Cloneable {
    public static volatile X509KeyManager defaultKeyManager;
    public static volatile X509TrustManager defaultTrustManager;
    public static volatile SecureRandom defaultSecureRandom;
    public static volatile SSLParametersImpl defaultParameters;
    public final ClientSessionContext clientSessionContext;
    public final ServerSessionContext serverSessionContext;
    public X509KeyManager keyManager;
    public X509TrustManager trustManager;
    public SecureRandom secureRandom;
    public CipherSuite[] enabledCipherSuites;
    public String[] enabledCipherSuiteNames = null;
    public String[] enabledProtocols = ProtocolVersion.supportedProtocols;
    public boolean client_mode = true;
    public boolean need_client_auth = false;
    public boolean want_client_auth = false;
    public boolean enable_session_creation = true;

    public CipherSuite[] getEnabledCipherSuitesMember() {
        if (this.enabledCipherSuites == null) {
            this.enabledCipherSuites = CipherSuite.DEFAULT_CIPHER_SUITES;
        }
        return this.enabledCipherSuites;
    }

    public SSLParametersImpl(KeyManager[] kms, TrustManager[] tms, SecureRandom sr, ClientSessionContext clientSessionContext, ServerSessionContext serverSessionContext) throws KeyManagementException {
        this.serverSessionContext = serverSessionContext;
        this.clientSessionContext = clientSessionContext;
        this.keyManager = kms == null || kms.length == 0 ? SSLParametersImpl.getDefaultKeyManager() : SSLParametersImpl.findX509KeyManager(kms);
        if (this.keyManager == null) {
            throw new KeyManagementException("No X509KeyManager found");
        }
        this.trustManager = tms == null || tms.length == 0 ? SSLParametersImpl.getDefaultTrustManager() : SSLParametersImpl.findX509TrustManager(tms);
        if (this.trustManager == null) {
            throw new KeyManagementException("No X509TrustManager found");
        }
        this.secureRandom = sr;
    }

    public static SSLParametersImpl getDefault() throws KeyManagementException {
        SSLParametersImpl result = defaultParameters;
        if (result == null) {
            defaultParameters = result = new SSLParametersImpl(null, null, null, new ClientSessionContext(), new ServerSessionContext());
        }
        return (SSLParametersImpl)result.clone();
    }

    public ServerSessionContext getServerSessionContext() {
        return this.serverSessionContext;
    }

    public ClientSessionContext getClientSessionContext() {
        return this.clientSessionContext;
    }

    public X509KeyManager getKeyManager() {
        return this.keyManager;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public SecureRandom getSecureRandom() {
        if (this.secureRandom != null) {
            return this.secureRandom;
        }
        SecureRandom result = defaultSecureRandom;
        if (result == null) {
            defaultSecureRandom = result = new SecureRandom();
        }
        this.secureRandom = result;
        return this.secureRandom;
    }

    public SecureRandom getSecureRandomMember() {
        return this.secureRandom;
    }

    public String[] getEnabledCipherSuites() {
        if (this.enabledCipherSuiteNames == null) {
            CipherSuite[] enabledCipherSuites = this.getEnabledCipherSuitesMember();
            this.enabledCipherSuiteNames = new String[enabledCipherSuites.length];
            for (int i = 0; i < enabledCipherSuites.length; ++i) {
                this.enabledCipherSuiteNames[i] = enabledCipherSuites[i].getName();
            }
        }
        return (String[])this.enabledCipherSuiteNames.clone();
    }

    public void setEnabledCipherSuites(String[] suites) {
        if (suites == null) {
            throw new IllegalArgumentException("suites == null");
        }
        CipherSuite[] cipherSuites = new CipherSuite[suites.length];
        for (int i = 0; i < suites.length; ++i) {
            String suite = suites[i];
            if (suite == null) {
                throw new IllegalArgumentException("suites[" + i + "] == null");
            }
            cipherSuites[i] = CipherSuite.getByName(suite);
            if (cipherSuites[i] != null && cipherSuites[i].supported) continue;
            throw new IllegalArgumentException(suite + " is not supported.");
        }
        this.enabledCipherSuites = cipherSuites;
        this.enabledCipherSuiteNames = suites;
    }

    public String[] getEnabledProtocols() {
        return (String[])this.enabledProtocols.clone();
    }

    public void setEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException("protocols == null");
        }
        for (int i = 0; i < protocols.length; ++i) {
            String protocol = protocols[i];
            if (protocol == null) {
                throw new IllegalArgumentException("protocols[" + i + "] == null");
            }
            if (ProtocolVersion.isSupported(protocol)) continue;
            throw new IllegalArgumentException("Protocol " + protocol + " is not supported.");
        }
        this.enabledProtocols = protocols;
    }

    public void setUseClientMode(boolean mode) {
        this.client_mode = mode;
    }

    public boolean getUseClientMode() {
        return this.client_mode;
    }

    public void setNeedClientAuth(boolean need) {
        this.need_client_auth = need;
        this.want_client_auth = false;
    }

    public boolean getNeedClientAuth() {
        return this.need_client_auth;
    }

    public void setWantClientAuth(boolean want) {
        this.want_client_auth = want;
        this.need_client_auth = false;
    }

    public boolean getWantClientAuth() {
        return this.want_client_auth;
    }

    public void setEnableSessionCreation(boolean flag) {
        this.enable_session_creation = flag;
    }

    public boolean getEnableSessionCreation() {
        return this.enable_session_creation;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static X509KeyManager getDefaultKeyManager() {
        X509KeyManager result = defaultKeyManager;
        if (result == null) {
            defaultKeyManager = result = SSLParametersImpl.createDefaultKeyManager();
        }
        return result;
    }

    public static X509KeyManager createDefaultKeyManager() {
        try {
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(null, null);
            KeyManager[] kms = kmf.getKeyManagers();
            return SSLParametersImpl.findX509KeyManager(kms);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (KeyStoreException e) {
            return null;
        }
        catch (UnrecoverableKeyException e) {
            return null;
        }
    }

    public static X509KeyManager findX509KeyManager(KeyManager[] kms) {
        for (KeyManager km : kms) {
            if (!(km instanceof X509KeyManager)) continue;
            return (X509KeyManager)km;
        }
        return null;
    }

    public static X509TrustManager getDefaultTrustManager() {
        X509TrustManager result = defaultTrustManager;
        if (result == null) {
            defaultTrustManager = result = SSLParametersImpl.createDefaultTrustManager();
        }
        return result;
    }

    public static X509TrustManager createDefaultTrustManager() {
        try {
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init((KeyStore)null);
            TrustManager[] tms = tmf.getTrustManagers();
            X509TrustManager trustManager = SSLParametersImpl.findX509TrustManager(tms);
            return trustManager;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    public static X509TrustManager findX509TrustManager(TrustManager[] tms) {
        for (TrustManager tm : tms) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }
}

