/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import javax.net.ssl.SSLProtocolException;
import org.apache.harmony.xnet.provider.jsse.AlertException;
import org.apache.harmony.xnet.provider.jsse.AlertProtocol;
import org.apache.harmony.xnet.provider.jsse.Appendable;
import org.apache.harmony.xnet.provider.jsse.ConnectionState;
import org.apache.harmony.xnet.provider.jsse.ConnectionStateSSLv3;
import org.apache.harmony.xnet.provider.jsse.ConnectionStateTLS;
import org.apache.harmony.xnet.provider.jsse.DataStream;
import org.apache.harmony.xnet.provider.jsse.HandshakeProtocol;
import org.apache.harmony.xnet.provider.jsse.Logger;
import org.apache.harmony.xnet.provider.jsse.SSLInputStream;
import org.apache.harmony.xnet.provider.jsse.SSLSessionImpl;

public class SSLRecordProtocol {
    public static final int MAX_DATA_LENGTH = 16384;
    public static final int MAX_COMPRESSED_DATA_LENGTH = 17408;
    public static final int MAX_CIPHERED_DATA_LENGTH = 18432;
    public static final int MAX_SSL_PACKET_SIZE = 18437;
    public SSLSessionImpl session;
    public byte[] version;
    public SSLInputStream in;
    public HandshakeProtocol handshakeProtocol;
    public AlertProtocol alertProtocol;
    public Appendable appData;
    public ConnectionState activeReadState;
    public ConnectionState activeWriteState;
    public ConnectionState pendingConnectionState;
    public Logger.Stream logger = Logger.getStream("record");
    public boolean sessionWasChanged = false;
    public static final byte[] change_cipher_spec_byte = new byte[]{1};

    public SSLRecordProtocol(HandshakeProtocol handshakeProtocol, AlertProtocol alertProtocol, SSLInputStream in, Appendable appData) {
        this.handshakeProtocol = handshakeProtocol;
        this.handshakeProtocol.setRecordProtocol(this);
        this.alertProtocol = alertProtocol;
        this.alertProtocol.setRecordProtocol(this);
        this.in = in;
        this.appData = appData;
    }

    public SSLSessionImpl getSession() {
        return this.session;
    }

    public int getMinRecordSize() {
        return this.activeReadState == null ? 6 : 5 + this.activeReadState.getMinFragmentSize();
    }

    public int getRecordSize(int data_size) {
        if (this.activeWriteState == null) {
            return 5 + data_size;
        }
        int res = 5 + this.activeWriteState.getFragmentSize(data_size);
        return res > 18432 ? 18432 : res;
    }

    public int getDataSize(int record_size) {
        if ((record_size -= 5) > 18432) {
            return 16384;
        }
        if (this.activeReadState == null) {
            return record_size;
        }
        return this.activeReadState.getContentSize(record_size);
    }

    public byte[] wrap(byte content_type, DataStream dataStream) {
        byte[] fragment = dataStream.getData(16384);
        return this.wrap(content_type, fragment, 0, fragment.length);
    }

    public byte[] wrap(byte content_type, byte[] fragment, int offset, int len) {
        if (this.logger != null) {
            this.logger.println("SSLRecordProtocol.wrap: TLSPlaintext.fragment[" + len + "]:");
            this.logger.print(fragment, offset, len);
        }
        if (len > 16384) {
            throw new AlertException(80, new SSLProtocolException("The provided chunk of data is too big: " + len + " > MAX_DATA_LENGTH == " + 16384));
        }
        byte[] ciphered_fragment = fragment;
        if (this.activeWriteState != null) {
            ciphered_fragment = this.activeWriteState.encrypt(content_type, fragment, offset, len);
            if (ciphered_fragment.length > 18432) {
                throw new AlertException(80, new SSLProtocolException("The ciphered data increased more than on 1024 bytes"));
            }
            if (this.logger != null) {
                this.logger.println("SSLRecordProtocol.wrap: TLSCiphertext.fragment[" + ciphered_fragment.length + "]:");
                this.logger.print(ciphered_fragment);
            }
        }
        return this.packetize(content_type, this.version, ciphered_fragment);
    }

    public byte[] packetize(byte type, byte[] version, byte[] fragment) {
        byte[] buff = new byte[5 + fragment.length];
        buff[0] = type;
        if (version != null) {
            buff[1] = version[0];
            buff[2] = version[1];
        } else {
            buff[1] = 3;
            buff[2] = 1;
        }
        buff[3] = (byte)((0xFF00 & fragment.length) >> 8);
        buff[4] = (byte)(0xFF & fragment.length);
        System.arraycopy(fragment, 0, buff, 5, fragment.length);
        return buff;
    }

    public void setSession(SSLSessionImpl session) {
        if (!this.sessionWasChanged) {
            if (this.logger != null) {
                this.logger.println("SSLRecordProtocol.setSession: Set pending session");
                this.logger.println("  cipher name: " + session.getCipherSuite());
            }
            this.session = session;
            this.pendingConnectionState = this.version == null || this.version[1] == 1 ? new ConnectionStateTLS(this.getSession()) : new ConnectionStateSSLv3(this.getSession());
            this.sessionWasChanged = true;
        } else {
            this.sessionWasChanged = false;
        }
    }

    public byte[] getChangeCipherSpecMesage(SSLSessionImpl session) {
        byte[] change_cipher_spec_message = this.activeWriteState == null ? new byte[]{20, this.version[0], this.version[1], 0, 1, 1} : this.packetize((byte)20, this.version, this.activeWriteState.encrypt((byte)20, change_cipher_spec_byte, 0, 1));
        this.setSession(session);
        this.activeWriteState = this.pendingConnectionState;
        if (this.logger != null) {
            this.logger.println("SSLRecordProtocol.getChangeCipherSpecMesage");
            this.logger.println("activeWriteState = pendingConnectionState");
            this.logger.print(change_cipher_spec_message);
        }
        return change_cipher_spec_message;
    }

    public int unwrap() throws IOException {
        int type;
        if (this.logger != null) {
            this.logger.println("SSLRecordProtocol.unwrap: BEGIN [");
        }
        if ((type = this.in.readUint8()) < 20 || type > 23) {
            if (this.logger != null) {
                this.logger.println("Non v3.1 message type:" + type);
            }
            if (type >= 128) {
                int length = (type & 0x7F) << 8 | this.in.read();
                byte[] fragment = this.in.read(length);
                this.handshakeProtocol.unwrapSSLv2(fragment);
                if (this.logger != null) {
                    this.logger.println("SSLRecordProtocol:unwrap ] END, SSLv2 type");
                }
                return 22;
            }
            throw new AlertException(10, new SSLProtocolException("Unexpected message type has been received: " + type));
        }
        if (this.logger != null) {
            this.logger.println("Got the message of type: " + type);
        }
        if (this.version != null) {
            if (this.in.read() != this.version[0] || this.in.read() != this.version[1]) {
                throw new AlertException(10, new SSLProtocolException("Unexpected message type has been received: " + type));
            }
        } else {
            this.in.skip(2L);
        }
        int length = this.in.readUint16();
        if (this.logger != null) {
            this.logger.println("TLSCiphertext.fragment[" + length + "]: ...");
        }
        if (length > 18432) {
            throw new AlertException(22, new SSLProtocolException("Received message is too big."));
        }
        byte[] fragment = this.in.read(length);
        if (this.logger != null) {
            this.logger.print(fragment);
        }
        if (this.activeReadState != null) {
            fragment = this.activeReadState.decrypt((byte)type, fragment);
            if (this.logger != null) {
                this.logger.println("TLSPlaintext.fragment:");
                this.logger.print(fragment);
            }
        }
        if (fragment.length > 16384) {
            throw new AlertException(30, new SSLProtocolException("Decompressed plain data is too big."));
        }
        switch (type) {
            case 20: {
                this.handshakeProtocol.receiveChangeCipherSpec();
                this.setSession(this.handshakeProtocol.getSession());
                if (this.logger != null) {
                    this.logger.println("activeReadState = pendingConnectionState");
                }
                this.activeReadState = this.pendingConnectionState;
                break;
            }
            case 21: {
                this.alert(fragment[0], fragment[1]);
                break;
            }
            case 22: {
                this.handshakeProtocol.unwrap(fragment);
                break;
            }
            case 23: {
                if (this.logger != null) {
                    this.logger.println("TLSCiphertext.unwrap: APP DATA[" + length + "]:");
                    this.logger.println(new String(fragment));
                }
                this.appData.append(fragment);
                break;
            }
            default: {
                throw new AlertException(10, new SSLProtocolException("Unexpected message type has been received: " + type));
            }
        }
        if (this.logger != null) {
            this.logger.println("SSLRecordProtocol:unwrap ] END, type: " + type);
        }
        return type;
    }

    public void alert(byte level, byte description) {
        if (this.logger != null) {
            this.logger.println("SSLRecordProtocol.allert: " + level + " " + description);
        }
        this.alertProtocol.alert(level, description);
    }

    public void setVersion(byte[] ver) {
        this.version = ver;
    }

    public void shutdown() {
        this.session = null;
        this.version = null;
        this.in = null;
        this.handshakeProtocol = null;
        this.alertProtocol = null;
        this.appData = null;
        if (this.pendingConnectionState != null) {
            this.pendingConnectionState.shutdown();
        }
        this.pendingConnectionState = null;
        if (this.activeReadState != null) {
            this.activeReadState.shutdown();
        }
        this.activeReadState = null;
        if (this.activeReadState != null) {
            this.activeReadState.shutdown();
        }
        this.activeWriteState = null;
    }
}

