/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHealth;
import android.bluetooth.BluetoothInputDevice;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Pair;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothAdapter {
    private static final String TAG = "BluetoothAdapter";
    private static final boolean DBG = false;
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    public static final String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static final int STATE_OFF = 10;
    public static final int STATE_TURNING_ON = 11;
    public static final int STATE_ON = 12;
    public static final int STATE_TURNING_OFF = 13;
    public static final String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";
    public static final String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";
    public static final String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";
    public static final String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";
    public static final String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";
    public static final String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";
    public static final int SCAN_MODE_NONE = 20;
    public static final int SCAN_MODE_CONNECTABLE = 21;
    public static final int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23;
    public static final String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";
    public static final String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";
    public static final String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static final String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED";
    public static final String EXTRA_CONNECTION_STATE = "android.bluetooth.adapter.extra.CONNECTION_STATE";
    public static final String EXTRA_PREVIOUS_CONNECTION_STATE = "android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    public static final String BLUETOOTH_SERVICE = "bluetooth";
    private static final int ADDRESS_LENGTH = 17;
    private static BluetoothAdapter sAdapter;
    private final IBluetooth mService;
    private Handler mServiceRecordHandler;

    public static synchronized BluetoothAdapter getDefaultAdapter() {
        IBinder b;
        if (sAdapter == null && (b = ServiceManager.getService(BLUETOOTH_SERVICE)) != null) {
            IBluetooth service = IBluetooth.Stub.asInterface(b);
            sAdapter = new BluetoothAdapter(service);
        }
        return sAdapter;
    }

    public BluetoothAdapter(IBluetooth service) {
        if (service == null) {
            throw new IllegalArgumentException("service is null");
        }
        this.mService = service;
        this.mServiceRecordHandler = null;
    }

    public BluetoothDevice getRemoteDevice(String address) {
        return new BluetoothDevice(address);
    }

    public boolean isEnabled() {
        try {
            return this.mService.isEnabled();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public int getState() {
        try {
            return this.mService.getBluetoothState();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return 10;
        }
    }

    public boolean enable() {
        try {
            return this.mService.enable();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean disable() {
        try {
            return this.mService.disable(true);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public String getAddress() {
        try {
            return this.mService.getAddress();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String getName() {
        try {
            return this.mService.getName();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public ParcelUuid[] getUuids() {
        if (this.getState() != 12) {
            return null;
        }
        try {
            return this.mService.getUuids();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public boolean setName(String name) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return this.mService.setName(name);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public int getScanMode() {
        if (this.getState() != 12) {
            return 20;
        }
        try {
            return this.mService.getScanMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return 20;
        }
    }

    public boolean setScanMode(int mode, int duration) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return this.mService.setScanMode(mode, duration);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean setScanMode(int mode) {
        if (this.getState() != 12) {
            return false;
        }
        return this.setScanMode(mode, 120);
    }

    public int getDiscoverableTimeout() {
        if (this.getState() != 12) {
            return -1;
        }
        try {
            return this.mService.getDiscoverableTimeout();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return -1;
        }
    }

    public void setDiscoverableTimeout(int timeout) {
        if (this.getState() != 12) {
            return;
        }
        try {
            this.mService.setDiscoverableTimeout(timeout);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    public boolean startDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return this.mService.startDiscovery();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean cancelDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return this.mService.cancelDiscovery();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean isDiscovering() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return this.mService.isDiscovering();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public Set<BluetoothDevice> getBondedDevices() {
        if (this.getState() != 12) {
            return this.toDeviceSet(new String[0]);
        }
        try {
            return this.toDeviceSet(this.mService.listBonds());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public int getConnectionState() {
        if (this.getState() != 12) {
            return 0;
        }
        try {
            return this.mService.getAdapterConnectionState();
        }
        catch (RemoteException e) {
            Log.e(TAG, "getConnectionState:", e);
            return 0;
        }
    }

    public int getProfileConnectionState(int profile) {
        if (this.getState() != 12) {
            return 0;
        }
        try {
            return this.mService.getProfileConnectionState(profile);
        }
        catch (RemoteException e) {
            Log.e(TAG, "getProfileConnectionState:", e);
            return 0;
        }
    }

    public BluetoothServerSocket listenUsingRfcommOn(int channel) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, true, true, channel);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            socket.mSocket.throwErrnoNative(errno);
        }
        return socket;
    }

    public BluetoothServerSocket listenUsingRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, true, true);
    }

    public BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, false);
    }

    public BluetoothServerSocket listenUsingEncryptedRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, true);
    }

    private BluetoothServerSocket createNewRfcommSocketAndRecord(String name, UUID uuid, boolean auth, boolean encrypt) throws IOException {
        BluetoothServerSocket socket;
        int channel;
        RfcommChannelPicker picker = new RfcommChannelPicker(uuid);
        while (true) {
            if ((channel = picker.nextChannel()) == -1) {
                throw new IOException("No available channels");
            }
            socket = new BluetoothServerSocket(1, auth, encrypt, channel);
            int errno = socket.mSocket.bindListen();
            if (errno == 0) break;
            if (errno == 98) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
                continue;
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            socket.mSocket.throwErrnoNative(errno);
        }
        int handle = -1;
        try {
            handle = this.mService.addRfcommServiceRecord(name, new ParcelUuid(uuid), channel, new Binder());
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        if (handle == -1) {
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new IOException("Not able to register SDP record for " + name);
        }
        if (this.mServiceRecordHandler == null) {
            this.mServiceRecordHandler = new Handler(Looper.getMainLooper()){

                public void handleMessage(Message msg) {
                    int handle = msg.what;
                    try {
                        BluetoothAdapter.this.mService.removeServiceRecord(handle);
                    }
                    catch (RemoteException e) {
                        Log.e(BluetoothAdapter.TAG, "", e);
                    }
                }
            };
        }
        socket.setCloseHandler(this.mServiceRecordHandler, handle);
        return socket;
    }

    public BluetoothServerSocket listenUsingInsecureRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, false, port);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            socket.mSocket.throwErrnoNative(errno);
        }
        return socket;
    }

    public BluetoothServerSocket listenUsingEncryptedRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, true, port);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            socket.mSocket.throwErrnoNative(errno);
        }
        return socket;
    }

    public static BluetoothServerSocket listenUsingScoOn() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(2, false, false, -1);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            socket.mSocket.throwErrnoNative(errno);
        }
        return socket;
    }

    public Pair<byte[], byte[]> readOutOfBandData() {
        if (this.getState() != 12) {
            return null;
        }
        try {
            byte[] ret = this.mService.readOutOfBandData();
            if (ret == null || ret.length != 32) {
                return null;
            }
            byte[] hash = Arrays.copyOfRange(ret, 0, 16);
            byte[] randomizer = Arrays.copyOfRange(ret, 16, 32);
            return new Pair<byte[], byte[]>(hash, randomizer);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        if (context == null || listener == null) {
            return false;
        }
        if (profile == 1) {
            BluetoothHeadset headset = new BluetoothHeadset(context, listener);
            return true;
        }
        if (profile == 2) {
            BluetoothA2dp a2dp = new BluetoothA2dp(context, listener);
            return true;
        }
        if (profile == 4) {
            BluetoothInputDevice iDev = new BluetoothInputDevice(context, listener);
            return true;
        }
        if (profile == 5) {
            BluetoothPan pan = new BluetoothPan(context, listener);
            return true;
        }
        if (profile == 3) {
            BluetoothHealth health = new BluetoothHealth(context, listener);
            return true;
        }
        return false;
    }

    public void closeProfileProxy(int profile, BluetoothProfile proxy) {
        BluetoothHeadset headset;
        if (profile == 1 && (headset = (BluetoothHeadset)proxy) != null) {
            headset.close();
        }
    }

    public boolean changeApplicationBluetoothState(boolean on, BluetoothStateChangeCallback callback) {
        if (callback == null) {
            return false;
        }
        try {
            return this.mService.changeApplicationBluetoothState(on, new StateChangeCallbackWrapper(callback), new Binder());
        }
        catch (RemoteException e) {
            Log.e(TAG, "changeBluetoothState", e);
            return false;
        }
    }

    private Set<BluetoothDevice> toDeviceSet(String[] addresses) {
        HashSet<BluetoothDevice> devices = new HashSet<BluetoothDevice>(addresses.length);
        for (int i = 0; i < addresses.length; ++i) {
            devices.add(this.getRemoteDevice(addresses[i]));
        }
        return Collections.unmodifiableSet(devices);
    }

    public static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public class StateChangeCallbackWrapper
    extends IBluetoothStateChangeCallback.Stub {
        private BluetoothStateChangeCallback mCallback;

        StateChangeCallbackWrapper(BluetoothStateChangeCallback callback) {
            this.mCallback = callback;
        }

        public void onBluetoothStateChange(boolean on) {
            this.mCallback.onBluetoothStateChange(on);
        }
    }

    public static interface BluetoothStateChangeCallback {
        public void onBluetoothStateChange(boolean var1);
    }

    private static class RfcommChannelPicker {
        private static final int[] RESERVED_RFCOMM_CHANNELS = new int[]{10, 11, 12, 19};
        private static LinkedList<Integer> sChannels;
        private static Random sRandom;
        private final LinkedList<Integer> mChannels;
        private final UUID mUuid;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RfcommChannelPicker(UUID uuid) {
            Class<RfcommChannelPicker> clazz = RfcommChannelPicker.class;
            synchronized (RfcommChannelPicker.class) {
                if (sChannels == null) {
                    sChannels = new LinkedList();
                    for (int i = 1; i <= 30; ++i) {
                        sChannels.addLast(new Integer(i));
                    }
                    for (int reserved : RESERVED_RFCOMM_CHANNELS) {
                        sChannels.remove(new Integer(reserved));
                    }
                    sRandom = new Random();
                }
                this.mChannels = (LinkedList)sChannels.clone();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.mUuid = uuid;
                return;
            }
        }

        public int nextChannel() {
            if (this.mChannels.size() == 0) {
                return -1;
            }
            return this.mChannels.remove(sRandom.nextInt(this.mChannels.size()));
        }
    }
}

