/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.BulkCursorNative;
import android.database.BulkCursorToCursorAdaptor;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.IBulkCursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import java.io.FileNotFoundException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContentProviderProxy
implements IContentProvider {
    private IBinder mRemote;

    public ContentProviderProxy(IBinder remote) {
        this.mRemote = remote;
    }

    @Override
    public IBinder asBinder() {
        return this.mRemote;
    }

    @Override
    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder) throws RemoteException {
        BulkCursorToCursorAdaptor adaptor = new BulkCursorToCursorAdaptor();
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            int i;
            data.writeInterfaceToken("android.content.IContentProvider");
            url.writeToParcel(data, 0);
            int length = 0;
            if (projection != null) {
                length = projection.length;
            }
            data.writeInt(length);
            for (i = 0; i < length; ++i) {
                data.writeString(projection[i]);
            }
            data.writeString(selection);
            length = selectionArgs != null ? selectionArgs.length : 0;
            data.writeInt(length);
            for (i = 0; i < length; ++i) {
                data.writeString(selectionArgs[i]);
            }
            data.writeString(sortOrder);
            data.writeStrongBinder(adaptor.getObserver().asBinder());
            this.mRemote.transact(1, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            IBulkCursor bulkCursor = BulkCursorNative.asInterface(reply.readStrongBinder());
            if (bulkCursor != null) {
                int rowCount = reply.readInt();
                int idColumnPosition = reply.readInt();
                boolean wantsAllOnMoveCalls = reply.readInt() != 0;
                adaptor.initialize(bulkCursor, rowCount, idColumnPosition, wantsAllOnMoveCalls);
            } else {
                adaptor.close();
                adaptor = null;
            }
            BulkCursorToCursorAdaptor bulkCursorToCursorAdaptor = adaptor;
            return bulkCursorToCursorAdaptor;
        }
        catch (RemoteException ex) {
            adaptor.close();
            throw ex;
        }
        catch (RuntimeException ex) {
            adaptor.close();
            throw ex;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getType(Uri url) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            String out;
            data.writeInterfaceToken("android.content.IContentProvider");
            url.writeToParcel(data, 0);
            this.mRemote.transact(2, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            String string2 = out = reply.readString();
            return string2;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uri insert(Uri url, ContentValues values) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            Uri out;
            data.writeInterfaceToken("android.content.IContentProvider");
            url.writeToParcel(data, 0);
            values.writeToParcel(data, 0);
            this.mRemote.transact(3, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            Uri uri = out = Uri.CREATOR.createFromParcel(reply);
            return uri;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bulkInsert(Uri url, ContentValues[] values) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            int count;
            data.writeInterfaceToken("android.content.IContentProvider");
            url.writeToParcel(data, 0);
            data.writeTypedArray(values, 0);
            this.mRemote.transact(13, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            int n = count = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            ContentProviderResult[] results;
            data.writeInterfaceToken("android.content.IContentProvider");
            data.writeInt(operations.size());
            for (ContentProviderOperation operation : operations) {
                operation.writeToParcel(data, 0);
            }
            this.mRemote.transact(20, data, reply, 0);
            DatabaseUtils.readExceptionWithOperationApplicationExceptionFromParcel(reply);
            ContentProviderResult[] contentProviderResultArray = results = reply.createTypedArray(ContentProviderResult.CREATOR);
            return contentProviderResultArray;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Uri url, String selection, String[] selectionArgs) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            int count;
            data.writeInterfaceToken("android.content.IContentProvider");
            url.writeToParcel(data, 0);
            data.writeString(selection);
            data.writeStringArray(selectionArgs);
            this.mRemote.transact(4, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            int n = count = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(Uri url, ContentValues values, String selection, String[] selectionArgs) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            int count;
            data.writeInterfaceToken("android.content.IContentProvider");
            url.writeToParcel(data, 0);
            values.writeToParcel(data, 0);
            data.writeString(selection);
            data.writeStringArray(selectionArgs);
            this.mRemote.transact(10, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            int n = count = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor openFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            ParcelFileDescriptor fd;
            data.writeInterfaceToken("android.content.IContentProvider");
            url.writeToParcel(data, 0);
            data.writeString(mode);
            this.mRemote.transact(14, data, reply, 0);
            DatabaseUtils.readExceptionWithFileNotFoundExceptionFromParcel(reply);
            int has = reply.readInt();
            ParcelFileDescriptor parcelFileDescriptor = fd = has != 0 ? reply.readFileDescriptor() : null;
            return parcelFileDescriptor;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssetFileDescriptor openAssetFile(Uri url, String mode) throws RemoteException, FileNotFoundException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            AssetFileDescriptor fd;
            data.writeInterfaceToken("android.content.IContentProvider");
            url.writeToParcel(data, 0);
            data.writeString(mode);
            this.mRemote.transact(15, data, reply, 0);
            DatabaseUtils.readExceptionWithFileNotFoundExceptionFromParcel(reply);
            int has = reply.readInt();
            AssetFileDescriptor assetFileDescriptor = fd = has != 0 ? AssetFileDescriptor.CREATOR.createFromParcel(reply) : null;
            return assetFileDescriptor;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle call(String method, String request, Bundle args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            Bundle bundle;
            data.writeInterfaceToken("android.content.IContentProvider");
            data.writeString(method);
            data.writeString(request);
            data.writeBundle(args);
            this.mRemote.transact(21, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            Bundle bundle2 = bundle = reply.readBundle();
            return bundle2;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getStreamTypes(Uri url, String mimeTypeFilter) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            String[] out;
            data.writeInterfaceToken("android.content.IContentProvider");
            url.writeToParcel(data, 0);
            data.writeString(mimeTypeFilter);
            this.mRemote.transact(22, data, reply, 0);
            DatabaseUtils.readExceptionFromParcel(reply);
            String[] stringArray = out = reply.createStringArray();
            return stringArray;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssetFileDescriptor openTypedAssetFile(Uri url, String mimeType, Bundle opts) throws RemoteException, FileNotFoundException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            AssetFileDescriptor fd;
            data.writeInterfaceToken("android.content.IContentProvider");
            url.writeToParcel(data, 0);
            data.writeString(mimeType);
            data.writeBundle(opts);
            this.mRemote.transact(23, data, reply, 0);
            DatabaseUtils.readExceptionWithFileNotFoundExceptionFromParcel(reply);
            int has = reply.readInt();
            AssetFileDescriptor assetFileDescriptor = fd = has != 0 ? AssetFileDescriptor.CREATOR.createFromParcel(reply) : null;
            return assetFileDescriptor;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }
}

