/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.SyncAdapterType;
import android.content.SyncAdaptersCache;
import android.content.SyncOperation;
import android.content.SyncStorageEngine;
import android.content.pm.RegisteredServicesCache;
import android.os.SystemClock;
import android.text.format.DateUtils;
import android.util.Log;
import android.util.Pair;
import com.google.android.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SyncQueue {
    private static final String TAG = "SyncManager";
    private SyncStorageEngine mSyncStorageEngine;
    public final HashMap<String, SyncOperation> mOperationsMap = Maps.newHashMap();

    public SyncQueue(SyncStorageEngine syncStorageEngine, SyncAdaptersCache syncAdapters) {
        this.mSyncStorageEngine = syncStorageEngine;
        ArrayList<SyncStorageEngine.PendingOperation> ops = this.mSyncStorageEngine.getPendingOperations();
        int N = ops.size();
        for (int i = 0; i < N; ++i) {
            SyncStorageEngine.PendingOperation op = ops.get(i);
            Pair<Long, Long> backoff = syncStorageEngine.getBackoff(op.account, op.authority);
            RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo = syncAdapters.getServiceInfo(SyncAdapterType.newKey(op.authority, op.account.type));
            if (syncAdapterInfo == null) continue;
            SyncOperation syncOperation = new SyncOperation(op.account, op.syncSource, op.authority, op.extras, 0L, backoff != null ? (Long)backoff.first : 0L, syncStorageEngine.getDelayUntilTime(op.account, op.authority), ((SyncAdapterType)syncAdapterInfo.type).allowParallelSyncs());
            syncOperation.expedited = op.expedited;
            syncOperation.pendingOperation = op;
            this.add(syncOperation, op);
        }
    }

    public boolean add(SyncOperation operation) {
        return this.add(operation, null);
    }

    private boolean add(SyncOperation operation, SyncStorageEngine.PendingOperation pop) {
        String operationKey = operation.key;
        SyncOperation existingOperation = this.mOperationsMap.get(operationKey);
        if (existingOperation != null) {
            boolean changed = false;
            if (existingOperation.expedited == operation.expedited) {
                long newRunTime = Math.min(existingOperation.earliestRunTime, operation.earliestRunTime);
                if (existingOperation.earliestRunTime != newRunTime) {
                    existingOperation.earliestRunTime = newRunTime;
                    changed = true;
                }
            } else if (operation.expedited) {
                existingOperation.expedited = true;
                changed = true;
            }
            return changed;
        }
        operation.pendingOperation = pop;
        if (operation.pendingOperation == null) {
            pop = new SyncStorageEngine.PendingOperation(operation.account, operation.syncSource, operation.authority, operation.extras, operation.expedited);
            if ((pop = this.mSyncStorageEngine.insertIntoPending(pop)) == null) {
                throw new IllegalStateException("error adding pending sync operation " + operation);
            }
            operation.pendingOperation = pop;
        }
        this.mOperationsMap.put(operationKey, operation);
        return true;
    }

    public void remove(SyncOperation operation) {
        SyncOperation operationToRemove = this.mOperationsMap.remove(operation.key);
        if (operationToRemove == null) {
            return;
        }
        if (!this.mSyncStorageEngine.deleteFromPending(operationToRemove.pendingOperation)) {
            String errorMessage = "unable to find pending row for " + operationToRemove;
            Log.e(TAG, errorMessage, new IllegalStateException(errorMessage));
        }
    }

    public void onBackoffChanged(Account account, String providerName, long backoff) {
        for (SyncOperation op : this.mOperationsMap.values()) {
            if (!op.account.equals(account) || !op.authority.equals(providerName)) continue;
            op.backoff = backoff;
            op.updateEffectiveRunTime();
        }
    }

    public void onDelayUntilTimeChanged(Account account, String providerName, long delayUntil) {
        for (SyncOperation op : this.mOperationsMap.values()) {
            if (!op.account.equals(account) || !op.authority.equals(providerName)) continue;
            op.delayUntil = delayUntil;
            op.updateEffectiveRunTime();
        }
    }

    public void remove(Account account, String authority) {
        Iterator<Map.Entry<String, SyncOperation>> entries = this.mOperationsMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, SyncOperation> entry = entries.next();
            SyncOperation syncOperation = entry.getValue();
            if (account != null && !syncOperation.account.equals(account) || authority != null && !syncOperation.authority.equals(authority)) continue;
            entries.remove();
            if (this.mSyncStorageEngine.deleteFromPending(syncOperation.pendingOperation)) continue;
            String errorMessage = "unable to find pending row for " + syncOperation;
            Log.e(TAG, errorMessage, new IllegalStateException(errorMessage));
        }
    }

    public void dump(StringBuilder sb) {
        long now = SystemClock.elapsedRealtime();
        sb.append("SyncQueue: ").append(this.mOperationsMap.size()).append(" operation(s)\n");
        for (SyncOperation operation : this.mOperationsMap.values()) {
            sb.append("  ");
            if (operation.effectiveRunTime <= now) {
                sb.append("READY");
            } else {
                sb.append(DateUtils.formatElapsedTime((operation.effectiveRunTime - now) / 1000L));
            }
            sb.append(" - ");
            sb.append(operation.dump(false)).append("\n");
        }
    }
}

