/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetManager;
import android.content.res.StringBlock;
import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import com.android.internal.util.XmlUtils;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParserException;

class XmlBlock {
    private static final boolean DEBUG = false;
    private final AssetManager mAssets;
    private final int mNative;
    private final StringBlock mStrings;
    private boolean mOpen = true;
    private int mOpenCount = 1;

    public XmlBlock(byte[] data) {
        this.mAssets = null;
        this.mNative = XmlBlock.nativeCreate(data, 0, data.length);
        this.mStrings = new StringBlock(XmlBlock.nativeGetStringBlock(this.mNative), false);
    }

    public XmlBlock(byte[] data, int offset, int size) {
        this.mAssets = null;
        this.mNative = XmlBlock.nativeCreate(data, offset, size);
        this.mStrings = new StringBlock(XmlBlock.nativeGetStringBlock(this.mNative), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        XmlBlock xmlBlock = this;
        synchronized (xmlBlock) {
            if (this.mOpen) {
                this.mOpen = false;
                this.decOpenCountLocked();
            }
        }
    }

    private void decOpenCountLocked() {
        --this.mOpenCount;
        if (this.mOpenCount == 0) {
            XmlBlock.nativeDestroy(this.mNative);
            if (this.mAssets != null) {
                this.mAssets.xmlBlockGone(this.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlResourceParser newParser() {
        XmlBlock xmlBlock = this;
        synchronized (xmlBlock) {
            if (this.mNative != 0) {
                return new Parser(XmlBlock.nativeCreateParseState(this.mNative), this);
            }
            return null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    XmlBlock(AssetManager assets, int xmlBlock) {
        this.mAssets = assets;
        this.mNative = xmlBlock;
        this.mStrings = new StringBlock(XmlBlock.nativeGetStringBlock(xmlBlock), false);
    }

    private static int nativeCreate(byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeCreate([BII)I", true, null);
    }

    private static int nativeGetStringBlock(int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetStringBlock(I)I", true, null);
    }

    private static int nativeCreateParseState(int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeCreateParseState(I)I", true, null);
    }

    private static int nativeNext(int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeNext(I)I", true, null);
    }

    private static int nativeGetNamespace(int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetNamespace(I)I", true, null);
    }

    private static int nativeGetName(int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetName(I)I", true, null);
    }

    private static int nativeGetText(int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetText(I)I", true, null);
    }

    private static int nativeGetLineNumber(int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetLineNumber(I)I", true, null);
    }

    private static int nativeGetAttributeCount(int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeCount(I)I", true, null);
    }

    private static int nativeGetAttributeNamespace(int n, int n2) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeNamespace(II)I", true, null);
    }

    private static int nativeGetAttributeName(int n, int n2) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeName(II)I", true, null);
    }

    private static int nativeGetAttributeResource(int n, int n2) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeResource(II)I", true, null);
    }

    private static int nativeGetAttributeDataType(int n, int n2) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeDataType(II)I", true, null);
    }

    private static int nativeGetAttributeData(int n, int n2) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeData(II)I", true, null);
    }

    private static int nativeGetAttributeStringValue(int n, int n2) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeStringValue(II)I", true, null);
    }

    private static int nativeGetIdAttribute(int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetIdAttribute(I)I", true, null);
    }

    private static int nativeGetClassAttribute(int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetClassAttribute(I)I", true, null);
    }

    private static int nativeGetStyleAttribute(int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetStyleAttribute(I)I", true, null);
    }

    private static int nativeGetAttributeIndex(int n, String string2, String string3) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeIndex(ILjava/lang/String;Ljava/lang/String;)I", true, null);
    }

    private static void nativeDestroyParseState(int n) {
        OverrideMethod.invokeV("android.content.res.XmlBlock#nativeDestroyParseState(I)V", true, null);
    }

    private static void nativeDestroy(int n) {
        OverrideMethod.invokeV("android.content.res.XmlBlock#nativeDestroy(I)V", true, null);
    }

    class Parser
    implements XmlResourceParser {
        int mParseState;
        private final XmlBlock mBlock;
        private boolean mStarted = false;
        private boolean mDecNextDepth = false;
        private int mDepth = 0;
        private int mEventType = 0;

        Parser(int parseState, XmlBlock block) {
            this.mParseState = parseState;
            this.mBlock = block;
            block.mOpenCount++;
        }

        public void setFeature(String name, boolean state) throws XmlPullParserException {
            if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name) && state) {
                return;
            }
            if ("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(name) && state) {
                return;
            }
            throw new XmlPullParserException("Unsupported feature: " + name);
        }

        public boolean getFeature(String name) {
            if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name)) {
                return true;
            }
            return "http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(name);
        }

        public void setProperty(String name, Object value) throws XmlPullParserException {
            throw new XmlPullParserException("setProperty() not supported");
        }

        public Object getProperty(String name) {
            return null;
        }

        public void setInput(Reader in) throws XmlPullParserException {
            throw new XmlPullParserException("setInput() not supported");
        }

        public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
            throw new XmlPullParserException("setInput() not supported");
        }

        public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
            throw new XmlPullParserException("defineEntityReplacementText() not supported");
        }

        public String getNamespacePrefix(int pos) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespacePrefix() not supported");
        }

        public String getInputEncoding() {
            return null;
        }

        public String getNamespace(String prefix) {
            throw new RuntimeException("getNamespace() not supported");
        }

        public int getNamespaceCount(int depth) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespaceCount() not supported");
        }

        public String getPositionDescription() {
            return "Binary XML file line #" + this.getLineNumber();
        }

        public String getNamespaceUri(int pos) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespaceUri() not supported");
        }

        public int getColumnNumber() {
            return -1;
        }

        public int getDepth() {
            return this.mDepth;
        }

        public String getText() {
            int id2 = XmlBlock.nativeGetText(this.mParseState);
            return id2 >= 0 ? ((Object)XmlBlock.this.mStrings.get(id2)).toString() : null;
        }

        public int getLineNumber() {
            return XmlBlock.nativeGetLineNumber(this.mParseState);
        }

        public int getEventType() throws XmlPullParserException {
            return this.mEventType;
        }

        public boolean isWhitespace() throws XmlPullParserException {
            return false;
        }

        public String getPrefix() {
            throw new RuntimeException("getPrefix not supported");
        }

        public char[] getTextCharacters(int[] holderForStartAndLength) {
            String txt = this.getText();
            char[] chars = null;
            if (txt != null) {
                holderForStartAndLength[0] = 0;
                holderForStartAndLength[1] = txt.length();
                chars = new char[txt.length()];
                txt.getChars(0, txt.length(), chars, 0);
            }
            return chars;
        }

        public String getNamespace() {
            int id2 = XmlBlock.nativeGetNamespace(this.mParseState);
            return id2 >= 0 ? ((Object)XmlBlock.this.mStrings.get(id2)).toString() : "";
        }

        public String getName() {
            int id2 = XmlBlock.nativeGetName(this.mParseState);
            return id2 >= 0 ? ((Object)XmlBlock.this.mStrings.get(id2)).toString() : null;
        }

        public String getAttributeNamespace(int index) {
            int id2 = XmlBlock.nativeGetAttributeNamespace(this.mParseState, index);
            if (id2 >= 0) {
                return ((Object)XmlBlock.this.mStrings.get(id2)).toString();
            }
            if (id2 == -1) {
                return "";
            }
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        public String getAttributeName(int index) {
            int id2 = XmlBlock.nativeGetAttributeName(this.mParseState, index);
            if (id2 >= 0) {
                return ((Object)XmlBlock.this.mStrings.get(id2)).toString();
            }
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        public String getAttributePrefix(int index) {
            throw new RuntimeException("getAttributePrefix not supported");
        }

        public boolean isEmptyElementTag() throws XmlPullParserException {
            return false;
        }

        public int getAttributeCount() {
            return this.mEventType == 2 ? XmlBlock.nativeGetAttributeCount(this.mParseState) : -1;
        }

        public String getAttributeValue(int index) {
            int id2 = XmlBlock.nativeGetAttributeStringValue(this.mParseState, index);
            if (id2 >= 0) {
                return ((Object)XmlBlock.this.mStrings.get(id2)).toString();
            }
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, index);
            if (t == 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            int v = XmlBlock.nativeGetAttributeData(this.mParseState, index);
            return TypedValue.coerceToString(t, v);
        }

        public String getAttributeType(int index) {
            return "CDATA";
        }

        public boolean isAttributeDefault(int index) {
            return false;
        }

        public int nextToken() throws XmlPullParserException, IOException {
            return this.next();
        }

        public String getAttributeValue(String namespace, String name) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, name);
            if (idx >= 0) {
                return this.getAttributeValue(idx);
            }
            return null;
        }

        public int next() throws XmlPullParserException, IOException {
            if (!this.mStarted) {
                this.mStarted = true;
                return 0;
            }
            if (this.mParseState == 0) {
                return 1;
            }
            int ev = XmlBlock.nativeNext(this.mParseState);
            if (this.mDecNextDepth) {
                --this.mDepth;
                this.mDecNextDepth = false;
            }
            switch (ev) {
                case 2: {
                    ++this.mDepth;
                    break;
                }
                case 3: {
                    this.mDecNextDepth = true;
                }
            }
            this.mEventType = ev;
            if (ev == 1) {
                this.close();
            }
            return ev;
        }

        public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
            if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
                throw new XmlPullParserException("expected " + TYPES[type] + this.getPositionDescription());
            }
        }

        public String nextText() throws XmlPullParserException, IOException {
            if (this.getEventType() != 2) {
                throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG to read next text", this, null);
            }
            int eventType = this.next();
            if (eventType == 4) {
                String result = this.getText();
                eventType = this.next();
                if (eventType != 3) {
                    throw new XmlPullParserException(this.getPositionDescription() + ": event TEXT it must be immediately followed by END_TAG", this, null);
                }
                return result;
            }
            if (eventType == 3) {
                return "";
            }
            throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG or TEXT to read text", this, null);
        }

        public int nextTag() throws XmlPullParserException, IOException {
            int eventType = this.next();
            if (eventType == 4 && this.isWhitespace()) {
                eventType = this.next();
            }
            if (eventType != 2 && eventType != 3) {
                throw new XmlPullParserException(this.getPositionDescription() + ": expected start or end tag", this, null);
            }
            return eventType;
        }

        public int getAttributeNameResource(int index) {
            return XmlBlock.nativeGetAttributeResource(this.mParseState, index);
        }

        public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeListValue(idx, options, defaultValue);
            }
            return defaultValue;
        }

        public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeBooleanValue(idx, defaultValue);
            }
            return defaultValue;
        }

        public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeResourceValue(idx, defaultValue);
            }
            return defaultValue;
        }

        public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeIntValue(idx, defaultValue);
            }
            return defaultValue;
        }

        public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeUnsignedIntValue(idx, defaultValue);
            }
            return defaultValue;
        }

        public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeFloatValue(idx, defaultValue);
            }
            return defaultValue;
        }

        public int getAttributeListValue(int idx, String[] options, int defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            int v = XmlBlock.nativeGetAttributeData(this.mParseState, idx);
            if (t == 3) {
                return XmlUtils.convertValueToList(XmlBlock.this.mStrings.get(v), options, defaultValue);
            }
            return v;
        }

        public boolean getAttributeBooleanValue(int idx, boolean defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            if (t >= 16 && t <= 31) {
                return XmlBlock.nativeGetAttributeData(this.mParseState, idx) != 0;
            }
            return defaultValue;
        }

        public int getAttributeResourceValue(int idx, int defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            if (t == 1) {
                return XmlBlock.nativeGetAttributeData(this.mParseState, idx);
            }
            return defaultValue;
        }

        public int getAttributeIntValue(int idx, int defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            if (t >= 16 && t <= 31) {
                return XmlBlock.nativeGetAttributeData(this.mParseState, idx);
            }
            return defaultValue;
        }

        public int getAttributeUnsignedIntValue(int idx, int defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            if (t >= 16 && t <= 31) {
                return XmlBlock.nativeGetAttributeData(this.mParseState, idx);
            }
            return defaultValue;
        }

        public float getAttributeFloatValue(int idx, float defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            if (t == 4) {
                return Float.intBitsToFloat(XmlBlock.nativeGetAttributeData(this.mParseState, idx));
            }
            throw new RuntimeException("not a float!");
        }

        public String getIdAttribute() {
            int id2 = XmlBlock.nativeGetIdAttribute(this.mParseState);
            return id2 >= 0 ? ((Object)XmlBlock.this.mStrings.get(id2)).toString() : null;
        }

        public String getClassAttribute() {
            int id2 = XmlBlock.nativeGetClassAttribute(this.mParseState);
            return id2 >= 0 ? ((Object)XmlBlock.this.mStrings.get(id2)).toString() : null;
        }

        public int getIdAttributeResourceValue(int defaultValue) {
            return this.getAttributeResourceValue(null, "id", defaultValue);
        }

        public int getStyleAttribute() {
            return XmlBlock.nativeGetStyleAttribute(this.mParseState);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            XmlBlock xmlBlock = this.mBlock;
            synchronized (xmlBlock) {
                if (this.mParseState != 0) {
                    XmlBlock.nativeDestroyParseState(this.mParseState);
                    this.mParseState = 0;
                    this.mBlock.decOpenCountLocked();
                }
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        CharSequence getPooledString(int id2) {
            return XmlBlock.this.mStrings.get(id2);
        }
    }
}

