/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.util.MathUtils;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.HashMap;
import java.util.Locale;

public class Color {
    public static final int BLACK = -16777216;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = -7829368;
    public static final int LTGRAY = -3355444;
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int YELLOW = -256;
    public static final int CYAN = -16711681;
    public static final int MAGENTA = -65281;
    public static final int TRANSPARENT = 0;
    private static final HashMap<String, Integer> sColorNameMap = new HashMap();

    public static int alpha(int color2) {
        return color2 >>> 24;
    }

    public static int red(int color2) {
        return color2 >> 16 & 0xFF;
    }

    public static int green(int color2) {
        return color2 >> 8 & 0xFF;
    }

    public static int blue(int color2) {
        return color2 & 0xFF;
    }

    public static int rgb(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public static int argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static float hue(int color2) {
        float H2;
        int temp;
        int b = color2 & 0xFF;
        int r = color2 >> 16 & 0xFF;
        int g = color2 >> 8 & 0xFF;
        int V = Math.max(b, Math.max(r, g));
        if (V == (temp = Math.min(b, Math.min(r, g)))) {
            H2 = 0.0f;
        } else {
            float vtemp = V - temp;
            float cr = (float)(V - r) / vtemp;
            float cg = (float)(V - g) / vtemp;
            float cb = (float)(V - b) / vtemp;
            H2 = r == V ? cb - cg : (g == V ? 2.0f + cr - cb : 4.0f + cg - cr);
            if ((H2 /= 6.0f) < 0.0f) {
                H2 += 1.0f;
            }
        }
        return H2;
    }

    public static float saturation(int color2) {
        int temp;
        int b = color2 & 0xFF;
        int r = color2 >> 16 & 0xFF;
        int g = color2 >> 8 & 0xFF;
        int V = Math.max(b, Math.max(r, g));
        float S = V == (temp = Math.min(b, Math.min(r, g))) ? 0.0f : (float)(V - temp) / (float)V;
        return S;
    }

    public static float brightness(int color2) {
        int r = color2 >> 16 & 0xFF;
        int g = color2 >> 8 & 0xFF;
        int b = color2 & 0xFF;
        int V = Math.max(b, Math.max(r, g));
        return (float)V / 255.0f;
    }

    public static int parseColor(String colorString) {
        if (colorString.charAt(0) == '#') {
            long color2 = Long.parseLong(colorString.substring(1), 16);
            if (colorString.length() == 7) {
                color2 |= 0xFFFFFFFFFF000000L;
            } else if (colorString.length() != 9) {
                throw new IllegalArgumentException("Unknown color");
            }
            return (int)color2;
        }
        Integer color3 = sColorNameMap.get(colorString.toLowerCase(Locale.US));
        if (color3 != null) {
            return color3;
        }
        throw new IllegalArgumentException("Unknown color");
    }

    public static int HSBtoColor(float[] hsb) {
        return Color.HSBtoColor(hsb[0], hsb[1], hsb[2]);
    }

    public static int HSBtoColor(float h, float s, float b) {
        h = MathUtils.constrain(h, 0.0f, 1.0f);
        s = MathUtils.constrain(s, 0.0f, 1.0f);
        b = MathUtils.constrain(b, 0.0f, 1.0f);
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float hf = (h - (float)((int)h)) * 6.0f;
        int ihf = (int)hf;
        float f = hf - (float)ihf;
        float pv = b * (1.0f - s);
        float qv = b * (1.0f - s * f);
        float tv = b * (1.0f - s * (1.0f - f));
        switch (ihf) {
            case 0: {
                red = b;
                green = tv;
                blue = pv;
                break;
            }
            case 1: {
                red = qv;
                green = b;
                blue = pv;
                break;
            }
            case 2: {
                red = pv;
                green = b;
                blue = tv;
                break;
            }
            case 3: {
                red = pv;
                green = qv;
                blue = b;
                break;
            }
            case 4: {
                red = tv;
                green = pv;
                blue = b;
                break;
            }
            case 5: {
                red = b;
                green = pv;
                blue = qv;
            }
        }
        return 0xFF000000 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    public static void RGBToHSV(int red, int green, int blue, float[] hsv) {
        if (hsv.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        Color.nativeRGBToHSV(red, green, blue, hsv);
    }

    public static void colorToHSV(int color2, float[] hsv) {
        Color.RGBToHSV(color2 >> 16 & 0xFF, color2 >> 8 & 0xFF, color2 & 0xFF, hsv);
    }

    public static int HSVToColor(float[] hsv) {
        return Color.HSVToColor(255, hsv);
    }

    public static int HSVToColor(int alpha, float[] hsv) {
        if (hsv.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        return Color.nativeHSVToColor(alpha, hsv);
    }

    private static void nativeRGBToHSV(int n, int n2, int n3, float[] fArray) {
        OverrideMethod.invokeV("android.graphics.Color#nativeRGBToHSV(III[F)V", true, null);
    }

    private static int nativeHSVToColor(int n, float[] fArray) {
        return OverrideMethod.invokeI("android.graphics.Color#nativeHSVToColor(I[F)I", true, null);
    }

    static {
        sColorNameMap.put("black", -16777216);
        sColorNameMap.put("darkgray", -12303292);
        sColorNameMap.put("gray", -7829368);
        sColorNameMap.put("lightgray", -3355444);
        sColorNameMap.put("white", -1);
        sColorNameMap.put("red", -65536);
        sColorNameMap.put("green", -16711936);
        sColorNameMap.put("blue", -16776961);
        sColorNameMap.put("yellow", -256);
        sColorNameMap.put("cyan", -16711681);
        sColorNameMap.put("magenta", -65281);
    }
}

