/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkTemplate;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Objects;
import com.android.internal.util.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkPolicy
implements Parcelable,
Comparable<NetworkPolicy> {
    public static final long WARNING_DISABLED = -1L;
    public static final long LIMIT_DISABLED = -1L;
    public static final long SNOOZE_NEVER = -1L;
    public final NetworkTemplate template;
    public int cycleDay;
    public long warningBytes;
    public long limitBytes;
    public long lastSnooze;
    private static final long DEFAULT_MTU = 1500L;
    public static final Parcelable.Creator<NetworkPolicy> CREATOR = new Parcelable.Creator<NetworkPolicy>(){

        @Override
        public NetworkPolicy createFromParcel(Parcel in) {
            return new NetworkPolicy(in);
        }

        public NetworkPolicy[] newArray(int size) {
            return new NetworkPolicy[size];
        }
    };

    public NetworkPolicy(NetworkTemplate template, int cycleDay, long warningBytes, long limitBytes, long lastSnooze) {
        this.template = Preconditions.checkNotNull(template, "missing NetworkTemplate");
        this.cycleDay = cycleDay;
        this.warningBytes = warningBytes;
        this.limitBytes = limitBytes;
        this.lastSnooze = lastSnooze;
    }

    public NetworkPolicy(Parcel in) {
        this.template = (NetworkTemplate)in.readParcelable(null);
        this.cycleDay = in.readInt();
        this.warningBytes = in.readLong();
        this.limitBytes = in.readLong();
        this.lastSnooze = in.readLong();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.template, flags);
        dest.writeInt(this.cycleDay);
        dest.writeLong(this.warningBytes);
        dest.writeLong(this.limitBytes);
        dest.writeLong(this.lastSnooze);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean isOverLimit(long totalBytes) {
        return this.limitBytes != -1L && (totalBytes += 3000L) >= this.limitBytes;
    }

    @Override
    public int compareTo(NetworkPolicy another) {
        if (another == null || another.limitBytes == -1L) {
            return -1;
        }
        if (this.limitBytes == -1L || another.limitBytes < this.limitBytes) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.template, this.cycleDay, this.warningBytes, this.limitBytes, this.lastSnooze);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkPolicy) {
            NetworkPolicy other = (NetworkPolicy)obj;
            return Objects.equal(this.template, other.template) && this.cycleDay == other.cycleDay && this.warningBytes == other.warningBytes && this.limitBytes == other.limitBytes && this.lastSnooze == other.lastSnooze;
        }
        return false;
    }

    public String toString() {
        return "NetworkPolicy[" + this.template + "]: cycleDay=" + this.cycleDay + ", warningBytes=" + this.warningBytes + ", limitBytes=" + this.limitBytes + ", lastSnooze=" + this.lastSnooze;
    }
}

