/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.content.Context;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import java.util.HashMap;

public class WifiP2pManager {
    private static final String TAG = "WifiP2pManager";
    public static final String WIFI_P2P_STATE_CHANGED_ACTION = "android.net.wifi.p2p.STATE_CHANGED";
    public static final String EXTRA_WIFI_STATE = "wifi_p2p_state";
    public static final int WIFI_P2P_STATE_DISABLED = 1;
    public static final int WIFI_P2P_STATE_ENABLED = 2;
    public static final String WIFI_P2P_CONNECTION_CHANGED_ACTION = "android.net.wifi.p2p.CONNECTION_STATE_CHANGE";
    public static final String EXTRA_WIFI_P2P_INFO = "wifiP2pInfo";
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_LINK_PROPERTIES = "linkProperties";
    public static final String EXTRA_LINK_CAPABILITIES = "linkCapabilities";
    public static final String WIFI_P2P_PEERS_CHANGED_ACTION = "android.net.wifi.p2p.PEERS_CHANGED";
    public static final String WIFI_P2P_THIS_DEVICE_CHANGED_ACTION = "android.net.wifi.p2p.THIS_DEVICE_CHANGED";
    public static final String EXTRA_WIFI_P2P_DEVICE = "wifiP2pDevice";
    IWifiP2pManager mService;
    private static final int BASE = 139264;
    public static final int ENABLE_P2P = 139265;
    public static final int ENABLE_P2P_FAILED = 139266;
    public static final int ENABLE_P2P_SUCCEEDED = 139267;
    public static final int DISABLE_P2P = 139268;
    public static final int DISABLE_P2P_FAILED = 139269;
    public static final int DISABLE_P2P_SUCCEEDED = 139270;
    public static final int DISCOVER_PEERS = 139271;
    public static final int DISCOVER_PEERS_FAILED = 139272;
    public static final int DISCOVER_PEERS_SUCCEEDED = 139273;
    public static final int CONNECT = 139274;
    public static final int CONNECT_FAILED = 139275;
    public static final int CONNECT_SUCCEEDED = 139276;
    public static final int CANCEL_CONNECT = 139277;
    public static final int CANCEL_CONNECT_FAILED = 139278;
    public static final int CANCEL_CONNECT_SUCCEEDED = 139279;
    public static final int CREATE_GROUP = 139280;
    public static final int CREATE_GROUP_FAILED = 139281;
    public static final int CREATE_GROUP_SUCCEEDED = 139282;
    public static final int REMOVE_GROUP = 139283;
    public static final int REMOVE_GROUP_FAILED = 139284;
    public static final int REMOVE_GROUP_SUCCEEDED = 139285;
    public static final int REQUEST_PEERS = 139286;
    public static final int RESPONSE_PEERS = 139287;
    public static final int REQUEST_CONNECTION_INFO = 139288;
    public static final int RESPONSE_CONNECTION_INFO = 139289;
    public static final int REQUEST_GROUP_INFO = 139290;
    public static final int RESPONSE_GROUP_INFO = 139291;
    public static final int ERROR = 0;
    public static final int P2P_UNSUPPORTED = 1;
    public static final int BUSY = 2;

    public WifiP2pManager(IWifiP2pManager service) {
        this.mService = service;
    }

    public Channel initialize(Context srcContext, Looper srcLooper, ChannelListener listener) {
        Messenger messenger = this.getMessenger();
        if (messenger == null) {
            return null;
        }
        Channel c = new Channel(srcLooper, listener);
        if (c.mAsyncChannel.connectSync(srcContext, (Handler)c.mHandler, messenger) == 0) {
            return c;
        }
        return null;
    }

    public void enableP2p(Channel c) {
        if (c == null) {
            return;
        }
        c.mAsyncChannel.sendMessage(139265);
    }

    public void disableP2p(Channel c) {
        if (c == null) {
            return;
        }
        c.mAsyncChannel.sendMessage(139268);
    }

    public void discoverPeers(Channel c, ActionListener listener) {
        if (c == null) {
            return;
        }
        c.mAsyncChannel.sendMessage(139271, 0, c.putListener(listener));
    }

    public void connect(Channel c, WifiP2pConfig config, ActionListener listener) {
        if (c == null) {
            return;
        }
        c.mAsyncChannel.sendMessage(139274, 0, c.putListener(listener), config);
    }

    public void cancelConnect(Channel c, ActionListener listener) {
        if (c == null) {
            return;
        }
        c.mAsyncChannel.sendMessage(139277, 0, c.putListener(listener));
    }

    public void createGroup(Channel c, ActionListener listener) {
        if (c == null) {
            return;
        }
        c.mAsyncChannel.sendMessage(139280, 0, c.putListener(listener));
    }

    public void removeGroup(Channel c, ActionListener listener) {
        if (c == null) {
            return;
        }
        c.mAsyncChannel.sendMessage(139283, 0, c.putListener(listener));
    }

    public void requestPeers(Channel c, PeerListListener listener) {
        if (c == null) {
            return;
        }
        c.mAsyncChannel.sendMessage(139286, 0, c.putListener(listener));
    }

    public void requestConnectionInfo(Channel c, ConnectionInfoListener listener) {
        if (c == null) {
            return;
        }
        c.mAsyncChannel.sendMessage(139288, 0, c.putListener(listener));
    }

    public void requestGroupInfo(Channel c, GroupInfoListener listener) {
        if (c == null) {
            return;
        }
        c.mAsyncChannel.sendMessage(139290, 0, c.putListener(listener));
    }

    public Messenger getMessenger() {
        try {
            return this.mService.getMessenger();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public static class Channel {
        private ChannelListener mChannelListener;
        private HashMap<Integer, Object> mListenerMap = new HashMap();
        private Object mListenerMapLock = new Object();
        private int mListenerKey = 0;
        AsyncChannel mAsyncChannel = new AsyncChannel();
        P2pHandler mHandler;

        Channel(Looper looper, ChannelListener l) {
            this.mHandler = new P2pHandler(looper);
            this.mChannelListener = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int putListener(Object listener) {
            int key;
            if (listener == null) {
                return 0;
            }
            Object object = this.mListenerMapLock;
            synchronized (object) {
                key = this.mListenerKey++;
                this.mListenerMap.put(key, listener);
            }
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getListener(int key) {
            Object object = this.mListenerMapLock;
            synchronized (object) {
                return this.mListenerMap.remove(key);
            }
        }

        class P2pHandler
        extends Handler {
            P2pHandler(Looper looper) {
                super(looper);
            }

            public void handleMessage(Message message) {
                Object listener = Channel.this.getListener(message.arg2);
                switch (message.what) {
                    case 69636: {
                        if (Channel.this.mChannelListener == null) break;
                        Channel.this.mChannelListener.onChannelDisconnected();
                        Channel.this.mChannelListener = null;
                        break;
                    }
                    case 139272: 
                    case 139275: 
                    case 139278: 
                    case 139281: 
                    case 139284: {
                        if (listener == null) break;
                        ((ActionListener)listener).onFailure(message.arg1);
                        break;
                    }
                    case 139273: 
                    case 139276: 
                    case 139279: 
                    case 139282: 
                    case 139285: {
                        if (listener == null) break;
                        ((ActionListener)listener).onSuccess();
                        break;
                    }
                    case 139287: {
                        WifiP2pDeviceList peers = (WifiP2pDeviceList)message.obj;
                        if (listener == null) break;
                        ((PeerListListener)listener).onPeersAvailable(peers);
                        break;
                    }
                    case 139289: {
                        WifiP2pInfo wifiP2pInfo = (WifiP2pInfo)message.obj;
                        if (listener == null) break;
                        ((ConnectionInfoListener)listener).onConnectionInfoAvailable(wifiP2pInfo);
                        break;
                    }
                    case 139291: {
                        WifiP2pGroup group = (WifiP2pGroup)message.obj;
                        if (listener == null) break;
                        ((GroupInfoListener)listener).onGroupInfoAvailable(group);
                        break;
                    }
                    default: {
                        Log.d(WifiP2pManager.TAG, "Ignored " + message);
                    }
                }
            }
        }
    }

    public static interface GroupInfoListener {
        public void onGroupInfoAvailable(WifiP2pGroup var1);
    }

    public static interface ConnectionInfoListener {
        public void onConnectionInfoAvailable(WifiP2pInfo var1);
    }

    public static interface PeerListListener {
        public void onPeersAvailable(WifiP2pDeviceList var1);
    }

    public static interface ActionListener {
        public void onSuccess();

        public void onFailure(int var1);
    }

    public static interface ChannelListener {
        public void onChannelDisconnected();
    }
}

