/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.RSDriverException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.Sampler;
import android.util.Log;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;

public class RenderScript {
    static final String LOG_TAG = "RenderScript_jni";
    static final boolean DEBUG = false;
    static final boolean LOG_ENABLED = false;
    private Context mApplicationContext;
    static boolean sInitialized = false;
    int mDev;
    int mContext;
    MessageThread mMessageThread;
    Element mElement_U8;
    Element mElement_I8;
    Element mElement_U16;
    Element mElement_I16;
    Element mElement_U32;
    Element mElement_I32;
    Element mElement_U64;
    Element mElement_I64;
    Element mElement_F32;
    Element mElement_F64;
    Element mElement_BOOLEAN;
    Element mElement_ELEMENT;
    Element mElement_TYPE;
    Element mElement_ALLOCATION;
    Element mElement_SAMPLER;
    Element mElement_SCRIPT;
    Element mElement_MESH;
    Element mElement_PROGRAM_FRAGMENT;
    Element mElement_PROGRAM_VERTEX;
    Element mElement_PROGRAM_RASTER;
    Element mElement_PROGRAM_STORE;
    Element mElement_A_8;
    Element mElement_RGB_565;
    Element mElement_RGB_888;
    Element mElement_RGBA_5551;
    Element mElement_RGBA_4444;
    Element mElement_RGBA_8888;
    Element mElement_FLOAT_2;
    Element mElement_FLOAT_3;
    Element mElement_FLOAT_4;
    Element mElement_DOUBLE_2;
    Element mElement_DOUBLE_3;
    Element mElement_DOUBLE_4;
    Element mElement_UCHAR_2;
    Element mElement_UCHAR_3;
    Element mElement_UCHAR_4;
    Element mElement_CHAR_2;
    Element mElement_CHAR_3;
    Element mElement_CHAR_4;
    Element mElement_USHORT_2;
    Element mElement_USHORT_3;
    Element mElement_USHORT_4;
    Element mElement_SHORT_2;
    Element mElement_SHORT_3;
    Element mElement_SHORT_4;
    Element mElement_UINT_2;
    Element mElement_UINT_3;
    Element mElement_UINT_4;
    Element mElement_INT_2;
    Element mElement_INT_3;
    Element mElement_INT_4;
    Element mElement_ULONG_2;
    Element mElement_ULONG_3;
    Element mElement_ULONG_4;
    Element mElement_LONG_2;
    Element mElement_LONG_3;
    Element mElement_LONG_4;
    Element mElement_MATRIX_4X4;
    Element mElement_MATRIX_3X3;
    Element mElement_MATRIX_2X2;
    Sampler mSampler_CLAMP_NEAREST;
    Sampler mSampler_CLAMP_LINEAR;
    Sampler mSampler_CLAMP_LINEAR_MIP_LINEAR;
    Sampler mSampler_WRAP_NEAREST;
    Sampler mSampler_WRAP_LINEAR;
    Sampler mSampler_WRAP_LINEAR_MIP_LINEAR;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_TEST;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_TEST;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH;
    ProgramRaster mProgramRaster_CULL_BACK;
    ProgramRaster mProgramRaster_CULL_FRONT;
    ProgramRaster mProgramRaster_CULL_NONE;
    RSMessageHandler mMessageCallback = null;
    RSErrorHandler mErrorCallback = null;

    static void _nInit() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#_nInit()V", true, null);
    }

    int nDeviceCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nDeviceCreate()I", true, this);
    }

    void nDeviceDestroy(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nDeviceDestroy(I)V", true, this);
    }

    void nDeviceSetConfig(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nDeviceSetConfig(III)V", true, this);
    }

    int nContextGetUserMessage(int n, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nContextGetUserMessage(I[I)I", true, this);
    }

    String nContextGetErrorMessage(int n) {
        return (String)OverrideMethod.invokeA("android.renderscript.RenderScript#nContextGetErrorMessage(I)Ljava/lang/String;", true, this);
    }

    int nContextPeekMessage(int n, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nContextPeekMessage(I[I)I", true, this);
    }

    void nContextInitToClient(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextInitToClient(I)V", true, this);
    }

    void nContextDeinitToClient(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextDeinitToClient(I)V", true, this);
    }

    int rsnContextCreateGL(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, float f, int n14) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnContextCreateGL(IIIIIIIIIIIIIFI)I", true, this);
    }

    synchronized int nContextCreateGL(int dev, int ver, int sdkVer, int colorMin, int colorPref, int alphaMin, int alphaPref, int depthMin, int depthPref, int stencilMin, int stencilPref, int samplesMin, int samplesPref, float samplesQ, int dpi) {
        return this.rsnContextCreateGL(dev, ver, sdkVer, colorMin, colorPref, alphaMin, alphaPref, depthMin, depthPref, stencilMin, stencilPref, samplesMin, samplesPref, samplesQ, dpi);
    }

    int rsnContextCreate(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnContextCreate(III)I", true, this);
    }

    synchronized int nContextCreate(int dev, int ver, int sdkVer) {
        return this.rsnContextCreate(dev, ver, sdkVer);
    }

    void rsnContextDestroy(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextDestroy(I)V", true, this);
    }

    synchronized void nContextDestroy() {
        this.validate();
        this.rsnContextDestroy(this.mContext);
    }

    void rsnContextSetSurface(int n, int n2, int n3, Surface surface) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSetSurface(IIILandroid/view/Surface;)V", true, this);
    }

    synchronized void nContextSetSurface(int w, int h, Surface sur) {
        this.validate();
        this.rsnContextSetSurface(this.mContext, w, h, sur);
    }

    void rsnContextSetSurfaceTexture(int n, int n2, int n3, SurfaceTexture surfaceTexture) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSetSurfaceTexture(IIILandroid/graphics/SurfaceTexture;)V", true, this);
    }

    synchronized void nContextSetSurfaceTexture(int w, int h, SurfaceTexture sur) {
        this.validate();
        this.rsnContextSetSurfaceTexture(this.mContext, w, h, sur);
    }

    void rsnContextSetPriority(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSetPriority(II)V", true, this);
    }

    synchronized void nContextSetPriority(int p) {
        this.validate();
        this.rsnContextSetPriority(this.mContext, p);
    }

    void rsnContextDump(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextDump(II)V", true, this);
    }

    synchronized void nContextDump(int bits) {
        this.validate();
        this.rsnContextDump(this.mContext, bits);
    }

    void rsnContextFinish(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextFinish(I)V", true, this);
    }

    synchronized void nContextFinish() {
        this.validate();
        this.rsnContextFinish(this.mContext);
    }

    void rsnContextBindRootScript(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindRootScript(II)V", true, this);
    }

    synchronized void nContextBindRootScript(int script) {
        this.validate();
        this.rsnContextBindRootScript(this.mContext, script);
    }

    void rsnContextBindSampler(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindSampler(III)V", true, this);
    }

    synchronized void nContextBindSampler(int sampler, int slot) {
        this.validate();
        this.rsnContextBindSampler(this.mContext, sampler, slot);
    }

    void rsnContextBindProgramStore(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramStore(II)V", true, this);
    }

    synchronized void nContextBindProgramStore(int pfs) {
        this.validate();
        this.rsnContextBindProgramStore(this.mContext, pfs);
    }

    void rsnContextBindProgramFragment(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramFragment(II)V", true, this);
    }

    synchronized void nContextBindProgramFragment(int pf) {
        this.validate();
        this.rsnContextBindProgramFragment(this.mContext, pf);
    }

    void rsnContextBindProgramVertex(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramVertex(II)V", true, this);
    }

    synchronized void nContextBindProgramVertex(int pv) {
        this.validate();
        this.rsnContextBindProgramVertex(this.mContext, pv);
    }

    void rsnContextBindProgramRaster(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramRaster(II)V", true, this);
    }

    synchronized void nContextBindProgramRaster(int pr) {
        this.validate();
        this.rsnContextBindProgramRaster(this.mContext, pr);
    }

    void rsnContextPause(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextPause(I)V", true, this);
    }

    synchronized void nContextPause() {
        this.validate();
        this.rsnContextPause(this.mContext);
    }

    void rsnContextResume(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextResume(I)V", true, this);
    }

    synchronized void nContextResume() {
        this.validate();
        this.rsnContextResume(this.mContext);
    }

    void rsnAssignName(int n, int n2, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAssignName(II[B)V", true, this);
    }

    synchronized void nAssignName(int obj, byte[] name) {
        this.validate();
        this.rsnAssignName(this.mContext, obj, name);
    }

    String rsnGetName(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.renderscript.RenderScript#rsnGetName(II)Ljava/lang/String;", true, this);
    }

    synchronized String nGetName(int obj) {
        this.validate();
        return this.rsnGetName(this.mContext, obj);
    }

    void rsnObjDestroy(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnObjDestroy(II)V", true, this);
    }

    synchronized void nObjDestroy(int id2) {
        if (this.mContext != 0) {
            this.rsnObjDestroy(this.mContext, id2);
        }
    }

    int rsnElementCreate(int n, int n2, int n3, boolean bl, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnElementCreate(IIIZI)I", true, this);
    }

    synchronized int nElementCreate(int type, int kind, boolean norm, int vecSize) {
        this.validate();
        return this.rsnElementCreate(this.mContext, type, kind, norm, vecSize);
    }

    int rsnElementCreate2(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnElementCreate2(I[I[Ljava/lang/String;[I)I", true, this);
    }

    synchronized int nElementCreate2(int[] elements, String[] names, int[] arraySizes) {
        this.validate();
        return this.rsnElementCreate2(this.mContext, elements, names, arraySizes);
    }

    void rsnElementGetNativeData(int n, int n2, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnElementGetNativeData(II[I)V", true, this);
    }

    synchronized void nElementGetNativeData(int id2, int[] elementData) {
        this.validate();
        this.rsnElementGetNativeData(this.mContext, id2, elementData);
    }

    void rsnElementGetSubElements(int n, int n2, int[] nArray, String[] stringArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnElementGetSubElements(II[I[Ljava/lang/String;)V", true, this);
    }

    synchronized void nElementGetSubElements(int id2, int[] IDs, String[] names) {
        this.validate();
        this.rsnElementGetSubElements(this.mContext, id2, IDs, names);
    }

    int rsnTypeCreate(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnTypeCreate(IIIIIZZ)I", true, this);
    }

    synchronized int nTypeCreate(int eid, int x, int y, int z, boolean mips, boolean faces) {
        this.validate();
        return this.rsnTypeCreate(this.mContext, eid, x, y, z, mips, faces);
    }

    void rsnTypeGetNativeData(int n, int n2, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnTypeGetNativeData(II[I)V", true, this);
    }

    synchronized void nTypeGetNativeData(int id2, int[] typeData) {
        this.validate();
        this.rsnTypeGetNativeData(this.mContext, id2, typeData);
    }

    int rsnAllocationCreateTyped(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateTyped(IIII)I", true, this);
    }

    synchronized int nAllocationCreateTyped(int type, int mip, int usage) {
        this.validate();
        return this.rsnAllocationCreateTyped(this.mContext, type, mip, usage);
    }

    int rsnAllocationCreateFromBitmap(int n, int n2, int n3, Bitmap bitmap, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateFromBitmap(IIILandroid/graphics/Bitmap;I)I", true, this);
    }

    synchronized int nAllocationCreateFromBitmap(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    int rsnAllocationCubeCreateFromBitmap(int n, int n2, int n3, Bitmap bitmap, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCubeCreateFromBitmap(IIILandroid/graphics/Bitmap;I)I", true, this);
    }

    synchronized int nAllocationCubeCreateFromBitmap(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCubeCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    int rsnAllocationCreateBitmapRef(int n, int n2, Bitmap bitmap) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateBitmapRef(IILandroid/graphics/Bitmap;)I", true, this);
    }

    synchronized int nAllocationCreateBitmapRef(int type, Bitmap bmp) {
        this.validate();
        return this.rsnAllocationCreateBitmapRef(this.mContext, type, bmp);
    }

    int rsnAllocationCreateFromAssetStream(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateFromAssetStream(IIII)I", true, this);
    }

    synchronized int nAllocationCreateFromAssetStream(int mips, int assetStream, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromAssetStream(this.mContext, mips, assetStream, usage);
    }

    void rsnAllocationCopyToBitmap(int n, int n2, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationCopyToBitmap(IILandroid/graphics/Bitmap;)V", true, this);
    }

    synchronized void nAllocationCopyToBitmap(int alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyToBitmap(this.mContext, alloc, bmp);
    }

    void rsnAllocationSyncAll(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationSyncAll(III)V", true, this);
    }

    synchronized void nAllocationSyncAll(int alloc, int src) {
        this.validate();
        this.rsnAllocationSyncAll(this.mContext, alloc, src);
    }

    void rsnAllocationGenerateMipmaps(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationGenerateMipmaps(II)V", true, this);
    }

    synchronized void nAllocationGenerateMipmaps(int alloc) {
        this.validate();
        this.rsnAllocationGenerateMipmaps(this.mContext, alloc);
    }

    void rsnAllocationCopyFromBitmap(int n, int n2, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationCopyFromBitmap(IILandroid/graphics/Bitmap;)V", true, this);
    }

    synchronized void nAllocationCopyFromBitmap(int alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyFromBitmap(this.mContext, alloc, bmp);
    }

    void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[II)V", true, this);
    }

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, short[] sArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[SI)V", true, this);
    }

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[BI)V", true, this);
    }

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[FI)V", true, this);
    }

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    void rsnAllocationElementData1D(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationElementData1D(IIIII[BI)V", true, this);
    }

    synchronized void nAllocationElementData1D(int id2, int xoff, int mip, int compIdx, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationElementData1D(this.mContext, id2, xoff, mip, compIdx, d, sizeBytes);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIIIIIIII)V", true, this);
    }

    synchronized void nAllocationData2D(int dstAlloc, int dstXoff, int dstYoff, int dstMip, int dstFace, int width, int height, int srcAlloc, int srcXoff, int srcYoff, int srcMip, int srcFace) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, dstAlloc, dstXoff, dstYoff, dstMip, dstFace, width, height, srcAlloc, srcXoff, srcYoff, srcMip, srcFace);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[BI)V", true, this);
    }

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, short[] sArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[SI)V", true, this);
    }

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[II)V", true, this);
    }

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[FI)V", true, this);
    }

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIILandroid/graphics/Bitmap;)V", true, this);
    }

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, Bitmap b) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, b);
    }

    void rsnAllocationRead(int n, int n2, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[B)V", true, this);
    }

    synchronized void nAllocationRead(int id2, byte[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    void rsnAllocationRead(int n, int n2, short[] sArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[S)V", true, this);
    }

    synchronized void nAllocationRead(int id2, short[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    void rsnAllocationRead(int n, int n2, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[I)V", true, this);
    }

    synchronized void nAllocationRead(int id2, int[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    void rsnAllocationRead(int n, int n2, float[] fArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[F)V", true, this);
    }

    synchronized void nAllocationRead(int id2, float[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    int rsnAllocationGetType(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationGetType(II)I", true, this);
    }

    synchronized int nAllocationGetType(int id2) {
        this.validate();
        return this.rsnAllocationGetType(this.mContext, id2);
    }

    void rsnAllocationResize1D(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationResize1D(III)V", true, this);
    }

    synchronized void nAllocationResize1D(int id2, int dimX) {
        this.validate();
        this.rsnAllocationResize1D(this.mContext, id2, dimX);
    }

    void rsnAllocationResize2D(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationResize2D(IIII)V", true, this);
    }

    synchronized void nAllocationResize2D(int id2, int dimX, int dimY) {
        this.validate();
        this.rsnAllocationResize2D(this.mContext, id2, dimX, dimY);
    }

    int rsnFileA3DCreateFromAssetStream(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DCreateFromAssetStream(II)I", true, this);
    }

    synchronized int nFileA3DCreateFromAssetStream(int assetStream) {
        this.validate();
        return this.rsnFileA3DCreateFromAssetStream(this.mContext, assetStream);
    }

    int rsnFileA3DCreateFromFile(int n, String string2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DCreateFromFile(ILjava/lang/String;)I", true, this);
    }

    synchronized int nFileA3DCreateFromFile(String path) {
        this.validate();
        return this.rsnFileA3DCreateFromFile(this.mContext, path);
    }

    int rsnFileA3DCreateFromAsset(int n, AssetManager assetManager, String string2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DCreateFromAsset(ILandroid/content/res/AssetManager;Ljava/lang/String;)I", true, this);
    }

    synchronized int nFileA3DCreateFromAsset(AssetManager mgr, String path) {
        this.validate();
        return this.rsnFileA3DCreateFromAsset(this.mContext, mgr, path);
    }

    int rsnFileA3DGetNumIndexEntries(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DGetNumIndexEntries(II)I", true, this);
    }

    synchronized int nFileA3DGetNumIndexEntries(int fileA3D) {
        this.validate();
        return this.rsnFileA3DGetNumIndexEntries(this.mContext, fileA3D);
    }

    void rsnFileA3DGetIndexEntries(int n, int n2, int n3, int[] nArray, String[] stringArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnFileA3DGetIndexEntries(III[I[Ljava/lang/String;)V", true, this);
    }

    synchronized void nFileA3DGetIndexEntries(int fileA3D, int numEntries, int[] IDs, String[] names) {
        this.validate();
        this.rsnFileA3DGetIndexEntries(this.mContext, fileA3D, numEntries, IDs, names);
    }

    int rsnFileA3DGetEntryByIndex(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DGetEntryByIndex(III)I", true, this);
    }

    synchronized int nFileA3DGetEntryByIndex(int fileA3D, int index) {
        this.validate();
        return this.rsnFileA3DGetEntryByIndex(this.mContext, fileA3D, index);
    }

    int rsnFontCreateFromFile(int n, String string2, float f, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFontCreateFromFile(ILjava/lang/String;FI)I", true, this);
    }

    synchronized int nFontCreateFromFile(String fileName, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromFile(this.mContext, fileName, size, dpi);
    }

    int rsnFontCreateFromAssetStream(int n, String string2, float f, int n2, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFontCreateFromAssetStream(ILjava/lang/String;FII)I", true, this);
    }

    synchronized int nFontCreateFromAssetStream(String name, float size, int dpi, int assetStream) {
        this.validate();
        return this.rsnFontCreateFromAssetStream(this.mContext, name, size, dpi, assetStream);
    }

    int rsnFontCreateFromAsset(int n, AssetManager assetManager, String string2, float f, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFontCreateFromAsset(ILandroid/content/res/AssetManager;Ljava/lang/String;FI)I", true, this);
    }

    synchronized int nFontCreateFromAsset(AssetManager mgr, String path, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromAsset(this.mContext, mgr, path, size, dpi);
    }

    void rsnScriptBindAllocation(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptBindAllocation(IIII)V", true, this);
    }

    synchronized void nScriptBindAllocation(int script, int alloc, int slot) {
        this.validate();
        this.rsnScriptBindAllocation(this.mContext, script, alloc, slot);
    }

    void rsnScriptSetTimeZone(int n, int n2, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetTimeZone(II[B)V", true, this);
    }

    synchronized void nScriptSetTimeZone(int script, byte[] timeZone) {
        this.validate();
        this.rsnScriptSetTimeZone(this.mContext, script, timeZone);
    }

    void rsnScriptInvoke(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptInvoke(III)V", true, this);
    }

    synchronized void nScriptInvoke(int id2, int slot) {
        this.validate();
        this.rsnScriptInvoke(this.mContext, id2, slot);
    }

    void rsnScriptForEach(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEach(IIIII[B)V", true, this);
    }

    void rsnScriptForEach(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEach(IIIII)V", true, this);
    }

    synchronized void nScriptForEach(int id2, int slot, int ain, int aout, byte[] params) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEach(this.mContext, id2, slot, ain, aout);
        } else {
            this.rsnScriptForEach(this.mContext, id2, slot, ain, aout, params);
        }
    }

    void rsnScriptInvokeV(int n, int n2, int n3, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptInvokeV(III[B)V", true, this);
    }

    synchronized void nScriptInvokeV(int id2, int slot, byte[] params) {
        this.validate();
        this.rsnScriptInvokeV(this.mContext, id2, slot, params);
    }

    void rsnScriptSetVarI(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarI(IIII)V", true, this);
    }

    synchronized void nScriptSetVarI(int id2, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarI(this.mContext, id2, slot, val);
    }

    void rsnScriptSetVarJ(int n, int n2, int n3, long l) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarJ(IIIJ)V", true, this);
    }

    synchronized void nScriptSetVarJ(int id2, int slot, long val) {
        this.validate();
        this.rsnScriptSetVarJ(this.mContext, id2, slot, val);
    }

    void rsnScriptSetVarF(int n, int n2, int n3, float f) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarF(IIIF)V", true, this);
    }

    synchronized void nScriptSetVarF(int id2, int slot, float val) {
        this.validate();
        this.rsnScriptSetVarF(this.mContext, id2, slot, val);
    }

    void rsnScriptSetVarD(int n, int n2, int n3, double d) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarD(IIID)V", true, this);
    }

    synchronized void nScriptSetVarD(int id2, int slot, double val) {
        this.validate();
        this.rsnScriptSetVarD(this.mContext, id2, slot, val);
    }

    void rsnScriptSetVarV(int n, int n2, int n3, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarV(III[B)V", true, this);
    }

    synchronized void nScriptSetVarV(int id2, int slot, byte[] val) {
        this.validate();
        this.rsnScriptSetVarV(this.mContext, id2, slot, val);
    }

    void rsnScriptSetVarObj(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarObj(IIII)V", true, this);
    }

    synchronized void nScriptSetVarObj(int id2, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarObj(this.mContext, id2, slot, val);
    }

    int rsnScriptCCreate(int n, String string2, String string3, byte[] byArray, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnScriptCCreate(ILjava/lang/String;Ljava/lang/String;[BI)I", true, this);
    }

    synchronized int nScriptCCreate(String resName, String cacheDir, byte[] script, int length) {
        this.validate();
        return this.rsnScriptCCreate(this.mContext, resName, cacheDir, script, length);
    }

    int rsnSamplerCreate(int n, int n2, int n3, int n4, int n5, int n6, float f) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnSamplerCreate(IIIIIIF)I", true, this);
    }

    synchronized int nSamplerCreate(int magFilter, int minFilter, int wrapS, int wrapT, int wrapR, float aniso) {
        this.validate();
        return this.rsnSamplerCreate(this.mContext, magFilter, minFilter, wrapS, wrapT, wrapR, aniso);
    }

    int rsnProgramStoreCreate(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramStoreCreate(IZZZZZZIII)I", true, this);
    }

    synchronized int nProgramStoreCreate(boolean r, boolean g, boolean b, boolean a, boolean depthMask, boolean dither, int srcMode, int dstMode, int depthFunc) {
        this.validate();
        return this.rsnProgramStoreCreate(this.mContext, r, g, b, a, depthMask, dither, srcMode, dstMode, depthFunc);
    }

    int rsnProgramRasterCreate(int n, boolean bl, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramRasterCreate(IZI)I", true, this);
    }

    synchronized int nProgramRasterCreate(boolean pointSprite, int cullMode) {
        this.validate();
        return this.rsnProgramRasterCreate(this.mContext, pointSprite, cullMode);
    }

    void rsnProgramBindConstants(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindConstants(IIII)V", true, this);
    }

    synchronized void nProgramBindConstants(int pv, int slot, int mID) {
        this.validate();
        this.rsnProgramBindConstants(this.mContext, pv, slot, mID);
    }

    void rsnProgramBindTexture(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindTexture(IIII)V", true, this);
    }

    synchronized void nProgramBindTexture(int vpf, int slot, int a) {
        this.validate();
        this.rsnProgramBindTexture(this.mContext, vpf, slot, a);
    }

    void rsnProgramBindSampler(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindSampler(IIII)V", true, this);
    }

    synchronized void nProgramBindSampler(int vpf, int slot, int s) {
        this.validate();
        this.rsnProgramBindSampler(this.mContext, vpf, slot, s);
    }

    int rsnProgramFragmentCreate(int n, String string2, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramFragmentCreate(ILjava/lang/String;[I)I", true, this);
    }

    synchronized int nProgramFragmentCreate(String shader, int[] params) {
        this.validate();
        return this.rsnProgramFragmentCreate(this.mContext, shader, params);
    }

    int rsnProgramVertexCreate(int n, String string2, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramVertexCreate(ILjava/lang/String;[I)I", true, this);
    }

    synchronized int nProgramVertexCreate(String shader, int[] params) {
        this.validate();
        return this.rsnProgramVertexCreate(this.mContext, shader, params);
    }

    int rsnMeshCreate(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnMeshCreate(I[I[I[I)I", true, this);
    }

    synchronized int nMeshCreate(int[] vtx, int[] idx, int[] prim) {
        this.validate();
        return this.rsnMeshCreate(this.mContext, vtx, idx, prim);
    }

    int rsnMeshGetVertexBufferCount(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnMeshGetVertexBufferCount(II)I", true, this);
    }

    synchronized int nMeshGetVertexBufferCount(int id2) {
        this.validate();
        return this.rsnMeshGetVertexBufferCount(this.mContext, id2);
    }

    int rsnMeshGetIndexCount(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnMeshGetIndexCount(II)I", true, this);
    }

    synchronized int nMeshGetIndexCount(int id2) {
        this.validate();
        return this.rsnMeshGetIndexCount(this.mContext, id2);
    }

    void rsnMeshGetVertices(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnMeshGetVertices(II[II)V", true, this);
    }

    synchronized void nMeshGetVertices(int id2, int[] vtxIds, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetVertices(this.mContext, id2, vtxIds, vtxIdCount);
    }

    void rsnMeshGetIndices(int n, int n2, int[] nArray, int[] nArray2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnMeshGetIndices(II[I[II)V", true, this);
    }

    synchronized void nMeshGetIndices(int id2, int[] idxIds, int[] primitives, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetIndices(this.mContext, id2, idxIds, primitives, vtxIdCount);
    }

    public void setMessageHandler(RSMessageHandler msg) {
        this.mMessageCallback = msg;
    }

    public RSMessageHandler getMessageHandler() {
        return this.mMessageCallback;
    }

    public void setErrorHandler(RSErrorHandler msg) {
        this.mErrorCallback = msg;
    }

    public RSErrorHandler getErrorHandler() {
        return this.mErrorCallback;
    }

    void validate() {
        if (this.mContext == 0) {
            throw new RSInvalidStateException("Calling RS with no Context active.");
        }
    }

    public void setPriority(Priority p) {
        this.validate();
        this.nContextSetPriority(p.mID);
    }

    RenderScript(Context ctx) {
        this.mApplicationContext = ctx.getApplicationContext();
    }

    public Context getApplicationContext() {
        return this.mApplicationContext;
    }

    static int getTargetSdkVersion(Context ctx) {
        return ctx.getApplicationInfo().targetSdkVersion;
    }

    public static RenderScript create(Context ctx) {
        RenderScript rs = new RenderScript(ctx);
        int sdkVersion = RenderScript.getTargetSdkVersion(ctx);
        rs.mDev = rs.nDeviceCreate();
        rs.mContext = rs.nContextCreate(rs.mDev, 0, sdkVersion);
        if (rs.mContext == 0) {
            throw new RSDriverException("Failed to create RS context.");
        }
        rs.mMessageThread = new MessageThread(rs);
        rs.mMessageThread.start();
        return rs;
    }

    public void contextDump() {
        this.validate();
        this.nContextDump(0);
    }

    public void finish() {
        this.nContextFinish();
    }

    public void destroy() {
        this.validate();
        this.nContextDeinitToClient(this.mContext);
        this.mMessageThread.mRun = false;
        try {
            this.mMessageThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.nContextDestroy();
        this.mContext = 0;
        this.nDeviceDestroy(this.mDev);
        this.mDev = 0;
    }

    boolean isAlive() {
        return this.mContext != 0;
    }

    int safeID(BaseObj o) {
        if (o != null) {
            return o.getID();
        }
        return 0;
    }

    static {
        try {
            System.loadLibrary("rs_jni");
            RenderScript._nInit();
            sInitialized = true;
        }
        catch (UnsatisfiedLinkError e) {
            Log.e(LOG_TAG, "Error loading RS jni library: " + e);
            throw new RSRuntimeException("Error loading RS jni library: " + e);
        }
    }

    static class MessageThread
    extends Thread {
        RenderScript mRS;
        boolean mRun = true;
        int[] mAuxData = new int[2];
        static final int RS_MESSAGE_TO_CLIENT_NONE = 0;
        static final int RS_MESSAGE_TO_CLIENT_EXCEPTION = 1;
        static final int RS_MESSAGE_TO_CLIENT_RESIZE = 2;
        static final int RS_MESSAGE_TO_CLIENT_ERROR = 3;
        static final int RS_MESSAGE_TO_CLIENT_USER = 4;
        static final int RS_ERROR_FATAL_UNKNOWN = 4096;

        MessageThread(RenderScript rs) {
            super("RSMessageThread");
            this.mRS = rs;
        }

        public void run() {
            int[] rbuf = new int[16];
            this.mRS.nContextInitToClient(this.mRS.mContext);
            while (this.mRun) {
                rbuf[0] = 0;
                int msg = this.mRS.nContextPeekMessage(this.mRS.mContext, this.mAuxData);
                int size = this.mAuxData[1];
                int subID = this.mAuxData[0];
                if (msg == 4) {
                    if (size >> 2 >= rbuf.length) {
                        rbuf = new int[size + 3 >> 2];
                    }
                    if (this.mRS.nContextGetUserMessage(this.mRS.mContext, rbuf) != 4) {
                        throw new RSDriverException("Error processing message from Renderscript.");
                    }
                    if (this.mRS.mMessageCallback != null) {
                        this.mRS.mMessageCallback.mData = rbuf;
                        this.mRS.mMessageCallback.mID = subID;
                        this.mRS.mMessageCallback.mLength = size;
                        this.mRS.mMessageCallback.run();
                        continue;
                    }
                    throw new RSInvalidStateException("Received a message from the script with no message handler installed.");
                }
                if (msg == 3) {
                    String e = this.mRS.nContextGetErrorMessage(this.mRS.mContext);
                    if (subID >= 4096) {
                        throw new RSRuntimeException("Fatal error " + subID + ", details: " + e);
                    }
                    if (this.mRS.mErrorCallback == null) continue;
                    this.mRS.mErrorCallback.mErrorMessage = e;
                    this.mRS.mErrorCallback.mErrorNum = subID;
                    this.mRS.mErrorCallback.run();
                    continue;
                }
                try {
                    MessageThread.sleep(1L, 0);
                }
                catch (InterruptedException e) {}
            }
            Log.d(RenderScript.LOG_TAG, "MessageThread exiting.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        LOW(15),
        NORMAL(-4);

        int mID;

        private Priority(int id2) {
            this.mID = id2;
        }
    }

    public static class RSErrorHandler
    implements Runnable {
        protected String mErrorMessage;
        protected int mErrorNum;

        public void run() {
        }
    }

    public static class RSMessageHandler
    implements Runnable {
        protected int[] mData;
        protected int mID;
        protected int mLength;

        public void run() {
        }
    }
}

