/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.ActionMode;
import android.view.DisplayList;
import android.view.DragEvent;
import android.view.FocusFinder;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewManager;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.view.animation.Transformation;
import com.android.internal.R;
import com.android.internal.util.Predicate;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewGroup
extends View
implements ViewParent,
ViewManager {
    private static final boolean DBG = false;
    protected ArrayList<View> mDisappearingChildren;
    protected OnHierarchyChangeListener mOnHierarchyChangeListener;
    private View mFocused;
    private final Transformation mChildTransformation = new Transformation();
    private RectF mInvalidateRegion;
    private Transformation mInvalidationTransformation;
    private View mCurrentDragView;
    private DragEvent mCurrentDrag;
    private HashSet<View> mDragNotifiedChildren;
    private boolean mChildAcceptsDrag;
    private final PointF mLocalPoint = new PointF();
    private LayoutAnimationController mLayoutAnimationController;
    private Animation.AnimationListener mAnimationListener;
    private TouchTarget mFirstTouchTarget;
    @ViewDebug.ExportedProperty(category="events")
    private long mLastTouchDownTime;
    @ViewDebug.ExportedProperty(category="events")
    private int mLastTouchDownIndex = -1;
    @ViewDebug.ExportedProperty(category="events")
    private float mLastTouchDownX;
    @ViewDebug.ExportedProperty(category="events")
    private float mLastTouchDownY;
    private HoverTarget mFirstHoverTarget;
    private boolean mHoveredSelf;
    protected int mGroupFlags;
    private static final int FLAG_CLIP_CHILDREN = 1;
    private static final int FLAG_CLIP_TO_PADDING = 2;
    private static final int FLAG_INVALIDATE_REQUIRED = 4;
    private static final int FLAG_RUN_ANIMATION = 8;
    private static final int FLAG_ANIMATION_DONE = 16;
    private static final int FLAG_PADDING_NOT_NULL = 32;
    private static final int FLAG_ANIMATION_CACHE = 64;
    private static final int FLAG_OPTIMIZE_INVALIDATE = 128;
    private static final int FLAG_CLEAR_TRANSFORMATION = 256;
    private static final int FLAG_NOTIFY_ANIMATION_LISTENER = 512;
    protected static final int FLAG_USE_CHILD_DRAWING_ORDER = 1024;
    protected static final int FLAG_SUPPORT_STATIC_TRANSFORMATIONS = 2048;
    private static final int FLAG_ALPHA_LOWER_THAN_ONE = 4096;
    private static final int FLAG_ADD_STATES_FROM_CHILDREN = 8192;
    private static final int FLAG_ALWAYS_DRAWN_WITH_CACHE = 16384;
    private static final int FLAG_CHILDREN_DRAWN_WITH_CACHE = 32768;
    private static final int FLAG_NOTIFY_CHILDREN_ON_DRAWABLE_STATE_CHANGE = 65536;
    private static final int FLAG_MASK_FOCUSABILITY = 393216;
    public static final int FOCUS_BEFORE_DESCENDANTS = 131072;
    public static final int FOCUS_AFTER_DESCENDANTS = 262144;
    public static final int FOCUS_BLOCK_DESCENDANTS = 393216;
    private static final int[] DESCENDANT_FOCUSABILITY_FLAGS = new int[]{131072, 262144, 393216};
    protected static final int FLAG_DISALLOW_INTERCEPT = 524288;
    private static final int FLAG_SPLIT_MOTION_EVENTS = 0x200000;
    private static final int FLAG_PREVENT_DISPATCH_ATTACHED_TO_WINDOW = 0x400000;
    protected int mPersistentDrawingCache;
    public static final int PERSISTENT_NO_CACHE = 0;
    public static final int PERSISTENT_ANIMATION_CACHE = 1;
    public static final int PERSISTENT_SCROLLING_CACHE = 2;
    public static final int PERSISTENT_ALL_CACHES = 3;
    protected static final int CLIP_TO_PADDING_MASK = 34;
    private static final int CHILD_LEFT_INDEX = 0;
    private static final int CHILD_TOP_INDEX = 1;
    private View[] mChildren;
    private boolean mLayoutSuppressed = false;
    private int mChildrenCount;
    private static final int ARRAY_INITIAL_CAPACITY = 12;
    private static final int ARRAY_CAPACITY_INCREMENT = 12;
    private final Paint mCachePaint = new Paint();
    private LayoutTransition mTransition;
    private ArrayList<View> mTransitioningViews;
    private ArrayList<View> mVisibilityChangingChildren;
    @ViewDebug.ExportedProperty(category="drawing")
    private boolean mDrawLayers = true;
    private LayoutTransition.TransitionListener mLayoutTransitionListener = new LayoutTransition.TransitionListener(){

        public void startTransition(LayoutTransition transition, ViewGroup container, View view, int transitionType) {
            if (transitionType == 3) {
                ViewGroup.this.startViewTransition(view);
            }
        }

        public void endTransition(LayoutTransition transition, ViewGroup container, View view, int transitionType) {
            if (ViewGroup.this.mLayoutSuppressed && !transition.isChangingLayout()) {
                ViewGroup.this.requestLayout();
                ViewGroup.this.mLayoutSuppressed = false;
            }
            if (transitionType == 3 && ViewGroup.this.mTransitioningViews != null) {
                ViewGroup.this.endViewTransition(view);
            }
        }
    };

    public ViewGroup(Context context) {
        super(context);
        this.initViewGroup();
    }

    public ViewGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViewGroup();
        this.initFromAttributes(context, attrs);
    }

    public ViewGroup(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initViewGroup();
        this.initFromAttributes(context, attrs);
    }

    private void initViewGroup() {
        this.setFlags(128, 128);
        this.mGroupFlags |= 1;
        this.mGroupFlags |= 2;
        this.mGroupFlags |= 0x10;
        this.mGroupFlags |= 0x40;
        this.mGroupFlags |= 0x4000;
        if (this.mContext.getApplicationInfo().targetSdkVersion >= 11) {
            this.mGroupFlags |= 0x200000;
        }
        this.setDescendantFocusability(131072);
        this.mChildren = new View[12];
        this.mChildrenCount = 0;
        this.mCachePaint.setDither(false);
        this.mPersistentDrawingCache = 2;
    }

    private void initFromAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewGroup);
        int N = a.getIndexCount();
        block12: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 0: {
                    this.setClipChildren(a.getBoolean(attr2, true));
                    continue block12;
                }
                case 1: {
                    this.setClipToPadding(a.getBoolean(attr2, true));
                    continue block12;
                }
                case 3: {
                    this.setAnimationCacheEnabled(a.getBoolean(attr2, true));
                    continue block12;
                }
                case 4: {
                    this.setPersistentDrawingCache(a.getInt(attr2, 2));
                    continue block12;
                }
                case 6: {
                    this.setAddStatesFromChildren(a.getBoolean(attr2, false));
                    continue block12;
                }
                case 5: {
                    this.setAlwaysDrawnWithCacheEnabled(a.getBoolean(attr2, true));
                    continue block12;
                }
                case 2: {
                    int id2 = a.getResourceId(attr2, -1);
                    if (id2 <= 0) continue block12;
                    this.setLayoutAnimation(AnimationUtils.loadLayoutAnimation(this.mContext, id2));
                    continue block12;
                }
                case 7: {
                    this.setDescendantFocusability(DESCENDANT_FOCUSABILITY_FLAGS[a.getInt(attr2, 0)]);
                    continue block12;
                }
                case 8: {
                    this.setMotionEventSplittingEnabled(a.getBoolean(attr2, false));
                    continue block12;
                }
                case 9: {
                    boolean animateLayoutChanges = a.getBoolean(attr2, false);
                    if (!animateLayoutChanges) continue block12;
                    this.setLayoutTransition(new LayoutTransition());
                }
            }
        }
        a.recycle();
    }

    @ViewDebug.ExportedProperty(category="focus", mapping={@ViewDebug.IntToString(from=131072, to="FOCUS_BEFORE_DESCENDANTS"), @ViewDebug.IntToString(from=262144, to="FOCUS_AFTER_DESCENDANTS"), @ViewDebug.IntToString(from=393216, to="FOCUS_BLOCK_DESCENDANTS")})
    public int getDescendantFocusability() {
        return this.mGroupFlags & 0x60000;
    }

    public void setDescendantFocusability(int focusability) {
        switch (focusability) {
            case 131072: 
            case 262144: 
            case 393216: {
                break;
            }
            default: {
                throw new IllegalArgumentException("must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS");
            }
        }
        this.mGroupFlags &= 0xFFF9FFFF;
        this.mGroupFlags |= focusability & 0x60000;
    }

    @Override
    void handleFocusGainInternal(int direction, Rect previouslyFocusedRect) {
        if (this.mFocused != null) {
            this.mFocused.unFocus();
            this.mFocused = null;
        }
        super.handleFocusGainInternal(direction, previouslyFocusedRect);
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        super.unFocus();
        if (this.mFocused != child) {
            if (this.mFocused != null) {
                this.mFocused.unFocus();
            }
            this.mFocused = child;
        }
        if (this.mParent != null) {
            this.mParent.requestChildFocus(this, focused);
        }
    }

    @Override
    public void focusableViewAvailable(View v) {
        if (!(this.mParent == null || this.getDescendantFocusability() == 393216 || this.isFocused() && this.getDescendantFocusability() != 262144)) {
            this.mParent.focusableViewAvailable(v);
        }
    }

    @Override
    public boolean showContextMenuForChild(View originalView) {
        return this.mParent != null && this.mParent.showContextMenuForChild(originalView);
    }

    @Override
    public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback) {
        return this.mParent != null ? this.mParent.startActionModeForChild(originalView, callback) : null;
    }

    @Override
    public View focusSearch(View focused, int direction) {
        if (this.isRootNamespace()) {
            return FocusFinder.getInstance().findNextFocus(this, focused, direction);
        }
        if (this.mParent != null) {
            return this.mParent.focusSearch(focused, direction);
        }
        return null;
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        return false;
    }

    @Override
    public boolean requestSendAccessibilityEvent(View child, AccessibilityEvent event) {
        ViewParent parent = this.getParent();
        if (parent == null) {
            return false;
        }
        boolean propagate = this.onRequestSendAccessibilityEvent(child, event);
        if (!propagate) {
            return false;
        }
        return parent.requestSendAccessibilityEvent(this, event);
    }

    public boolean onRequestSendAccessibilityEvent(View child, AccessibilityEvent event) {
        if (this.mAccessibilityDelegate != null) {
            return this.mAccessibilityDelegate.onRequestSendAccessibilityEvent(this, child, event);
        }
        return this.onRequestSendAccessibilityEventInternal(child, event);
    }

    boolean onRequestSendAccessibilityEventInternal(View child, AccessibilityEvent event) {
        return true;
    }

    @Override
    public boolean dispatchUnhandledMove(View focused, int direction) {
        return this.mFocused != null && this.mFocused.dispatchUnhandledMove(focused, direction);
    }

    @Override
    public void clearChildFocus(View child) {
        this.mFocused = null;
        if (this.mParent != null) {
            this.mParent.clearChildFocus(this);
        }
    }

    @Override
    public void clearFocus() {
        super.clearFocus();
        if (this.mFocused != null) {
            this.mFocused.clearFocus();
        }
    }

    @Override
    void unFocus() {
        super.unFocus();
        if (this.mFocused != null) {
            this.mFocused.unFocus();
        }
        this.mFocused = null;
    }

    public View getFocusedChild() {
        return this.mFocused;
    }

    @Override
    public boolean hasFocus() {
        return (this.mPrivateFlags & 2) != 0 || this.mFocused != null;
    }

    @Override
    public View findFocus() {
        if (this.isFocused()) {
            return this;
        }
        if (this.mFocused != null) {
            return this.mFocused.findFocus();
        }
        return null;
    }

    @Override
    public boolean hasFocusable() {
        if ((this.mViewFlags & 0xC) != 0) {
            return false;
        }
        if (this.isFocusable()) {
            return true;
        }
        int descendantFocusability = this.getDescendantFocusability();
        if (descendantFocusability != 393216) {
            int count = this.mChildrenCount;
            View[] children = this.mChildren;
            for (int i = 0; i < count; ++i) {
                View child = children[i];
                if (!child.hasFocusable()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addFocusables(ArrayList<View> views, int direction) {
        this.addFocusables(views, direction, 1);
    }

    @Override
    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        int focusableCount = views.size();
        int descendantFocusability = this.getDescendantFocusability();
        if (descendantFocusability != 393216) {
            int count = this.mChildrenCount;
            View[] children = this.mChildren;
            for (int i = 0; i < count; ++i) {
                View child = children[i];
                if ((child.mViewFlags & 0xC) != 0) continue;
                child.addFocusables(views, direction, focusableMode);
            }
        }
        if (descendantFocusability != 262144 || focusableCount == views.size()) {
            super.addFocusables(views, direction, focusableMode);
        }
    }

    @Override
    public void findViewsWithText(ArrayList<View> outViews, CharSequence text, int flags) {
        super.findViewsWithText(outViews, text, flags);
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < childrenCount; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0 || (child.mPrivateFlags & 8) != 0) continue;
            child.findViewsWithText(outViews, text, flags);
        }
    }

    @Override
    View findViewByAccessibilityIdTraversal(int accessibilityId) {
        View foundView = super.findViewByAccessibilityIdTraversal(accessibilityId);
        if (foundView != null) {
            return foundView;
        }
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < childrenCount; ++i) {
            View child = children[i];
            foundView = child.findViewByAccessibilityIdTraversal(accessibilityId);
            if (foundView == null) continue;
            return foundView;
        }
        return null;
    }

    @Override
    public void dispatchWindowFocusChanged(boolean hasFocus) {
        super.dispatchWindowFocusChanged(hasFocus);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchWindowFocusChanged(hasFocus);
        }
    }

    @Override
    public void addTouchables(ArrayList<View> views) {
        super.addTouchables(views);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0) continue;
            child.addTouchables(views);
        }
    }

    @Override
    public void dispatchDisplayHint(int hint) {
        super.dispatchDisplayHint(hint);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchDisplayHint(hint);
        }
    }

    protected void onChildVisibilityChanged(View child, int visibility) {
        if (this.mTransition != null) {
            if (visibility == 0) {
                this.mTransition.showChild(this, child);
            } else {
                this.mTransition.hideChild(this, child);
            }
            if (visibility != 0) {
                if (this.mVisibilityChangingChildren == null) {
                    this.mVisibilityChangingChildren = new ArrayList();
                }
                this.mVisibilityChangingChildren.add(child);
                if (this.mTransitioningViews != null && this.mTransitioningViews.contains(child)) {
                    this.addDisappearingView(child);
                }
            }
        }
        if (this.mCurrentDrag != null && visibility == 0) {
            this.notifyChildOfDrag(child);
        }
    }

    @Override
    protected void dispatchVisibilityChanged(View changedView, int visibility) {
        super.dispatchVisibilityChanged(changedView, visibility);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchVisibilityChanged(changedView, visibility);
        }
    }

    @Override
    public void dispatchWindowVisibilityChanged(int visibility) {
        super.dispatchWindowVisibilityChanged(visibility);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchWindowVisibilityChanged(visibility);
        }
    }

    @Override
    public void dispatchConfigurationChanged(Configuration newConfig) {
        super.dispatchConfigurationChanged(newConfig);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchConfigurationChanged(newConfig);
        }
    }

    @Override
    public void recomputeViewAttributes(View child) {
        ViewParent parent;
        if (this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes && (parent = this.mParent) != null) {
            parent.recomputeViewAttributes(this);
        }
    }

    @Override
    void dispatchCollectViewAttributes(int visibility) {
        super.dispatchCollectViewAttributes(visibility |= this.mViewFlags & 0xC);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchCollectViewAttributes(visibility);
        }
    }

    @Override
    public void bringChildToFront(View child) {
        int index = this.indexOfChild(child);
        if (index >= 0) {
            this.removeFromArray(index);
            this.addInArray(child, this.mChildrenCount);
            child.mParent = this;
        }
    }

    @Override
    public boolean dispatchDragEvent(DragEvent event) {
        boolean retval = false;
        float tx = event.mX;
        float ty = event.mY;
        ViewRootImpl root = this.getViewRootImpl();
        switch (event.mAction) {
            case 1: {
                this.mCurrentDragView = null;
                this.mCurrentDrag = DragEvent.obtain(event);
                if (this.mDragNotifiedChildren == null) {
                    this.mDragNotifiedChildren = new HashSet();
                } else {
                    this.mDragNotifiedChildren.clear();
                }
                this.mChildAcceptsDrag = false;
                int count = this.mChildrenCount;
                View[] children = this.mChildren;
                for (int i = 0; i < count; ++i) {
                    boolean handled;
                    View child = children[i];
                    child.mPrivateFlags2 &= 0xFFFFFFFC;
                    if (child.getVisibility() != 0 || !(handled = this.notifyChildOfDrag(children[i]))) continue;
                    this.mChildAcceptsDrag = true;
                }
                if (!this.mChildAcceptsDrag) break;
                retval = true;
                break;
            }
            case 4: {
                if (this.mDragNotifiedChildren != null) {
                    for (View child : this.mDragNotifiedChildren) {
                        child.dispatchDragEvent(event);
                        child.mPrivateFlags2 &= 0xFFFFFFFC;
                        child.refreshDrawableState();
                    }
                    this.mDragNotifiedChildren.clear();
                    this.mCurrentDrag.recycle();
                    this.mCurrentDrag = null;
                }
                if (!this.mChildAcceptsDrag) break;
                retval = true;
                break;
            }
            case 2: {
                View target = this.findFrontmostDroppableChildAt(event.mX, event.mY, this.mLocalPoint);
                if (this.mCurrentDragView != target) {
                    root.setDragFocus(target);
                    int action = event.mAction;
                    if (this.mCurrentDragView != null) {
                        View view = this.mCurrentDragView;
                        event.mAction = 6;
                        view.dispatchDragEvent(event);
                        view.mPrivateFlags2 &= 0xFFFFFFFD;
                        view.refreshDrawableState();
                    }
                    this.mCurrentDragView = target;
                    if (target != null) {
                        event.mAction = 5;
                        target.dispatchDragEvent(event);
                        target.mPrivateFlags2 |= 2;
                        target.refreshDrawableState();
                    }
                    event.mAction = action;
                }
                if (target == null) break;
                event.mX = this.mLocalPoint.x;
                event.mY = this.mLocalPoint.y;
                retval = target.dispatchDragEvent(event);
                event.mX = tx;
                event.mY = ty;
                break;
            }
            case 6: {
                if (this.mCurrentDragView == null) break;
                View view = this.mCurrentDragView;
                view.dispatchDragEvent(event);
                view.mPrivateFlags2 &= 0xFFFFFFFD;
                view.refreshDrawableState();
                this.mCurrentDragView = null;
                break;
            }
            case 3: {
                View target = this.findFrontmostDroppableChildAt(event.mX, event.mY, this.mLocalPoint);
                if (target == null) break;
                event.mX = this.mLocalPoint.x;
                event.mY = this.mLocalPoint.y;
                retval = target.dispatchDragEvent(event);
                event.mX = tx;
                event.mY = ty;
            }
        }
        if (!retval) {
            retval = super.dispatchDragEvent(event);
        }
        return retval;
    }

    View findFrontmostDroppableChildAt(float x, float y, PointF outLocalPoint) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = count - 1; i >= 0; --i) {
            View child = children[i];
            if (!child.canAcceptDrag() || !this.isTransformedTouchPointInView(x, y, child, outLocalPoint)) continue;
            return child;
        }
        return null;
    }

    boolean notifyChildOfDrag(View child) {
        boolean canAccept = false;
        if (!this.mDragNotifiedChildren.contains(child)) {
            this.mDragNotifiedChildren.add(child);
            canAccept = child.dispatchDragEvent(this.mCurrentDrag);
            if (canAccept && !child.canAcceptDrag()) {
                child.mPrivateFlags2 |= 1;
                child.refreshDrawableState();
            }
        }
        return canAccept;
    }

    @Override
    public void dispatchSystemUiVisibilityChanged(int visible) {
        super.dispatchSystemUiVisibilityChanged(visible);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            child.dispatchSystemUiVisibilityChanged(visible);
        }
    }

    @Override
    void updateLocalSystemUiVisibility(int localValue, int localChanges) {
        super.updateLocalSystemUiVisibility(localValue, localChanges);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            child.updateLocalSystemUiVisibility(localValue, localChanges);
        }
    }

    @Override
    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchKeyEventPreIme(event);
        }
        if (this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16) {
            return this.mFocused.dispatchKeyEventPreIme(event);
        }
        return false;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onKeyEvent(event, 1);
        }
        if ((this.mPrivateFlags & 0x12) == 18 ? super.dispatchKeyEvent(event) : this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16 && this.mFocused.dispatchKeyEvent(event)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 1);
        }
        return false;
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchKeyShortcutEvent(event);
        }
        if (this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16) {
            return this.mFocused.dispatchKeyShortcutEvent(event);
        }
        return false;
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent event) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTrackballEvent(event, 1);
        }
        if ((this.mPrivateFlags & 0x12) == 18 ? super.dispatchTrackballEvent(event) : this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16 && this.mFocused.dispatchTrackballEvent(event)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 1);
        }
        return false;
    }

    @Override
    protected boolean dispatchHoverEvent(MotionEvent event) {
        boolean newHoveredSelf;
        int action = event.getAction();
        boolean interceptHover = this.onInterceptHoverEvent(event);
        event.setAction(action);
        MotionEvent eventNoHistory = event;
        boolean handled = false;
        HoverTarget firstOldHoverTarget = this.mFirstHoverTarget;
        this.mFirstHoverTarget = null;
        if (!interceptHover && action != 10) {
            float x = event.getX();
            float y = event.getY();
            int childrenCount = this.mChildrenCount;
            if (childrenCount != 0) {
                View[] children = this.mChildren;
                HoverTarget lastHoverTarget = null;
                for (int i = childrenCount - 1; i >= 0; --i) {
                    boolean wasHovered;
                    View child = children[i];
                    if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null)) continue;
                    HoverTarget hoverTarget = firstOldHoverTarget;
                    HoverTarget predecessor = null;
                    while (true) {
                        if (hoverTarget == null) {
                            hoverTarget = HoverTarget.obtain(child);
                            wasHovered = false;
                            break;
                        }
                        if (hoverTarget.child == child) {
                            if (predecessor != null) {
                                predecessor.next = hoverTarget.next;
                            } else {
                                firstOldHoverTarget = hoverTarget.next;
                            }
                            hoverTarget.next = null;
                            wasHovered = true;
                            break;
                        }
                        predecessor = hoverTarget;
                        hoverTarget = hoverTarget.next;
                    }
                    if (lastHoverTarget != null) {
                        lastHoverTarget.next = hoverTarget;
                    } else {
                        lastHoverTarget = hoverTarget;
                        this.mFirstHoverTarget = hoverTarget;
                    }
                    if (action == 9) {
                        if (!wasHovered) {
                            handled |= this.dispatchTransformedGenericPointerEvent(event, child);
                        }
                    } else if (action == 7) {
                        if (!wasHovered) {
                            eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                            eventNoHistory.setAction(9);
                            handled |= this.dispatchTransformedGenericPointerEvent(eventNoHistory, child);
                            eventNoHistory.setAction(action);
                            handled |= this.dispatchTransformedGenericPointerEvent(eventNoHistory, child);
                        } else {
                            handled |= this.dispatchTransformedGenericPointerEvent(event, child);
                        }
                    }
                    if (handled) break;
                }
            }
        }
        while (firstOldHoverTarget != null) {
            View child = firstOldHoverTarget.child;
            if (action == 10) {
                handled |= this.dispatchTransformedGenericPointerEvent(event, child);
            } else {
                if (action == 7) {
                    this.dispatchTransformedGenericPointerEvent(event, child);
                }
                eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                eventNoHistory.setAction(10);
                this.dispatchTransformedGenericPointerEvent(eventNoHistory, child);
                eventNoHistory.setAction(action);
            }
            HoverTarget nextOldHoverTarget = firstOldHoverTarget.next;
            firstOldHoverTarget.recycle();
            firstOldHoverTarget = nextOldHoverTarget;
        }
        boolean bl = newHoveredSelf = !handled;
        if (newHoveredSelf == this.mHoveredSelf) {
            if (newHoveredSelf) {
                handled |= super.dispatchHoverEvent(event);
            }
        } else {
            if (this.mHoveredSelf) {
                if (action == 10) {
                    handled |= super.dispatchHoverEvent(event);
                } else {
                    if (action == 7) {
                        super.dispatchHoverEvent(event);
                    }
                    eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                    eventNoHistory.setAction(10);
                    super.dispatchHoverEvent(eventNoHistory);
                    eventNoHistory.setAction(action);
                }
                this.mHoveredSelf = false;
            }
            if (newHoveredSelf) {
                if (action == 9) {
                    handled |= super.dispatchHoverEvent(event);
                    this.mHoveredSelf = true;
                } else if (action == 7) {
                    eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                    eventNoHistory.setAction(9);
                    handled |= super.dispatchHoverEvent(eventNoHistory);
                    eventNoHistory.setAction(action);
                    handled |= super.dispatchHoverEvent(eventNoHistory);
                    this.mHoveredSelf = true;
                }
            }
        }
        if (eventNoHistory != event) {
            eventNoHistory.recycle();
        }
        return handled;
    }

    @Override
    protected boolean hasHoveredChild() {
        return this.mFirstHoverTarget != null;
    }

    public boolean onInterceptHoverEvent(MotionEvent event) {
        return false;
    }

    private static MotionEvent obtainMotionEventNoHistoryOrSelf(MotionEvent event) {
        if (event.getHistorySize() == 0) {
            return event;
        }
        return MotionEvent.obtainNoHistory(event);
    }

    @Override
    protected boolean dispatchGenericPointerEvent(MotionEvent event) {
        int childrenCount = this.mChildrenCount;
        if (childrenCount != 0) {
            View[] children = this.mChildren;
            float x = event.getX();
            float y = event.getY();
            for (int i = childrenCount - 1; i >= 0; --i) {
                View child = children[i];
                if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null) || !this.dispatchTransformedGenericPointerEvent(event, child)) continue;
                return true;
            }
        }
        return super.dispatchGenericPointerEvent(event);
    }

    @Override
    protected boolean dispatchGenericFocusedEvent(MotionEvent event) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchGenericFocusedEvent(event);
        }
        if (this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16) {
            return this.mFocused.dispatchGenericMotionEvent(event);
        }
        return false;
    }

    private boolean dispatchTransformedGenericPointerEvent(MotionEvent event, View child) {
        boolean handled;
        float offsetX = this.mScrollX - child.mLeft;
        float offsetY = this.mScrollY - child.mTop;
        if (!child.hasIdentityMatrix()) {
            MotionEvent transformedEvent = MotionEvent.obtain(event);
            transformedEvent.offsetLocation(offsetX, offsetY);
            transformedEvent.transform(child.getInverseMatrix());
            handled = child.dispatchGenericMotionEvent(transformedEvent);
            transformedEvent.recycle();
        } else {
            event.offsetLocation(offsetX, offsetY);
            handled = child.dispatchGenericMotionEvent(event);
            event.offsetLocation(-offsetX, -offsetY);
        }
        return handled;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTouchEvent(ev, 1);
        }
        boolean handled = false;
        if (this.onFilterTouchEventForSecurity(ev)) {
            int actionIndex;
            boolean intercepted;
            int action = ev.getAction();
            int actionMasked = action & 0xFF;
            if (actionMasked == 0) {
                this.cancelAndClearTouchTargets(ev);
                this.resetTouchState();
            }
            if (actionMasked == 0 || this.mFirstTouchTarget != null) {
                boolean disallowIntercept;
                boolean bl = disallowIntercept = (this.mGroupFlags & 0x80000) != 0;
                if (!disallowIntercept) {
                    intercepted = this.onInterceptTouchEvent(ev);
                    ev.setAction(action);
                } else {
                    intercepted = false;
                }
            } else {
                intercepted = true;
            }
            boolean canceled = this.resetCancelNextUpFlag(this) || actionMasked == 3;
            boolean split = (this.mGroupFlags & 0x200000) != 0;
            TouchTarget newTouchTarget = null;
            boolean alreadyDispatchedToNewTouchTarget = false;
            if (!canceled && !intercepted && (actionMasked == 0 || split && actionMasked == 5 || actionMasked == 7)) {
                actionIndex = ev.getActionIndex();
                int idBitsToAssign = split ? 1 << ev.getPointerId(actionIndex) : -1;
                this.removePointersFromTouchTargets(idBitsToAssign);
                int childrenCount = this.mChildrenCount;
                if (childrenCount != 0) {
                    View[] children = this.mChildren;
                    float x = ev.getX(actionIndex);
                    float y = ev.getY(actionIndex);
                    for (int i = childrenCount - 1; i >= 0; --i) {
                        View child = children[i];
                        if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null)) continue;
                        newTouchTarget = this.getTouchTarget(child);
                        if (newTouchTarget != null) {
                            newTouchTarget.pointerIdBits |= idBitsToAssign;
                            break;
                        }
                        this.resetCancelNextUpFlag(child);
                        if (!this.dispatchTransformedTouchEvent(ev, false, child, idBitsToAssign)) continue;
                        this.mLastTouchDownTime = ev.getDownTime();
                        this.mLastTouchDownIndex = i;
                        this.mLastTouchDownX = ev.getX();
                        this.mLastTouchDownY = ev.getY();
                        newTouchTarget = this.addTouchTarget(child, idBitsToAssign);
                        alreadyDispatchedToNewTouchTarget = true;
                        break;
                    }
                }
                if (newTouchTarget == null && this.mFirstTouchTarget != null) {
                    newTouchTarget = this.mFirstTouchTarget;
                    while (newTouchTarget.next != null) {
                        newTouchTarget = newTouchTarget.next;
                    }
                    newTouchTarget.pointerIdBits |= idBitsToAssign;
                }
            }
            if (this.mFirstTouchTarget == null) {
                handled = this.dispatchTransformedTouchEvent(ev, canceled, null, -1);
            } else {
                TouchTarget predecessor = null;
                TouchTarget target = this.mFirstTouchTarget;
                while (target != null) {
                    TouchTarget next = target.next;
                    if (alreadyDispatchedToNewTouchTarget && target == newTouchTarget) {
                        handled = true;
                    } else {
                        boolean cancelChild;
                        boolean bl = cancelChild = this.resetCancelNextUpFlag(target.child) || intercepted;
                        if (this.dispatchTransformedTouchEvent(ev, cancelChild, target.child, target.pointerIdBits)) {
                            handled = true;
                        }
                        if (cancelChild) {
                            if (predecessor == null) {
                                this.mFirstTouchTarget = next;
                            } else {
                                predecessor.next = next;
                            }
                            target.recycle();
                            target = next;
                            continue;
                        }
                    }
                    predecessor = target;
                    target = next;
                }
            }
            if (canceled || actionMasked == 1 || actionMasked == 7) {
                this.resetTouchState();
            } else if (split && actionMasked == 6) {
                actionIndex = ev.getActionIndex();
                int idBitsToRemove = 1 << ev.getPointerId(actionIndex);
                this.removePointersFromTouchTargets(idBitsToRemove);
            }
        }
        if (!handled && this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(ev, 1);
        }
        return handled;
    }

    private void resetTouchState() {
        this.clearTouchTargets();
        this.resetCancelNextUpFlag(this);
        this.mGroupFlags &= 0xFFF7FFFF;
    }

    private boolean resetCancelNextUpFlag(View view) {
        if ((view.mPrivateFlags & 0x4000000) != 0) {
            view.mPrivateFlags &= 0xFBFFFFFF;
            return true;
        }
        return false;
    }

    private void clearTouchTargets() {
        TouchTarget target = this.mFirstTouchTarget;
        if (target != null) {
            TouchTarget next;
            do {
                next = target.next;
                target.recycle();
            } while ((target = next) != null);
            this.mFirstTouchTarget = null;
        }
    }

    private void cancelAndClearTouchTargets(MotionEvent event) {
        if (this.mFirstTouchTarget != null) {
            boolean syntheticEvent = false;
            if (event == null) {
                long now = SystemClock.uptimeMillis();
                event = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
                event.setSource(4098);
                syntheticEvent = true;
            }
            TouchTarget target = this.mFirstTouchTarget;
            while (target != null) {
                this.resetCancelNextUpFlag(target.child);
                this.dispatchTransformedTouchEvent(event, true, target.child, target.pointerIdBits);
                target = target.next;
            }
            this.clearTouchTargets();
            if (syntheticEvent) {
                event.recycle();
            }
        }
    }

    private TouchTarget getTouchTarget(View child) {
        TouchTarget target = this.mFirstTouchTarget;
        while (target != null) {
            if (target.child == child) {
                return target;
            }
            target = target.next;
        }
        return null;
    }

    private TouchTarget addTouchTarget(View child, int pointerIdBits) {
        TouchTarget target = TouchTarget.obtain(child, pointerIdBits);
        target.next = this.mFirstTouchTarget;
        this.mFirstTouchTarget = target;
        return target;
    }

    private void removePointersFromTouchTargets(int pointerIdBits) {
        TouchTarget predecessor = null;
        TouchTarget target = this.mFirstTouchTarget;
        while (target != null) {
            TouchTarget next = target.next;
            if ((target.pointerIdBits & pointerIdBits) != 0) {
                target.pointerIdBits &= ~pointerIdBits;
                if (target.pointerIdBits == 0) {
                    if (predecessor == null) {
                        this.mFirstTouchTarget = next;
                    } else {
                        predecessor.next = next;
                    }
                    target.recycle();
                    target = next;
                    continue;
                }
            }
            predecessor = target;
            target = next;
        }
    }

    private static boolean canViewReceivePointerEvents(View child) {
        return (child.mViewFlags & 0xC) == 0 || child.getAnimation() != null;
    }

    protected boolean isTransformedTouchPointInView(float x, float y, View child, PointF outLocalPoint) {
        boolean isInView;
        float localX = x + (float)this.mScrollX - (float)child.mLeft;
        float localY = y + (float)this.mScrollY - (float)child.mTop;
        if (!child.hasIdentityMatrix() && this.mAttachInfo != null) {
            float[] localXY = this.mAttachInfo.mTmpTransformLocation;
            localXY[0] = localX;
            localXY[1] = localY;
            child.getInverseMatrix().mapPoints(localXY);
            localX = localXY[0];
            localY = localXY[1];
        }
        if ((isInView = child.pointInView(localX, localY)) && outLocalPoint != null) {
            outLocalPoint.set(localX, localY);
        }
        return isInView;
    }

    private boolean dispatchTransformedTouchEvent(MotionEvent event, boolean cancel, View child, int desiredPointerIdBits) {
        boolean handled;
        MotionEvent transformedEvent;
        int oldAction = event.getAction();
        if (cancel || oldAction == 3) {
            event.setAction(3);
            boolean handled2 = child == null ? super.dispatchTouchEvent(event) : child.dispatchTouchEvent(event);
            event.setAction(oldAction);
            return handled2;
        }
        int oldPointerIdBits = event.getPointerIdBits();
        int newPointerIdBits = oldPointerIdBits & desiredPointerIdBits;
        if (newPointerIdBits == 0) {
            return false;
        }
        if (newPointerIdBits == oldPointerIdBits) {
            if (child == null || child.hasIdentityMatrix()) {
                boolean handled3;
                if (child == null) {
                    handled3 = super.dispatchTouchEvent(event);
                } else {
                    float offsetX = this.mScrollX - child.mLeft;
                    float offsetY = this.mScrollY - child.mTop;
                    event.offsetLocation(offsetX, offsetY);
                    handled3 = child.dispatchTouchEvent(event);
                    event.offsetLocation(-offsetX, -offsetY);
                }
                return handled3;
            }
            transformedEvent = MotionEvent.obtain(event);
        } else {
            transformedEvent = event.split(newPointerIdBits);
        }
        if (child == null) {
            handled = super.dispatchTouchEvent(transformedEvent);
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            transformedEvent.offsetLocation(offsetX, offsetY);
            if (!child.hasIdentityMatrix()) {
                transformedEvent.transform(child.getInverseMatrix());
            }
            handled = child.dispatchTouchEvent(transformedEvent);
        }
        transformedEvent.recycle();
        return handled;
    }

    public void setMotionEventSplittingEnabled(boolean split) {
        this.mGroupFlags = split ? (this.mGroupFlags |= 0x200000) : (this.mGroupFlags &= 0xFFDFFFFF);
    }

    public boolean isMotionEventSplittingEnabled() {
        return (this.mGroupFlags & 0x200000) == 0x200000;
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept == ((this.mGroupFlags & 0x80000) != 0)) {
            return;
        }
        this.mGroupFlags = disallowIntercept ? (this.mGroupFlags |= 0x80000) : (this.mGroupFlags &= 0xFFF7FFFF);
        if (this.mParent != null) {
            this.mParent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return false;
    }

    @Override
    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        int descendantFocusability = this.getDescendantFocusability();
        switch (descendantFocusability) {
            case 393216: {
                return super.requestFocus(direction, previouslyFocusedRect);
            }
            case 131072: {
                boolean took = super.requestFocus(direction, previouslyFocusedRect);
                return took ? took : this.onRequestFocusInDescendants(direction, previouslyFocusedRect);
            }
            case 262144: {
                boolean took = this.onRequestFocusInDescendants(direction, previouslyFocusedRect);
                return took ? took : super.requestFocus(direction, previouslyFocusedRect);
            }
        }
        throw new IllegalStateException("descendant focusability must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS but is " + descendantFocusability);
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        int end;
        int increment;
        int index;
        int count = this.mChildrenCount;
        if ((direction & 2) != 0) {
            index = 0;
            increment = 1;
            end = count;
        } else {
            index = count - 1;
            increment = -1;
            end = -1;
        }
        View[] children = this.mChildren;
        for (int i = index; i != end; i += increment) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0 || !child.requestFocus(direction, previouslyFocusedRect)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispatchStartTemporaryDetach() {
        super.dispatchStartTemporaryDetach();
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchStartTemporaryDetach();
        }
    }

    @Override
    public void dispatchFinishTemporaryDetach() {
        super.dispatchFinishTemporaryDetach();
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchFinishTemporaryDetach();
        }
    }

    @Override
    void dispatchAttachedToWindow(View.AttachInfo info, int visibility) {
        this.mGroupFlags |= 0x400000;
        super.dispatchAttachedToWindow(info, visibility);
        this.mGroupFlags &= 0xFFBFFFFF;
        visibility |= this.mViewFlags & 0xC;
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchAttachedToWindow(info, visibility);
        }
    }

    @Override
    boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        boolean handled = super.dispatchPopulateAccessibilityEventInternal(event);
        if (handled) {
            return handled;
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if ((child.mViewFlags & 0xC) != 0 || !(handled = this.getChildAt(i).dispatchPopulateAccessibilityEvent(event))) continue;
            return handled;
        }
        return false;
    }

    @Override
    void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (!(this.getParent() instanceof ViewRootImpl) && (this.mPrivateFlags & 8) != 0) {
            return;
        }
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            View child = this.mChildren[i];
            if ((child.mViewFlags & 0xC) != 0) continue;
            info.addChild(child);
        }
    }

    @Override
    void dispatchDetachedFromWindow() {
        this.cancelAndClearTouchTargets(null);
        this.mLayoutSuppressed = false;
        this.mDragNotifiedChildren = null;
        if (this.mCurrentDrag != null) {
            this.mCurrentDrag.recycle();
            this.mCurrentDrag = null;
        }
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchDetachedFromWindow();
        }
        super.dispatchDetachedFromWindow();
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.mGroupFlags = (this.mPaddingLeft | this.mPaddingTop | this.mPaddingRight | this.mPaddingBottom) != 0 ? (this.mGroupFlags |= 0x20) : (this.mGroupFlags &= 0xFFFFFFDF);
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        super.dispatchSaveInstanceState(container);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View c = children[i];
            if ((c.mViewFlags & 0x20000000) == 0x20000000) continue;
            c.dispatchSaveInstanceState(container);
        }
    }

    protected void dispatchFreezeSelfOnly(SparseArray<Parcelable> container) {
        super.dispatchSaveInstanceState(container);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        super.dispatchRestoreInstanceState(container);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View c = children[i];
            if ((c.mViewFlags & 0x20000000) == 0x20000000) continue;
            c.dispatchRestoreInstanceState(container);
        }
    }

    protected void dispatchThawSelfOnly(SparseArray<Parcelable> container) {
        super.dispatchRestoreInstanceState(container);
    }

    protected void setChildrenDrawingCacheEnabled(boolean enabled) {
        if (enabled || (this.mPersistentDrawingCache & 3) != 3) {
            View[] children = this.mChildren;
            int count = this.mChildrenCount;
            for (int i = 0; i < count; ++i) {
                children[i].setDrawingCacheEnabled(enabled);
            }
        }
    }

    @Override
    protected void onAnimationStart() {
        super.onAnimationStart();
        if ((this.mGroupFlags & 0x40) == 64) {
            int count = this.mChildrenCount;
            View[] children = this.mChildren;
            boolean buildCache = !this.isHardwareAccelerated();
            for (int i = 0; i < count; ++i) {
                View child = children[i];
                if ((child.mViewFlags & 0xC) != 0) continue;
                child.setDrawingCacheEnabled(true);
                if (!buildCache) continue;
                child.buildDrawingCache(true);
            }
            this.mGroupFlags |= 0x8000;
        }
    }

    @Override
    protected void onAnimationEnd() {
        super.onAnimationEnd();
        if ((this.mGroupFlags & 0x40) == 64) {
            this.mGroupFlags &= 0xFFFF7FFF;
            if ((this.mPersistentDrawingCache & 1) == 0) {
                this.setChildrenDrawingCacheEnabled(false);
            }
        }
    }

    @Override
    Bitmap createSnapshot(Bitmap.Config quality, int backgroundColor, boolean skipChildren) {
        int count = this.mChildrenCount;
        int[] visibilities = null;
        if (skipChildren) {
            visibilities = new int[count];
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                visibilities[i] = child.getVisibility();
                if (visibilities[i] != 0) continue;
                child.setVisibility(4);
            }
        }
        Bitmap b = super.createSnapshot(quality, backgroundColor, skipChildren);
        if (skipChildren) {
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setVisibility(visibilities[i]);
            }
        }
        return b;
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        View child;
        int i;
        boolean clipToPadding;
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        int flags = this.mGroupFlags;
        if ((flags & 8) != 0 && this.canAnimate()) {
            boolean cache = (this.mGroupFlags & 0x40) == 64;
            boolean buildCache = !this.isHardwareAccelerated();
            for (int i2 = 0; i2 < count; ++i2) {
                View child2 = children[i2];
                if ((child2.mViewFlags & 0xC) != 0) continue;
                LayoutParams params = child2.getLayoutParams();
                this.attachLayoutAnimationParameters(child2, params, i2, count);
                this.bindLayoutAnimation(child2);
                if (!cache) continue;
                child2.setDrawingCacheEnabled(true);
                if (!buildCache) continue;
                child2.buildDrawingCache(true);
            }
            LayoutAnimationController controller = this.mLayoutAnimationController;
            if (controller.willOverlap()) {
                this.mGroupFlags |= 0x80;
            }
            controller.start();
            this.mGroupFlags &= 0xFFFFFFF7;
            this.mGroupFlags &= 0xFFFFFFEF;
            if (cache) {
                this.mGroupFlags |= 0x8000;
            }
            if (this.mAnimationListener != null) {
                this.mAnimationListener.onAnimationStart(controller.getAnimation());
            }
        }
        int saveCount = 0;
        boolean bl = clipToPadding = (flags & 0x22) == 34;
        if (clipToPadding) {
            saveCount = canvas.save();
            canvas.clipRect(this.mScrollX + this.mPaddingLeft, this.mScrollY + this.mPaddingTop, this.mScrollX + this.mRight - this.mLeft - this.mPaddingRight, this.mScrollY + this.mBottom - this.mTop - this.mPaddingBottom);
        }
        this.mPrivateFlags &= 0xFFFFFFBF;
        this.mGroupFlags &= 0xFFFFFFFB;
        boolean more = false;
        long drawingTime = this.getDrawingTime();
        if ((flags & 0x400) == 0) {
            for (i = 0; i < count; ++i) {
                child = children[i];
                if ((child.mViewFlags & 0xC) != 0 && child.getAnimation() == null) continue;
                more |= this.drawChild(canvas, child, drawingTime);
            }
        } else {
            for (i = 0; i < count; ++i) {
                child = children[this.getChildDrawingOrder(count, i)];
                if ((child.mViewFlags & 0xC) != 0 && child.getAnimation() == null) continue;
                more |= this.drawChild(canvas, child, drawingTime);
            }
        }
        if (this.mDisappearingChildren != null) {
            int disappearingCount;
            ArrayList<View> disappearingChildren = this.mDisappearingChildren;
            for (int i3 = disappearingCount = disappearingChildren.size() - 1; i3 >= 0; --i3) {
                View child3 = disappearingChildren.get(i3);
                more |= this.drawChild(canvas, child3, drawingTime);
            }
        }
        if (clipToPadding) {
            canvas.restoreToCount(saveCount);
        }
        if (((flags = this.mGroupFlags) & 4) == 4) {
            this.invalidate(true);
        }
        if ((flags & 0x10) == 0 && (flags & 0x200) == 0 && this.mLayoutAnimationController.isDone() && !more) {
            this.mGroupFlags |= 0x200;
            Runnable end = new Runnable(){

                public void run() {
                    ViewGroup.this.notifyAnimationListener();
                }
            };
            this.post(end);
        }
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        return i;
    }

    private void notifyAnimationListener() {
        this.mGroupFlags &= 0xFFFFFDFF;
        this.mGroupFlags |= 0x10;
        if (this.mAnimationListener != null) {
            Runnable end = new Runnable(){

                public void run() {
                    ViewGroup.this.mAnimationListener.onAnimationEnd(ViewGroup.this.mLayoutAnimationController.getAnimation());
                }
            };
            this.post(end);
        }
        if ((this.mGroupFlags & 0x40) == 64) {
            this.mGroupFlags &= 0xFFFF7FFF;
            if ((this.mPersistentDrawingCache & 1) == 0) {
                this.setChildrenDrawingCacheEnabled(false);
            }
        }
        this.invalidate(true);
    }

    @Override
    protected void dispatchGetDisplayList() {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0 && child.getAnimation() == null || !child.hasStaticLayer()) continue;
            child.mRecreateDisplayList = (child.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
            child.mPrivateFlags &= Integer.MAX_VALUE;
            child.getDisplayList();
            child.mRecreateDisplayList = false;
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        int scrollY;
        boolean hasTransform;
        boolean caching;
        boolean more = false;
        int cl = child.mLeft;
        int ct = child.mTop;
        int cr = child.mRight;
        int cb = child.mBottom;
        boolean childHasIdentityMatrix = child.hasIdentityMatrix();
        int flags = this.mGroupFlags;
        if ((flags & 0x100) == 256) {
            this.mChildTransformation.clear();
            this.mGroupFlags &= 0xFFFFFEFF;
        }
        Transformation transformToApply = null;
        Animation a = child.getAnimation();
        boolean concatMatrix = false;
        boolean scalingRequired = false;
        int layerType = this.mDrawLayers ? child.getLayerType() : 0;
        boolean hardwareAccelerated = canvas.isHardwareAccelerated();
        if ((flags & 0x8000) == 32768 || (flags & 0x4000) == 16384) {
            caching = true;
            if (this.mAttachInfo != null) {
                scalingRequired = this.mAttachInfo.mScalingRequired;
            }
        } else {
            boolean bl = caching = layerType != 0 || hardwareAccelerated;
        }
        if (a != null) {
            Transformation invalidationTransform;
            boolean initialized = a.isInitialized();
            if (!initialized) {
                a.initialize(cr - cl, cb - ct, this.getWidth(), this.getHeight());
                a.initializeInvalidateRegion(0, 0, cr - cl, cb - ct);
                child.onAnimationStart();
            }
            more = a.getTransformation(drawingTime, this.mChildTransformation, scalingRequired ? this.mAttachInfo.mApplicationScale : 1.0f);
            if (scalingRequired && this.mAttachInfo.mApplicationScale != 1.0f) {
                if (this.mInvalidationTransformation == null) {
                    this.mInvalidationTransformation = new Transformation();
                }
                invalidationTransform = this.mInvalidationTransformation;
                a.getTransformation(drawingTime, invalidationTransform, 1.0f);
            } else {
                invalidationTransform = this.mChildTransformation;
            }
            transformToApply = this.mChildTransformation;
            concatMatrix = a.willChangeTransformationMatrix();
            if (more) {
                if (!a.willChangeBounds()) {
                    if ((flags & 0x90) == 128) {
                        this.mGroupFlags |= 4;
                    } else if ((flags & 4) == 0) {
                        this.mPrivateFlags |= 0x40;
                        this.invalidate(cl, ct, cr, cb);
                    }
                } else {
                    if (this.mInvalidateRegion == null) {
                        this.mInvalidateRegion = new RectF();
                    }
                    RectF region = this.mInvalidateRegion;
                    a.getInvalidateRegion(0, 0, cr - cl, cb - ct, region, invalidationTransform);
                    this.mPrivateFlags |= 0x40;
                    int left = cl + (int)region.left;
                    int top = ct + (int)region.top;
                    this.invalidate(left, top, left + (int)(region.width() + 0.5f), top + (int)(region.height() + 0.5f));
                }
            }
        } else if ((flags & 0x800) == 2048 && (hasTransform = this.getChildStaticTransformation(child, this.mChildTransformation))) {
            int transformType = this.mChildTransformation.getTransformationType();
            transformToApply = transformType != Transformation.TYPE_IDENTITY ? this.mChildTransformation : null;
            concatMatrix = (transformType & Transformation.TYPE_MATRIX) != 0;
        }
        boolean bl = !childHasIdentityMatrix;
        child.mPrivateFlags |= 0x20;
        if (!(concatMatrix |= bl) && canvas.quickReject(cl, ct, cr, cb, Canvas.EdgeType.BW) && (child.mPrivateFlags & 0x40) == 0) {
            return more;
        }
        float alpha = child.getAlpha();
        if (alpha <= 0.020833334f && (child.mPrivateFlags & 0x40000) == 0 && !(child instanceof SurfaceView)) {
            return more;
        }
        if (hardwareAccelerated) {
            child.mRecreateDisplayList = (child.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
            child.mPrivateFlags &= Integer.MAX_VALUE;
        }
        child.computeScroll();
        int sx = child.mScrollX;
        int sy = child.mScrollY;
        DisplayList displayList = null;
        Bitmap cache = null;
        boolean hasDisplayList = false;
        if (caching) {
            if (!hardwareAccelerated) {
                if (layerType != 0) {
                    layerType = 1;
                    child.buildDrawingCache(true);
                }
                cache = child.getDrawingCache(true);
            } else {
                switch (layerType) {
                    case 1: {
                        child.buildDrawingCache(true);
                        cache = child.getDrawingCache(true);
                        break;
                    }
                    case 0: {
                        hasDisplayList = child.canHaveDisplayList();
                    }
                }
            }
        }
        boolean hasNoCache = cache == null || hasDisplayList;
        boolean offsetForScroll = cache == null && !hasDisplayList && layerType != 2;
        int restoreTo = canvas.save();
        if (offsetForScroll) {
            canvas.translate(cl - sx, ct - sy);
        } else {
            canvas.translate(cl, ct);
            if (scalingRequired) {
                float scale = 1.0f / this.mAttachInfo.mApplicationScale;
                canvas.scale(scale, scale);
            }
        }
        if (transformToApply != null || alpha < 1.0f || !child.hasIdentityMatrix()) {
            if (transformToApply != null || !childHasIdentityMatrix) {
                int transX = 0;
                int transY = 0;
                if (offsetForScroll) {
                    transX = -sx;
                    transY = -sy;
                }
                if (transformToApply != null) {
                    float transformAlpha;
                    if (concatMatrix) {
                        canvas.translate(-transX, -transY);
                        canvas.concat(transformToApply.getMatrix());
                        canvas.translate(transX, transY);
                        this.mGroupFlags |= 0x100;
                    }
                    if ((transformAlpha = transformToApply.getAlpha()) < 1.0f) {
                        alpha *= transformToApply.getAlpha();
                        this.mGroupFlags |= 0x100;
                    }
                }
                if (!childHasIdentityMatrix) {
                    canvas.translate(-transX, -transY);
                    canvas.concat(child.getMatrix());
                    canvas.translate(transX, transY);
                }
            }
            if (alpha < 1.0f) {
                this.mGroupFlags |= 0x100;
                if (hasNoCache) {
                    int multipliedAlpha = (int)(255.0f * alpha);
                    if (!child.onSetAlpha(multipliedAlpha)) {
                        int layerFlags = 4;
                        if ((flags & 1) == 1 || layerType != 0) {
                            layerFlags |= 0x10;
                        }
                        if (layerType == 0) {
                            int scrollX = hasDisplayList ? 0 : sx;
                            scrollY = hasDisplayList ? 0 : sy;
                            canvas.saveLayerAlpha(scrollX, scrollY, scrollX + cr - cl, scrollY + cb - ct, multipliedAlpha, layerFlags);
                        }
                    } else {
                        child.mPrivateFlags |= 0x40000;
                    }
                }
            }
        } else if ((child.mPrivateFlags & 0x40000) == 262144) {
            child.onSetAlpha(255);
            child.mPrivateFlags &= 0xFFFBFFFF;
        }
        if ((flags & 1) == 1) {
            if (offsetForScroll) {
                canvas.clipRect(sx, sy, sx + (cr - cl), sy + (cb - ct));
            } else if (!scalingRequired || cache == null) {
                canvas.clipRect(0, 0, cr - cl, cb - ct);
            } else {
                canvas.clipRect(0, 0, cache.getWidth(), cache.getHeight());
            }
        }
        if (hasDisplayList && !(displayList = child.getDisplayList()).isValid()) {
            displayList = null;
            hasDisplayList = false;
        }
        if (hasNoCache) {
            boolean layerRendered = false;
            if (layerType == 2) {
                HardwareLayer layer = child.getHardwareLayer();
                if (layer != null && layer.isValid()) {
                    child.mLayerPaint.setAlpha((int)(alpha * 255.0f));
                    ((HardwareCanvas)canvas).drawHardwareLayer(layer, 0.0f, 0.0f, child.mLayerPaint);
                    layerRendered = true;
                } else {
                    int scrollX = hasDisplayList ? 0 : sx;
                    scrollY = hasDisplayList ? 0 : sy;
                    canvas.saveLayer(scrollX, scrollY, scrollX + cr - cl, scrollY + cb - ct, child.mLayerPaint, 20);
                }
            }
            if (!layerRendered) {
                if (!hasDisplayList) {
                    if ((child.mPrivateFlags & 0x80) == 128) {
                        child.mPrivateFlags &= 0xFF9FFFFF;
                        child.dispatchDraw(canvas);
                    } else {
                        child.draw(canvas);
                    }
                } else {
                    child.mPrivateFlags &= 0xFF9FFFFF;
                    ((HardwareCanvas)canvas).drawDisplayList(displayList, cr - cl, cb - ct, null);
                }
            }
        } else if (cache != null) {
            Paint cachePaint;
            child.mPrivateFlags &= 0xFF9FFFFF;
            if (layerType == 0) {
                cachePaint = this.mCachePaint;
                if (alpha < 1.0f) {
                    cachePaint.setAlpha((int)(alpha * 255.0f));
                    this.mGroupFlags |= 0x1000;
                } else if ((flags & 0x1000) == 4096) {
                    cachePaint.setAlpha(255);
                    this.mGroupFlags &= 0xFFFFEFFF;
                }
            } else {
                cachePaint = child.mLayerPaint;
                cachePaint.setAlpha((int)(alpha * 255.0f));
            }
            canvas.drawBitmap(cache, 0.0f, 0.0f, cachePaint);
        }
        canvas.restoreToCount(restoreTo);
        if (a != null && !more) {
            if (!hardwareAccelerated && !a.getFillAfter()) {
                child.onSetAlpha(255);
            }
            this.finishAnimatingView(child, a);
        }
        if (more && hardwareAccelerated) {
            this.invalidate(true);
            if (a.hasAlpha() && (child.mPrivateFlags & 0x40000) == 262144) {
                child.invalidate(true);
            }
        }
        child.mRecreateDisplayList = false;
        return more;
    }

    public void setChildrenLayersEnabled(boolean enabled) {
        if (enabled != this.mDrawLayers) {
            this.mDrawLayers = enabled;
            this.invalidate(true);
            for (int i = 0; i < this.mChildrenCount; ++i) {
                View child = this.mChildren[i];
                if (child.mLayerType == 0) continue;
                child.invalidate(true);
            }
        }
    }

    public void setClipChildren(boolean clipChildren) {
        this.setBooleanFlag(1, clipChildren);
    }

    public void setClipToPadding(boolean clipToPadding) {
        this.setBooleanFlag(2, clipToPadding);
    }

    @Override
    public void dispatchSetSelected(boolean selected) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].setSelected(selected);
        }
    }

    @Override
    public void dispatchSetActivated(boolean activated) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].setActivated(activated);
        }
    }

    @Override
    protected void dispatchSetPressed(boolean pressed) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].setPressed(pressed);
        }
    }

    protected void setStaticTransformationsEnabled(boolean enabled) {
        this.setBooleanFlag(2048, enabled);
    }

    protected boolean getChildStaticTransformation(View child, Transformation t) {
        return false;
    }

    @Override
    protected View findViewTraversal(int id2) {
        if (id2 == this.mID) {
            return this;
        }
        View[] where = this.mChildren;
        int len = this.mChildrenCount;
        for (int i = 0; i < len; ++i) {
            View v = where[i];
            if ((v.mPrivateFlags & 8) != 0 || (v = v.findViewById(id2)) == null) continue;
            return v;
        }
        return null;
    }

    @Override
    protected View findViewWithTagTraversal(Object tag) {
        if (tag != null && tag.equals(this.mTag)) {
            return this;
        }
        View[] where = this.mChildren;
        int len = this.mChildrenCount;
        for (int i = 0; i < len; ++i) {
            View v = where[i];
            if ((v.mPrivateFlags & 8) != 0 || (v = v.findViewWithTag(tag)) == null) continue;
            return v;
        }
        return null;
    }

    @Override
    protected View findViewByPredicateTraversal(Predicate<View> predicate, View childToSkip) {
        if (predicate.apply(this)) {
            return this;
        }
        View[] where = this.mChildren;
        int len = this.mChildrenCount;
        for (int i = 0; i < len; ++i) {
            View v = where[i];
            if (v == childToSkip || (v.mPrivateFlags & 8) != 0 || (v = v.findViewByPredicate(predicate)) == null) continue;
            return v;
        }
        return null;
    }

    public void addView(View child) {
        this.addView(child, -1);
    }

    public void addView(View child, int index) {
        LayoutParams params = child.getLayoutParams();
        if (params == null && (params = this.generateDefaultLayoutParams()) == null) {
            throw new IllegalArgumentException("generateDefaultLayoutParams() cannot return null");
        }
        this.addView(child, index, params);
    }

    public void addView(View child, int width, int height) {
        LayoutParams params = this.generateDefaultLayoutParams();
        params.width = width;
        params.height = height;
        this.addView(child, -1, params);
    }

    @Override
    public void addView(View child, LayoutParams params) {
        this.addView(child, -1, params);
    }

    public void addView(View child, int index, LayoutParams params) {
        this.requestLayout();
        this.invalidate(true);
        this.addViewInner(child, index, params, false);
    }

    @Override
    public void updateViewLayout(View view, LayoutParams params) {
        if (!this.checkLayoutParams(params)) {
            throw new IllegalArgumentException("Invalid LayoutParams supplied to " + this);
        }
        if (view.mParent != this) {
            throw new IllegalArgumentException("Given view not a child of " + this);
        }
        view.setLayoutParams(params);
    }

    protected boolean checkLayoutParams(LayoutParams p) {
        return p != null;
    }

    public void setOnHierarchyChangeListener(OnHierarchyChangeListener listener) {
        this.mOnHierarchyChangeListener = listener;
    }

    protected void onViewAdded(View child) {
        if (this.mOnHierarchyChangeListener != null) {
            this.mOnHierarchyChangeListener.onChildViewAdded(this, child);
        }
    }

    protected void onViewRemoved(View child) {
        if (this.mOnHierarchyChangeListener != null) {
            this.mOnHierarchyChangeListener.onChildViewRemoved(this, child);
        }
    }

    protected boolean addViewInLayout(View child, int index, LayoutParams params) {
        return this.addViewInLayout(child, index, params, false);
    }

    protected boolean addViewInLayout(View child, int index, LayoutParams params, boolean preventRequestLayout) {
        child.mParent = null;
        this.addViewInner(child, index, params, preventRequestLayout);
        child.mPrivateFlags = child.mPrivateFlags & 0xFF9FFFFF | 0x20;
        return true;
    }

    protected void cleanupLayoutState(View child) {
        child.mPrivateFlags &= 0xFFFFEFFF;
    }

    private void addViewInner(View child, int index, LayoutParams params, boolean preventRequestLayout) {
        View.AttachInfo ai;
        if (this.mTransition != null) {
            this.mTransition.cancel(3);
        }
        if (child.getParent() != null) {
            throw new IllegalStateException("The specified child already has a parent. You must call removeView() on the child's parent first.");
        }
        if (this.mTransition != null) {
            this.mTransition.addChild(this, child);
        }
        if (!this.checkLayoutParams(params)) {
            params = this.generateLayoutParams(params);
        }
        if (preventRequestLayout) {
            child.mLayoutParams = params;
        } else {
            child.setLayoutParams(params);
        }
        if (index < 0) {
            index = this.mChildrenCount;
        }
        this.addInArray(child, index);
        if (preventRequestLayout) {
            child.assignParent(this);
        } else {
            child.mParent = this;
        }
        if (child.hasFocus()) {
            this.requestChildFocus(child, child.findFocus());
        }
        if ((ai = this.mAttachInfo) != null && (this.mGroupFlags & 0x400000) == 0) {
            boolean lastKeepOn = ai.mKeepScreenOn;
            ai.mKeepScreenOn = false;
            child.dispatchAttachedToWindow(this.mAttachInfo, this.mViewFlags & 0xC);
            if (ai.mKeepScreenOn) {
                this.needGlobalAttributesUpdate(true);
            }
            ai.mKeepScreenOn = lastKeepOn;
        }
        this.onViewAdded(child);
        if ((child.mViewFlags & 0x400000) == 0x400000) {
            this.mGroupFlags |= 0x10000;
        }
    }

    private void addInArray(View child, int index) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        int size = children.length;
        if (index == count) {
            if (size == count) {
                this.mChildren = new View[size + 12];
                System.arraycopy(children, 0, this.mChildren, 0, size);
                children = this.mChildren;
            }
            children[this.mChildrenCount++] = child;
        } else if (index < count) {
            if (size == count) {
                this.mChildren = new View[size + 12];
                System.arraycopy(children, 0, this.mChildren, 0, index);
                System.arraycopy(children, index, this.mChildren, index + 1, count - index);
                children = this.mChildren;
            } else {
                System.arraycopy(children, index, children, index + 1, count - index);
            }
            children[index] = child;
            ++this.mChildrenCount;
            if (this.mLastTouchDownIndex >= index) {
                ++this.mLastTouchDownIndex;
            }
        } else {
            throw new IndexOutOfBoundsException("index=" + index + " count=" + count);
        }
    }

    private void removeFromArray(int index) {
        int count;
        View[] children = this.mChildren;
        if (this.mTransitioningViews == null || !this.mTransitioningViews.contains(children[index])) {
            children[index].mParent = null;
        }
        if (index == (count = this.mChildrenCount--) - 1) {
            children[this.mChildrenCount] = null;
        } else if (index >= 0 && index < count) {
            System.arraycopy(children, index + 1, children, index, count - index - 1);
            children[--this.mChildrenCount] = null;
        } else {
            throw new IndexOutOfBoundsException();
        }
        if (this.mLastTouchDownIndex == index) {
            this.mLastTouchDownTime = 0L;
            this.mLastTouchDownIndex = -1;
        } else if (this.mLastTouchDownIndex > index) {
            --this.mLastTouchDownIndex;
        }
    }

    private void removeFromArray(int start, int count) {
        int end;
        View[] children = this.mChildren;
        int childrenCount = this.mChildrenCount;
        if ((start = Math.max(0, start)) == (end = Math.min(childrenCount, start + count))) {
            return;
        }
        if (end == childrenCount) {
            for (int i = start; i < end; ++i) {
                children[i].mParent = null;
                children[i] = null;
            }
        } else {
            int i;
            for (i = start; i < end; ++i) {
                children[i].mParent = null;
            }
            System.arraycopy(children, end, children, start, childrenCount - end);
            for (i = childrenCount - (end - start); i < childrenCount; ++i) {
                children[i] = null;
            }
        }
        this.mChildrenCount -= end - start;
    }

    private void bindLayoutAnimation(View child) {
        Animation a = this.mLayoutAnimationController.getAnimationForView(child);
        child.setAnimation(a);
    }

    protected void attachLayoutAnimationParameters(View child, LayoutParams params, int index, int count) {
        LayoutAnimationController.AnimationParameters animationParams = params.layoutAnimationParameters;
        if (animationParams == null) {
            params.layoutAnimationParameters = animationParams = new LayoutAnimationController.AnimationParameters();
        }
        animationParams.count = count;
        animationParams.index = index;
    }

    @Override
    public void removeView(View view) {
        this.removeViewInternal(view);
        this.requestLayout();
        this.invalidate(true);
    }

    public void removeViewInLayout(View view) {
        this.removeViewInternal(view);
    }

    public void removeViewsInLayout(int start, int count) {
        this.removeViewsInternal(start, count);
    }

    public void removeViewAt(int index) {
        this.removeViewInternal(index, this.getChildAt(index));
        this.requestLayout();
        this.invalidate(true);
    }

    public void removeViews(int start, int count) {
        this.removeViewsInternal(start, count);
        this.requestLayout();
        this.invalidate(true);
    }

    private void removeViewInternal(View view) {
        int index = this.indexOfChild(view);
        if (index >= 0) {
            this.removeViewInternal(index, view);
        }
    }

    private void removeViewInternal(int index, View view) {
        if (this.mTransition != null) {
            this.mTransition.removeChild(this, view);
        }
        boolean clearChildFocus = false;
        if (view == this.mFocused) {
            view.clearFocusForRemoval();
            clearChildFocus = true;
        }
        if (view.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
            this.addDisappearingView(view);
        } else if (view.mAttachInfo != null) {
            view.dispatchDetachedFromWindow();
        }
        this.onViewRemoved(view);
        this.needGlobalAttributesUpdate(false);
        this.removeFromArray(index);
        if (clearChildFocus) {
            this.clearChildFocus(view);
        }
    }

    public void setLayoutTransition(LayoutTransition transition) {
        if (this.mTransition != null) {
            this.mTransition.removeTransitionListener(this.mLayoutTransitionListener);
        }
        this.mTransition = transition;
        if (this.mTransition != null) {
            this.mTransition.addTransitionListener(this.mLayoutTransitionListener);
        }
    }

    public LayoutTransition getLayoutTransition() {
        return this.mTransition;
    }

    private void removeViewsInternal(int start, int count) {
        View focused = this.mFocused;
        boolean detach = this.mAttachInfo != null;
        View clearChildFocus = null;
        View[] children = this.mChildren;
        int end = start + count;
        for (int i = start; i < end; ++i) {
            View view = children[i];
            if (this.mTransition != null) {
                this.mTransition.removeChild(this, view);
            }
            if (view == focused) {
                view.clearFocusForRemoval();
                clearChildFocus = view;
            }
            if (view.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
                this.addDisappearingView(view);
            } else if (detach) {
                view.dispatchDetachedFromWindow();
            }
            this.needGlobalAttributesUpdate(false);
            this.onViewRemoved(view);
        }
        this.removeFromArray(start, count);
        if (clearChildFocus != null) {
            this.clearChildFocus(clearChildFocus);
        }
    }

    public void removeAllViews() {
        this.removeAllViewsInLayout();
        this.requestLayout();
        this.invalidate(true);
    }

    public void removeAllViewsInLayout() {
        int count = this.mChildrenCount;
        if (count <= 0) {
            return;
        }
        View[] children = this.mChildren;
        this.mChildrenCount = 0;
        View focused = this.mFocused;
        boolean detach = this.mAttachInfo != null;
        View clearChildFocus = null;
        this.needGlobalAttributesUpdate(false);
        for (int i = count - 1; i >= 0; --i) {
            View view = children[i];
            if (this.mTransition != null) {
                this.mTransition.removeChild(this, view);
            }
            if (view == focused) {
                view.clearFocusForRemoval();
                clearChildFocus = view;
            }
            if (view.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
                this.addDisappearingView(view);
            } else if (detach) {
                view.dispatchDetachedFromWindow();
            }
            this.onViewRemoved(view);
            view.mParent = null;
            children[i] = null;
        }
        if (clearChildFocus != null) {
            this.clearChildFocus(clearChildFocus);
        }
    }

    protected void removeDetachedView(View child, boolean animate) {
        if (this.mTransition != null) {
            this.mTransition.removeChild(this, child);
        }
        if (child == this.mFocused) {
            child.clearFocus();
        }
        if (animate && child.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(child)) {
            this.addDisappearingView(child);
        } else if (child.mAttachInfo != null) {
            child.dispatchDetachedFromWindow();
        }
        this.onViewRemoved(child);
    }

    protected void attachViewToParent(View child, int index, LayoutParams params) {
        child.mLayoutParams = params;
        if (index < 0) {
            index = this.mChildrenCount;
        }
        this.addInArray(child, index);
        child.mParent = this;
        child.mPrivateFlags = child.mPrivateFlags & 0xFF9FFFFF & 0xFFFF7FFF | 0x20 | Integer.MIN_VALUE;
        this.mPrivateFlags |= Integer.MIN_VALUE;
        if (child.hasFocus()) {
            this.requestChildFocus(child, child.findFocus());
        }
    }

    protected void detachViewFromParent(View child) {
        this.removeFromArray(this.indexOfChild(child));
    }

    protected void detachViewFromParent(int index) {
        this.removeFromArray(index);
    }

    protected void detachViewsFromParent(int start, int count) {
        this.removeFromArray(start, count);
    }

    protected void detachAllViewsFromParent() {
        int count = this.mChildrenCount;
        if (count <= 0) {
            return;
        }
        View[] children = this.mChildren;
        this.mChildrenCount = 0;
        for (int i = count - 1; i >= 0; --i) {
            children[i].mParent = null;
            children[i] = null;
        }
    }

    @Override
    public void invalidateChild(View child, Rect dirty) {
        block24: {
            int opaqueFlag;
            boolean drawAnimation;
            View.AttachInfo attachInfo;
            ViewParent parent;
            block25: {
                parent = this;
                attachInfo = this.mAttachInfo;
                if (attachInfo == null) break block24;
                boolean bl = drawAnimation = (child.mPrivateFlags & 0x40) == 64;
                if (dirty != null) break block25;
                if (child.mLayerType != 0) {
                    this.mPrivateFlags |= Integer.MIN_VALUE;
                    this.mPrivateFlags &= 0xFFFF7FFF;
                    child.mLocalDirtyRect.setEmpty();
                }
                do {
                    View view = null;
                    if (parent instanceof View) {
                        view = (View)((Object)parent);
                        if (view.mLayerType != 0) {
                            view.mLocalDirtyRect.setEmpty();
                            if (view.getParent() instanceof View) {
                                View grandParent = (View)((Object)view.getParent());
                                grandParent.mPrivateFlags |= Integer.MIN_VALUE;
                                grandParent.mPrivateFlags &= 0xFFFF7FFF;
                            }
                        }
                        if ((view.mPrivateFlags & 0x600000) != 0) break block24;
                    }
                    if (drawAnimation) {
                        if (view != null) {
                            view.mPrivateFlags |= 0x40;
                        } else if (parent instanceof ViewRootImpl) {
                            ((ViewRootImpl)parent).mIsAnimating = true;
                        }
                    }
                    if (parent instanceof ViewRootImpl) {
                        ((ViewRootImpl)parent).invalidate();
                        parent = null;
                        continue;
                    }
                    if (view == null) continue;
                    if ((view.mPrivateFlags & 0x20) == 32 || (view.mPrivateFlags & 0x8000) == 32768) {
                        view.mPrivateFlags &= 0xFFFF7FFF;
                        view.mPrivateFlags |= 0x200000;
                        parent = view.mParent;
                        continue;
                    }
                    parent = null;
                } while (parent != null);
                break block24;
                {
                }
            }
            boolean isOpaque = child.isOpaque() && !drawAnimation && child.getAnimation() == null;
            int n = opaqueFlag = isOpaque ? 0x400000 : 0x200000;
            if (child.mLayerType != 0) {
                this.mPrivateFlags |= Integer.MIN_VALUE;
                this.mPrivateFlags &= 0xFFFF7FFF;
                child.mLocalDirtyRect.union(dirty);
            }
            int[] location = attachInfo.mInvalidateChildLocation;
            location[0] = child.mLeft;
            location[1] = child.mTop;
            Matrix childMatrix = child.getMatrix();
            if (!childMatrix.isIdentity()) {
                RectF boundingRect = attachInfo.mTmpTransformRect;
                boundingRect.set(dirty);
                childMatrix.mapRect(boundingRect);
                dirty.set((int)(boundingRect.left - 0.5f), (int)(boundingRect.top - 0.5f), (int)(boundingRect.right + 0.5f), (int)(boundingRect.bottom + 0.5f));
            }
            do {
                Matrix m;
                View view = null;
                if (parent instanceof View) {
                    view = (View)((Object)parent);
                    if (view.mLayerType != 0 && view.getParent() instanceof View) {
                        View grandParent = (View)((Object)view.getParent());
                        grandParent.mPrivateFlags |= Integer.MIN_VALUE;
                        grandParent.mPrivateFlags &= 0xFFFF7FFF;
                    }
                }
                if (drawAnimation) {
                    if (view != null) {
                        view.mPrivateFlags |= 0x40;
                    } else if (parent instanceof ViewRootImpl) {
                        ((ViewRootImpl)parent).mIsAnimating = true;
                    }
                }
                if (view != null) {
                    if ((view.mViewFlags & 0x3000) != 0 && view.getSolidColor() == 0) {
                        opaqueFlag = 0x200000;
                    }
                    if ((view.mPrivateFlags & 0x600000) != 0x200000) {
                        view.mPrivateFlags = view.mPrivateFlags & 0xFF9FFFFF | opaqueFlag;
                    }
                }
                parent = parent.invalidateChildInParent(location, dirty);
                if (view == null || (m = view.getMatrix()).isIdentity()) continue;
                RectF boundingRect = attachInfo.mTmpTransformRect;
                boundingRect.set(dirty);
                m.mapRect(boundingRect);
                dirty.set((int)boundingRect.left, (int)boundingRect.top, (int)(boundingRect.right + 0.5f), (int)(boundingRect.bottom + 0.5f));
            } while (parent != null);
        }
    }

    @Override
    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        if ((this.mPrivateFlags & 0x20) == 32 || (this.mPrivateFlags & 0x8000) == 32768) {
            if ((this.mGroupFlags & 0x90) != 128) {
                dirty.offset(location[0] - this.mScrollX, location[1] - this.mScrollY);
                int left = this.mLeft;
                int top = this.mTop;
                if ((this.mGroupFlags & 1) != 1 || dirty.intersect(0, 0, this.mRight - left, this.mBottom - top) || (this.mPrivateFlags & 0x40) == 64) {
                    this.mPrivateFlags &= 0xFFFF7FFF;
                    location[0] = left;
                    location[1] = top;
                    if (this.mLayerType != 0) {
                        this.mLocalDirtyRect.union(dirty);
                    }
                    return this.mParent;
                }
            } else {
                this.mPrivateFlags &= 0xFFFF7FDF;
                location[0] = this.mLeft;
                location[1] = this.mTop;
                if ((this.mGroupFlags & 1) == 1) {
                    dirty.set(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                } else {
                    dirty.union(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                }
                if (this.mLayerType != 0) {
                    this.mLocalDirtyRect.union(dirty);
                }
                return this.mParent;
            }
        }
        return null;
    }

    public void offsetDescendantRectToMyCoords(View descendant, Rect rect) {
        this.offsetRectBetweenParentAndChild(descendant, rect, true, false);
    }

    public void offsetRectIntoDescendantCoords(View descendant, Rect rect) {
        this.offsetRectBetweenParentAndChild(descendant, rect, false, false);
    }

    void offsetRectBetweenParentAndChild(View descendant, Rect rect, boolean offsetFromChildToParent, boolean clipToBounds) {
        if (descendant == this) {
            return;
        }
        ViewParent theParent = descendant.mParent;
        while (theParent != null && theParent instanceof View && theParent != this) {
            View p;
            if (offsetFromChildToParent) {
                rect.offset(descendant.mLeft - descendant.mScrollX, descendant.mTop - descendant.mScrollY);
                if (clipToBounds) {
                    p = (View)((Object)theParent);
                    rect.intersect(0, 0, p.mRight - p.mLeft, p.mBottom - p.mTop);
                }
            } else {
                if (clipToBounds) {
                    p = (View)((Object)theParent);
                    rect.intersect(0, 0, p.mRight - p.mLeft, p.mBottom - p.mTop);
                }
                rect.offset(descendant.mScrollX - descendant.mLeft, descendant.mScrollY - descendant.mTop);
            }
            descendant = (View)((Object)theParent);
            theParent = descendant.mParent;
        }
        if (theParent == this) {
            if (offsetFromChildToParent) {
                rect.offset(descendant.mLeft - descendant.mScrollX, descendant.mTop - descendant.mScrollY);
            } else {
                rect.offset(descendant.mScrollX - descendant.mLeft, descendant.mScrollY - descendant.mTop);
            }
        } else {
            throw new IllegalArgumentException("parameter must be a descendant of this view");
        }
    }

    public void offsetChildrenTopAndBottom(int offset) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View v = children[i];
            v.mTop += offset;
            v.mBottom += offset;
        }
    }

    @Override
    public boolean getChildVisibleRect(View child, Rect r, Point offset) {
        int dx = child.mLeft - this.mScrollX;
        int dy = child.mTop - this.mScrollY;
        if (offset != null) {
            offset.x += dx;
            offset.y += dy;
        }
        r.offset(dx, dy);
        return r.intersect(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop) && (this.mParent == null || this.mParent.getChildVisibleRect(this, r, offset));
    }

    @Override
    public void layout(int l, int t, int r, int b) {
        if (this.mTransition == null || !this.mTransition.isChangingLayout()) {
            super.layout(l, t, r, b);
        } else {
            this.mLayoutSuppressed = true;
        }
    }

    @Override
    protected abstract void onLayout(boolean var1, int var2, int var3, int var4, int var5);

    protected boolean canAnimate() {
        return this.mLayoutAnimationController != null;
    }

    public void startLayoutAnimation() {
        if (this.mLayoutAnimationController != null) {
            this.mGroupFlags |= 8;
            this.requestLayout();
        }
    }

    public void scheduleLayoutAnimation() {
        this.mGroupFlags |= 8;
    }

    public void setLayoutAnimation(LayoutAnimationController controller) {
        this.mLayoutAnimationController = controller;
        if (this.mLayoutAnimationController != null) {
            this.mGroupFlags |= 8;
        }
    }

    public LayoutAnimationController getLayoutAnimation() {
        return this.mLayoutAnimationController;
    }

    @ViewDebug.ExportedProperty
    public boolean isAnimationCacheEnabled() {
        return (this.mGroupFlags & 0x40) == 64;
    }

    public void setAnimationCacheEnabled(boolean enabled) {
        this.setBooleanFlag(64, enabled);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean isAlwaysDrawnWithCacheEnabled() {
        return (this.mGroupFlags & 0x4000) == 16384;
    }

    public void setAlwaysDrawnWithCacheEnabled(boolean always) {
        this.setBooleanFlag(16384, always);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    protected boolean isChildrenDrawnWithCacheEnabled() {
        return (this.mGroupFlags & 0x8000) == 32768;
    }

    protected void setChildrenDrawnWithCacheEnabled(boolean enabled) {
        this.setBooleanFlag(32768, enabled);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    protected boolean isChildrenDrawingOrderEnabled() {
        return (this.mGroupFlags & 0x400) == 1024;
    }

    protected void setChildrenDrawingOrderEnabled(boolean enabled) {
        this.setBooleanFlag(1024, enabled);
    }

    private void setBooleanFlag(int flag, boolean value) {
        this.mGroupFlags = value ? (this.mGroupFlags |= flag) : (this.mGroupFlags &= ~flag);
    }

    @ViewDebug.ExportedProperty(category="drawing", mapping={@ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=1, to="ANIMATION"), @ViewDebug.IntToString(from=2, to="SCROLLING"), @ViewDebug.IntToString(from=3, to="ALL")})
    public int getPersistentDrawingCache() {
        return this.mPersistentDrawingCache;
    }

    public void setPersistentDrawingCache(int drawingCacheToKeep) {
        this.mPersistentDrawingCache = drawingCacheToKeep & 3;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(LayoutParams p) {
        return p;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    protected boolean dispatchConsistencyCheck(int consistency) {
        boolean result = super.dispatchConsistencyCheck(consistency);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            if (children[i].dispatchConsistencyCheck(consistency)) continue;
            result = false;
        }
        return result;
    }

    @Override
    protected boolean onConsistencyCheck(int consistency) {
        ViewParent parent;
        boolean checkDrawing;
        boolean result = super.onConsistencyCheck(consistency);
        boolean checkLayout = (consistency & 1) != 0;
        boolean bl = checkDrawing = (consistency & 2) != 0;
        if (checkLayout) {
            int count = this.mChildrenCount;
            View[] children = this.mChildren;
            for (int i = 0; i < count; ++i) {
                if (children[i].getParent() == this) continue;
                result = false;
                Log.d("ViewConsistency", "View " + children[i] + " has no parent/a parent that is not " + this);
            }
        }
        if (checkDrawing && (this.mPrivateFlags & 0x600000) != 0 && (parent = this.getParent()) != null && !(parent instanceof ViewRootImpl) && (((View)((Object)parent)).mPrivateFlags & 0x600000) == 0) {
            result = false;
            Log.d("ViewConsistency", "ViewGroup " + this + " is dirty but its parent is not: " + this);
        }
        return result;
    }

    @Override
    protected void debug(int depth) {
        String output;
        super.debug(depth);
        if (this.mFocused != null) {
            output = ViewGroup.debugIndent(depth);
            output = output + "mFocused";
            Log.d("View", output);
        }
        if (this.mChildrenCount != 0) {
            output = ViewGroup.debugIndent(depth);
            output = output + "{";
            Log.d("View", output);
        }
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            View child = this.mChildren[i];
            child.debug(depth + 1);
        }
        if (this.mChildrenCount != 0) {
            output = ViewGroup.debugIndent(depth);
            output = output + "}";
            Log.d("View", output);
        }
    }

    public int indexOfChild(View child) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            if (children[i] != child) continue;
            return i;
        }
        return -1;
    }

    public int getChildCount() {
        return this.mChildrenCount;
    }

    public View getChildAt(int index) {
        if (index < 0 || index >= this.mChildrenCount) {
            return null;
        }
        return this.mChildren[index];
    }

    protected void measureChildren(int widthMeasureSpec, int heightMeasureSpec) {
        int size = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < size; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec(parentWidthMeasureSpec, this.mPaddingLeft + this.mPaddingRight, lp.width);
        int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec(parentHeightMeasureSpec, this.mPaddingTop + this.mPaddingBottom, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        MarginLayoutParams lp = (MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec(parentWidthMeasureSpec, this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec(parentHeightMeasureSpec, this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    public static int getChildMeasureSpec(int spec, int padding, int childDimension) {
        int specMode = View.MeasureSpec.getMode(spec);
        int specSize = View.MeasureSpec.getSize(spec);
        int size = Math.max(0, specSize - padding);
        int resultSize = 0;
        int resultMode = 0;
        switch (specMode) {
            case 0x40000000: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
                break;
            }
            case -2147483648: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = Integer.MIN_VALUE;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
                break;
            }
            case 0: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = 0;
                    resultMode = 0;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = 0;
                resultMode = 0;
            }
        }
        return View.MeasureSpec.makeMeasureSpec(resultSize, resultMode);
    }

    public void clearDisappearingChildren() {
        if (this.mDisappearingChildren != null) {
            this.mDisappearingChildren.clear();
        }
    }

    private void addDisappearingView(View v) {
        ArrayList<View> disappearingChildren = this.mDisappearingChildren;
        if (disappearingChildren == null) {
            disappearingChildren = this.mDisappearingChildren = new ArrayList();
        }
        disappearingChildren.add(v);
    }

    private void finishAnimatingView(View view, Animation animation) {
        ArrayList<View> disappearingChildren = this.mDisappearingChildren;
        if (disappearingChildren != null && disappearingChildren.contains(view)) {
            disappearingChildren.remove(view);
            if (view.mAttachInfo != null) {
                view.dispatchDetachedFromWindow();
            }
            view.clearAnimation();
            this.mGroupFlags |= 4;
        }
        if (animation != null && !animation.getFillAfter()) {
            view.clearAnimation();
        }
        if ((view.mPrivateFlags & 0x10000) == 65536) {
            view.onAnimationEnd();
            view.mPrivateFlags &= 0xFFFEFFFF;
            this.mGroupFlags |= 4;
        }
    }

    boolean isViewTransitioning(View view) {
        return this.mTransitioningViews != null && this.mTransitioningViews.contains(view);
    }

    public void startViewTransition(View view) {
        if (view.mParent == this) {
            if (this.mTransitioningViews == null) {
                this.mTransitioningViews = new ArrayList();
            }
            this.mTransitioningViews.add(view);
        }
    }

    public void endViewTransition(View view) {
        if (this.mTransitioningViews != null) {
            this.mTransitioningViews.remove(view);
            ArrayList<View> disappearingChildren = this.mDisappearingChildren;
            if (disappearingChildren != null && disappearingChildren.contains(view)) {
                disappearingChildren.remove(view);
                if (this.mVisibilityChangingChildren != null && this.mVisibilityChangingChildren.contains(view)) {
                    this.mVisibilityChangingChildren.remove(view);
                } else {
                    if (view.mAttachInfo != null) {
                        view.dispatchDetachedFromWindow();
                    }
                    if (view.mParent != null) {
                        view.mParent = null;
                    }
                }
                this.mGroupFlags |= 4;
            }
        }
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        boolean meOpaque;
        boolean bl = meOpaque = (this.mPrivateFlags & 0x200) == 0;
        if (meOpaque && region == null) {
            return true;
        }
        super.gatherTransparentRegion(region);
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        boolean noneOfTheChildrenAreTransparent = true;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0 && child.getAnimation() == null || child.gatherTransparentRegion(region)) continue;
            noneOfTheChildrenAreTransparent = false;
        }
        return meOpaque || noneOfTheChildrenAreTransparent;
    }

    @Override
    public void requestTransparentRegion(View child) {
        if (child != null) {
            child.mPrivateFlags |= 0x200;
            if (this.mParent != null) {
                this.mParent.requestTransparentRegion(this);
            }
        }
    }

    @Override
    protected boolean fitSystemWindows(Rect insets) {
        boolean done = super.fitSystemWindows(insets);
        if (!done) {
            int count = this.mChildrenCount;
            View[] children = this.mChildren;
            for (int i = 0; i < count && !(done = children[i].fitSystemWindows(insets)); ++i) {
            }
        }
        return done;
    }

    public Animation.AnimationListener getLayoutAnimationListener() {
        return this.mAnimationListener;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if ((this.mGroupFlags & 0x10000) != 0) {
            if ((this.mGroupFlags & 0x2000) != 0) {
                throw new IllegalStateException("addStateFromChildren cannot be enabled if a child has duplicateParentState set to true");
            }
            View[] children = this.mChildren;
            int count = this.mChildrenCount;
            for (int i = 0; i < count; ++i) {
                View child = children[i];
                if ((child.mViewFlags & 0x400000) == 0) continue;
                child.refreshDrawableState();
            }
        }
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].jumpDrawablesToCurrentState();
        }
    }

    @Override
    protected int[] onCreateDrawableState(int extraSpace) {
        if ((this.mGroupFlags & 0x2000) == 0) {
            return super.onCreateDrawableState(extraSpace);
        }
        int need = 0;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            int[] childState = this.getChildAt(i).getDrawableState();
            if (childState == null) continue;
            need += childState.length;
        }
        int[] state = super.onCreateDrawableState(extraSpace + need);
        for (int i = 0; i < n; ++i) {
            int[] childState = this.getChildAt(i).getDrawableState();
            if (childState == null) continue;
            state = ViewGroup.mergeDrawableStates(state, childState);
        }
        return state;
    }

    public void setAddStatesFromChildren(boolean addsStates) {
        this.mGroupFlags = addsStates ? (this.mGroupFlags |= 0x2000) : (this.mGroupFlags &= 0xFFFFDFFF);
        this.refreshDrawableState();
    }

    public boolean addStatesFromChildren() {
        return (this.mGroupFlags & 0x2000) != 0;
    }

    @Override
    public void childDrawableStateChanged(View child) {
        if ((this.mGroupFlags & 0x2000) != 0) {
            this.refreshDrawableState();
        }
    }

    public void setLayoutAnimationListener(Animation.AnimationListener animationListener) {
        this.mAnimationListener = animationListener;
    }

    public void requestTransitionStart(LayoutTransition transition) {
        ViewRootImpl viewAncestor = this.getViewRootImpl();
        if (viewAncestor != null) {
            viewAncestor.requestTransitionStart(transition);
        }
    }

    @Override
    protected void resetResolvedLayoutDirection() {
        super.resetResolvedLayoutDirection();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getLayoutDirection() != Integer.MIN_VALUE) continue;
            child.resetResolvedLayoutDirection();
        }
    }

    @Override
    protected void resetResolvedTextDirection() {
        super.resetResolvedTextDirection();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getTextDirection() != 0) continue;
            child.resetResolvedTextDirection();
        }
    }

    public boolean shouldDelayChildPressedState() {
        return true;
    }

    private static class HoverTarget {
        private static final int MAX_RECYCLED = 32;
        private static final Object sRecycleLock = new Object();
        private static HoverTarget sRecycleBin;
        private static int sRecycledCount;
        public View child;
        public HoverTarget next;

        private HoverTarget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static HoverTarget obtain(View child) {
            HoverTarget target;
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycleBin == null) {
                    target = new HoverTarget();
                } else {
                    target = sRecycleBin;
                    sRecycleBin = target.next;
                    --sRecycledCount;
                    target.next = null;
                }
            }
            target.child = child;
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycledCount < 32) {
                    this.next = sRecycleBin;
                    sRecycleBin = this;
                    ++sRecycledCount;
                } else {
                    this.next = null;
                }
                this.child = null;
            }
        }
    }

    private static class TouchTarget {
        private static final int MAX_RECYCLED = 32;
        private static final Object sRecycleLock = new Object();
        private static TouchTarget sRecycleBin;
        private static int sRecycledCount;
        public static final int ALL_POINTER_IDS = -1;
        public View child;
        public int pointerIdBits;
        public TouchTarget next;

        private TouchTarget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TouchTarget obtain(View child, int pointerIdBits) {
            TouchTarget target;
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycleBin == null) {
                    target = new TouchTarget();
                } else {
                    target = sRecycleBin;
                    sRecycleBin = target.next;
                    --sRecycledCount;
                    target.next = null;
                }
            }
            target.child = child;
            target.pointerIdBits = pointerIdBits;
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycledCount < 32) {
                    this.next = sRecycleBin;
                    sRecycleBin = this;
                    ++sRecycledCount;
                } else {
                    this.next = null;
                }
                this.child = null;
            }
        }
    }

    public static class MarginLayoutParams
    extends LayoutParams {
        @ViewDebug.ExportedProperty(category="layout")
        public int leftMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int topMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int rightMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int bottomMargin;
        @ViewDebug.ExportedProperty(category="layout")
        protected int startMargin = Integer.MIN_VALUE;
        @ViewDebug.ExportedProperty(category="layout")
        protected int endMargin = Integer.MIN_VALUE;
        private static final int DEFAULT_RELATIVE = Integer.MIN_VALUE;

        public MarginLayoutParams(Context c, AttributeSet attrs) {
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ViewGroup_MarginLayout);
            this.setBaseAttributes(a, 0, 1);
            int margin = a.getDimensionPixelSize(2, -1);
            if (margin >= 0) {
                this.leftMargin = margin;
                this.topMargin = margin;
                this.rightMargin = margin;
                this.bottomMargin = margin;
            } else {
                this.leftMargin = a.getDimensionPixelSize(3, 0);
                this.topMargin = a.getDimensionPixelSize(4, 0);
                this.rightMargin = a.getDimensionPixelSize(5, 0);
                this.bottomMargin = a.getDimensionPixelSize(6, 0);
                this.startMargin = a.getDimensionPixelSize(7, Integer.MIN_VALUE);
                this.endMargin = a.getDimensionPixelSize(8, Integer.MIN_VALUE);
            }
            a.recycle();
        }

        public MarginLayoutParams(int width, int height) {
            super(width, height);
        }

        public MarginLayoutParams(MarginLayoutParams source) {
            this.width = source.width;
            this.height = source.height;
            this.leftMargin = source.leftMargin;
            this.topMargin = source.topMargin;
            this.rightMargin = source.rightMargin;
            this.bottomMargin = source.bottomMargin;
            this.startMargin = source.startMargin;
            this.endMargin = source.endMargin;
        }

        public MarginLayoutParams(LayoutParams source) {
            super(source);
        }

        public void setMargins(int left, int top, int right, int bottom) {
            this.leftMargin = left;
            this.topMargin = top;
            this.rightMargin = right;
            this.bottomMargin = bottom;
        }

        public void setMarginsRelative(int start, int top, int end, int bottom) {
            this.startMargin = start;
            this.topMargin = top;
            this.endMargin = end;
            this.bottomMargin = bottom;
        }

        public int getMarginStart() {
            return this.startMargin;
        }

        public int getMarginEnd() {
            return this.endMargin;
        }

        public boolean isMarginRelative() {
            return this.startMargin != Integer.MIN_VALUE || this.endMargin != Integer.MIN_VALUE;
        }

        protected void resolveWithDirection(int layoutDirection) {
            switch (layoutDirection) {
                case 0x40000000: {
                    this.leftMargin = this.endMargin > Integer.MIN_VALUE ? this.endMargin : this.leftMargin;
                    this.rightMargin = this.startMargin > Integer.MIN_VALUE ? this.startMargin : this.rightMargin;
                    break;
                }
                default: {
                    this.leftMargin = this.startMargin > Integer.MIN_VALUE ? this.startMargin : this.leftMargin;
                    this.rightMargin = this.endMargin > Integer.MIN_VALUE ? this.endMargin : this.rightMargin;
                }
            }
        }
    }

    public static class LayoutParams {
        @Deprecated
        public static final int FILL_PARENT = -1;
        public static final int MATCH_PARENT = -1;
        public static final int WRAP_CONTENT = -2;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=-1, to="MATCH_PARENT"), @ViewDebug.IntToString(from=-2, to="WRAP_CONTENT")})
        public int width;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=-1, to="MATCH_PARENT"), @ViewDebug.IntToString(from=-2, to="WRAP_CONTENT")})
        public int height;
        public LayoutAnimationController.AnimationParameters layoutAnimationParameters;

        public LayoutParams(Context c, AttributeSet attrs) {
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ViewGroup_Layout);
            this.setBaseAttributes(a, 0, 1);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public LayoutParams(LayoutParams source) {
            this.width = source.width;
            this.height = source.height;
        }

        LayoutParams() {
        }

        protected void setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = a.getLayoutDimension(widthAttr, "layout_width");
            this.height = a.getLayoutDimension(heightAttr, "layout_height");
        }

        protected void resolveWithDirection(int layoutDirection) {
        }

        public String debug(String output) {
            return output + "ViewGroup.LayoutParams={ width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " }";
        }

        protected static String sizeToString(int size) {
            if (size == -2) {
                return "wrap-content";
            }
            if (size == -1) {
                return "match-parent";
            }
            return String.valueOf(size);
        }
    }

    public static interface OnHierarchyChangeListener {
        public void onChildViewAdded(View var1, View var2);

        public void onChildViewRemoved(View var1, View var2);
    }
}

