/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.DecelerateInterpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.Scroller;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Locale;

public class NumberPicker
extends LinearLayout {
    private static final long DEFAULT_LONG_PRESS_UPDATE_INTERVAL = 300L;
    private static final int SELECTOR_MIDDLE_ITEM_INDEX = 2;
    private static final int SELECTOR_MAX_FLING_VELOCITY_ADJUSTMENT = 8;
    private static final int SELECTOR_ADJUSTMENT_DURATION_MILLIS = 800;
    private static final int CHANGE_CURRENT_BY_ONE_SCROLL_DURATION = 300;
    private static final int SHOW_INPUT_CONTROLS_DELAY_MILLIS = ViewConfiguration.getDoubleTapTimeout();
    private static final float TOP_AND_BOTTOM_FADING_EDGE_STRENGTH = 0.9f;
    private static final int UNSCALED_DEFAULT_SELECTION_DIVIDER_HEIGHT = 2;
    private static final int SELECTOR_WHEEL_STATE_NONE = 0;
    private static final int SELECTOR_WHEEL_STATE_SMALL = 1;
    private static final int SELECTOR_WHEEL_STATE_LARGE = 2;
    private static final int SELECTOR_WHEEL_BRIGHT_ALPHA = 255;
    private static final int SELECTOR_WHEEL_DIM_ALPHA = 60;
    private static final int BUTTON_ALPHA_TRANSPARENT = 0;
    private static final int BUTTON_ALPHA_OPAQUE = 1;
    private static final String PROPERTY_SELECTOR_PAINT_ALPHA = "selectorPaintAlpha";
    private static final String PROPERTY_BUTTON_ALPHA = "alpha";
    private static final char[] DIGIT_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final Formatter TWO_DIGIT_FORMATTER = new Formatter(){
        final StringBuilder mBuilder = new StringBuilder();
        final java.util.Formatter mFmt = new java.util.Formatter(this.mBuilder, Locale.US);
        final Object[] mArgs = new Object[1];

        public String format(int value) {
            this.mArgs[0] = value;
            this.mBuilder.delete(0, this.mBuilder.length());
            this.mFmt.format("%02d", this.mArgs);
            return this.mFmt.toString();
        }
    };
    private final ImageButton mIncrementButton;
    private final ImageButton mDecrementButton;
    private final EditText mInputText;
    private final int mTextSize;
    private int mSelectorTextGapHeight;
    private String[] mDisplayedValues;
    private int mMinValue;
    private int mMaxValue;
    private int mValue;
    private OnValueChangeListener mOnValueChangeListener;
    private OnScrollListener mOnScrollListener;
    private Formatter mFormatter;
    private long mLongPressUpdateInterval = 300L;
    private final SparseArray<String> mSelectorIndexToStringCache = new SparseArray();
    private final int[] mSelectorIndices = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
    private final Paint mSelectorWheelPaint;
    private int mSelectorElementHeight;
    private int mInitialScrollOffset = Integer.MIN_VALUE;
    private int mCurrentScrollOffset;
    private final Scroller mFlingScroller;
    private final Scroller mAdjustScroller;
    private int mPreviousScrollerY;
    private SetSelectionCommand mSetSelectionCommand;
    private AdjustScrollerCommand mAdjustScrollerCommand;
    private ChangeCurrentByOneFromLongPressCommand mChangeCurrentByOneFromLongPressCommand;
    private final AnimatorSet mShowInputControlsAnimator;
    private final Animator mDimSelectorWheelAnimator;
    private float mLastDownEventY;
    private float mLastMotionEventY;
    private boolean mBeginEditOnUpEvent;
    private boolean mAdjustScrollerOnUpEvent;
    private int mSelectorWheelState;
    private VelocityTracker mVelocityTracker;
    private int mTouchSlop;
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;
    private boolean mWrapSelectorWheel;
    private final int mSolidColor;
    private final boolean mFlingable;
    private final Drawable mSelectionDivider;
    private final int mSelectionDividerHeight;
    private final Rect mTempRect = new Rect();
    private int mScrollState = 0;
    private final long mShowInputControlsAnimimationDuration;
    private boolean mScrollWheelAndFadingEdgesInitialized;

    public NumberPicker(Context context) {
        this(context, null);
    }

    public NumberPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 16843706);
    }

    public NumberPicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.NumberPicker, defStyle, 0);
        this.mSolidColor = attributesArray.getColor(0, 0);
        this.mFlingable = attributesArray.getBoolean(1, true);
        this.mSelectionDivider = attributesArray.getDrawable(2);
        int defSelectionDividerHeight = (int)TypedValue.applyDimension(1, 2.0f, this.getResources().getDisplayMetrics());
        this.mSelectionDividerHeight = attributesArray.getDimensionPixelSize(3, defSelectionDividerHeight);
        attributesArray.recycle();
        this.mShowInputControlsAnimimationDuration = this.getResources().getInteger(17694722);
        this.setWillNotDraw(false);
        this.setSelectorWheelState(0);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(17367140, (ViewGroup)this, true);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
                if (inputMethodManager != null && inputMethodManager.isActive(NumberPicker.this.mInputText)) {
                    inputMethodManager.hideSoftInputFromWindow(NumberPicker.this.getWindowToken(), 0);
                }
                NumberPicker.this.mInputText.clearFocus();
                if (v.getId() == 16908992) {
                    NumberPicker.this.changeCurrentByOne(true);
                } else {
                    NumberPicker.this.changeCurrentByOne(false);
                }
            }
        };
        View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                NumberPicker.this.mInputText.clearFocus();
                if (v.getId() == 16908992) {
                    NumberPicker.this.postChangeCurrentByOneFromLongPress(true);
                } else {
                    NumberPicker.this.postChangeCurrentByOneFromLongPress(false);
                }
                return true;
            }
        };
        this.mIncrementButton = (ImageButton)this.findViewById(16908992);
        this.mIncrementButton.setOnClickListener(onClickListener);
        this.mIncrementButton.setOnLongClickListener(onLongClickListener);
        this.mDecrementButton = (ImageButton)this.findViewById(16908994);
        this.mDecrementButton.setOnClickListener(onClickListener);
        this.mDecrementButton.setOnLongClickListener(onLongClickListener);
        this.mInputText = (EditText)this.findViewById(16908993);
        this.mInputText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    NumberPicker.this.mInputText.selectAll();
                    InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
                    if (inputMethodManager != null) {
                        inputMethodManager.showSoftInput(NumberPicker.this.mInputText, 0);
                    }
                } else {
                    NumberPicker.this.mInputText.setSelection(0, 0);
                    NumberPicker.this.validateInputTextView(v);
                }
            }
        });
        this.mInputText.setFilters(new InputFilter[]{new InputTextFilter()});
        this.mInputText.setRawInputType(2);
        this.mTouchSlop = ViewConfiguration.getTapTimeout();
        ViewConfiguration configuration = ViewConfiguration.get(context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity() / 8;
        this.mTextSize = (int)this.mInputText.getTextSize();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setTextSize(this.mTextSize);
        paint.setTypeface(this.mInputText.getTypeface());
        ColorStateList colors = this.mInputText.getTextColors();
        int color2 = colors.getColorForState(ENABLED_STATE_SET, -1);
        paint.setColor(color2);
        this.mSelectorWheelPaint = paint;
        this.mDimSelectorWheelAnimator = ObjectAnimator.ofInt(this, PROPERTY_SELECTOR_PAINT_ALPHA, 255, 60);
        ObjectAnimator showIncrementButton = ObjectAnimator.ofFloat(this.mIncrementButton, PROPERTY_BUTTON_ALPHA, 0.0f, 1.0f);
        ObjectAnimator showDecrementButton = ObjectAnimator.ofFloat(this.mDecrementButton, PROPERTY_BUTTON_ALPHA, 0.0f, 1.0f);
        this.mShowInputControlsAnimator = new AnimatorSet();
        this.mShowInputControlsAnimator.playTogether(this.mDimSelectorWheelAnimator, showIncrementButton, showDecrementButton);
        this.mShowInputControlsAnimator.addListener(new AnimatorListenerAdapter(){
            private boolean mCanceled = false;

            public void onAnimationEnd(Animator animation) {
                if (!this.mCanceled) {
                    NumberPicker.this.setSelectorWheelState(1);
                }
                this.mCanceled = false;
            }

            public void onAnimationCancel(Animator animation) {
                if (NumberPicker.this.mShowInputControlsAnimator.isRunning()) {
                    this.mCanceled = true;
                }
            }
        });
        this.mFlingScroller = new Scroller(this.getContext(), null, true);
        this.mAdjustScroller = new Scroller(this.getContext(), new DecelerateInterpolator(2.5f));
        this.updateInputTextView();
        this.updateIncrementAndDecrementButtonsVisibilityState();
        if (this.mFlingable) {
            if (this.isInEditMode()) {
                this.setSelectorWheelState(1);
            } else {
                this.setSelectorWheelState(2);
                this.hideInputControls();
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mScrollWheelAndFadingEdgesInitialized) {
            this.mScrollWheelAndFadingEdgesInitialized = true;
            this.initializeSelectorWheel();
            this.initializeFadingEdges();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || !this.mFlingable) {
            return false;
        }
        switch (event.getActionMasked()) {
            case 0: {
                this.mLastMotionEventY = this.mLastDownEventY = event.getY();
                this.removeAllCallbacks();
                this.mShowInputControlsAnimator.cancel();
                this.mDimSelectorWheelAnimator.cancel();
                this.mBeginEditOnUpEvent = false;
                this.mAdjustScrollerOnUpEvent = true;
                if (this.mSelectorWheelState == 2) {
                    boolean scrollersFinished;
                    boolean bl = scrollersFinished = this.mFlingScroller.isFinished() && this.mAdjustScroller.isFinished();
                    if (!scrollersFinished) {
                        this.mFlingScroller.forceFinished(true);
                        this.mAdjustScroller.forceFinished(true);
                        this.onScrollStateChange(0);
                    }
                    this.mBeginEditOnUpEvent = scrollersFinished;
                    this.mAdjustScrollerOnUpEvent = true;
                    this.hideInputControls();
                    return true;
                }
                if (!this.isEventInViewHitRect(event, this.mInputText) && (this.mIncrementButton.isShown() || !this.isEventInViewHitRect(event, this.mIncrementButton)) && (this.mDecrementButton.isShown() || !this.isEventInViewHitRect(event, this.mDecrementButton))) break;
                this.mAdjustScrollerOnUpEvent = false;
                this.setSelectorWheelState(2);
                this.hideInputControls();
                return true;
            }
            case 2: {
                float currentMoveY = event.getY();
                int deltaDownY = (int)Math.abs(currentMoveY - this.mLastDownEventY);
                if (deltaDownY <= this.mTouchSlop) break;
                this.mBeginEditOnUpEvent = false;
                this.onScrollStateChange(1);
                this.setSelectorWheelState(2);
                this.hideInputControls();
                return true;
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getActionMasked();
        switch (action) {
            case 2: {
                int deltaDownY;
                float currentMoveY = ev.getY();
                if ((this.mBeginEditOnUpEvent || this.mScrollState != 1) && (deltaDownY = (int)Math.abs(currentMoveY - this.mLastDownEventY)) > this.mTouchSlop) {
                    this.mBeginEditOnUpEvent = false;
                    this.onScrollStateChange(1);
                }
                int deltaMoveY = (int)(currentMoveY - this.mLastMotionEventY);
                this.scrollBy(0, deltaMoveY);
                this.invalidate();
                this.mLastMotionEventY = currentMoveY;
                break;
            }
            case 1: {
                if (this.mBeginEditOnUpEvent) {
                    this.setSelectorWheelState(1);
                    this.showInputControls(this.mShowInputControlsAnimimationDuration);
                    this.mInputText.requestFocus();
                    return true;
                }
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumFlingVelocity);
                int initialVelocity = (int)velocityTracker.getYVelocity();
                if (Math.abs(initialVelocity) > this.mMinimumFlingVelocity) {
                    this.fling(initialVelocity);
                    this.onScrollStateChange(2);
                } else if (this.mAdjustScrollerOnUpEvent) {
                    if (this.mFlingScroller.isFinished() && this.mAdjustScroller.isFinished()) {
                        this.postAdjustScrollerCommand(0);
                    }
                } else {
                    this.postAdjustScrollerCommand(SHOW_INPUT_CONTROLS_DELAY_MILLIS);
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        int action = event.getActionMasked();
        switch (action) {
            case 2: {
                if (this.mSelectorWheelState != 2) break;
                this.removeAllCallbacks();
                this.forceCompleteChangeCurrentByOneViaScroll();
                break;
            }
            case 1: 
            case 3: {
                this.removeAllCallbacks();
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode == 23 || keyCode == 66) {
            this.removeAllCallbacks();
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean dispatchTrackballEvent(MotionEvent event) {
        int action = event.getActionMasked();
        if (action == 3 || action == 1) {
            this.removeAllCallbacks();
        }
        return super.dispatchTrackballEvent(event);
    }

    public void computeScroll() {
        if (this.mSelectorWheelState == 0) {
            return;
        }
        Scroller scroller = this.mFlingScroller;
        if (scroller.isFinished() && (scroller = this.mAdjustScroller).isFinished()) {
            return;
        }
        scroller.computeScrollOffset();
        int currentScrollerY = scroller.getCurrY();
        if (this.mPreviousScrollerY == 0) {
            this.mPreviousScrollerY = scroller.getStartY();
        }
        this.scrollBy(0, currentScrollerY - this.mPreviousScrollerY);
        this.mPreviousScrollerY = currentScrollerY;
        if (scroller.isFinished()) {
            this.onScrollerFinished(scroller);
        } else {
            this.invalidate();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mIncrementButton.setEnabled(enabled);
        this.mDecrementButton.setEnabled(enabled);
        this.mInputText.setEnabled(enabled);
    }

    public void scrollBy(int x, int y) {
        if (this.mSelectorWheelState == 0) {
            return;
        }
        int[] selectorIndices = this.mSelectorIndices;
        if (!this.mWrapSelectorWheel && y > 0 && selectorIndices[2] <= this.mMinValue) {
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
            return;
        }
        if (!this.mWrapSelectorWheel && y < 0 && selectorIndices[2] >= this.mMaxValue) {
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
            return;
        }
        this.mCurrentScrollOffset += y;
        while (this.mCurrentScrollOffset - this.mInitialScrollOffset > this.mSelectorTextGapHeight) {
            this.mCurrentScrollOffset -= this.mSelectorElementHeight;
            this.decrementSelectorIndices(selectorIndices);
            this.changeCurrent(selectorIndices[2]);
            if (this.mWrapSelectorWheel || selectorIndices[2] > this.mMinValue) continue;
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
        }
        while (this.mCurrentScrollOffset - this.mInitialScrollOffset < -this.mSelectorTextGapHeight) {
            this.mCurrentScrollOffset += this.mSelectorElementHeight;
            this.incrementSelectorIndices(selectorIndices);
            this.changeCurrent(selectorIndices[2]);
            if (this.mWrapSelectorWheel || selectorIndices[2] < this.mMaxValue) continue;
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
        }
    }

    public int getSolidColor() {
        return this.mSolidColor;
    }

    public void setOnValueChangedListener(OnValueChangeListener onValueChangedListener) {
        this.mOnValueChangeListener = onValueChangedListener;
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    public void setFormatter(Formatter formatter) {
        if (formatter == this.mFormatter) {
            return;
        }
        this.mFormatter = formatter;
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
    }

    public void setValue(int value) {
        if (this.mValue == value) {
            return;
        }
        if (value < this.mMinValue) {
            int n = value = this.mWrapSelectorWheel ? this.mMaxValue : this.mMinValue;
        }
        if (value > this.mMaxValue) {
            value = this.mWrapSelectorWheel ? this.mMinValue : this.mMaxValue;
        }
        this.mValue = value;
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
        this.updateIncrementAndDecrementButtonsVisibilityState();
        this.invalidate();
    }

    public boolean getWrapSelectorWheel() {
        return this.mWrapSelectorWheel;
    }

    public void setWrapSelectorWheel(boolean wrapSelectorWheel) {
        if (wrapSelectorWheel && this.mMaxValue - this.mMinValue < this.mSelectorIndices.length) {
            throw new IllegalStateException("Range less than selector items count.");
        }
        if (wrapSelectorWheel != this.mWrapSelectorWheel) {
            this.mWrapSelectorWheel = wrapSelectorWheel;
            this.updateIncrementAndDecrementButtonsVisibilityState();
        }
    }

    public void setOnLongPressUpdateInterval(long intervalMillis) {
        this.mLongPressUpdateInterval = intervalMillis;
    }

    public int getValue() {
        return this.mValue;
    }

    public int getMinValue() {
        return this.mMinValue;
    }

    public void setMinValue(int minValue) {
        if (this.mMinValue == minValue) {
            return;
        }
        if (minValue < 0) {
            throw new IllegalArgumentException("minValue must be >= 0");
        }
        this.mMinValue = minValue;
        if (this.mMinValue > this.mValue) {
            this.mValue = this.mMinValue;
        }
        boolean wrapSelectorWheel = this.mMaxValue - this.mMinValue > this.mSelectorIndices.length;
        this.setWrapSelectorWheel(wrapSelectorWheel);
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(int maxValue) {
        if (this.mMaxValue == maxValue) {
            return;
        }
        if (maxValue < 0) {
            throw new IllegalArgumentException("maxValue must be >= 0");
        }
        this.mMaxValue = maxValue;
        if (this.mMaxValue < this.mValue) {
            this.mValue = this.mMaxValue;
        }
        boolean wrapSelectorWheel = this.mMaxValue - this.mMinValue > this.mSelectorIndices.length;
        this.setWrapSelectorWheel(wrapSelectorWheel);
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
    }

    public String[] getDisplayedValues() {
        return this.mDisplayedValues;
    }

    public void setDisplayedValues(String[] displayedValues) {
        if (this.mDisplayedValues == displayedValues) {
            return;
        }
        this.mDisplayedValues = displayedValues;
        if (this.mDisplayedValues != null) {
            this.mInputText.setRawInputType(524289);
        } else {
            this.mInputText.setRawInputType(2);
        }
        this.updateInputTextView();
        this.initializeSelectorWheelIndices();
    }

    protected float getTopFadingEdgeStrength() {
        return 0.9f;
    }

    protected float getBottomFadingEdgeStrength() {
        return 0.9f;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mFlingable && !this.isInEditMode()) {
            this.showInputControls(this.mShowInputControlsAnimimationDuration * 2L);
        }
    }

    protected void onDetachedFromWindow() {
        this.removeAllCallbacks();
    }

    protected void dispatchDraw(Canvas canvas) {
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mShowInputControlsAnimator.isRunning() || this.mSelectorWheelState != 2) {
            long drawTime = this.getDrawingTime();
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isShown()) continue;
                this.drawChild(canvas, this.getChildAt(i), drawTime);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mSelectorWheelState == 0) {
            return;
        }
        float x = (this.mRight - this.mLeft) / 2;
        float y = this.mCurrentScrollOffset;
        int restoreCount = canvas.save();
        if (this.mSelectorWheelState == 1) {
            Rect clipBounds = canvas.getClipBounds();
            clipBounds.inset(0, this.mSelectorElementHeight);
            canvas.clipRect(clipBounds);
        }
        int[] selectorIndices = this.mSelectorIndices;
        for (int i = 0; i < selectorIndices.length; ++i) {
            int selectorIndex = selectorIndices[i];
            String scrollSelectorValue = this.mSelectorIndexToStringCache.get(selectorIndex);
            if (i != 2 || this.mInputText.getVisibility() != 0) {
                canvas.drawText(scrollSelectorValue, x, y, this.mSelectorWheelPaint);
            }
            y += (float)this.mSelectorElementHeight;
        }
        if (this.mSelectionDivider != null) {
            int topOfTopDivider = (this.getHeight() - this.mSelectorElementHeight - this.mSelectionDividerHeight) / 2;
            int bottomOfTopDivider = topOfTopDivider + this.mSelectionDividerHeight;
            this.mSelectionDivider.setBounds(0, topOfTopDivider, this.mRight, bottomOfTopDivider);
            this.mSelectionDivider.draw(canvas);
            int topOfBottomDivider = topOfTopDivider + this.mSelectorElementHeight;
            int bottomOfBottomDivider = bottomOfTopDivider + this.mSelectorElementHeight;
            this.mSelectionDivider.setBounds(0, topOfBottomDivider, this.mRight, bottomOfBottomDivider);
            this.mSelectionDivider.draw(canvas);
        }
        canvas.restoreToCount(restoreCount);
    }

    public void sendAccessibilityEvent(int eventType) {
    }

    private void initializeSelectorWheelIndices() {
        this.mSelectorIndexToStringCache.clear();
        int[] selectorIdices = this.mSelectorIndices;
        int current = this.getValue();
        for (int i = 0; i < this.mSelectorIndices.length; ++i) {
            int selectorIndex = current + (i - 2);
            if (this.mWrapSelectorWheel) {
                selectorIndex = this.getWrappedSelectorIndex(selectorIndex);
            }
            this.mSelectorIndices[i] = selectorIndex;
            this.ensureCachedScrollSelectorValue(this.mSelectorIndices[i]);
        }
    }

    private void changeCurrent(int current) {
        if (this.mValue == current) {
            return;
        }
        if (this.mWrapSelectorWheel) {
            current = this.getWrappedSelectorIndex(current);
        }
        int previous = this.mValue;
        this.setValue(current);
        this.notifyChange(previous, current);
    }

    private void changeCurrentByOne(boolean increment) {
        if (this.mFlingable) {
            this.mDimSelectorWheelAnimator.cancel();
            this.mInputText.setVisibility(4);
            this.mSelectorWheelPaint.setAlpha(255);
            this.mPreviousScrollerY = 0;
            this.forceCompleteChangeCurrentByOneViaScroll();
            if (increment) {
                this.mFlingScroller.startScroll(0, 0, 0, -this.mSelectorElementHeight, 300);
            } else {
                this.mFlingScroller.startScroll(0, 0, 0, this.mSelectorElementHeight, 300);
            }
            this.invalidate();
        } else if (increment) {
            this.changeCurrent(this.mValue + 1);
        } else {
            this.changeCurrent(this.mValue - 1);
        }
    }

    private void forceCompleteChangeCurrentByOneViaScroll() {
        Scroller scroller = this.mFlingScroller;
        if (!scroller.isFinished()) {
            int yBeforeAbort = scroller.getCurrY();
            scroller.abortAnimation();
            int yDelta = scroller.getCurrY() - yBeforeAbort;
            this.scrollBy(0, yDelta);
        }
    }

    private void setSelectorPaintAlpha(int alpha) {
        this.mSelectorWheelPaint.setAlpha(alpha);
        this.invalidate();
    }

    private boolean isEventInViewHitRect(MotionEvent event, View view) {
        view.getHitRect(this.mTempRect);
        return this.mTempRect.contains((int)event.getX(), (int)event.getY());
    }

    private void setSelectorWheelState(int selectorWheelState) {
        this.mSelectorWheelState = selectorWheelState;
        if (selectorWheelState == 2) {
            this.mSelectorWheelPaint.setAlpha(255);
        }
        if (this.mFlingable && selectorWheelState == 2 && AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            AccessibilityManager.getInstance(this.mContext).interrupt();
            String text = this.mContext.getString(17040484);
            this.mInputText.setContentDescription(text);
            this.mInputText.sendAccessibilityEvent(4);
            this.mInputText.setContentDescription(null);
        }
    }

    private void initializeSelectorWheel() {
        this.initializeSelectorWheelIndices();
        int[] selectorIndices = this.mSelectorIndices;
        int totalTextHeight = selectorIndices.length * this.mTextSize;
        float totalTextGapHeight = this.mBottom - this.mTop - totalTextHeight;
        float textGapCount = selectorIndices.length - 1;
        this.mSelectorTextGapHeight = (int)(totalTextGapHeight / textGapCount + 0.5f);
        this.mSelectorElementHeight = this.mTextSize + this.mSelectorTextGapHeight;
        int editTextTextPosition = this.mInputText.getBaseline() + this.mInputText.getTop();
        this.mCurrentScrollOffset = this.mInitialScrollOffset = editTextTextPosition - this.mSelectorElementHeight * 2;
        this.updateInputTextView();
    }

    private void initializeFadingEdges() {
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength((this.mBottom - this.mTop - this.mTextSize) / 2);
    }

    private void onScrollerFinished(Scroller scroller) {
        if (scroller == this.mFlingScroller) {
            if (this.mSelectorWheelState == 2) {
                this.postAdjustScrollerCommand(0);
                this.onScrollStateChange(0);
            } else {
                this.updateInputTextView();
                this.fadeSelectorWheel(this.mShowInputControlsAnimimationDuration);
            }
        } else {
            this.updateInputTextView();
            this.showInputControls(this.mShowInputControlsAnimimationDuration);
        }
    }

    private void onScrollStateChange(int scrollState) {
        if (this.mScrollState == scrollState) {
            return;
        }
        this.mScrollState = scrollState;
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChange(this, scrollState);
        }
    }

    private void fling(int velocityY) {
        this.mPreviousScrollerY = 0;
        Scroller flingScroller = this.mFlingScroller;
        if (this.mWrapSelectorWheel) {
            if (velocityY > 0) {
                flingScroller.fling(0, 0, 0, velocityY, 0, 0, 0, Integer.MAX_VALUE);
            } else {
                flingScroller.fling(0, Integer.MAX_VALUE, 0, velocityY, 0, 0, 0, Integer.MAX_VALUE);
            }
        } else if (velocityY > 0) {
            int maxY = this.mTextSize * (this.mValue - this.mMinValue);
            flingScroller.fling(0, 0, 0, velocityY, 0, 0, 0, maxY);
        } else {
            int startY;
            int maxY = startY = this.mTextSize * (this.mMaxValue - this.mValue);
            flingScroller.fling(0, startY, 0, velocityY, 0, 0, 0, maxY);
        }
        this.invalidate();
    }

    private void hideInputControls() {
        this.mShowInputControlsAnimator.cancel();
        this.mIncrementButton.setVisibility(4);
        this.mDecrementButton.setVisibility(4);
        this.mInputText.setVisibility(4);
    }

    private void showInputControls(long animationDuration) {
        this.updateIncrementAndDecrementButtonsVisibilityState();
        this.mInputText.setVisibility(0);
        this.mShowInputControlsAnimator.setDuration(animationDuration);
        this.mShowInputControlsAnimator.start();
    }

    private void fadeSelectorWheel(long animationDuration) {
        this.mInputText.setVisibility(0);
        this.mDimSelectorWheelAnimator.setDuration(animationDuration);
        this.mDimSelectorWheelAnimator.start();
    }

    private void updateIncrementAndDecrementButtonsVisibilityState() {
        if (this.mWrapSelectorWheel || this.mValue < this.mMaxValue) {
            this.mIncrementButton.setVisibility(0);
        } else {
            this.mIncrementButton.setVisibility(4);
        }
        if (this.mWrapSelectorWheel || this.mValue > this.mMinValue) {
            this.mDecrementButton.setVisibility(0);
        } else {
            this.mDecrementButton.setVisibility(4);
        }
    }

    private int getWrappedSelectorIndex(int selectorIndex) {
        if (selectorIndex > this.mMaxValue) {
            return this.mMinValue + (selectorIndex - this.mMaxValue) % (this.mMaxValue - this.mMinValue) - 1;
        }
        if (selectorIndex < this.mMinValue) {
            return this.mMaxValue - (this.mMinValue - selectorIndex) % (this.mMaxValue - this.mMinValue) + 1;
        }
        return selectorIndex;
    }

    private void incrementSelectorIndices(int[] selectorIndices) {
        for (int i = 0; i < selectorIndices.length - 1; ++i) {
            selectorIndices[i] = selectorIndices[i + 1];
        }
        int nextScrollSelectorIndex = selectorIndices[selectorIndices.length - 2] + 1;
        if (this.mWrapSelectorWheel && nextScrollSelectorIndex > this.mMaxValue) {
            nextScrollSelectorIndex = this.mMinValue;
        }
        selectorIndices[selectorIndices.length - 1] = nextScrollSelectorIndex;
        this.ensureCachedScrollSelectorValue(nextScrollSelectorIndex);
    }

    private void decrementSelectorIndices(int[] selectorIndices) {
        for (int i = selectorIndices.length - 1; i > 0; --i) {
            selectorIndices[i] = selectorIndices[i - 1];
        }
        int nextScrollSelectorIndex = selectorIndices[1] - 1;
        if (this.mWrapSelectorWheel && nextScrollSelectorIndex < this.mMinValue) {
            nextScrollSelectorIndex = this.mMaxValue;
        }
        selectorIndices[0] = nextScrollSelectorIndex;
        this.ensureCachedScrollSelectorValue(nextScrollSelectorIndex);
    }

    private void ensureCachedScrollSelectorValue(int selectorIndex) {
        SparseArray<String> cache = this.mSelectorIndexToStringCache;
        String scrollSelectorValue = cache.get(selectorIndex);
        if (scrollSelectorValue != null) {
            return;
        }
        if (selectorIndex < this.mMinValue || selectorIndex > this.mMaxValue) {
            scrollSelectorValue = "";
        } else if (this.mDisplayedValues != null) {
            int displayedValueIndex = selectorIndex - this.mMinValue;
            scrollSelectorValue = this.mDisplayedValues[displayedValueIndex];
        } else {
            scrollSelectorValue = this.formatNumber(selectorIndex);
        }
        cache.put(selectorIndex, scrollSelectorValue);
    }

    private String formatNumber(int value) {
        return this.mFormatter != null ? this.mFormatter.format(value) : String.valueOf(value);
    }

    private void validateInputTextView(View v) {
        String str = String.valueOf(((TextView)v).getText());
        if (TextUtils.isEmpty(str)) {
            this.updateInputTextView();
        } else {
            int current = this.getSelectedPos(str.toString());
            this.changeCurrent(current);
        }
    }

    private void updateInputTextView() {
        if (this.mDisplayedValues == null) {
            this.mInputText.setText(this.formatNumber(this.mValue));
        } else {
            this.mInputText.setText(this.mDisplayedValues[this.mValue - this.mMinValue]);
        }
        this.mInputText.setSelection(this.mInputText.getText().length());
        if (this.mFlingable && AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            String text = this.mContext.getString(17040483, this.mInputText.getText());
            this.mInputText.setContentDescription(text);
        }
    }

    private void notifyChange(int previous, int current) {
        if (this.mOnValueChangeListener != null) {
            this.mOnValueChangeListener.onValueChange(this, previous, this.mValue);
        }
    }

    private void postChangeCurrentByOneFromLongPress(boolean increment) {
        this.mInputText.clearFocus();
        this.removeAllCallbacks();
        if (this.mChangeCurrentByOneFromLongPressCommand == null) {
            this.mChangeCurrentByOneFromLongPressCommand = new ChangeCurrentByOneFromLongPressCommand();
        }
        this.mChangeCurrentByOneFromLongPressCommand.setIncrement(increment);
        this.post(this.mChangeCurrentByOneFromLongPressCommand);
    }

    private void removeAllCallbacks() {
        if (this.mChangeCurrentByOneFromLongPressCommand != null) {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
        if (this.mAdjustScrollerCommand != null) {
            this.removeCallbacks(this.mAdjustScrollerCommand);
        }
        if (this.mSetSelectionCommand != null) {
            this.removeCallbacks(this.mSetSelectionCommand);
        }
    }

    private int getSelectedPos(String value) {
        if (this.mDisplayedValues == null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
            }
        } else {
            for (int i = 0; i < this.mDisplayedValues.length; ++i) {
                value = value.toLowerCase();
                if (!this.mDisplayedValues[i].toLowerCase().startsWith(value)) continue;
                return this.mMinValue + i;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.mMinValue;
    }

    private void postSetSelectionCommand(int selectionStart, int selectionEnd) {
        if (this.mSetSelectionCommand == null) {
            this.mSetSelectionCommand = new SetSelectionCommand();
        } else {
            this.removeCallbacks(this.mSetSelectionCommand);
        }
        this.mSetSelectionCommand.mSelectionStart = selectionStart;
        this.mSetSelectionCommand.mSelectionEnd = selectionEnd;
        this.post(this.mSetSelectionCommand);
    }

    private void postAdjustScrollerCommand(int delayMillis) {
        if (this.mAdjustScrollerCommand == null) {
            this.mAdjustScrollerCommand = new AdjustScrollerCommand();
        } else {
            this.removeCallbacks(this.mAdjustScrollerCommand);
        }
        this.postDelayed(this.mAdjustScrollerCommand, delayMillis);
    }

    class ChangeCurrentByOneFromLongPressCommand
    implements Runnable {
        private boolean mIncrement;

        ChangeCurrentByOneFromLongPressCommand() {
        }

        private void setIncrement(boolean increment) {
            this.mIncrement = increment;
        }

        public void run() {
            NumberPicker.this.changeCurrentByOne(this.mIncrement);
            NumberPicker.this.postDelayed(this, NumberPicker.this.mLongPressUpdateInterval);
        }
    }

    class AdjustScrollerCommand
    implements Runnable {
        AdjustScrollerCommand() {
        }

        public void run() {
            NumberPicker.this.mPreviousScrollerY = 0;
            if (NumberPicker.this.mInitialScrollOffset == NumberPicker.this.mCurrentScrollOffset) {
                NumberPicker.this.updateInputTextView();
                NumberPicker.this.showInputControls(NumberPicker.this.mShowInputControlsAnimimationDuration);
                return;
            }
            int deltaY = NumberPicker.this.mInitialScrollOffset - NumberPicker.this.mCurrentScrollOffset;
            if (Math.abs(deltaY) > NumberPicker.this.mSelectorElementHeight / 2) {
                deltaY += deltaY > 0 ? -NumberPicker.this.mSelectorElementHeight : NumberPicker.this.mSelectorElementHeight;
            }
            NumberPicker.this.mAdjustScroller.startScroll(0, 0, 0, deltaY, 800);
            NumberPicker.this.invalidate();
        }
    }

    class SetSelectionCommand
    implements Runnable {
        private int mSelectionStart;
        private int mSelectionEnd;

        SetSelectionCommand() {
        }

        public void run() {
            NumberPicker.this.mInputText.setSelection(this.mSelectionStart, this.mSelectionEnd);
        }
    }

    class InputTextFilter
    extends NumberKeyListener {
        InputTextFilter() {
        }

        public int getInputType() {
            return 1;
        }

        protected char[] getAcceptedChars() {
            return DIGIT_CHARACTERS;
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (NumberPicker.this.mDisplayedValues == null) {
                String result;
                CharSequence filtered = super.filter(source, start, end, dest, dstart, dend);
                if (filtered == null) {
                    filtered = source.subSequence(start, end);
                }
                if ("".equals(result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length()))) {
                    return result;
                }
                int val = NumberPicker.this.getSelectedPos(result);
                if (val > NumberPicker.this.mMaxValue) {
                    return "";
                }
                return filtered;
            }
            String filtered = String.valueOf(source.subSequence(start, end));
            if (TextUtils.isEmpty(filtered)) {
                return "";
            }
            String result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length());
            String str = String.valueOf(result).toLowerCase();
            for (String val : NumberPicker.this.mDisplayedValues) {
                String valLowerCase = val.toLowerCase();
                if (!valLowerCase.startsWith(str)) continue;
                NumberPicker.this.postSetSelectionCommand(result.length(), val.length());
                return val.subSequence(dstart, val.length());
            }
            return "";
        }
    }

    public static interface Formatter {
        public String format(int var1);
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChange(NumberPicker var1, int var2);
    }

    public static interface OnValueChangeListener {
        public void onValueChange(NumberPicker var1, int var2, int var3);
    }
}

