/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.AdnRecordLoader;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.ims.IsimRecords;

public abstract class IccRecords
extends Handler
implements IccConstants {
    protected static final boolean DBG = true;
    protected PhoneBase phone;
    protected RegistrantList recordsLoadedRegistrants = new RegistrantList();
    protected int recordsToLoad;
    protected AdnRecordCache adnCache;
    protected boolean recordsRequested = false;
    public String iccid;
    protected String msisdn = null;
    protected String msisdnTag = null;
    protected String voiceMailNum = null;
    protected String voiceMailTag = null;
    protected String newVoiceMailNum = null;
    protected String newVoiceMailTag = null;
    protected boolean isVoiceMailFixed = false;
    protected int countVoiceMessages = 0;
    protected int mncLength = -1;
    protected int mailboxIndex = 0;
    protected String spn;
    protected int spnDisplayCondition;
    protected static final int UNINITIALIZED = -1;
    protected static final int UNKNOWN = 0;
    protected static final int SPN_RULE_SHOW_SPN = 1;
    protected static final int SPN_RULE_SHOW_PLMN = 2;
    protected static final int EVENT_SET_MSISDN_DONE = 30;
    public static final int EVENT_GET_ICC_RECORD_DONE = 100;

    public IccRecords(PhoneBase p) {
        this.phone = p;
    }

    public abstract void dispose();

    protected abstract void onRadioOffOrNotAvailable();

    public AdnRecordCache getAdnCache() {
        return this.adnCache;
    }

    public void registerForRecordsLoaded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.recordsLoadedRegistrants.add(r);
        if (this.recordsToLoad == 0 && this.recordsRequested) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForRecordsLoaded(Handler h) {
        this.recordsLoadedRegistrants.remove(h);
    }

    public String getIMSI() {
        return null;
    }

    public String getMsisdnNumber() {
        return this.msisdn;
    }

    public void setMsisdnNumber(String alphaTag, String number, Message onComplete) {
        this.msisdn = number;
        this.msisdnTag = alphaTag;
        this.log("Set MSISDN: " + this.msisdnTag + " " + this.msisdn);
        AdnRecord adn = new AdnRecord(this.msisdnTag, this.msisdn);
        new AdnRecordLoader(this.phone).updateEF(adn, 28480, 28490, 1, null, this.obtainMessage(30, onComplete));
    }

    public String getMsisdnAlphaTag() {
        return this.msisdnTag;
    }

    public String getVoiceMailNumber() {
        return this.voiceMailNum;
    }

    public String getServiceProviderName() {
        return this.spn;
    }

    public abstract void setVoiceMailNumber(String var1, String var2, Message var3);

    public String getVoiceMailAlphaTag() {
        return this.voiceMailTag;
    }

    public abstract void setVoiceMessageWaiting(int var1, int var2);

    public boolean getVoiceMessageWaiting() {
        return this.countVoiceMessages != 0;
    }

    public int getVoiceMessageCount() {
        return this.countVoiceMessages;
    }

    public abstract void onRefresh(boolean var1, int[] var2);

    public boolean getRecordsLoaded() {
        return this.recordsToLoad == 0 && this.recordsRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                try {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccRecordLoaded recordLoaded = (IccRecordLoaded)ar.userObj;
                    this.log(recordLoaded.getEfName() + " LOADED");
                    if (ar.exception != null) {
                        this.loge("Record Load Exception: " + ar.exception);
                        break;
                    }
                    recordLoaded.onRecordLoaded(ar);
                    break;
                }
                catch (RuntimeException exc) {
                    this.loge("Exception parsing SIM record: " + exc);
                    break;
                }
                finally {
                    this.onRecordLoaded();
                }
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    protected abstract void onRecordLoaded();

    protected abstract void onAllRecordsLoaded();

    public abstract int getDisplayRule(String var1);

    public boolean isCspPlmnEnabled() {
        return false;
    }

    public String getOperatorNumeric() {
        return null;
    }

    public boolean getVoiceCallForwardingFlag() {
        return false;
    }

    public void setVoiceCallForwardingFlag(int line, boolean enable) {
    }

    public boolean isProvisioned() {
        return true;
    }

    protected abstract void log(String var1);

    protected abstract void loge(String var1);

    public IsimRecords getIsimRecords() {
        return null;
    }

    public static interface IccRecordLoaded {
        public String getEfName();

        public void onRecordLoaded(AsyncResult var1);
    }
}

