/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.Application;
import android.app.ApplicationPackageManager;
import android.app.ApplicationThreadNative;
import android.app.ContextImpl;
import android.app.IActivityManager;
import android.app.IInstrumentationWatcher;
import android.app.Instrumentation;
import android.app.LoadedApk;
import android.app.OnActivityPausedListener;
import android.app.QueuedWork;
import android.app.RemoteServiceException;
import android.app.ResultInfo;
import android.app.Service;
import android.app.SuperNotCalledException;
import android.app.backup.BackupAgent;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks2;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDebug;
import android.ddm.DdmHandleAppName;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.net.IConnectivityManager;
import android.net.Proxy;
import android.net.ProxyProperties;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.view.Display;
import android.view.HardwareRenderer;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import com.android.internal.os.BinderInternal;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.SamplingProfilerIntegration;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityThread {
    public static final String TAG = "ActivityThread";
    private static final Bitmap.Config THUMBNAIL_FORMAT = Bitmap.Config.RGB_565;
    static final boolean localLOGV = false;
    static final boolean DEBUG_MESSAGES = false;
    public static final boolean DEBUG_BROADCAST = false;
    private static final boolean DEBUG_RESULTS = false;
    private static final boolean DEBUG_BACKUP = true;
    private static final boolean DEBUG_CONFIGURATION = false;
    private static final long MIN_TIME_BETWEEN_GCS = 5000L;
    private static final Pattern PATTERN_SEMICOLON = Pattern.compile(";");
    private static final int SQLITE_MEM_RELEASED_EVENT_LOG_TAG = 75003;
    private static final int LOG_ON_PAUSE_CALLED = 30021;
    private static final int LOG_ON_RESUME_CALLED = 30022;
    static ContextImpl mSystemContext = null;
    static IPackageManager sPackageManager;
    final ApplicationThread mAppThread = new ApplicationThread();
    final Looper mLooper = Looper.myLooper();
    final H mH = new H();
    final HashMap<IBinder, ActivityClientRecord> mActivities = new HashMap();
    ActivityClientRecord mNewActivities = null;
    int mNumVisibleActivities = 0;
    final HashMap<IBinder, Service> mServices = new HashMap();
    AppBindData mBoundApplication;
    Profiler mProfiler;
    Configuration mConfiguration;
    Configuration mCompatConfiguration;
    Configuration mResConfiguration;
    CompatibilityInfo mResCompatibilityInfo;
    Application mInitialApplication;
    final ArrayList<Application> mAllApplications = new ArrayList();
    final HashMap<String, BackupAgent> mBackupAgents = new HashMap();
    static final ThreadLocal<ActivityThread> sThreadLocal;
    Instrumentation mInstrumentation;
    String mInstrumentationAppDir = null;
    String mInstrumentationAppPackage = null;
    String mInstrumentedAppDir = null;
    boolean mSystemThread = false;
    boolean mJitEnabled = false;
    final HashMap<String, WeakReference<LoadedApk>> mPackages = new HashMap();
    final HashMap<String, WeakReference<LoadedApk>> mResourcePackages = new HashMap();
    final HashMap<CompatibilityInfo, DisplayMetrics> mDisplayMetrics = new HashMap();
    final HashMap<ResourcesKey, WeakReference<Resources>> mActiveResources = new HashMap();
    final ArrayList<ActivityClientRecord> mRelaunchingActivities = new ArrayList();
    Configuration mPendingConfiguration = null;
    final HashMap<String, ProviderClientRecord> mProviderMap = new HashMap();
    final HashMap<IBinder, ProviderRefCount> mProviderRefCountMap = new HashMap();
    final HashMap<IBinder, ProviderClientRecord> mLocalProviders = new HashMap();
    final HashMap<Activity, ArrayList<OnActivityPausedListener>> mOnPauseListeners = new HashMap();
    final GcIdler mGcIdler = new GcIdler();
    boolean mGcIdlerScheduled = false;
    static Handler sMainThreadHandler;
    Bundle mCoreSettings = null;
    private Configuration mMainThreadConfig = new Configuration();
    private static final ThreadLocal<Intent> sCurrentBroadcastIntent;
    private int mThumbnailWidth = -1;
    private int mThumbnailHeight = -1;
    private Bitmap mAvailThumbnailBitmap = null;
    private Canvas mThumbnailCanvas = null;

    private void dumpGraphicsInfo(FileDescriptor fileDescriptor) {
        OverrideMethod.invokeV("android.app.ActivityThread#dumpGraphicsInfo(Ljava/io/FileDescriptor;)V", true, this);
    }

    public static ActivityThread currentActivityThread() {
        return sThreadLocal.get();
    }

    public static String currentPackageName() {
        ActivityThread am = ActivityThread.currentActivityThread();
        return am != null && am.mBoundApplication != null ? am.mBoundApplication.processName : null;
    }

    public static Application currentApplication() {
        ActivityThread am = ActivityThread.currentActivityThread();
        return am != null ? am.mInitialApplication : null;
    }

    public static IPackageManager getPackageManager() {
        if (sPackageManager != null) {
            return sPackageManager;
        }
        IBinder b = ServiceManager.getService("package");
        sPackageManager = IPackageManager.Stub.asInterface(b);
        return sPackageManager;
    }

    DisplayMetrics getDisplayMetricsLocked(CompatibilityInfo ci, boolean forceUpdate) {
        DisplayMetrics dm = this.mDisplayMetrics.get(ci);
        if (dm != null && !forceUpdate) {
            return dm;
        }
        if (dm == null) {
            dm = new DisplayMetrics();
            this.mDisplayMetrics.put(ci, dm);
        }
        Display d = WindowManagerImpl.getDefault(ci).getDefaultDisplay();
        d.getMetrics(dm);
        return dm;
    }

    static Configuration applyConfigCompat(Configuration config, CompatibilityInfo compat) {
        if (config == null) {
            return null;
        }
        if (compat != null && !compat.supportsScreen()) {
            config = new Configuration(config);
            compat.applyToConfiguration(config);
        }
        return config;
    }

    Configuration applyConfigCompatMainThread(Configuration config, CompatibilityInfo compat) {
        if (config == null) {
            return null;
        }
        if (compat != null && !compat.supportsScreen()) {
            this.mMainThreadConfig.setTo(config);
            config = this.mMainThreadConfig;
            compat.applyToConfiguration(config);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Resources getTopLevelResources(String resDir, CompatibilityInfo compInfo) {
        Resources r;
        ResourcesKey key = new ResourcesKey(resDir, compInfo.applicationScale);
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            WeakReference<Resources> wr = this.mActiveResources.get(key);
            Resources resources = r = wr != null ? (Resources)wr.get() : null;
            if (r != null && r.getAssets().isUpToDate()) {
                return r;
            }
        }
        AssetManager assets = new AssetManager();
        if (assets.addAssetPath(resDir) == 0) {
            return null;
        }
        DisplayMetrics metrics = this.getDisplayMetricsLocked(null, false);
        r = new Resources(assets, metrics, this.getConfiguration(), compInfo);
        HashMap<String, WeakReference<LoadedApk>> hashMap2 = this.mPackages;
        synchronized (hashMap2) {
            Resources existing;
            WeakReference<Resources> wr = this.mActiveResources.get(key);
            Resources resources = existing = wr != null ? (Resources)wr.get() : null;
            if (existing != null && existing.getAssets().isUpToDate()) {
                r.getAssets().close();
                return existing;
            }
            this.mActiveResources.put(key, new WeakReference<Resources>(r));
            return r;
        }
    }

    Resources getTopLevelResources(String resDir, LoadedApk pkgInfo) {
        return this.getTopLevelResources(resDir, pkgInfo.mCompatibilityInfo.get());
    }

    Handler getHandler() {
        return this.mH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedApk getPackageInfo(String packageName, CompatibilityInfo compatInfo, int flags) {
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            LoadedApk packageInfo;
            WeakReference<LoadedApk> ref = (flags & 1) != 0 ? this.mPackages.get(packageName) : this.mResourcePackages.get(packageName);
            LoadedApk loadedApk = packageInfo = ref != null ? (LoadedApk)ref.get() : null;
            if (packageInfo != null && (packageInfo.mResources == null || packageInfo.mResources.getAssets().isUpToDate())) {
                if (packageInfo.isSecurityViolation() && (flags & 2) == 0) {
                    throw new SecurityException("Requesting code from " + packageName + " to be run in process " + this.mBoundApplication.processName + "/" + this.mBoundApplication.appInfo.uid);
                }
                return packageInfo;
            }
        }
        ApplicationInfo ai = null;
        try {
            ai = ActivityThread.getPackageManager().getApplicationInfo(packageName, 1024);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (ai != null) {
            return this.getPackageInfo(ai, compatInfo, flags);
        }
        return null;
    }

    public LoadedApk getPackageInfo(ApplicationInfo ai, CompatibilityInfo compatInfo, int flags) {
        boolean securityViolation;
        boolean includeCode = (flags & 1) != 0;
        boolean bl = securityViolation = includeCode && ai.uid != 0 && ai.uid != 1000 && (this.mBoundApplication == null || ai.uid != this.mBoundApplication.appInfo.uid);
        if ((flags & 3) == 1 && securityViolation) {
            String msg = "Requesting code from " + ai.packageName + " (with uid " + ai.uid + ")";
            if (this.mBoundApplication != null) {
                msg = msg + " to be run in process " + this.mBoundApplication.processName + " (with uid " + this.mBoundApplication.appInfo.uid + ")";
            }
            throw new SecurityException(msg);
        }
        return this.getPackageInfo(ai, compatInfo, null, securityViolation, includeCode);
    }

    public LoadedApk getPackageInfoNoCheck(ApplicationInfo ai, CompatibilityInfo compatInfo) {
        return this.getPackageInfo(ai, compatInfo, null, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedApk peekPackageInfo(String packageName, boolean includeCode) {
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            WeakReference<LoadedApk> ref = includeCode ? this.mPackages.get(packageName) : this.mResourcePackages.get(packageName);
            return ref != null ? (LoadedApk)ref.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedApk getPackageInfo(ApplicationInfo aInfo, CompatibilityInfo compatInfo, ClassLoader baseLoader, boolean securityViolation, boolean includeCode) {
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            LoadedApk packageInfo;
            WeakReference<LoadedApk> ref = includeCode ? this.mPackages.get(aInfo.packageName) : this.mResourcePackages.get(aInfo.packageName);
            LoadedApk loadedApk = packageInfo = ref != null ? (LoadedApk)ref.get() : null;
            if (packageInfo == null || packageInfo.mResources != null && !packageInfo.mResources.getAssets().isUpToDate()) {
                packageInfo = new LoadedApk(this, aInfo, compatInfo, this, baseLoader, securityViolation, includeCode && (aInfo.flags & 4) != 0);
                if (includeCode) {
                    this.mPackages.put(aInfo.packageName, new WeakReference<LoadedApk>(packageInfo));
                } else {
                    this.mResourcePackages.put(aInfo.packageName, new WeakReference<LoadedApk>(packageInfo));
                }
            }
            return packageInfo;
        }
    }

    ActivityThread() {
    }

    public ApplicationThread getApplicationThread() {
        return this.mAppThread;
    }

    public Instrumentation getInstrumentation() {
        return this.mInstrumentation;
    }

    public Configuration getConfiguration() {
        return this.mResConfiguration;
    }

    public boolean isProfiling() {
        return this.mProfiler != null && this.mProfiler.profileFile != null && this.mProfiler.profileFd == null;
    }

    public String getProfileFilePath() {
        return this.mProfiler.profileFile;
    }

    public Looper getLooper() {
        return this.mLooper;
    }

    public Application getApplication() {
        return this.mInitialApplication;
    }

    public String getProcessName() {
        return this.mBoundApplication.processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextImpl getSystemContext() {
        ActivityThread activityThread = this;
        synchronized (activityThread) {
            if (mSystemContext == null) {
                ContextImpl context = ContextImpl.createSystemContext(this);
                LoadedApk info = new LoadedApk(this, "android", context, null, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO);
                context.init(info, null, this);
                context.getResources().updateConfiguration(this.getConfiguration(), this.getDisplayMetricsLocked(CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, false));
                mSystemContext = context;
            }
        }
        return mSystemContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installSystemApplicationInfo(ApplicationInfo info) {
        ActivityThread activityThread = this;
        synchronized (activityThread) {
            ContextImpl context = this.getSystemContext();
            context.init(new LoadedApk(this, "android", context, info, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO), null, this);
            this.mProfiler = new Profiler();
        }
    }

    void ensureJitEnabled() {
        if (!this.mJitEnabled) {
            this.mJitEnabled = true;
            VMRuntime.getRuntime().startJitCompilation();
        }
    }

    void scheduleGcIdler() {
        if (!this.mGcIdlerScheduled) {
            this.mGcIdlerScheduled = true;
            Looper.myQueue().addIdleHandler(this.mGcIdler);
        }
        this.mH.removeMessages(120);
    }

    void unscheduleGcIdler() {
        if (this.mGcIdlerScheduled) {
            this.mGcIdlerScheduled = false;
            Looper.myQueue().removeIdleHandler(this.mGcIdler);
        }
        this.mH.removeMessages(120);
    }

    void doGcIfNeeded() {
        this.mGcIdlerScheduled = false;
        long now = SystemClock.uptimeMillis();
        if (BinderInternal.getLastGcTime() + 5000L < now) {
            BinderInternal.forceGc("bg");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnActivityPausedListener(Activity activity, OnActivityPausedListener listener) {
        HashMap<Activity, ArrayList<OnActivityPausedListener>> hashMap = this.mOnPauseListeners;
        synchronized (hashMap) {
            ArrayList<OnActivityPausedListener> list = this.mOnPauseListeners.get(activity);
            if (list == null) {
                list = new ArrayList();
                this.mOnPauseListeners.put(activity, list);
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnActivityPausedListener(Activity activity, OnActivityPausedListener listener) {
        HashMap<Activity, ArrayList<OnActivityPausedListener>> hashMap = this.mOnPauseListeners;
        synchronized (hashMap) {
            ArrayList<OnActivityPausedListener> list = this.mOnPauseListeners.get(activity);
            if (list != null) {
                list.remove(listener);
            }
        }
    }

    public ActivityInfo resolveActivityInfo(Intent intent) {
        ActivityInfo aInfo = intent.resolveActivityInfo(this.mInitialApplication.getPackageManager(), 1024);
        if (aInfo == null) {
            Instrumentation.checkStartActivityResult(-2, intent);
        }
        return aInfo;
    }

    public Activity startActivityNow(Activity parent, String id2, Intent intent, ActivityInfo activityInfo, IBinder token, Bundle state, Activity.NonConfigurationInstances lastNonConfigurationInstances) {
        ActivityClientRecord r = new ActivityClientRecord();
        r.token = token;
        r.ident = 0;
        r.intent = intent;
        r.state = state;
        r.parent = parent;
        r.embeddedID = id2;
        r.activityInfo = activityInfo;
        r.lastNonConfigurationInstances = lastNonConfigurationInstances;
        return this.performLaunchActivity(r, null);
    }

    public Activity getActivity(IBinder token) {
        return this.mActivities.get((Object)token).activity;
    }

    public void sendActivityResult(IBinder token, String id2, int requestCode, int resultCode, Intent data) {
        ArrayList<ResultInfo> list = new ArrayList<ResultInfo>();
        list.add(new ResultInfo(id2, requestCode, resultCode, data));
        this.mAppThread.scheduleSendResult(token, list);
    }

    private void queueOrSendMessage(int what, Object obj) {
        this.queueOrSendMessage(what, obj, 0, 0);
    }

    private void queueOrSendMessage(int what, Object obj, int arg1) {
        this.queueOrSendMessage(what, obj, arg1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueOrSendMessage(int what, Object obj, int arg1, int arg2) {
        ActivityThread activityThread = this;
        synchronized (activityThread) {
            Message msg = Message.obtain();
            msg.what = what;
            msg.obj = obj;
            msg.arg1 = arg1;
            msg.arg2 = arg2;
            this.mH.sendMessage(msg);
        }
    }

    void scheduleContextCleanup(ContextImpl context, String who, String what) {
        ContextCleanupInfo cci = new ContextCleanupInfo();
        cci.context = context;
        cci.who = who;
        cci.what = what;
        this.queueOrSendMessage(119, cci);
    }

    private Activity performLaunchActivity(ActivityClientRecord r, Intent customIntent) {
        Activity activity;
        block18: {
            ComponentName component;
            block17: {
                ActivityInfo aInfo = r.activityInfo;
                if (r.packageInfo == null) {
                    r.packageInfo = this.getPackageInfo(aInfo.applicationInfo, r.compatInfo, 1);
                }
                if ((component = r.intent.getComponent()) == null) {
                    component = r.intent.resolveActivity(this.mInitialApplication.getPackageManager());
                    r.intent.setComponent(component);
                }
                if (r.activityInfo.targetActivity != null) {
                    component = new ComponentName(r.activityInfo.packageName, r.activityInfo.targetActivity);
                }
                activity = null;
                try {
                    ClassLoader cl = r.packageInfo.getClassLoader();
                    activity = this.mInstrumentation.newActivity(cl, component.getClassName(), r.intent);
                    StrictMode.incrementExpectedActivityCount(activity.getClass());
                    r.intent.setExtrasClassLoader(cl);
                    if (r.state != null) {
                        r.state.setClassLoader(cl);
                    }
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(activity, e)) break block17;
                    throw new RuntimeException("Unable to instantiate activity " + component + ": " + e.toString(), e);
                }
            }
            try {
                Application app = r.packageInfo.makeApplication(false, this.mInstrumentation);
                if (activity != null) {
                    ContextImpl appContext = new ContextImpl();
                    appContext.init(r.packageInfo, r.token, this);
                    appContext.setOuterContext(activity);
                    CharSequence title = r.activityInfo.loadLabel(appContext.getPackageManager());
                    Configuration config = new Configuration(this.mCompatConfiguration);
                    activity.attach(appContext, this, this.getInstrumentation(), r.token, r.ident, app, r.intent, r.activityInfo, title, r.parent, r.embeddedID, r.lastNonConfigurationInstances, config);
                    if (customIntent != null) {
                        activity.mIntent = customIntent;
                    }
                    r.lastNonConfigurationInstances = null;
                    activity.mStartedActivity = false;
                    int theme = r.activityInfo.getThemeResource();
                    if (theme != 0) {
                        activity.setTheme(theme);
                    }
                    activity.mCalled = false;
                    this.mInstrumentation.callActivityOnCreate(activity, r.state);
                    if (!activity.mCalled) {
                        throw new SuperNotCalledException("Activity " + r.intent.getComponent().toShortString() + " did not call through to super.onCreate()");
                    }
                    r.activity = activity;
                    r.stopped = true;
                    if (!r.activity.mFinished) {
                        activity.performStart();
                        r.stopped = false;
                    }
                    if (!r.activity.mFinished && r.state != null) {
                        this.mInstrumentation.callActivityOnRestoreInstanceState(activity, r.state);
                    }
                    if (!r.activity.mFinished) {
                        activity.mCalled = false;
                        this.mInstrumentation.callActivityOnPostCreate(activity, r.state);
                        if (!activity.mCalled) {
                            throw new SuperNotCalledException("Activity " + r.intent.getComponent().toShortString() + " did not call through to super.onPostCreate()");
                        }
                    }
                }
                r.paused = true;
                this.mActivities.put(r.token, r);
            }
            catch (SuperNotCalledException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.mInstrumentation.onException(activity, e)) break block18;
                throw new RuntimeException("Unable to start activity " + component + ": " + e.toString(), e);
            }
        }
        return activity;
    }

    private void handleLaunchActivity(ActivityClientRecord r, Intent customIntent) {
        this.unscheduleGcIdler();
        if (r.profileFd != null) {
            this.mProfiler.setProfiler(r.profileFile, r.profileFd);
            this.mProfiler.startProfiling();
            this.mProfiler.autoStopProfiler = r.autoStopProfiler;
        }
        this.handleConfigurationChanged(null, null);
        Activity a = this.performLaunchActivity(r, customIntent);
        if (a != null) {
            r.createdConfig = new Configuration(this.mConfiguration);
            Bundle oldState = r.state;
            this.handleResumeActivity(r.token, false, r.isForward);
            if (!r.activity.mFinished && r.startsNotResumed) {
                block10: {
                    try {
                        r.activity.mCalled = false;
                        this.mInstrumentation.callActivityOnPause(r.activity);
                        r.state = oldState;
                        if (!r.activity.mCalled) {
                            throw new SuperNotCalledException("Activity " + r.intent.getComponent().toShortString() + " did not call through to super.onPause()");
                        }
                    }
                    catch (SuperNotCalledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (this.mInstrumentation.onException(r.activity, e)) break block10;
                        throw new RuntimeException("Unable to pause activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                    }
                }
                r.paused = true;
            }
        } else {
            try {
                ActivityManagerNative.getDefault().finishActivity(r.token, 0, null);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    private void deliverNewIntents(ActivityClientRecord r, List<Intent> intents) {
        int N = intents.size();
        for (int i = 0; i < N; ++i) {
            Intent intent = intents.get(i);
            intent.setExtrasClassLoader(r.activity.getClassLoader());
            r.activity.mFragments.noteStateNotSaved();
            this.mInstrumentation.callActivityOnNewIntent(r.activity, intent);
        }
    }

    public void performNewIntents(IBinder token, List<Intent> intents) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r != null) {
            boolean resumed;
            boolean bl = resumed = !r.paused;
            if (resumed) {
                r.activity.mTemporaryPause = true;
                this.mInstrumentation.callActivityOnPause(r.activity);
            }
            this.deliverNewIntents(r, intents);
            if (resumed) {
                r.activity.performResume();
                r.activity.mTemporaryPause = false;
            }
        }
    }

    private void handleNewIntent(NewIntentData data) {
        this.performNewIntents(data.token, data.intents);
    }

    public static Intent getIntentBeingBroadcast() {
        return sCurrentBroadcastIntent.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReceiver(ReceiverData data) {
        BroadcastReceiver receiver;
        this.unscheduleGcIdler();
        String component = data.intent.getComponent().getClassName();
        LoadedApk packageInfo = this.getPackageInfoNoCheck(data.info.applicationInfo, data.compatInfo);
        IActivityManager mgr = ActivityManagerNative.getDefault();
        try {
            ClassLoader cl = packageInfo.getClassLoader();
            data.intent.setExtrasClassLoader(cl);
            data.setExtrasClassLoader(cl);
            receiver = (BroadcastReceiver)cl.loadClass(component).newInstance();
        }
        catch (Exception e) {
            data.sendFinished(mgr);
            throw new RuntimeException("Unable to instantiate receiver " + component + ": " + e.toString(), e);
        }
        try {
            Application app = packageInfo.makeApplication(false, this.mInstrumentation);
            ContextImpl context = (ContextImpl)app.getBaseContext();
            sCurrentBroadcastIntent.set(data.intent);
            receiver.setPendingResult(data);
            receiver.onReceive(context.getReceiverRestrictedContext(), data.intent);
        }
        catch (Exception e) {
            data.sendFinished(mgr);
            if (!this.mInstrumentation.onException(receiver, e)) {
                throw new RuntimeException("Unable to start receiver " + component + ": " + e.toString(), e);
            }
        }
        finally {
            sCurrentBroadcastIntent.set(null);
        }
        if (receiver.getPendingResult() != null) {
            data.finish();
        }
    }

    private void handleCreateBackupAgent(CreateBackupAgentData data) {
        Slog.v(TAG, "handleCreateBackupAgent: " + data);
        this.unscheduleGcIdler();
        LoadedApk packageInfo = this.getPackageInfoNoCheck(data.appInfo, data.compatInfo);
        String packageName = packageInfo.mPackageName;
        if (this.mBackupAgents.get(packageName) != null) {
            Slog.d(TAG, "BackupAgent   for " + packageName + " already exists");
            return;
        }
        BackupAgent agent = null;
        String classname = data.appInfo.backupAgentName;
        if (classname == null && (data.backupMode == 1 || data.backupMode == 3)) {
            classname = "android.app.backup.FullBackupAgent";
        }
        try {
            IBinder binder;
            block8: {
                binder = null;
                try {
                    Slog.v(TAG, "Initializing agent class " + classname);
                    ClassLoader cl = packageInfo.getClassLoader();
                    agent = (BackupAgent)cl.loadClass(classname).newInstance();
                    ContextImpl context = new ContextImpl();
                    context.init(packageInfo, null, this);
                    context.setOuterContext(agent);
                    agent.attach(context);
                    agent.onCreate();
                    binder = agent.onBind();
                    this.mBackupAgents.put(packageName, agent);
                }
                catch (Exception e) {
                    Slog.e(TAG, "Agent threw during creation: " + e);
                    if (data.backupMode == 2 || data.backupMode == 3) break block8;
                    throw e;
                }
            }
            try {
                ActivityManagerNative.getDefault().backupAgentCreated(packageName, binder);
            }
            catch (RemoteException e) {}
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create BackupAgent " + classname + ": " + e.toString(), e);
        }
    }

    private void handleDestroyBackupAgent(CreateBackupAgentData data) {
        Slog.v(TAG, "handleDestroyBackupAgent: " + data);
        LoadedApk packageInfo = this.getPackageInfoNoCheck(data.appInfo, data.compatInfo);
        String packageName = packageInfo.mPackageName;
        BackupAgent agent = this.mBackupAgents.get(packageName);
        if (agent != null) {
            try {
                agent.onDestroy();
            }
            catch (Exception e) {
                Slog.w(TAG, "Exception thrown in onDestroy by backup agent of " + data.appInfo);
                e.printStackTrace();
            }
            this.mBackupAgents.remove(packageName);
        } else {
            Slog.w(TAG, "Attempt to destroy unknown backup agent " + data);
        }
    }

    private void handleCreateService(CreateServiceData data) {
        block7: {
            Service service;
            LoadedApk packageInfo;
            block6: {
                this.unscheduleGcIdler();
                packageInfo = this.getPackageInfoNoCheck(data.info.applicationInfo, data.compatInfo);
                service = null;
                try {
                    ClassLoader cl = packageInfo.getClassLoader();
                    service = (Service)cl.loadClass(data.info.name).newInstance();
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(service, e)) break block6;
                    throw new RuntimeException("Unable to instantiate service " + data.info.name + ": " + e.toString(), e);
                }
            }
            try {
                ContextImpl context = new ContextImpl();
                context.init(packageInfo, null, this);
                Application app = packageInfo.makeApplication(false, this.mInstrumentation);
                context.setOuterContext(service);
                service.attach(context, this, data.info.name, data.token, app, ActivityManagerNative.getDefault());
                service.onCreate();
                this.mServices.put(data.token, service);
                try {
                    ActivityManagerNative.getDefault().serviceDoneExecuting(data.token, 0, 0, 0);
                }
                catch (RemoteException e) {}
            }
            catch (Exception e) {
                if (this.mInstrumentation.onException(service, e)) break block7;
                throw new RuntimeException("Unable to create service " + data.info.name + ": " + e.toString(), e);
            }
        }
    }

    private void handleBindService(BindServiceData data) {
        block7: {
            Service s = this.mServices.get(data.token);
            if (s != null) {
                try {
                    data.intent.setExtrasClassLoader(s.getClassLoader());
                    try {
                        if (!data.rebind) {
                            IBinder binder = s.onBind(data.intent);
                            ActivityManagerNative.getDefault().publishService(data.token, data.intent, binder);
                        } else {
                            s.onRebind(data.intent);
                            ActivityManagerNative.getDefault().serviceDoneExecuting(data.token, 0, 0, 0);
                        }
                        this.ensureJitEnabled();
                    }
                    catch (RemoteException ex) {}
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(s, e)) break block7;
                    throw new RuntimeException("Unable to bind to service " + s + " with " + data.intent + ": " + e.toString(), e);
                }
            }
        }
    }

    private void handleUnbindService(BindServiceData data) {
        block6: {
            Service s = this.mServices.get(data.token);
            if (s != null) {
                try {
                    data.intent.setExtrasClassLoader(s.getClassLoader());
                    boolean doRebind = s.onUnbind(data.intent);
                    try {
                        if (doRebind) {
                            ActivityManagerNative.getDefault().unbindFinished(data.token, data.intent, doRebind);
                            break block6;
                        }
                        ActivityManagerNative.getDefault().serviceDoneExecuting(data.token, 0, 0, 0);
                    }
                    catch (RemoteException ex) {}
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(s, e)) break block6;
                    throw new RuntimeException("Unable to unbind to service " + s + " with " + data.intent + ": " + e.toString(), e);
                }
            }
        }
    }

    private void handleDumpService(DumpComponentInfo info) {
        Service s = this.mServices.get(info.token);
        if (s != null) {
            PrintWriter pw = new PrintWriter(new FileOutputStream(info.fd.getFileDescriptor()));
            s.dump(info.fd.getFileDescriptor(), pw, info.args);
            pw.flush();
            try {
                info.fd.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void handleDumpActivity(DumpComponentInfo info) {
        ActivityClientRecord r = this.mActivities.get(info.token);
        if (r != null && r.activity != null) {
            PrintWriter pw = new PrintWriter(new FileOutputStream(info.fd.getFileDescriptor()));
            r.activity.dump(info.prefix, info.fd.getFileDescriptor(), pw, info.args);
            pw.flush();
            try {
                info.fd.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void handleServiceArgs(ServiceArgsData data) {
        block8: {
            Service s = this.mServices.get(data.token);
            if (s != null) {
                try {
                    int res;
                    if (data.args != null) {
                        data.args.setExtrasClassLoader(s.getClassLoader());
                    }
                    if (!data.taskRemoved) {
                        res = s.onStartCommand(data.args, data.flags, data.startId);
                    } else {
                        s.onTaskRemoved(data.args);
                        res = 1000;
                    }
                    QueuedWork.waitToFinish();
                    try {
                        ActivityManagerNative.getDefault().serviceDoneExecuting(data.token, 1, data.startId, res);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    this.ensureJitEnabled();
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(s, e)) break block8;
                    throw new RuntimeException("Unable to start service " + s + " with " + data.args + ": " + e.toString(), e);
                }
            }
        }
    }

    private void handleStopService(IBinder token) {
        block6: {
            Service s = this.mServices.remove(token);
            if (s != null) {
                try {
                    s.onDestroy();
                    Context context = s.getBaseContext();
                    if (context instanceof ContextImpl) {
                        String who = s.getClassName();
                        ((ContextImpl)context).scheduleFinalCleanup(who, "Service");
                    }
                    QueuedWork.waitToFinish();
                    try {
                        ActivityManagerNative.getDefault().serviceDoneExecuting(token, 0, 0, 0);
                    }
                    catch (RemoteException e) {}
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(s, e)) break block6;
                    throw new RuntimeException("Unable to stop service " + s + ": " + e.toString(), e);
                }
            }
        }
    }

    public ActivityClientRecord performResumeActivity(IBinder token, boolean clearHide) {
        ActivityClientRecord r;
        block6: {
            r = this.mActivities.get(token);
            if (r != null && !r.activity.mFinished) {
                if (clearHide) {
                    r.hideForNow = false;
                    r.activity.mStartedActivity = false;
                }
                try {
                    if (r.pendingIntents != null) {
                        this.deliverNewIntents(r, r.pendingIntents);
                        r.pendingIntents = null;
                    }
                    if (r.pendingResults != null) {
                        this.deliverResults(r, r.pendingResults);
                        r.pendingResults = null;
                    }
                    r.activity.performResume();
                    EventLog.writeEvent(30022, r.activity.getComponentName().getClassName());
                    r.paused = false;
                    r.stopped = false;
                    r.state = null;
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(r.activity, e)) break block6;
                    throw new RuntimeException("Unable to resume activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                }
            }
        }
        return r;
    }

    void cleanUpPendingRemoveWindows(ActivityClientRecord r) {
        if (r.mPendingRemoveWindow != null) {
            r.mPendingRemoveWindowManager.removeViewImmediate(r.mPendingRemoveWindow);
            IBinder wtoken = r.mPendingRemoveWindow.getWindowToken();
            if (wtoken != null) {
                WindowManagerImpl.getDefault().closeAll(wtoken, r.activity.getClass().getName(), "Activity");
            }
        }
        r.mPendingRemoveWindow = null;
        r.mPendingRemoveWindowManager = null;
    }

    void handleResumeActivity(IBinder token, boolean clearHide, boolean isForward) {
        this.unscheduleGcIdler();
        ActivityClientRecord r = this.performResumeActivity(token, clearHide);
        if (r != null) {
            WindowManager wm;
            boolean willBeVisible;
            Activity a = r.activity;
            int forwardBit = isForward ? 256 : 0;
            boolean bl = willBeVisible = !a.mStartedActivity;
            if (!willBeVisible) {
                try {
                    willBeVisible = ActivityManagerNative.getDefault().willActivityBeVisible(a.getActivityToken());
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            if (r.window == null && !a.mFinished && willBeVisible) {
                r.window = r.activity.getWindow();
                View decor = r.window.getDecorView();
                decor.setVisibility(4);
                wm = a.getWindowManager();
                WindowManager.LayoutParams l = r.window.getAttributes();
                a.mDecor = decor;
                l.type = 1;
                l.softInputMode |= forwardBit;
                if (a.mVisibleFromClient) {
                    a.mWindowAdded = true;
                    wm.addView(decor, l);
                }
            } else if (!willBeVisible) {
                r.hideForNow = true;
            }
            this.cleanUpPendingRemoveWindows(r);
            if (!r.activity.mFinished && willBeVisible && r.activity.mDecor != null && !r.hideForNow) {
                if (r.newConfig != null) {
                    this.performConfigurationChanged(r.activity, r.newConfig);
                    r.newConfig = null;
                }
                WindowManager.LayoutParams l = r.window.getAttributes();
                if ((l.softInputMode & 0x100) != forwardBit) {
                    l.softInputMode = l.softInputMode & 0xFFFFFEFF | forwardBit;
                    if (r.activity.mVisibleFromClient) {
                        wm = a.getWindowManager();
                        View decor = r.window.getDecorView();
                        wm.updateViewLayout(decor, l);
                    }
                }
                r.activity.mVisibleFromServer = true;
                ++this.mNumVisibleActivities;
                if (r.activity.mVisibleFromClient) {
                    r.activity.makeVisible();
                }
            }
            if (!r.onlyLocalRequest) {
                r.nextIdle = this.mNewActivities;
                this.mNewActivities = r;
                Looper.myQueue().addIdleHandler(new Idler());
            }
            r.onlyLocalRequest = false;
        } else {
            try {
                ActivityManagerNative.getDefault().finishActivity(token, 0, null);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    private Bitmap createThumbnailBitmap(ActivityClientRecord r) {
        Bitmap thumbnail = this.mAvailThumbnailBitmap;
        try {
            if (thumbnail == null) {
                int h;
                int w = this.mThumbnailWidth;
                if (w < 0) {
                    Resources res = r.activity.getResources();
                    this.mThumbnailHeight = h = res.getDimensionPixelSize(0x1050001);
                    this.mThumbnailWidth = w = res.getDimensionPixelSize(17104898);
                } else {
                    h = this.mThumbnailHeight;
                }
                if (w > 0 && h > 0) {
                    thumbnail = Bitmap.createBitmap(w, h, THUMBNAIL_FORMAT);
                    thumbnail.eraseColor(0);
                }
            }
            if (thumbnail != null) {
                Canvas cv = this.mThumbnailCanvas;
                if (cv == null) {
                    this.mThumbnailCanvas = cv = new Canvas();
                }
                cv.setBitmap(thumbnail);
                if (!r.activity.onCreateThumbnail(thumbnail, cv)) {
                    this.mAvailThumbnailBitmap = thumbnail;
                    thumbnail = null;
                }
                cv.setBitmap(null);
            }
        }
        catch (Exception e) {
            if (!this.mInstrumentation.onException(r.activity, e)) {
                throw new RuntimeException("Unable to create thumbnail of " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
            }
            thumbnail = null;
        }
        return thumbnail;
    }

    private void handlePauseActivity(IBinder token, boolean finished, boolean userLeaving, int configChanges) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r != null) {
            if (userLeaving) {
                this.performUserLeavingActivity(r);
            }
            r.activity.mConfigChangeFlags |= configChanges;
            this.performPauseActivity(token, finished, r.isPreHoneycomb());
            if (r.isPreHoneycomb()) {
                QueuedWork.waitToFinish();
            }
            try {
                ActivityManagerNative.getDefault().activityPaused(token);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    void performUserLeavingActivity(ActivityClientRecord r) {
        this.mInstrumentation.callActivityOnUserLeaving(r.activity);
    }

    Bundle performPauseActivity(IBinder token, boolean finished, boolean saveState) {
        ActivityClientRecord r = this.mActivities.get(token);
        return r != null ? this.performPauseActivity(r, finished, saveState) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle performPauseActivity(ActivityClientRecord r, boolean finished, boolean saveState) {
        ArrayList<OnActivityPausedListener> listeners;
        Bundle state;
        block12: {
            if (r.paused) {
                if (r.activity.mFinished) {
                    return null;
                }
                RuntimeException e = new RuntimeException("Performing pause of activity that is not resumed: " + r.intent.getComponent().toShortString());
                Slog.e(TAG, e.getMessage(), e);
            }
            state = null;
            if (finished) {
                r.activity.mFinished = true;
            }
            try {
                if (!r.activity.mFinished && saveState) {
                    state = new Bundle();
                    state.setAllowFds(false);
                    this.mInstrumentation.callActivityOnSaveInstanceState(r.activity, state);
                    r.state = state;
                }
                r.activity.mCalled = false;
                this.mInstrumentation.callActivityOnPause(r.activity);
                EventLog.writeEvent(30021, r.activity.getComponentName().getClassName());
                if (!r.activity.mCalled) {
                    throw new SuperNotCalledException("Activity " + r.intent.getComponent().toShortString() + " did not call through to super.onPause()");
                }
            }
            catch (SuperNotCalledException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.mInstrumentation.onException(r.activity, e)) break block12;
                throw new RuntimeException("Unable to pause activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
            }
        }
        r.paused = true;
        HashMap<Activity, ArrayList<OnActivityPausedListener>> hashMap = this.mOnPauseListeners;
        synchronized (hashMap) {
            listeners = this.mOnPauseListeners.remove(r.activity);
        }
        int size = listeners != null ? listeners.size() : 0;
        for (int i = 0; i < size; ++i) {
            listeners.get(i).onPaused(r.activity);
        }
        return state;
    }

    void performStopActivity(IBinder token, boolean saveState) {
        ActivityClientRecord r = this.mActivities.get(token);
        this.performStopActivityInner(r, null, false, saveState);
    }

    private void performStopActivityInner(ActivityClientRecord r, StopInfo info, boolean keepShown, boolean saveState) {
        Bundle state = null;
        if (r != null) {
            block12: {
                if (!keepShown && r.stopped) {
                    if (r.activity.mFinished) {
                        return;
                    }
                    RuntimeException e = new RuntimeException("Performing stop of activity that is not resumed: " + r.intent.getComponent().toShortString());
                    Slog.e(TAG, e.getMessage(), e);
                }
                if (info != null) {
                    try {
                        info.thumbnail = null;
                        info.description = r.activity.onCreateDescription();
                    }
                    catch (Exception e) {
                        if (this.mInstrumentation.onException(r.activity, e)) break block12;
                        throw new RuntimeException("Unable to save state of activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                    }
                }
            }
            if (!r.activity.mFinished && saveState) {
                if (r.state == null) {
                    state = new Bundle();
                    state.setAllowFds(false);
                    this.mInstrumentation.callActivityOnSaveInstanceState(r.activity, state);
                    r.state = state;
                } else {
                    state = r.state;
                }
            }
            if (!keepShown) {
                block13: {
                    try {
                        r.activity.performStop();
                    }
                    catch (Exception e) {
                        if (this.mInstrumentation.onException(r.activity, e)) break block13;
                        throw new RuntimeException("Unable to stop activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                    }
                }
                r.stopped = true;
            }
            r.paused = true;
        }
    }

    private void updateVisibility(ActivityClientRecord r, boolean show) {
        View v = r.activity.mDecor;
        if (v != null) {
            if (show) {
                if (!r.activity.mVisibleFromServer) {
                    r.activity.mVisibleFromServer = true;
                    ++this.mNumVisibleActivities;
                    if (r.activity.mVisibleFromClient) {
                        r.activity.makeVisible();
                    }
                }
                if (r.newConfig != null) {
                    this.performConfigurationChanged(r.activity, r.newConfig);
                    r.newConfig = null;
                }
            } else if (r.activity.mVisibleFromServer) {
                r.activity.mVisibleFromServer = false;
                --this.mNumVisibleActivities;
                v.setVisibility(4);
            }
        }
    }

    private void handleStopActivity(IBinder token, boolean show, int configChanges) {
        ActivityClientRecord r = this.mActivities.get(token);
        r.activity.mConfigChangeFlags |= configChanges;
        StopInfo info = new StopInfo();
        this.performStopActivityInner(r, info, show, true);
        this.updateVisibility(r, show);
        if (!r.isPreHoneycomb()) {
            QueuedWork.waitToFinish();
        }
        try {
            ActivityManagerNative.getDefault().activityStopped(r.token, r.state, info.thumbnail, info.description);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    void performRestartActivity(IBinder token) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r.stopped) {
            r.activity.performRestart();
            r.stopped = false;
        }
    }

    private void handleWindowVisibility(IBinder token, boolean show) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r == null) {
            Log.w(TAG, "handleWindowVisibility: no activity for token " + token);
            return;
        }
        if (!show && !r.stopped) {
            this.performStopActivityInner(r, null, show, false);
        } else if (show && r.stopped) {
            this.unscheduleGcIdler();
            r.activity.performRestart();
            r.stopped = false;
        }
        if (r.activity.mDecor != null) {
            this.updateVisibility(r, show);
        }
    }

    private void handleSleeping(IBinder token, boolean sleeping) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r == null) {
            Log.w(TAG, "handleSleeping: no activity for token " + token);
            return;
        }
        if (sleeping) {
            if (!r.stopped && !r.isPreHoneycomb()) {
                block10: {
                    try {
                        r.activity.performStop();
                    }
                    catch (Exception e) {
                        if (this.mInstrumentation.onException(r.activity, e)) break block10;
                        throw new RuntimeException("Unable to stop activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                    }
                }
                r.stopped = true;
            }
            if (!r.isPreHoneycomb()) {
                QueuedWork.waitToFinish();
            }
            try {
                ActivityManagerNative.getDefault().activitySlept(r.token);
            }
            catch (RemoteException ex) {}
        } else if (r.stopped && r.activity.mVisibleFromServer) {
            r.activity.performRestart();
            r.stopped = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSetCoreSettings(Bundle coreSettings) {
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.mCoreSettings = coreSettings;
        }
    }

    private void handleUpdatePackageCompatibilityInfo(UpdateCompatibilityData data) {
        LoadedApk apk = this.peekPackageInfo(data.pkg, false);
        if (apk != null) {
            apk.mCompatibilityInfo.set(data.info);
        }
        if ((apk = this.peekPackageInfo(data.pkg, true)) != null) {
            apk.mCompatibilityInfo.set(data.info);
        }
        this.handleConfigurationChanged(this.mConfiguration, data.info);
        WindowManagerImpl.getDefault().reportNewConfiguration(this.mConfiguration);
    }

    private void deliverResults(ActivityClientRecord r, List<ResultInfo> results) {
        int N = results.size();
        for (int i = 0; i < N; ++i) {
            ResultInfo ri = results.get(i);
            try {
                if (ri.mData != null) {
                    ri.mData.setExtrasClassLoader(r.activity.getClassLoader());
                }
                r.activity.dispatchActivityResult(ri.mResultWho, ri.mRequestCode, ri.mResultCode, ri.mData);
                continue;
            }
            catch (Exception e) {
                if (this.mInstrumentation.onException(r.activity, e)) continue;
                throw new RuntimeException("Failure delivering result " + ri + " to activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
            }
        }
    }

    private void handleSendResult(ResultData res) {
        ActivityClientRecord r = this.mActivities.get(res.token);
        if (r != null) {
            boolean resumed;
            block8: {
                boolean bl = resumed = !r.paused;
                if (!r.activity.mFinished && r.activity.mDecor != null && r.hideForNow && resumed) {
                    this.updateVisibility(r, true);
                }
                if (resumed) {
                    try {
                        r.activity.mCalled = false;
                        r.activity.mTemporaryPause = true;
                        this.mInstrumentation.callActivityOnPause(r.activity);
                        if (!r.activity.mCalled) {
                            throw new SuperNotCalledException("Activity " + r.intent.getComponent().toShortString() + " did not call through to super.onPause()");
                        }
                    }
                    catch (SuperNotCalledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (this.mInstrumentation.onException(r.activity, e)) break block8;
                        throw new RuntimeException("Unable to pause activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                    }
                }
            }
            this.deliverResults(r, res.results);
            if (resumed) {
                r.activity.performResume();
                r.activity.mTemporaryPause = false;
            }
        }
    }

    public ActivityClientRecord performDestroyActivity(IBinder token, boolean finishing) {
        return this.performDestroyActivity(token, finishing, 0, false);
    }

    private ActivityClientRecord performDestroyActivity(IBinder token, boolean finishing, int configChanges, boolean getNonConfigInstance) {
        Class<?> activityClass;
        ActivityClientRecord r;
        block22: {
            r = this.mActivities.get(token);
            activityClass = null;
            if (r != null) {
                block21: {
                    activityClass = r.activity.getClass();
                    r.activity.mConfigChangeFlags |= configChanges;
                    if (finishing) {
                        r.activity.mFinished = true;
                    }
                    if (!r.paused) {
                        block19: {
                            try {
                                r.activity.mCalled = false;
                                this.mInstrumentation.callActivityOnPause(r.activity);
                                EventLog.writeEvent(30021, r.activity.getComponentName().getClassName());
                                if (!r.activity.mCalled) {
                                    throw new SuperNotCalledException("Activity " + ActivityThread.safeToComponentShortString(r.intent) + " did not call through to super.onPause()");
                                }
                            }
                            catch (SuperNotCalledException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                if (this.mInstrumentation.onException(r.activity, e)) break block19;
                                throw new RuntimeException("Unable to pause activity " + ActivityThread.safeToComponentShortString(r.intent) + ": " + e.toString(), e);
                            }
                        }
                        r.paused = true;
                    }
                    if (!r.stopped) {
                        block20: {
                            try {
                                r.activity.performStop();
                            }
                            catch (SuperNotCalledException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                if (this.mInstrumentation.onException(r.activity, e)) break block20;
                                throw new RuntimeException("Unable to stop activity " + ActivityThread.safeToComponentShortString(r.intent) + ": " + e.toString(), e);
                            }
                        }
                        r.stopped = true;
                    }
                    if (getNonConfigInstance) {
                        try {
                            r.lastNonConfigurationInstances = r.activity.retainNonConfigurationInstances();
                        }
                        catch (Exception e) {
                            if (this.mInstrumentation.onException(r.activity, e)) break block21;
                            throw new RuntimeException("Unable to retain activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                        }
                    }
                }
                try {
                    r.activity.mCalled = false;
                    this.mInstrumentation.callActivityOnDestroy(r.activity);
                    if (!r.activity.mCalled) {
                        throw new SuperNotCalledException("Activity " + ActivityThread.safeToComponentShortString(r.intent) + " did not call through to super.onDestroy()");
                    }
                    if (r.window != null) {
                        r.window.closeAllPanels();
                    }
                }
                catch (SuperNotCalledException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(r.activity, e)) break block22;
                    throw new RuntimeException("Unable to destroy activity " + ActivityThread.safeToComponentShortString(r.intent) + ": " + e.toString(), e);
                }
            }
        }
        this.mActivities.remove(token);
        StrictMode.decrementExpectedActivityCount(activityClass);
        return r;
    }

    private static String safeToComponentShortString(Intent intent) {
        ComponentName component = intent.getComponent();
        return component == null ? "[Unknown]" : component.toShortString();
    }

    private void handleDestroyActivity(IBinder token, boolean finishing, int configChanges, boolean getNonConfigInstance) {
        ActivityClientRecord r = this.performDestroyActivity(token, finishing, configChanges, getNonConfigInstance);
        if (r != null) {
            Context c;
            this.cleanUpPendingRemoveWindows(r);
            WindowManager wm = r.activity.getWindowManager();
            View v = r.activity.mDecor;
            if (v != null) {
                if (r.activity.mVisibleFromServer) {
                    --this.mNumVisibleActivities;
                }
                IBinder wtoken = v.getWindowToken();
                if (r.activity.mWindowAdded) {
                    if (r.onlyLocalRequest) {
                        r.mPendingRemoveWindow = v;
                        r.mPendingRemoveWindowManager = wm;
                    } else {
                        wm.removeViewImmediate(v);
                    }
                }
                if (wtoken != null && r.mPendingRemoveWindow == null) {
                    WindowManagerImpl.getDefault().closeAll(wtoken, r.activity.getClass().getName(), "Activity");
                }
                r.activity.mDecor = null;
            }
            if (r.mPendingRemoveWindow == null) {
                WindowManagerImpl.getDefault().closeAll(token, r.activity.getClass().getName(), "Activity");
            }
            if ((c = r.activity.getBaseContext()) instanceof ContextImpl) {
                ((ContextImpl)c).scheduleFinalCleanup(r.activity.getClass().getName(), "Activity");
            }
        }
        if (finishing) {
            try {
                ActivityManagerNative.getDefault().activityDestroyed(token);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRelaunchActivity(IBinder token, List<ResultInfo> pendingResults, List<Intent> pendingNewIntents, int configChanges, boolean notResumed, Configuration config, boolean fromServer) {
        ActivityClientRecord target = null;
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (int i = 0; i < this.mRelaunchingActivities.size(); ++i) {
                ActivityClientRecord r = this.mRelaunchingActivities.get(i);
                if (r.token != token) continue;
                target = r;
                if (pendingResults != null) {
                    if (r.pendingResults != null) {
                        r.pendingResults.addAll(pendingResults);
                    } else {
                        r.pendingResults = pendingResults;
                    }
                }
                if (pendingNewIntents == null) break;
                if (r.pendingIntents != null) {
                    r.pendingIntents.addAll(pendingNewIntents);
                    break;
                }
                r.pendingIntents = pendingNewIntents;
                break;
            }
            if (target == null) {
                target = new ActivityClientRecord();
                target.token = token;
                target.pendingResults = pendingResults;
                target.pendingIntents = pendingNewIntents;
                if (!fromServer) {
                    ActivityClientRecord existing = this.mActivities.get(token);
                    if (existing != null) {
                        target.startsNotResumed = existing.paused;
                    }
                    target.onlyLocalRequest = true;
                }
                this.mRelaunchingActivities.add(target);
                this.queueOrSendMessage(126, target);
            }
            if (fromServer) {
                target.startsNotResumed = notResumed;
                target.onlyLocalRequest = false;
            }
            if (config != null) {
                target.createdConfig = config;
            }
            target.pendingConfigChanges |= configChanges;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRelaunchActivity(ActivityClientRecord tmp) {
        ActivityClientRecord r;
        this.unscheduleGcIdler();
        Configuration changedConfig = null;
        int configChanges = 0;
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            int N = this.mRelaunchingActivities.size();
            IBinder token = tmp.token;
            tmp = null;
            for (int i = 0; i < N; ++i) {
                ActivityClientRecord r2 = this.mRelaunchingActivities.get(i);
                if (r2.token != token) continue;
                tmp = r2;
                configChanges |= tmp.pendingConfigChanges;
                this.mRelaunchingActivities.remove(i);
                --i;
                --N;
            }
            if (tmp == null) {
                return;
            }
            if (this.mPendingConfiguration != null) {
                changedConfig = this.mPendingConfiguration;
                this.mPendingConfiguration = null;
            }
        }
        if (tmp.createdConfig != null && (this.mConfiguration == null || tmp.createdConfig.isOtherSeqNewer(this.mConfiguration) && this.mConfiguration.diff(tmp.createdConfig) != 0) && (changedConfig == null || tmp.createdConfig.isOtherSeqNewer(changedConfig))) {
            changedConfig = tmp.createdConfig;
        }
        if (changedConfig != null) {
            this.handleConfigurationChanged(changedConfig, null);
        }
        if ((r = this.mActivities.get(tmp.token)) == null) {
            return;
        }
        r.activity.mConfigChangeFlags |= configChanges;
        r.onlyLocalRequest = tmp.onlyLocalRequest;
        Intent currentIntent = r.activity.mIntent;
        r.activity.mChangingConfigurations = true;
        if (!r.paused) {
            this.performPauseActivity(r.token, false, r.isPreHoneycomb());
        }
        if (r.state == null && !r.stopped && !r.isPreHoneycomb()) {
            r.state = new Bundle();
            r.state.setAllowFds(false);
            this.mInstrumentation.callActivityOnSaveInstanceState(r.activity, r.state);
        }
        this.handleDestroyActivity(r.token, false, configChanges, true);
        r.activity = null;
        r.window = null;
        r.hideForNow = false;
        r.nextIdle = null;
        if (tmp.pendingResults != null) {
            if (r.pendingResults == null) {
                r.pendingResults = tmp.pendingResults;
            } else {
                r.pendingResults.addAll(tmp.pendingResults);
            }
        }
        if (tmp.pendingIntents != null) {
            if (r.pendingIntents == null) {
                r.pendingIntents = tmp.pendingIntents;
            } else {
                r.pendingIntents.addAll(tmp.pendingIntents);
            }
        }
        r.startsNotResumed = tmp.startsNotResumed;
        this.handleLaunchActivity(r, currentIntent);
    }

    private void handleRequestThumbnail(IBinder token) {
        CharSequence description;
        Bitmap thumbnail;
        block4: {
            ActivityClientRecord r = this.mActivities.get(token);
            thumbnail = this.createThumbnailBitmap(r);
            description = null;
            try {
                description = r.activity.onCreateDescription();
            }
            catch (Exception e) {
                if (this.mInstrumentation.onException(r.activity, e)) break block4;
                throw new RuntimeException("Unable to create description of activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
            }
        }
        try {
            ActivityManagerNative.getDefault().reportThumbnail(token, thumbnail, description);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<ComponentCallbacks2> collectComponentCallbacksLocked(boolean allActivities, Configuration newConfig) {
        Iterator<Service> it;
        ArrayList<ComponentCallbacks2> callbacks = new ArrayList<ComponentCallbacks2>();
        if (this.mActivities.size() > 0) {
            for (ActivityClientRecord ar : this.mActivities.values()) {
                Activity a = ar.activity;
                if (a == null) continue;
                Configuration thisConfig = this.applyConfigCompatMainThread(newConfig, ar.packageInfo.mCompatibilityInfo.getIfNeeded());
                if (!ar.activity.mFinished && (allActivities || a != null && !ar.paused)) {
                    callbacks.add(a);
                    continue;
                }
                if (thisConfig == null) continue;
                ar.newConfig = thisConfig;
            }
        }
        if (this.mServices.size() > 0) {
            it = this.mServices.values().iterator();
            while (it.hasNext()) {
                callbacks.add(it.next());
            }
        }
        it = this.mProviderMap;
        synchronized (it) {
            if (this.mLocalProviders.size() > 0) {
                Iterator<ProviderClientRecord> it2 = this.mLocalProviders.values().iterator();
                while (it2.hasNext()) {
                    callbacks.add(it2.next().mLocalProvider);
                }
            }
        }
        int N = this.mAllApplications.size();
        for (int i = 0; i < N; ++i) {
            callbacks.add(this.mAllApplications.get(i));
        }
        return callbacks;
    }

    private void performConfigurationChanged(ComponentCallbacks2 cb, Configuration config) {
        Activity activity;
        Activity activity2 = activity = cb instanceof Activity ? (Activity)cb : null;
        if (activity != null) {
            activity.mCalled = false;
        }
        boolean shouldChangeConfig = false;
        if (activity == null || activity.mCurrentConfig == null) {
            shouldChangeConfig = true;
        } else {
            int diff = activity.mCurrentConfig.diff(config);
            if (diff != 0 && (~activity.mActivityInfo.getRealConfigChanged() & diff) == 0) {
                shouldChangeConfig = true;
            }
        }
        if (shouldChangeConfig) {
            cb.onConfigurationChanged(config);
            if (activity != null) {
                if (!activity.mCalled) {
                    throw new SuperNotCalledException("Activity " + activity.getLocalClassName() + " did not call through to super.onConfigurationChanged()");
                }
                activity.mConfigChangeFlags = 0;
                activity.mCurrentConfig = new Configuration(config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyConfigurationToResources(Configuration config) {
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.applyConfigurationToResourcesLocked(config, null);
        }
    }

    boolean applyConfigurationToResourcesLocked(Configuration config, CompatibilityInfo compat) {
        if (this.mResConfiguration == null) {
            this.mResConfiguration = new Configuration();
        }
        if (!this.mResConfiguration.isOtherSeqNewer(config) && compat == null) {
            return false;
        }
        int changes = this.mResConfiguration.updateFrom(config);
        DisplayMetrics dm = this.getDisplayMetricsLocked(null, true);
        if (!(compat == null || this.mResCompatibilityInfo != null && this.mResCompatibilityInfo.equals(compat))) {
            this.mResCompatibilityInfo = compat;
            changes |= 0xD00;
        }
        if (config.locale != null) {
            Locale.setDefault(config.locale);
        }
        Resources.updateSystemConfiguration(config, dm, compat);
        ApplicationPackageManager.configurationChanged();
        Iterator<WeakReference<Resources>> it = this.mActiveResources.values().iterator();
        while (it.hasNext()) {
            WeakReference<Resources> v = it.next();
            Resources r = (Resources)v.get();
            if (r != null) {
                r.updateConfiguration(config, dm, compat);
                continue;
            }
            it.remove();
        }
        return changes != 0;
    }

    Configuration applyCompatConfiguration() {
        Configuration config = this.mConfiguration;
        if (this.mCompatConfiguration == null) {
            this.mCompatConfiguration = new Configuration();
        }
        this.mCompatConfiguration.setTo(this.mConfiguration);
        if (this.mResCompatibilityInfo != null && !this.mResCompatibilityInfo.supportsScreen()) {
            this.mResCompatibilityInfo.applyToConfiguration(this.mCompatConfiguration);
            config = this.mCompatConfiguration;
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleConfigurationChanged(Configuration config, CompatibilityInfo compat) {
        ArrayList<ComponentCallbacks2> callbacks = null;
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mPendingConfiguration != null) {
                if (!this.mPendingConfiguration.isOtherSeqNewer(config)) {
                    config = this.mPendingConfiguration;
                }
                this.mPendingConfiguration = null;
            }
            if (config == null) {
                return;
            }
            this.applyConfigurationToResourcesLocked(config, compat);
            if (this.mConfiguration == null) {
                this.mConfiguration = new Configuration();
            }
            if (!this.mConfiguration.isOtherSeqNewer(config) && compat == null) {
                return;
            }
            this.mConfiguration.updateFrom(config);
            config = this.applyCompatConfiguration();
            callbacks = this.collectComponentCallbacksLocked(false, config);
        }
        WindowManagerImpl.getDefault().trimLocalMemory();
        if (callbacks != null) {
            int N = callbacks.size();
            for (int i = 0; i < N; ++i) {
                this.performConfigurationChanged(callbacks.get(i), config);
            }
        }
    }

    void handleActivityConfigurationChanged(IBinder token) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r == null || r.activity == null) {
            return;
        }
        this.performConfigurationChanged(r.activity, this.mCompatConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleProfilerControl(boolean start, ProfilerControlData pcd, int profileType) {
        if (start) {
            try {
                switch (profileType) {
                    case 1: {
                        ViewDebug.startLooperProfiling(pcd.path, pcd.fd.getFileDescriptor());
                        return;
                    }
                    default: {
                        this.mProfiler.setProfiler(pcd.path, pcd.fd);
                        this.mProfiler.autoStopProfiler = false;
                        this.mProfiler.startProfiling();
                        return;
                    }
                }
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Profiling failed on path " + pcd.path + " -- can the process access this path?");
                return;
            }
            finally {
                try {
                    pcd.fd.close();
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failure closing profile fd", e);
                }
            }
        }
        switch (profileType) {
            case 1: {
                ViewDebug.stopLooperProfiling();
                return;
            }
            default: {
                this.mProfiler.stopProfiling();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDumpHeap(boolean managed, DumpHeapData dhd) {
        if (managed) {
            try {
                Debug.dumpHprofData(dhd.path, dhd.fd.getFileDescriptor());
            }
            catch (IOException e) {
                Slog.w(TAG, "Managed heap dump failed on path " + dhd.path + " -- can the process access this path?");
            }
            finally {
                try {
                    dhd.fd.close();
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failure closing profile fd", e);
                }
            }
        } else {
            Debug.dumpNativeHeap(dhd.fd.getFileDescriptor());
        }
    }

    void handleDispatchPackageBroadcast(int cmd, String[] packages) {
        boolean hasPkgInfo = false;
        if (packages != null) {
            for (int i = packages.length - 1; i >= 0; --i) {
                if (!hasPkgInfo) {
                    WeakReference<LoadedApk> ref = this.mPackages.get(packages[i]);
                    if (ref != null && ref.get() != null) {
                        hasPkgInfo = true;
                    } else {
                        ref = this.mResourcePackages.get(packages[i]);
                        if (ref != null && ref.get() != null) {
                            hasPkgInfo = true;
                        }
                    }
                }
                this.mPackages.remove(packages[i]);
                this.mResourcePackages.remove(packages[i]);
            }
        }
        ApplicationPackageManager.handlePackageBroadcast(cmd, packages, hasPkgInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleLowMemory() {
        ArrayList<ComponentCallbacks2> callbacks;
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            callbacks = this.collectComponentCallbacksLocked(true, null);
        }
        int N = callbacks.size();
        for (int i = 0; i < N; ++i) {
            callbacks.get(i).onLowMemory();
        }
        if (Process.myUid() != 1000) {
            int sqliteReleased = SQLiteDatabase.releaseMemory();
            EventLog.writeEvent(75003, sqliteReleased);
        }
        Canvas.freeCaches();
        BinderInternal.forceGc("mem");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTrimMemory(int level) {
        ArrayList<ComponentCallbacks2> callbacks;
        WindowManagerImpl.getDefault().trimMemory(level);
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            callbacks = this.collectComponentCallbacksLocked(true, null);
        }
        int N = callbacks.size();
        for (int i = 0; i < N; ++i) {
            callbacks.get(i).onTrimMemory(level);
        }
    }

    private void setupGraphicsSupport(LoadedApk info) {
        try {
            int uid = Process.myUid();
            String[] packages = ActivityThread.getPackageManager().getPackagesForUid(uid);
            if (packages.length == 1) {
                ContextImpl appContext = new ContextImpl();
                appContext.init(info, null, this);
                HardwareRenderer.setupDiskCache(appContext.getCacheDir());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void handleBindApplication(AppBindData data) {
        block29: {
            List<ProviderInfo> providers;
            Application app;
            IBinder b;
            Display display;
            this.mBoundApplication = data;
            this.mConfiguration = new Configuration(data.config);
            this.mCompatConfiguration = new Configuration(data.config);
            this.mProfiler = new Profiler();
            this.mProfiler.profileFile = data.initProfileFile;
            this.mProfiler.profileFd = data.initProfileFd;
            this.mProfiler.autoStopProfiler = data.initAutoStopProfiler;
            Process.setArgV0(data.processName);
            DdmHandleAppName.setAppName(data.processName);
            if (data.persistent && !ActivityManager.isHighEndGfx(display = WindowManagerImpl.getDefault().getDefaultDisplay())) {
                HardwareRenderer.disable(false);
            }
            if (this.mProfiler.profileFd != null) {
                this.mProfiler.startProfiling();
            }
            if (data.appInfo.targetSdkVersion <= 12) {
                AsyncTask.setDefaultExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            }
            TimeZone.setDefault(null);
            Locale.setDefault(data.config.locale);
            this.applyConfigurationToResourcesLocked(data.config, data.compatInfo);
            this.applyCompatConfiguration();
            data.info = this.getPackageInfoNoCheck(data.appInfo, data.compatInfo);
            this.setupGraphicsSupport(data.info);
            if ((data.appInfo.flags & 0x81) != 0) {
                StrictMode.conditionallyEnableDebugLogging();
            }
            if (data.appInfo.targetSdkVersion > 9) {
                StrictMode.enableDeathOnNetwork();
            }
            if ((data.appInfo.flags & 0x2000) == 0) {
                Bitmap.setDefaultDensity(160);
            }
            if (data.debugMode != 0) {
                Debug.changeDebugPort(8100);
                if (data.debugMode == 2) {
                    Slog.w(TAG, "Application " + data.info.getPackageName() + " is waiting for the debugger on port 8100...");
                    IActivityManager mgr = ActivityManagerNative.getDefault();
                    try {
                        mgr.showWaitingForDebugger(this.mAppThread, true);
                    }
                    catch (RemoteException ex) {
                        // empty catch block
                    }
                    Debug.waitForDebugger();
                    try {
                        mgr.showWaitingForDebugger(this.mAppThread, false);
                    }
                    catch (RemoteException ex) {}
                } else {
                    Slog.w(TAG, "Application " + data.info.getPackageName() + " can be debugged on port 8100...");
                }
            }
            if ((b = ServiceManager.getService("connectivity")) != null) {
                IConnectivityManager service = IConnectivityManager.Stub.asInterface(b);
                try {
                    ProxyProperties proxyProperties = service.getProxy();
                    Proxy.setHttpProxySystemProperty(proxyProperties);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            if (data.instrumentationName != null) {
                ContextImpl appContext = new ContextImpl();
                appContext.init(data.info, null, this);
                InstrumentationInfo ii = null;
                try {
                    ii = appContext.getPackageManager().getInstrumentationInfo(data.instrumentationName, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
                if (ii == null) {
                    throw new RuntimeException("Unable to find instrumentation info for: " + data.instrumentationName);
                }
                this.mInstrumentationAppDir = ii.sourceDir;
                this.mInstrumentationAppPackage = ii.packageName;
                this.mInstrumentedAppDir = data.info.getAppDir();
                ApplicationInfo instrApp = new ApplicationInfo();
                instrApp.packageName = ii.packageName;
                instrApp.sourceDir = ii.sourceDir;
                instrApp.publicSourceDir = ii.publicSourceDir;
                instrApp.dataDir = ii.dataDir;
                instrApp.nativeLibraryDir = ii.nativeLibraryDir;
                LoadedApk pi = this.getPackageInfo(instrApp, data.compatInfo, appContext.getClassLoader(), false, true);
                ContextImpl instrContext = new ContextImpl();
                instrContext.init(pi, null, this);
                try {
                    ClassLoader cl = instrContext.getClassLoader();
                    this.mInstrumentation = (Instrumentation)cl.loadClass(data.instrumentationName.getClassName()).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to instantiate instrumentation " + data.instrumentationName + ": " + e.toString(), e);
                }
                this.mInstrumentation.init(this, instrContext, appContext, new ComponentName(ii.packageName, ii.name), data.instrumentationWatcher);
                if (this.mProfiler.profileFile != null && !ii.handleProfiling && this.mProfiler.profileFd == null) {
                    this.mProfiler.handlingProfiling = true;
                    File file = new File(this.mProfiler.profileFile);
                    file.getParentFile().mkdirs();
                    Debug.startMethodTracing(file.toString(), 0x800000);
                }
                try {
                    this.mInstrumentation.onCreate(data.instrumentationArgs);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception thrown in onCreate() of " + data.instrumentationName + ": " + e.toString(), e);
                }
            }
            this.mInstrumentation = new Instrumentation();
            if ((data.appInfo.flags & 0x100000) != 0) {
                VMRuntime.getRuntime().clearGrowthLimit();
            }
            this.mInitialApplication = app = data.info.makeApplication(data.restrictedBackupMode, null);
            if (!data.restrictedBackupMode && (providers = data.providers) != null) {
                this.installContentProviders(app, providers);
                this.mH.sendEmptyMessageDelayed(132, 10000L);
            }
            try {
                this.mInstrumentation.callApplicationOnCreate(app);
            }
            catch (Exception e) {
                if (this.mInstrumentation.onException(app, e)) break block29;
                throw new RuntimeException("Unable to create application " + app.getClass().getName() + ": " + e.toString(), e);
            }
        }
    }

    void finishInstrumentation(int resultCode, Bundle results) {
        IActivityManager am = ActivityManagerNative.getDefault();
        if (this.mProfiler.profileFile != null && this.mProfiler.handlingProfiling && this.mProfiler.profileFd == null) {
            Debug.stopMethodTracing();
        }
        try {
            am.finishInstrumentation(this.mAppThread, resultCode, results);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    private void installContentProviders(Context context, List<ProviderInfo> providers) {
        ArrayList<IActivityManager.ContentProviderHolder> results = new ArrayList<IActivityManager.ContentProviderHolder>();
        for (ProviderInfo cpi : providers) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Pub ");
            buf.append(cpi.authority);
            buf.append(": ");
            buf.append(cpi.name);
            Log.i(TAG, buf.toString());
            IContentProvider cp = this.installProvider(context, null, cpi, false, true);
            if (cp == null) continue;
            IActivityManager.ContentProviderHolder cph = new IActivityManager.ContentProviderHolder(cpi);
            cph.provider = cp;
            cph.noReleaseNeeded = true;
            results.add(cph);
        }
        try {
            ActivityManagerNative.getDefault().publishContentProviders(this.getApplicationThread(), results);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public IContentProvider acquireProvider(Context c, String name) {
        IContentProvider provider = this.acquireExistingProvider(c, name);
        if (provider != null) {
            return provider;
        }
        IActivityManager.ContentProviderHolder holder = null;
        try {
            holder = ActivityManagerNative.getDefault().getContentProvider(this.getApplicationThread(), name);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        if (holder == null) {
            Slog.e(TAG, "Failed to find provider info for " + name);
            return null;
        }
        provider = this.installProvider(c, holder.provider, holder.info, true, holder.noReleaseNeeded);
        if (holder.provider != null && provider != holder.provider) {
            try {
                ActivityManagerNative.getDefault().removeContentProvider(this.getApplicationThread(), name);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContentProvider acquireExistingProvider(Context c, String name) {
        HashMap<String, ProviderClientRecord> hashMap = this.mProviderMap;
        synchronized (hashMap) {
            ProviderClientRecord pr = this.mProviderMap.get(name);
            if (pr == null) {
                return null;
            }
            IContentProvider provider = pr.mProvider;
            IBinder jBinder = provider.asBinder();
            ProviderRefCount prc = this.mProviderRefCountMap.get(jBinder);
            if (prc != null) {
                ++prc.count;
                if (prc.count == 1) {
                    this.mH.removeMessages(131, provider);
                }
            }
            return provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseProvider(IContentProvider provider) {
        if (provider == null) {
            return false;
        }
        IBinder jBinder = provider.asBinder();
        HashMap<String, ProviderClientRecord> hashMap = this.mProviderMap;
        synchronized (hashMap) {
            ProviderRefCount prc = this.mProviderRefCountMap.get(jBinder);
            if (prc == null) {
                return false;
            }
            if (prc.count == 0) {
                return false;
            }
            --prc.count;
            if (prc.count == 0) {
                Message msg = this.mH.obtainMessage(131, provider);
                this.mH.sendMessage(msg);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeRemoveProvider(IContentProvider provider) {
        IBinder jBinder = provider.asBinder();
        String remoteProviderName = null;
        HashMap<String, ProviderClientRecord> hashMap = this.mProviderMap;
        synchronized (hashMap) {
            ProviderRefCount prc = this.mProviderRefCountMap.get(jBinder);
            if (prc == null) {
                return;
            }
            if (prc.count != 0) {
                return;
            }
            this.mProviderRefCountMap.remove(jBinder);
            Iterator<ProviderClientRecord> iter = this.mProviderMap.values().iterator();
            while (iter.hasNext()) {
                ProviderClientRecord pr = iter.next();
                IBinder myBinder = pr.mProvider.asBinder();
                if (myBinder != jBinder) continue;
                iter.remove();
                if (pr.mLocalProvider != null) continue;
                myBinder.unlinkToDeath(pr, 0);
                if (remoteProviderName != null) continue;
                remoteProviderName = pr.mName;
            }
        }
        if (remoteProviderName != null) {
            try {
                ActivityManagerNative.getDefault().removeContentProvider(this.getApplicationThread(), remoteProviderName);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDeadProvider(String name, IContentProvider provider) {
        HashMap<String, ProviderClientRecord> hashMap = this.mProviderMap;
        synchronized (hashMap) {
            ProviderClientRecord pr = this.mProviderMap.get(name);
            if (pr != null && pr.mProvider.asBinder() == provider.asBinder()) {
                Slog.i(TAG, "Removing dead content provider: " + name);
                ProviderClientRecord removed = this.mProviderMap.remove(name);
                if (removed != null) {
                    removed.mProvider.asBinder().unlinkToDeath(removed, 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IContentProvider installProvider(Context context, IContentProvider provider, ProviderInfo info, boolean noisy, boolean noReleaseNeeded) {
        ContentProvider localProvider = null;
        if (provider == null) {
            if (noisy) {
                Slog.d(TAG, "Loading provider " + info.authority + ": " + info.name);
            }
            Context c = null;
            ApplicationInfo ai = info.applicationInfo;
            if (context.getPackageName().equals(ai.packageName)) {
                c = context;
            } else if (this.mInitialApplication != null && this.mInitialApplication.getPackageName().equals(ai.packageName)) {
                c = this.mInitialApplication;
            } else {
                try {
                    c = context.createPackageContext(ai.packageName, 1);
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
            }
            if (c == null) {
                Slog.w(TAG, "Unable to get context for package " + ai.packageName + " while loading content provider " + info.name);
                return null;
            }
            try {
                ClassLoader cl = c.getClassLoader();
                localProvider = (ContentProvider)cl.loadClass(info.name).newInstance();
                provider = localProvider.getIContentProvider();
                if (provider == null) {
                    Slog.e(TAG, "Failed to instantiate class " + info.name + " from sourceDir " + info.applicationInfo.sourceDir);
                    return null;
                }
                localProvider.attachInfo(c, info);
            }
            catch (Exception e) {
                if (!this.mInstrumentation.onException(null, e)) {
                    throw new RuntimeException("Unable to get provider " + info.name + ": " + e.toString(), e);
                }
                return null;
            }
        }
        HashMap<String, ProviderClientRecord> hashMap = this.mProviderMap;
        synchronized (hashMap) {
            IBinder jBinder = provider.asBinder();
            String[] names = PATTERN_SEMICOLON.split(info.authority);
            for (int i = 0; i < names.length; ++i) {
                ProviderClientRecord pr = this.mProviderMap.get(names[i]);
                if (pr != null) {
                    provider = pr.mProvider;
                    continue;
                }
                pr = new ProviderClientRecord(names[i], provider, localProvider);
                if (localProvider == null) {
                    try {
                        jBinder.linkToDeath(pr, 0);
                    }
                    catch (RemoteException e) {
                        return null;
                    }
                }
                this.mProviderMap.put(names[i], pr);
            }
            if (localProvider != null) {
                ProviderClientRecord pr = this.mLocalProviders.get(jBinder);
                if (pr != null) {
                    provider = pr.mProvider;
                } else {
                    pr = new ProviderClientRecord(null, provider, localProvider);
                    this.mLocalProviders.put(jBinder, pr);
                }
            }
            if (!noReleaseNeeded) {
                ProviderRefCount prc = this.mProviderRefCountMap.get(jBinder);
                if (prc != null) {
                    ++prc.count;
                    if (prc.count == 1) {
                        this.mH.removeMessages(131, provider);
                    }
                } else {
                    this.mProviderRefCountMap.put(jBinder, new ProviderRefCount(1));
                }
            }
        }
        return provider;
    }

    private void attach(boolean system) {
        sThreadLocal.set(this);
        this.mSystemThread = system;
        if (!system) {
            ViewRootImpl.addFirstDrawHandler(new Runnable(){

                public void run() {
                    ActivityThread.this.ensureJitEnabled();
                }
            });
            DdmHandleAppName.setAppName("<pre-initialized>");
            RuntimeInit.setApplicationObject(this.mAppThread.asBinder());
            IActivityManager mgr = ActivityManagerNative.getDefault();
            try {
                mgr.attachApplication(this.mAppThread);
            }
            catch (RemoteException ex) {}
        } else {
            DdmHandleAppName.setAppName("system_process");
            try {
                this.mInstrumentation = new Instrumentation();
                ContextImpl context = new ContextImpl();
                context.init(this.getSystemContext().mPackageInfo, null, this);
                Application app = Instrumentation.newApplication(Application.class, context);
                this.mAllApplications.add(app);
                this.mInitialApplication = app;
                app.onCreate();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate Application():" + e.toString(), e);
            }
        }
        ViewRootImpl.addConfigCallback(new ComponentCallbacks2(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onConfigurationChanged(Configuration newConfig) {
                HashMap<String, WeakReference<LoadedApk>> hashMap = ActivityThread.this.mPackages;
                synchronized (hashMap) {
                    if (ActivityThread.this.applyConfigurationToResourcesLocked(newConfig, null) && (ActivityThread.this.mPendingConfiguration == null || ActivityThread.this.mPendingConfiguration.isOtherSeqNewer(newConfig))) {
                        ActivityThread.this.mPendingConfiguration = newConfig;
                        ActivityThread.this.queueOrSendMessage(118, newConfig);
                    }
                }
            }

            public void onLowMemory() {
            }

            public void onTrimMemory(int level) {
            }
        });
    }

    public static ActivityThread systemMain() {
        HardwareRenderer.disable(true);
        ActivityThread thread = new ActivityThread();
        thread.attach(true);
        return thread;
    }

    public void installSystemProviders(List<ProviderInfo> providers) {
        if (providers != null) {
            this.installContentProviders(this.mInitialApplication, providers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntCoreSetting(String key, int defaultValue) {
        HashMap<String, WeakReference<LoadedApk>> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mCoreSettings != null) {
                return this.mCoreSettings.getInt(key, defaultValue);
            }
            return defaultValue;
        }
    }

    public static void main(String[] args) {
        SamplingProfilerIntegration.start();
        CloseGuard.setEnabled(false);
        Process.setArgV0("<pre-initialized>");
        Looper.prepareMainLooper();
        if (sMainThreadHandler == null) {
            sMainThreadHandler = new Handler();
        }
        ActivityThread thread = new ActivityThread();
        thread.attach(false);
        Looper.loop();
        throw new RuntimeException("Main thread loop unexpectedly exited");
    }

    static {
        sThreadLocal = new ThreadLocal();
        sCurrentBroadcastIntent = new ThreadLocal();
    }

    private static class ProviderRefCount {
        public int count;

        ProviderRefCount(int pCount) {
            this.count = pCount;
        }
    }

    private static class StopInfo {
        Bitmap thumbnail;
        CharSequence description;

        private StopInfo() {
        }
    }

    private static class ResourcesKey {
        private final String mResDir;
        private final float mScale;
        private final int mHash;

        ResourcesKey(String resDir, float scale) {
            this.mResDir = resDir;
            this.mScale = scale;
            this.mHash = this.mResDir.hashCode() << 2 + (int)(this.mScale * 2.0f);
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ResourcesKey)) {
                return false;
            }
            ResourcesKey peer = (ResourcesKey)obj;
            return this.mResDir.equals(peer.mResDir) && this.mScale == peer.mScale;
        }
    }

    class GcIdler
    implements MessageQueue.IdleHandler {
        GcIdler() {
        }

        public boolean queueIdle() {
            ActivityThread.this.doGcIfNeeded();
            return false;
        }
    }

    private class Idler
    implements MessageQueue.IdleHandler {
        private Idler() {
        }

        public boolean queueIdle() {
            ActivityClientRecord a = ActivityThread.this.mNewActivities;
            boolean stopProfiling = false;
            if (ActivityThread.this.mBoundApplication != null && ActivityThread.this.mProfiler.profileFd != null && ActivityThread.this.mProfiler.autoStopProfiler) {
                stopProfiling = true;
            }
            if (a != null) {
                ActivityThread.this.mNewActivities = null;
                IActivityManager am = ActivityManagerNative.getDefault();
                do {
                    if (a.activity != null && !a.activity.mFinished) {
                        try {
                            am.activityIdle(a.token, a.createdConfig, stopProfiling);
                            a.createdConfig = null;
                        }
                        catch (RemoteException ex) {
                            // empty catch block
                        }
                    }
                    ActivityClientRecord prev = a;
                    a = a.nextIdle;
                    prev.nextIdle = null;
                } while (a != null);
            }
            if (stopProfiling) {
                ActivityThread.this.mProfiler.stopProfiling();
            }
            ActivityThread.this.ensureJitEnabled();
            return false;
        }
    }

    private class H
    extends Handler {
        public static final int LAUNCH_ACTIVITY = 100;
        public static final int PAUSE_ACTIVITY = 101;
        public static final int PAUSE_ACTIVITY_FINISHING = 102;
        public static final int STOP_ACTIVITY_SHOW = 103;
        public static final int STOP_ACTIVITY_HIDE = 104;
        public static final int SHOW_WINDOW = 105;
        public static final int HIDE_WINDOW = 106;
        public static final int RESUME_ACTIVITY = 107;
        public static final int SEND_RESULT = 108;
        public static final int DESTROY_ACTIVITY = 109;
        public static final int BIND_APPLICATION = 110;
        public static final int EXIT_APPLICATION = 111;
        public static final int NEW_INTENT = 112;
        public static final int RECEIVER = 113;
        public static final int CREATE_SERVICE = 114;
        public static final int SERVICE_ARGS = 115;
        public static final int STOP_SERVICE = 116;
        public static final int REQUEST_THUMBNAIL = 117;
        public static final int CONFIGURATION_CHANGED = 118;
        public static final int CLEAN_UP_CONTEXT = 119;
        public static final int GC_WHEN_IDLE = 120;
        public static final int BIND_SERVICE = 121;
        public static final int UNBIND_SERVICE = 122;
        public static final int DUMP_SERVICE = 123;
        public static final int LOW_MEMORY = 124;
        public static final int ACTIVITY_CONFIGURATION_CHANGED = 125;
        public static final int RELAUNCH_ACTIVITY = 126;
        public static final int PROFILER_CONTROL = 127;
        public static final int CREATE_BACKUP_AGENT = 128;
        public static final int DESTROY_BACKUP_AGENT = 129;
        public static final int SUICIDE = 130;
        public static final int REMOVE_PROVIDER = 131;
        public static final int ENABLE_JIT = 132;
        public static final int DISPATCH_PACKAGE_BROADCAST = 133;
        public static final int SCHEDULE_CRASH = 134;
        public static final int DUMP_HEAP = 135;
        public static final int DUMP_ACTIVITY = 136;
        public static final int SLEEPING = 137;
        public static final int SET_CORE_SETTINGS = 138;
        public static final int UPDATE_PACKAGE_COMPATIBILITY_INFO = 139;
        public static final int TRIM_MEMORY = 140;

        private H() {
        }

        String codeToString(int code) {
            return "(unknown)";
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    ActivityClientRecord r = (ActivityClientRecord)msg.obj;
                    r.packageInfo = ActivityThread.this.getPackageInfoNoCheck(r.activityInfo.applicationInfo, r.compatInfo);
                    ActivityThread.this.handleLaunchActivity(r, null);
                    break;
                }
                case 126: {
                    ActivityClientRecord r = (ActivityClientRecord)msg.obj;
                    ActivityThread.this.handleRelaunchActivity(r);
                    break;
                }
                case 101: {
                    ActivityThread.this.handlePauseActivity((IBinder)msg.obj, false, msg.arg1 != 0, msg.arg2);
                    this.maybeSnapshot();
                    break;
                }
                case 102: {
                    ActivityThread.this.handlePauseActivity((IBinder)msg.obj, true, msg.arg1 != 0, msg.arg2);
                    break;
                }
                case 103: {
                    ActivityThread.this.handleStopActivity((IBinder)msg.obj, true, msg.arg2);
                    break;
                }
                case 104: {
                    ActivityThread.this.handleStopActivity((IBinder)msg.obj, false, msg.arg2);
                    break;
                }
                case 105: {
                    ActivityThread.this.handleWindowVisibility((IBinder)msg.obj, true);
                    break;
                }
                case 106: {
                    ActivityThread.this.handleWindowVisibility((IBinder)msg.obj, false);
                    break;
                }
                case 107: {
                    ActivityThread.this.handleResumeActivity((IBinder)msg.obj, true, msg.arg1 != 0);
                    break;
                }
                case 108: {
                    ActivityThread.this.handleSendResult((ResultData)msg.obj);
                    break;
                }
                case 109: {
                    ActivityThread.this.handleDestroyActivity((IBinder)msg.obj, msg.arg1 != 0, msg.arg2, false);
                    break;
                }
                case 110: {
                    AppBindData data = (AppBindData)msg.obj;
                    ActivityThread.this.handleBindApplication(data);
                    break;
                }
                case 111: {
                    if (ActivityThread.this.mInitialApplication != null) {
                        ActivityThread.this.mInitialApplication.onTerminate();
                    }
                    Looper.myLooper().quit();
                    break;
                }
                case 112: {
                    ActivityThread.this.handleNewIntent((NewIntentData)msg.obj);
                    break;
                }
                case 113: {
                    ActivityThread.this.handleReceiver((ReceiverData)msg.obj);
                    this.maybeSnapshot();
                    break;
                }
                case 114: {
                    ActivityThread.this.handleCreateService((CreateServiceData)msg.obj);
                    break;
                }
                case 121: {
                    ActivityThread.this.handleBindService((BindServiceData)msg.obj);
                    break;
                }
                case 122: {
                    ActivityThread.this.handleUnbindService((BindServiceData)msg.obj);
                    break;
                }
                case 115: {
                    ActivityThread.this.handleServiceArgs((ServiceArgsData)msg.obj);
                    break;
                }
                case 116: {
                    ActivityThread.this.handleStopService((IBinder)msg.obj);
                    this.maybeSnapshot();
                    break;
                }
                case 117: {
                    ActivityThread.this.handleRequestThumbnail((IBinder)msg.obj);
                    break;
                }
                case 118: {
                    ActivityThread.this.handleConfigurationChanged((Configuration)msg.obj, null);
                    break;
                }
                case 119: {
                    ContextCleanupInfo cci = (ContextCleanupInfo)msg.obj;
                    cci.context.performFinalCleanup(cci.who, cci.what);
                    break;
                }
                case 120: {
                    ActivityThread.this.scheduleGcIdler();
                    break;
                }
                case 123: {
                    ActivityThread.this.handleDumpService((DumpComponentInfo)msg.obj);
                    break;
                }
                case 124: {
                    ActivityThread.this.handleLowMemory();
                    break;
                }
                case 125: {
                    ActivityThread.this.handleActivityConfigurationChanged((IBinder)msg.obj);
                    break;
                }
                case 127: {
                    ActivityThread.this.handleProfilerControl(msg.arg1 != 0, (ProfilerControlData)msg.obj, msg.arg2);
                    break;
                }
                case 128: {
                    ActivityThread.this.handleCreateBackupAgent((CreateBackupAgentData)msg.obj);
                    break;
                }
                case 129: {
                    ActivityThread.this.handleDestroyBackupAgent((CreateBackupAgentData)msg.obj);
                    break;
                }
                case 130: {
                    Process.killProcess(Process.myPid());
                    break;
                }
                case 131: {
                    ActivityThread.this.completeRemoveProvider((IContentProvider)msg.obj);
                    break;
                }
                case 132: {
                    ActivityThread.this.ensureJitEnabled();
                    break;
                }
                case 133: {
                    ActivityThread.this.handleDispatchPackageBroadcast(msg.arg1, (String[])msg.obj);
                    break;
                }
                case 134: {
                    throw new RemoteServiceException((String)msg.obj);
                }
                case 135: {
                    ActivityThread.this.handleDumpHeap(msg.arg1 != 0, (DumpHeapData)msg.obj);
                    break;
                }
                case 136: {
                    ActivityThread.this.handleDumpActivity((DumpComponentInfo)msg.obj);
                    break;
                }
                case 137: {
                    ActivityThread.this.handleSleeping((IBinder)msg.obj, msg.arg1 != 0);
                    break;
                }
                case 138: {
                    ActivityThread.this.handleSetCoreSettings((Bundle)msg.obj);
                    break;
                }
                case 139: {
                    ActivityThread.this.handleUpdatePackageCompatibilityInfo((UpdateCompatibilityData)msg.obj);
                    break;
                }
                case 140: {
                    ActivityThread.this.handleTrimMemory(msg.arg1);
                }
            }
        }

        private void maybeSnapshot() {
            if (ActivityThread.this.mBoundApplication != null && SamplingProfilerIntegration.isEnabled()) {
                String packageName = ActivityThread.this.mBoundApplication.info.mPackageName;
                PackageInfo packageInfo = null;
                try {
                    ContextImpl context = ActivityThread.this.getSystemContext();
                    if (context == null) {
                        Log.e(ActivityThread.TAG, "cannot get a valid context");
                        return;
                    }
                    PackageManager pm = ((Context)context).getPackageManager();
                    if (pm == null) {
                        Log.e(ActivityThread.TAG, "cannot get a valid PackageManager");
                        return;
                    }
                    packageInfo = pm.getPackageInfo(packageName, 1);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(ActivityThread.TAG, "cannot get package info for " + packageName, e);
                }
                SamplingProfilerIntegration.writeSnapshot(ActivityThread.this.mBoundApplication.processName, packageInfo);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplicationThread
    extends ApplicationThreadNative {
        private static final String HEAP_COLUMN = "%13s %8s %8s %8s %8s %8s %8s";
        private static final String ONE_COUNT_COLUMN = "%21s %8d";
        private static final String TWO_COUNT_COLUMNS = "%21s %8d %21s %8d";
        private static final String TWO_COUNT_COLUMNS_DB = "%21s %8d %21s %8d";
        private static final String DB_INFO_FORMAT = "  %8s %8s %14s %14s  %s";
        private static final int ACTIVITY_THREAD_CHECKIN_VERSION = 1;

        private ApplicationThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updatePendingConfiguration(Configuration config) {
            HashMap<String, WeakReference<LoadedApk>> hashMap = ActivityThread.this.mPackages;
            synchronized (hashMap) {
                if (ActivityThread.this.mPendingConfiguration == null || ActivityThread.this.mPendingConfiguration.isOtherSeqNewer(config)) {
                    ActivityThread.this.mPendingConfiguration = config;
                }
            }
        }

        @Override
        public void schedulePauseActivity(IBinder token, boolean finished, boolean userLeaving, int configChanges) {
            ActivityThread.this.queueOrSendMessage(finished ? 102 : 101, token, userLeaving ? 1 : 0, configChanges);
        }

        @Override
        public void scheduleStopActivity(IBinder token, boolean showWindow, int configChanges) {
            ActivityThread.this.queueOrSendMessage(showWindow ? 103 : 104, token, 0, configChanges);
        }

        @Override
        public void scheduleWindowVisibility(IBinder token, boolean showWindow) {
            ActivityThread.this.queueOrSendMessage(showWindow ? 105 : 106, token);
        }

        @Override
        public void scheduleSleeping(IBinder token, boolean sleeping) {
            ActivityThread.this.queueOrSendMessage(137, token, sleeping ? 1 : 0);
        }

        @Override
        public void scheduleResumeActivity(IBinder token, boolean isForward) {
            ActivityThread.this.queueOrSendMessage(107, token, isForward ? 1 : 0);
        }

        @Override
        public void scheduleSendResult(IBinder token, List<ResultInfo> results) {
            ResultData res = new ResultData();
            res.token = token;
            res.results = results;
            ActivityThread.this.queueOrSendMessage(108, res);
        }

        @Override
        public void scheduleLaunchActivity(Intent intent, IBinder token, int ident, ActivityInfo info, Configuration curConfig, CompatibilityInfo compatInfo, Bundle state, List<ResultInfo> pendingResults, List<Intent> pendingNewIntents, boolean notResumed, boolean isForward, String profileName, ParcelFileDescriptor profileFd, boolean autoStopProfiler) {
            ActivityClientRecord r = new ActivityClientRecord();
            r.token = token;
            r.ident = ident;
            r.intent = intent;
            r.activityInfo = info;
            r.compatInfo = compatInfo;
            r.state = state;
            r.pendingResults = pendingResults;
            r.pendingIntents = pendingNewIntents;
            r.startsNotResumed = notResumed;
            r.isForward = isForward;
            r.profileFile = profileName;
            r.profileFd = profileFd;
            r.autoStopProfiler = autoStopProfiler;
            this.updatePendingConfiguration(curConfig);
            ActivityThread.this.queueOrSendMessage(100, r);
        }

        @Override
        public void scheduleRelaunchActivity(IBinder token, List<ResultInfo> pendingResults, List<Intent> pendingNewIntents, int configChanges, boolean notResumed, Configuration config) {
            ActivityThread.this.requestRelaunchActivity(token, pendingResults, pendingNewIntents, configChanges, notResumed, config, true);
        }

        @Override
        public void scheduleNewIntent(List<Intent> intents, IBinder token) {
            NewIntentData data = new NewIntentData();
            data.intents = intents;
            data.token = token;
            ActivityThread.this.queueOrSendMessage(112, data);
        }

        @Override
        public void scheduleDestroyActivity(IBinder token, boolean finishing, int configChanges) {
            ActivityThread.this.queueOrSendMessage(109, token, finishing ? 1 : 0, configChanges);
        }

        @Override
        public void scheduleReceiver(Intent intent, ActivityInfo info, CompatibilityInfo compatInfo, int resultCode, String data, Bundle extras, boolean sync) {
            ReceiverData r = new ReceiverData(intent, resultCode, data, extras, sync, false, ActivityThread.this.mAppThread.asBinder());
            r.info = info;
            r.compatInfo = compatInfo;
            ActivityThread.this.queueOrSendMessage(113, r);
        }

        @Override
        public void scheduleCreateBackupAgent(ApplicationInfo app, CompatibilityInfo compatInfo, int backupMode) {
            CreateBackupAgentData d = new CreateBackupAgentData();
            d.appInfo = app;
            d.compatInfo = compatInfo;
            d.backupMode = backupMode;
            ActivityThread.this.queueOrSendMessage(128, d);
        }

        @Override
        public void scheduleDestroyBackupAgent(ApplicationInfo app, CompatibilityInfo compatInfo) {
            CreateBackupAgentData d = new CreateBackupAgentData();
            d.appInfo = app;
            d.compatInfo = compatInfo;
            ActivityThread.this.queueOrSendMessage(129, d);
        }

        @Override
        public void scheduleCreateService(IBinder token, ServiceInfo info, CompatibilityInfo compatInfo) {
            CreateServiceData s = new CreateServiceData();
            s.token = token;
            s.info = info;
            s.compatInfo = compatInfo;
            ActivityThread.this.queueOrSendMessage(114, s);
        }

        @Override
        public void scheduleBindService(IBinder token, Intent intent, boolean rebind) {
            BindServiceData s = new BindServiceData();
            s.token = token;
            s.intent = intent;
            s.rebind = rebind;
            ActivityThread.this.queueOrSendMessage(121, s);
        }

        @Override
        public void scheduleUnbindService(IBinder token, Intent intent) {
            BindServiceData s = new BindServiceData();
            s.token = token;
            s.intent = intent;
            ActivityThread.this.queueOrSendMessage(122, s);
        }

        @Override
        public void scheduleServiceArgs(IBinder token, boolean taskRemoved, int startId, int flags, Intent args) {
            ServiceArgsData s = new ServiceArgsData();
            s.token = token;
            s.taskRemoved = taskRemoved;
            s.startId = startId;
            s.flags = flags;
            s.args = args;
            ActivityThread.this.queueOrSendMessage(115, s);
        }

        @Override
        public void scheduleStopService(IBinder token) {
            ActivityThread.this.queueOrSendMessage(116, token);
        }

        @Override
        public void bindApplication(String processName, ApplicationInfo appInfo, List<ProviderInfo> providers, ComponentName instrumentationName, String profileFile, ParcelFileDescriptor profileFd, boolean autoStopProfiler, Bundle instrumentationArgs, IInstrumentationWatcher instrumentationWatcher, int debugMode, boolean isRestrictedBackupMode, boolean persistent, Configuration config, CompatibilityInfo compatInfo, Map<String, IBinder> services, Bundle coreSettings) {
            if (services != null) {
                ServiceManager.initServiceCache(services);
            }
            this.setCoreSettings(coreSettings);
            AppBindData data = new AppBindData();
            data.processName = processName;
            data.appInfo = appInfo;
            data.providers = providers;
            data.instrumentationName = instrumentationName;
            data.instrumentationArgs = instrumentationArgs;
            data.instrumentationWatcher = instrumentationWatcher;
            data.debugMode = debugMode;
            data.restrictedBackupMode = isRestrictedBackupMode;
            data.persistent = persistent;
            data.config = config;
            data.compatInfo = compatInfo;
            data.initProfileFile = profileFile;
            data.initProfileFd = profileFd;
            data.initAutoStopProfiler = false;
            ActivityThread.this.queueOrSendMessage(110, data);
        }

        @Override
        public void scheduleExit() {
            ActivityThread.this.queueOrSendMessage(111, null);
        }

        @Override
        public void scheduleSuicide() {
            ActivityThread.this.queueOrSendMessage(130, null);
        }

        @Override
        public void requestThumbnail(IBinder token) {
            ActivityThread.this.queueOrSendMessage(117, token);
        }

        @Override
        public void scheduleConfigurationChanged(Configuration config) {
            this.updatePendingConfiguration(config);
            ActivityThread.this.queueOrSendMessage(118, config);
        }

        @Override
        public void updateTimeZone() {
            TimeZone.setDefault(null);
        }

        @Override
        public void clearDnsCache() {
            InetAddress.clearDnsCache();
        }

        @Override
        public void setHttpProxy(String host, String port, String exclList) {
            Proxy.setHttpProxySystemProperty(host, port, exclList);
        }

        @Override
        public void processInBackground() {
            ActivityThread.this.mH.removeMessages(120);
            ActivityThread.this.mH.sendMessage(ActivityThread.this.mH.obtainMessage(120));
        }

        @Override
        public void dumpService(FileDescriptor fd, IBinder servicetoken, String[] args) {
            DumpComponentInfo data = new DumpComponentInfo();
            try {
                data.fd = ParcelFileDescriptor.dup(fd);
                data.token = servicetoken;
                data.args = args;
                ActivityThread.this.queueOrSendMessage(123, data);
            }
            catch (IOException e) {
                Slog.w(ActivityThread.TAG, "dumpService failed", e);
            }
        }

        @Override
        public void scheduleRegisteredReceiver(IIntentReceiver receiver, Intent intent, int resultCode, String dataStr, Bundle extras, boolean ordered, boolean sticky) throws RemoteException {
            receiver.performReceive(intent, resultCode, dataStr, extras, ordered, sticky);
        }

        @Override
        public void scheduleLowMemory() {
            ActivityThread.this.queueOrSendMessage(124, null);
        }

        @Override
        public void scheduleActivityConfigurationChanged(IBinder token) {
            ActivityThread.this.queueOrSendMessage(125, token);
        }

        @Override
        public void profilerControl(boolean start, String path, ParcelFileDescriptor fd, int profileType) {
            ProfilerControlData pcd = new ProfilerControlData();
            pcd.path = path;
            pcd.fd = fd;
            ActivityThread.this.queueOrSendMessage(127, pcd, start ? 1 : 0, profileType);
        }

        @Override
        public void dumpHeap(boolean managed, String path, ParcelFileDescriptor fd) {
            DumpHeapData dhd = new DumpHeapData();
            dhd.path = path;
            dhd.fd = fd;
            ActivityThread.this.queueOrSendMessage(135, dhd, managed ? 1 : 0);
        }

        @Override
        public void setSchedulingGroup(int group) {
            try {
                Process.setProcessGroup(Process.myPid(), group);
            }
            catch (Exception e) {
                Slog.w(ActivityThread.TAG, "Failed setting process group to " + group, e);
            }
        }

        @Override
        public void getMemoryInfo(Debug.MemoryInfo outInfo) {
            Debug.getMemoryInfo(outInfo);
        }

        @Override
        public void dispatchPackageBroadcast(int cmd, String[] packages) {
            ActivityThread.this.queueOrSendMessage(133, packages, cmd);
        }

        @Override
        public void scheduleCrash(String msg) {
            ActivityThread.this.queueOrSendMessage(134, msg);
        }

        @Override
        public void dumpActivity(FileDescriptor fd, IBinder activitytoken, String prefix, String[] args) {
            DumpComponentInfo data = new DumpComponentInfo();
            try {
                data.fd = ParcelFileDescriptor.dup(fd);
                data.token = activitytoken;
                data.prefix = prefix;
                data.args = args;
                ActivityThread.this.queueOrSendMessage(136, data);
            }
            catch (IOException e) {
                Slog.w(ActivityThread.TAG, "dumpActivity failed", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Debug.MemoryInfo dumpMemInfo(FileDescriptor fd, boolean checkin, boolean all, String[] args) {
            FileOutputStream fout = new FileOutputStream(fd);
            PrintWriter pw = new PrintWriter(fout);
            try {
                Debug.MemoryInfo memoryInfo = this.dumpMemInfo(pw, checkin, all, args);
                return memoryInfo;
            }
            finally {
                pw.flush();
            }
        }

        private Debug.MemoryInfo dumpMemInfo(PrintWriter pw, boolean checkin, boolean all, String[] args) {
            String assetAlloc;
            long nativeMax = Debug.getNativeHeapSize() / 1024L;
            long nativeAllocated = Debug.getNativeHeapAllocatedSize() / 1024L;
            long nativeFree = Debug.getNativeHeapFreeSize() / 1024L;
            Debug.MemoryInfo memInfo = new Debug.MemoryInfo();
            Debug.getMemoryInfo(memInfo);
            if (!all) {
                return memInfo;
            }
            Runtime runtime = Runtime.getRuntime();
            long dalvikMax = runtime.totalMemory() / 1024L;
            long dalvikFree = runtime.freeMemory() / 1024L;
            long dalvikAllocated = dalvikMax - dalvikFree;
            long viewInstanceCount = ViewDebug.getViewInstanceCount();
            long viewRootInstanceCount = ViewDebug.getViewRootImplCount();
            long appContextInstanceCount = Debug.countInstancesOfClass(ContextImpl.class);
            long activityInstanceCount = Debug.countInstancesOfClass(Activity.class);
            int globalAssetCount = AssetManager.getGlobalAssetCount();
            int globalAssetManagerCount = AssetManager.getGlobalAssetManagerCount();
            int binderLocalObjectCount = Debug.getBinderLocalObjectCount();
            int binderProxyObjectCount = Debug.getBinderProxyObjectCount();
            int binderDeathObjectCount = Debug.getBinderDeathObjectCount();
            long openSslSocketCount = Debug.countInstancesOfClass(OpenSSLSocketImpl.class);
            long sqliteAllocated = SQLiteDebug.getHeapAllocatedSize() / 1024L;
            SQLiteDebug.PagerStats stats = SQLiteDebug.getDatabaseInfo();
            if (checkin) {
                String processName = ActivityThread.this.mBoundApplication != null ? ActivityThread.this.mBoundApplication.processName : "unknown";
                pw.print(1);
                pw.print(',');
                pw.print(Process.myPid());
                pw.print(',');
                pw.print(processName);
                pw.print(',');
                pw.print(nativeMax);
                pw.print(',');
                pw.print(dalvikMax);
                pw.print(',');
                pw.print("N/A,");
                pw.print(nativeMax + dalvikMax);
                pw.print(',');
                pw.print(nativeAllocated);
                pw.print(',');
                pw.print(dalvikAllocated);
                pw.print(',');
                pw.print("N/A,");
                pw.print(nativeAllocated + dalvikAllocated);
                pw.print(',');
                pw.print(nativeFree);
                pw.print(',');
                pw.print(dalvikFree);
                pw.print(',');
                pw.print("N/A,");
                pw.print(nativeFree + dalvikFree);
                pw.print(',');
                pw.print(memInfo.nativePss);
                pw.print(',');
                pw.print(memInfo.dalvikPss);
                pw.print(',');
                pw.print(memInfo.otherPss);
                pw.print(',');
                pw.print(memInfo.nativePss + memInfo.dalvikPss + memInfo.otherPss);
                pw.print(',');
                pw.print(memInfo.nativeSharedDirty);
                pw.print(',');
                pw.print(memInfo.dalvikSharedDirty);
                pw.print(',');
                pw.print(memInfo.otherSharedDirty);
                pw.print(',');
                pw.print(memInfo.nativeSharedDirty + memInfo.dalvikSharedDirty + memInfo.otherSharedDirty);
                pw.print(',');
                pw.print(memInfo.nativePrivateDirty);
                pw.print(',');
                pw.print(memInfo.dalvikPrivateDirty);
                pw.print(',');
                pw.print(memInfo.otherPrivateDirty);
                pw.print(',');
                pw.print(memInfo.nativePrivateDirty + memInfo.dalvikPrivateDirty + memInfo.otherPrivateDirty);
                pw.print(',');
                pw.print(viewInstanceCount);
                pw.print(',');
                pw.print(viewRootInstanceCount);
                pw.print(',');
                pw.print(appContextInstanceCount);
                pw.print(',');
                pw.print(activityInstanceCount);
                pw.print(',');
                pw.print(globalAssetCount);
                pw.print(',');
                pw.print(globalAssetManagerCount);
                pw.print(',');
                pw.print(binderLocalObjectCount);
                pw.print(',');
                pw.print(binderProxyObjectCount);
                pw.print(',');
                pw.print(binderDeathObjectCount);
                pw.print(',');
                pw.print(openSslSocketCount);
                pw.print(',');
                pw.print(sqliteAllocated);
                pw.print(',');
                pw.print(stats.memoryUsed / 1024);
                pw.print(',');
                pw.print(stats.pageCacheOverflo / 1024);
                pw.print(',');
                pw.print(stats.largestMemAlloc / 1024);
                for (int i = 0; i < stats.dbStats.size(); ++i) {
                    SQLiteDebug.DbStats dbStats = stats.dbStats.get(i);
                    pw.print(',');
                    pw.print(dbStats.dbName);
                    pw.print(',');
                    pw.print(dbStats.pageSize);
                    pw.print(',');
                    pw.print(dbStats.dbSize);
                    pw.print(',');
                    pw.print(dbStats.lookaside);
                    pw.print(',');
                    pw.print(dbStats.cache);
                    pw.print(',');
                    pw.print(dbStats.cache);
                }
                pw.println();
                return memInfo;
            }
            this.printRow(pw, HEAP_COLUMN, "", "", "Shared", "Private", "Heap", "Heap", "Heap");
            this.printRow(pw, HEAP_COLUMN, "", "Pss", "Dirty", "Dirty", "Size", "Alloc", "Free");
            this.printRow(pw, HEAP_COLUMN, "", "------", "------", "------", "------", "------", "------");
            this.printRow(pw, HEAP_COLUMN, "Native", memInfo.nativePss, memInfo.nativeSharedDirty, memInfo.nativePrivateDirty, nativeMax, nativeAllocated, nativeFree);
            this.printRow(pw, HEAP_COLUMN, "Dalvik", memInfo.dalvikPss, memInfo.dalvikSharedDirty, memInfo.dalvikPrivateDirty, dalvikMax, dalvikAllocated, dalvikFree);
            int otherPss = memInfo.otherPss;
            int otherSharedDirty = memInfo.otherSharedDirty;
            int otherPrivateDirty = memInfo.otherPrivateDirty;
            for (int i = 0; i < 9; ++i) {
                this.printRow(pw, HEAP_COLUMN, Debug.MemoryInfo.getOtherLabel(i), memInfo.getOtherPss(i), memInfo.getOtherSharedDirty(i), memInfo.getOtherPrivateDirty(i), "", "", "");
                otherPss -= memInfo.getOtherPss(i);
                otherSharedDirty -= memInfo.getOtherSharedDirty(i);
                otherPrivateDirty -= memInfo.getOtherPrivateDirty(i);
            }
            this.printRow(pw, HEAP_COLUMN, "Unknown", otherPss, otherSharedDirty, otherPrivateDirty, "", "", "");
            this.printRow(pw, HEAP_COLUMN, "TOTAL", memInfo.getTotalPss(), memInfo.getTotalSharedDirty(), memInfo.getTotalPrivateDirty(), nativeMax + dalvikMax, nativeAllocated + dalvikAllocated, nativeFree + dalvikFree);
            pw.println(" ");
            pw.println(" Objects");
            this.printRow(pw, "%21s %8d %21s %8d", "Views:", viewInstanceCount, "ViewRootImpl:", viewRootInstanceCount);
            this.printRow(pw, "%21s %8d %21s %8d", "AppContexts:", appContextInstanceCount, "Activities:", activityInstanceCount);
            this.printRow(pw, "%21s %8d %21s %8d", "Assets:", globalAssetCount, "AssetManagers:", globalAssetManagerCount);
            this.printRow(pw, "%21s %8d %21s %8d", "Local Binders:", binderLocalObjectCount, "Proxy Binders:", binderProxyObjectCount);
            this.printRow(pw, ONE_COUNT_COLUMN, "Death Recipients:", binderDeathObjectCount);
            this.printRow(pw, ONE_COUNT_COLUMN, "OpenSSL Sockets:", openSslSocketCount);
            pw.println(" ");
            pw.println(" SQL");
            this.printRow(pw, "%21s %8d %21s %8d", "heap:", sqliteAllocated, "MEMORY_USED:", stats.memoryUsed / 1024);
            this.printRow(pw, "%21s %8d %21s %8d", "PAGECACHE_OVERFLOW:", stats.pageCacheOverflo / 1024, "MALLOC_SIZE:", stats.largestMemAlloc / 1024);
            pw.println(" ");
            int N = stats.dbStats.size();
            if (N > 0) {
                pw.println(" DATABASES");
                this.printRow(pw, DB_INFO_FORMAT, "pgsz", "dbsz", "Lookaside(b)", "cache", "Dbname");
                for (int i = 0; i < N; ++i) {
                    SQLiteDebug.DbStats dbStats = stats.dbStats.get(i);
                    this.printRow(pw, DB_INFO_FORMAT, dbStats.pageSize > 0L ? String.valueOf(dbStats.pageSize) : " ", dbStats.dbSize > 0L ? String.valueOf(dbStats.dbSize) : " ", dbStats.lookaside > 0 ? String.valueOf(dbStats.lookaside) : " ", dbStats.cache, dbStats.dbName);
                }
            }
            if ((assetAlloc = AssetManager.getAssetAllocations()) != null) {
                pw.println(" ");
                pw.println(" Asset Allocations");
                pw.print(assetAlloc);
            }
            return memInfo;
        }

        @Override
        public void dumpGfxInfo(FileDescriptor fd, String[] args) {
            ActivityThread.this.dumpGraphicsInfo(fd);
            WindowManagerImpl.getDefault().dumpGfxInfo(fd);
        }

        private void printRow(PrintWriter pw, String format, Object ... objs) {
            pw.println(String.format(format, objs));
        }

        @Override
        public void setCoreSettings(Bundle coreSettings) {
            ActivityThread.this.queueOrSendMessage(138, coreSettings);
        }

        @Override
        public void updatePackageCompatibilityInfo(String pkg, CompatibilityInfo info) {
            UpdateCompatibilityData ucd = new UpdateCompatibilityData();
            ucd.pkg = pkg;
            ucd.info = info;
            ActivityThread.this.queueOrSendMessage(139, ucd);
        }

        @Override
        public void scheduleTrimMemory(int level) {
            ActivityThread.this.queueOrSendMessage(140, null, level);
        }
    }

    static class UpdateCompatibilityData {
        String pkg;
        CompatibilityInfo info;

        UpdateCompatibilityData() {
        }
    }

    static class DumpHeapData {
        String path;
        ParcelFileDescriptor fd;

        DumpHeapData() {
        }
    }

    static class ProfilerControlData {
        String path;
        ParcelFileDescriptor fd;

        ProfilerControlData() {
        }
    }

    static class ContextCleanupInfo {
        ContextImpl context;
        String what;
        String who;

        ContextCleanupInfo() {
        }
    }

    static class ResultData {
        IBinder token;
        List<ResultInfo> results;

        ResultData() {
        }

        public String toString() {
            return "ResultData{token=" + this.token + " results" + this.results + "}";
        }
    }

    static class DumpComponentInfo {
        ParcelFileDescriptor fd;
        IBinder token;
        String prefix;
        String[] args;

        DumpComponentInfo() {
        }
    }

    static class Profiler {
        String profileFile;
        ParcelFileDescriptor profileFd;
        boolean autoStopProfiler;
        boolean profiling;
        boolean handlingProfiling;

        Profiler() {
        }

        public void setProfiler(String file, ParcelFileDescriptor fd) {
            if (this.profiling) {
                if (fd != null) {
                    try {
                        fd.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return;
            }
            if (this.profileFd != null) {
                try {
                    this.profileFd.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.profileFile = file;
            this.profileFd = fd;
        }

        public void startProfiling() {
            if (this.profileFd == null || this.profiling) {
                return;
            }
            try {
                Debug.startMethodTracing(this.profileFile, this.profileFd.getFileDescriptor(), 0x800000, 0);
                this.profiling = true;
            }
            catch (RuntimeException e) {
                Slog.w(ActivityThread.TAG, "Profiling failed on path " + this.profileFile);
                try {
                    this.profileFd.close();
                    this.profileFd = null;
                }
                catch (IOException e2) {
                    Slog.w(ActivityThread.TAG, "Failure closing profile fd", e2);
                }
            }
        }

        public void stopProfiling() {
            if (this.profiling) {
                this.profiling = false;
                Debug.stopMethodTracing();
                if (this.profileFd != null) {
                    try {
                        this.profileFd.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.profileFd = null;
                this.profileFile = null;
            }
        }
    }

    static class AppBindData {
        LoadedApk info;
        String processName;
        ApplicationInfo appInfo;
        List<ProviderInfo> providers;
        ComponentName instrumentationName;
        Bundle instrumentationArgs;
        IInstrumentationWatcher instrumentationWatcher;
        int debugMode;
        boolean restrictedBackupMode;
        boolean persistent;
        Configuration config;
        CompatibilityInfo compatInfo;
        String initProfileFile;
        ParcelFileDescriptor initProfileFd;
        boolean initAutoStopProfiler;

        AppBindData() {
        }

        public String toString() {
            return "AppBindData{appInfo=" + this.appInfo + "}";
        }
    }

    static class ServiceArgsData {
        IBinder token;
        boolean taskRemoved;
        int startId;
        int flags;
        Intent args;

        ServiceArgsData() {
        }

        public String toString() {
            return "ServiceArgsData{token=" + this.token + " startId=" + this.startId + " args=" + this.args + "}";
        }
    }

    static class BindServiceData {
        IBinder token;
        Intent intent;
        boolean rebind;

        BindServiceData() {
        }

        public String toString() {
            return "BindServiceData{token=" + this.token + " intent=" + this.intent + "}";
        }
    }

    static class CreateServiceData {
        IBinder token;
        ServiceInfo info;
        CompatibilityInfo compatInfo;
        Intent intent;

        CreateServiceData() {
        }

        public String toString() {
            return "CreateServiceData{token=" + this.token + " className=" + this.info.name + " packageName=" + this.info.packageName + " intent=" + this.intent + "}";
        }
    }

    static class CreateBackupAgentData {
        ApplicationInfo appInfo;
        CompatibilityInfo compatInfo;
        int backupMode;

        CreateBackupAgentData() {
        }

        public String toString() {
            return "CreateBackupAgentData{appInfo=" + this.appInfo + " backupAgent=" + this.appInfo.backupAgentName + " mode=" + this.backupMode + "}";
        }
    }

    static class ReceiverData
    extends BroadcastReceiver.PendingResult {
        Intent intent;
        ActivityInfo info;
        CompatibilityInfo compatInfo;

        public ReceiverData(Intent intent, int resultCode, String resultData, Bundle resultExtras, boolean ordered, boolean sticky, IBinder token) {
            super(resultCode, resultData, resultExtras, 0, ordered, sticky, token);
            this.intent = intent;
        }

        public String toString() {
            return "ReceiverData{intent=" + this.intent + " packageName=" + this.info.packageName + " resultCode=" + this.getResultCode() + " resultData=" + this.getResultData() + " resultExtras=" + this.getResultExtras(false) + "}";
        }
    }

    static class NewIntentData {
        List<Intent> intents;
        IBinder token;

        NewIntentData() {
        }

        public String toString() {
            return "NewIntentData{intents=" + this.intents + " token=" + this.token + "}";
        }
    }

    class ProviderClientRecord
    implements IBinder.DeathRecipient {
        final String mName;
        final IContentProvider mProvider;
        final ContentProvider mLocalProvider;

        ProviderClientRecord(String name, IContentProvider provider, ContentProvider localProvider) {
            this.mName = name;
            this.mProvider = provider;
            this.mLocalProvider = localProvider;
        }

        public void binderDied() {
            ActivityThread.this.removeDeadProvider(this.mName, this.mProvider);
        }
    }

    static class ActivityClientRecord {
        IBinder token;
        int ident;
        Intent intent;
        Bundle state;
        Activity activity;
        Window window;
        Activity parent = null;
        String embeddedID = null;
        Activity.NonConfigurationInstances lastNonConfigurationInstances;
        boolean paused = false;
        boolean stopped = false;
        boolean hideForNow = false;
        Configuration newConfig;
        Configuration createdConfig;
        ActivityClientRecord nextIdle = null;
        String profileFile;
        ParcelFileDescriptor profileFd;
        boolean autoStopProfiler;
        ActivityInfo activityInfo;
        CompatibilityInfo compatInfo;
        LoadedApk packageInfo;
        List<ResultInfo> pendingResults;
        List<Intent> pendingIntents;
        boolean startsNotResumed;
        boolean isForward;
        int pendingConfigChanges;
        boolean onlyLocalRequest;
        View mPendingRemoveWindow;
        WindowManager mPendingRemoveWindowManager;

        ActivityClientRecord() {
        }

        public boolean isPreHoneycomb() {
            if (this.activity != null) {
                return this.activity.getApplicationInfo().targetSdkVersion < 11;
            }
            return false;
        }

        public String toString() {
            ComponentName componentName = this.intent.getComponent();
            return "ActivityRecord{" + Integer.toHexString(System.identityHashCode(this)) + " token=" + this.token + " " + (componentName == null ? "no component name" : componentName.toShortString()) + "}";
        }
    }
}

