/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.pm.ActivityInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources_Theme_Delegate;
import android.content.res.TypedArray;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.graphics.Movie;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Locale;
import libcore.icu.NativePluralRules;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources {
    static final String TAG = "Resources";
    private static final boolean DEBUG_LOAD = false;
    private static final boolean DEBUG_CONFIG = false;
    private static final boolean DEBUG_ATTRIBUTES_CACHE = false;
    private static final boolean TRACE_FOR_PRELOAD = false;
    private static final boolean TRACE_FOR_MISS_PRELOAD = false;
    private static final int ID_OTHER = 0x1000004;
    private static final Object mSync = new Object();
    static Resources mSystem = null;
    private static final LongSparseArray<Drawable.ConstantState> sPreloadedDrawables = new LongSparseArray();
    private static final SparseArray<ColorStateList> mPreloadedColorStateLists = new SparseArray();
    private static final LongSparseArray<Drawable.ConstantState> sPreloadedColorDrawables = new LongSparseArray();
    private static boolean mPreloaded;
    final TypedValue mTmpValue = new TypedValue();
    final Configuration mTmpConfig = new Configuration();
    private final LongSparseArray<WeakReference<Drawable.ConstantState>> mDrawableCache = new LongSparseArray();
    private final SparseArray<WeakReference<ColorStateList>> mColorStateListCache = new SparseArray();
    private final LongSparseArray<WeakReference<Drawable.ConstantState>> mColorDrawableCache = new LongSparseArray();
    private boolean mPreloading;
    TypedArray mCachedStyledAttributes = null;
    RuntimeException mLastRetrievedAttrs = null;
    private int mLastCachedXmlBlockIndex = -1;
    private final int[] mCachedXmlBlockIds = new int[]{0, 0, 0, 0};
    private final XmlBlock[] mCachedXmlBlocks = new XmlBlock[4];
    final AssetManager mAssets;
    private final Configuration mConfiguration = new Configuration();
    final DisplayMetrics mMetrics = new DisplayMetrics();
    private NativePluralRules mPluralRule;
    private CompatibilityInfo mCompatibilityInfo;
    private static final LongSparseArray<Object> EMPTY_ARRAY;

    private static <T> LongSparseArray<T> emptySparseArray() {
        return EMPTY_ARRAY;
    }

    public static int selectDefaultTheme(int curTheme, int targetSdkVersion) {
        return Resources.selectSystemTheme(curTheme, targetSdkVersion, 16973829, 16973931, 16974120);
    }

    public static int selectSystemTheme(int curTheme, int targetSdkVersion, int orig, int holo, int deviceDefault) {
        if (curTheme != 0) {
            return curTheme;
        }
        if (targetSdkVersion < 11) {
            return orig;
        }
        if (targetSdkVersion < 14) {
            return holo;
        }
        return deviceDefault;
    }

    public Resources(AssetManager assets, DisplayMetrics metrics, Configuration config) {
        this(assets, metrics, config, null);
    }

    public Resources(AssetManager assets, DisplayMetrics metrics, Configuration config, CompatibilityInfo compInfo) {
        this.mAssets = assets;
        this.mMetrics.setToDefaults();
        this.mCompatibilityInfo = compInfo;
        this.updateConfiguration(config, metrics);
        assets.ensureStringBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resources getSystem() {
        Object object = mSync;
        synchronized (object) {
            Resources ret = mSystem;
            if (ret == null) {
                mSystem = ret = new Resources();
            }
            return ret;
        }
    }

    public CharSequence getText(int id2) throws NotFoundException {
        CharSequence res = this.mAssets.getResourceText(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String resource ID #0x" + Integer.toHexString(id2));
    }

    public CharSequence getQuantityText(int id2, int quantity) throws NotFoundException {
        NativePluralRules rule = this.getPluralRule();
        CharSequence res = this.mAssets.getResourceBagText(id2, Resources.attrForQuantityCode(rule.quantityForInt(quantity)));
        if (res != null) {
            return res;
        }
        res = this.mAssets.getResourceBagText(id2, 0x1000004);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Plural resource ID #0x" + Integer.toHexString(id2) + " quantity=" + quantity + " item=" + Resources.stringForQuantityCode(rule.quantityForInt(quantity)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativePluralRules getPluralRule() {
        Object object = mSync;
        synchronized (object) {
            if (this.mPluralRule == null) {
                this.mPluralRule = NativePluralRules.forLocale(this.mConfiguration.locale);
            }
            return this.mPluralRule;
        }
    }

    private static int attrForQuantityCode(int quantityCode) {
        switch (quantityCode) {
            case 0: {
                return 0x1000005;
            }
            case 1: {
                return 0x1000006;
            }
            case 2: {
                return 0x1000007;
            }
            case 3: {
                return 0x1000008;
            }
            case 4: {
                return 0x1000009;
            }
        }
        return 0x1000004;
    }

    private static String stringForQuantityCode(int quantityCode) {
        switch (quantityCode) {
            case 0: {
                return "zero";
            }
            case 1: {
                return "one";
            }
            case 2: {
                return "two";
            }
            case 3: {
                return "few";
            }
            case 4: {
                return "many";
            }
        }
        return "other";
    }

    public String getString(int id2) throws NotFoundException {
        CharSequence res = this.getText(id2);
        if (res != null) {
            return ((Object)res).toString();
        }
        throw new NotFoundException("String resource ID #0x" + Integer.toHexString(id2));
    }

    public String getString(int id2, Object ... formatArgs) throws NotFoundException {
        String raw2 = this.getString(id2);
        return String.format(this.mConfiguration.locale, raw2, formatArgs);
    }

    public String getQuantityString(int id2, int quantity, Object ... formatArgs) throws NotFoundException {
        String raw2 = ((Object)this.getQuantityText(id2, quantity)).toString();
        return String.format(this.mConfiguration.locale, raw2, formatArgs);
    }

    public String getQuantityString(int id2, int quantity) throws NotFoundException {
        return ((Object)this.getQuantityText(id2, quantity)).toString();
    }

    public CharSequence getText(int id2, CharSequence def) {
        CharSequence res = id2 != 0 ? this.mAssets.getResourceText(id2) : null;
        return res != null ? res : def;
    }

    public CharSequence[] getTextArray(int id2) throws NotFoundException {
        CharSequence[] res = this.mAssets.getResourceTextArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Text array resource ID #0x" + Integer.toHexString(id2));
    }

    public String[] getStringArray(int id2) throws NotFoundException {
        String[] res = this.mAssets.getResourceStringArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String array resource ID #0x" + Integer.toHexString(id2));
    }

    public int[] getIntArray(int id2) throws NotFoundException {
        int[] res = this.mAssets.getArrayIntResource(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Int array resource ID #0x" + Integer.toHexString(id2));
    }

    public TypedArray obtainTypedArray(int id2) throws NotFoundException {
        int len = this.mAssets.getArraySize(id2);
        if (len < 0) {
            throw new NotFoundException("Array resource ID #0x" + Integer.toHexString(id2));
        }
        TypedArray array2 = this.getCachedStyledAttributes(len);
        array2.mLength = this.mAssets.retrieveArray(id2, array2.mData);
        array2.mIndices[0] = 0;
        return array2;
    }

    public float getDimension(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type == 5) {
                return TypedValue.complexToDimension(value.data, this.mMetrics);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    public int getDimensionPixelOffset(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type == 5) {
                return TypedValue.complexToDimensionPixelOffset(value.data, this.mMetrics);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    public int getDimensionPixelSize(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type == 5) {
                return TypedValue.complexToDimensionPixelSize(value.data, this.mMetrics);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    public float getFraction(int id2, int base, int pbase) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type == 6) {
                return TypedValue.complexToFraction(value.data, base, pbase);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawable(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            return this.loadDrawable(value, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawableForDensity(int id2, int density) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValueForDensity(id2, density, value, true);
            if (value.density > 0 && value.density != 65535) {
                value.density = value.density == density ? DisplayMetrics.DENSITY_DEVICE : value.density * DisplayMetrics.DENSITY_DEVICE / density;
            }
            return this.loadDrawable(value, id2);
        }
    }

    public Movie getMovie(int id2) throws NotFoundException {
        InputStream is = this.openRawResource(id2);
        Movie movie = Movie.decodeStream(is);
        try {
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return movie;
    }

    public int getColor(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                return value.data;
            }
            if (value.type == 3) {
                ColorStateList csl = this.loadColorStateList(this.mTmpValue, id2);
                return csl.getDefaultColor();
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorStateList getColorStateList(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            return this.loadColorStateList(value, id2);
        }
    }

    public boolean getBoolean(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                return value.data != 0;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    public int getInteger(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                return value.data;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    public XmlResourceParser getLayout(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "layout");
    }

    public XmlResourceParser getAnimation(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "anim");
    }

    public XmlResourceParser getXml(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openRawResource(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            return this.openRawResource(id2, this.mTmpValue);
        }
    }

    public InputStream openRawResource(int id2, TypedValue value) throws NotFoundException {
        this.getValue(id2, value, true);
        try {
            return this.mAssets.openNonAsset(value.assetCookie, ((Object)value.string).toString(), 2);
        }
        catch (Exception e) {
            NotFoundException rnf = new NotFoundException("File " + ((Object)value.string).toString() + " from drawable resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(e);
            throw rnf;
        }
    }

    public AssetFileDescriptor openRawResourceFd(int id2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            try {
                return this.mAssets.openNonAssetFd(value.assetCookie, ((Object)value.string).toString());
            }
            catch (Exception e) {
                NotFoundException rnf = new NotFoundException("File " + ((Object)value.string).toString() + " from drawable resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        }
    }

    public void getValue(int id2, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        boolean found = this.mAssets.getResourceValue(id2, 0, outValue, resolveRefs);
        if (found) {
            return;
        }
        throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2));
    }

    public void getValueForDensity(int id2, int density, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        boolean found = this.mAssets.getResourceValue(id2, density, outValue, resolveRefs);
        if (found) {
            return;
        }
        throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2));
    }

    public void getValue(String name, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        int id2 = this.getIdentifier(name, "string", null);
        if (id2 != 0) {
            this.getValue(id2, outValue, resolveRefs);
            return;
        }
        throw new NotFoundException("String resource name " + name);
    }

    public Theme newTheme() {
        return new Theme();
    }

    public TypedArray obtainAttributes(AttributeSet set, int[] attrs) {
        int len = attrs.length;
        TypedArray array2 = this.getCachedStyledAttributes(len);
        XmlBlock.Parser parser = (XmlBlock.Parser)set;
        this.mAssets.retrieveAttributes(parser.mParseState, attrs, array2.mData, array2.mIndices);
        array2.mRsrcs = attrs;
        array2.mXml = parser;
        return array2;
    }

    public void updateConfiguration(Configuration config, DisplayMetrics metrics) {
        this.updateConfiguration(config, metrics, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        Object object = this.mTmpValue;
        synchronized (object) {
            int height;
            int width;
            if (compat != null) {
                this.mCompatibilityInfo = compat;
            }
            if (metrics != null) {
                this.mMetrics.setTo(metrics);
            }
            if (this.mCompatibilityInfo != null) {
                this.mCompatibilityInfo.applyToDisplayMetrics(this.mMetrics);
            }
            int configChanges = 0xFFFFFFF;
            if (config != null) {
                this.mTmpConfig.setTo(config);
                if (this.mCompatibilityInfo != null) {
                    this.mCompatibilityInfo.applyToConfiguration(this.mTmpConfig);
                }
                if (this.mTmpConfig.locale == null) {
                    this.mTmpConfig.locale = Locale.getDefault();
                }
                configChanges = this.mConfiguration.updateFrom(this.mTmpConfig);
                configChanges = ActivityInfo.activityInfoConfigToNative(configChanges);
            }
            if (this.mConfiguration.locale == null) {
                this.mConfiguration.locale = Locale.getDefault();
            }
            this.mMetrics.scaledDensity = this.mMetrics.density * this.mConfiguration.fontScale;
            String locale = null;
            if (this.mConfiguration.locale != null) {
                locale = this.mConfiguration.locale.getLanguage();
                if (this.mConfiguration.locale.getCountry() != null) {
                    locale = locale + "-" + this.mConfiguration.locale.getCountry();
                }
            }
            if (this.mMetrics.widthPixels >= this.mMetrics.heightPixels) {
                width = this.mMetrics.widthPixels;
                height = this.mMetrics.heightPixels;
            } else {
                width = this.mMetrics.heightPixels;
                height = this.mMetrics.widthPixels;
            }
            int keyboardHidden = this.mConfiguration.keyboardHidden;
            if (keyboardHidden == 1 && this.mConfiguration.hardKeyboardHidden == 2) {
                keyboardHidden = 3;
            }
            this.mAssets.setConfiguration(this.mConfiguration.mcc, this.mConfiguration.mnc, locale, this.mConfiguration.orientation, this.mConfiguration.touchscreen, (int)(this.mMetrics.density * 160.0f), this.mConfiguration.keyboard, keyboardHidden, this.mConfiguration.navigation, width, height, this.mConfiguration.smallestScreenWidthDp, this.mConfiguration.screenWidthDp, this.mConfiguration.screenHeightDp, this.mConfiguration.screenLayout, this.mConfiguration.uiMode, Build.VERSION.RESOURCES_SDK_INT);
            this.clearDrawableCache(this.mDrawableCache, configChanges);
            this.clearDrawableCache(this.mColorDrawableCache, configChanges);
            this.mColorStateListCache.clear();
            this.flushLayoutCache();
        }
        object = mSync;
        synchronized (object) {
            if (this.mPluralRule != null) {
                this.mPluralRule = NativePluralRules.forLocale(config.locale);
            }
        }
    }

    private void clearDrawableCache(LongSparseArray<WeakReference<Drawable.ConstantState>> cache, int configChanges) {
        int N = cache.size();
        for (int i = 0; i < N; ++i) {
            Drawable.ConstantState cs;
            WeakReference<Drawable.ConstantState> ref = cache.valueAt(i);
            if (ref == null || (cs = (Drawable.ConstantState)ref.get()) == null || !Configuration.needNewResources(configChanges, cs.getChangingConfigurations())) continue;
            cache.setValueAt(i, null);
        }
    }

    public static void updateSystemConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        if (mSystem != null) {
            mSystem.updateConfiguration(config, metrics, compat);
        }
    }

    public static void updateSystemConfiguration(Configuration config, DisplayMetrics metrics) {
        Resources.updateSystemConfiguration(config, metrics, null);
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mMetrics;
    }

    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public CompatibilityInfo getCompatibilityInfo() {
        return this.mCompatibilityInfo != null ? this.mCompatibilityInfo : CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
    }

    public void setCompatibilityInfo(CompatibilityInfo ci) {
        this.mCompatibilityInfo = ci;
        this.updateConfiguration(this.mConfiguration, this.mMetrics);
    }

    public int getIdentifier(String name, String defType, String defPackage) {
        try {
            return Integer.parseInt(name);
        }
        catch (Exception e) {
            return this.mAssets.getResourceIdentifier(name, defType, defPackage);
        }
    }

    public String getResourceName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourceName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    public String getResourcePackageName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourcePackageName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    public String getResourceTypeName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourceTypeName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    public String getResourceEntryName(int resid) throws NotFoundException {
        String str = this.mAssets.getResourceEntryName(resid);
        if (str != null) {
            return str;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(resid));
    }

    public void parseBundleExtras(XmlResourceParser parser, Bundle outBundle) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("extra")) {
                this.parseBundleExtra("extra", parser, outBundle);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseBundleExtra(String tagName, AttributeSet attrs, Bundle outBundle) throws XmlPullParserException {
        TypedArray sa = this.obtainAttributes(attrs, R.styleable.Extra);
        String name = sa.getString(0);
        if (name == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:name attribute at " + attrs.getPositionDescription());
        }
        TypedValue v = sa.peekValue(1);
        if (v == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:value or android:resource attribute at " + attrs.getPositionDescription());
        }
        if (v.type == 3) {
            CharSequence cs = v.coerceToString();
            outBundle.putCharSequence(name, cs);
        } else if (v.type == 18) {
            outBundle.putBoolean(name, v.data != 0);
        } else if (v.type >= 16 && v.type <= 31) {
            outBundle.putInt(name, v.data);
        } else {
            if (v.type != 4) {
                sa.recycle();
                throw new XmlPullParserException("<" + tagName + "> only supports string, integer, float, color, and boolean at " + attrs.getPositionDescription());
            }
            outBundle.putFloat(name, v.getFloat());
        }
        sa.recycle();
    }

    public AssetManager getAssets() {
        return this.mAssets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLayoutCache() {
        int[] nArray = this.mCachedXmlBlockIds;
        synchronized (this.mCachedXmlBlockIds) {
            int num = this.mCachedXmlBlockIds.length;
            for (int i = 0; i < num; ++i) {
                this.mCachedXmlBlockIds[i] = 0;
                XmlBlock oldBlock = this.mCachedXmlBlocks[i];
                if (oldBlock != null) {
                    oldBlock.close();
                }
                this.mCachedXmlBlocks[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPreloading() {
        Object object = mSync;
        synchronized (object) {
            if (mPreloaded) {
                throw new IllegalStateException("Resources already preloaded");
            }
            mPreloaded = true;
            this.mPreloading = true;
        }
    }

    public void finishPreloading() {
        if (this.mPreloading) {
            this.mPreloading = false;
            this.flushLayoutCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Drawable loadDrawable(TypedValue value, int id2) throws NotFoundException {
        Drawable.ConstantState cs;
        Drawable dr;
        long key = (long)value.assetCookie << 32 | (long)value.data;
        boolean isColorDrawable = false;
        if (value.type >= 28 && value.type <= 31) {
            isColorDrawable = true;
        }
        if ((dr = this.getCachedDrawable(isColorDrawable ? this.mColorDrawableCache : this.mDrawableCache, key)) != null) {
            return dr;
        }
        Drawable.ConstantState constantState = cs = isColorDrawable ? sPreloadedColorDrawables.get(key) : sPreloadedDrawables.get(key);
        if (cs != null) {
            dr = cs.newDrawable(this);
        } else {
            if (value.type >= 28 && value.type <= 31) {
                dr = new ColorDrawable(value.data);
            }
            if (dr == null) {
                if (value.string == null) {
                    throw new NotFoundException("Resource is not a Drawable (color or path): " + value);
                }
                String file = ((Object)value.string).toString();
                if (file.endsWith(".xml")) {
                    try {
                        XmlResourceParser rp = this.loadXmlResourceParser(file, id2, value.assetCookie, "drawable");
                        dr = Drawable.createFromXml(this, rp);
                        rp.close();
                    }
                    catch (Exception e) {
                        NotFoundException rnf = new NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2));
                        rnf.initCause(e);
                        throw rnf;
                    }
                }
                try {
                    InputStream is = this.mAssets.openNonAsset(value.assetCookie, file, 2);
                    dr = Drawable.createFromResourceStream(this, value, is, file, null);
                    is.close();
                }
                catch (Exception e) {
                    NotFoundException rnf = new NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2));
                    rnf.initCause(e);
                    throw rnf;
                }
            }
        }
        if (dr != null) {
            dr.setChangingConfigurations(value.changingConfigurations);
            cs = dr.getConstantState();
            if (cs != null) {
                if (this.mPreloading) {
                    if (isColorDrawable) {
                        sPreloadedColorDrawables.put(key, cs);
                    } else {
                        sPreloadedDrawables.put(key, cs);
                    }
                } else {
                    TypedValue typedValue = this.mTmpValue;
                    synchronized (typedValue) {
                        if (isColorDrawable) {
                            this.mColorDrawableCache.put(key, new WeakReference<Drawable.ConstantState>(cs));
                        } else {
                            this.mDrawableCache.put(key, new WeakReference<Drawable.ConstantState>(cs));
                        }
                    }
                }
            }
        }
        return dr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable getCachedDrawable(LongSparseArray<WeakReference<Drawable.ConstantState>> drawableCache, long key) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            WeakReference<Drawable.ConstantState> wr = drawableCache.get(key);
            if (wr != null) {
                Drawable.ConstantState entry = (Drawable.ConstantState)wr.get();
                if (entry != null) {
                    return entry.newDrawable(this);
                }
                drawableCache.delete(key);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ColorStateList loadColorStateList(TypedValue value, int id2) throws NotFoundException {
        int key = value.assetCookie << 24 | value.data;
        if (value.type >= 28 && value.type <= 31) {
            ColorStateList csl = mPreloadedColorStateLists.get(key);
            if (csl != null) {
                return csl;
            }
            csl = ColorStateList.valueOf(value.data);
            if (this.mPreloading) {
                mPreloadedColorStateLists.put(key, csl);
            }
            return csl;
        }
        ColorStateList csl = this.getCachedColorStateList(key);
        if (csl != null) {
            return csl;
        }
        csl = mPreloadedColorStateLists.get(key);
        if (csl != null) {
            return csl;
        }
        if (value.string == null) {
            throw new NotFoundException("Resource is not a ColorStateList (color or path): " + value);
        }
        String file = ((Object)value.string).toString();
        if (file.endsWith(".xml")) {
            try {
                XmlResourceParser rp = this.loadXmlResourceParser(file, id2, value.assetCookie, "colorstatelist");
                csl = ColorStateList.createFromXml(this, rp);
                rp.close();
            }
            catch (Exception e) {
                NotFoundException rnf = new NotFoundException("File " + file + " from color state list resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        } else {
            throw new NotFoundException("File " + file + " from drawable resource ID #0x" + Integer.toHexString(id2) + ": .xml extension required");
        }
        if (csl != null) {
            if (this.mPreloading) {
                mPreloadedColorStateLists.put(key, csl);
            } else {
                TypedValue typedValue = this.mTmpValue;
                synchronized (typedValue) {
                    this.mColorStateListCache.put(key, new WeakReference<ColorStateList>(csl));
                }
            }
        }
        return csl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColorStateList getCachedColorStateList(int key) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            WeakReference<ColorStateList> wr = this.mColorStateListCache.get(key);
            if (wr != null) {
                ColorStateList entry = (ColorStateList)wr.get();
                if (entry != null) {
                    return entry;
                }
                this.mColorStateListCache.delete(key);
            }
        }
        return null;
    }

    XmlResourceParser loadXmlResourceParser(int id2, String type) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue value = this.mTmpValue;
            this.getValue(id2, value, true);
            if (value.type == 3) {
                return this.loadXmlResourceParser(((Object)value.string).toString(), id2, value.assetCookie, type);
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XmlResourceParser loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws NotFoundException {
        if (id2 != 0) {
            try {
                int[] nArray = this.mCachedXmlBlockIds;
                synchronized (this.mCachedXmlBlockIds) {
                    int num = this.mCachedXmlBlockIds.length;
                    for (int i = 0; i < num; ++i) {
                        if (this.mCachedXmlBlockIds[i] != id2) continue;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return this.mCachedXmlBlocks[i].newParser();
                    }
                    XmlBlock block = this.mAssets.openXmlBlockAsset(assetCookie, file);
                    if (block != null) {
                        int pos = this.mLastCachedXmlBlockIndex + 1;
                        if (pos >= num) {
                            pos = 0;
                        }
                        this.mLastCachedXmlBlockIndex = pos;
                        XmlBlock oldBlock = this.mCachedXmlBlocks[pos];
                        if (oldBlock != null) {
                            oldBlock.close();
                        }
                        this.mCachedXmlBlockIds[pos] = id2;
                        this.mCachedXmlBlocks[pos] = block;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return block.newParser();
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                NotFoundException rnf = new NotFoundException("File " + file + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(e);
                throw rnf;
            }
        }
        {
            throw new NotFoundException("File " + file + " from xml type " + type + " resource ID #0x" + Integer.toHexString(id2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypedArray getCachedStyledAttributes(int len) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedArray attrs = this.mCachedStyledAttributes;
            if (attrs != null) {
                this.mCachedStyledAttributes = null;
                attrs.mLength = len;
                int fullLen = len * 6;
                if (attrs.mData.length >= fullLen) {
                    return attrs;
                }
                attrs.mData = new int[fullLen];
                attrs.mIndices = new int[1 + len];
                return attrs;
            }
            return new TypedArray(this, new int[len * 6], new int[1 + len], len);
        }
    }

    private Resources() {
        this.mAssets = AssetManager.getSystem();
        this.mConfiguration.setToDefaults();
        this.mMetrics.setToDefaults();
        this.updateConfiguration(null, null);
        this.mAssets.ensureStringBlocks();
        this.mCompatibilityInfo = CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
    }

    static {
        EMPTY_ARRAY = new LongSparseArray<Object>(0){

            @Override
            public void put(long k, Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void append(long k, Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public class Theme {
        private final AssetManager mAssets;
        private final int mTheme;

        public void applyStyle(int resid, boolean force) {
            AssetManager.applyThemeStyle(this.mTheme, resid, force);
        }

        public void setTo(Theme other) {
            AssetManager.copyTheme(this.mTheme, other.mTheme);
        }

        public TypedArray obtainStyledAttributes_Original(int[] attrs) {
            int len = attrs.length;
            TypedArray array2 = Resources.this.getCachedStyledAttributes(len);
            array2.mRsrcs = attrs;
            AssetManager.applyStyle(this.mTheme, 0, 0, 0, attrs, array2.mData, array2.mIndices);
            return array2;
        }

        @LayoutlibDelegate
        public TypedArray obtainStyledAttributes(int[] nArray) {
            return Resources_Theme_Delegate.obtainStyledAttributes(Resources.this, this, nArray);
        }

        public TypedArray obtainStyledAttributes_Original(int resid, int[] attrs) throws NotFoundException {
            int len = attrs.length;
            TypedArray array2 = Resources.this.getCachedStyledAttributes(len);
            array2.mRsrcs = attrs;
            AssetManager.applyStyle(this.mTheme, 0, resid, 0, attrs, array2.mData, array2.mIndices);
            return array2;
        }

        @LayoutlibDelegate
        public TypedArray obtainStyledAttributes(int n, int[] nArray) throws NotFoundException {
            return Resources_Theme_Delegate.obtainStyledAttributes(Resources.this, this, n, nArray);
        }

        public TypedArray obtainStyledAttributes_Original(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            int len = attrs.length;
            TypedArray array2 = Resources.this.getCachedStyledAttributes(len);
            XmlBlock.Parser parser = (XmlBlock.Parser)set;
            AssetManager.applyStyle(this.mTheme, defStyleAttr, defStyleRes, parser != null ? parser.mParseState : 0, attrs, array2.mData, array2.mIndices);
            array2.mRsrcs = attrs;
            array2.mXml = parser;
            return array2;
        }

        @LayoutlibDelegate
        public TypedArray obtainStyledAttributes(AttributeSet attributeSet, int[] nArray, int n, int n2) {
            return Resources_Theme_Delegate.obtainStyledAttributes(Resources.this, this, attributeSet, nArray, n, n2);
        }

        public boolean resolveAttribute_Original(int resid, TypedValue outValue, boolean resolveRefs) {
            boolean got = this.mAssets.getThemeValue(this.mTheme, resid, outValue, resolveRefs);
            return got;
        }

        @LayoutlibDelegate
        public boolean resolveAttribute(int n, TypedValue typedValue, boolean bl) {
            return Resources_Theme_Delegate.resolveAttribute(Resources.this, this, n, typedValue, bl);
        }

        public void dump(int priority, String tag, String prefix) {
            AssetManager.dumpTheme(this.mTheme, priority, tag, prefix);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.mAssets.releaseTheme(this.mTheme);
        }

        Theme() {
            this.mAssets = Resources.this.mAssets;
            this.mTheme = this.mAssets.createTheme();
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        public NotFoundException() {
        }

        public NotFoundException(String name) {
            super(name);
        }
    }
}

