/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.impl.FontLoader;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Typeface_Delegate {
    private static final String SYSTEM_FONTS = "/system/fonts/";
    private static final DelegateManager<Typeface_Delegate> sManager = new DelegateManager<Typeface_Delegate>(Typeface_Delegate.class);
    private static final String DEFAULT_FAMILY = "sans-serif";
    private static FontLoader sFontLoader;
    private static final List<Typeface_Delegate> sPostInitDelegate;
    private final String mFamily;
    private int mStyle;
    private List<Font> mFonts;

    public static synchronized void init(FontLoader fontLoader) {
        sFontLoader = fontLoader;
        for (Typeface_Delegate typeface_Delegate : sPostInitDelegate) {
            typeface_Delegate.init();
        }
        sPostInitDelegate.clear();
    }

    public static Typeface_Delegate getDelegate(int n) {
        return sManager.getDelegate(n);
    }

    public static List<Font> getFonts(Typeface typeface) {
        return Typeface_Delegate.getFonts(typeface.native_instance);
    }

    public static List<Font> getFonts(int n) {
        Typeface_Delegate typeface_Delegate = sManager.getDelegate(n);
        if (typeface_Delegate == null) {
            return null;
        }
        return typeface_Delegate.getFonts();
    }

    public List<Font> getFonts() {
        return this.mFonts;
    }

    @LayoutlibDelegate
    static synchronized int nativeCreate(String string2, int n) {
        if (string2 == null) {
            string2 = DEFAULT_FAMILY;
        }
        Typeface_Delegate typeface_Delegate = new Typeface_Delegate(string2, n);
        if (sFontLoader != null) {
            typeface_Delegate.init();
        } else {
            sPostInitDelegate.add(typeface_Delegate);
        }
        return sManager.addNewDelegate(typeface_Delegate);
    }

    @LayoutlibDelegate
    static synchronized int nativeCreateFromTypeface(int n, int n2) {
        Typeface_Delegate typeface_Delegate = sManager.getDelegate(n);
        if (typeface_Delegate == null) {
            return 0;
        }
        Typeface_Delegate typeface_Delegate2 = new Typeface_Delegate(typeface_Delegate.mFamily, n2);
        if (sFontLoader != null) {
            typeface_Delegate2.init();
        } else {
            sPostInitDelegate.add(typeface_Delegate2);
        }
        return sManager.addNewDelegate(typeface_Delegate2);
    }

    @LayoutlibDelegate
    static synchronized int nativeCreateFromAsset(AssetManager assetManager, String string2) {
        Bridge.getLog().fidelityWarning("unsupported", "Typeface.createFromAsset() is not supported.", null, null);
        return 0;
    }

    @LayoutlibDelegate
    static synchronized int nativeCreateFromFile(String string2) {
        if (string2.startsWith(SYSTEM_FONTS)) {
            String string3 = string2.substring(SYSTEM_FONTS.length());
            File file = new File(sFontLoader.getOsFontsLocation(), string3);
            try {
                Font font = Font.createFont(0, file);
                if (font != null) {
                    Typeface_Delegate typeface_Delegate = new Typeface_Delegate(font);
                    return sManager.addNewDelegate(typeface_Delegate);
                }
            }
            catch (Exception exception) {
                Bridge.getLog().fidelityWarning("broken", String.format("Unable to load font %1$s", string3), null, null);
            }
        } else {
            Bridge.getLog().fidelityWarning("unsupported", "Typeface.createFromFile() can only work with platform fonts located in /system/fonts/", null, null);
        }
        return Typeface_Delegate.nativeCreate(null, 0);
    }

    @LayoutlibDelegate
    static void nativeUnref(int n) {
        sManager.removeJavaReferenceFor(n);
    }

    @LayoutlibDelegate
    static int nativeGetStyle(int n) {
        Typeface_Delegate typeface_Delegate = sManager.getDelegate(n);
        if (typeface_Delegate == null) {
            return 0;
        }
        return typeface_Delegate.mStyle;
    }

    @LayoutlibDelegate
    static void setGammaForText(float f, float f2) {
    }

    private Typeface_Delegate(String string2, int n) {
        this.mFamily = string2;
        this.mStyle = n;
    }

    private Typeface_Delegate(Font font) {
        this.mFamily = font.getFamily();
        this.mStyle = 0;
        this.mFonts = sFontLoader.getFallbackFonts(this.mStyle);
        this.mFonts.add(0, font);
    }

    private void init() {
        this.mFonts = sFontLoader.getFont(this.mFamily, this.mStyle);
    }

    static {
        sPostInitDelegate = new ArrayList<Typeface_Delegate>();
    }
}

