/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import com.android.tools.layoutlib.create.OverrideMethod;

public class AudioSystem {
    public static final int STREAM_VOICE_CALL = 0;
    public static final int STREAM_SYSTEM = 1;
    public static final int STREAM_RING = 2;
    public static final int STREAM_MUSIC = 3;
    public static final int STREAM_ALARM = 4;
    public static final int STREAM_NOTIFICATION = 5;
    public static final int STREAM_BLUETOOTH_SCO = 6;
    public static final int STREAM_SYSTEM_ENFORCED = 7;
    public static final int STREAM_DTMF = 8;
    public static final int STREAM_TTS = 9;
    public static final int NUM_STREAMS = 5;
    private static final int NUM_STREAM_TYPES = 10;
    public static final int MODE_INVALID = -2;
    public static final int MODE_CURRENT = -1;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_RINGTONE = 1;
    public static final int MODE_IN_CALL = 2;
    public static final int MODE_IN_COMMUNICATION = 3;
    public static final int NUM_MODES = 4;
    @Deprecated
    public static final int ROUTE_EARPIECE = 1;
    @Deprecated
    public static final int ROUTE_SPEAKER = 2;
    @Deprecated
    public static final int ROUTE_BLUETOOTH = 4;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_SCO = 4;
    @Deprecated
    public static final int ROUTE_HEADSET = 8;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_A2DP = 16;
    @Deprecated
    public static final int ROUTE_ALL = -1;
    public static final int AUDIO_STATUS_OK = 0;
    public static final int AUDIO_STATUS_ERROR = 1;
    public static final int AUDIO_STATUS_SERVER_DIED = 100;
    private static ErrorCallback mErrorCallback;
    public static final int DEVICE_OUT_EARPIECE = 1;
    public static final int DEVICE_OUT_SPEAKER = 2;
    public static final int DEVICE_OUT_WIRED_HEADSET = 4;
    public static final int DEVICE_OUT_WIRED_HEADPHONE = 8;
    public static final int DEVICE_OUT_BLUETOOTH_SCO = 16;
    public static final int DEVICE_OUT_BLUETOOTH_SCO_HEADSET = 32;
    public static final int DEVICE_OUT_BLUETOOTH_SCO_CARKIT = 64;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP = 128;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    public static final int DEVICE_OUT_AUX_DIGITAL = 1024;
    public static final int DEVICE_OUT_ANLG_DOCK_HEADSET = 2048;
    public static final int DEVICE_OUT_DGTL_DOCK_HEADSET = 4096;
    public static final int DEVICE_OUT_DEFAULT = 32768;
    public static final int DEVICE_IN_COMMUNICATION = 65536;
    public static final int DEVICE_IN_AMBIENT = 131072;
    public static final int DEVICE_IN_BUILTIN_MIC1 = 262144;
    public static final int DEVICE_IN_BUILTIN_MIC2 = 524288;
    public static final int DEVICE_IN_MIC_ARRAY = 0x100000;
    public static final int DEVICE_IN_BLUETOOTH_SCO_HEADSET = 0x200000;
    public static final int DEVICE_IN_WIRED_HEADSET = 0x400000;
    public static final int DEVICE_IN_AUX_DIGITAL = 0x800000;
    public static final int DEVICE_IN_DEFAULT = Integer.MIN_VALUE;
    public static final int DEVICE_STATE_UNAVAILABLE = 0;
    public static final int DEVICE_STATE_AVAILABLE = 1;
    private static final int NUM_DEVICE_STATES = 1;
    public static final int PHONE_STATE_OFFCALL = 0;
    public static final int PHONE_STATE_RINGING = 1;
    public static final int PHONE_STATE_INCALL = 2;
    public static final int FORCE_NONE = 0;
    public static final int FORCE_SPEAKER = 1;
    public static final int FORCE_HEADPHONES = 2;
    public static final int FORCE_BT_SCO = 3;
    public static final int FORCE_BT_A2DP = 4;
    public static final int FORCE_WIRED_ACCESSORY = 5;
    public static final int FORCE_BT_CAR_DOCK = 6;
    public static final int FORCE_BT_DESK_DOCK = 7;
    public static final int FORCE_ANALOG_DOCK = 8;
    public static final int FORCE_DIGITAL_DOCK = 9;
    private static final int NUM_FORCE_CONFIG = 10;
    public static final int FORCE_DEFAULT = 0;
    public static final int FOR_COMMUNICATION = 0;
    public static final int FOR_MEDIA = 1;
    public static final int FOR_RECORD = 2;
    public static final int FOR_DOCK = 3;
    private static final int NUM_FORCE_USE = 4;

    public static int getNumStreamTypes() {
        return 10;
    }

    public static int muteMicrophone(boolean bl) {
        return OverrideMethod.invokeI("android.media.AudioSystem#muteMicrophone(Z)I", true, null);
    }

    public static boolean isMicrophoneMuted() {
        return OverrideMethod.invokeI("android.media.AudioSystem#isMicrophoneMuted()Z", true, null) != 0;
    }

    public static boolean isStreamActive(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#isStreamActive(II)Z", true, null) != 0;
    }

    public static int setParameters(String string2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setParameters(Ljava/lang/String;)I", true, null);
    }

    public static String getParameters(String string2) {
        return (String)OverrideMethod.invokeA("android.media.AudioSystem#getParameters(Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setErrorCallback(ErrorCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            mErrorCallback = cb;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            AudioSystem.isMicrophoneMuted();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void errorCallbackFromNative(int error) {
        ErrorCallback errorCallback = null;
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            if (mErrorCallback != null) {
                errorCallback = mErrorCallback;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (errorCallback != null) {
                errorCallback.onError(error);
            }
            return;
        }
    }

    public static int setDeviceConnectionState(int n, int n2, String string2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setDeviceConnectionState(IILjava/lang/String;)I", true, null);
    }

    public static int getDeviceConnectionState(int n, String string2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getDeviceConnectionState(ILjava/lang/String;)I", true, null);
    }

    public static int setPhoneState(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setPhoneState(I)I", true, null);
    }

    public static int setRingerMode(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setRingerMode(II)I", true, null);
    }

    public static int setForceUse(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setForceUse(II)I", true, null);
    }

    public static int getForceUse(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getForceUse(I)I", true, null);
    }

    public static int initStreamVolume(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.media.AudioSystem#initStreamVolume(III)I", true, null);
    }

    public static int setStreamVolumeIndex(int n, int n2) {
        return OverrideMethod.invokeI("android.media.AudioSystem#setStreamVolumeIndex(II)I", true, null);
    }

    public static int getStreamVolumeIndex(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getStreamVolumeIndex(I)I", true, null);
    }

    public static int getDevicesForStream(int n) {
        return OverrideMethod.invokeI("android.media.AudioSystem#getDevicesForStream(I)I", true, null);
    }

    public static interface ErrorCallback {
        public void onError(int var1);
    }
}

