/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Log;
import java.util.HashMap;

public class LatencyTimer {
    final String TAG = "LatencyTimer";
    final int mSampleSize;
    final int mScaleFactor;
    volatile HashMap<String, long[]> store = new HashMap();

    public LatencyTimer(int sampleSize, int scaleFactor) {
        if (scaleFactor == 0) {
            scaleFactor = 1;
        }
        this.mScaleFactor = scaleFactor;
        this.mSampleSize = sampleSize;
    }

    public void sample(String tag, long delta) {
        long[] array2 = this.getArray(tag);
        int n = this.mSampleSize;
        long l = array2[n];
        array2[n] = l + 1L;
        int index = (int)l;
        array2[index] = delta;
        if (array2[this.mSampleSize] == (long)this.mSampleSize) {
            long totalDelta = 0L;
            for (long d : array2) {
                totalDelta += d / (long)this.mScaleFactor;
            }
            array2[this.mSampleSize] = 0L;
            Log.i("LatencyTimer", tag + " average = " + totalDelta / (long)this.mSampleSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] getArray(String tag) {
        long[] data = this.store.get(tag);
        if (data == null) {
            HashMap<String, long[]> hashMap = this.store;
            synchronized (hashMap) {
                data = this.store.get(tag);
                if (data == null) {
                    data = new long[this.mSampleSize + 1];
                    this.store.put(tag, data);
                    data[this.mSampleSize] = 0L;
                }
            }
        }
        return data;
    }
}

