/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import android.util.Log;
import android.webkit.CacheManager;
import android.webkit.CookieManager;
import android.webkit.JniUtil;
import android.webkit.WebTextView;
import android.webkit.WebViewWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebViewDatabase {
    private static final String DATABASE_FILE = "webview.db";
    private static final String CACHE_DATABASE_FILE = "webviewCache.db";
    protected static final String LOGTAG = "webviewdatabase";
    private static final int DATABASE_VERSION = 11;
    private static final int CACHE_DATABASE_VERSION = 4;
    private static WebViewDatabase mInstance = null;
    private static SQLiteDatabase mDatabase = null;
    private static SQLiteDatabase mCacheDatabase = null;
    private final Object mCookieLock = new Object();
    private final Object mPasswordLock = new Object();
    private final Object mFormLock = new Object();
    private final Object mHttpAuthLock = new Object();
    private static final String[] mTableNames = new String[]{"cookies", "password", "formurl", "formdata", "httpauth"};
    private static final int TABLE_COOKIES_ID = 0;
    private static final int TABLE_PASSWORD_ID = 1;
    private static final int TABLE_FORMURL_ID = 2;
    private static final int TABLE_FORMDATA_ID = 3;
    private static final int TABLE_HTTPAUTH_ID = 4;
    private static final String ID_COL = "_id";
    private static final String[] ID_PROJECTION = new String[]{"_id"};
    private static final String COOKIES_NAME_COL = "name";
    private static final String COOKIES_VALUE_COL = "value";
    private static final String COOKIES_DOMAIN_COL = "domain";
    private static final String COOKIES_PATH_COL = "path";
    private static final String COOKIES_EXPIRES_COL = "expires";
    private static final String COOKIES_SECURE_COL = "secure";
    private static final String CACHE_URL_COL = "url";
    private static final String CACHE_FILE_PATH_COL = "filepath";
    private static final String CACHE_LAST_MODIFY_COL = "lastmodify";
    private static final String CACHE_ETAG_COL = "etag";
    private static final String CACHE_EXPIRES_COL = "expires";
    private static final String CACHE_EXPIRES_STRING_COL = "expiresstring";
    private static final String CACHE_MIMETYPE_COL = "mimetype";
    private static final String CACHE_ENCODING_COL = "encoding";
    private static final String CACHE_HTTP_STATUS_COL = "httpstatus";
    private static final String CACHE_LOCATION_COL = "location";
    private static final String CACHE_CONTENTLENGTH_COL = "contentlength";
    private static final String CACHE_CONTENTDISPOSITION_COL = "contentdisposition";
    private static final String CACHE_CROSSDOMAIN_COL = "crossdomain";
    private static final String PASSWORD_HOST_COL = "host";
    private static final String PASSWORD_USERNAME_COL = "username";
    private static final String PASSWORD_PASSWORD_COL = "password";
    private static final String FORMURL_URL_COL = "url";
    private static final String FORMDATA_URLID_COL = "urlid";
    private static final String FORMDATA_NAME_COL = "name";
    private static final String FORMDATA_VALUE_COL = "value";
    private static final String HTTPAUTH_HOST_COL = "host";
    private static final String HTTPAUTH_REALM_COL = "realm";
    private static final String HTTPAUTH_USERNAME_COL = "username";
    private static final String HTTPAUTH_PASSWORD_COL = "password";
    private static DatabaseUtils.InsertHelper mCacheInserter;
    private static int mCacheUrlColIndex;
    private static int mCacheFilePathColIndex;
    private static int mCacheLastModifyColIndex;
    private static int mCacheETagColIndex;
    private static int mCacheExpiresColIndex;
    private static int mCacheExpiresStringColIndex;
    private static int mCacheMimeTypeColIndex;
    private static int mCacheEncodingColIndex;
    private static int mCacheHttpStatusColIndex;
    private static int mCacheLocationColIndex;
    private static int mCacheContentLengthColIndex;
    private static int mCacheContentDispositionColIndex;
    private static int mCacheCrossDomainColIndex;
    private static int mCacheTransactionRefcount;
    private boolean mInitialized = false;

    private WebViewDatabase(final Context context) {
        new Thread(){

            public void run() {
                WebViewDatabase.this.init(context);
            }
        }.start();
    }

    public static synchronized WebViewDatabase getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new WebViewDatabase(context);
        }
        return mInstance;
    }

    private synchronized void init(Context context) {
        if (this.mInitialized) {
            return;
        }
        this.initDatabase(context);
        if (JniUtil.useChromiumHttpStack()) {
            context.deleteDatabase(CACHE_DATABASE_FILE);
        } else {
            this.initCacheDatabase(context);
        }
        this.mInitialized = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabase(Context context) {
        block7: {
            try {
                mDatabase = context.openOrCreateDatabase(DATABASE_FILE, 0, null);
            }
            catch (SQLiteException e) {
                if (!context.deleteDatabase(DATABASE_FILE)) break block7;
                mDatabase = context.openOrCreateDatabase(DATABASE_FILE, 0, null);
            }
        }
        mDatabase.enableWriteAheadLogging();
        if (mDatabase == null) {
            this.mInitialized = true;
            this.notify();
            return;
        }
        if (mDatabase.getVersion() != 11) {
            mDatabase.beginTransactionNonExclusive();
            try {
                WebViewDatabase.upgradeDatabase();
                mDatabase.setTransactionSuccessful();
            }
            finally {
                mDatabase.endTransaction();
            }
        }
        mDatabase.setLockingEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCacheDatabase(Context context) {
        block8: {
            assert (!JniUtil.useChromiumHttpStack());
            try {
                mCacheDatabase = context.openOrCreateDatabase(CACHE_DATABASE_FILE, 0, null);
            }
            catch (SQLiteException e) {
                if (!context.deleteDatabase(CACHE_DATABASE_FILE)) break block8;
                mCacheDatabase = context.openOrCreateDatabase(CACHE_DATABASE_FILE, 0, null);
            }
        }
        mCacheDatabase.enableWriteAheadLogging();
        if (mCacheDatabase == null) {
            this.mInitialized = true;
            this.notify();
            return;
        }
        if (mCacheDatabase.getVersion() != 4) {
            mCacheDatabase.beginTransactionNonExclusive();
            try {
                WebViewDatabase.upgradeCacheDatabase();
                WebViewDatabase.bootstrapCacheDatabase();
                mCacheDatabase.setTransactionSuccessful();
            }
            finally {
                mCacheDatabase.endTransaction();
            }
            CacheManager.removeAllCacheFiles();
        }
        mCacheDatabase.execSQL("PRAGMA read_uncommitted = true;");
        mCacheDatabase.setLockingEnabled(false);
        mCacheInserter = new DatabaseUtils.InsertHelper(mCacheDatabase, "cache");
        mCacheUrlColIndex = mCacheInserter.getColumnIndex("url");
        mCacheFilePathColIndex = mCacheInserter.getColumnIndex(CACHE_FILE_PATH_COL);
        mCacheLastModifyColIndex = mCacheInserter.getColumnIndex(CACHE_LAST_MODIFY_COL);
        mCacheETagColIndex = mCacheInserter.getColumnIndex(CACHE_ETAG_COL);
        mCacheExpiresColIndex = mCacheInserter.getColumnIndex("expires");
        mCacheExpiresStringColIndex = mCacheInserter.getColumnIndex(CACHE_EXPIRES_STRING_COL);
        mCacheMimeTypeColIndex = mCacheInserter.getColumnIndex(CACHE_MIMETYPE_COL);
        mCacheEncodingColIndex = mCacheInserter.getColumnIndex(CACHE_ENCODING_COL);
        mCacheHttpStatusColIndex = mCacheInserter.getColumnIndex(CACHE_HTTP_STATUS_COL);
        mCacheLocationColIndex = mCacheInserter.getColumnIndex(CACHE_LOCATION_COL);
        mCacheContentLengthColIndex = mCacheInserter.getColumnIndex(CACHE_CONTENTLENGTH_COL);
        mCacheContentDispositionColIndex = mCacheInserter.getColumnIndex(CACHE_CONTENTDISPOSITION_COL);
        mCacheCrossDomainColIndex = mCacheInserter.getColumnIndex(CACHE_CROSSDOMAIN_COL);
    }

    private static void upgradeDatabase() {
        WebViewDatabase.upgradeDatabaseToV10();
        WebViewDatabase.upgradeDatabaseFromV10ToV11();
        mDatabase.setVersion(11);
    }

    private static void upgradeDatabaseFromV10ToV11() {
        int oldVersion = mDatabase.getVersion();
        if (oldVersion >= 11) {
            return;
        }
        if (JniUtil.useChromiumHttpStack()) {
            mDatabase.execSQL("DROP TABLE IF EXISTS " + mTableNames[0]);
            mDatabase.execSQL("DROP TABLE IF EXISTS cache");
        }
        Cursor c = mDatabase.query(mTableNames[2], null, null, null, null, null, null);
        while (c.moveToNext()) {
            String urlId = Long.toString(c.getLong(c.getColumnIndex(ID_COL)));
            String url = c.getString(c.getColumnIndex("url"));
            ContentValues cv = new ContentValues(1);
            cv.put("url", WebTextView.urlForAutoCompleteData(url));
            mDatabase.update(mTableNames[2], cv, "_id=?", new String[]{urlId});
        }
        c.close();
    }

    private static void upgradeDatabaseToV10() {
        int oldVersion = mDatabase.getVersion();
        if (oldVersion >= 10) {
            return;
        }
        if (oldVersion != 0) {
            Log.i(LOGTAG, "Upgrading database from version " + oldVersion + " to " + 11 + ", which will destroy old data");
        }
        if (9 == oldVersion) {
            mDatabase.execSQL("DROP TABLE IF EXISTS " + mTableNames[4]);
            mDatabase.execSQL("CREATE TABLE " + mTableNames[4] + " (" + ID_COL + " INTEGER PRIMARY KEY, " + "host" + " TEXT, " + HTTPAUTH_REALM_COL + " TEXT, " + "username" + " TEXT, " + "password" + " TEXT," + " UNIQUE (" + "host" + ", " + HTTPAUTH_REALM_COL + ") ON CONFLICT REPLACE);");
            return;
        }
        mDatabase.execSQL("DROP TABLE IF EXISTS " + mTableNames[0]);
        mDatabase.execSQL("DROP TABLE IF EXISTS cache");
        mDatabase.execSQL("DROP TABLE IF EXISTS " + mTableNames[2]);
        mDatabase.execSQL("DROP TABLE IF EXISTS " + mTableNames[3]);
        mDatabase.execSQL("DROP TABLE IF EXISTS " + mTableNames[4]);
        mDatabase.execSQL("DROP TABLE IF EXISTS " + mTableNames[1]);
        mDatabase.execSQL("CREATE TABLE " + mTableNames[0] + " (" + ID_COL + " INTEGER PRIMARY KEY, " + "name" + " TEXT, " + "value" + " TEXT, " + COOKIES_DOMAIN_COL + " TEXT, " + COOKIES_PATH_COL + " TEXT, " + "expires" + " INTEGER, " + COOKIES_SECURE_COL + " INTEGER" + ");");
        mDatabase.execSQL("CREATE INDEX cookiesIndex ON " + mTableNames[0] + " (path)");
        mDatabase.execSQL("CREATE TABLE " + mTableNames[2] + " (" + ID_COL + " INTEGER PRIMARY KEY, " + "url" + " TEXT" + ");");
        mDatabase.execSQL("CREATE TABLE " + mTableNames[3] + " (" + ID_COL + " INTEGER PRIMARY KEY, " + FORMDATA_URLID_COL + " INTEGER, " + "name" + " TEXT, " + "value" + " TEXT," + " UNIQUE (" + FORMDATA_URLID_COL + ", " + "name" + ", " + "value" + ") ON CONFLICT IGNORE);");
        mDatabase.execSQL("CREATE TABLE " + mTableNames[4] + " (" + ID_COL + " INTEGER PRIMARY KEY, " + "host" + " TEXT, " + HTTPAUTH_REALM_COL + " TEXT, " + "username" + " TEXT, " + "password" + " TEXT," + " UNIQUE (" + "host" + ", " + HTTPAUTH_REALM_COL + ") ON CONFLICT REPLACE);");
        mDatabase.execSQL("CREATE TABLE " + mTableNames[1] + " (" + ID_COL + " INTEGER PRIMARY KEY, " + "host" + " TEXT, " + "username" + " TEXT, " + "password" + " TEXT," + " UNIQUE (" + "host" + ", " + "username" + ") ON CONFLICT REPLACE);");
    }

    private static void upgradeCacheDatabase() {
        int oldVersion = mCacheDatabase.getVersion();
        if (oldVersion != 0) {
            Log.i(LOGTAG, "Upgrading cache database from version " + oldVersion + " to " + 4 + ", which will destroy all old data");
        }
        mCacheDatabase.execSQL("DROP TABLE IF EXISTS cache");
        mCacheDatabase.setVersion(4);
    }

    private static void bootstrapCacheDatabase() {
        if (mCacheDatabase != null) {
            mCacheDatabase.execSQL("CREATE TABLE cache (_id INTEGER PRIMARY KEY, url TEXT, filepath TEXT, lastmodify TEXT, etag TEXT, expires INTEGER, expiresstring TEXT, mimetype TEXT, encoding TEXT,httpstatus INTEGER, location TEXT, contentlength INTEGER, contentdisposition TEXT, crossdomain TEXT, UNIQUE (url) ON CONFLICT REPLACE);");
            mCacheDatabase.execSQL("CREATE INDEX cacheUrlIndex ON cache (url)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInitialized() {
        WebViewDatabase webViewDatabase = this;
        synchronized (webViewDatabase) {
            while (!this.mInitialized) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e(LOGTAG, "Caught exception while checking initialization");
                    Log.e(LOGTAG, Log.getStackTraceString(e));
                }
            }
        }
        return mDatabase != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasEntries(int tableId) {
        if (!this.checkInitialized()) {
            return false;
        }
        Cursor cursor = null;
        boolean ret = false;
        try {
            cursor = mDatabase.query(mTableNames[tableId], ID_PROJECTION, null, null, null, null, null);
            ret = cursor.moveToFirst();
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "hasEntries", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<CookieManager.Cookie> getCookiesForDomain(String domain) {
        ArrayList<CookieManager.Cookie> list = new ArrayList<CookieManager.Cookie>();
        if (domain == null || !this.checkInitialized()) {
            return list;
        }
        Object object = this.mCookieLock;
        synchronized (object) {
            String[] columns = new String[]{ID_COL, COOKIES_DOMAIN_COL, COOKIES_PATH_COL, "name", "value", "expires", COOKIES_SECURE_COL};
            String selection = "(domain GLOB '*' || ?)";
            Cursor cursor = null;
            try {
                cursor = mDatabase.query(mTableNames[0], columns, "(domain GLOB '*' || ?)", new String[]{domain}, null, null, null);
                if (cursor.moveToFirst()) {
                    int domainCol = cursor.getColumnIndex(COOKIES_DOMAIN_COL);
                    int pathCol = cursor.getColumnIndex(COOKIES_PATH_COL);
                    int nameCol = cursor.getColumnIndex("name");
                    int valueCol = cursor.getColumnIndex("value");
                    int expiresCol = cursor.getColumnIndex("expires");
                    int secureCol = cursor.getColumnIndex(COOKIES_SECURE_COL);
                    do {
                        CookieManager.Cookie cookie = new CookieManager.Cookie();
                        cookie.domain = cursor.getString(domainCol);
                        cookie.path = cursor.getString(pathCol);
                        cookie.name = cursor.getString(nameCol);
                        cookie.value = cursor.getString(valueCol);
                        cookie.expires = cursor.isNull(expiresCol) ? -1L : cursor.getLong(expiresCol);
                        cookie.secure = cursor.getShort(secureCol) != 0;
                        cookie.mode = 1;
                        list.add(cookie);
                    } while (cursor.moveToNext());
                }
            }
            catch (IllegalStateException e) {
                Log.e(LOGTAG, "getCookiesForDomain", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteCookies(String domain, String path, String name) {
        if (domain == null || !this.checkInitialized()) {
            return;
        }
        Object object = this.mCookieLock;
        synchronized (object) {
            String where = "(domain == ?) AND (path == ?) AND (name == ?)";
            mDatabase.delete(mTableNames[0], "(domain == ?) AND (path == ?) AND (name == ?)", new String[]{domain, path, name});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCookie(CookieManager.Cookie cookie) {
        if (cookie.domain == null || cookie.path == null || cookie.name == null || !this.checkInitialized()) {
            return;
        }
        Object object = this.mCookieLock;
        synchronized (object) {
            ContentValues cookieVal = new ContentValues();
            cookieVal.put(COOKIES_DOMAIN_COL, cookie.domain);
            cookieVal.put(COOKIES_PATH_COL, cookie.path);
            cookieVal.put("name", cookie.name);
            cookieVal.put("value", cookie.value);
            if (cookie.expires != -1L) {
                cookieVal.put("expires", cookie.expires);
            }
            cookieVal.put(COOKIES_SECURE_COL, cookie.secure);
            mDatabase.insert(mTableNames[0], null, cookieVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasCookies() {
        Object object = this.mCookieLock;
        synchronized (object) {
            return this.hasEntries(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCookies() {
        if (!this.checkInitialized()) {
            return;
        }
        Object object = this.mCookieLock;
        synchronized (object) {
            mDatabase.delete(mTableNames[0], null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSessionCookies() {
        if (!this.checkInitialized()) {
            return;
        }
        String sessionExpired = "expires ISNULL";
        Object object = this.mCookieLock;
        synchronized (object) {
            mDatabase.delete(mTableNames[0], "expires ISNULL", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearExpiredCookies(long now) {
        if (!this.checkInitialized()) {
            return;
        }
        String expires = "expires <= ?";
        Object object = this.mCookieLock;
        synchronized (object) {
            mDatabase.delete(mTableNames[0], "expires <= ?", new String[]{Long.toString(now)});
        }
    }

    boolean startCacheTransaction() {
        if (++mCacheTransactionRefcount == 1) {
            if (!Thread.currentThread().equals(WebViewWorker.getHandler().getLooper().getThread())) {
                Log.w(LOGTAG, "startCacheTransaction should be called from WebViewWorkerThread instead of from " + Thread.currentThread().getName());
            }
            mCacheDatabase.beginTransactionNonExclusive();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endCacheTransaction() {
        if (--mCacheTransactionRefcount == 0) {
            if (!Thread.currentThread().equals(WebViewWorker.getHandler().getLooper().getThread())) {
                Log.w(LOGTAG, "endCacheTransaction should be called from WebViewWorkerThread instead of from " + Thread.currentThread().getName());
            }
            try {
                mCacheDatabase.setTransactionSuccessful();
            }
            finally {
                mCacheDatabase.endTransaction();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheManager.CacheResult getCache(String url) {
        assert (!JniUtil.useChromiumHttpStack());
        if (url == null || !this.checkInitialized()) {
            return null;
        }
        Cursor cursor = null;
        String query = "SELECT filepath, lastmodify, etag, expires, expiresstring, mimetype, encoding, httpstatus, location, contentlength, contentdisposition, crossdomain FROM cache WHERE url = ?";
        try {
            cursor = mCacheDatabase.rawQuery("SELECT filepath, lastmodify, etag, expires, expiresstring, mimetype, encoding, httpstatus, location, contentlength, contentdisposition, crossdomain FROM cache WHERE url = ?", new String[]{url});
            if (cursor.moveToFirst()) {
                CacheManager.CacheResult ret = new CacheManager.CacheResult();
                ret.localPath = cursor.getString(0);
                ret.lastModified = cursor.getString(1);
                ret.etag = cursor.getString(2);
                ret.expires = cursor.getLong(3);
                ret.expiresString = cursor.getString(4);
                ret.mimeType = cursor.getString(5);
                ret.encoding = cursor.getString(6);
                ret.httpStatusCode = cursor.getInt(7);
                ret.location = cursor.getString(8);
                ret.contentLength = cursor.getLong(9);
                ret.contentdisposition = cursor.getString(10);
                ret.crossDomain = cursor.getString(11);
                CacheManager.CacheResult cacheResult = ret;
                return cacheResult;
            }
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "getCache", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    void removeCache(String url) {
        assert (!JniUtil.useChromiumHttpStack());
        if (url == null || !this.checkInitialized()) {
            return;
        }
        mCacheDatabase.execSQL("DELETE FROM cache WHERE url = ?", new String[]{url});
    }

    void addCache(String url, CacheManager.CacheResult c) {
        assert (!JniUtil.useChromiumHttpStack());
        if (url == null || !this.checkInitialized()) {
            return;
        }
        mCacheInserter.prepareForInsert();
        mCacheInserter.bind(mCacheUrlColIndex, url);
        mCacheInserter.bind(mCacheFilePathColIndex, c.localPath);
        mCacheInserter.bind(mCacheLastModifyColIndex, c.lastModified);
        mCacheInserter.bind(mCacheETagColIndex, c.etag);
        mCacheInserter.bind(mCacheExpiresColIndex, c.expires);
        mCacheInserter.bind(mCacheExpiresStringColIndex, c.expiresString);
        mCacheInserter.bind(mCacheMimeTypeColIndex, c.mimeType);
        mCacheInserter.bind(mCacheEncodingColIndex, c.encoding);
        mCacheInserter.bind(mCacheHttpStatusColIndex, c.httpStatusCode);
        mCacheInserter.bind(mCacheLocationColIndex, c.location);
        mCacheInserter.bind(mCacheContentLengthColIndex, c.contentLength);
        mCacheInserter.bind(mCacheContentDispositionColIndex, c.contentdisposition);
        mCacheInserter.bind(mCacheCrossDomainColIndex, c.crossDomain);
        mCacheInserter.execute();
    }

    void clearCache() {
        if (!this.checkInitialized()) {
            return;
        }
        mCacheDatabase.delete("cache", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasCache() {
        if (!this.checkInitialized()) {
            return false;
        }
        Cursor cursor = null;
        boolean ret = false;
        try {
            cursor = mCacheDatabase.query("cache", ID_PROJECTION, null, null, null, null, null);
            ret = cursor.moveToFirst();
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "hasCache", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCacheTotalSize() {
        if (mCacheDatabase == null) {
            return 0L;
        }
        long size = 0L;
        Cursor cursor = null;
        String query = "SELECT SUM(contentlength) as sum FROM cache";
        try {
            cursor = mCacheDatabase.rawQuery("SELECT SUM(contentlength) as sum FROM cache", null);
            if (cursor.moveToFirst()) {
                size = cursor.getLong(0);
            }
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "getCacheTotalSize", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> trimCache(long amount) {
        ArrayList<String> pathList;
        block15: {
            pathList = new ArrayList<String>(100);
            Cursor cursor = null;
            String query = "SELECT contentlength, filepath FROM cache ORDER BY expires ASC";
            try {
                cursor = mCacheDatabase.rawQuery("SELECT contentlength, filepath FROM cache ORDER BY expires ASC", null);
                if (!cursor.moveToFirst()) break block15;
                int batchSize = 100;
                StringBuilder pathStr = new StringBuilder(20 + 16 * batchSize);
                pathStr.append("DELETE FROM cache WHERE filepath IN (?");
                for (int i = 1; i < batchSize; ++i) {
                    pathStr.append(", ?");
                }
                pathStr.append(")");
                SQLiteStatement statement = null;
                try {
                    statement = mCacheDatabase.compileStatement(pathStr.toString());
                    int index = 1;
                    do {
                        long length;
                        if ((length = cursor.getLong(0)) == 0L) continue;
                        amount -= length;
                        String filePath = cursor.getString(1);
                        statement.bindString(index, filePath);
                        pathList.add(filePath);
                        if (index++ != batchSize) continue;
                        statement.execute();
                        statement.clearBindings();
                        index = 1;
                    } while (cursor.moveToNext() && amount > 0L);
                    if (index > 1) {
                        statement.execute();
                    }
                }
                catch (IllegalStateException e) {
                    Log.e(LOGTAG, "trimCache SQLiteStatement", e);
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (IllegalStateException e) {
                Log.e(LOGTAG, "trimCache Cursor", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        return pathList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getAllCacheFileNames() {
        ArrayList<String> pathList = null;
        Cursor cursor = null;
        try {
            cursor = mCacheDatabase.rawQuery("SELECT filepath FROM cache", null);
            if (cursor != null && cursor.moveToFirst()) {
                pathList = new ArrayList<String>(cursor.getCount());
                do {
                    pathList.add(cursor.getString(0));
                } while (cursor.moveToNext());
            }
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "getAllCacheFileNames", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return pathList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUsernamePassword(String schemePlusHost, String username, String password) {
        if (schemePlusHost == null || !this.checkInitialized()) {
            return;
        }
        Object object = this.mPasswordLock;
        synchronized (object) {
            ContentValues c = new ContentValues();
            c.put("host", schemePlusHost);
            c.put("username", username);
            c.put("password", password);
            mDatabase.insert(mTableNames[1], "host", c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getUsernamePassword(String schemePlusHost) {
        if (schemePlusHost == null || !this.checkInitialized()) {
            return null;
        }
        String[] columns = new String[]{"username", "password"};
        String selection = "(host == ?)";
        Object object = this.mPasswordLock;
        synchronized (object) {
            String[] ret = null;
            Cursor cursor = null;
            try {
                cursor = mDatabase.query(mTableNames[1], columns, "(host == ?)", new String[]{schemePlusHost}, null, null, null);
                if (cursor.moveToFirst()) {
                    ret = new String[]{cursor.getString(cursor.getColumnIndex("username")), cursor.getString(cursor.getColumnIndex("password"))};
                }
            }
            catch (IllegalStateException e) {
                Log.e(LOGTAG, "getUsernamePassword", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUsernamePassword() {
        Object object = this.mPasswordLock;
        synchronized (object) {
            return this.hasEntries(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUsernamePassword() {
        if (!this.checkInitialized()) {
            return;
        }
        Object object = this.mPasswordLock;
        synchronized (object) {
            mDatabase.delete(mTableNames[1], null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHttpAuthUsernamePassword(String host, String realm, String username, String password) {
        if (host == null || realm == null || !this.checkInitialized()) {
            return;
        }
        Object object = this.mHttpAuthLock;
        synchronized (object) {
            ContentValues c = new ContentValues();
            c.put("host", host);
            c.put(HTTPAUTH_REALM_COL, realm);
            c.put("username", username);
            c.put("password", password);
            mDatabase.insert(mTableNames[4], "host", c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getHttpAuthUsernamePassword(String host, String realm) {
        if (host == null || realm == null || !this.checkInitialized()) {
            return null;
        }
        String[] columns = new String[]{"username", "password"};
        String selection = "(host == ?) AND (realm == ?)";
        Object object = this.mHttpAuthLock;
        synchronized (object) {
            String[] ret = null;
            Cursor cursor = null;
            try {
                cursor = mDatabase.query(mTableNames[4], columns, "(host == ?) AND (realm == ?)", new String[]{host, realm}, null, null, null);
                if (cursor.moveToFirst()) {
                    ret = new String[]{cursor.getString(cursor.getColumnIndex("username")), cursor.getString(cursor.getColumnIndex("password"))};
                }
            }
            catch (IllegalStateException e) {
                Log.e(LOGTAG, "getHttpAuthUsernamePassword", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHttpAuthUsernamePassword() {
        Object object = this.mHttpAuthLock;
        synchronized (object) {
            return this.hasEntries(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHttpAuthUsernamePassword() {
        if (!this.checkInitialized()) {
            return;
        }
        Object object = this.mHttpAuthLock;
        synchronized (object) {
            mDatabase.delete(mTableNames[4], null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFormData(String url, HashMap<String, String> formdata) {
        if (url == null || formdata == null || !this.checkInitialized()) {
            return;
        }
        String selection = "(url == ?)";
        Object object = this.mFormLock;
        synchronized (object) {
            long urlid = -1L;
            Cursor cursor = null;
            try {
                cursor = mDatabase.query(mTableNames[2], ID_PROJECTION, "(url == ?)", new String[]{url}, null, null, null);
                if (cursor.moveToFirst()) {
                    urlid = cursor.getLong(cursor.getColumnIndex(ID_COL));
                } else {
                    ContentValues c = new ContentValues();
                    c.put("url", url);
                    urlid = mDatabase.insert(mTableNames[2], null, c);
                }
            }
            catch (IllegalStateException e) {
                Log.e(LOGTAG, "setFormData", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            if (urlid >= 0L) {
                Set<Map.Entry<String, String>> set = formdata.entrySet();
                Iterator<Map.Entry<String, String>> iter = set.iterator();
                ContentValues map = new ContentValues();
                map.put(FORMDATA_URLID_COL, urlid);
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    map.put("name", entry.getKey());
                    map.put("value", entry.getValue());
                    mDatabase.insert(mTableNames[3], null, map);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<String> getFormData(String url, String name) {
        ArrayList<String> values = new ArrayList<String>();
        if (url == null || name == null || !this.checkInitialized()) {
            return values;
        }
        String urlSelection = "(url == ?)";
        String dataSelection = "(urlid == ?) AND (name == ?)";
        Object object = this.mFormLock;
        synchronized (object) {
            Cursor cursor = null;
            try {
                cursor = mDatabase.query(mTableNames[2], ID_PROJECTION, "(url == ?)", new String[]{url}, null, null, null);
                while (cursor.moveToNext()) {
                    long urlid = cursor.getLong(cursor.getColumnIndex(ID_COL));
                    Cursor dataCursor = null;
                    try {
                        dataCursor = mDatabase.query(mTableNames[3], new String[]{ID_COL, "value"}, "(urlid == ?) AND (name == ?)", new String[]{Long.toString(urlid), name}, null, null, null);
                        if (!dataCursor.moveToFirst()) continue;
                        int valueCol = dataCursor.getColumnIndex("value");
                        do {
                            values.add(dataCursor.getString(valueCol));
                        } while (dataCursor.moveToNext());
                    }
                    catch (IllegalStateException e) {
                        Log.e(LOGTAG, "getFormData dataCursor", e);
                    }
                    finally {
                        if (dataCursor == null) continue;
                        dataCursor.close();
                    }
                }
            }
            catch (IllegalStateException e) {
                Log.e(LOGTAG, "getFormData cursor", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFormData() {
        Object object = this.mFormLock;
        synchronized (object) {
            return this.hasEntries(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFormData() {
        if (!this.checkInitialized()) {
            return;
        }
        Object object = this.mFormLock;
        synchronized (object) {
            mDatabase.delete(mTableNames[2], null, null);
            mDatabase.delete(mTableNames[3], null, null);
        }
    }
}

